#include "Xcos.hxx"
/* Generated by GIWS (version 1.2.1) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_xcos {

// Returns the current env

JNIEnv * Xcos::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Xcos::~Xcos() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
Xcos::Xcos(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidxcosID=NULL; 
voidxcosjstringID=NULL; 
voidwarnCellByUIDjstringjstringID=NULL; 
voidcloseXcosFromScilabID=NULL; 
jintxcosDiagramToHDF5jstringjstringjbooleanID=NULL; 
voidxcosDiagramOpenjstringjbooleanID=NULL; 
voidxcosDiagramClosejstringID=NULL; 


}

Xcos::Xcos(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidxcosID=NULL; 
voidxcosjstringID=NULL; 
voidwarnCellByUIDjstringjstringID=NULL; 
voidcloseXcosFromScilabID=NULL; 
jintxcosDiagramToHDF5jstringjstringjbooleanID=NULL; 
voidxcosDiagramOpenjstringjbooleanID=NULL; 
voidxcosDiagramClosejstringID=NULL; 


}

// Generic methods

void Xcos::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}

void Xcos::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}
// Method(s)

void Xcos::xcos (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosID = curEnv->GetStaticMethodID(cls, "xcos", "()V" ) ;
if (voidxcosID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcos");
}

                         curEnv->CallStaticVoidMethod(cls, voidxcosID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcos (JavaVM * jvm_, char * fileName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosjstringID = curEnv->GetStaticMethodID(cls, "xcos", "(Ljava/lang/String;)V" ) ;
if (voidxcosjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcos");
}

jstring fileName_ = curEnv->NewStringUTF( fileName );

                         curEnv->CallStaticVoidMethod(cls, voidxcosjstringID ,fileName_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::warnCellByUID (JavaVM * jvm_, char * UID, char * message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidwarnCellByUIDjstringjstringID = curEnv->GetStaticMethodID(cls, "warnCellByUID", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidwarnCellByUIDjstringjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "warnCellByUID");
}

jstring UID_ = curEnv->NewStringUTF( UID );

jstring message_ = curEnv->NewStringUTF( message );

                         curEnv->CallStaticVoidMethod(cls, voidwarnCellByUIDjstringjstringID ,UID_, message_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::closeXcosFromScilab (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcloseXcosFromScilabID = curEnv->GetStaticMethodID(cls, "closeXcosFromScilab", "()V" ) ;
if (voidcloseXcosFromScilabID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeXcosFromScilab");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseXcosFromScilabID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int Xcos::xcosDiagramToHDF5 (JavaVM * jvm_, char * xcosFile, char * h5File, bool forceOverwrite){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintxcosDiagramToHDF5jstringjstringjbooleanID = curEnv->GetStaticMethodID(cls, "xcosDiagramToHDF5", "(Ljava/lang/String;Ljava/lang/String;Z)I" ) ;
if (jintxcosDiagramToHDF5jstringjstringjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramToHDF5");
}

jstring xcosFile_ = curEnv->NewStringUTF( xcosFile );

jstring h5File_ = curEnv->NewStringUTF( h5File );

jboolean forceOverwrite_ = (static_cast<bool>(forceOverwrite) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintxcosDiagramToHDF5jstringjstringjbooleanID ,xcosFile_, h5File_, forceOverwrite_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void Xcos::xcosDiagramOpen (JavaVM * jvm_, char * UID, bool show){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosDiagramOpenjstringjbooleanID = curEnv->GetStaticMethodID(cls, "xcosDiagramOpen", "(Ljava/lang/String;Z)V" ) ;
if (voidxcosDiagramOpenjstringjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramOpen");
}

jstring UID_ = curEnv->NewStringUTF( UID );

jboolean show_ = (static_cast<bool>(show) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidxcosDiagramOpenjstringjbooleanID ,UID_, show_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcosDiagramClose (JavaVM * jvm_, char * UID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosDiagramClosejstringID = curEnv->GetStaticMethodID(cls, "xcosDiagramClose", "(Ljava/lang/String;)V" ) ;
if (voidxcosDiagramClosejstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramClose");
}

jstring UID_ = curEnv->NewStringUTF( UID );

                         curEnv->CallStaticVoidMethod(cls, voidxcosDiagramClosejstringID ,UID_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
