// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008-2008 - INRIA - Jean-Baptiste Silvy
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- TEST WITH GRAPHIC -->

// <-- Non-regression test for bug 1726 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=1726
//
// <-- Short Description -->
// Painter algorithm limitations

p = [];
p ( 1,1) =  1; p ( 1,2) = -1; p ( 1,3) =  1;
p ( 2,1) =  1; p ( 2,2) = -1; p ( 2,3) = -1;
p ( 3,1) = -1; p ( 3,2) = -1; p ( 3,3) =  1;
p ( 4,1) = -1; p ( 4,2) = -1; p ( 4,3) = -1;
p ( 5,1) =  1; p ( 5,2) =  1; p ( 5,3) =  1;
p ( 6,1) =  1; p ( 6,2) =  1; p ( 6,3) = -1;
p ( 7,1) = -1; p ( 7,2) =  1; p ( 7,3) =  1;
p ( 8,1) = -1; p ( 8,2) =  1; p ( 8,3) = -1;
p ( 9,1) =  0.9; p ( 9,2) =  0.9; p ( 9,3) =  0.9;
p (10,1) =  0.9; p (10,2) =  0.9; p (10,3) = -0.9;
p (11,1) = -0.9; p (11,2) =  0.9; p (11,3) =  0.9;
p (12,1) = -0.9; p (12,2) =  0.9; p (12,3) = -0.9;


tx = [];
tx (1, 1) = p ( 1,1); tx (2, 1) = p ( 3,1); tx (3, 1) = p ( 7,1); tx (4, 1) = p( 5,1);
tx (1, 2) = p ( 2,1); tx (2, 2) = p ( 6,1); tx (3, 2) = p ( 8,1); tx (4, 2) = p( 4,1);
tx (1, 3) = p ( 1,1); tx (2, 3) = p ( 5,1); tx (3, 3) = p ( 6,1); tx (4, 3) = p( 2,1);
tx (1, 4) = p ( 7,1); tx (2, 4) = p ( 8,1); tx (3, 4) = p ( 6,1); tx (4, 4) = p( 5,1);
tx (1, 5) = p ( 3,1); tx (2, 5) = p ( 4,1); tx (3, 5) = p ( 8,1); tx (4, 5) = p( 7,1);
tx (1, 6) = p ( 4,1); tx (2, 6) = p ( 3,1); tx (3, 6) = p (11,1); tx (4, 6) = p(12,1);
tx (1, 7) = p ( 2,1); tx (2, 7) = p ( 4,1); tx (3, 7) = p (12,1); tx (4, 7) = p(10,1);
tx (1, 8) = p ( 1,1); tx (2, 8) = p ( 2,1); tx (3, 8) = p (10,1); tx (4, 8) = p( 9,1);
tx (1, 9) = p ( 3,1); tx (2, 9) = p ( 1,1); tx (3, 9) = p ( 9,1); tx (4, 9) = p(11,1);
tx (1,10) = p (10,1); tx (2,10) = p (12,1); tx (3,10) = p (11,1); tx (4,10) = p( 9,1);

ty = [];
ty (1, 1) = p ( 1,2); ty (2, 1) = p ( 3,2); ty (3, 1) = p ( 7,2); ty (4, 1) = p( 5,2);
ty (1, 2) = p ( 2,2); ty (2, 2) = p ( 6,2); ty (3, 2) = p ( 8,2); ty (4, 2) = p( 4,2);
ty (1, 3) = p ( 1,2); ty (2, 3) = p ( 5,2); ty (3, 3) = p ( 6,2); ty (4, 3) = p( 2,2);
ty (1, 4) = p ( 7,2); ty (2, 4) = p ( 8,2); ty (3, 4) = p ( 6,2); ty (4, 4) = p( 5,2);
ty (1, 5) = p ( 3,2); ty (2, 5) = p ( 4,2); ty (3, 5) = p ( 8,2); ty (4, 5) = p( 7,2);
ty (1, 6) = p ( 4,2); ty (2, 6) = p ( 3,2); ty (3, 6) = p (11,2); ty (4, 6) = p(12,2);
ty (1, 7) = p ( 2,2); ty (2, 7) = p ( 4,2); ty (3, 7) = p (12,2); ty (4, 7) = p(10,2);
ty (1, 8) = p ( 1,2); ty (2, 8) = p ( 2,2); ty (3, 8) = p (10,2); ty (4, 8) = p( 9,2);
ty (1, 9) = p ( 3,2); ty (2, 9) = p ( 1,2); ty (3, 9) = p ( 9,2); ty (4, 9) = p(11,2);
ty (1,10) = p (10,2); ty (2,10) = p (12,2); ty (3,10) = p (11,2); ty (4,10) = p( 9,2);


tz = [];
tz (1, 1) = p ( 1,3); tz (2, 1) = p ( 3,3); tz (3, 1) = p ( 7,3); tz (4, 1) = p( 5,3);
tz (1, 2) = p ( 2,3); tz (2, 2) = p ( 6,3); tz (3, 2) = p ( 8,3); tz (4, 2) = p( 4,3);
tz (1, 3) = p ( 1,3); tz (2, 3) = p ( 5,3); tz (3, 3) = p ( 6,3); tz (4, 3) = p( 2,3);
tz (1, 4) = p ( 7,3); tz (2, 4) = p ( 8,3); tz (3, 4) = p ( 6,3); tz (4, 4) = p( 5,3);
tz (1, 5) = p ( 3,3); tz (2, 5) = p ( 4,3); tz (3, 5) = p ( 8,3); tz (4, 5) = p( 7,3);
tz (1, 6) = p ( 4,3); tz (2, 6) = p ( 3,3); tz (3, 6) = p (11,3); tz (4, 6) = p(12,3);
tz (1, 7) = p ( 2,3); tz (2, 7) = p ( 4,3); tz (3, 7) = p (12,3); tz (4, 7) = p(10,3);
tz (1, 8) = p ( 1,3); tz (2, 8) = p ( 2,3); tz (3, 8) = p (10,3); tz (4, 8) = p( 9,3);
tz (1, 9) = p ( 3,3); tz (2, 9) = p ( 1,3); tz (3, 9) = p ( 9,3); tz (4, 9) = p(11,3);
tz (1,10) = p (10,3); tz (2,10) = p (12,3); tz (3,10) = p (11,3); tz (4,10) = p( 9,3);


c = [];
c( 1)= 30;
c( 2)= 60;
c( 3)= 90;
c( 4)= 40;
c( 5)= 70;
c( 6)= 99;
c( 7)= 50;
c( 8)= 80;
c( 9)= 35;
c(10)= 65;

hf = scf (1);
hf.color_map = jetcolormap (100);
ha = gca ();
ha.view = "3d";
ha.tight_limits = "on";
ha.isoview = "on";
plot3d (tx, ty, list (tz,c));

alpha = 80;
for alpha = -250:0.1:0
    drawlater();
    ha.rotation_angles(2) = alpha;
    drawnow();
end

// chack that 5 facets of the cube are correctly drawn.

