#include "scim-bridge-agent-cursor-location-changed-event.h"

ScimBridgeAgentCursorLocationChangedEvent::ScimBridgeAgentCursorLocationChangedEvent (scim_bridge_imcontext_id_t new_id, int new_x, int new_y, ScimBridgeAgentClientListener *new_client_listener):
ScimBridgeAgentEvent (CURSOR_LOCATION_CHANGED_EVENT), imcontext_id (new_id), cursor_x (new_x), cursor_y (new_y), client_listener (new_client_listener)
{
}


ScimBridgeAgentCursorLocationChangedEvent::~ScimBridgeAgentCursorLocationChangedEvent ()
{
}


scim_bridge_imcontext_id_t ScimBridgeAgentCursorLocationChangedEvent::get_imcontext_id () const
{
    return imcontext_id;
}


int ScimBridgeAgentCursorLocationChangedEvent::get_cursor_x () const
{
    return cursor_x;
}


int ScimBridgeAgentCursorLocationChangedEvent::get_cursor_y () const
{
    return cursor_y;
}


ScimBridgeAgentClientListener *ScimBridgeAgentCursorLocationChangedEvent::get_client_listener () const
{
    return client_listener;
}
