/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include "scim-bridge-agent-set-preedit-attributes-event.h"

using namespace scim;

ScimBridgeAgentSetPreeditAttributesEvent::ScimBridgeAgentSetPreeditAttributesEvent (scim_bridge_imcontext_id_t new_id, AttributeList &new_attrs):
ScimBridgeAgentEvent (SET_PREEDIT_ATTRIBUTES_EVENT), imcontext_id (new_id), attrs (new_attrs)
{
}


ScimBridgeAgentSetPreeditAttributesEvent::~ScimBridgeAgentSetPreeditAttributesEvent ()
{
}


scim_bridge_imcontext_id_t ScimBridgeAgentSetPreeditAttributesEvent::get_imcontext_id () const
{
    return imcontext_id;
}


AttributeList &ScimBridgeAgentSetPreeditAttributesEvent::get_preedit_attributes () const
{
    return attrs;
}
