/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGESTRING_H_
#define SCIMBRIDGESTRING_H_

#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C"
{
#endif

#ifndef __STDC_ISO_10646__
    typedef uint32 wchar;
#else
    typedef wchar_t wchar;
#endif

    ssize_t scim_bridge_string_to_wstring (wchar **wstr, const char *str);
    ssize_t scim_bridge_wstring_to_string (char **str, const wchar *wstr);

    ssize_t scim_bridge_string_get_length (const char *str);
    ssize_t scim_bridge_wstring_get_length (const wchar *wstr);

    retval_t scim_bridge_string_to_uint (unsigned int *dst, const char *str);
    retval_t scim_bridge_string_to_int (int *dst, const char *str);
    retval_t scim_bridge_string_to_boolean (boolean *dst, const char *str);

    size_t scim_bridge_string_from_uint (char **str, unsigned int value);
    size_t scim_bridge_string_from_int (char **str, int value);
    size_t scim_bridge_string_from_boolean (char **str, boolean value);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGESTRING_H_*/
