/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDCOMMON_H_
#define SCIMBRIDCOMMON_H_

#include <signal.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef SCIM_VERSION
#define SCIM_VERSION "<unknown>"
#endif

#define _(String)   gettext(String)
#define N_(String)  gettext_noop(String)
#define gettext_noop(String) (String)

#define SIGNOTIFY SIGUSR1

#ifndef NPOS
#define NPOS -1
#endif

/**
 * The type of boolean.
 */
typedef int boolean;

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

/**
 * The type of retvals.
 */
typedef int retval_t;

/**
 * The return value of failture.
 */
#define RETVAL_FAILED -1

/**
 * The return value of success.
 */
#define RETVAL_SUCCEEDED 0
#endif                                            /*SCIMBRIDCOMMON_H_*/
