/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_setup.cpp,v 1.10.4.1 2004/05/01 13:23:36 suzhe Exp $
 *
 */

#include <iostream>
#include <locale.h>

#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_MODULE
#define Uses_SCIM_DEBUG

#include "scim_private.h"
#include "scim.h"

#include "scim_setup_module.h"
#include "scim_setup_ui.h"

int main (int argc, char *argv [])
{
    std::vector<String>  setup_list;

    SetupModule         *setup_module = 0;

    SetupUI             *setup_ui;

    if (!scim_get_setup_module_list (setup_list)) {
        std::cerr << "No Setup module found!\n";
    }

    setup_ui = new SetupUI (argc, argv);

    if (!setup_ui) {
        std::cerr << "Failed to create Setup UI.\n";
        return -1;
    }

    for (int i = 0; i < setup_list.size (); ++ i) {
        std::cout << "Loading Setup Module " << setup_list [i] << "\n";
        setup_module = new SetupModule (setup_list [i]);

        if (setup_module && setup_module->valid ()) {
            setup_ui->add_module (setup_module);
        } else {
            std::cerr << "Setup Module " << setup_list [i]
                  << " load failed!\n";
            if (setup_module) delete setup_module;
        }
    }

    std::cout << "Starting Setup UI...\n";

    setup_ui->run ();

    delete setup_ui;

    return 0;
}

/*
vi:ts=4:nowrap:ai:expandtab
*/
