/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_server_module.cpp,v 1.14 2004/03/06 15:48:11 suzhe Exp $
 *
 */

#define Uses_SCIM_SERVER_MODULE
#define Uses_SCIM_MODULE
#include "scim_private.h"
#include "scim.h"

namespace scim {

ServerModule::ServerModule ()
    : m_server_init (0),
      m_server_create_factory (0),
      m_number_of_servers (0)
{
}

ServerModule::ServerModule (const String &name, const ConfigPointer &config)
    : m_server_init (0),
      m_server_create_factory (0),
      m_number_of_servers (0)
{
    load (name, config);
}

bool
ServerModule::load (const String &name, const ConfigPointer &config)
{
    try {
        if (!m_module.load (name, "Server"))
            return false;

        m_server_init = (ServerModuleInitFunc) m_module.symbol ("scim_server_module_init");
        m_server_create_factory = (ServerModuleCreateFactoryFunc) m_module.symbol ("scim_server_module_create_factory");

        if (!m_server_init || !m_server_create_factory) {
            m_module.unload ();
            m_server_init = 0;
            m_server_create_factory = 0;
            m_number_of_servers = 0;
            return false;
        }

        m_number_of_servers = m_server_init (config);
    } catch (...) {
        m_module.unload ();
        m_server_init = 0;
        m_server_create_factory = 0;
        m_number_of_servers = 0;
        return false;
    }

    return true;
}

bool
ServerModule::unload ()
{
    return m_module.unload ();
}

bool
ServerModule::valid () const
{
    return (m_module.valid () && m_server_init &&
            m_server_create_factory && m_number_of_servers > 0);
}

ServerFactoryPointer
ServerModule::create_factory (unsigned int server) const
{
    if (valid () && server < m_number_of_servers)
        return m_server_create_factory (server);

    return ServerFactoryPointer (0);
}

unsigned int
ServerModule::number_of_servers () const
{
    return m_number_of_servers;
}

int scim_get_server_module_list (std::vector <String>& mod_list)
{
    return scim_get_module_list (mod_list, "Server");
}


} // namespace scim

/*
vi:ts=4:nowrap:ai:expandtab
*/
