/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_frontend.cpp,v 1.33 2004/07/23 16:17:30 suzhe Exp $
 *
 */

#define Uses_SCIM_FRONTEND
#include "scim_private.h"
#include "scim.h"

namespace scim {

class FrontEndBase::FrontEndBaseImpl
{
public:
    BackEndPointer  m_backend;

    FrontEndBaseImpl (const BackEndPointer &backend)
        : m_backend (backend)
    { }
};

FrontEndBase::FrontEndBase (const BackEndPointer &backend)
    : m_impl (new FrontEndBaseImpl (backend))
{
    backend->signal_connect_show_preedit_string   (slot (this, &FrontEndBase::show_preedit_string));
    backend->signal_connect_show_aux_string       (slot (this, &FrontEndBase::show_aux_string));
    backend->signal_connect_show_lookup_table     (slot (this, &FrontEndBase::show_lookup_table));
    backend->signal_connect_hide_preedit_string   (slot (this, &FrontEndBase::hide_preedit_string));
    backend->signal_connect_hide_aux_string       (slot (this, &FrontEndBase::hide_aux_string));
    backend->signal_connect_hide_lookup_table     (slot (this, &FrontEndBase::hide_lookup_table));
    backend->signal_connect_update_preedit_caret  (slot (this, &FrontEndBase::update_preedit_caret));
    backend->signal_connect_update_preedit_string (slot (this, &FrontEndBase::update_preedit_string));
    backend->signal_connect_update_aux_string     (slot (this, &FrontEndBase::update_aux_string));
    backend->signal_connect_update_lookup_table   (slot (this, &FrontEndBase::update_lookup_table));
    backend->signal_connect_commit_string         (slot (this, &FrontEndBase::commit_string));
    backend->signal_connect_forward_key_event     (slot (this, &FrontEndBase::forward_key_event));
    backend->signal_connect_register_properties   (slot (this, &FrontEndBase::register_properties));
    backend->signal_connect_update_property       (slot (this, &FrontEndBase::update_property));
}

FrontEndBase::~FrontEndBase ()
{
    delete m_impl;
}

uint32
FrontEndBase::get_factory_list (std::vector<String>& uuids, const String &encoding) const
{
    return m_impl->m_backend->get_factory_list (uuids, encoding);
}

WideString
FrontEndBase::get_factory_name (const String &uuid) const
{
    return m_impl->m_backend->get_factory_name (uuid);
}

WideString
FrontEndBase::get_factory_authors (const String &uuid) const
{
    return m_impl->m_backend->get_factory_authors (uuid);
}

WideString
FrontEndBase::get_factory_credits (const String &uuid) const
{
    return m_impl->m_backend->get_factory_credits (uuid);
}

WideString
FrontEndBase::get_factory_help (const String &uuid) const
{
    return m_impl->m_backend->get_factory_help (uuid);
}

String
FrontEndBase::get_factory_locales (const String &uuid) const
{
    return m_impl->m_backend->get_factory_locales (uuid);
}

String
FrontEndBase::get_factory_language (const String &uuid) const
{
    return m_impl->m_backend->get_factory_language (uuid);
}

String
FrontEndBase::get_factory_icon_file (const String &uuid) const
{
    return m_impl->m_backend->get_factory_icon_file (uuid);
}

String
FrontEndBase::get_all_locales () const
{
    return m_impl->m_backend->get_all_locales ();
}

int
FrontEndBase::new_instance (const String &sf_uuid, const String& encoding)
{
    return m_impl->m_backend->new_instance (sf_uuid, encoding);
}

bool
FrontEndBase::replace_instance (int si_id, const String &sf_uuid)
{
    return m_impl->m_backend->replace_instance (si_id, sf_uuid);
}

bool
FrontEndBase::delete_instance (int id)
{
    return m_impl->m_backend->delete_instance (id);
}

void
FrontEndBase::delete_all_instances ()
{
    m_impl->m_backend->delete_all_instances ();
}

String
FrontEndBase::get_instance_encoding (int id) const
{
    return m_impl->m_backend->get_instance_encoding (id);
}

WideString
FrontEndBase::get_instance_name (int id) const
{
    return m_impl->m_backend->get_instance_name (id);
}

WideString
FrontEndBase::get_instance_authors (int id) const
{
    return m_impl->m_backend->get_instance_authors (id);
}

WideString
FrontEndBase::get_instance_credits (int id) const
{
    return m_impl->m_backend->get_instance_credits (id);
}

WideString
FrontEndBase::get_instance_help (int id) const
{
    return m_impl->m_backend->get_instance_help (id);
}

String
FrontEndBase::get_instance_icon_file (int id) const
{
    return m_impl->m_backend->get_instance_icon_file (id);
}

void
FrontEndBase::focus_in (int id) const
{
    m_impl->m_backend->focus_in (id);
}

void
FrontEndBase::focus_out (int id) const
{
    m_impl->m_backend->focus_out (id);
}

void
FrontEndBase::reset (int id) const
{
    m_impl->m_backend->reset (id);
}

bool
FrontEndBase::process_key_event (int id, const KeyEvent& key) const
{
    return m_impl->m_backend->process_key_event (id, key);
}

void
FrontEndBase::move_preedit_caret (int id, unsigned int pos) const
{
    m_impl->m_backend->move_preedit_caret (id, pos);
}

void
FrontEndBase::select_candidate (int id, unsigned int index) const
{
    m_impl->m_backend->select_candidate (id, index);
}

void
FrontEndBase::update_lookup_table_page_size (int id, unsigned int page_size) const
{
    m_impl->m_backend->update_lookup_table_page_size (id, page_size);
}

void
FrontEndBase::lookup_table_page_up (int id) const
{
    m_impl->m_backend->lookup_table_page_up (id);
}

void
FrontEndBase::lookup_table_page_down (int id) const
{
    m_impl->m_backend->lookup_table_page_down (id);
}

void
FrontEndBase::trigger_property (int id, const String & property) const
{
    m_impl->m_backend->trigger_property (id, property);
}

} // namespace scim

/*
vi:ts=4:ai:nowrap:expandtab
*/
