//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 483> sph_bessel_data = {{
      {{ SC_(0.0), SC_(0.177219114266335964202880859375e-2), SC_(0.999999476556507842202459130864323898236e0) }}, 
      {{ SC_(0.0), SC_(0.22177286446094512939453125e-2), SC_(0.9999991802801447287222232346958222796612e0) }}, 
      {{ SC_(0.0), SC_(0.7444499991834163665771484375e-2), SC_(0.9999907632622405689302860688925139982587e0) }}, 
      {{ SC_(0.0), SC_(0.1433600485324859619140625e-1), SC_(0.9999657468461303487880990241993035937654e0) }}, 
      {{ SC_(0.0), SC_(0.1760916970670223236083984375e-1), SC_(0.9999483203249623334100130061926184665364e0) }}, 
      {{ SC_(0.0), SC_(0.6152711808681488037109375e-1), SC_(0.9993691883680863109159389449304869676033e0) }}, 
      {{ SC_(0.0), SC_(0.11958599090576171875e0), SC_(0.9976182354925345599905760522457355689246e0) }}, 
      {{ SC_(0.0), SC_(0.15262925624847412109375e0), SC_(0.9961219049249727586697484380600284691174e0) }}, 
      {{ SC_(0.0), SC_(0.408089816570281982421875e0), SC_(0.9724739915431544258938594874310588064205e0) }}, 
      {{ SC_(0.0), SC_(0.6540834903717041015625e0), SC_(0.9302056396192119311058689588352213355057e0) }}, 
      {{ SC_(0.0), SC_(0.1097540378570556640625e1), SC_(0.8109851883728203095784514632631378051565e0) }}, 
      {{ SC_(0.0), SC_(0.30944411754608154296875e1), SC_(0.1523183208785146731314680065502594134681e-1) }}, 
      {{ SC_(0.0), SC_(0.51139926910400390625e1), SC_(-0.1799836939747169709868781821542134553205e0) }}, 
      {{ SC_(0.0), SC_(0.95070552825927734375e1), SC_(-0.8644582430311092690468530625290874536115e-2) }}, 
      {{ SC_(0.0), SC_(0.24750102996826171875e2), SC_(-0.1508556180252377401284155114952468133194e-1) }}, 
      {{ SC_(0.0), SC_(0.637722015380859375e2), SC_(0.1266638994943852616886089579836946490336e-1) }}, 
      {{ SC_(0.0), SC_(0.1252804412841796875e3), SC_(-0.2984906844146395453998586259283750185621e-2) }}, 
      {{ SC_(0.0), SC_(0.25554705810546875e3), SC_(-0.3447656740458789191073137012008656930551e-2) }}, 
      {{ SC_(0.0), SC_(0.503011474609375e3), SC_(0.6940935913226775542129988435446092279729e-3) }}, 
      {{ SC_(0.0), SC_(0.10074598388671875e4), SC_(0.8305987986864569002626675437293057248821e-3) }}, 
      {{ SC_(0.0), SC_(0.1185395751953125e4), SC_(-0.7167649812470622363222627438778746846582e-3) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.5907301953593941259509561856854291087832e-3) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.7392425179532175006179700888774678679099e-3) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.2481486244688331388548761462155911660424e-2) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.477857007345182708698871081176423742643e-2) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.5869541227527534973977936514325779485181e-2) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.205012765381082643967011963466059108825e-1) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(0.3980502019486214219412102921577104486039e-1) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(0.507579971871436936245493977138951657167e-1) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(0.1337779656209597925613024398512918494342e0) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(0.2088414497092880298218980583359870711751e0) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(0.3236312899642309880098636972650663742421e0) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(0.3277232784787348060184709473722850920387e0) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(-0.1116307129673207101011381466711802872966e0) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(0.1039199329743298950197804325967556415006e0) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(-0.3809149370198498667373716310901593032325e-1) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(-0.9045323488777102113973090754530543316476e-2) }}, 
      {{ SC_(0.1e1), SC_(0.1252804412841796875e3), SC_(-0.7426806470289446901421322001368677195156e-2) }}, 
      {{ SC_(0.1e1), SC_(0.25554705810546875e3), SC_(0.183761395344989507935202292272917754448e-2) }}, 
      {{ SC_(0.1e1), SC_(0.503011474609375e3), SC_(-0.1861543185509194453611459536122112443011e-2) }}, 
      {{ SC_(0.1e1), SC_(0.10074598388671875e4), SC_(0.5442867382073472255455809862764039075858e-3) }}, 
      {{ SC_(0.1e1), SC_(0.1185395751953125e4), SC_(0.4442651225543710411266851455520061266312e-3) }}, 
      {{ SC_(0.2e1), SC_(0.177219114266335964202880859375e-2), SC_(0.2093773827720430565251557110538425770714e-6) }}, 
      {{ SC_(0.2e1), SC_(0.22177286446094512939453125e-2), SC_(0.3278879075515531514779472751721891924383e-6) }}, 
      {{ SC_(0.2e1), SC_(0.7444499991834163665771484375e-2), SC_(0.3694690716009003179822952040973660348991e-5) }}, 
      {{ SC_(0.2e1), SC_(0.1433600485324859619140625e-1), SC_(0.1370120120703995134662099191103188366059e-4) }}, 
      {{ SC_(0.2e1), SC_(0.1760916970670223236083984375e-1), SC_(0.2067173265753174063228459655801741280461e-4) }}, 
      {{ SC_(0.2e1), SC_(0.6152711808681488037109375e-1), SC_(0.2523041832594696207720873096523404469743e-3) }}, 
      {{ SC_(0.2e1), SC_(0.11958599090576171875e0), SC_(0.9524137960598563739357464134535327666968e-3) }}, 
      {{ SC_(0.2e1), SC_(0.15262925624847412109375e0), SC_(0.1550463428413672091078292641795407438935e-2) }}, 
      {{ SC_(0.2e1), SC_(0.408089816570281982421875e0), SC_(0.1097102611452317567405386767797158993089e-1) }}, 
      {{ SC_(0.2e1), SC_(0.6540834903717041015625e0), SC_(0.2766037955185958056378446380712964902424e-1) }}, 
      {{ SC_(0.2e1), SC_(0.1097540378570556640625e1), SC_(0.7362360493389258718677168933368717603075e-1) }}, 
      {{ SC_(0.2e1), SC_(0.30944411754608154296875e1), SC_(0.3024894557597979701575888951210976888787e0) }}, 
      {{ SC_(0.2e1), SC_(0.51139926910400390625e1), SC_(0.1144982388451644297330327843104009488548e0) }}, 
      {{ SC_(0.2e1), SC_(0.95070552825927734375e1), SC_(0.4143704967238294556855640424303560695077e-1) }}, 
      {{ SC_(0.2e1), SC_(0.24750102996826171875e2), SC_(0.1046843026490516523565262690999881523111e-1) }}, 
      {{ SC_(0.2e1), SC_(0.637722015380859375e2), SC_(-0.1309190404197185674877392619814616382613e-1) }}, 
      {{ SC_(0.2e1), SC_(0.1252804412841796875e3), SC_(0.2807062488056296863373885100415798671326e-2) }}, 
      {{ SC_(0.2e1), SC_(0.25554705810546875e3), SC_(0.3469229447658863624235064543945418606161e-2) }}, 
      {{ SC_(0.2e1), SC_(0.503011474609375e3), SC_(-0.7051959813046644551033771629828891764763e-3) }}, 
      {{ SC_(0.2e1), SC_(0.10074598388671875e4), SC_(-0.8289780291514071759326532983957910172243e-3) }}, 
      {{ SC_(0.2e1), SC_(0.1185395751953125e4), SC_(0.7178893275807378245723639629312389935114e-3) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(0.1043783376837269415656629099992565667092e-13) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(0.2559774557671848742422562459374402479171e-13) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(0.3250193613184550377260115454105020657549e-11) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(0.4469682677416623924037229681870123528417e-10) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(0.101746056573412727336966799805478893789e-9) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(0.1516211386725807703466991840076574150499e-7) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(0.216275386096930433390507967308045332362e-6) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(0.5736664261625388112327264738146401787856e-6) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(0.2912740194772400778071406390564947979695e-4) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(0.1899514932067494545272197267372701237686e-3) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(0.1453347874709174940209018570873349993662e-2) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(0.6180107635015316992043827444759368254146e-1) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(0.1915321596858163372986487584900250664944e0) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(-0.1019068788444761880653772745191206413045e0) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(0.9030066589287021559976120569661632677975e-3) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(0.1397210032438881117957577869478362267954e-1) }}, 
      {{ SC_(0.4e1), SC_(0.1252804412841796875e3), SC_(-0.2385832623037109699838426896495044868037e-2) }}, 
      {{ SC_(0.4e1), SC_(0.25554705810546875e3), SC_(-0.3517706422383530613292370111075474391608e-2) }}, 
      {{ SC_(0.4e1), SC_(0.503011474609375e3), SC_(0.7310040090939546601467579790071020662223e-3) }}, 
      {{ SC_(0.4e1), SC_(0.10074598388671875e4), SC_(0.8251676474254587452146668417855595386434e-3) }}, 
      {{ SC_(0.4e1), SC_(0.1185395751953125e4), SC_(-0.7204949210708954243611577591830711882785e-3) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(0.2708412355512061998254744639047117242005e-25) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(0.1301666337751972379119644811690242989531e-24) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(0.6251567482081419841960943936252840800054e-21) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(0.6139531687093123223760370542940134641589e-19) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(0.2590055598488719668444784072004850390416e-18) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(0.1646487937461224311477751736559153713855e-14) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(0.1724727019112870072974551941040449676603e-12) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(0.95127883759441487679171959521067497234e-12) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(0.9253444130577989992750702351532090441498e-9) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(0.2495196845317271516108278829583237997479e-7) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(0.9134165775553915557738914845438280809529e-6) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(0.1006985517520869208111066088679440346231e-2) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(0.2020027207608275213557945137543520484536e-1) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(0.1309975302899428558431047955995222007864e0) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(0.3009439581838823094669769473563721003996e-1) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(0.298617402690478447954804302475942518644e-2) }}, 
      {{ SC_(0.7e1), SC_(0.1252804412841796875e3), SC_(0.7887555711993028736906736576314283291289e-2) }}, 
      {{ SC_(0.7e1), SC_(0.25554705810546875e3), SC_(-0.1463292767579579943284849187188066532514e-2) }}, 
      {{ SC_(0.7e1), SC_(0.503011474609375e3), SC_(0.1821521094606276151942737494477710854595e-2) }}, 
      {{ SC_(0.7e1), SC_(0.10074598388671875e4), SC_(-0.5663419016539526060091032204835345890129e-3) }}, 
      {{ SC_(0.7e1), SC_(0.1185395751953125e4), SC_(-0.4278209067597136718349540002556196983317e-3) }}, 
      {{ SC_(0.1e2), SC_(0.177219114266335964202880859375e-2), SC_(0.2222412467063898207339355229881993867402e-37) }}, 
      {{ SC_(0.1e2), SC_(0.22177286446094512939453125e-2), SC_(0.2093163200601515020924233805357985251582e-36) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(0.3802540886240934890183051910134291949295e-31) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(0.266684964367900816875239147989997648647e-28) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2084994625560126959450283831818652290172e-27) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(0.5653912338828260373998244611776434552227e-22) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(0.434897713836155706767684061375087761872e-19) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(0.498743230435897612604045721851468634098e-18) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(0.9283337003558958058861668656497082016435e-14) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(0.1032785828790319478929806429586227832242e-11) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(0.1796964101377643846918518764647301038832e-9) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(0.4746440374381865829103554103321044705551e-5) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(0.4971062536928122665081320579097067859344e-3) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(0.5057461997083240817148363720744832430867e-1) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(-0.4052937140121672458358612461490746557027e-1) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(-0.1535890173916687054981660529993884242007e-1) }}, 
      {{ SC_(0.1e2), SC_(0.1252804412841796875e3), SC_(-0.4474939888286181251334623695852436518611e-3) }}, 
      {{ SC_(0.1e2), SC_(0.25554705810546875e3), SC_(0.3765065711063798205085097254744083332607e-2) }}, 
      {{ SC_(0.1e2), SC_(0.503011474609375e3), SC_(-0.8933414061270055016410291246172182703654e-3) }}, 
      {{ SC_(0.1e2), SC_(0.10074598388671875e4), SC_(-0.7997283918635939289638161916718765095033e-3) }}, 
      {{ SC_(0.1e2), SC_(0.1185395751953125e4), SC_(0.7366418035649163180844407244651812974016e-3) }}, 
      {{ SC_(0.13e2), SC_(0.177219114266335964202880859375e-2), SC_(0.7967549070233529373880017026126952489191e-50) }}, 
      {{ SC_(0.13e2), SC_(0.22177286446094512939453125e-2), SC_(0.1470607273069396437619925218568282570226e-48) }}, 
      {{ SC_(0.13e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1010529492888596137769488788134125934543e-41) }}, 
      {{ SC_(0.13e2), SC_(0.1433600485324859619140625e-1), SC_(0.5061179515261786863969473670883645484482e-38) }}, 
      {{ SC_(0.13e2), SC_(0.1760916970670223236083984375e-1), SC_(0.7333150083305427873393149999673417624209e-37) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(0.8482513831072114971132095039793732605003e-30) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(0.4790980140493688074282533717797429273979e-26) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(0.1142363387781932566708234637553639504e-24) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(0.4066915958862166702295650618551698937403e-19) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(0.1865153829735527369701114229684691988478e-16) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(0.1538608747375031523485313338490956011086e-13) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(0.9466058139210775751844332755983630328812e-8) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(0.48504542431773440351722505921471017723e-5) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(0.4669762150797955475363862542405060020244e-2) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(0.4275485766960573697460210427189698102253e-1) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(0.113970869465756399991670439131126101944e-1) }}, 
      {{ SC_(0.13e2), SC_(0.1252804412841796875e3), SC_(-0.7536964500733528735734781223525082467916e-2) }}, 
      {{ SC_(0.13e2), SC_(0.25554705810546875e3), SC_(0.5331122223146610928354973014822996100139e-3) }}, 
      {{ SC_(0.13e2), SC_(0.503011474609375e3), SC_(-0.1707932339445138163253579221754559361486e-2) }}, 
      {{ SC_(0.13e2), SC_(0.10074598388671875e4), SC_(0.6161982725605395120038556266779816128265e-3) }}, 
      {{ SC_(0.13e2), SC_(0.1185395751953125e4), SC_(0.3886012392582820794747915723285121522844e-3) }}, 
      {{ SC_(0.16e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1494799019178919704164684488697950765401e-62) }}, 
      {{ SC_(0.16e2), SC_(0.22177286446094512939453125e-2), SC_(0.5406899559381251453544169680868077266279e-61) }}, 
      {{ SC_(0.16e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1405342026752410287955311949575311259182e-52) }}, 
      {{ SC_(0.16e2), SC_(0.1433600485324859619140625e-1), SC_(0.5026466492790835096662241130408498936167e-48) }}, 
      {{ SC_(0.16e2), SC_(0.1760916970670223236083984375e-1), SC_(0.134968983417705578727994627307910143279e-46) }}, 
      {{ SC_(0.16e2), SC_(0.6152711808681488037109375e-1), SC_(0.665971316060260945039307883943078858114e-38) }}, 
      {{ SC_(0.16e2), SC_(0.11958599090576171875e0), SC_(0.276191313737021349212591975678624891256e-33) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(0.1369222136686508369518858329528365276932e-31) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(0.9321217895124114971986136959461421247752e-25) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(0.1761530144676075863434436240846302094995e-21) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(0.6881211593792194005308098151953401401657e-18) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(0.9729690406205422015094030111006162785483e-11) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(0.2369384609873979026448692174721409067076e-7) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(0.1840144164665907839516357934905584301009e-3) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(-0.3782449186764807008803327973421536394565e-1) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(0.9058896143977969311183407247844501595529e-3) }}, 
      {{ SC_(0.16e2), SC_(0.1252804412841796875e3), SC_(0.5188234812418497350666801838628597224656e-2) }}, 
      {{ SC_(0.16e2), SC_(0.25554705810546875e3), SC_(-0.3914183257756290386308986660817807901091e-2) }}, 
      {{ SC_(0.16e2), SC_(0.503011474609375e3), SC_(0.1166797445373819044700790380121207908842e-2) }}, 
      {{ SC_(0.16e2), SC_(0.10074598388671875e4), SC_(0.7499495974300410955160550557937905221906e-3) }}, 
      {{ SC_(0.16e2), SC_(0.1185395751953125e4), SC_(-0.7630182265896611227918142846728827781432e-3) }}, 
      {{ SC_(0.19e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1647328137505776803665556649681294214429e-75) }}, 
      {{ SC_(0.19e2), SC_(0.22177286446094512939453125e-2), SC_(0.1167721156926765964617081497378340236669e-73) }}, 
      {{ SC_(0.19e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1148032836839990572733346760555819154369e-63) }}, 
      {{ SC_(0.19e2), SC_(0.1433600485324859619140625e-1), SC_(0.2932331198078231365628892888986179941717e-58) }}, 
      {{ SC_(0.19e2), SC_(0.1760916970670223236083984375e-1), SC_(0.1459205707718986730267688124799008768904e-56) }}, 
      {{ SC_(0.19e2), SC_(0.6152711808681488037109375e-1), SC_(0.3071314610753011509563627469767240897976e-46) }}, 
      {{ SC_(0.19e2), SC_(0.11958599090576171875e0), SC_(0.9352539352435882122864731154174998436925e-41) }}, 
      {{ SC_(0.19e2), SC_(0.15262925624847412109375e0), SC_(0.9639933804338041569207162945804028032218e-39) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(0.125474879414245919901052299666990587518e-30) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(0.9768859561346455343073918524536182289401e-27) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(0.1805872345289899044932828488235930856372e-22) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(0.5824898256766049332141670366521224363248e-14) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(0.6636835786625579616169200350572117580618e-10) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(0.3855699191681560295883321198702198533656e-5) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(0.4088696716386786969522279433375948444082e-2) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(-0.1117794430073494920526792498246447801453e-1) }}, 
      {{ SC_(0.19e2), SC_(0.1252804412841796875e3), SC_(0.338026617039469683574906738787114656499e-2) }}, 
      {{ SC_(0.19e2), SC_(0.25554705810546875e3), SC_(0.9737821689979933751640244597139357048864e-3) }}, 
      {{ SC_(0.19e2), SC_(0.503011474609375e3), SC_(0.1476104412709440376091325195254203816075e-2) }}, 
      {{ SC_(0.19e2), SC_(0.10074598388671875e4), SC_(-0.6896131282003686830970164872319742255719e-3) }}, 
      {{ SC_(0.19e2), SC_(0.1185395751953125e4), SC_(-0.3247919500263073292648287044867251022298e-3) }}, 
      {{ SC_(0.22e2), SC_(0.177219114266335964202880859375e-2), SC_(0.115570496092769541976791861538054839035e-88) }}, 
      {{ SC_(0.22e2), SC_(0.22177286446094512939453125e-2), SC_(0.1605460200977085471550938888703841087224e-86) }}, 
      {{ SC_(0.22e2), SC_(0.7444499991834163665771484375e-2), SC_(0.5970299567469574128938480660616379715401e-75) }}, 
      {{ SC_(0.22e2), SC_(0.1433600485324859619140625e-1), SC_(0.1089012217086948569488309137374168179772e-68) }}, 
      {{ SC_(0.22e2), SC_(0.1760916970670223236083984375e-1), SC_(0.100431174165530608013874662207409109887e-66) }}, 
      {{ SC_(0.22e2), SC_(0.6152711808681488037109375e-1), SC_(0.9016993553881957239106946510253201848281e-55) }}, 
      {{ SC_(0.22e2), SC_(0.11958599090576171875e0), SC_(0.2016115028015319311662627825725368676571e-48) }}, 
      {{ SC_(0.22e2), SC_(0.15262925624847412109375e0), SC_(0.4320543085613016459083307878983475415807e-46) }}, 
      {{ SC_(0.22e2), SC_(0.408089816570281982421875e0), SC_(0.1075156900631929554655506824478260122832e-36) }}, 
      {{ SC_(0.22e2), SC_(0.6540834903717041015625e0), SC_(0.3448005537298630067925105881991666714362e-32) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(0.3015080541362985466164096100863692361889e-27) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(0.2208465739590277824044745620237120652321e-17) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(0.1166299570727830472707179451623517252553e-12) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(0.4857373355963448563126486224353642389299e-7) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(0.590129849978225923266816585759037650451e-1) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(0.1575558980304030876971199319344467844283e-1) }}, 
      {{ SC_(0.22e2), SC_(0.1252804412841796875e3), SC_(-0.8027574745134647035512348129760053678816e-2) }}, 
      {{ SC_(0.22e2), SC_(0.25554705810546875e3), SC_(0.3444714422238110167660953457802558341129e-2) }}, 
      {{ SC_(0.22e2), SC_(0.503011474609375e3), SC_(-0.1506980286438278486200021177115787936675e-2) }}, 
      {{ SC_(0.22e2), SC_(0.10074598388671875e4), SC_(-0.6695734911585466996605065690429855975964e-3) }}, 
      {{ SC_(0.22e2), SC_(0.1185395751953125e4), SC_(0.7948046191878189623863943385417937902111e-3) }}, 
      {{ SC_(0.25e2), SC_(0.177219114266335964202880859375e-2), SC_(0.5476644488663159849042225880390978995961e-102) }}, 
      {{ SC_(0.25e2), SC_(0.22177286446094512939453125e-2), SC_(0.1490941661051738605059687877811960169617e-99) }}, 
      {{ SC_(0.25e2), SC_(0.7444499991834163665771484375e-2), SC_(0.2097194157780967799397144530971517823821e-86) }}, 
      {{ SC_(0.25e2), SC_(0.1433600485324859619140625e-1), SC_(0.2731826813279762741060215264479056593715e-79) }}, 
      {{ SC_(0.25e2), SC_(0.1760916970670223236083984375e-1), SC_(0.4668971523482048878387920385920980176132e-77) }}, 
      {{ SC_(0.25e2), SC_(0.6152711808681488037109375e-1), SC_(0.1788131052412233907472678457841349914873e-63) }}, 
      {{ SC_(0.25e2), SC_(0.11958599090576171875e0), SC_(0.2935618339628096022270537875225522573166e-56) }}, 
      {{ SC_(0.25e2), SC_(0.15262925624847412109375e0), SC_(0.1307975998789935802968332268782900511622e-53) }}, 
      {{ SC_(0.25e2), SC_(0.408089816570281982421875e0), SC_(0.6222460074587683747882003944109421862327e-43) }}, 
      {{ SC_(0.25e2), SC_(0.6540834903717041015625e0), SC_(0.8219156039882384903916730268217384409663e-38) }}, 
      {{ SC_(0.25e2), SC_(0.1097540378570556640625e1), SC_(0.3398809376070863184869448598682839548489e-32) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(0.5636498168138861667702497500288192639577e-21) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(0.1371245412178991599450811165398791987009e-15) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(0.3986605282151849884140862585678481739027e-9) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(0.2960574441657556306186264307844324552434e-1) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(-0.1612522243155876237406606398662193271529e-1) }}, 
      {{ SC_(0.25e2), SC_(0.1252804412841796875e3), SC_(0.4876199303134212065811103201065382975693e-2) }}, 
      {{ SC_(0.25e2), SC_(0.25554705810546875e3), SC_(-0.2759186309935219884320850168389728706905e-2) }}, 
      {{ SC_(0.25e2), SC_(0.503011474609375e3), SC_(-0.1069974373239466105453978588018181219313e-2) }}, 
      {{ SC_(0.25e2), SC_(0.10074598388671875e4), SC_(0.7788863106315495907326644443477168009543e-3) }}, 
      {{ SC_(0.25e2), SC_(0.1185395751953125e4), SC_(0.2342098737167276743397666396962575279497e-3) }}, 
      {{ SC_(0.28e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1834563807666394651412285699642330649596e-115) }}, 
      {{ SC_(0.28e2), SC_(0.22177286446094512939453125e-2), SC_(0.9787515332871736972368637040925674801202e-113) }}, 
      {{ SC_(0.28e2), SC_(0.7444499991834163665771484375e-2), SC_(0.5207530819213787944295766953774614574213e-98) }}, 
      {{ SC_(0.28e2), SC_(0.1433600485324859619140625e-1), SC_(0.4844224393509102989989410547993747354657e-90) }}, 
      {{ SC_(0.28e2), SC_(0.1760916970670223236083984375e-1), SC_(0.1534350490185687887303259794602735548086e-87) }}, 
      {{ SC_(0.28e2), SC_(0.6152711808681488037109375e-1), SC_(0.2506612653364868055242532378263674339192e-72) }}, 
      {{ SC_(0.28e2), SC_(0.11958599090576171875e0), SC_(0.3021572752323760442898558805978716974025e-64) }}, 
      {{ SC_(0.28e2), SC_(0.15262925624847412109375e0), SC_(0.2799042097273001397629680500476119616954e-61) }}, 
      {{ SC_(0.28e2), SC_(0.408089816570281982421875e0), SC_(0.2545571914568155257065291034990411748045e-49) }}, 
      {{ SC_(0.28e2), SC_(0.6540834903717041015625e0), SC_(0.1384814695968473038227676443267055411783e-43) }}, 
      {{ SC_(0.28e2), SC_(0.1097540378570556640625e1), SC_(0.2707553790339595024432465606734041421116e-37) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(0.1014495285106345089038033287512609253277e-24) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(0.1132171226825462869232233839175821823053e-18) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(0.2257103866423017458018218876831510764162e-11) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(0.6555946796374431213876027943793880171737e-2) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(0.1503151145481491133995892741625706728646e-1) }}, 
      {{ SC_(0.28e2), SC_(0.1252804412841796875e3), SC_(0.2157891077843019930205470620066920609457e-2) }}, 
      {{ SC_(0.28e2), SC_(0.25554705810546875e3), SC_(-0.1788793705149522781267354777425462202614e-2) }}, 
      {{ SC_(0.28e2), SC_(0.503011474609375e3), SC_(0.1827259871969465268630920775652820115813e-2) }}, 
      {{ SC_(0.28e2), SC_(0.10074598388671875e4), SC_(0.5510168376335794400191425934521608161138e-3) }}, 
      {{ SC_(0.28e2), SC_(0.1185395751953125e4), SC_(-0.8246625896207856567855098443845597543213e-3) }}, 
      {{ SC_(0.31e2), SC_(0.177219114266335964202880859375e-2), SC_(0.450341646547891299535390843219020912013e-129) }}, 
      {{ SC_(0.31e2), SC_(0.22177286446094512939453125e-2), SC_(0.470842090012514886717204107032003775445e-126) }}, 
      {{ SC_(0.31e2), SC_(0.7444499991834163665771484375e-2), SC_(0.947580408373511644913421124194380763653e-110) }}, 
      {{ SC_(0.31e2), SC_(0.1433600485324859619140625e-1), SC_(0.6294863889266647462734778538906921935152e-101) }}, 
      {{ SC_(0.31e2), SC_(0.1760916970670223236083984375e-1), SC_(0.3695038114267496507939522005920002375773e-98) }}, 
      {{ SC_(0.31e2), SC_(0.6152711808681488037109375e-1), SC_(0.2574932433769852523604160840325816009115e-81) }}, 
      {{ SC_(0.31e2), SC_(0.11958599090576171875e0), SC_(0.2279063560902495195438276134818404109147e-72) }}, 
      {{ SC_(0.31e2), SC_(0.15262925624847412109375e0), SC_(0.4389431868285318525557770624833871905963e-69) }}, 
      {{ SC_(0.31e2), SC_(0.408089816570281982421875e0), SC_(0.7631094460061294051925710270654754371175e-56) }}, 
      {{ SC_(0.31e2), SC_(0.6540834903717041015625e0), SC_(0.1709677515111988969844896637060971018075e-49) }}, 
      {{ SC_(0.31e2), SC_(0.1097540378570556640625e1), SC_(0.1580249445297258620417855161882092111436e-42) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(0.1335793301744010082734635269241679829174e-28) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(0.6817791856987874676383799421199833859559e-22) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(0.9203901138410915625813992834509825352705e-14) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(0.8406280681224935795934794929715395020542e-3) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(-0.1444818405975203243678768179197624660225e-1) }}, 
      {{ SC_(0.31e2), SC_(0.1252804412841796875e3), SC_(-0.7286620250338267746409191133617323432711e-2) }}, 
      {{ SC_(0.31e2), SC_(0.25554705810546875e3), SC_(0.3899856018034826692215108576120608654257e-2) }}, 
      {{ SC_(0.31e2), SC_(0.503011474609375e3), SC_(0.449338424967868394115991409832934957202e-3) }}, 
      {{ SC_(0.31e2), SC_(0.10074598388671875e4), SC_(-0.8717559539209677259631192249054121075363e-3) }}, 
      {{ SC_(0.31e2), SC_(0.1185395751953125e4), SC_(-0.1152529652857399266204015514559382936477e-3) }}, 
      {{ SC_(0.34e2), SC_(0.177219114266335964202880859375e-2), SC_(0.8341353892742104953202036584429061316869e-143) }}, 
      {{ SC_(0.34e2), SC_(0.22177286446094512939453125e-2), SC_(0.1709083368431823229093966656933864266194e-139) }}, 
      {{ SC_(0.34e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1301024394676657908384032627920913316992e-121) }}, 
      {{ SC_(0.34e2), SC_(0.1433600485324859619140625e-1), SC_(0.6172108756115104932830157128831021920702e-112) }}, 
      {{ SC_(0.34e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6714263743502974327813570372355250793042e-109) }}, 
      {{ SC_(0.34e2), SC_(0.6152711808681488037109375e-1), SC_(0.1995856791943837590552573366995511140193e-90) }}, 
      {{ SC_(0.34e2), SC_(0.11958599090576171875e0), SC_(0.129707217890254721545720000632483663058e-80) }}, 
      {{ SC_(0.34e2), SC_(0.15262925624847412109375e0), SC_(0.5193869134795032962568000095527078749841e-77) }}, 
      {{ SC_(0.34e2), SC_(0.408089816570281982421875e0), SC_(0.1726091724796837804929664943698047951843e-62) }}, 
      {{ SC_(0.34e2), SC_(0.6540834903717041015625e0), SC_(0.159256552301312364196983011108506591544e-55) }}, 
      {{ SC_(0.34e2), SC_(0.1097540378570556640625e1), SC_(0.6958091265932025190103005038260913661135e-48) }}, 
      {{ SC_(0.34e2), SC_(0.30944411754608154296875e1), SC_(0.1325440331216567038955043585624653119631e-32) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(0.3086962993481446627387430878220817161574e-25) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(0.279604214924886058777382343649124639512e-16) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(0.7038787062356070483319562476809157144813e-4) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(0.1519325647788089234580260703583525837011e-1) }}, 
      {{ SC_(0.34e2), SC_(0.1252804412841796875e3), SC_(0.7738483029713573041966191162279749778184e-2) }}, 
      {{ SC_(0.34e2), SC_(0.25554705810546875e3), SC_(-0.1042268883854291209522496599816470859589e-2) }}, 
      {{ SC_(0.34e2), SC_(0.503011474609375e3), SC_(-0.1989426073012910695491145157911143175164e-2) }}, 
      {{ SC_(0.34e2), SC_(0.10074598388671875e4), SC_(-0.3873351426227495385942642664561499860392e-3) }}, 
      {{ SC_(0.34e2), SC_(0.1185395751953125e4), SC_(0.8425716719657403986065664237808586888143e-3) }}, 
      {{ SC_(0.37e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1194333902828176431081258465331146785745e-156) }}, 
      {{ SC_(0.37e2), SC_(0.22177286446094512939453125e-2), SC_(0.4795633604010179229986966798665208492453e-153) }}, 
      {{ SC_(0.37e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1380859786119863368217815850587088834151e-133) }}, 
      {{ SC_(0.37e2), SC_(0.1433600485324859619140625e-1), SC_(0.4678165316034431036960541572672838540796e-123) }}, 
      {{ SC_(0.37e2), SC_(0.1760916970670223236083984375e-1), SC_(0.9431323362026060346441278627232299466235e-120) }}, 
      {{ SC_(0.37e2), SC_(0.6152711808681488037109375e-1), SC_(0.1195879789201307779177368623226181252951e-99) }}, 
      {{ SC_(0.37e2), SC_(0.11958599090576171875e0), SC_(0.5706449780423923474316135603718910535834e-89) }}, 
      {{ SC_(0.37e2), SC_(0.15262925624847412109375e0), SC_(0.4750807641084782624583571645639875576794e-85) }}, 
      {{ SC_(0.37e2), SC_(0.408089816570281982421875e0), SC_(0.3018063419569773907826218055899342783603e-69) }}, 
      {{ SC_(0.37e2), SC_(0.6540834903717041015625e0), SC_(0.114671731226423949814916448453528829483e-61) }}, 
      {{ SC_(0.37e2), SC_(0.1097540378570556640625e1), SC_(0.2368079824048013481072401097915651323377e-53) }}, 
      {{ SC_(0.37e2), SC_(0.30944411754608154296875e1), SC_(0.1015669125945783729952707403931897463544e-36) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(0.1077570423204979083061012765900776333959e-28) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(0.6503015570957313806850401490553942274495e-19) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(0.4131272479370448839518852164409687678328e-5) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(-0.1689985813234713962976503000830873800688e-1) }}, 
      {{ SC_(0.37e2), SC_(0.1252804412841796875e3), SC_(-0.4331036498034980712992345228610856025587e-2) }}, 
      {{ SC_(0.37e2), SC_(0.25554705810546875e3), SC_(-0.3028547457000298970847409674877937134343e-2) }}, 
      {{ SC_(0.37e2), SC_(0.503011474609375e3), SC_(0.3644030566956990427127870072394715592528e-3) }}, 
      {{ SC_(0.37e2), SC_(0.10074598388671875e4), SC_(0.9504704692090138501500029850106080789549e-3) }}, 
      {{ SC_(0.37e2), SC_(0.1185395751953125e4), SC_(-0.3174121444895938735016063242693231015462e-4) }}, 
      {{ SC_(0.4e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1349132519814897141545380723282945134739e-170) }}, 
      {{ SC_(0.4e2), SC_(0.22177286446094512939453125e-2), SC_(0.106161825600796974715747857778256365494e-166) }}, 
      {{ SC_(0.4e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1156254296163259779002302460360053861732e-145) }}, 
      {{ SC_(0.4e2), SC_(0.1433600485324859619140625e-1), SC_(0.2797416868342281344274593630970357327589e-134) }}, 
      {{ SC_(0.4e2), SC_(0.1760916970670223236083984375e-1), SC_(0.1045168952061520920476230994204419896363e-130) }}, 
      {{ SC_(0.4e2), SC_(0.6152711808681488037109375e-1), SC_(0.5653080665808000541561966051488700731662e-109) }}, 
      {{ SC_(0.4e2), SC_(0.11958599090576171875e0), SC_(0.1980646629246866754701297262378946575052e-97) }}, 
      {{ SC_(0.4e2), SC_(0.15262925624847412109375e0), SC_(0.3428330827878163446284470210708897774377e-93) }}, 
      {{ SC_(0.4e2), SC_(0.408089816570281982421875e0), SC_(0.4163194976372237202112486963801226702853e-76) }}, 
      {{ SC_(0.4e2), SC_(0.6540834903717041015625e0), SC_(0.6513888519665116964065443564271785448627e-68) }}, 
      {{ SC_(0.4e2), SC_(0.1097540378570556640625e1), SC_(0.6357709233470759944100999784732402088283e-59) }}, 
      {{ SC_(0.4e2), SC_(0.30944411754608154296875e1), SC_(0.6135535486449250123166310560643592708587e-41) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(0.2961329488432456251614333144034801018987e-32) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(0.118431318659248196855114613884608701832e-21) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(0.1782930906773170515093474082811039321474e-6) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(0.1762506910558869828086954812174717503353e-1) }}, 
      {{ SC_(0.4e2), SC_(0.1252804412841796875e3), SC_(-0.5125786045312195960751705287079621135715e-3) }}, 
      {{ SC_(0.4e2), SC_(0.25554705810546875e3), SC_(0.3597803112462359504172319683283900865428e-2) }}, 
      {{ SC_(0.4e2), SC_(0.503011474609375e3), SC_(0.1820695048737985932185260894452560274482e-2) }}, 
      {{ SC_(0.4e2), SC_(0.10074598388671875e4), SC_(0.1752013511159797068283377941007942320545e-3) }}, 
      {{ SC_(0.4e2), SC_(0.1185395751953125e4), SC_(-0.8360151263131336845006028348410474142665e-3) }}, 
      {{ SC_(0.43e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1223404364522471876386040503647069764552e-184) }}, 
      {{ SC_(0.43e2), SC_(0.22177286446094512939453125e-2), SC_(0.1886589122980017409865377547551417950166e-180) }}, 
      {{ SC_(0.43e2), SC_(0.7444499991834163665771484375e-2), SC_(0.7772195206450086612598421132633145706806e-158) }}, 
      {{ SC_(0.43e2), SC_(0.1433600485324859619140625e-1), SC_(0.1342843412144403056002696624893550210449e-145) }}, 
      {{ SC_(0.43e2), SC_(0.1760916970670223236083984375e-1), SC_(0.9297943886327958919090815356289191355617e-142) }}, 
      {{ SC_(0.43e2), SC_(0.6152711808681488037109375e-1), SC_(0.2145207465004238675455364046218459318412e-118) }}, 
      {{ SC_(0.43e2), SC_(0.11958599090576171875e0), SC_(0.5518666759303511453990791896942022227403e-106) }}, 
      {{ SC_(0.43e2), SC_(0.15262925624847412109375e0), SC_(0.1986021409119343250882888340048878096855e-101) }}, 
      {{ SC_(0.43e2), SC_(0.408089816570281982421875e0), SC_(0.4610065828371707886080984411603861015004e-83) }}, 
      {{ SC_(0.43e2), SC_(0.6540834903717041015625e0), SC_(0.2970291531223911689634747798962485121291e-74) }}, 
      {{ SC_(0.43e2), SC_(0.1097540378570556640625e1), SC_(0.1370119423055714744180026374929987956621e-64) }}, 
      {{ SC_(0.43e2), SC_(0.30944411754608154296875e1), SC_(0.297354822546642285914560953158328580393e-45) }}, 
      {{ SC_(0.43e2), SC_(0.51139926910400390625e1), SC_(0.6522100266019409770044623454800636241776e-36) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(0.1721161665321131684779827276882951985891e-24) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(0.5859244041710111729905151572270149812223e-8) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(-0.1353696759272298967044778067036814439029e-1) }}, 
      {{ SC_(0.43e2), SC_(0.1252804412841796875e3), SC_(0.4706471952825932298541627133673912851846e-2) }}, 
      {{ SC_(0.43e2), SC_(0.25554705810546875e3), SC_(-0.3013236362131892566197294262018369224863e-3) }}, 
      {{ SC_(0.43e2), SC_(0.503011474609375e3), SC_(-0.1233256918054408823768226078718921526159e-2) }}, 
      {{ SC_(0.43e2), SC_(0.10074598388671875e4), SC_(-0.9917026270512502832706583187232360041197e-3) }}, 
      {{ SC_(0.43e2), SC_(0.1185395751953125e4), SC_(0.2027733948184595880435953384346723574731e-3) }}, 
      {{ SC_(0.46e2), SC_(0.177219114266335964202880859375e-2), SC_(0.9040394104538269827502763858866574379154e-199) }}, 
      {{ SC_(0.46e2), SC_(0.22177286446094512939453125e-2), SC_(0.2732047194656667119666757426400199586458e-194) }}, 
      {{ SC_(0.46e2), SC_(0.7444499991834163665771484375e-2), SC_(0.4257316737171282042400835165934703549258e-170) }}, 
      {{ SC_(0.46e2), SC_(0.1433600485324859619140625e-1), SC_(0.5252855754628379568905352359955531795544e-157) }}, 
      {{ SC_(0.46e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6740455687930813305297333291280199789231e-153) }}, 
      {{ SC_(0.46e2), SC_(0.6152711808681488037109375e-1), SC_(0.6633691265009777819595520409458305226369e-128) }}, 
      {{ SC_(0.46e2), SC_(0.11958599090576171875e0), SC_(0.125303426149495589011380306130037125168e-114) }}, 
      {{ SC_(0.46e2), SC_(0.15262925624847412109375e0), SC_(0.937532932288203153989391220247481417114e-110) }}, 
      {{ SC_(0.46e2), SC_(0.408089816570281982421875e0), SC_(0.4159927057569031050063861406651463379403e-90) }}, 
      {{ SC_(0.46e2), SC_(0.6540834903717041015625e0), SC_(0.1103697915951208639745638619848387966328e-80) }}, 
      {{ SC_(0.46e2), SC_(0.1097540378570556640625e1), SC_(0.2405975820030826693648441346218826820867e-70) }}, 
      {{ SC_(0.46e2), SC_(0.30944411754608154296875e1), SC_(0.1173776299880355139751103170467745542721e-49) }}, 
      {{ SC_(0.46e2), SC_(0.51139926910400390625e1), SC_(0.1168965825562227495762644707320434058994e-39) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(0.2028596251539445836931564425730981539088e-27) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(0.1506307082149153247277810883442524835901e-9) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(0.9981390073397570470311862738222580946682e-3) }}, 
      {{ SC_(0.46e2), SC_(0.1252804412841796875e3), SC_(-0.7291170921230448995307745765159879879917e-2) }}, 
      {{ SC_(0.46e2), SC_(0.25554705810546875e3), SC_(-0.3240042995538310471851852251143813655283e-2) }}, 
      {{ SC_(0.46e2), SC_(0.503011474609375e3), SC_(-0.1180752496915180759015257303074531713751e-2) }}, 
      {{ SC_(0.46e2), SC_(0.10074598388671875e4), SC_(0.8112995649167475106523147339693999640721e-4) }}, 
      {{ SC_(0.46e2), SC_(0.1185395751953125e4), SC_(0.7908406619706603256943101136482675770749e-3) }}, 
      {{ SC_(0.49e2), SC_(0.177219114266335964202880859375e-2), SC_(0.5515546045969304722008600804322812862354e-213) }}, 
      {{ SC_(0.49e2), SC_(0.22177286446094512939453125e-2), SC_(0.326650164794020092365784924346435136517e-208) }}, 
      {{ SC_(0.49e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1925360407412391019857608682831977562776e-182) }}, 
      {{ SC_(0.49e2), SC_(0.1433600485324859619140625e-1), SC_(0.1696482510953376927277246087752612819038e-168) }}, 
      {{ SC_(0.49e2), SC_(0.1760916970670223236083984375e-1), SC_(0.4034367000095565704299813933456029116899e-164) }}, 
      {{ SC_(0.49e2), SC_(0.6152711808681488037109375e-1), SC_(0.1693655026076133877660970241165014704451e-137) }}, 
      {{ SC_(0.49e2), SC_(0.11958599090576171875e0), SC_(0.2348958117281878334841541282897547765415e-123) }}, 
      {{ SC_(0.49e2), SC_(0.15262925624847412109375e0), SC_(0.3654033502135831724309937917523935502668e-118) }}, 
      {{ SC_(0.49e2), SC_(0.408089816570281982421875e0), SC_(0.3099167637766167128925774129143043527408e-97) }}, 
      {{ SC_(0.49e2), SC_(0.6540834903717041015625e0), SC_(0.3385925104782587944340438218046569787901e-87) }}, 
      {{ SC_(0.49e2), SC_(0.1097540378570556640625e1), SC_(0.3488075239147121457577900092276265954556e-76) }}, 
      {{ SC_(0.49e2), SC_(0.30944411754608154296875e1), SC_(0.3823874600343831420393015688949984870929e-54) }}, 
      {{ SC_(0.49e2), SC_(0.51139926910400390625e1), SC_(0.1727893893654003330466257673489103445204e-43) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(0.1966295052177707644956458594445543297349e-30) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(0.3095382191507684987784237056495861811507e-11) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(0.158295373743556601533454490387052548217e-1) }}, 
      {{ SC_(0.49e2), SC_(0.1252804412841796875e3), SC_(0.82836746548166677824971194819851133652e-2) }}, 
      {{ SC_(0.49e2), SC_(0.25554705810546875e3), SC_(0.3644444755072188782636164173218495212912e-2) }}, 
      {{ SC_(0.49e2), SC_(0.503011474609375e3), SC_(0.1873650276195313552512971867889734167198e-2) }}, 
      {{ SC_(0.49e2), SC_(0.10074598388671875e4), SC_(0.96821173121543674370030596847704670817e-3) }}, 
      {{ SC_(0.49e2), SC_(0.1185395751953125e4), SC_(-0.3882928591259993124112306803057698639751e-3) }}, 
      {{ SC_(0.52e2), SC_(0.177219114266335964202880859375e-2), SC_(0.2810426956251312594726679498943253449939e-227) }}, 
      {{ SC_(0.52e2), SC_(0.22177286446094512939453125e-2), SC_(0.3261821586222305590688396082340930337197e-222) }}, 
      {{ SC_(0.52e2), SC_(0.7444499991834163665771484375e-2), SC_(0.7272282602335146322076473310722428705234e-195) }}, 
      {{ SC_(0.52e2), SC_(0.1433600485324859619140625e-1), SC_(0.4575999118312716040572653394509627667421e-180) }}, 
      {{ SC_(0.52e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2016713378994708224486485028173988784384e-175) }}, 
      {{ SC_(0.52e2), SC_(0.6152711808681488037109375e-1), SC_(0.3611413640730227943802279701896849784546e-147) }}, 
      {{ SC_(0.52e2), SC_(0.11958599090576171875e0), SC_(0.3677646815864905481023738513580609303132e-132) }}, 
      {{ SC_(0.52e2), SC_(0.15262925624847412109375e0), SC_(0.1189435235193540319708552300693475643205e-126) }}, 
      {{ SC_(0.52e2), SC_(0.408089816570281982421875e0), SC_(0.1928344047619157510429385225938387716745e-104) }}, 
      {{ SC_(0.52e2), SC_(0.6540834903717041015625e0), SC_(0.8675221916812243553880316898424564367176e-94) }}, 
      {{ SC_(0.52e2), SC_(0.1097540378570556640625e1), SC_(0.4223229826495542762298450140014968626056e-82) }}, 
      {{ SC_(0.52e2), SC_(0.30944411754608154296875e1), SC_(0.104005992095441008419804771706791846708e-58) }}, 
      {{ SC_(0.52e2), SC_(0.51139926910400390625e1), SC_(0.2131148367399257759519412699653606504304e-47) }}, 
      {{ SC_(0.52e2), SC_(0.95070552825927734375e1), SC_(0.1586614197158476471413308754970129553623e-33) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(0.5175370600854880940253656288662351415917e-13) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(-0.17532409288934115094263569459614392385e-1) }}, 
      {{ SC_(0.52e2), SC_(0.1252804412841796875e3), SC_(-0.81931089129677844005131776262320688731e-2) }}, 
      {{ SC_(0.52e2), SC_(0.25554705810546875e3), SC_(-0.8105943479828618683212783966808076515887e-3) }}, 
      {{ SC_(0.52e2), SC_(0.503011474609375e3), SC_(0.8559984069467296788733442052899950392641e-4) }}, 
      {{ SC_(0.52e2), SC_(0.10074598388671875e4), SC_(-0.3653807379369436466708861221542025660679e-3) }}, 
      {{ SC_(0.52e2), SC_(0.1185395751953125e4), SC_(-0.6931477169897557084753887842368702759482e-3) }}, 
      {{ SC_(0.55e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1208288753536924400989698078437356511703e-241) }}, 
      {{ SC_(0.55e2), SC_(0.22177286446094512939453125e-2), SC_(0.2748224243571374121394628637078216213795e-236) }}, 
      {{ SC_(0.55e2), SC_(0.7444499991834163665771484375e-2), SC_(0.2317629980513787136420907827650557993837e-207) }}, 
      {{ SC_(0.55e2), SC_(0.1433600485324859619140625e-1), SC_(0.104144686711366844962623177915396851023e-191) }}, 
      {{ SC_(0.55e2), SC_(0.1760916970670223236083984375e-1), SC_(0.8506043420003708373323912746376820821917e-187) }}, 
      {{ SC_(0.55e2), SC_(0.6152711808681488037109375e-1), SC_(0.6497467376347885988588920192401434832693e-157) }}, 
      {{ SC_(0.55e2), SC_(0.11958599090576171875e0), SC_(0.4858242908178906496481848927231899579715e-141) }}, 
      {{ SC_(0.55e2), SC_(0.15262925624847412109375e0), SC_(0.3266806562437370063677150237483657480669e-135) }}, 
      {{ SC_(0.55e2), SC_(0.408089816570281982421875e0), SC_(0.1012363516617469262510002411527525089154e-111) }}, 
      {{ SC_(0.55e2), SC_(0.6540834903717041015625e0), SC_(0.1875396080076928265201291332242100047049e-100) }}, 
      {{ SC_(0.55e2), SC_(0.1097540378570556640625e1), SC_(0.4314225131885992800618800784424280652408e-88) }}, 
      {{ SC_(0.55e2), SC_(0.30944411754608154296875e1), SC_(0.2386188946009811741115402149427915301942e-63) }}, 
      {{ SC_(0.55e2), SC_(0.51139926910400390625e1), SC_(0.2216092396198493700432387401826650688793e-51) }}, 
      {{ SC_(0.55e2), SC_(0.95070552825927734375e1), SC_(0.1077268775045601594715005289873066535698e-36) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(0.7145924372118157260136350067139292902786e-15) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(-0.9639150724102627821461487026096968045471e-2) }}, 
      {{ SC_(0.55e2), SC_(0.1252804412841796875e3), SC_(0.7613679890890913165510416348925798112055e-2) }}, 
      {{ SC_(0.55e2), SC_(0.25554705810546875e3), SC_(-0.2628460166452094563254227164509714721701e-2) }}, 
      {{ SC_(0.55e2), SC_(0.503011474609375e3), SC_(-0.1916611872581451277353556345649407783691e-2) }}, 
      {{ SC_(0.55e2), SC_(0.10074598388671875e4), SC_(-0.8532381652732649330426131075577885254381e-3) }}, 
      {{ SC_(0.55e2), SC_(0.1185395751953125e4), SC_(0.5715720651795509548926590280953054477066e-3) }}, 
      {{ SC_(0.58e2), SC_(0.177219114266335964202880859375e-2), SC_(0.442323764221339251671141303318431108478e-256) }}, 
      {{ SC_(0.58e2), SC_(0.22177286446094512939453125e-2), SC_(0.1971583791626620727195469420538567193962e-250) }}, 
      {{ SC_(0.58e2), SC_(0.7444499991834163665771484375e-2), SC_(0.6289100883677515415757195488104887078879e-220) }}, 
      {{ SC_(0.58e2), SC_(0.1433600485324859619140625e-1), SC_(0.2018177733122065474623739428744794685423e-203) }}, 
      {{ SC_(0.58e2), SC_(0.1760916970670223236083984375e-1), SC_(0.3054795320059194548696602856000938647052e-198) }}, 
      {{ SC_(0.58e2), SC_(0.6152711808681488037109375e-1), SC_(0.9953642739298005551795428591931462815948e-167) }}, 
      {{ SC_(0.58e2), SC_(0.11958599090576171875e0), SC_(0.546461267246679212639001052047785879468e-150) }}, 
      {{ SC_(0.58e2), SC_(0.15262925624847412109375e0), SC_(0.7639710377234199236097520431614621507318e-144) }}, 
      {{ SC_(0.58e2), SC_(0.408089816570281982421875e0), SC_(0.4525408091084346067559391415753234146623e-119) }}, 
      {{ SC_(0.58e2), SC_(0.6540834903717041015625e0), SC_(0.3452008641978455477403610949257595865265e-107) }}, 
      {{ SC_(0.58e2), SC_(0.1097540378570556640625e1), SC_(0.3752484512573063001603693690152615718616e-94) }}, 
      {{ SC_(0.58e2), SC_(0.30944411754608154296875e1), SC_(0.4660345641388563178171531149615009184069e-68) }}, 
      {{ SC_(0.58e2), SC_(0.51139926910400390625e1), SC_(0.1960863006295924933138482025108297330693e-55) }}, 
      {{ SC_(0.58e2), SC_(0.95070552825927734375e1), SC_(0.6213624017861198159027984879634566021036e-40) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(0.8252480997909935579863933179819188239925e-17) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(0.2016586308654754622690091357752537719812e-1) }}, 
      {{ SC_(0.58e2), SC_(0.1252804412841796875e3), SC_(-0.7017468118833063218312557452977246591573e-2) }}, 
      {{ SC_(0.58e2), SC_(0.25554705810546875e3), SC_(0.3961059662958721103739812991599937252217e-2) }}, 
      {{ SC_(0.58e2), SC_(0.503011474609375e3), SC_(0.1159722024061608331934095179228494399393e-2) }}, 
      {{ SC_(0.58e2), SC_(0.10074598388671875e4), SC_(0.6455961901963375666872388539662639143768e-3) }}, 
      {{ SC_(0.58e2), SC_(0.1185395751953125e4), SC_(0.5324640861533894098235525421246130031191e-3) }}, 
      {{ SC_(0.61e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1390063099953273001760976643829493412235e-270) }}, 
      {{ SC_(0.61e2), SC_(0.22177286446094512939453125e-2), SC_(0.1214235746891325324123447717603508906882e-264) }}, 
      {{ SC_(0.61e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1465067803501878545612089003565516614999e-232) }}, 
      {{ SC_(0.61e2), SC_(0.1433600485324859619140625e-1), SC_(0.3357425642907951097269617118707813745614e-215) }}, 
      {{ SC_(0.61e2), SC_(0.1760916970670223236083984375e-1), SC_(0.9418057496533460392723945550704596626117e-210) }}, 
      {{ SC_(0.61e2), SC_(0.6152711808681488037109375e-1), SC_(0.1309015102638367959763911559061398598334e-176) }}, 
      {{ SC_(0.61e2), SC_(0.11958599090576171875e0), SC_(0.5276720779633476596305457037624920158493e-159) }}, 
      {{ SC_(0.61e2), SC_(0.15262925624847412109375e0), SC_(0.1533750989168073201676611877485582641816e-152) }}, 
      {{ SC_(0.61e2), SC_(0.408089816570281982421875e0), SC_(0.1736609472559701112844257684577329098627e-126) }}, 
      {{ SC_(0.61e2), SC_(0.6540834903717041015625e0), SC_(0.5454707501690087691332936974401497393552e-114) }}, 
      {{ SC_(0.61e2), SC_(0.1097540378570556640625e1), SC_(0.2801873396633198777831566955045782029762e-100) }}, 
      {{ SC_(0.61e2), SC_(0.30944411754608154296875e1), SC_(0.7812083655684529175645698522139037522772e-73) }}, 
      {{ SC_(0.61e2), SC_(0.51139926910400390625e1), SC_(0.1488629979362386514563024050166990786373e-59) }}, 
      {{ SC_(0.61e2), SC_(0.95070552825927734375e1), SC_(0.3070674775920232104372515582146972644154e-43) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(0.8059317390853095912429339684297296887014e-19) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(0.2553438361299694660955712647272386491838e-1) }}, 
      {{ SC_(0.61e2), SC_(0.1252804412841796875e3), SC_(0.6702527215895999645298014803289940554868e-2) }}, 
      {{ SC_(0.61e2), SC_(0.25554705810546875e3), SC_(-0.2435818794268515565710215283462154963534e-2) }}, 
      {{ SC_(0.61e2), SC_(0.503011474609375e3), SC_(0.1113025090458558853547625070047439913018e-2) }}, 
      {{ SC_(0.61e2), SC_(0.10074598388671875e4), SC_(0.6282813469515595099026690750450965536512e-3) }}, 
      {{ SC_(0.61e2), SC_(0.1185395751953125e4), SC_(-0.7280704607550679547528319738669934801603e-3) }}
   }};

