/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli \
 *     --scli-exclude='broadMauBasic' MAU-MIB
 *
 * Derived from MAU-MIB:
 *   Management information for 802.3 MAUs.
 *   
 *   The following reference is used throughout
 *   this MIB module:
 *   
 *   [IEEE 802.3 Std] refers to:
 *      IEEE Std 802.3, 2002 Edition: 'IEEE Standard
 *      for Information technology -
 *      Telecommunications and information exchange
 *      between systems - Local and metropolitan
 *      area networks - Specific requirements -
 *      Part 3: Carrier sense multiple access with
 *      collision detection (CSMA/CD) access method
 *      and physical layer specifications', as
 *      amended by IEEE Std 802.3ae-2002:
 *      'Amendment: Media Access Control (MAC)
 *      Parameters, Physical Layer, and Management
 *      Parameters for 10 Gb/s Operation', August,
 *      2002.
 *   
 *   Of particular interest is Clause 30, '10Mb/s,
 *   100Mb/s, 1000Mb/s and 10 Gb/s Management'.
 *   
 *   Copyright (C) The Internet Society (2003).  This
 *   version of this MIB module is part of RFC 3636;
 *   see the RFC itself for full legal notices.
 *
 * Revision 2003-09-19 00:00:
 *   Updated to include support for 10 Gb/s MAUs.
 *   This resulted in the following revisions:
 *   - Added OBJECT-IDENTITY definitions for
 *     10 gigabit MAU types
 *   - Added fiberLC jack type to JackType TC
 *   - Extended ifMauTypeListBits with bits for
 *     the 10 gigabit MAU types
 *   - Added enumerations to ifMauMediaAvailable,
 *     and updated its DESCRIPTION to reflect
 *     behaviour at 10 Gb/s
 *   - Added 64-bit version of ifMauFalseCarriers
 *     and added mauIfGrpHCStats object group to
 *   
 *   
 *   
 *     contain the new object
 *   - Deprecated mauModIfCompl2 and replaced it
 *     with mauModIfCompl3, which includes the new
 *     object group
 *   
 *    This version published as RFC 3636.
 *
 * Revision 1999-08-24 04:00:
 *   This version published as RFC 2668.  Updated
 *   to include support for 1000 Mb/sec
 *   MAUs and flow control negotiation.
 *
 * Revision 1997-10-31 00:00:
 *   Version published as RFC 2239.
 *
 * Revision 1993-09-30 00:00:
 *   Initial version, published as RFC 1515.
 *
 * $Id: mau-mib.c 1788 2006-02-21 20:47:18Z schoenw $
 */

#include "mau-mib.h"

GNetSnmpEnum const mau_mib_enums_rpMauStatus[] = {
    { MAU_MIB_RPMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_RPMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_RPMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_RPMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_RPMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_RPMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_rpMauMediaAvailable[] = {
    { MAU_MIB_RPMAUMEDIAAVAILABLE_OTHER,          "other" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_UNKNOWN,        "unknown" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_AVAILABLE,      "available" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_NOTAVAILABLE,   "notAvailable" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTEFAULT,    "remoteFault" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_INVALIDSIGNAL,  "invalidSignal" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTEJABBER,   "remoteJabber" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTELINKLOSS, "remoteLinkLoss" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTETEST,     "remoteTest" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_OFFLINE,        "offline" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_AUTONEGERROR,   "autoNegError" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_rpMauJabberState[] = {
    { MAU_MIB_RPMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_RPMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_RPMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_RPMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauStatus[] = {
    { MAU_MIB_IFMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_IFMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_IFMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_IFMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_IFMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_IFMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauMediaAvailable[] = {
    { MAU_MIB_IFMAUMEDIAAVAILABLE_OTHER,          "other" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_UNKNOWN,        "unknown" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_AVAILABLE,      "available" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_NOTAVAILABLE,   "notAvailable" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTEFAULT,    "remoteFault" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_INVALIDSIGNAL,  "invalidSignal" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTEJABBER,   "remoteJabber" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTELINKLOSS, "remoteLinkLoss" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTETEST,     "remoteTest" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_OFFLINE,        "offline" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_AUTONEGERROR,   "autoNegError" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_PMDLINKFAULT,   "pmdLinkFault" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_WISFRAMELOSS,   "wisFrameLoss" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_WISSIGNALLOSS,  "wisSignalLoss" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_PCSLINKFAULT,   "pcsLinkFault" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_EXCESSIVEBER,   "excessiveBER" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_DXSLINKFAULT,   "dxsLinkFault" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_PXSLINKFAULT,   "pxsLinkFault" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauJabberState[] = {
    { MAU_MIB_IFMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_IFMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_IFMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_IFMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegAdminStatus[] = {
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_ENABLED,  "enabled" },
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_DISABLED, "disabled" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteSignaling[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_DETECTED,    "detected" },
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_NOTDETECTED, "notdetected" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegConfig[] = {
    { MAU_MIB_IFMAUAUTONEGCONFIG_OTHER,              "other" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_CONFIGURING,        "configuring" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_COMPLETE,           "complete" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_DISABLED,           "disabled" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_PARALLELDETECTFAIL, "parallelDetectFail" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRestart[] = {
    { MAU_MIB_IFMAUAUTONEGRESTART_RESTART,   "restart" },
    { MAU_MIB_IFMAUAUTONEGRESTART_NORESTART, "norestart" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultAdvertised[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultReceived[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};

GNetSnmpEnum const mau_mib_enums_JackType[] = {
    { MAU_MIB_JACKTYPE_OTHER,    "other" },
    { MAU_MIB_JACKTYPE_RJ45,     "rj45" },
    { MAU_MIB_JACKTYPE_RJ45S,    "rj45S" },
    { MAU_MIB_JACKTYPE_DB9,      "db9" },
    { MAU_MIB_JACKTYPE_BNC,      "bnc" },
    { MAU_MIB_JACKTYPE_FAUI,     "fAUI" },
    { MAU_MIB_JACKTYPE_MAUI,     "mAUI" },
    { MAU_MIB_JACKTYPE_FIBERSC,  "fiberSC" },
    { MAU_MIB_JACKTYPE_FIBERMIC, "fiberMIC" },
    { MAU_MIB_JACKTYPE_FIBERST,  "fiberST" },
    { MAU_MIB_JACKTYPE_TELCO,    "telco" },
    { MAU_MIB_JACKTYPE_MTRJ,     "mtrj" },
    { MAU_MIB_JACKTYPE_HSSDC,    "hssdc" },
    { MAU_MIB_JACKTYPE_FIBERLC,  "fiberLC" },
    { 0, NULL }
};


static guint32 const dot3MauTypeAUI[]
	= { MAU_MIB_DOT3MAUTYPEAUI };
static guint32 const dot3MauType10Base5[]
	= { MAU_MIB_DOT3MAUTYPE10BASE5 };
static guint32 const dot3MauTypeFoirl[]
	= { MAU_MIB_DOT3MAUTYPEFOIRL };
static guint32 const dot3MauType10Base2[]
	= { MAU_MIB_DOT3MAUTYPE10BASE2 };
static guint32 const dot3MauType10BaseT[]
	= { MAU_MIB_DOT3MAUTYPE10BASET };
static guint32 const dot3MauType10BaseFP[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFP };
static guint32 const dot3MauType10BaseFB[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFB };
static guint32 const dot3MauType10BaseFL[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFL };
static guint32 const dot3MauType10Broad36[]
	= { MAU_MIB_DOT3MAUTYPE10BROAD36 };
static guint32 const dot3MauType10BaseTHD[]
	= { MAU_MIB_DOT3MAUTYPE10BASETHD };
static guint32 const dot3MauType10BaseTFD[]
	= { MAU_MIB_DOT3MAUTYPE10BASETFD };
static guint32 const dot3MauType10BaseFLHD[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFLHD };
static guint32 const dot3MauType10BaseFLFD[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFLFD };
static guint32 const dot3MauType100BaseT4[]
	= { MAU_MIB_DOT3MAUTYPE100BASET4 };
static guint32 const dot3MauType100BaseTXHD[]
	= { MAU_MIB_DOT3MAUTYPE100BASETXHD };
static guint32 const dot3MauType100BaseTXFD[]
	= { MAU_MIB_DOT3MAUTYPE100BASETXFD };
static guint32 const dot3MauType100BaseFXHD[]
	= { MAU_MIB_DOT3MAUTYPE100BASEFXHD };
static guint32 const dot3MauType100BaseFXFD[]
	= { MAU_MIB_DOT3MAUTYPE100BASEFXFD };
static guint32 const dot3MauType100BaseT2HD[]
	= { MAU_MIB_DOT3MAUTYPE100BASET2HD };
static guint32 const dot3MauType100BaseT2FD[]
	= { MAU_MIB_DOT3MAUTYPE100BASET2FD };
static guint32 const dot3MauType1000BaseXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASEXHD };
static guint32 const dot3MauType1000BaseXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASEXFD };
static guint32 const dot3MauType1000BaseLXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASELXHD };
static guint32 const dot3MauType1000BaseLXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASELXFD };
static guint32 const dot3MauType1000BaseSXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASESXHD };
static guint32 const dot3MauType1000BaseSXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASESXFD };
static guint32 const dot3MauType1000BaseCXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASECXHD };
static guint32 const dot3MauType1000BaseCXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASECXFD };
static guint32 const dot3MauType1000BaseTHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASETHD };
static guint32 const dot3MauType1000BaseTFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASETFD };
static guint32 const dot3MauType10GigBaseX[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASEX };
static guint32 const dot3MauType10GigBaseLX4[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASELX4 };
static guint32 const dot3MauType10GigBaseR[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASER };
static guint32 const dot3MauType10GigBaseER[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASEER };
static guint32 const dot3MauType10GigBaseLR[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASELR };
static guint32 const dot3MauType10GigBaseSR[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASESR };
static guint32 const dot3MauType10GigBaseW[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASEW };
static guint32 const dot3MauType10GigBaseEW[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASEEW };
static guint32 const dot3MauType10GigBaseLW[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASELW };
static guint32 const dot3MauType10GigBaseSW[]
	= { MAU_MIB_DOT3MAUTYPE10GIGBASESW };

GNetSnmpIdentity const mau_mib_identities[] = {
    { dot3MauTypeAUI,
      G_N_ELEMENTS(dot3MauTypeAUI),
      "dot3MauTypeAUI" },
    { dot3MauType10Base5,
      G_N_ELEMENTS(dot3MauType10Base5),
      "dot3MauType10Base5" },
    { dot3MauTypeFoirl,
      G_N_ELEMENTS(dot3MauTypeFoirl),
      "dot3MauTypeFoirl" },
    { dot3MauType10Base2,
      G_N_ELEMENTS(dot3MauType10Base2),
      "dot3MauType10Base2" },
    { dot3MauType10BaseT,
      G_N_ELEMENTS(dot3MauType10BaseT),
      "dot3MauType10BaseT" },
    { dot3MauType10BaseFP,
      G_N_ELEMENTS(dot3MauType10BaseFP),
      "dot3MauType10BaseFP" },
    { dot3MauType10BaseFB,
      G_N_ELEMENTS(dot3MauType10BaseFB),
      "dot3MauType10BaseFB" },
    { dot3MauType10BaseFL,
      G_N_ELEMENTS(dot3MauType10BaseFL),
      "dot3MauType10BaseFL" },
    { dot3MauType10Broad36,
      G_N_ELEMENTS(dot3MauType10Broad36),
      "dot3MauType10Broad36" },
    { dot3MauType10BaseTHD,
      G_N_ELEMENTS(dot3MauType10BaseTHD),
      "dot3MauType10BaseTHD" },
    { dot3MauType10BaseTFD,
      G_N_ELEMENTS(dot3MauType10BaseTFD),
      "dot3MauType10BaseTFD" },
    { dot3MauType10BaseFLHD,
      G_N_ELEMENTS(dot3MauType10BaseFLHD),
      "dot3MauType10BaseFLHD" },
    { dot3MauType10BaseFLFD,
      G_N_ELEMENTS(dot3MauType10BaseFLFD),
      "dot3MauType10BaseFLFD" },
    { dot3MauType100BaseT4,
      G_N_ELEMENTS(dot3MauType100BaseT4),
      "dot3MauType100BaseT4" },
    { dot3MauType100BaseTXHD,
      G_N_ELEMENTS(dot3MauType100BaseTXHD),
      "dot3MauType100BaseTXHD" },
    { dot3MauType100BaseTXFD,
      G_N_ELEMENTS(dot3MauType100BaseTXFD),
      "dot3MauType100BaseTXFD" },
    { dot3MauType100BaseFXHD,
      G_N_ELEMENTS(dot3MauType100BaseFXHD),
      "dot3MauType100BaseFXHD" },
    { dot3MauType100BaseFXFD,
      G_N_ELEMENTS(dot3MauType100BaseFXFD),
      "dot3MauType100BaseFXFD" },
    { dot3MauType100BaseT2HD,
      G_N_ELEMENTS(dot3MauType100BaseT2HD),
      "dot3MauType100BaseT2HD" },
    { dot3MauType100BaseT2FD,
      G_N_ELEMENTS(dot3MauType100BaseT2FD),
      "dot3MauType100BaseT2FD" },
    { dot3MauType1000BaseXHD,
      G_N_ELEMENTS(dot3MauType1000BaseXHD),
      "dot3MauType1000BaseXHD" },
    { dot3MauType1000BaseXFD,
      G_N_ELEMENTS(dot3MauType1000BaseXFD),
      "dot3MauType1000BaseXFD" },
    { dot3MauType1000BaseLXHD,
      G_N_ELEMENTS(dot3MauType1000BaseLXHD),
      "dot3MauType1000BaseLXHD" },
    { dot3MauType1000BaseLXFD,
      G_N_ELEMENTS(dot3MauType1000BaseLXFD),
      "dot3MauType1000BaseLXFD" },
    { dot3MauType1000BaseSXHD,
      G_N_ELEMENTS(dot3MauType1000BaseSXHD),
      "dot3MauType1000BaseSXHD" },
    { dot3MauType1000BaseSXFD,
      G_N_ELEMENTS(dot3MauType1000BaseSXFD),
      "dot3MauType1000BaseSXFD" },
    { dot3MauType1000BaseCXHD,
      G_N_ELEMENTS(dot3MauType1000BaseCXHD),
      "dot3MauType1000BaseCXHD" },
    { dot3MauType1000BaseCXFD,
      G_N_ELEMENTS(dot3MauType1000BaseCXFD),
      "dot3MauType1000BaseCXFD" },
    { dot3MauType1000BaseTHD,
      G_N_ELEMENTS(dot3MauType1000BaseTHD),
      "dot3MauType1000BaseTHD" },
    { dot3MauType1000BaseTFD,
      G_N_ELEMENTS(dot3MauType1000BaseTFD),
      "dot3MauType1000BaseTFD" },
    { dot3MauType10GigBaseX,
      G_N_ELEMENTS(dot3MauType10GigBaseX),
      "dot3MauType10GigBaseX" },
    { dot3MauType10GigBaseLX4,
      G_N_ELEMENTS(dot3MauType10GigBaseLX4),
      "dot3MauType10GigBaseLX4" },
    { dot3MauType10GigBaseR,
      G_N_ELEMENTS(dot3MauType10GigBaseR),
      "dot3MauType10GigBaseR" },
    { dot3MauType10GigBaseER,
      G_N_ELEMENTS(dot3MauType10GigBaseER),
      "dot3MauType10GigBaseER" },
    { dot3MauType10GigBaseLR,
      G_N_ELEMENTS(dot3MauType10GigBaseLR),
      "dot3MauType10GigBaseLR" },
    { dot3MauType10GigBaseSR,
      G_N_ELEMENTS(dot3MauType10GigBaseSR),
      "dot3MauType10GigBaseSR" },
    { dot3MauType10GigBaseW,
      G_N_ELEMENTS(dot3MauType10GigBaseW),
      "dot3MauType10GigBaseW" },
    { dot3MauType10GigBaseEW,
      G_N_ELEMENTS(dot3MauType10GigBaseEW),
      "dot3MauType10GigBaseEW" },
    { dot3MauType10GigBaseLW,
      G_N_ELEMENTS(dot3MauType10GigBaseLW),
      "dot3MauType10GigBaseLW" },
    { dot3MauType10GigBaseSW,
      G_N_ELEMENTS(dot3MauType10GigBaseSW),
      "dot3MauType10GigBaseSW" },
    { 0, 0, NULL }
};


static guint32 const rpMauJabberTrap[]
	= { MAU_MIB_RPMAUJABBERTRAP };
static guint32 const ifMauJabberTrap[]
	= { MAU_MIB_IFMAUJABBERTRAP };

GNetSnmpIdentity const mau_mib_notifications[] = {
    { rpMauJabberTrap,
      G_N_ELEMENTS(rpMauJabberTrap),
      "rpMauJabberTrap" },
    { ifMauJabberTrap,
      G_N_ELEMENTS(ifMauJabberTrap),
      "ifMauJabberTrap" },
    { 0, 0, NULL }
};


static guint32 const rpMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1};

static GNetSnmpAttribute rpMauEntry_attr[] = {
    { 4, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_RPMAUTYPE, "rpMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauType),
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, _rpMauTypeLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUSTATUS, "rpMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUMEDIAAVAILABLE, "rpMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailable),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUMEDIAAVAILABLESTATEEXITS, "rpMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailableStateExits),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPMAUJABBERSTATE, "rpMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberState),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUJABBERINGSTATEENTERS, "rpMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberingStateEnters),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_RPMAUFALSECARRIERS, "rpMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauFalseCarriers),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const rpJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1};

static GNetSnmpAttribute rpJackEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_RPJACKTYPE, "rpJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpJackEntry_t, rpJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1};

static GNetSnmpAttribute ifMauEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_IFMAUTYPE, "ifMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUSTATUS, "ifMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUMEDIAAVAILABLE, "ifMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailable),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUMEDIAAVAILABLESTATEEXITS, "ifMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailableStateExits),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUJABBERSTATE, "ifMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberState),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUJABBERINGSTATEENTERS, "ifMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberingStateEnters),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      MAU_MIB_IFMAUFALSECARRIERS, "ifMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauFalseCarriers),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUTYPELIST, "ifMauTypeList",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeList),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      MAU_MIB_IFMAUDEFAULTTYPE, "ifMauDefaultType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauDefaultType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauDefaultTypeLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGSUPPORTED, "ifMauAutoNegSupported",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauAutoNegSupported),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUTYPELISTBITS, "ifMauTypeListBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeListBits),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeListBitsLength),
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_COUNTER64,
      MAU_MIB_IFMAUHCFALSECARRIERS, "ifMauHCFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauHCFalseCarriers),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1};

static GNetSnmpAttribute ifJackEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFJACKTYPE, "ifJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifJackEntry_t, ifJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauAutoNegEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1};

static GNetSnmpAttribute ifMauAutoNegEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGADMINSTATUS, "ifMauAutoNegAdminStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTESIGNALING, "ifMauAutoNegRemoteSignaling",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteSignaling),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCONFIG, "ifMauAutoNegConfig",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegConfig),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPABILITY, "ifMauAutoNegCapability",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapability),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISED, "ifMauAutoNegCapAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVED, "ifMauAutoNegCapReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceived),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGRESTART, "ifMauAutoNegRestart",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRestart),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPABILITYBITS, "ifMauAutoNegCapabilityBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapabilityBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapabilityBitsLength),
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITS, "ifMauAutoNegCapAdvertisedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertisedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapAdvertisedBitsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITS, "ifMauAutoNegCapReceivedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceivedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapReceivedBitsLength),
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED, "ifMauAutoNegRemoteFaultAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED, "ifMauAutoNegRemoteFaultReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultReceived),
      0,
      0 },
    { 0, 0, 0, NULL }
};


mau_mib_rpMauEntry_t *
mau_mib_new_rpMauEntry()
{
    mau_mib_rpMauEntry_t *rpMauEntry;

    rpMauEntry = (mau_mib_rpMauEntry_t *) g_malloc0(sizeof(mau_mib_rpMauEntry_t) + sizeof(gpointer));
    return rpMauEntry;
}

static inline int
unpack_rpMauEntry(GNetSnmpVarBind *vb, mau_mib_rpMauEntry_t *rpMauEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauGroupIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauGroupIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauPortIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauPortIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpMauEntry->rpMauIndex = vb->oid[idx++];
    if ((rpMauEntry->rpMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_rpMauEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    return idx;
}

static inline mau_mib_rpMauEntry_t *
assign_rpMauEntry(GList *vbl)
{
    mau_mib_rpMauEntry_t *rpMauEntry;
    char *p;

    rpMauEntry = mau_mib_new_rpMauEntry();
    p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
    * (GList **) p = vbl;

    if (unpack_rpMauEntry((GNetSnmpVarBind *) vbl->data, rpMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpMauEntry");
        g_free(rpMauEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, rpMauEntry_oid, G_N_ELEMENTS(rpMauEntry_oid),
                      rpMauEntry_attr, rpMauEntry);

    return rpMauEntry;
}

void
mau_mib_get_rpMauTable(GNetSnmp *s, mau_mib_rpMauEntry_t ***rpMauEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 0};

    *rpMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, rpMauEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *rpMauEntry = (mau_mib_rpMauEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_rpMauEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*rpMauEntry)[i] = assign_rpMauEntry(row->data);
        }
    }
}

void
mau_mib_get_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t **rpMauEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *rpMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, rpMauEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *rpMauEntry = assign_rpMauEntry(out);
    }
}

void
mau_mib_set_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t *rpMauEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauEntry->rpMauGroupIndex, rpMauEntry->rpMauPortIndex, rpMauEntry->rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, rpMauEntry_attr, mask, rpMauEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_rpMauEntry(mau_mib_rpMauEntry_t *rpMauEntry)
{
    GList *vbl;
    char *p;

    if (rpMauEntry) {
        p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(rpMauEntry);
    }
}

void
mau_mib_free_rpMauTable(mau_mib_rpMauEntry_t **rpMauEntry)
{
    int i;

    if (rpMauEntry) {
        for (i = 0; rpMauEntry[i]; i++) {
            mau_mib_free_rpMauEntry(rpMauEntry[i]);
        }
        g_free(rpMauEntry);
    }
}

mau_mib_rpJackEntry_t *
mau_mib_new_rpJackEntry()
{
    mau_mib_rpJackEntry_t *rpJackEntry;

    rpJackEntry = (mau_mib_rpJackEntry_t *) g_malloc0(sizeof(mau_mib_rpJackEntry_t) + sizeof(gpointer));
    return rpJackEntry;
}

static inline int
unpack_rpJackEntry(GNetSnmpVarBind *vb, mau_mib_rpJackEntry_t *rpJackEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauGroupIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauGroupIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauPortIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauPortIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpMauIndex = vb->oid[idx++];
    if ((rpJackEntry->rpMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    rpJackEntry->rpJackIndex = vb->oid[idx++];
    if ((rpJackEntry->rpJackIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_rpJackEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    base[idx++] = rpJackIndex;
    return idx;
}

static inline mau_mib_rpJackEntry_t *
assign_rpJackEntry(GList *vbl)
{
    mau_mib_rpJackEntry_t *rpJackEntry;
    char *p;

    rpJackEntry = mau_mib_new_rpJackEntry();
    p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
    * (GList **) p = vbl;

    if (unpack_rpJackEntry((GNetSnmpVarBind *) vbl->data, rpJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpJackEntry");
        g_free(rpJackEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, rpJackEntry_oid, G_N_ELEMENTS(rpJackEntry_oid),
                      rpJackEntry_attr, rpJackEntry);

    return rpJackEntry;
}

void
mau_mib_get_rpJackTable(GNetSnmp *s, mau_mib_rpJackEntry_t ***rpJackEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 0};

    *rpJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, rpJackEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *rpJackEntry = (mau_mib_rpJackEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_rpJackEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*rpJackEntry)[i] = assign_rpJackEntry(row->data);
        }
    }
}

void
mau_mib_get_rpJackEntry(GNetSnmp *s, mau_mib_rpJackEntry_t **rpJackEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, rpJackEntry_oid, sizeof(rpJackEntry_oid));
    len = pack_rpJackEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex, rpJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpJackEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *rpJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, rpJackEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *rpJackEntry = assign_rpJackEntry(out);
    }
}

void
mau_mib_free_rpJackEntry(mau_mib_rpJackEntry_t *rpJackEntry)
{
    GList *vbl;
    char *p;

    if (rpJackEntry) {
        p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(rpJackEntry);
    }
}

void
mau_mib_free_rpJackTable(mau_mib_rpJackEntry_t **rpJackEntry)
{
    int i;

    if (rpJackEntry) {
        for (i = 0; rpJackEntry[i]; i++) {
            mau_mib_free_rpJackEntry(rpJackEntry[i]);
        }
        g_free(rpJackEntry);
    }
}

mau_mib_ifMauEntry_t *
mau_mib_new_ifMauEntry()
{
    mau_mib_ifMauEntry_t *ifMauEntry;

    ifMauEntry = (mau_mib_ifMauEntry_t *) g_malloc0(sizeof(mau_mib_ifMauEntry_t) + sizeof(gpointer));
    return ifMauEntry;
}

static inline int
unpack_ifMauEntry(GNetSnmpVarBind *vb, mau_mib_ifMauEntry_t *ifMauEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifMauEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifMauEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifMauEntry->ifMauIndex = vb->oid[idx++];
    if ((ifMauEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifMauEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static inline mau_mib_ifMauEntry_t *
assign_ifMauEntry(GList *vbl)
{
    mau_mib_ifMauEntry_t *ifMauEntry;
    char *p;

    ifMauEntry = mau_mib_new_ifMauEntry();
    p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifMauEntry((GNetSnmpVarBind *) vbl->data, ifMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauEntry");
        g_free(ifMauEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifMauEntry_oid, G_N_ELEMENTS(ifMauEntry_oid),
                      ifMauEntry_attr, ifMauEntry);

    return ifMauEntry;
}

void
mau_mib_get_ifMauTable(GNetSnmp *s, mau_mib_ifMauEntry_t ***ifMauEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 0};

    *ifMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifMauEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifMauEntry = (mau_mib_ifMauEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifMauEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifMauEntry)[i] = assign_ifMauEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t **ifMauEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifMauEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifMauEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifMauEntry = assign_ifMauEntry(out);
    }
}

void
mau_mib_set_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t *ifMauEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauEntry->ifMauIfIndex, ifMauEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, ifMauEntry_attr, mask, ifMauEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_ifMauEntry(mau_mib_ifMauEntry_t *ifMauEntry)
{
    GList *vbl;
    char *p;

    if (ifMauEntry) {
        p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifMauEntry);
    }
}

void
mau_mib_free_ifMauTable(mau_mib_ifMauEntry_t **ifMauEntry)
{
    int i;

    if (ifMauEntry) {
        for (i = 0; ifMauEntry[i]; i++) {
            mau_mib_free_ifMauEntry(ifMauEntry[i]);
        }
        g_free(ifMauEntry);
    }
}

mau_mib_ifJackEntry_t *
mau_mib_new_ifJackEntry()
{
    mau_mib_ifJackEntry_t *ifJackEntry;

    ifJackEntry = (mau_mib_ifJackEntry_t *) g_malloc0(sizeof(mau_mib_ifJackEntry_t) + sizeof(gpointer));
    return ifJackEntry;
}

static inline int
unpack_ifJackEntry(GNetSnmpVarBind *vb, mau_mib_ifJackEntry_t *ifJackEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifJackEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifMauIndex = vb->oid[idx++];
    if ((ifJackEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifJackEntry->ifJackIndex = vb->oid[idx++];
    if ((ifJackEntry->ifJackIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifJackEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    base[idx++] = ifJackIndex;
    return idx;
}

static inline mau_mib_ifJackEntry_t *
assign_ifJackEntry(GList *vbl)
{
    mau_mib_ifJackEntry_t *ifJackEntry;
    char *p;

    ifJackEntry = mau_mib_new_ifJackEntry();
    p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifJackEntry((GNetSnmpVarBind *) vbl->data, ifJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifJackEntry");
        g_free(ifJackEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifJackEntry_oid, G_N_ELEMENTS(ifJackEntry_oid),
                      ifJackEntry_attr, ifJackEntry);

    return ifJackEntry;
}

void
mau_mib_get_ifJackTable(GNetSnmp *s, mau_mib_ifJackEntry_t ***ifJackEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 0};

    *ifJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifJackEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifJackEntry = (mau_mib_ifJackEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifJackEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifJackEntry)[i] = assign_ifJackEntry(row->data);
        }
    }
}

void
mau_mib_get_ifJackEntry(GNetSnmp *s, mau_mib_ifJackEntry_t **ifJackEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifJackEntry_oid, sizeof(ifJackEntry_oid));
    len = pack_ifJackEntry(base, ifMauIfIndex, ifMauIndex, ifJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifJackEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifJackEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifJackEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifJackEntry = assign_ifJackEntry(out);
    }
}

void
mau_mib_free_ifJackEntry(mau_mib_ifJackEntry_t *ifJackEntry)
{
    GList *vbl;
    char *p;

    if (ifJackEntry) {
        p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifJackEntry);
    }
}

void
mau_mib_free_ifJackTable(mau_mib_ifJackEntry_t **ifJackEntry)
{
    int i;

    if (ifJackEntry) {
        for (i = 0; ifJackEntry[i]; i++) {
            mau_mib_free_ifJackEntry(ifJackEntry[i]);
        }
        g_free(ifJackEntry);
    }
}

mau_mib_ifMauAutoNegEntry_t *
mau_mib_new_ifMauAutoNegEntry()
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;

    ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t *) g_malloc0(sizeof(mau_mib_ifMauAutoNegEntry_t) + sizeof(gpointer));
    return ifMauAutoNegEntry;
}

static inline int
unpack_ifMauAutoNegEntry(GNetSnmpVarBind *vb, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIfIndex = vb->oid[idx++];
    if ((ifMauAutoNegEntry->ifMauIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIndex = vb->oid[idx++];
    if ((ifMauAutoNegEntry->ifMauIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ifMauAutoNegEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static inline mau_mib_ifMauAutoNegEntry_t *
assign_ifMauAutoNegEntry(GList *vbl)
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;
    char *p;

    ifMauAutoNegEntry = mau_mib_new_ifMauAutoNegEntry();
    p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
    * (GList **) p = vbl;

    if (unpack_ifMauAutoNegEntry((GNetSnmpVarBind *) vbl->data, ifMauAutoNegEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauAutoNegEntry");
        g_free(ifMauAutoNegEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ifMauAutoNegEntry_oid, G_N_ELEMENTS(ifMauAutoNegEntry_oid),
                      ifMauAutoNegEntry_attr, ifMauAutoNegEntry);

    return ifMauAutoNegEntry;
}

void
mau_mib_get_ifMauAutoNegTable(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t ***ifMauAutoNegEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 0};

    *ifMauAutoNegEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, ifMauAutoNegEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(mau_mib_ifMauAutoNegEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ifMauAutoNegEntry)[i] = assign_ifMauAutoNegEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ifMauAutoNegEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ifMauAutoNegEntry = assign_ifMauAutoNegEntry(out);
    }
}

void
mau_mib_set_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauAutoNegEntry->ifMauIfIndex, ifMauAutoNegEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask, ifMauAutoNegEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
mau_mib_free_ifMauAutoNegEntry(mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    GList *vbl;
    char *p;

    if (ifMauAutoNegEntry) {
        p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ifMauAutoNegEntry);
    }
}

void
mau_mib_free_ifMauAutoNegTable(mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry)
{
    int i;

    if (ifMauAutoNegEntry) {
        for (i = 0; ifMauAutoNegEntry[i]; i++) {
            mau_mib_free_ifMauAutoNegEntry(ifMauAutoNegEntry[i]);
        }
        g_free(ifMauAutoNegEntry);
    }
}


