/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//this file shall be an include for all subfiles of this project.


#include "smspdu.h"
#include "memtypes.h"

#include "timeincl.h"
#include <termios.h>
#include <unistd.h>

#ifndef min
#define min(a,b) (a < b ? a : b)
#endif

#define AT_PREFIX        "AT"
#define AT_TEST_SUFFIX   "=?"
#define AT_WRITE_SUFFIX  "="
#define AT_READ_SUFFIX   "?"
#define AT_REPLY_SUFFIX  ": "

#define AT_CHARSET "+CSCS"
#define AT_SMSC    "+CSCA"
#define AT_SORTED_PB_ENTRY "^SPBG"
#define AT_READ_PB_ENTRY   "+CPBR"
#define AT_WRITE_PB_ENTRY  "+CPBW"

// Macro definitions which constructs correct form of AT command
// AT_TEST - Test command, returns AT - command specific information
// AT_WRITE - Write command, writes information to phone
// AT_READ - Read command, reads information from phone
// AT_REPLY_PREFIX - Reply prefix of AT - command
#define AT_TEST(at_command)          AT_PREFIX""at_command""AT_TEST_SUFFIX
#define AT_WRITE(at_command)         AT_PREFIX""at_command""AT_WRITE_SUFFIX
#define AT_READ(at_command)          AT_PREFIX""at_command""AT_READ_SUFFIX
#define AT_REPLY_PREFIX(at_command)  ""at_command""AT_REPLY_SUFFIX

//global variables
int mytty;
int VERBOSE_LEVEL;
char* PIN;

//functon declaration
//from help.c
void help(char *me);
void version();
//from scmxx.c (no direct text output anywhere else!!!)
void errexit(char *errmessage, ...);
void myprintf(int verbose_level, char *output, ...);
//from common.c
void new_at_command(char *at_command_p, char *addon_p);
void add_at_command(char *at_command_p, char *addon_p,...);
char** parse_at_stringlist (char* stringlist);
int check_return_code (char* output,
		       char* errorcode, size_t esize);
int verify_command (char* command, char* errorcode, size_t esize);
char* get_value (char* command);
//from ttyaccess.c
void set_ttyport(char* ttyport, char *newttyport);
speed_t tty_speed(char *newttyspeed);
char* tty_write_read (char *at_command_p);
void tty_write_command(const char *at_command_p);
int  tty_write_data (const char* data, size_t count);
int  tty_write (const char* data, size_t count, const char* finish);
char* tty_readline(void);
char* tty_read(char *at_command_p);
void tty_open (struct port_args_t* args);
void tty_close();
int open_myFile_ro(char* file);
int open_myFile_rw(char* file);
void close_myFile(int filedes);
//from numhandle.c
int numlen (long num);
int numtype (char* number);
unsigned int hexstr2int(char *hexstring, int length);
int is_number (char* string);
int is_pnumber (char* string, unsigned short positive_only);
int is_numfield (char* string);
//from action.c
int phone_init (void);
int command_echo (int enable);
int verbose_errors (int enable);
int pbook_select_mem (char* mem);
int sms_select_mem (char* mem, struct slot_range* r,
		    int* current_fill);
void set_smsc (char* smsnr);
void set_time ();
char* get_value (char* at);
char* get_vendor ();
char* get_model ();
char* get_revision ();
char* get_phoneserial ();
char* get_simserial ();
char* get_simid ();
char* get_operator ();
char* get_smsc ();
char* get_charset ();
int   set_charset(char *charset);
char* get_battery ();
char* get_signal_ber ();
struct tm* get_time ();
char* get_netstatus (unsigned int* areacode_p, unsigned int* cellid_p);
void info (char* file, int misc, int mem);

//from s35_files.c
void file_transfer_manage (int   action, char** files,
			   char* outfile, char* pipe,
			   char* mem, int slot);
void file_delete (char* ftype, int slot);
int file_detect_free_slot (char* ftype, int minimum, int maximum);
void file_send (char* file, char* ftype, int slot);
void file_get (char* file, char* ftype, int slot, char* pipe);

//from s35_pbook.c
void pbook_manage (int action, char* outfile,
		   char** files, char* phonebook);
void pbook_delete (char* phonebook);
void pbook_send_file (char* file, char* phonebook);
void pbook_get (char* file, char* phonebook);
int pbook_get_ranges (char* mem, int write, int* min, int* max, int* nrlen, int* txtlen);

//from s35_sms.c
void sms_manage (int action, char** files,
		 char* outfile, char* pipe,
		 struct parameters* myparams,
		 struct smsopts* mysmsopts);
void sms_delete_slot (int smsslot);
void sms_delete_all (struct sms_data** slist);
void sms_send_slot (int smsslot, char* smsnumber);
void sms_send_pdu (char* pdu, int direct);
void sms_send_pdu_all (struct sms_data** slist, char* number, int direct);
char* sms_pdu_create (char* file, char* text, char* number,
		      struct smsopts* mysmsopts);
int sms_get (struct sms_data** slist, size_t ssize, int slot, int mark_read);
void sms_print (FILE* filefd, char* pipe, struct sms_data* sms);
void sms_print_all (char* file, char* pipe, struct sms_data** slist);
void sms_get_direct (char* file, char* pipe);
