/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>

#include <config.h>
#ifdef HAVE_LANGINFO_H
#  include <langinfo.h>
#endif

char* get_system_charset () {
#ifdef NO_NL_LANGINFO
  return "ANSI_X3.4-1968";
#else
#  ifdef HAVE_LIBICONV
  /* The default implementation uses nl_langinfo(CODESET)
   * If this gives you problems with your mixture
   * of libc and libiconv, fix it here.
   */
#  endif
  return nl_langinfo(CODESET);
#endif
}
