/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helper.h"
#include "charsets.h"
#include <string.h>

char* pb_mask_chars (gsmchar_t* input) {
  char* retval;
  unsigned int i;
  unsigned int off = 0;

  retval=mem_alloc(strlen(input)*3,1);
  for (i=0; i<strlen(input); i++) {
    switch (*(input+i)&127) {
    case 0x00: // masking the at character
      *(retval+i+off++) = 0x5c;
      *(retval+i+off++) = 0x30;
      *(retval+i+off) = 0x30;
      break;
    case 0x08: //masking the o` sign
      *(retval+i+off++) = 0x5c;
      *(retval+i+off++) = 0x30;
      *(retval+i+off) = 0x38;
      break;
    case 0x0a: // deleting the newline character
    case 0x0d: // deleting the carriage return  character
      // these character make no sense in a phonebook entry
      --off;
      break;
    case 0x22: //masking the quote sign
      *(retval+i+off++) = 0x5c;
      *(retval+i+off++) = 0x32;
      *(retval+i+off) = 0x32;
      break;
    case 0x5c: //masking the mask character
      *(retval+i+off++) = 0x5c;
      *(retval+i+off++) = 0x35;
      *(retval+i+off) = 0x43;
      break;
    default:
      *(retval+i+off) = *(input+i)&127;
      break;
    }
  }
  *(retval+i+off)=0;
  return mem_realloc(retval,strlen(retval)+1);
}
