/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <helper.h>
#include <charsets.h>
#include "smscoding.h"

#include <string.h>

char* sms_data_gsm_encode (ucs4char_t* input, unsigned int* udl) {
  char* retval;
  gsmchar_t* temp;
  unsigned int state, inc, outc;
  unsigned char first, end;

  if (input == NULL || udl == NULL) {
    return NULL;
  }
  temp = convert_to_gsm(input);
  *udl = strlen(temp);

  retval = mem_alloc(((MAXSMSSIZE*7)/8)*2 + 1, 1);

  //7bit-GSM octet encoding
  state = 0;
  outc = 0;
  for (inc = 0; inc < *udl; ++inc) {
    if (state != 7) {
      state %= 8;
      //the character are 7bit
      //shifting dependent on state (0-7)
      first = ((temp[inc+1] & 0x7F) << (7-state)) & 0xFF;
      end = (temp[inc] & 0x7F) >> state;
      //storing as hexstring
      sprintf (retval + outc, "%02X", (first | end));
      outc += 2;
    }
    ++state;
  }

  mem_realloc(temp,0);
  return retval;
}

char* sms_data_ucs2_encode (ucs4char_t* input, unsigned int* udl) {
  char* retval;

  if (input == NULL || udl == NULL) return NULL;
  retval = convert_to_ucs2_hexstring(input);
  *udl = strlen(retval)/2;
  return retval;
}
