/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <charsets.h>
#include <helper.h>
#include "ucs2.h"

#include <stdio.h>
#include <string.h>

ucs2char_t* convert_to_ucs2 (ucs4char_t* input) {
  return (ucs2char_t*)convert_from_internal(ucs2_get_iconv_charset(),
					    input,
					    REPMODE_ESCAPE_CHARS);
}

char* convert_to_ucs2_hexstring (ucs4char_t* input) {
  char* retval;
  ucs2char_t* temp;
  unsigned int i;

  temp = convert_to_ucs2(input);
  retval = mem_alloc((ucs2len(temp)*2*sizeof(ucs2char_t))+1,1);
  for (i = 0; i < ucs2len(temp); ++i) {
    sprintf(retval+(4*i),"%04X",temp[i]);
  }
  mem_realloc(temp,0);
  return retval;
}
