/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "atcommand.h"
#include "helper.h"
#include "common.h"
#include "gtincl.h"

#include "string.h"

void keypad_dial_number (char* number) {
  char* keylist;
  char* ausgabe;
  char* temp;

  if (str_len(number) == 0) return;

  // enable keypad control from TE
  at_command_send(AT_GEN_TERM_CMODE,"2");
  //ignore response
  mem_realloc(at_read_line(),0);

  keylist = mem_alloc(strlen(number)+3,1);
  sprintf(keylist,"C%sS",number);
  temp = keylist;
  myprintf(0,_("Using dialing sequence %s.\n"),number);
  do {
    temp = at_gen_keypad(temp,1,0);
    ausgabe = at_read_line();
    if (at_line_type(ausgabe,NULL,NULL) != AT_RET_OK) {
      errexit("%s: %s\n", "Error", "dialing failed");
    }
    mem_realloc(ausgabe,0);
  } while (temp != NULL);
  mem_realloc(keylist,0);
}
