/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gtincl.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void* mem_realloc (void* oldpointer, size_t size) {
  void* retval;
    
  if ((retval=realloc(oldpointer,size))==NULL && size>0) {
    fprintf(stderr,"%s\n",_("Memory allocation failure"));
    exit(EXIT_FAILURE);
  }
  return retval;
}

void* mem_alloc (size_t size, short zero_it) {
  void* retval;

  retval=mem_realloc(NULL,size);
  if (zero_it) {
    memset(retval,0,size);
  }
  return retval;
}
