/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTYACCESS_H
#define TTYACCESS_H

#include "intincl.h"
#include <sys/types.h>

struct port_args_t {
  char* device;
  char* baud;
  uint8_t timeout;
  unsigned int ignorebits :1;
  unsigned int startdelay;
};

void tty_open (struct port_args_t* args);
void tty_close();

int  tty_write (const char* data, size_t count);
char* tty_read_line (int (*stop_condition)(const char*,const size_t));
void tty_flush ();

// \x1a represents Ctrl-Z (represents end of data stream)
#define tty_write_data(data,count) (tty_write(data,count) && tty_write("\x1a",1))

#endif
