<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS><TS version="1.1">
<context>
    <name></name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="21"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="35"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="50"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="64"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="77"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="94"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="106"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="22"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="46"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="88"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="101"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="111"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="55"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="96"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="108"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="117"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="128"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="141"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="152"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="162"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="173"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="185"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="196"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="206"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="218"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="226"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="233"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="241"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="249"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="256"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="21"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="31"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="41"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="51"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="61"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="71"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="81"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="91"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="102"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="113"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="124"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="134"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="145"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="155"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="165"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="177"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="189"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="200"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="209"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="83"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="101"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="135"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="165"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="23"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="35"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="48"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="59"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="69"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="80"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="89"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="98"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="107"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="118"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="126"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="141"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="153"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="166"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="177"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="187"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="199"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="24"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="33"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="43"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="62"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="71"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="83"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="92"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="105"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="118"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="131"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="144"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="157"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="170"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="182"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="194"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="208"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="222"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="236"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="250"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="263"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="275"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="287"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="300"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="311"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="320"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="329"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="338"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="26"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="43"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="60"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="75"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="90"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="108"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="128"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="149"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="165"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="177"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="193"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="211"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="227"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="240"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="252"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="26"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="36"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="45"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="54"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="65"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="78"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="91"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="100"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="110"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="123"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="132"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="141"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="151"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="167"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="181"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="198"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="22"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="33"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="43"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="53"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="63"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="73"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="83"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="96"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="110"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="121"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="132"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="143"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="157"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="169"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="181"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="43"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="80"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="23"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="35"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="45"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="55"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="67"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="79"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="89"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="100"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="110"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="120"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="132"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="146"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="159"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="173"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="186"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="199"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="211"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="223"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="236"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="250"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="261"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="272"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="282"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="295"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="308"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="325"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="338"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="352"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="365"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="379"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="394"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="406"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="21"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="34"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="47"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="61"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="69"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="83"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="95"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="106"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="21"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="33"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="45"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="57"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="124"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="127"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="264"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="2226"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../scribus/about.cpp" line="187"/>
        <source>&amp;About</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="304"/>
        <source>Contributions from:</source>
        <translation type="unfinished">Kontribusi dari:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="200"/>
        <source>A&amp;uthors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>German:</source>
        <translation type="obsolete">Jerman:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>French:</source>
        <translation type="obsolete">Perancis:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Ukrainian:</source>
        <translation type="obsolete">Ukrania:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Lithuanian:</source>
        <translation type="obsolete">Lithuania:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Polish:</source>
        <translation type="obsolete">Polandia:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Czech:</source>
        <translation type="obsolete">Cechnya:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Slovak:</source>
        <translation type="obsolete">Slovakia:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Norwegian:</source>
        <translation type="obsolete">Norwegia:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Russian:</source>
        <translation type="obsolete">Rusia:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="214"/>
        <source>&amp;Translations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="225"/>
        <source>&amp;Online</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="264"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="296"/>
        <source>Development Team:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="306"/>
        <source>Official Documentation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="310"/>
        <source>Other Documentation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="344"/>
        <source>Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="346"/>
        <source>Online Reference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="350"/>
        <source>Bugs and Feature Requests</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="354"/>
        <source>Mailing List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="328"/>
        <source>Official Translations and Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="330"/>
        <source>Previous Translation Contributors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="348"/>
        <source>Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="124"/>
        <source>%1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="132"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="182"/>
        <source>Using Ghostscript version %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="184"/>
        <source>No Ghostscript version available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Build ID:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="298"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="302"/>
        <source>Windows&amp;#174; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="316"/>
        <source>Tango Project Icons:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="228"/>
        <source>&amp;Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="276"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="300"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="314"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="272"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="273"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="274"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="275"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Scribus Version</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="648"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="646"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="352"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="239"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="248"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="308"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="312"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="624"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No</source>
        <translation type="obsolete">Tidak</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1254"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1255"/>
        <source>&amp;Open...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1256"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1258"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1259"/>
        <source>Re&amp;vert to Saved</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1260"/>
        <source>Collect for O&amp;utput...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1261"/>
        <source>Get Text...</source>
        <translation type="unfinished">Ambil Teks...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1262"/>
        <source>Append &amp;Text...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1263"/>
        <source>Get Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1266"/>
        <source>Save &amp;Text...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1268"/>
        <source>Save as P&amp;DF...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1269"/>
        <source>Document &amp;Setup...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1271"/>
        <source>&amp;Print...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1273"/>
        <source>&amp;Quit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Undo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1276"/>
        <source>&amp;Redo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Item Action Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1278"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1282"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1285"/>
        <source>Select &amp;All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1287"/>
        <source>&amp;Deselect All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1288"/>
        <source>&amp;Search/Replace...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1289"/>
        <source>Edit Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1291"/>
        <source>C&amp;olors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1295"/>
        <source>&amp;Master Pages...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1270"/>
        <source>P&amp;references...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1303"/>
        <source>%1 pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1305"/>
        <source>&amp;Other...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1306"/>
        <source>&amp;Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1307"/>
        <source>&amp;Center</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1308"/>
        <source>&amp;Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Block</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Forced</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1321"/>
        <source>&amp;Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1322"/>
        <source>&amp;Underline</source>
        <translation type="unfinished">&amp;Garis bawah</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1323"/>
        <source>Underline &amp;Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1324"/>
        <source>&amp;Strike Through</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;All Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1326"/>
        <source>Small &amp;Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1327"/>
        <source>Su&amp;perscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1328"/>
        <source>Su&amp;bscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1330"/>
        <source>S&amp;hadow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1332"/>
        <source>&amp;Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Tabulators...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1336"/>
        <source>D&amp;uplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Multiple Duplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1338"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1339"/>
        <source>&amp;Group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1340"/>
        <source>&amp;Ungroup</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1341"/>
        <source>Is &amp;Locked</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1342"/>
        <source>Si&amp;ze is Locked</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1346"/>
        <source>Lower to &amp;Bottom</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1347"/>
        <source>Raise to &amp;Top</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Lower</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Raise</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1350"/>
        <source>Send to S&amp;crapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Attributes...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1354"/>
        <source>I&amp;mage Visible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1355"/>
        <source>&amp;Update Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1356"/>
        <source>Adjust Frame to Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1358"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Low Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1360"/>
        <source>&amp;Normal Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1361"/>
        <source>&amp;Full Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1362"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1363"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1364"/>
        <source>Annotation P&amp;roperties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1365"/>
        <source>Field P&amp;roperties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1366"/>
        <source>&amp;Edit Shape...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1367"/>
        <source>&amp;Attach Text to Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1368"/>
        <source>&amp;Detach Text from Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1369"/>
        <source>&amp;Combine Polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1370"/>
        <source>Split &amp;Polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1374"/>
        <source>&amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Glyph...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1380"/>
        <source>Sample Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1384"/>
        <source>&amp;Insert...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1385"/>
        <source>Im&amp;port...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1386"/>
        <source>&amp;Delete...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1387"/>
        <source>&amp;Copy...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Move...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1389"/>
        <source>&amp;Apply Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1391"/>
        <source>Manage &amp;Guides...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1392"/>
        <source>Manage Page Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1397"/>
        <source>&amp;50%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1398"/>
        <source>&amp;75%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;100%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1400"/>
        <source>&amp;200%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1403"/>
        <source>Show &amp;Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1405"/>
        <source>Show &amp;Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show &amp;Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show G&amp;uides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Text Chain</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show Control Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1416"/>
        <source>Sn&amp;ap to Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1417"/>
        <source>Sna&amp;p to Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1422"/>
        <source>&amp;Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1424"/>
        <source>&amp;Scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1425"/>
        <source>&amp;Layers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Arrange Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Measurements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1429"/>
        <source>Action &amp;History</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1430"/>
        <source>Preflight &amp;Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Align and Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1433"/>
        <source>P&amp;DF Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1436"/>
        <source>Select Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1437"/>
        <source>Rotate Item</source>
        <translation type="unfinished">Putar Item</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1438"/>
        <source>Zoom in or out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1439"/>
        <source>Zoom in</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1440"/>
        <source>Zoom out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1441"/>
        <source>Edit Contents of Frame</source>
        <translation type="unfinished">Edit Isi Frame</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1442"/>
        <source>Edit Text...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1443"/>
        <source>Link Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1444"/>
        <source>Unlink Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1445"/>
        <source>&amp;Eye Dropper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1446"/>
        <source>Copy Item Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1469"/>
        <source>&amp;Hyphenate Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1470"/>
        <source>Dehyphenate Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1471"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;About Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1480"/>
        <source>About &amp;Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1481"/>
        <source>Toolti&amp;ps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1483"/>
        <source>Scribus &amp;Manual...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1501"/>
        <source>Smart &amp;Hyphen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1502"/>
        <source>Non Breaking Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1503"/>
        <source>Non Breaking &amp;Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1504"/>
        <source>Page &amp;Number</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1506"/>
        <source>New Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1507"/>
        <source>Frame Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1508"/>
        <source>Column Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1511"/>
        <source>Copyright</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1512"/>
        <source>Registered Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1513"/>
        <source>Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1515"/>
        <source>Bullet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1517"/>
        <source>Em Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1518"/>
        <source>En Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1519"/>
        <source>Figure Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1520"/>
        <source>Quotation Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1491"/>
        <source>Toggle Palettes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1492"/>
        <source>Toggle Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1272"/>
        <source>Print Previe&amp;w</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1296"/>
        <source>&amp;JavaScripts...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1390"/>
        <source>Convert to Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1474"/>
        <source>&amp;Cascade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Tile</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1353"/>
        <source>More Info...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Printing Enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Flip Horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1345"/>
        <source>&amp;Flip Vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Rulers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1423"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1514"/>
        <source>Solidus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1516"/>
        <source>Middle Dot</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1541"/>
        <source>En Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1542"/>
        <source>Em Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1543"/>
        <source>Thin Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1544"/>
        <source>Thick Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1545"/>
        <source>Mid Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1546"/>
        <source>Hair Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1558"/>
        <source>ff</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1559"/>
        <source>fi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1560"/>
        <source>fl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1561"/>
        <source>ffi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1562"/>
        <source>ffl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1563"/>
        <source>ft</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1564"/>
        <source>st</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>S&amp;tyles...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1283"/>
        <source>Paste (&amp;Absolute)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1284"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1461"/>
        <source>Insert PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1267"/>
        <source>Save as &amp;EPS...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Text Frame Columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Frame...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1402"/>
        <source>Preview Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1406"/>
        <source>Show Layer Indicators</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1293"/>
        <source>Patterns...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1351"/>
        <source>Send to Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1381"/>
        <source>Sticky Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1395"/>
        <source>&amp;Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1396"/>
        <source>Fit to Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1404"/>
        <source>Show Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1509"/>
        <source>&amp;Zero Width Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1510"/>
        <source>Zero Width NB Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1522"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1523"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1524"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1525"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1526"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1527"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1529"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1530"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1531"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1532"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1534"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1535"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1536"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1537"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1538"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1539"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;400%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1448"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1449"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1451"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1484"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1485"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1486"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1487"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1468"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1493"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1264"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1286"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1290"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1292"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1415"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1450"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1488"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1505"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1357"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>&amp;File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>Style</source>
        <translation type="unfinished">Gaya</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>&amp;Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>Page</source>
        <translation type="unfinished">Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>&amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>&amp;View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>&amp;Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>&amp;Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1871"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1873"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1875"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1482"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdvOptions</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Pilihan Advanced</translation>
    </message>
</context>
<context>
    <name>Align</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Distribute/Align</source>
        <translation type="obsolete">Sebar/Bariskan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Align</source>
        <translation type="obsolete">Bariskan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Horizontal</source>
        <translation type="obsolete">Horisontal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Left Sides</source>
        <translation type="obsolete">Sisi Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Middles</source>
        <translation type="obsolete">Tengah</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right Sides</source>
        <translation type="obsolete">Sisi Kanan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Vertical</source>
        <translation type="obsolete">Vertikal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Top Sides</source>
        <translation type="obsolete">Sisi Atas</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Bottom Sides</source>
        <translation type="obsolete">Sisi Bawah</translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Bariskan</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Align</source>
        <translation type="obsolete">Bariskan</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation type="unfinished">Bariskan</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation type="unfinished">Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="443"/>
        <source>Y: %1%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="451"/>
        <source>X: %1%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation type="unfinished">Bariskan Teks di Kiri</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation type="unfinished">Bariskan Teks di Kanan</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation type="unfinished">Bariskan Teks di Tengah</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation type="unfinished">Properti Field</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation type="unfinished">Tipe:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation type="unfinished">Tombol</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation type="unfinished">Field Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation type="unfinished">Kotak Cek</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation type="unfinished">Kotak Combo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation type="unfinished">Kotak Daftar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation type="unfinished">Properti</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation type="unfinished">Nama:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Tool-Tip:</source>
        <translation type="obsolete">Tool-Tip:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation type="unfinished">Batas</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation type="unfinished">Warna:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2087"/>
        <source>None</source>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation type="unfinished">Lebar:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation type="unfinished">Tipis</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation type="unfinished">Lebar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation type="unfinished">Solid</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation type="unfinished">Putus-putus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation type="unfinished">Garis Bawah</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation type="unfinished">Sisipan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation type="unfinished">Lainnya</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation type="unfinished">Hanya-Baca</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation type="unfinished">Dibutuhkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Don&apos;t Export Value</source>
        <translation type="obsolete">Jangan Mengekspor Nilai</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation type="unfinished">Visibilitas:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation type="unfinished">Tampak</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation type="unfinished">Tersembunyi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation type="unfinished">Tidak boleh Dicetak</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation type="unfinished">Tidak boleh Dilihat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation type="unfinished">Penampilan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation type="unfinished">Teks untuk Tombol Turun</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation type="unfinished">Teks untuk Roll Over</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation type="unfinished">Gunakan Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation type="unfinished">Hapus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation type="unfinished">Ditekan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation type="unfinished">Peletakan Ikon...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation type="unfinished">Balik</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation type="unfinished">Tekan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation type="unfinished">Banyak-Garis</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation type="unfinished">Kata kunci</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation type="unfinished">Batas dari</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation type="unfinished">Karakter</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation type="unfinished">Jangan Scroll</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation type="unfinished">Jangan Periksa Ejaan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation type="unfinished">Periksa Gaya:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation type="unfinished">Periksa</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation type="unfinished">Silang</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation type="unfinished">Berlian</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation type="unfinished">Lingkaran</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation type="unfinished">Bintang</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation type="unfinished">Persegi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation type="unfinished">Default Terpilih</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation type="unfinished">Bisa diedit</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Java Script</source>
        <translation type="obsolete">Java Script</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>Go To</source>
        <translation type="unfinished">Pergi Ke</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Submit Form</source>
        <translation type="unfinished">Kirim Formulir</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Reset Form</source>
        <translation type="unfinished">Reset Formulir</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Import Data</source>
        <translation type="unfinished">Impor Data</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation type="unfinished">Kejadian:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Up</source>
        <translation type="unfinished">Mouse Naik</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Down</source>
        <translation type="unfinished">Mouse Turun</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Enter</source>
        <translation type="unfinished">Mouse Enter</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>Mouse Exit</source>
        <translation type="unfinished">Mouse Keluar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Focus</source>
        <translation type="unfinished">Saat Fokus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Blur</source>
        <translation type="unfinished">Saat Blur</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation type="unfinished">Skrip:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1095"/>
        <source>Edit...</source>
        <translation type="unfinished">Edit...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation type="unfinished">Kirim ke URL:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="678"/>
        <source>Submit Data as HTML</source>
        <translation type="unfinished">Kirim Data sebagai HTML</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="691"/>
        <source>Import Data from:</source>
        <translation type="unfinished">Impor Data dari:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation type="unfinished">Tujuan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation type="unfinished">Ubah...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation type="unfinished">Halaman:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="700"/>
        <source>Action</source>
        <translation type="unfinished">Aksi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="731"/>
        <source>Field is formatted as:</source>
        <translation type="unfinished">Field diformat sebagai:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Plain</source>
        <translation type="unfinished">Biasa</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Number</source>
        <translation type="unfinished">Nomor</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Percentage</source>
        <translation type="unfinished">Persentasi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Date</source>
        <translation type="unfinished">Tanggal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Time</source>
        <translation type="unfinished">Waktu</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Custom</source>
        <translation type="unfinished">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="752"/>
        <source>Number Format</source>
        <translation type="unfinished">Format Penomoran</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="820"/>
        <source>Decimals:</source>
        <translation type="unfinished">Desimal:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="775"/>
        <source>Use Currency Symbol</source>
        <translation type="unfinished">Gunakan Simbol Mata Uang</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="784"/>
        <source>Prepend Currency Symbol</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="831"/>
        <source>Formatting</source>
        <translation type="unfinished">Pengaturan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="811"/>
        <source>Percent Format</source>
        <translation type="unfinished">Format Persen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="854"/>
        <source>Date Format</source>
        <translation type="unfinished">Format Tanggal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="880"/>
        <source>Time Format</source>
        <translation type="unfinished">Format Waktu</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="902"/>
        <source>Custom Scripts</source>
        <translation type="unfinished">Skrip Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="914"/>
        <source>Format:</source>
        <translation type="unfinished">Format:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="940"/>
        <source>Keystroke:</source>
        <translation type="unfinished">Kunci:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="964"/>
        <source>Format</source>
        <translation type="unfinished">Format</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="980"/>
        <source>Value is not validated</source>
        <translation type="unfinished">Nilai tidak divalidasi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="989"/>
        <source>Value must be greater than or equal to:</source>
        <translation type="unfinished">Nilai harus lebih besar atau sama dengan:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="993"/>
        <source>and less or equal to:</source>
        <translation type="unfinished">dan kurang dari atau sama dengan:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1004"/>
        <source>Custom validate script:</source>
        <translation type="unfinished">Skrip divalidasi sendiri:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1025"/>
        <source>Validate</source>
        <translation type="unfinished">Validasi</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1042"/>
        <source>Value is not calculated</source>
        <translation type="unfinished">Nilai tidak dihitung</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1051"/>
        <source>Value is the</source>
        <translation type="unfinished">Nilainya adalah</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>sum</source>
        <translation type="unfinished">jumlah</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>product</source>
        <translation type="unfinished">perkalian</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>average</source>
        <translation type="unfinished">rata-rata</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>minimum</source>
        <translation type="unfinished">minimum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1057"/>
        <source>maximum</source>
        <translation type="unfinished">maksimum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1064"/>
        <source>of the following fields:</source>
        <translation type="unfinished">dari field berikut:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1074"/>
        <source>Pick...</source>
        <translation type="unfinished">Ambil...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1079"/>
        <source>Custom calculation script:</source>
        <translation type="unfinished">Skrip perhitungan sendiri:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1099"/>
        <source>Calculate</source>
        <translation type="unfinished">Hitung</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1118"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1122"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1174"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1175"/>
        <source>Enter a comma separated list of fields here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1176"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation type="unfinished">Anda membutuhkan setidaknya Ikon untuk Normal untuk menggunakan Ikon untuk Tombol </translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1453"/>
        <source>Example:</source>
        <translation type="unfinished">Contoh:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2079"/>
        <source>Selection Change</source>
        <translation type="unfinished">Perubahan Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2088"/>
        <source>JavaScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>None</source>
        <comment>action</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1342"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1287"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation type="unfinished">Properti Anotasi</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation type="unfinished">Link</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation type="unfinished">Tujuan</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyT</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Apply Template</source>
        <translation type="obsolete">Terapkan Template</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <location filename="../arrowchooser.cpp" line="33"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="69"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="79"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="86"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="337"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="338"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="218"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="405"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="57"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="407"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="152"/>
        <source>&amp;Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="145"/>
        <source>Select one of the available barcode type here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="125"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="115"/>
        <source>Reset the barcode samples</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="90"/>
        <source>&amp;Include text in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="93"/>
        <source>Alt+I</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="87"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="77"/>
        <source>&amp;Guard whitespace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="80"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="74"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="168"/>
        <source>Colors</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="208"/>
        <source>&amp;Background</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="211"/>
        <source>Alt+B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="205"/>
        <source>Background color - under the code lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="240"/>
        <source>&amp;Lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="243"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="237"/>
        <source>Color of the lines in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="272"/>
        <source>&amp;Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="275"/>
        <source>Alt+T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="269"/>
        <source>Color of the text and numbers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="304"/>
        <source>Hints and help is shown here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="314"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="132"/>
        <source>Co&amp;de:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="64"/>
        <source>I&amp;nclude checksum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="67"/>
        <source>Alt+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="61"/>
        <source>Generate and include a checksum in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="51"/>
        <source>Incl&amp;ude checksum digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="54"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="48"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Format</translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation type="unfinished">Scrapbook</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation type="unfinished">Hapus</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Nama &quot;%1&quot; tidak unik.
Silakan pilih nama lain.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation type="unfinished">Obyek</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation type="unfinished">Entri Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished">Simpan sebagai...</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <location filename="../bookmwin.cpp" line="554"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Bookmark</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="219"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Pindahkan Bookmark</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="220"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Masukkan Bookmark</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="221"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation type="unfinished">Bookmark</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation type="unfinished">Tataletak:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation type="unfinished">Hanya Caption</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation type="unfinished">Hanya Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation type="unfinished">Caption di bawah Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation type="unfinished">Caption di atas Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation type="unfinished">Caption di kanan Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation type="unfinished">Caption di kiri Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation type="unfinished">Caption melapisi Ikon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation type="unfinished">Skala:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation type="unfinished">Selalu</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation type="unfinished">Jika Ikon terlalu kecil</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation type="unfinished">Jika Ikon terlalu besar</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation type="unfinished">Tidak pernah</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation type="unfinished">Proporsional</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation type="unfinished">Tidak Proporsional</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation type="unfinished">Reset</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Color Management Settings</source>
        <translation type="obsolete">Pengaturan Manajemen Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="34"/>
        <source>System Profiles</source>
        <translation type="obsolete">Profil Sistem</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="89"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Intensitas Rendering</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation type="unfinished">Colorimetric Relatif</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation type="unfinished">Saturasi</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation type="unfinished">Colorimetric Absolut</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="98"/>
        <source>Images:</source>
        <translation type="obsolete">Gambar:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Profil Sistem</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Intensitas Rendering</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Gambar:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation type="unfinished">Edit Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation type="unfinished">Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation type="unfinished">Tua</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation type="unfinished">Batang Warna Dinamis</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation type="unfinished">Batang Warna Statis</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CStyleP</name>
    <message>
        <location filename="../smcstylew.ui" line="109"/>
        <source>Colors</source>
        <translation type="obsolete">Warna</translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="488"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="47"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="54"/>
        <source>Result Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="311"/>
        <source>CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="532"/>
        <source>RGB</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="718"/>
        <source>HSV</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="108"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="118"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="144"/>
        <source>Angle:</source>
        <translation type="unfinished">Sudut:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="154"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="169"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="203"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="206"/>
        <source>&amp;Merge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="209"/>
        <source>Alt+M</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="216"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="219"/>
        <source>&amp;Replace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="222"/>
        <source>Alt+R</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="229"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="232"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="235"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="244"/>
        <source>Preview:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="268"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="287"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="294"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="331"/>
        <source>C:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="431"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="361"/>
        <source>M:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="391"/>
        <source>Y:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="421"/>
        <source>K:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="827"/>
        <source>RGB:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="674"/>
        <source>HSV:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="560"/>
        <source>R:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="587"/>
        <source>G:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="614"/>
        <source>B:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="863"/>
        <source>CMYK:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="746"/>
        <source>H:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="773"/>
        <source>S:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="800"/>
        <source>V:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="907"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Document</source>
        <translation type="obsolete">Dokumen</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2252"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2243"/>
        <source>X: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2245"/>
        <source>Y: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2260"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2262"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1822"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1852"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="226"/>
        <source>Choose a filename to open</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="256"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="298"/>
        <source>Cannot write file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="306"/>
        <source>Empty the Palette?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="307"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="24"/>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="272"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="205"/>
        <source>Full Character Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="210"/>
        <source>Basic Latin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="216"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="222"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="228"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="234"/>
        <source>General Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="240"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="246"/>
        <source>Currency Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="252"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="258"/>
        <source>Number Forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="264"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="270"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="276"/>
        <source>Box Drawing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="282"/>
        <source>Block Elements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="288"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="294"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="300"/>
        <source>Dingbats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="306"/>
        <source>Small Form Variants</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="312"/>
        <source>Ligatures</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="318"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="324"/>
        <source>Greek</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="330"/>
        <source>Greek Extended</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="336"/>
        <source>Cyrillic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="342"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="348"/>
        <source>Arabic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="354"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="360"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="366"/>
        <source>Hebrew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="181"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="184"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation type="unfinished">Tanpa Gaya</translation>
    </message>
</context>
<context>
    <name>CharTable</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete</source>
        <translation type="obsolete">Hapus</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation type="unfinished">Hapus</translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="869"/>
        <source>Current Profile:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="865"/>
        <source>Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="866"/>
        <source>Problems</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="877"/>
        <source>Glyphs missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="878"/>
        <source>Text overflow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="879"/>
        <source>Object is not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="880"/>
        <source>Missing Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="884"/>
        <source>Object has transparency</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="886"/>
        <source>Object is a placed PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="250"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="254"/>
        <source>No Problems found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="656"/>
        <source>Page </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="837"/>
        <source>Free Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="843"/>
        <source>Problems found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="863"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="885"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="870"/>
        <source>&amp;Ignore Errors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="871"/>
        <source>Check again</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="882"/>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="883"/>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="887"/>
        <source>Image is GIF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="255"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="276"/>
        <source>Transparency used</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="279"/>
        <source>Blendmode used</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="286"/>
        <source>Layer &quot;%1&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="888"/>
        <source>Annotation uses a non TrueType font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="873"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="874"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="875"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="881"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ChooseStyles</name>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="68"/>
        <source>Collecting...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="73"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="87"/>
        <source>Cannot collect the file: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="80"/>
        <source>&amp;Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="82"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="84"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="88"/>
        <source>D&amp;uplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="91"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="96"/>
        <source>&amp;Remove Unused</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="103"/>
        <source>Color Sets</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="109"/>
        <source>Current Color Set:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="140"/>
        <source>&amp;Save Color Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="159"/>
        <source>Choose a color set to load</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="160"/>
        <source>Save the current color set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="165"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="167"/>
        <source>Import colors to the current set from an existing document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="168"/>
        <source>Create a new color within the current set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="169"/>
        <source>Edit the currently selected color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="170"/>
        <source>Make a copy of the currently selected color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="171"/>
        <source>Delete the currently selected color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="172"/>
        <source>Make the current colorset the default color set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>Choose a Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Open</source>
        <translation type="obsolete">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="353"/>
        <source>Copy of %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="364"/>
        <source>New Color</source>
        <translation type="unfinished">Warna Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Import</source>
        <translation type="obsolete">Impor</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="173"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="311"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="312"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="224"/>
        <source>Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="206"/>
        <source>Monochromatic Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="209"/>
        <source>Monochromatic Dark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="216"/>
        <source>1st. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="217"/>
        <source>2nd. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="231"/>
        <source>1st. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="232"/>
        <source>2nd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="233"/>
        <source>3rd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="234"/>
        <source>4th. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="241"/>
        <source>1st. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="242"/>
        <source>2nd. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="249"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="250"/>
        <source>2nd. Tetradic (angle)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="251"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheelDialog</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Color</source>
        <translation type="obsolete">Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New Color</source>
        <translation type="obsolete">Warna Baru</translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="244"/>
        <source>&amp;Apply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="247"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="250"/>
        <source>None</source>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="254"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="257"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="260"/>
        <source>Warning</source>
        <translation type="unfinished">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <comment>color name</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="285"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation type="unfinished">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="291"/>
        <source>Single Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="292"/>
        <source>Double Sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="293"/>
        <source>3-Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="294"/>
        <source>4-Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Left Page</source>
        <translation type="obsolete">Halaman Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right Page</source>
        <translation type="obsolete">Halaman Kanan</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="330"/>
        <source>Monday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="331"/>
        <source>Tuesday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="332"/>
        <source>Wednesday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="333"/>
        <source>Thursday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="334"/>
        <source>Friday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="335"/>
        <source>Saturday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="336"/>
        <source>Sunday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="337"/>
        <source>January</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="338"/>
        <source>February</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="339"/>
        <source>March</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="340"/>
        <source>April</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="341"/>
        <source>May</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="342"/>
        <source>June</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="343"/>
        <source>July</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="344"/>
        <source>August</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="345"/>
        <source>September</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="346"/>
        <source>October</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="347"/>
        <source>November</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="348"/>
        <source>December</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="262"/>
        <source>Yes</source>
        <translation type="unfinished">Ya</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="263"/>
        <source>No</source>
        <translation type="unfinished">Tidak</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="264"/>
        <source>&amp;Yes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;No</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="301"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation type="unfinished">Halaman Kiri</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="302"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="305"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation type="unfinished">Halaman Kanan</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="308"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="310"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="312"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="314"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="356"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="357"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="358"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="359"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="360"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="362"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="316"/>
        <source>Solid Line</source>
        <translation type="unfinished">Garis Solid</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="317"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Garis Putus-putus</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="318"/>
        <source>Dotted Line</source>
        <translation type="unfinished">Garis Titik-titik</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="319"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Garis Putus Titik</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Garis Putus Titik Titik</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="364"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="365"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="366"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="367"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="368"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="369"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="372"/>
        <source>Min. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="373"/>
        <source>Max. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="376"/>
        <source>Min. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="377"/>
        <source>Max. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="350"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="351"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="352"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="353"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="354"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="381"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="267"/>
        <source>Text Frame</source>
        <translation type="unfinished">Frame Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="268"/>
        <source>Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="269"/>
        <source>Line</source>
        <translation type="unfinished">Garis</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="270"/>
        <source>Polygon</source>
        <translation type="unfinished">Poligon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="271"/>
        <source>Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="272"/>
        <source>Text on a Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="274"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="275"/>
        <source>PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="388"/>
        <source>PostScript Level 1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="394"/>
        <source>Windows GDI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="273"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="325"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Character Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="210"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="421"/>
        <source>Paste File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="454"/>
        <source>Delete Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="182"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation type="unfinished">Nama:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpagedialog.cpp" line="18"/>
        <source>New Master Page %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1001"/>
        <source>Shade:</source>
        <translation type="unfinished">Tingkat Kegelapan:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="985"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1002"/>
        <source>Opacity:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1020"/>
        <source>Normal</source>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1008"/>
        <source>Horizontal Gradient</source>
        <translation type="unfinished">Gradien Horisontal</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1009"/>
        <source>Vertical Gradient</source>
        <translation type="unfinished">Gradien Vertikal</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1010"/>
        <source>Diagonal Gradient</source>
        <translation type="unfinished">Gradien Diagonal</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1011"/>
        <source>Cross Diagonal Gradient</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1012"/>
        <source>Radial Gradient</source>
        <translation type="unfinished">Gradien Radial</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1013"/>
        <source>Free linear Gradient</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1014"/>
        <source>Free radial Gradient</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="984"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1038"/>
        <source>Edit Line Color Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1039"/>
        <source>Edit Fill Color Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1040"/>
        <source>Saturation of color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1041"/>
        <source>Normal or gradient fill method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1042"/>
        <source>Set the transparency for the color selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1003"/>
        <source>Move Vector</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1043"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1017"/>
        <source>Transparency Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1018"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1021"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1022"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1023"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1024"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1025"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1026"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1027"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1028"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1030"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1031"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1032"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1033"/>
        <source>Saturation</source>
        <translation type="unfinished">Saturasi</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1034"/>
        <source>Color</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1035"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="988"/>
        <source>Offsets</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="989"/>
        <source>X:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="991"/>
        <source>Y:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="993"/>
        <source>Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="998"/>
        <source>Rotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="999"/>
        <source>Angle</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1015"/>
        <source>Pattern</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1029"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="994"/>
        <source>X-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="996"/>
        <source>Y-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1036"/>
        <source>Display only used Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1044"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="52"/>
        <source>Printer Options</source>
        <translation type="unfinished">Pilihan Printer</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="143"/>
        <source>Page Set</source>
        <translation type="unfinished">Ketetapan Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="147"/>
        <source>All Pages</source>
        <translation type="unfinished">Semua Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="141"/>
        <source>Even Pages only</source>
        <translation type="unfinished">Halaman Genap saja</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="142"/>
        <source>Odd Pages only</source>
        <translation type="unfinished">Halaman Ganjil saja</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="160"/>
        <source>Mirror</source>
        <translation type="unfinished">Balik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No</source>
        <translation type="obsolete">Tidak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="177"/>
        <source>Orientation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="181"/>
        <source>Portrait</source>
        <translation type="unfinished">Tegak</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="175"/>
        <source>Landscape</source>
        <translation type="unfinished">Datar</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="197"/>
        <source>N-Up Printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="201"/>
        <source>Page per Sheet</source>
        <translation type="unfinished">Halaman per Lembar</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="196"/>
        <source>Pages per Sheet</source>
        <translation type="unfinished">Halaman per Lembar</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="63"/>
        <source>Option</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="64"/>
        <source>Value</source>
        <translation type="unfinished">Nilai</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="224"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="414"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Save as</source>
        <translation type="unfinished">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="483"/>
        <source>Cannot write the file: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="509"/>
        <source>Inverts the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="510"/>
        <source>Resets the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="511"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="512"/>
        <source>Loads a curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="513"/>
        <source>Saves this curve</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="327"/>
        <source>&amp;Compress File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Fonts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="355"/>
        <source>Encoding:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="366"/>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Pindah ke Direktori Dokumen anda.
Hal ini bisa diatur di Preferensi.</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="274"/>
        <source>Show Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="308"/>
        <source>&amp;Include Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="275"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="342"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="344"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="346"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="363"/>
        <source>Value:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="364"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="28"/>
        <source>Delete Color</source>
        <translation type="unfinished">Hapus Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Replace it with:</source>
        <translation type="obsolete">Gantikan dengan:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="36"/>
        <source>Delete Color:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="45"/>
        <source>Replace With:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation type="unfinished">Hapus Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete from:</source>
        <translation type="obsolete">Hapus dari:</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation type="unfinished">ke:</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelStyle</name>
    <message>
        <location filename="../editformats.cpp" line="49"/>
        <source>No Style</source>
        <translation type="obsolete">Tanpa Gaya</translation>
    </message>
</context>
<context>
    <name>DmF</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Missing Font</source>
        <translation type="obsolete">Font Hilang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>The Font %1 is not installed.</source>
        <translation type="obsolete">Font %1 belum terinstal.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Use</source>
        <translation type="obsolete">Gunakan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>instead</source>
        <translation type="obsolete">sebagai pengganti</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="160"/>
        <source>Importing failed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="161"/>
        <source>Importing Word document failed 
%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Keywords:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="61"/>
        <source>Descri&amp;ption:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="74"/>
        <source>P&amp;ublisher:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="81"/>
        <source>&amp;Contributors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="89"/>
        <source>Dat&amp;e:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="96"/>
        <source>T&amp;ype:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="103"/>
        <source>F&amp;ormat:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="110"/>
        <source>Identi&amp;fier:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="117"/>
        <source>&amp;Source:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Language:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Relation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="138"/>
        <source>Co&amp;verage:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="145"/>
        <source>Ri&amp;ghts:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="153"/>
        <source>Further &amp;Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="163"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="164"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="165"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="166"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="168"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="169"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="171"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="172"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="173"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="152"/>
        <source>Documen&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="159"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="160"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="161"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="162"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="167"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="170"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="79"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation type="unfinished">Gaya</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocSectionsBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Style</source>
        <translation type="obsolete">Gaya</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation type="unfinished">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation type="unfinished">Nilai</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributesBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="473"/>
        <source>Importing File:
%1
failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="474"/>
        <source>Fatal Error</source>
        <translation type="unfinished">Kesalahan Fatal</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="872"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="83"/>
        <source>Analyzing PostScript:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="479"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="871"/>
        <source>Converting of %1 images failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="738"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="80"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EditStyle</name>
    <message>
        <location filename="../edit1format.cpp" line="47"/>
        <source>Edit Style</source>
        <translation type="obsolete">Edit Gaya</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="80"/>
        <source>Character</source>
        <translation type="obsolete">Karakter</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Vertical Spaces</source>
        <translation type="obsolete">Spasi Vertikal</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="362"/>
        <source>Font Size</source>
        <translation type="obsolete">Ukuran Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name of the Style is not unique</source>
        <translation type="obsolete">Nama Gaya tidak unik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="328"/>
        <source>Background</source>
        <translation type="obsolete">Latar Belakang</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../scribus/editor.cpp" line="30"/>
        <source>Editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="36"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="39"/>
        <source>&amp;Open...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="41"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="43"/>
        <source>&amp;Save and Exit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="45"/>
        <source>&amp;Exit without Saving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="47"/>
        <source>&amp;Undo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="50"/>
        <source>&amp;Redo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="52"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="55"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="58"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="61"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="63"/>
        <source>&amp;Get Field Names</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="65"/>
        <source>&amp;File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="72"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="127"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="37"/>
        <source>Ctrl+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="48"/>
        <source>Ctrl+Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="53"/>
        <source>Ctrl+X</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="56"/>
        <source>Ctrl+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="59"/>
        <source>Ctrl-V</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="44"/>
        <source>Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="81"/>
        <source>Options:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="98"/>
        <source>Color:</source>
        <translation type="unfinished">Warna:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="109"/>
        <source>Shade:</source>
        <translation type="unfinished">Tingkat Kegelapan:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="125"/>
        <source>Brightness:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="147"/>
        <source>Contrast:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="198"/>
        <source>Radius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="180"/>
        <source>Value:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="216"/>
        <source>Posterize:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="500"/>
        <source>Available Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1393"/>
        <source>Blur</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1371"/>
        <source>Brightness</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1362"/>
        <source>Colorize</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1377"/>
        <source>Contrast</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="981"/>
        <source>Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="983"/>
        <source>Invert</source>
        <translation type="unfinished">Balik</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1406"/>
        <source>Posterize</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1383"/>
        <source>Sharpen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="482"/>
        <source>&gt;&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="486"/>
        <source>&lt;&lt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="497"/>
        <source>Effects in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="616"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="620"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="351"/>
        <source>Color 1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="371"/>
        <source>Color 2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="391"/>
        <source>Color 3:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="411"/>
        <source>Color 4:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1412"/>
        <source>Duotone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1448"/>
        <source>Tritone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1499"/>
        <source>Quadtone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1565"/>
        <source>Curves</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>File exists. Overwrite?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="205"/>
        <source>exists already. Overwrite?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>All</source>
        <translation type="obsolete">Semua</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Save as Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="192"/>
        <source>Insufficient memory for this image size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="219"/>
        <source>Error writing the output file(s).</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="39"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="102"/>
        <source>Normal</source>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="103"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="104"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="105"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="106"/>
        <source>Saturation</source>
        <translation type="unfinished">Saturasi</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="107"/>
        <source>Color</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="108"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="109"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="110"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="111"/>
        <source>Dissolve</source>
        <translation type="unfinished">Pecahkan</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="112"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="113"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="114"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="115"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="116"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="117"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="118"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="98"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="121"/>
        <source>Opacity:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="127"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="133"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Background</source>
        <translation type="obsolete">Latar Belakang</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="214"/>
        <source>Layers</source>
        <translation type="unfinished">Layer</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="267"/>
        <source>Don&apos;t use any Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="269"/>
        <source>Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="276"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="198"/>
        <source>Size:</source>
        <translation type="unfinished">Ukuran:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="216"/>
        <source>Title:</source>
        <translation type="unfinished">Judul:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="219"/>
        <source>No Title</source>
        <translation type="unfinished">Tidak Berjudul</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="221"/>
        <source>Author:</source>
        <translation type="unfinished">Penulis:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="229"/>
        <source>Unknown</source>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="231"/>
        <source>Scribus Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="205"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="226"/>
        <source>File Format:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Farbmanager</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Colors</source>
        <translation type="obsolete">Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Open</source>
        <translation type="obsolete">Buka</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New Color</source>
        <translation type="obsolete">Warna Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="593"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="597"/>
        <source> was replaced by: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="148"/>
        <source>Face:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation type="unfinished">Nama Font</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation type="unfinished">Gunakan Font</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation type="unfinished">Gaya</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation type="unfinished">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation type="unfinished">Format</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation type="unfinished">Font yang tersedia</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation type="unfinished">Substitusi Font</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation type="unfinished">Path Tambahan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation type="unfinished">Nama Font</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="57"/>
        <source>Use Font</source>
        <translation type="obsolete">Gunakan Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Embed in:</source>
        <translation type="obsolete">Masukkan ke dalam:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation type="unfinished">Penggantian</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="247"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="49"/>
        <source>Use Font</source>
        <comment>font preview</comment>
        <translation type="obsolete">Gunakan Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Embed in:</source>
        <comment>font preview</comment>
        <translation type="obsolete">Masukkan ke dalam:</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="130"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <comment>font preview</comment>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <comment>font preview</comment>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Text</source>
        <translation type="obsolete">Teks</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="327"/>
        <source>Position:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="328"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="336"/>
        <source>Add, change or remove color stops here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Atur Pemandu</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Horizontal Guides</source>
        <translation type="obsolete">Pemandu Horisontal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Vertical Guides</source>
        <translation type="obsolete">Pemandu Vertikal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Preview</source>
        <translation type="obsolete">Prapandang</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="31"/>
        <source>&amp;Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="146"/>
        <source>Horizontals</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="55"/>
        <source>&amp;Add</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="356"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="65"/>
        <source>D&amp;elete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="307"/>
        <source>Alt+E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="233"/>
        <source>Verticals</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="94"/>
        <source>A&amp;dd</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="97"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="104"/>
        <source>De&amp;lete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="122"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="119"/>
        <source>&amp;Lock Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="320"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="323"/>
        <source>Alt+Y</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="140"/>
        <source>&amp;Column/Row</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="152"/>
        <source>&amp;Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="175"/>
        <source>U&amp;se Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="178"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="275"/>
        <source>Refer To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="281"/>
        <source>&amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="343"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="294"/>
        <source>M&amp;argins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="304"/>
        <source>S&amp;election</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="239"/>
        <source>Nu&amp;mber:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="262"/>
        <source>Use &amp;Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="265"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="331"/>
        <source>&amp;Misc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="337"/>
        <source>Delete all guides from the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="340"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="350"/>
        <source>Delete all guides from the current document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="353"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="15"/>
        <source>Guide Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManagerBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Atur Pemandu</translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <location filename="../helpbrowser.cpp" line="343"/>
        <source>Link</source>
        <translation type="obsolete">Link</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="287"/>
        <source>Scribus Online Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="178"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="148"/>
        <source>&amp;Print...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Find</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Search Term:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="158"/>
        <source>&amp;Find...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Next</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="297"/>
        <source>Find &amp;Previous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Add Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="183"/>
        <source>D&amp;elete All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="291"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Quit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="715"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation type="unfinished">Terima</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation type="unfinished">Lewati</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="92"/>
        <source>Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="121"/>
        <source>Add a new Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Edit Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Exception List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No</source>
        <translation type="obsolete">Tidak</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation type="unfinished">Tegak</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation type="unfinished">Datar</translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation type="unfinished">Ukuran</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation type="unfinished">Prapandang</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation type="unfinished">Masukkan Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation type="unfinished">sebelum Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation type="unfinished">sesudah Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation type="unfinished">di Akhir</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Inserting</source>
        <translation type="obsolete">Memasukkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Template (Right Page):</source>
        <translation type="obsolete">Template (Halaman Kanan):</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="77"/>
        <source>&amp;Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="205"/>
        <source>Page Size</source>
        <translation type="unfinished">Ukuran Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="209"/>
        <source>&amp;Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="224"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="227"/>
        <source>Portrait</source>
        <translation type="unfinished">Tegak</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="228"/>
        <source>Landscape</source>
        <translation type="unfinished">Datar</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="233"/>
        <source>&amp;Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="240"/>
        <source>&amp;Height:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="245"/>
        <source>Move Objects with their Page</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="13"/>
        <source>Insert A Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="37"/>
        <source>T&amp;ype</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="75"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="85"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="116"/>
        <source>Polygon</source>
        <translation type="obsolete">Poligon</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="122"/>
        <source>&amp;Location</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="137"/>
        <source>Page Placement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="152"/>
        <source>Current Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="162"/>
        <source>All Pages</source>
        <translation type="unfinished">Semua Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="773"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="225"/>
        <source>Position of Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="240"/>
        <source>Top Left of Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="250"/>
        <source>Top Left of Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="260"/>
        <source>Top Left of Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="316"/>
        <source>X:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="309"/>
        <source>Y:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="379"/>
        <source>&amp;Size</source>
        <translation type="unfinished">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="409"/>
        <source>Same as the Page Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="419"/>
        <source>Same as the Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="429"/>
        <source>Same as the Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="439"/>
        <source>Same as the Imported Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="488"/>
        <source>Height:</source>
        <translation type="unfinished">Tinggi:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="495"/>
        <source>Width:</source>
        <translation type="unfinished">Lebar:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="558"/>
        <source>&amp;Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="759"/>
        <source>Source Image:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="813"/>
        <source>There are no options for this type of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="625"/>
        <source>Columns:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="611"/>
        <source>Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="697"/>
        <source>Source Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="172"/>
        <source>Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="270"/>
        <source>Custom Position</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="449"/>
        <source>Custom Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="72"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="82"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="134"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="149"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="159"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="169"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="187"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="222"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="237"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="247"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="257"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="267"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="323"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="330"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="406"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="416"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="426"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="436"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="446"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="502"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="509"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="601"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="618"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="649"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="652"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="661"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="664"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="680"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="704"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="766"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrameBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Polygon</source>
        <translation type="obsolete">Poligon</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Size</source>
        <translation type="obsolete">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Height:</source>
        <translation type="obsolete">Tinggi:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Width:</source>
        <translation type="obsolete">Lebar:</translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="27"/>
        <source>Edit JavaScripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="46"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="49"/>
        <source>&amp;Add...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="52"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="57"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="77"/>
        <source>&amp;New Script:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="78"/>
        <source>New Script</source>
        <translation type="unfinished">Skrip Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="71"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>KeyManager</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Keyboard Shortcuts</source>
        <translation type="obsolete">Atur Shortcut Keyboard</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Action</source>
        <translation type="obsolete">Aksi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Current Key</source>
        <translation type="obsolete">Kunci saat ini</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Select a Key for this Action</source>
        <translation type="obsolete">Pilih Kunci untuk Aksi ini</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="32"/>
        <source>Enter Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="44"/>
        <source>Update</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="51"/>
        <source>Revert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="130"/>
        <source>Program Messages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="181"/>
        <source>Status: Unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="165"/>
        <source>Kill Program</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="73"/>
        <source>Options</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="81"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="88"/>
        <source>Automatic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="91"/>
        <source> DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="104"/>
        <source>Program:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="116"/>
        <source>Use Preamble</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="330"/>
        <source>Status: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="334"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="336"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="339"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="518"/>
        <source>No item selected!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="520"/>
        <source>Insert symbol</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="13"/>
        <source>Editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="124"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="132"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="167"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="222"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="225"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="155"/>
        <source>Run external editor...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../scribus/layers.cpp" line="567"/>
        <source>Layers</source>
        <translation type="unfinished">Layer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Add a new Layer</source>
        <translation type="obsolete">Tambahkan Layer Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="290"/>
        <source>Delete Layer</source>
        <translation type="unfinished">Hapus Layer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Raise Layer</source>
        <translation type="obsolete">Naikkan Layer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Lower Layer</source>
        <translation type="obsolete">Turunkan Layer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New Layer</source>
        <translation type="obsolete">Layer Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="588"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="291"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="596"/>
        <source>Add a new layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="598"/>
        <source>Delete layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="599"/>
        <source>Raise layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="600"/>
        <source>Lower layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="586"/>
        <source>Opacity:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="587"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="568"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="570"/>
        <source>Normal</source>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="571"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="572"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="573"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="574"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="575"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="576"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="577"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="578"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="580"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="581"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="579"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="582"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="583"/>
        <source>Saturation</source>
        <translation type="unfinished">Saturasi</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="584"/>
        <source>Color</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="585"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="597"/>
        <source>Duplicates the current layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="603"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="604"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="605"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="606"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="607"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="608"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="609"/>
        <source>Name of the Layer - Double clicking on the name of a layer enabled editing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="601"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="602"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="5023"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="4993"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LineFormate</name>
    <message>
        <location filename="../lineformats.cpp" line="154"/>
        <source>New Style</source>
        <translation type="obsolete">Gaya Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Open</source>
        <translation type="obsolete">Buka</translation>
    </message>
</context>
<context>
    <name>LineStyleW</name>
    <message>
        <location filename="../smlinestylew.ui" line="208"/>
        <source>Line Width:</source>
        <translation type="obsolete">Lebar Garis:</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation type="unfinished">Penulis:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation type="unfinished">Ukuran Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation type="unfinished">Tegak</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation type="unfinished">Datar</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation type="unfinished">Tipe:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Pemandu Gari Tepi</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="43"/>
        <source>&amp;Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="45"/>
        <source>&amp;Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>&amp;Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>O&amp;utside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="33"/>
        <source>Preset Layouts:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="102"/>
        <source>Printer Margins...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="104"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="79"/>
        <source>Apply settings to:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="82"/>
        <source>All Document Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="86"/>
        <source>All Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="91"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="108"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Pemandu Gari Tepi</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="126"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="131"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="146"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="152"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="217"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="218"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="222"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="223"/>
        <source>Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="159"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="39"/>
        <source>Edit Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="116"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>New Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>Name:</source>
        <translation type="unfinished">Nama:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New MasterPage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="325"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="79"/>
        <source>Duplicate the selected master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="80"/>
        <source>Delete the selected master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="81"/>
        <source>Add a new master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="82"/>
        <source>Import master pages from another document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New Master Page %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>Unable to Rename Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>Rename Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>New Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="141"/>
        <source>Copy #%1 of %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="112"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Mdup</name>
    <message>
        <location filename="../mdup.cpp" line="29"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Penyalinan Banyak</translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>Measurements</name>
    <message>
        <location filename="../../scribus/measurements.cpp" line="127"/>
        <source>Distances</source>
        <translation type="obsolete">Jarak</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="135"/>
        <source>Angle:</source>
        <translation type="obsolete">Sudut:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="136"/>
        <source>Length:</source>
        <translation type="obsolete">Panjang:</translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/measurements.cpp" line="51"/>
        <source> °</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished">Jarak</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Panjang:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Sudut:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Change...</source>
        <translation type="obsolete">Ubah...</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>before Page</source>
        <translation type="obsolete">sebelum Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>after Page</source>
        <translation type="obsolete">sesudah Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>at End</source>
        <translation type="obsolete">di Akhir</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Import</source>
        <translation type="obsolete">Impor</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="72"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation type="unfinished">Font Hilang</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation type="unfinished">Font %1 belum terinstal.</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation type="unfinished">Gunakan</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="336"/>
        <source>instead</source>
        <translation type="unfinished">sebagai pengganti</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation type="unfinished">Alat bantu</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="121"/>
        <source>Properties...</source>
        <translation type="unfinished">Properti...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation type="unfinished">Pindah Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation type="unfinished">Salin Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation type="unfinished">Pindah Halaman:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>to:</source>
        <translation type="obsolete">ke:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>before Page</source>
        <translation type="obsolete">sebelum Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>after Page</source>
        <translation type="obsolete">sesudah Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>at End</source>
        <translation type="obsolete">di Akhir</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="58"/>
        <source>Number of copies:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiLine</name>
    <message>
        <location filename="../multiline.cpp" line="32"/>
        <source>Edit Style</source>
        <translation type="obsolete">Edit Gaya</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="100"/>
        <source>Line Width:</source>
        <translation type="obsolete">Lebar Garis:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Solid Line</source>
        <translation type="obsolete">Garis Solid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Dashed Line</source>
        <translation type="obsolete">Garis Putus-putus</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Dotted Line</source>
        <translation type="obsolete">Garis Titik-titik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Garis Putus Titik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Garis Putus Titik Titik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Nama &quot;%1&quot; tidak unik.
Silakan pilih nama lain.</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="112"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="165"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation type="unfinished">Penyalinan Banyak</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultipleDuplicateBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Penyalinan Banyak</translation>
    </message>
</context>
<context>
    <name>MusterPages</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Edit Templates</source>
        <translation type="obsolete">Edit Template</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New Template</source>
        <translation type="obsolete">Template Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name:</source>
        <translation type="obsolete">Nama:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
</context>
<context>
    <name>MusterSeiten</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Edit Templates</source>
        <translation type="obsolete">Edit Template</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New Template</source>
        <translation type="obsolete">Template Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name:</source>
        <translation type="obsolete">Nama:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <location filename="../../scribus/newfile.cpp" line="100"/>
        <source>New Document</source>
        <translation type="unfinished">Dokumen Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page Size</source>
        <translation type="obsolete">Ukuran Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="218"/>
        <source>&amp;Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Tabloid</source>
        <translation type="obsolete">Tabloid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="227"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="230"/>
        <source>Portrait</source>
        <translation type="unfinished">Tegak</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="231"/>
        <source>Landscape</source>
        <translation type="unfinished">Datar</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="237"/>
        <source>&amp;Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="243"/>
        <source>&amp;Height:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="259"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Pemandu Gari Tepi</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="278"/>
        <source>Options</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="291"/>
        <source>&amp;Default Unit:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Points (pts)</source>
        <translation type="obsolete">Point (pts)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Inches (in)</source>
        <translation type="obsolete">Inci (in)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Picas (p)</source>
        <translation type="obsolete">Picas (p)</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="301"/>
        <source>&amp;Automatic Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Column Guides</source>
        <translation type="obsolete">Pemandu Kolom</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="311"/>
        <source>&amp;Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="303"/>
        <source>Colu&amp;mns:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="140"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="141"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="142"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="143"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="145"/>
        <source>Default unit of measurement for document editing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="146"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="147"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="148"/>
        <source>Distance between automatically created columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="126"/>
        <source>Do not show this dialog again</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="144"/>
        <source>Initial number of pages of the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="285"/>
        <source>N&amp;umber of Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="356"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="110"/>
        <source>&amp;New Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="112"/>
        <source>Open &amp;Existing Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="115"/>
        <source>Open Recent &amp;Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="250"/>
        <source>First Page is:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="323"/>
        <source>Show Document Settings After Creation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="175"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="81"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewTm</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Left Page</source>
        <translation type="obsolete">Halaman Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right Page</source>
        <translation type="obsolete">Halaman Kanan</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="898"/>
        <source>Nodes</source>
        <translation type="unfinished">Node</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="901"/>
        <source>&amp;Absolute Coordinates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="904"/>
        <source>&amp;X-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="905"/>
        <source>&amp;Y-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>Edit &amp;Contour Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>&amp;Reset Contour Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>&amp;End Editing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Move Nodes</source>
        <translation type="unfinished">Pindahkan Node</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>Move Control Points</source>
        <translation type="unfinished">Pindahkan Titik Kontrol</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Add Nodes</source>
        <translation type="unfinished">Tambahkan Node</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Delete Nodes</source>
        <translation type="unfinished">Hapus Node</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>Move Control Points Independently</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Move Control Points Symmetrical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Reset Control Points</source>
        <translation type="unfinished">Reset Titik Kontrol</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Reset this Control Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Close this Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Mirror the Path Horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Mirror the Path Vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Shear the Path Vertically Up</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Shear the Path Vertically Down</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Rotate the Path Clockwise</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>Angle of Rotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="899"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="940"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>% to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>Set Contour to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="902"/>
        <source>to Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="297"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="613"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="96"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="111"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="126"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="138"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="208"/>
        <source>This file contains some unsupported features</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="206"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation type="unfinished">Ukuran</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation type="unfinished">Lebar:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation type="unfinished">Panjang:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation type="unfinished">Tinggi:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation type="unfinished">Sudut:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="908"/>
        <source>Element</source>
        <translation type="unfinished">Elemen</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="287"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="876"/>
        <source>Group </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="751"/>
        <source>Page </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="806"/>
        <source>Free Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="907"/>
        <source>Outline</source>
        <translation type="unfinished">Outline</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="140"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="909"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="141"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="152"/>
        <source>Save as PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="65"/>
        <source>O&amp;utput to File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="94"/>
        <source>Cha&amp;nge...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="97"/>
        <source>Output one file for eac&amp;h page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="110"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save as</source>
        <translation type="obsolete">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="122"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="123"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="153"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="170"/>
        <source>Cannot create directory: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save As</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="135"/>
        <source>Saving PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2536"/>
        <source>Page:</source>
        <translation type="unfinished">Halaman:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2549"/>
        <source>Date:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7702"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7707"/>
        <source>Failed to write an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7712"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7717"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7697"/>
        <source>A write error occured, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDF_Opts</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Export Range</source>
        <translation type="obsolete">Ekspor Cakupan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>File Options</source>
        <translation type="obsolete">Pilihan File</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Left Margin</source>
        <translation type="obsolete">Margin Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right Margin</source>
        <translation type="obsolete">Margin Kanan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Medium</source>
        <translation type="obsolete">Sedang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Embedding</source>
        <translation type="obsolete">Memasukkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Available Fonts:</source>
        <translation type="obsolete">Font yang Tersedia:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Fonts to embed:</source>
        <translation type="obsolete">Font yang dimasukkan:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page</source>
        <translation type="obsolete">Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Effects</source>
        <translation type="obsolete">Efek</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No Effect</source>
        <translation type="obsolete">Tidak ada Efek</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Blinds</source>
        <translation type="obsolete">Berkedip</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Box</source>
        <translation type="obsolete">Kotak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Dissolve</source>
        <translation type="obsolete">Pecahkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Split</source>
        <translation type="obsolete">Pisahkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Wipe</source>
        <translation type="obsolete">Seka</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Horizontal</source>
        <translation type="obsolete">Horisontal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Vertical</source>
        <translation type="obsolete">Vertikal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Inside</source>
        <translation type="obsolete">Di Dalam</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Outside</source>
        <translation type="obsolete">Di Luar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Left to Right</source>
        <translation type="obsolete">Kiri ke Kanan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Top to Bottom</source>
        <translation type="obsolete">Atas ke Bawah</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Bottom to Top</source>
        <translation type="obsolete">Bawah ke Atas</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right to Left</source>
        <translation type="obsolete">Kanan ke Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Passwords</source>
        <translation type="obsolete">Katakunci</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Settings</source>
        <translation type="obsolete">Pengaturan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>General</source>
        <translation type="obsolete">Umum</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Printer</source>
        <translation type="obsolete">Printer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Line</source>
        <translation type="obsolete">Garis</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Solid Colors:</source>
        <translation type="obsolete">Warna Solid:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Rendering-Intent:</source>
        <translation type="obsolete">Intensitas Rendering</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Relative Colorimetric</source>
        <translation type="obsolete">Colorimetric Relatif</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Saturation</source>
        <translation type="obsolete">Saturasi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Absolute Colorimetric</source>
        <translation type="obsolete">Colorimetric Absolut</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Images:</source>
        <translation type="obsolete">Gambar:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Save as</source>
        <translation type="obsolete">Simpan sebagai</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../scribus/preview.cpp" line="81"/>
        <source>Print Preview</source>
        <translation type="unfinished">Tampilan Prapandang</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="133"/>
        <source>Display Trans&amp;parency</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="248"/>
        <source>&amp;Under Color Removal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="138"/>
        <source>&amp;Display CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="206"/>
        <source>&amp;C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="211"/>
        <source>&amp;M</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="216"/>
        <source>&amp;Y</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="221"/>
        <source>&amp;K</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="326"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="327"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="350"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="351"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="352"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="353"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="619"/>
        <source>All</source>
        <translation type="unfinished">Semua</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="150"/>
        <source>Separation Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="162"/>
        <source>Cyan</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="169"/>
        <source>Magenta</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="176"/>
        <source>Yellow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="183"/>
        <source>Black</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="269"/>
        <source>Scaling:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="297"/>
        <source>Print...</source>
        <translation type="unfinished">Cetak...</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="328"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="329"/>
        <source>Resize the scale of the page.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="294"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="1106"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="128"/>
        <source>Enable &amp;Antialiasing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="281"/>
        <source>Fit to Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="282"/>
        <source>Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="283"/>
        <source>Fit to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="325"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="122"/>
        <source>Display Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="230"/>
        <source>Print Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="236"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="239"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="245"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="251"/>
        <source>Convert Spot Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="330"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="254"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="331"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Processing Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1726"/>
        <source>Failed to write data for an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1731"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1736"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1741"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PStyleW</name>
    <message>
        <location filename="../smpstylew.ui" line="26"/>
        <source>Properties</source>
        <translation type="obsolete">Properti</translation>
    </message>
</context>
<context>
    <name>PStyleWBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Properties</source>
        <translation type="obsolete">Properti</translation>
    </message>
</context>
<context>
    <name>Page</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Copy Here</source>
        <translation type="obsolete">Salin ke Sini</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Move Here</source>
        <translation type="obsolete">Pindah ke Sini</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Text Frame</source>
        <translation type="obsolete">Frame Teks</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Enabled</source>
        <translation type="obsolete">Bolehkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="388"/>
        <source>Image</source>
        <translation type="unfinished">Gambar</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="392"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="396"/>
        <source>Line</source>
        <translation type="unfinished">Garis</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="400"/>
        <source>Polygon</source>
        <translation type="unfinished">Poligon</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="404"/>
        <source>Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="408"/>
        <source>PathText</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="3612"/>
        <source>Copy of</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation type="unfinished">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation type="unfinished">Nilai</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItemAttributesBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="394"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="463"/>
        <source>Image</source>
        <translation type="unfinished">Gambar</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="469"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="472"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="473"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="104"/>
        <source>Size:</source>
        <translation type="unfinished">Ukuran:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="474"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="478"/>
        <source>Unknown</source>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="485"/>
        <source>Page:</source>
        <translation type="unfinished">Halaman:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="487"/>
        <source>Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="496"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="501"/>
        <source>No Image Loaded</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="564"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Running the external application failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="239"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="415"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../pageitem_latexframe.cpp" line="647"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="569"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="405"/>
        <source>The application &quot;%1&quot; failed to start!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="409"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="558"/>
        <source>Application</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="559"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="561"/>
        <source>State</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="566"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="260"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="557"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="224"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="421"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="319"/>
        <source>Paragraphs: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="327"/>
        <source>Lines: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="333"/>
        <source>Words: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="341"/>
        <source>Chars: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3422"/>
        <source>Linked Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3424"/>
        <source>Text Frame</source>
        <translation type="unfinished">Frame Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3428"/>
        <source>Paragraphs: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3436"/>
        <source>Lines: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3442"/>
        <source>Words: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3450"/>
        <source>Chars: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="933"/>
        <source>Arrange Pages</source>
        <translation type="unfinished">Susun Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="934"/>
        <source>Available Master Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="935"/>
        <source>Document Pages:</source>
        <translation type="unfinished">Halaman Dokumen:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="938"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="939"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="937"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="628"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="632"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="266"/>
        <source>%1 of %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageSize</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Medium</source>
        <translation type="obsolete">Sedang</translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation type="unfinished">Tanpa Gaya</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect first Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>with:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>PathDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="13"/>
        <source>Boolean Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="97"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="195"/>
        <source>=</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="274"/>
        <source>Operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="357"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="381"/>
        <source>Swap Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="386"/>
        <source>Options</source>
        <translation type="obsolete">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="41"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="139"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="234"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="286"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="321"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="337"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="353"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="462"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="488"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="158"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="161"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="305"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="378"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="418"/>
        <source>Result takes color from:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="424"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="427"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="437"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="440"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="447"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="478"/>
        <source>Stroke Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="498"/>
        <source>Fill Color</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="74"/>
        <source>Path Operations...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="78"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="103"/>
        <source>Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="104"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="95"/>
        <source>Create Path from Stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="74"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="134"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="162"/>
        <source>Loading Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="296"/>
        <source>All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="310"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="14"/>
        <source>Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="56"/>
        <source>Load</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="63"/>
        <source>Load Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="77"/>
        <source>Remove</source>
        <translation type="unfinished">Hapus</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="84"/>
        <source>Remove All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="107"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="114"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="213"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="70"/>
        <source>Rename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation type="unfinished">Hasil</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation type="unfinished">Hasil Pencarian untuk: </translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Preview</source>
        <translation type="obsolete">Prapandang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Select</source>
        <translation type="obsolete">Pilih</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation type="unfinished">Ukuran:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearchBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Result</source>
        <translation type="obsolete">Hasil</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search Results for: </source>
        <translation type="obsolete">Hasil Pencarian untuk: </translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="51"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="58"/>
        <source>Cancel Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="124"/>
        <source>Start Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="91"/>
        <source>Select a base directory for search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>The search failed: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation type="unfinished">Ubah...</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="103"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Pictures</source>
        <translation type="obsolete">Gambar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Path</source>
        <translation type="obsolete">Lokasi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page</source>
        <translation type="obsolete">Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Print</source>
        <translation type="obsolete">Cetak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Status</source>
        <translation type="obsolete">Status</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="575"/>
        <source>Goto</source>
        <translation type="obsolete">Pergi ke</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Missing</source>
        <translation type="obsolete">Hilang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search</source>
        <translation type="obsolete">Cari</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="16"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Manajemen Gambar</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="253"/>
        <source>Not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="278"/>
        <source>JPG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="281"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="284"/>
        <source>PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="287"/>
        <source>EPS/PS</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="290"/>
        <source>PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="293"/>
        <source>JPG2000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="299"/>
        <source>emb. PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="305"/>
        <source>Unknown</source>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="322"/>
        <source>n/a</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation type="unfinished">Nama:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation type="unfinished">Gambar</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation type="unfinished">Format:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation type="unfinished">Ukuran</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation type="unfinished">Skala:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation type="unfinished">Pilih</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="264"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="59"/>
        <source>Save as &amp;Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="78"/>
        <source>Export As Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="79"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="145"/>
        <source>Export successful</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="123"/>
        <source>Save as Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="118"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="124"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="72"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="61"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="97"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Import</source>
        <comment>plugin manager</comment>
        <translation type="obsolete">Impor</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="157"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="261"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="267"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="271"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="275"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="341"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="343"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="228"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="19"/>
        <source>Plugin Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="35"/>
        <source>Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="40"/>
        <source>How to run</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="45"/>
        <source>Type</source>
        <translation type="unfinished">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="50"/>
        <source>Load it?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="55"/>
        <source>Plugin ID</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="60"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No</source>
        <translation type="obsolete">Tidak</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="68"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="13"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation type="unfinished">Properti Poligon</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="../../scribus/prefs.cpp" line="72"/>
        <source>Preferences</source>
        <translation type="unfinished">Preferensi</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="75"/>
        <source>General</source>
        <translation type="unfinished">Umum</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="78"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="81"/>
        <source>Guides</source>
        <translation type="unfinished">Pemandu</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="84"/>
        <source>Typography</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="87"/>
        <source>Tools</source>
        <translation type="unfinished">Alat bantu</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="135"/>
        <source>Scrapbook</source>
        <translation type="unfinished">Scrapbook</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="138"/>
        <source>Display</source>
        <translation type="unfinished">Tampilan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>GUI</source>
        <translation type="obsolete">GUI</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Units</source>
        <translation type="obsolete">Satuan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Points (pt)</source>
        <translation type="obsolete">Point (pt)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Inches (in)</source>
        <translation type="obsolete">Inci (in)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Picas (p)</source>
        <translation type="obsolete">Picas (p)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page Size</source>
        <translation type="obsolete">Ukuran Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Portrait</source>
        <translation type="obsolete">Tegak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Landscape</source>
        <translation type="obsolete">Datar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Margin Guides</source>
        <translation type="obsolete">Pemandu Gari Tepi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Autosave</source>
        <translation type="obsolete">Simpan otomatis</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Grid Layout</source>
        <translation type="obsolete">Layout Grid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Grid Colors</source>
        <translation type="obsolete">Warna Grid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Placing</source>
        <translation type="obsolete">Peletakan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Other</source>
        <translation type="obsolete">Lainnya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Other Options</source>
        <translation type="obsolete">Pilihan Lain</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Preview</source>
        <translation type="obsolete">Prapandang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Small</source>
        <translation type="obsolete">Kecil</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Medium</source>
        <translation type="obsolete">Sedang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Choose a Directory</source>
        <translation type="obsolete">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="90"/>
        <source>Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="93"/>
        <source>Fonts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="104"/>
        <source>Color Management</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="119"/>
        <source>PDF Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="132"/>
        <source>Keyboard Shortcuts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="148"/>
        <source>Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="99"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="124"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="129"/>
        <source>Table of Contents and Indexes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="141"/>
        <source>External Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="144"/>
        <source>Miscellaneous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="96"/>
        <source>Printer</source>
        <translation type="unfinished">Printer</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="191"/>
        <source>&amp;Defaults</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="200"/>
        <source>Save Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="190"/>
        <source>Export...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="192"/>
        <source>&amp;Apply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="193"/>
        <source>All preferences can be reset here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="194"/>
        <source>Apply all changes without closing the dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="195"/>
        <source>Export current preferences into file</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Left Page</source>
        <translation type="obsolete">Halaman Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Right Page</source>
        <translation type="obsolete">Halaman Kanan</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>Postscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="809"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="811"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1684"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1696"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1710"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1720"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2393"/>
        <source>Error Writing Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2399"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2412"/>
        <source>Error Loading Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2417"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2125"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="555"/>
        <source>Magazine</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="556"/>
        <source>Fibonacci</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="557"/>
        <source>Golden Mean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="558"/>
        <source>Nine Parts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="554"/>
        <source>Gutenberg</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="553"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation type="unfinished">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="561"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <location filename="../printdialog.cpp" line="67"/>
        <source>Setup Printer</source>
        <translation type="obsolete">Pengaturan Printer</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="563"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="373"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="190"/>
        <source>Options</source>
        <translation type="obsolete">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="507"/>
        <source>All</source>
        <translation type="unfinished">Semua</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="506"/>
        <source>Cyan</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="505"/>
        <source>Magenta</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="504"/>
        <source>Yellow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="503"/>
        <source>Black</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save as</source>
        <translation type="obsolete">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="334"/>
        <source>Print Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="196"/>
        <source>Page</source>
        <translation type="obsolete">Halaman</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="214"/>
        <source>Color</source>
        <translation type="obsolete">Warna</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="232"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Pilihan Advanced</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="309"/>
        <source>Failed to retrieve printer settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="103"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="104"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save As</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="13"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Pengaturan Printer</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="22"/>
        <source>Print Destination</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="49"/>
        <source>&amp;Options...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="85"/>
        <source>&amp;File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="101"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="116"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="119"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="137"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="159"/>
        <source>Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="171"/>
        <source>Print &amp;All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="191"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="211"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="218"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="228"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="273"/>
        <source>Options</source>
        <translation type="unfinished">Pilihan</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="280"/>
        <source>Print Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="285"/>
        <source>Print Separations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="294"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="299"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="314"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="334"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Pilihan Advanced</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="340"/>
        <source>Page</source>
        <translation type="unfinished">Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="346"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="353"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="363"/>
        <source>Set Media Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="380"/>
        <source>Color</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="389"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="396"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="399"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="406"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="409"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="436"/>
        <source>Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="442"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="445"/>
        <source>Crop Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="452"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="455"/>
        <source>Registration Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="462"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="465"/>
        <source>Bleed Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="472"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="475"/>
        <source>Color Bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="484"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="491"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="514"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="520"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="527"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="534"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="541"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="548"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="555"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="562"/>
        <source>Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="569"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="576"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="579"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="605"/>
        <source>Preview...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="615"/>
        <source>&amp;Print</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="625"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="322"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="326"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4890"/>
        <source>Properties</source>
        <translation type="unfinished">Properti</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4892"/>
        <source>X, Y, &amp;Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4895"/>
        <source>&amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4893"/>
        <source>&amp;Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4894"/>
        <source>&amp;Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4896"/>
        <source>&amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4897"/>
        <source>&amp;Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4900"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4901"/>
        <source>Geometry</source>
        <translation type="unfinished">Geometri</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5093"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5005"/>
        <source>&amp;X-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5006"/>
        <source>&amp;Y-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4904"/>
        <source>&amp;Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4905"/>
        <source>&amp;Height:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4906"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4907"/>
        <source>Basepoint:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4908"/>
        <source>Level</source>
        <translation type="unfinished">Level</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4914"/>
        <source>Shape:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4934"/>
        <source>R&amp;ound
Corners:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Distance of Text</source>
        <translation type="obsolete">Jarak Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4935"/>
        <source>Colu&amp;mns:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4942"/>
        <source>To&amp;p:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4943"/>
        <source>&amp;Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4944"/>
        <source>&amp;Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4945"/>
        <source>&amp;Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4946"/>
        <source>T&amp;abulators...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5000"/>
        <source>Path Text Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4953"/>
        <source>Show Curve</source>
        <translation type="unfinished">Tampilkan Kurva</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4955"/>
        <source>Start Offset:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4956"/>
        <source>Distance from Curve:</source>
        <translation type="unfinished">Jarak dari Kurva:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4969"/>
        <source>Use &amp;Bounding Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4970"/>
        <source>&amp;Use Contour Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5079"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Shade:</source>
        <translation type="obsolete">Tingkat Kegelapan:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom Spacing</source>
        <translation type="obsolete">Spasi Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5002"/>
        <source>&amp;Free Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5007"/>
        <source>X-Sc&amp;ale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5008"/>
        <source>Y-Scal&amp;e:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5009"/>
        <source>Scale &amp;To Frame Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5010"/>
        <source>P&amp;roportional</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5013"/>
        <source>Input Profile:</source>
        <translation type="unfinished">Profil Masukan:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5014"/>
        <source>Rendering Intent:</source>
        <translation type="unfinished">Intensitas Rendering</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5024"/>
        <source>Perceptual</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5025"/>
        <source>Relative Colorimetric</source>
        <translation type="unfinished">Colorimetric Relatif</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5026"/>
        <source>Saturation</source>
        <translation type="unfinished">Saturasi</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5027"/>
        <source>Absolute Colorimetric</source>
        <translation type="unfinished">Colorimetric Absolut</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5036"/>
        <source>Left Point</source>
        <translation type="unfinished">Titik Kiri</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5037"/>
        <source>End Points</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5039"/>
        <source>&amp;Basepoint:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5040"/>
        <source>T&amp;ype of Line:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5052"/>
        <source>Line &amp;Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5056"/>
        <source>Miter Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5057"/>
        <source>Bevel Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5058"/>
        <source>Round Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5053"/>
        <source>Ed&amp;ges:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5063"/>
        <source>Flat Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5064"/>
        <source>Square Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5065"/>
        <source>Round Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5067"/>
        <source>&amp;Endings:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5120"/>
        <source>No Style</source>
        <translation type="unfinished">Tanpa Gaya</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5069"/>
        <source>Cell Lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5070"/>
        <source>Line at Top</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5071"/>
        <source>Line at the Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5072"/>
        <source>Line at the Right </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5073"/>
        <source>Line at Bottom</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5215"/>
        <source>Name of selected object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5216"/>
        <source>Horizontal position of current basepoint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5217"/>
        <source>Vertical position of current basepoint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5218"/>
        <source>Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5219"/>
        <source>Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5220"/>
        <source>Rotation of object at current basepoint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5221"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5229"/>
        <source>Flip Horizontal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5230"/>
        <source>Flip Vertical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5231"/>
        <source>Move one level up</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5232"/>
        <source>Move one level down</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5233"/>
        <source>Move to front</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5234"/>
        <source>Move to back</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5235"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5236"/>
        <source>Lock or unlock the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5237"/>
        <source>Lock or unlock the size of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5251"/>
        <source>Font of selected text or object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5252"/>
        <source>Font Size</source>
        <translation type="unfinished">Ukuran Font</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5254"/>
        <source>Scaling width of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5258"/>
        <source>Saturation of color of text stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5259"/>
        <source>Saturation of color of text fill</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Manual Kerning</source>
        <translation type="obsolete">Penonjolan Manual</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5262"/>
        <source>Line Spacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5281"/>
        <source>Change settings for left or end points</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5282"/>
        <source>Pattern of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5283"/>
        <source>Thickness of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5284"/>
        <source>Type of line joins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5285"/>
        <source>Type of line end</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5286"/>
        <source>Line style of current object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5288"/>
        <source>Choose the shape of frame...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5289"/>
        <source>Edit shape of the frame...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5290"/>
        <source>Set radius of corner rounding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5291"/>
        <source>Number of columns in text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5292"/>
        <source>Switches between Gap or Column width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5293"/>
        <source>Distance between columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5294"/>
        <source>Distance of text from top of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5295"/>
        <source>Distance of text from bottom of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5296"/>
        <source>Distance of text from left of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5297"/>
        <source>Distance of text from right of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5298"/>
        <source>Edit tab settings of text frame...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5300"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5301"/>
        <source>Horizontal offset of image within frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5302"/>
        <source>Vertical offset of image within frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5303"/>
        <source>Resize the image horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5304"/>
        <source>Resize the image vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5305"/>
        <source>Keep the X and Y scaling the same</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5306"/>
        <source>Keep the aspect ratio</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5307"/>
        <source>Make the image fit within the size of the frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5308"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5309"/>
        <source>Source profile of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5310"/>
        <source>Rendering intent for the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3869"/>
        <source>&amp;X1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3870"/>
        <source>X&amp;2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3871"/>
        <source>Y&amp;1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3872"/>
        <source>&amp;Y2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3633"/>
        <source>Column width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Nama &quot;%1&quot; tidak unik.
Silakan pilih nama lain.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5260"/>
        <source>Right to Left Writing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5041"/>
        <source>Start Arrow:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5042"/>
        <source>End Arrow:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5019"/>
        <source>Fixed Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5020"/>
        <source>Automatic Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5021"/>
        <source>Align to Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5003"/>
        <source>Actual X-DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5004"/>
        <source>Actual Y-DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5253"/>
        <source>Offset to baseline of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5255"/>
        <source>Scaling height of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5261"/>
        <source>Manual Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4766"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4957"/>
        <source>Fill Rule</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4958"/>
        <source>Even-Odd</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4959"/>
        <source>Non Zero</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5075"/>
        <source>Overprinting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5076"/>
        <source>Knockout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5077"/>
        <source>Overprint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5256"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5257"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4938"/>
        <source>Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4939"/>
        <source>Width:</source>
        <translation type="unfinished">Lebar:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4966"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4967"/>
        <source>Disabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4968"/>
        <source>Use Frame &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5011"/>
        <source>Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5012"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5245"/>
        <source>Disable text flow from lower frames around object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5246"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5247"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4915"/>
        <source>Transparency Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4898"/>
        <source>&amp;Group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4916"/>
        <source>Opacity:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4917"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4919"/>
        <source>Normal</source>
        <translation type="unfinished">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4920"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4921"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4922"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4924"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4925"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4926"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4927"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4928"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4929"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4930"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4931"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4933"/>
        <source>Color</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5227"/>
        <source>Group the selected objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3009"/>
        <source>Auto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5248"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object. T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4949"/>
        <source>Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4950"/>
        <source>Stair Step</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4951"/>
        <source>Skew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4952"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4954"/>
        <source>Type:</source>
        <translation type="unfinished">Tipe:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4971"/>
        <source>Use Image Clip Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4972"/>
        <source>Paragraph St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4973"/>
        <source>Character St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4989"/>
        <source>Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4993"/>
        <source>Min:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4991"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4992"/>
        <source>Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4994"/>
        <source>Max:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5249"/>
        <source>Use the clipping path of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5265"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5266"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5267"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5268"/>
        <source>Remove Direct Character Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5275"/>
        <source>Minimal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5276"/>
        <source>Normal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5277"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5278"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5238"/>
        <source>Enable or disable exporting of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5032"/>
        <source>Custom</source>
        <translation type="unfinished">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4913"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4998"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="832"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="833"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4995"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4996"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4997"/>
        <source>Style Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3011"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5228"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5264"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5271"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5272"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5273"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5001"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4999"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4984"/>
        <source>Left Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4985"/>
        <source>Right Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4986"/>
        <source>Left Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4987"/>
        <source>Right Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4988"/>
        <source>Reset</source>
        <translation type="unfinished">Reset</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="937"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5102"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="117"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="118"/>
        <source>Output of your script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="195"/>
        <source>Save the Python Commands in File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="220"/>
        <source>Text Files (*.txt)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="218"/>
        <source>Save Current Output</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="161"/>
        <source>Open Python Script File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="197"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="33"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="44"/>
        <source>Ctrl+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="65"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="130"/>
        <source>Hu&amp;e:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="131"/>
        <source>&amp;Sat:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="132"/>
        <source>&amp;Val:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="133"/>
        <source>&amp;Red:</source>
        <translation type="unfinished">Me&amp;rah:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="134"/>
        <source>&amp;Green:</source>
        <translation type="unfinished">Hi&amp;jau:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="135"/>
        <source>Bl&amp;ue:</source>
        <translation type="unfinished">Bir&amp;u:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="136"/>
        <source>A&amp;lpha channel:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Basic colors</source>
        <translation type="unfinished">&amp;Warna Dasar</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Custom colors</source>
        <translation type="unfinished">Warna sendi&amp;ri</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="139"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation type="unfinished">&amp;Tentukan Warna Sendiri &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="140"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="141"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Add to Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="143"/>
        <source>Select color</source>
        <translation type="unfinished">Pilih warna</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation type="unfinished">&amp;Nama File:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation type="unfinished">&amp;Tipe File:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="19"/>
        <source>One directory up</source>
        <translation type="unfinished">Naik satu direktori</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="20"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="21"/>
        <source>All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="22"/>
        <source>Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="23"/>
        <source>Size</source>
        <translation type="unfinished">Ukuran</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="24"/>
        <source>Type</source>
        <translation type="unfinished">Tipe</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="25"/>
        <source>Date</source>
        <translation type="unfinished">Tanggal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="26"/>
        <source>Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="27"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="28"/>
        <source>Look &amp;in:</source>
        <translation type="unfinished">L&amp;ihat di: </translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="29"/>
        <source>Back</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="30"/>
        <source>Create New Folder</source>
        <translation type="unfinished">Buat Folder Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="31"/>
        <source>List View</source>
        <translation type="unfinished">Tampilan Daftar</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="32"/>
        <source>Detail View</source>
        <translation type="unfinished">Tampilan Detail</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="33"/>
        <source>Preview File Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="34"/>
        <source>Preview File Contents</source>
        <translation type="unfinished">Prapandang Isi File</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="35"/>
        <source>Read-write</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="36"/>
        <source>Read-only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="37"/>
        <source>Write-only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="38"/>
        <source>Inaccessible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="39"/>
        <source>Symlink to File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="40"/>
        <source>Symlink to Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="41"/>
        <source>Symlink to Special</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="42"/>
        <source>File</source>
        <translation type="unfinished">Berkas</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="43"/>
        <source>Dir</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="44"/>
        <source>Special</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="45"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="46"/>
        <source>Save As</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="47"/>
        <source>&amp;Open</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="48"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="49"/>
        <source>&amp;Rename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="50"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="51"/>
        <source>R&amp;eload</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="52"/>
        <source>Sort by &amp;Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="53"/>
        <source>Sort by &amp;Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="54"/>
        <source>Sort by &amp;Date</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="55"/>
        <source>&amp;Unsorted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="57"/>
        <source>Show &amp;hidden files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="58"/>
        <source>the file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="59"/>
        <source>the directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="60"/>
        <source>the symlink</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="61"/>
        <source>Delete %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="62"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="65"/>
        <source>New Folder 1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="66"/>
        <source>New Folder</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="67"/>
        <source>New Folder %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="68"/>
        <source>Find Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="69"/>
        <source>Directories</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="70"/>
        <source>Save</source>
        <translation type="unfinished">Simpan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="71"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="72"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="73"/>
        <source>All Files (*.*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="74"/>
        <source>Select a Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="75"/>
        <source>Directory:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="147"/>
        <source>&amp;Font</source>
        <translation type="unfinished">&amp;Font</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="148"/>
        <source>Font st&amp;yle</source>
        <translation type="unfinished">Ga&amp;ya Font</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="149"/>
        <source>&amp;Size</source>
        <translation type="unfinished">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="150"/>
        <source>Effects</source>
        <translation type="unfinished">Efek</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="151"/>
        <source>Stri&amp;keout</source>
        <translation type="unfinished">Stri&amp;keout</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="152"/>
        <source>&amp;Underline</source>
        <translation type="unfinished">&amp;Garis bawah</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="154"/>
        <source>Sample</source>
        <translation type="unfinished">Contoh</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="155"/>
        <source>Scr&amp;ipt</source>
        <translation type="unfinished">Skr&amp;ip</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="156"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="157"/>
        <source>Apply</source>
        <translation type="unfinished">Terapkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="158"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="159"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="160"/>
        <source>Select Font</source>
        <translation type="unfinished">Pilih Font</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="79"/>
        <source>Clear</source>
        <translation type="unfinished">Bersihkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="80"/>
        <source>Select All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="81"/>
        <source>&amp;Undo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="82"/>
        <source>&amp;Redo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="83"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="84"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="99"/>
        <source>Line up</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="100"/>
        <source>Customize...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../scribus/gtaction.cpp" line="76"/>
        <source>Importing text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="195"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="242"/>
        <source>All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="240"/>
        <source>Initializing...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Document</source>
        <translation type="obsolete">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1100"/>
        <source>Background</source>
        <translation type="unfinished">Latar Belakang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../plugins/svgexplugin/svgexplugin.cpp" line="139"/>
        <source>Do you really want to overwrite the File:
%1 ?</source>
        <translation type="obsolete">Apakah anda benar-benar ingin menimpa File:
%1 ?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Newsletters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Brochures</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Catalogs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Flyers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Signs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Cards</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Letterheads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Envelopes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Business Cards</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Calendars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Advertisements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>Labels</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>Menus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Programs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>PDF Forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>PDF Presentations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Magazines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Posters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Announcements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <source>Text Documents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="175"/>
        <source>Folds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>No</source>
        <translation type="obsolete">Tidak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Yes</source>
        <translation type="obsolete">Ya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Print Preview</source>
        <translation type="obsolete">Tampilan Prapandang</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>Save as</source>
        <translation type="unfinished">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="12"/>
        <source>Comma Separated Value Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="58"/>
        <source>CSV_data</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="62"/>
        <source>CSV_header</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="43"/>
        <source>HTML Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="48"/>
        <source>html</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlreader.cpp" line="616"/>
        <source>
External Links
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/txtim/txtim.cpp" line="21"/>
        <source>Text Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="327"/>
        <source>Font %1 is broken, discarding it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/textfilter/textfilter.cpp" line="26"/>
        <source>Text Filters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="176"/>
        <source>Media Cases</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="60"/>
        <source>Albanian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="61"/>
        <source>Basque</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="65"/>
        <source>Catalan</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="66"/>
        <source>Chinese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="72"/>
        <source>Danish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="74"/>
        <source>Dutch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="228"/>
        <source>English</source>
        <translation type="unfinished">Inggris</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="77"/>
        <source>English (British)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="79"/>
        <source>Esperanto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="81"/>
        <source>German</source>
        <translation type="unfinished">Jerman</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="84"/>
        <source>Finnish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="85"/>
        <source>French</source>
        <translation type="unfinished">Perancis</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="88"/>
        <source>Galician</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="89"/>
        <source>Greek</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="91"/>
        <source>Hungarian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="94"/>
        <source>Indonesian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="95"/>
        <source>Italian</source>
        <translation type="unfinished">Italia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="98"/>
        <source>Korean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="102"/>
        <source>Lithuanian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="108"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="110"/>
        <source>Norwegian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="112"/>
        <source>Polish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="116"/>
        <source>Russian</source>
        <translation type="unfinished">Rusia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="124"/>
        <source>Swedish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="119"/>
        <source>Spanish</source>
        <translation type="unfinished">Spanyol</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="120"/>
        <source>Spanish (Latin)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="121"/>
        <source>Slovak</source>
        <translation type="unfinished">Slovakia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="122"/>
        <source>Slovenian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="123"/>
        <source>Serbian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="291"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="329"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="554"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="216"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="27"/>
        <source>Target is not an image frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="334"/>
        <source>Corner radius must be a positive number.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="64"/>
        <source>Cannot get a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="87"/>
        <source>Cannot change a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="123"/>
        <source>Cannot create a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="159"/>
        <source>Cannot delete a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="204"/>
        <source>Cannot replace a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/sxwim/sxwim.cpp" line="45"/>
        <source>OpenOffice.org Writer Documents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.cpp" line="65"/>
        <source>Color not found - python error</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="153"/>
        <source>Custom (optional) configuration: </source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="149"/>
        <source>Standard configuration: </source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="129"/>
        <source>Short Words processing. Wait please...</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="148"/>
        <source>Short Words processing. Done.</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="58"/>
        <source>Afrikaans</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="128"/>
        <source>Turkish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="129"/>
        <source>Ukranian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="131"/>
        <source>Welsh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="75"/>
        <source>The filename must be a string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="98"/>
        <source>Cannot delete image type settings.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="102"/>
        <source>The image type must be a string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="127"/>
        <source>&apos;allTypes&apos; attribute is READ-ONLY</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="188"/>
        <source>Failed to export image</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="271"/>
        <source>Cannot scale by 0%.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="386"/>
        <source>Specified item not an image frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="417"/>
        <source>Font not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="104"/>
        <source>Cannot render an empty sample.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="690"/>
        <source>Cannot have an empty layer name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="729"/>
        <source>Layer not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="695"/>
        <source>Cannot remove the last layer.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="746"/>
        <source>Cannot create layer without a name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="300"/>
        <source>Insert index out of bounds.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="337"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="363"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="372"/>
        <source>Cannot set font size on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="401"/>
        <source>Cannot set font on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="435"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="443"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="488"/>
        <source>Column gap out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="496"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="515"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="523"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="559"/>
        <source>Cannot select text in a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="596"/>
        <source>Cannot delete text from a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="628"/>
        <source>Cannot set text fill on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="664"/>
        <source>Cannot set text stroke on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="706"/>
        <source>Cannot set text shade on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="746"/>
        <source>Can only link text frames.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="756"/>
        <source>Target frame links to another frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="761"/>
        <source>Target frame is linked to by another frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="766"/>
        <source>Source and target are the same object.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="791"/>
        <source>Cannot unlink a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="846"/>
        <source>Cannot convert a non-text frame to outlines.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="82"/>
        <source>Page</source>
        <translation type="unfinished">Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="581"/>
        <source>Scribus Development Version</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="155"/>
        <source>pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="156"/>
        <source>mm</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="157"/>
        <source>in</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="158"/>
        <source>p</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="207"/>
        <source>Points (pt)</source>
        <translation type="unfinished">Point (pt)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="209"/>
        <source>Inches (in)</source>
        <translation type="unfinished">Inci (in)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="210"/>
        <source>Picas (p)</source>
        <translation type="unfinished">Picas (p)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="362"/>
        <source>File exists</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="486"/>
        <source>All</source>
        <translation type="unfinished">Semua</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="149"/>
        <source>Failed to open document.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="178"/>
        <source>Failed to save document.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="39"/>
        <source>Argument must be page item name, or PyCObject instance</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="90"/>
        <source>Property not found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="310"/>
        <source>Couldn&apos;t convert result type &apos;%1&apos;.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="442"/>
        <source>Property type &apos;%1&apos; not supported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="461"/>
        <source>Couldn&apos;t convert &apos;%1&apos; to property type &apos;%2&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="469"/>
        <source>Types matched, but setting property failed.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="138"/>
        <source>Unable to save pixmap</source>
        <comment>scripter error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="214"/>
        <source>Point list must contain at least two points (four values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="299"/>
        <source>Point list must contain an even number of values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="294"/>
        <source>Point list must contain at least three points (six values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="376"/>
        <source>Point list must contain at least four points (eight values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="381"/>
        <source>Point list must have a multiple of six values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="480"/>
        <source>Object not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="606"/>
        <source>Style not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="632"/>
        <source>Cannot set style on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="58"/>
        <source>Failed to save EPS.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="149"/>
        <source>Page number out of range.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="292"/>
        <source>argument is not list: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="252"/>
        <source>argument contains non-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="303"/>
        <source>argument contains no-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="217"/>
        <source>Line width out of bounds, must be 0 &lt;= line_width &lt;= 12.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="239"/>
        <source>Line shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="261"/>
        <source>Fill shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="363"/>
        <source>Line style not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="797"/>
        <source>Object is not a linked text frame, can&apos;t unlink.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="871"/>
        <source>Only text frames can be checked for overflowing</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="561"/>
        <source>&amp;Execute Script...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="562"/>
        <source>Show &amp;Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="563"/>
        <source>&amp;About Script...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="565"/>
        <source>&amp;Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="566"/>
        <source>&amp;Scribus Scripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="567"/>
        <source>&amp;Recent Scripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="534"/>
        <source>About Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="68"/>
        <source>Croatian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="113"/>
        <source>Portuguese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="114"/>
        <source>Portuguese (BR)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="259"/>
        <source>Scribus Crash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/main_nix.cpp" line="128"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="261"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="91"/>
        <source>Master Page </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="124"/>
        <source>4A0</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="130"/>
        <source>2A0</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="220"/>
        <source>Comm10E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="226"/>
        <source>DLE</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="40"/>
        <source>Could not open output file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="56"/>
        <source>Output stream not writeable</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="79"/>
        <source>Verification of settings failed: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="281"/>
        <source>Could not open input file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="663"/>
        <source>Unable to read settings XML:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="297"/>
        <source>%1 (line %2 col %3)</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>Unable to read settings XML: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>null root node</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="441"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="454"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="469"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="477"/>
        <source>node &lt;%1&gt; not an element</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="497"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="526"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="664"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="48"/>
        <source>Freetype2 library not available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="186"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="390"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="216"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="334"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="538"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="554"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="666"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="671"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="72"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="85"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="94"/>
        <source>table &apos;%1&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="95"/>
        <source>memcpy table: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="98"/>
        <source>memcpy offset: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="159"/>
        <source>cm</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="160"/>
        <source>c</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="208"/>
        <source>Millimeters (mm)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="211"/>
        <source>Centimeters (cm)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="212"/>
        <source>Cicero (c)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="525"/>
        <source>page</source>
        <comment>page export</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="117"/>
        <source>Document Template: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="213"/>
        <source>Color not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="173"/>
        <source>Color not found in document.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="184"/>
        <source>Color not found in default colors.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="204"/>
        <source>Cannot group less than two items</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="229"/>
        <source>Can&apos;t group less than two items</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="237"/>
        <source>Need selection or argument list of items to group</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="963"/>
        <source>Can&apos;t set bookmark on a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="997"/>
        <source>Can&apos;t get info from a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="80"/>
        <source>The filename should not be empty string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="759"/>
        <source>Scribus Python interface module

This module is the Python interface for Scribus. It provides functions
to control scribus and to manipulate objects on the canvas. Each
function is documented individually below.

A few things are common across most of the interface.

Most functions operate on frames. Frames are identified by their name,
a string - they are not real Python objects. Many functions take an
optional (non-keyword) parameter, a frame name.
Many exceptions are also common across most functions. These are
not currently documented in the docstring for each function.
- Many functions will raise a NoDocOpenError if you try to use them
without a document to operate on.
- If you do not pass a frame name to a function that requires one,
the function will use the currently selected frame, if any, or
raise a NoValidObjectError if it can&apos;t find anything to operate
on.
- Many functions will raise WrongFrameTypeError if you try to use them
on a frame type that they do not make sense with. For example, setting
the text color on a graphics frame doesn&apos;t make sense, and will result
in this exception being raised.
- Errors resulting from calls to the underlying Python API will be
passed through unaltered. As such, the list of exceptions thrown by
any function as provided here and in its docstring is incomplete.

Details of what exceptions each function may throw are provided on the
function&apos;s documentation, though as with most Python code this list
is not exhaustive due to exceptions from called functions.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtim.cpp" line="47"/>
        <source>OpenDocument Text Documents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="2620"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1967"/>
        <source>Black</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1969"/>
        <source>Cyan</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1971"/>
        <source>Magenta</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1973"/>
        <source>Yellow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="56"/>
        <source>Color Wheel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="58"/>
        <source>Font Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="45"/>
        <source>My Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="71"/>
        <source>New From Template</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="66"/>
        <source>Save As Template</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="133"/>
        <source>Scripter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="84"/>
        <source>Short Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="98"/>
        <source>SVG Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="101"/>
        <source>SVG Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="104"/>
        <source>OpenOffice.org Draw Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="236"/>
        <source>Scribus crashes due to the following exception : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="318"/>
        <source>Creating Font Cache</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="344"/>
        <source>New Font found, checking...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="381"/>
        <source>Modified Font found, checking...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="767"/>
        <source>Reading Font Cache</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="814"/>
        <source>Writing updated Font Cache</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="831"/>
        <source>Searching for Fonts</source>
        <translation type="unfinished">Mencari Font</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4287"/>
        <source>The changes to your document have not been saved and you have requested to revert them. Do you wish to continue?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="363"/>
        <source>A file named &apos;%1&apos; already exists.&lt;br/&gt;Do you want to replace it with the file you are saving?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="45"/>
        <source>firstPageOrder is bigger than allowed.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="40"/>
        <source>Old .sla format support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="83"/>
        <source>German (Trad.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1783"/>
        <source>Exporting PostScript File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1785"/>
        <source>Printing File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3635"/>
        <source>&lt;p&gt;You are trying to import more pages than there are available in the current document counting from the active page.&lt;/p&gt;Choose one of the following:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Create&lt;/b&gt; missing pages&lt;/li&gt;&lt;li&gt;&lt;b&gt;Import&lt;/b&gt; pages until the last page&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancel&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3636"/>
        <source>C&amp;reate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3637"/>
        <source>&amp;Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="126"/>
        <source>Thai</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="31"/>
        <source>Barcode Generator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="172"/>
        <source>OpenOffice.org Draw (*.sxd *.odg);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="52"/>
        <source>Word Documents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="32"/>
        <source>Palm PDB Documents</source>
        <comment>PDB Importer</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="100"/>
        <source>PDB Import</source>
        <comment>PDB Importer</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="92"/>
        <source>Could not open file %1</source>
        <comment>PDB Importer</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="103"/>
        <source>Luxembourgish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="96"/>
        <source>Japanese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="80"/>
        <source>Font %1(%2) is broken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="139"/>
        <source>Given master page name does not match any existing.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="59"/>
        <source>Arabic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="73"/>
        <source>Dzongkha</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="80"/>
        <source>Estonian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="170"/>
        <source>font %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="172"/>
        <source>size %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="174"/>
        <source>+style </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="176"/>
        <source>+color </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="178"/>
        <source>+underline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="178"/>
        <source>-underline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="180"/>
        <source>+strikeout </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="180"/>
        <source>-strikeout </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="182"/>
        <source>+shadow </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="182"/>
        <source>-shadow </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="184"/>
        <source>+outline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="184"/>
        <source>-outline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="186"/>
        <source>-tracking </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="190"/>
        <source>+stretch </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="192"/>
        <source>parent= %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="53"/>
        <source>Font %1 is broken (no Face), discarding it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="100"/>
        <source>Latin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="93"/>
        <source>Icelandic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="115"/>
        <source>Romanian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Quarto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Foolscap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Letter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Govt. Letter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Legal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Ledger</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Executive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Post</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Crown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Large Post</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Medium</source>
        <translation type="unfinished">Sedang</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Royal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Elephant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Double Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>Quad Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>STMT</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_tiff.cpp" line="957"/>
        <source>%1 may be corrupted : missing resolution tags</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="177"/>
        <source>Font %1 has broken glyph %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="173"/>
        <source>Transparency out of bounds, must be 0 &lt;= transparency &lt;= 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="195"/>
        <source>Blendmode out of bounds, must be 0 &lt;= blendmode &lt;= 15.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="57"/>
        <source>Scribus 1.2.x Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="101"/>
        <source>This file is not recognized as a PDB document. Please, report this as a bug if you are sure it is one.</source>
        <comment>PDB Importer</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="98"/>
        <source>Cannot get number of lines of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="582"/>
        <source>You are running a development version of Scribus 1.3.x. The document you are working with was created in Scribus 1.2.x.  Saving the current file under 1.3.x renders it unable to be edited in Scribus 1.2.x versions. To preserve the ability to edit in 1.2.x, save this file under a different name and further edit the newly named file and the original will be untouched. Are you sure you wish to proceed with this operation?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="186"/>
        <source>+tracking %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="188"/>
        <source>+baseline %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="63"/>
        <source>Breton</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="78"/>
        <source>English (American)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_jpeg.cpp" line="314"/>
        <source>%1 may be corrupted : missing or wrong resolution tags</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="76"/>
        <source>English (Australian)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="82"/>
        <source>German (Swiss)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="90"/>
        <source>Hebrew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="98"/>
        <source>Font %1 has broken metrics in file %2, ignoring metrics</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="67"/>
        <source>Chinese (Trad.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="61"/>
        <source>Scribus 1.3.0-&gt;1.3.3.x Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/serializer.cpp" line="380"/>
        <source>Copy of %1 (%2)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="72"/>
        <source>Image</source>
        <translation type="obsolete">Gambar</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="99"/>
        <source>Text</source>
        <translation type="obsolete">Teks</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="104"/>
        <source>Line</source>
        <translation type="obsolete">Garis</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="107"/>
        <source>Polygon</source>
        <translation type="obsolete">Poligon</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="163"/>
        <source>%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="97"/>
        <source>Khmer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="99"/>
        <source>Lao</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="130"/>
        <source>Vietnamese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="107"/>
        <source>An error occurred while initializing icc transforms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="134"/>
        <source>Output profile is not supported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/wmfimplugin/wmfimportplugin.cpp" line="89"/>
        <source>WMF Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/sclayer.cpp" line="388"/>
        <source>New Layer</source>
        <translation type="unfinished">Layer Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="71"/>
        <source>Adobe Illustrator Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="61"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PostScript Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="169"/>
        <source>Do you really want to overwrite the file:
%1 ?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="34"/>
        <source>Encapsulated PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="35"/>
        <source>GIF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="36"/>
        <source>JPEG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="37"/>
        <source>Pattern Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="38"/>
        <source>PDF Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="39"/>
        <source>PNG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="40"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="41"/>
        <source>Adobe Photoshop</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="42"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="43"/>
        <source>XPM</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="44"/>
        <source>Windows Meta File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="45"/>
        <source>Scalable Vector Graphics</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="46"/>
        <source>Adobe Illustrator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="104"/>
        <source>Valid metrics were found for font %1, using metrics in file %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="111"/>
        <source>No metrics found for font %1, ignoring font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="378"/>
        <source>Error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="375"/>
        <source>Configfile %1 not found or the file is not readable</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="386"/>
        <source>second argument is not tuple: must be tuple of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="398"/>
        <source>second argument contains non-numeric values: must be list of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="50"/>
        <source>Cannot have an empty paragraph style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="70"/>
        <source>hasdropcap has to be 0 or 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="122"/>
        <source>Cannot have an empty char style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="920"/>
        <source>Can only hyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="943"/>
        <source>Can only dehyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="82"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="91"/>
        <source>PathCutter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="95"/>
        <source>PathFinder</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="87"/>
        <source>PathStroker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="56"/>
        <source>Spell check (aspell)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/subdivide/subdivide.cpp" line="79"/>
        <source>Subdivide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="71"/>
        <source>Xfig Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="47"/>
        <source>Xfig File</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/langmgr.cpp" line="106"/>
        <source>Norwegian (Bokmål)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="380"/>
        <source>Parsing the configfile %1 failed! Depending on the type of the error render frames might not work correctly!
%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="86"/>
        <source>MeshDistortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="88"/>
        <source>PathAlongPath</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/transform/transformeffect.cpp" line="78"/>
        <source>Transform Effect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="161"/>
        <source>&#xb0;</source>
        <comment>degrees, unicode 0xB0</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="152"/>
        <source>Cannot get text distances of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="462"/>
        <source>Text distances out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="470"/>
        <source>Cannot set text distances on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="62"/>
        <source>Bengali</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="117"/>
        <source>Sanskrit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="64"/>
        <source>Scribus 1.3.4+ Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="82"/>
        <source>PathConnect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_ps.cpp" line="502"/>
        <source>The Font(s):
%1 are not embedded or available for Scribus.
They might be replaced by &quot;Courier&quot;, depending how your Ghostscript is configured.
Therefore the image may be not correct</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="108"/>
        <source>Save As</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="257"/>
        <source>Printing...</source>
        <translation type="unfinished">Mencetak...</translation>
    </message>
</context>
<context>
    <name>QTextEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="89"/>
        <source>Clear</source>
        <translation type="unfinished">Bersihkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="90"/>
        <source>Select All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="91"/>
        <source>&amp;Undo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="92"/>
        <source>&amp;Redo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="93"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="94"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="95"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QTitleBar</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="104"/>
        <source>System Menu</source>
        <translation type="unfinished">Menu Sistem</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="105"/>
        <source>Shade</source>
        <translation type="unfinished">Tingkat Kegelapan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="106"/>
        <source>Unshade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="107"/>
        <source>Normalize</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="108"/>
        <source>Minimize</source>
        <translation type="unfinished">Minimalkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="109"/>
        <source>Maximize</source>
        <translation type="unfinished">Maksimalkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="110"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
</context>
<context>
    <name>QWorkspace</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="114"/>
        <source>&amp;Restore</source>
        <translation type="unfinished">&amp;Kembalikan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="115"/>
        <source>&amp;Move</source>
        <translation type="unfinished">&amp;Pindahkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="116"/>
        <source>&amp;Size</source>
        <translation type="unfinished">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="117"/>
        <source>Mi&amp;nimize</source>
        <translation type="unfinished">Mi&amp;nimalkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="118"/>
        <source>Ma&amp;ximize</source>
        <translation type="unfinished">Maksi&amp;malkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="119"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="120"/>
        <source>Stay on &amp;Top</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="121"/>
        <source>Minimize</source>
        <translation type="unfinished">Minimalkan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="122"/>
        <source>Restore Down</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="123"/>
        <source>Close</source>
        <translation type="unfinished">Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="124"/>
        <source>Sh&amp;ade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="125"/>
        <source>%1 - [%2]</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="126"/>
        <source>&amp;Unshade</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ReformDoc</name>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="63"/>
        <source>Document Setup</source>
        <translation type="unfinished">Pengaturan Dokumen</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Margin Guides</source>
        <translation type="obsolete">Pemandu Gari Tepi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page Size</source>
        <translation type="obsolete">Ukuran Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Size:</source>
        <translation type="obsolete">Ukuran:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <translation type="obsolete">Atur Sendiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Orientation:</source>
        <translation type="obsolete">Orientasi:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Portrait</source>
        <translation type="obsolete">Tegak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Landscape</source>
        <translation type="obsolete">Datar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Width:</source>
        <translation type="obsolete">Lebar:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Height:</source>
        <translation type="obsolete">Tinggi:</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="66"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="72"/>
        <source>Guides</source>
        <translation type="unfinished">Pemandu</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="76"/>
        <source>Display</source>
        <translation type="unfinished">Tampilan</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="79"/>
        <source>Typography</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="82"/>
        <source>Tools</source>
        <translation type="unfinished">Alat bantu</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="85"/>
        <source>Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="88"/>
        <source>Fonts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="96"/>
        <source>PDF Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="116"/>
        <source>Color Management</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="69"/>
        <source>Document Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="91"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="101"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="106"/>
        <source>Table of Contents and Indexes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="458"/>
        <source>Adjusting Colors</source>
        <translation type="unfinished">Mengatur Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="110"/>
        <source>Sections</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>RulerMover</name>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="82"/>
        <source>Reset Rulers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="88"/>
        <source>Move on current Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="89"/>
        <source>Origin at Top Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="90"/>
        <source>Origin at Top Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="91"/>
        <source>Origin at Bottom Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="92"/>
        <source>Origin at Bottom Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="93"/>
        <source>Origin at Center</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>RunScriptDialog</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.cpp" line="27"/>
        <source>Python Scripts (*.py *.PY);; All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.ui" line="13"/>
        <source>Dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.ui" line="22"/>
        <source>Run as Extension Script</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMAlignSelect</name>
    <message>
        <location filename="../../scribus/smalignselect.cpp" line="20"/>
        <source>P</source>
        <comment>P as in Parent</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smalignselect.cpp" line="21"/>
        <source>Use parent style&apos;s alignment instead of overriding it</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMBase</name>
    <message>
        <location filename="../stylemanager.ui" line="429"/>
        <source>Name:</source>
        <translation type="obsolete">Nama:</translation>
    </message>
</context>
<context>
    <name>SMCStylePage</name>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="577"/>
        <source>Shade</source>
        <translation type="obsolete">Tingkat Kegelapan</translation>
    </message>
</context>
<context>
    <name>SMCStyleWidget</name>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="84"/>
        <source>Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="88"/>
        <source>Language</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="33"/>
        <source>Based On:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="301"/>
        <source>Language:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="460"/>
        <source>Shade</source>
        <translation type="unfinished">Tingkat Kegelapan</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="55"/>
        <source>Basic Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="271"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="198"/>
        <source>Advanced Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="428"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="345"/>
        <source>Colors</source>
        <translation type="unfinished">Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="81"/>
        <source>Parent Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="82"/>
        <source>Font Face</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="83"/>
        <source>Font Size</source>
        <translation type="unfinished">Ukuran Font</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="85"/>
        <source>Baseline Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="86"/>
        <source>Horizontal Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="87"/>
        <source>Vertical Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="89"/>
        <source>Fill Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="90"/>
        <source>Fill Shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="91"/>
        <source>Stroke Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="92"/>
        <source>Stroke Shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="221"/>
        <source>A default style cannot be assigned a parent style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMCharacterStyle</name>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1788"/>
        <source>Properties</source>
        <translation type="unfinished">Properti</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1419"/>
        <source>Character Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1424"/>
        <source>Character Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1564"/>
        <source>New Style</source>
        <translation type="unfinished">Gaya Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1586"/>
        <source>Clone of %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1613"/>
        <source>%1 (%2)</source>
        <comment>This for unique name when creating a new character style. %1 will be the name of the style and %2 will be a number forming a style name like: New Style (2)</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="2260"/>
        <source>Setting that style as parent would create an infinite loop.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMColorCombo</name>
    <message>
        <location filename="../../scribus/smcolorcombo.cpp" line="121"/>
        <source>Use Parent Value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMFontComboH</name>
    <message>
        <location filename="../../scribus/smfontcomboh.cpp" line="15"/>
        <source>Use Parent Font</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMLineStyle</name>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="33"/>
        <source>Properties</source>
        <translation type="unfinished">Properti</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="42"/>
        <source>Line Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="47"/>
        <source>Line Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="190"/>
        <source>New Style</source>
        <translation type="unfinished">Gaya Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="200"/>
        <source>Clone of %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="216"/>
        <source>%1 (%2)</source>
        <comment>This for unique name when creating a new character style. %1 will be the name of the style and %2 will be a number forming a style name like: New Style (2)</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="599"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="679"/>
        <source>Solid Line</source>
        <translation type="unfinished">Garis Solid</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="682"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Garis Putus-putus</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="685"/>
        <source>Dotted Line</source>
        <translation type="unfinished">Garis Titik-titik</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="688"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Garis Putus Titik</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="691"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Garis Putus Titik Titik</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="675"/>
        <source> pt </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMLineStyleWidget</name>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="36"/>
        <source>Flat Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="37"/>
        <source>Square Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="38"/>
        <source>Round Cap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="40"/>
        <source>Miter Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="41"/>
        <source>Bevel Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="42"/>
        <source>Round Join</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="62"/>
        <source>Add a new line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="63"/>
        <source>Remove a line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="64"/>
        <source>Line style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="65"/>
        <source>Line width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="66"/>
        <source>End style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="67"/>
        <source>Join style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="68"/>
        <source>Line color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="69"/>
        <source>Line shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="151"/>
        <source> pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.ui" line="234"/>
        <source>%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.ui" line="256"/>
        <source>Line Width:</source>
        <translation type="unfinished">Lebar Garis:</translation>
    </message>
</context>
<context>
    <name>SMPStyleWidget</name>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="330"/>
        <source>Fixed Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="331"/>
        <source>Automatic Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="332"/>
        <source>Align to Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="72"/>
        <source>Distances and Alignment</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="247"/>
        <source>Drop Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="562"/>
        <source>Tabulators and Indentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="20"/>
        <source>Properties</source>
        <translation type="unfinished">Properti</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="136"/>
        <source>Character Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="265"/>
        <source>&amp;Lines:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="289"/>
        <source>Distance from Text:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="95"/>
        <source>Alignment</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="81"/>
        <source>Parent Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="82"/>
        <source>Line Spacing Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="83"/>
        <source>Line Spacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="84"/>
        <source>Space Above</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="85"/>
        <source>Space Below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="93"/>
        <source>Drop Cap Lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="94"/>
        <source>Drop Cap Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="96"/>
        <source>First Line Indent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="97"/>
        <source>Left Indent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="98"/>
        <source>Right Indent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="34"/>
        <source>Based On:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="511"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="612"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="491"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="376"/>
        <source>Left Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="383"/>
        <source>Right Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="390"/>
        <source>Left Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="397"/>
        <source>Right Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="102"/>
        <source>Maximum white space compression allowed.
Expressed as a percentage of the current white space value.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="104"/>
        <source>Maximum compression of glyphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="106"/>
        <source>Maximum extension of glyphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="367"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="278"/>
        <source>A default style cannot be assigned a parent style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="138"/>
        <source>Min. Space Width:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="139"/>
        <source>Max. Glyph Compression:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="140"/>
        <source>Max. Glyph Extension:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="413"/>
        <source>Use Parent Value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="406"/>
        <source>Reset to Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="440"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMParagraphStyle</name>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="56"/>
        <source>Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="61"/>
        <source>Paragraph Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="227"/>
        <source>New Style</source>
        <translation type="unfinished">Gaya Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="249"/>
        <source>Clone of %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="277"/>
        <source>%1 (%2)</source>
        <comment>This for unique name when creating a new character style. %1 will be the name of the style and %2 will be a number forming a style name like: New Style (2)</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1359"/>
        <source>Setting that style as parent would create an infinite loop.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMReplaceDia</name>
    <message>
        <location filename="../../scribus/smreplacedia.cpp" line="65"/>
        <source>Remove</source>
        <translation type="unfinished">Hapus</translation>
    </message>
    <message>
        <location filename="../../scribus/smreplacedia.cpp" line="66"/>
        <source>Replace with</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smreplacedia.ui" line="13"/>
        <source>Delete Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smreplacedia.ui" line="65"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smreplacedia.ui" line="81"/>
        <source>Ca&amp;ncel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smreplacedia.ui" line="84"/>
        <source>Alt+N</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMRowWidget</name>
    <message>
        <location filename="../../scribus/smreplacedia.cpp" line="23"/>
        <source>No Style</source>
        <translation type="unfinished">Tanpa Gaya</translation>
    </message>
</context>
<context>
    <name>SMScComboBox</name>
    <message>
        <location filename="../../scribus/smsccombobox.cpp" line="180"/>
        <source>Use Parent Value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMShadeButton</name>
    <message>
        <location filename="../../scribus/smshadebutton.cpp" line="74"/>
        <source>Use Parent Value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMStyleImport</name>
    <message>
        <location filename="../../scribus/smstyleimport.cpp" line="22"/>
        <source>Character Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.cpp" line="34"/>
        <source>Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.cpp" line="46"/>
        <source>Line Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="13"/>
        <source>Choose Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="26"/>
        <source>Available Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="47"/>
        <source>&amp;Rename Imported Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="57"/>
        <source>R&amp;eplace Existing Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="34"/>
        <source>Select or Unselect All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleimport.ui" line="41"/>
        <source>In case of a name clash</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMStyleSelect</name>
    <message>
        <location filename="../../scribus/smstyleselect.cpp" line="20"/>
        <source>P</source>
        <comment>P as in Parent</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smstyleselect.cpp" line="21"/>
        <source>Use parent style&apos;s effects instead of overriding them</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMTabruler</name>
    <message>
        <location filename="../../scribus/smtabruler.cpp" line="20"/>
        <source> Parent Tabs </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SToolBAlign</name>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1309"/>
        <source>Style Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1336"/>
        <source>Style of current paragraph</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SToolBColorF</name>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1036"/>
        <source>Fill Color Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1073"/>
        <source>Color of text fill</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1074"/>
        <source>Saturation of color of text fill</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SToolBColorS</name>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1111"/>
        <source>Stroke Color Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1146"/>
        <source>Color of text stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1147"/>
        <source>Saturation of color of text stroke</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SToolBFont</name>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1356"/>
        <source>Font Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1409"/>
        <source>Font of selected text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1410"/>
        <source>Font Size</source>
        <translation type="unfinished">Ukuran Font</translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1411"/>
        <source>Scaling width of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1412"/>
        <source>Scaling height of characters</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SToolBStyle</name>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1179"/>
        <source>Character Settings</source>
        <translation type="unfinished">Pengaturan Karakter</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Manual Kerning</source>
        <translation type="obsolete">Penonjolan Manual</translation>
    </message>
    <message>
        <location filename="../../scribus/storyeditor.cpp" line="1221"/>
        <source>Manual Tracking</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SVGExportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="105"/>
        <source>Exports SVG Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="106"/>
        <source>Exports the current page into an SVG file.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="89"/>
        <source>Save as &amp;SVG...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="131"/>
        <source>Compress File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="135"/>
        <source>Save Images inline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="136"/>
        <source>Adds all Images on the Page inline to the SVG.
Caution: this will increase the file size!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="140"/>
        <source>Export Page background</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="141"/>
        <source>Adds the Page itself as background to the SVG.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SVGImportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="93"/>
        <source>Import &amp;SVG...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="108"/>
        <source>Imports SVG Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="109"/>
        <source>Imports most SVG files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="192"/>
        <source>SVG file contains some unsupported features</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="190"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SVGPlug</name>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="988"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SWDialog</name>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="104"/>
        <source>Short Words</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="105"/>
        <source>Apply unbreakable space on:</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="106"/>
        <source>&amp;Selected frames</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="107"/>
        <source>Active &amp;page</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="108"/>
        <source>&amp;All items</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="111"/>
        <source>Only selected frames processed.</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="112"/>
        <source>Only actual page processed.</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/vlnadialog.cpp" line="113"/>
        <source>All items in document processed.</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="14"/>
        <source>Short Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="65"/>
        <source>&amp;Languages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="20"/>
        <source>Apply Unbreakable Space On:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="26"/>
        <source>&amp;Selected Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="33"/>
        <source>Active &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="40"/>
        <source>&amp;All Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="50"/>
        <source>Language Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swdialog.ui" line="56"/>
        <source>&amp;Use Language from Style Definition</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SWPrefsGui</name>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="62"/>
        <source>User settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="67"/>
        <source>System wide configuration</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="92"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="93"/>
        <source>&amp;Reset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="95"/>
        <source>Save user configuration</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="96"/>
        <source>Reload system wide configuration and remove user defined one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="97"/>
        <source>Edit custom configuration. If you save it, it will be used over system wide configuration</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="122"/>
        <source>Short Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="123"/>
        <source>Cannot write file %1.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="130"/>
        <source>User settings saved</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="141"/>
        <source>System wide configuration reloaded</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="155"/>
        <source>Cannot open file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/swprefsgui.cpp" line="112"/>
        <source>User configuration exists already. Do you really want to overwrite it?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SaveAsTemplatePlugin</name>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="54"/>
        <source>Save as &amp;Template...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="74"/>
        <source>Save a document as a template</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="76"/>
        <source>Save a document as a template. Good way to ease the initial work for documents with a constant look</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScGTFileDialog</name>
    <message>
        <location filename="../../scribus/scgtplugin.cpp" line="108"/>
        <source>Select a file to import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scgtplugin.cpp" line="128"/>
        <source>Append</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scgtplugin.cpp" line="130"/>
        <source>Show options</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScInputDialog</name>
    <message>
        <location filename="../../scribus/scinputdialog.cpp" line="80"/>
        <source>Input Dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scinputdialog.cpp" line="81"/>
        <source>InputDialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scinputdialog.cpp" line="82"/>
        <source>&amp;OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scinputdialog.cpp" line="84"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScPlugin</name>
    <message>
        <location filename="../../scribus/scplugin.cpp" line="48"/>
        <source>Persistent</source>
        <comment>plugin manager plugin type</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Import</source>
        <comment>plugin manager plugin type</comment>
        <translation type="obsolete">Impor</translation>
    </message>
    <message>
        <location filename="../../scribus/scplugin.cpp" line="50"/>
        <source>Action</source>
        <comment>plugin manager plugin type</comment>
        <translation type="unfinished">Aksi</translation>
    </message>
    <message>
        <location filename="../../scribus/scplugin.cpp" line="46"/>
        <source>Load/Save/Import/Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scplugin.cpp" line="54"/>
        <source>Unknown</source>
        <translation type="unfinished">Tidak diketahui</translation>
    </message>
</context>
<context>
    <name>ScPrintEngine_GDI</name>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="257"/>
        <source>Printing...</source>
        <translation type="obsolete">Mencetak...</translation>
    </message>
</context>
<context>
    <name>ScProgressBar</name>
    <message>
        <location filename="../../scribus/scprogressbar.cpp" line="56"/>
        <source>%1 of %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScToolBar</name>
    <message>
        <location filename="../sctoolbar.cpp" line="274"/>
        <source>Horizontal</source>
        <translation type="obsolete">Horisontal</translation>
    </message>
    <message>
        <location filename="../sctoolbar.cpp" line="275"/>
        <source>Vertical</source>
        <translation type="obsolete">Vertikal</translation>
    </message>
</context>
<context>
    <name>ScWinPrint</name>
    <message>
        <location filename="../scwinprint.cpp" line="323"/>
        <source>Printing...</source>
        <translation type="obsolete">Mencetak...</translation>
    </message>
</context>
<context>
    <name>ScriXmlDoc</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Background</source>
        <translation type="obsolete">Latar Belakang</translation>
    </message>
</context>
<context>
    <name>Scribus12Format</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="107"/>
        <source>Scribus 1.2.x Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../plugins/fileloader/scribus12format/scribus12format.cpp" line="737"/>
        <source>Background</source>
        <translation type="obsolete">Latar Belakang</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="1723"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="67"/>
        <source>Scribus 1.2.x File Format Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="68"/>
        <source>Allows Scribus to read Scribus 1.2.x formatted files.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Scribus134Format</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="3471"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="74"/>
        <source>Scribus 1.3.4+ File Format Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="75"/>
        <source>Allows Scribus to read Scribus 1.3.4 and higher formatted files.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="92"/>
        <source>Scribus 1.3.4+ Document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Scribus13Format</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="3066"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="89"/>
        <source>Scribus 1.3.0-&gt;1.3.3.7 Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="71"/>
        <source>Scribus 1.3.x File Format Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="72"/>
        <source>Allows Scribus to read Scribus 1.3.0-&gt;1.3.3.x formatted files.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusApp</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>File</source>
        <translation type="obsolete">Berkas</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Searching for Fonts</source>
        <translation type="obsolete">Mencari Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>There are no Postscript-Fonts on your System</source>
        <translation type="obsolete">Tidak ada Font Postscript pada Sistem anda</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Exiting now</source>
        <translation type="obsolete">Keluar sekarang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Fatal Error</source>
        <translation type="obsolete">Kesalahan Fatal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Align Left</source>
        <translation type="obsolete">Bariskan di Kiri</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Align Right</source>
        <translation type="obsolete">Bariskan di Kanan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Align Center</source>
        <translation type="obsolete">Bariskan di Tengah</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Attach Text to Path</source>
        <translation type="obsolete">Masukkan Teks ke Path</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Show Layers</source>
        <translation type="obsolete">Tampilkan Layer</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Undo</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Show Page Palette</source>
        <translation type="obsolete">Tampilkan Palet Halaman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Reading Preferences</source>
        <translation type="obsolete">Membaca Preferensi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Setting up Shortcuts</source>
        <translation type="obsolete">Mengatur Shortcut</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Reading Scrapbook</source>
        <translation type="obsolete">Membaca Scrapbook</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Initializing Plugins</source>
        <translation type="obsolete">Inisialisasi Plugin</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>New</source>
        <translation type="obsolete">Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Open...</source>
        <translation type="obsolete">Buka...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Close</source>
        <translation type="obsolete">Tutup</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Save</source>
        <translation type="obsolete">Simpan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Save as...</source>
        <translation type="obsolete">Simpan sebagai...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Document Info...</source>
        <translation type="obsolete">Informasi Dokumen...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Document Setup...</source>
        <translation type="obsolete">Pengaturan Dokumen...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Print...</source>
        <translation type="obsolete">Cetak...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Quit</source>
        <translation type="obsolete">Keluar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cut</source>
        <translation type="obsolete">Cut</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Copy</source>
        <translation type="obsolete">Salin</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Paste</source>
        <translation type="obsolete">Tempel</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Clear</source>
        <translation type="obsolete">Bersihkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Select all</source>
        <translation type="obsolete">Pilih semua</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Colors...</source>
        <translation type="obsolete">Warna...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Styles...</source>
        <translation type="obsolete">Gaya...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Templates...</source>
        <translation type="obsolete">Template...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Duplicate</source>
        <translation type="obsolete">Salin</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Penyalinan Banyak</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete</source>
        <translation type="obsolete">Hapus</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Group</source>
        <translation type="obsolete">Grup</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Send to Back</source>
        <translation type="obsolete">Bawa ke Belakang</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Bring to Front</source>
        <translation type="obsolete">Bawa ke Depan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Lower</source>
        <translation type="obsolete">Turunkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Raise</source>
        <translation type="obsolete">Naikkan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Distribute/Align...</source>
        <translation type="obsolete">Sebar/Bariskan...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Insert...</source>
        <translation type="obsolete">Masukkan...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete...</source>
        <translation type="obsolete">Hapus...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Move...</source>
        <translation type="obsolete">Pindah...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Apply Template...</source>
        <translation type="obsolete">Terapkan Template...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Guides...</source>
        <translation type="obsolete">Atur Pemandu...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Fit in Window</source>
        <translation type="obsolete">Pas di Window</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Thumbnails</source>
        <translation type="obsolete">Thumbnail</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Hide Margins</source>
        <translation type="obsolete">Sembunyikan Garis Tepi</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Hide Frames</source>
        <translation type="obsolete">Sembunyikan Frame</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Hide Images</source>
        <translation type="obsolete">Sembunyikan Gambar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Show Grid</source>
        <translation type="obsolete">Tampilkan Grid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Snap to Grid</source>
        <translation type="obsolete">Dekatkan ke Grid</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Properties</source>
        <translation type="obsolete">Properti</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Outline</source>
        <translation type="obsolete">Outline</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Scrapbook</source>
        <translation type="obsolete">Scrapbook</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Manajemen Gambar</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Tools</source>
        <translation type="obsolete">Alat bantu</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Fonts...</source>
        <translation type="obsolete">Font...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>About Scribus</source>
        <translation type="obsolete">Tentang Scribus</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>About Qt</source>
        <translation type="obsolete">Tentang Qt</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Online-Help...</source>
        <translation type="obsolete">Bantuan Online...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Underline</source>
        <translation type="obsolete">Garis Bawah</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Strikethru</source>
        <translation type="obsolete">Coret</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Ready</source>
        <translation type="obsolete">Siap</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Get Text/Picture...</source>
        <translation type="obsolete">Ambil Teks/Gambar...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Get Picture...</source>
        <translation type="obsolete">Ambil Gambar...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Font</source>
        <translation type="obsolete">&amp;Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Size</source>
        <translation type="obsolete">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Get Text...</source>
        <translation type="obsolete">Ambil Teks...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Font</source>
        <translation type="obsolete">Font</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Size</source>
        <translation type="obsolete">Ukuran</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Style</source>
        <translation type="obsolete">Gaya</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Color</source>
        <translation type="obsolete">Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Shade</source>
        <translation type="obsolete">Tingkat Kegelapan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Open</source>
        <translation type="obsolete">Buka</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Import</source>
        <translation type="obsolete">Impor</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Loading...</source>
        <translation type="obsolete">Memuat...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Can&apos;t write the File: 
%1</source>
        <translation type="obsolete">Tidak dapat menulis ke File: 
%1</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Save as</source>
        <translation type="obsolete">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Printing...</source>
        <translation type="obsolete">Mencetak...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Document</source>
        <translation type="obsolete">Dokumen</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Printing failed!</source>
        <translation type="obsolete">Pencetakan gagal!</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Scribus Manual</source>
        <translation type="obsolete">Manual Scribus</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>The following Programs are missing:</source>
        <translation type="obsolete">Program berikut ini tidak ditemukan:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>All</source>
        <translation type="obsolete">Semua</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Cancel</source>
        <translation type="obsolete">Batal</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Unlock</source>
        <translation type="obsolete">Buka Kunci</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Lock</source>
        <translation type="obsolete">Kunci</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Loading:</source>
        <translation type="obsolete">Memuat:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Adjusting Colors</source>
        <translation type="obsolete">Mengatur Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>German</source>
        <translation type="obsolete">Jerman</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>English</source>
        <translation type="obsolete">Inggris</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Spanish</source>
        <translation type="obsolete">Spanyol</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Italian</source>
        <translation type="obsolete">Italia</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>French</source>
        <translation type="obsolete">Perancis</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Russian</source>
        <translation type="obsolete">Rusia</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Slovak</source>
        <translation type="obsolete">Slovakia</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Choose a Directory</source>
        <translation type="obsolete">Pilih Direktori</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Invert</source>
        <translation type="obsolete">Balik</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name:</source>
        <translation type="obsolete">Nama:</translation>
    </message>
</context>
<context>
    <name>ScribusColorList</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Color</source>
        <translation type="obsolete">Warna</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
</context>
<context>
    <name>ScribusCore</name>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="170"/>
        <source>Initializing Plugins</source>
        <translation type="unfinished">Inisialisasi Plugin</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="182"/>
        <source>Initializing Keyboard Shortcuts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="184"/>
        <source>Reading Preferences</source>
        <translation type="unfinished">Membaca Preferensi</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="331"/>
        <source>Searching for Fonts</source>
        <translation type="unfinished">Mencari Font</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="336"/>
        <source>There are no fonts found on your system.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="337"/>
        <source>Exiting now.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="338"/>
        <source>Fatal Error</source>
        <translation type="unfinished">Kesalahan Fatal</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="341"/>
        <source>Font System Initialized</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="196"/>
        <source>Reading Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusDoc</name>
    <message>
        <location filename="../scribusdoc.cpp" line="1595"/>
        <source>New Layer</source>
        <translation type="obsolete">Layer Baru</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="227"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="470"/>
        <source>Background</source>
        <translation type="unfinished">Latar Belakang</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7066"/>
        <source>Do you really want to clear all your text?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7110"/>
        <source>Cannot Delete In-Use Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7110"/>
        <source>The item %1 is currently being edited by Story Editor. The delete operation will be cancelled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7627"/>
        <source>Some objects are locked.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7623"/>
        <source>&amp;Unlock All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="7624"/>
        <source>&amp;Skip locked objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="715"/>
        <source>An error occurred while opening ICC profiles, color management is not enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="8761"/>
        <source>Number of copies: %1
Horizontal gap: %2
Vertical gap: %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="847"/>
        <source>Adjusting Colors</source>
        <translation type="unfinished">Mengatur Warna</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="5758"/>
        <source>remove direct paragraph formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="6004"/>
        <source>remove direct char formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="8732"/>
        <source>Number of copies: %1
Horizontal shift: %2
Vertical shift: %3
Rotation: %4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="9789"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="2571"/>
        <source>Copy_of_</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusdoc.cpp" line="1196"/>
        <source>Imported </source>
        <comment>Prefix of imported default style</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusMainWindow</name>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Initializing Plugins</source>
        <translation type="obsolete">Inisialisasi Plugin</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Reading Preferences</source>
        <translation type="obsolete">Membaca Preferensi</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="336"/>
        <source>Initializing Story Editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="342"/>
        <source>Initializing Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="348"/>
        <source>Reading Scrapbook</source>
        <translation type="unfinished">Membaca Scrapbook</translation>
    </message>
    <message>
        <location filename="../scribus.cpp" line="306"/>
        <source>Setting up Shortcuts</source>
        <translation type="obsolete">Mengatur Shortcut</translation>
    </message>
    <message>
        <location filename="../scribus.cpp" line="373"/>
        <source>File</source>
        <translation type="obsolete">Berkas</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Searching for Fonts</source>
        <translation type="obsolete">Mencari Font</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3793"/>
        <source>Fatal Error</source>
        <translation type="unfinished">Kesalahan Fatal</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9240"/>
        <source>Open &amp;Recent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9242"/>
        <source>&amp;Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9243"/>
        <source>&amp;Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../scribus.cpp" line="9306"/>
        <source>&amp;Size</source>
        <translation type="obsolete">U&amp;kuran</translation>
    </message>
    <message>
        <location filename="../scribus.cpp" line="9308"/>
        <source>&amp;Font</source>
        <translation type="obsolete">&amp;Font</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="727"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="711"/>
        <source>Level</source>
        <translation type="unfinished">Level</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="717"/>
        <source>Send to La&amp;yer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9250"/>
        <source>&amp;PDF Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9252"/>
        <source>C&amp;onvert To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9255"/>
        <source>Character</source>
        <translation type="unfinished">Karakter</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9256"/>
        <source>Quote</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9257"/>
        <source>Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9265"/>
        <source>&amp;Alignment</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9275"/>
        <source>Ready</source>
        <translation type="unfinished">Siap</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4145"/>
        <source>Open</source>
        <translation type="unfinished">Buka</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3602"/>
        <source>Importing Pages...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3631"/>
        <source>Import Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3673"/>
        <source>Import done</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3677"/>
        <source>Found nothing to import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3793"/>
        <source>File %1 is not in an acceptable format</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3814"/>
        <source>Loading...</source>
        <translation type="unfinished">Memuat...</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3961"/>
        <source> was replaced by: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3993"/>
        <source>(converted)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7953"/>
        <source>Cannot write the file: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7788"/>
        <source>Save As</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4394"/>
        <source>Saving...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7650"/>
        <source>Scribus has detected some errors. Consider using the Preflight Verifier to correct them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4693"/>
        <source>Printing...</source>
        <translation type="unfinished">Mencetak...</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7765"/>
        <source>Document</source>
        <translation type="unfinished">Dokumen</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4734"/>
        <source>Printing failed!</source>
        <translation type="unfinished">Pencetakan gagal!</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4824"/>
        <source>Cannot Cut In-Use Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4824"/>
        <source>The item %1 is currently being edited by Story Editor. The cut operation will be cancelled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="5372"/>
        <source>About Qt</source>
        <translation type="unfinished">Tentang Qt</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="5383"/>
        <source>Scribus Manual</source>
        <translation type="unfinished">Manual Scribus</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7860"/>
        <source>Save as</source>
        <translation type="obsolete">Simpan sebagai</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="5413"/>
        <source>Text Files (*.txt);;All Files(*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="../scribus.cpp" line="5457"/>
        <source>Name:</source>
        <translation type="obsolete">Nama:</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="6802"/>
        <source>&amp;Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="6802"/>
        <source>Size</source>
        <translation type="unfinished">Ukuran</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="6832"/>
        <source>&amp;Shade:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="6832"/>
        <source>Shade</source>
        <translation type="unfinished">Tingkat Kegelapan</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="6936"/>
        <source>No Style</source>
        <translation type="unfinished">Tanpa Gaya</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7547"/>
        <source>The following programs are missing:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7549"/>
        <source>Ghostscript : You cannot use EPS images or Print Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7686"/>
        <source>All</source>
        <translation type="unfinished">Semua</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7734"/>
        <source>Scribus detected some errors.
Consider using the Preflight Verifier  to correct them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7831"/>
        <source>Detected some errors.
Consider using the Preflight Verifier to correct them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7927"/>
        <source>-Page%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="8309"/>
        <source>Some objects are locked.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="8305"/>
        <source>&amp;Lock All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="8306"/>
        <source>&amp;Unlock All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9010"/>
        <source>Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9010"/>
        <source>The program %1 is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9049"/>
        <source>The program %1 is missing!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9163"/>
        <source>The selected color does not exist in the document&apos;s color set. Please enter a name for this new color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9166"/>
        <source>Color Not Found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9170"/>
        <source>The name you have selected already exists. Please enter a different name for this new color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9247"/>
        <source>&amp;Level</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9248"/>
        <source>Send to Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9249"/>
        <source>Previe&amp;w Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9271"/>
        <source>X-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9272"/>
        <source>Y-Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7551"/>
        <source>Ghostscript : You cannot use EPS images or PostScript Print Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9425"/>
        <source>Do you really want to replace your existing image?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9245"/>
        <source>Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="790"/>
        <source>&amp;Character</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="808"/>
        <source>&amp;Quote</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="833"/>
        <source>S&amp;paces &amp;&amp; Breaks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9258"/>
        <source>Liga&amp;ture</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9241"/>
        <source>Paste Recent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4362"/>
        <source>Documents (*.sla *.sla.gz);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4176"/>
        <source>Do you really want to clear all your text?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="283"/>
        <source>Scribus </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9266"/>
        <source>Online &amp;Tutorials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3958"/>
        <source>Some color profiles used by this document are not installed:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7788"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="320"/>
        <source>Applying User Shortcuts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="2484"/>
        <source>Updating Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4378"/>
        <source>Your document was saved to a temporary file and could not be moved: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4789"/>
        <source>Print engine initialization failed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3451"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9479"/>
        <source>&amp;Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="9479"/>
        <source>New Entry</source>
        <translation type="unfinished">Entri Baru</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="7598"/>
        <source>Ghostscript is missing : PostScript Print Preview is not available</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusQApp</name>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="199"/>
        <source>Invalid argument: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="219"/>
        <source>File %1 does not exist, aborting.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="405"/>
        <source>Usage: scribus [option ... ] [file]</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="406"/>
        <source>Options:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="408"/>
        <source>Print help (this message) and exit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="409"/>
        <source>Uses xx as shortcut for a language, eg `en&apos; or `de&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="410"/>
        <source>List the currently installed interface languages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="407"/>
        <source>Show information on the console when fonts are being loaded</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="411"/>
        <source>Do not show the splashscreen on startup</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="417"/>
        <source>Output version information and exit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="415"/>
        <source>Use right to left dialog button ordering (eg. Cancel/No/Yes instead of Yes/No/Cancel)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="413"/>
        <source>filename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="413"/>
        <source>Use filename as path for user given preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="436"/>
        <source>Installed interface languages for Scribus are as follows:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="444"/>
        <source>To override the default language choice:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="445"/>
        <source>scribus -l xx or scribus --lang xx, where xx is the language of choice.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="450"/>
        <source>Scribus Version</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="459"/>
        <source>Scribus, Open Source Desktop Publishing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="467"/>
        <source>Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="468"/>
        <source>Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="469"/>
        <source>Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="470"/>
        <source>Issues</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="412"/>
        <source>Stop the showing of the splashscreen on startup. Writes an empty file called .neversplash in ~/.scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="416"/>
        <source>Download a file from the Scribus website and show the latest available version.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="421"/>
        <source>Display a console window</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="414"/>
        <source>Show location ICC profile information on console while starting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusapp.cpp" line="217"/>
        <source>Invalid argument: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusView</name>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="208"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>All</source>
        <translation type="obsolete">Semua</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="1083"/>
        <source>Copy Here</source>
        <translation type="unfinished">Salin ke Sini</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="1084"/>
        <source>Move Here</source>
        <translation type="unfinished">Pindah ke Sini</translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="1085"/>
        <source>Cancel</source>
        <translation type="unfinished">Batal</translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="407"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../scribusview.cpp" line="2967"/>
        <source>Text Frame</source>
        <translation type="obsolete">Frame Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="5285"/>
        <source>Print: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="5287"/>
        <source>Enabled</source>
        <translation type="unfinished">Bolehkan</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="5289"/>
        <source>Disabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="137"/>
        <source>In&amp;fo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3493"/>
        <source>&amp;PDF Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="296"/>
        <source>Send to La&amp;yer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="330"/>
        <source>Le&amp;vel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="355"/>
        <source>Conve&amp;rt to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="2001"/>
        <source>Linking Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="3926"/>
        <source>Cannot Convert In-Use Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="3926"/>
        <source>The item %1 is currently being edited by Story Editor. The convert to outlines operation for this item will be skipped</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="2429"/>
        <source>Page %1 to %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="423"/>
        <source>Unknown</source>
        <translation type="obsolete">Tidak diketahui</translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="387"/>
        <source>Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="413"/>
        <source>Paste Recent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="3620"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="421"/>
        <source>Preview Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="422"/>
        <source>CMS is active. Therefore the color display may not match the perception by visually impaired</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="2847"/>
        <source>Enter Object Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="1995"/>
        <source>You are trying to link a frame to itself.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="2002"/>
        <source>You are trying to link a frame which is already linked.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="362"/>
        <source>Enable/disable Color Management</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="364"/>
        <source>Enable/disable the Preview Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="365"/>
        <source>Select the visual appearance of the display. You can choose between normal and several color blindness forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="363"/>
        <source>Configure CMS...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="353"/>
        <source>Zoom to 100%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="354"/>
        <source>Zoom out by the stepping value in Tools preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="355"/>
        <source>Zoom in by the stepping value in Tools preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="356"/>
        <source>Current zoom level</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="359"/>
        <source>Select the current layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribusview.cpp" line="360"/>
        <source>Select the current unit</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScribusWin</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Warning</source>
        <translation type="obsolete">Peringatan</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuswin.cpp" line="110"/>
        <source>Document:</source>
        <translation type="unfinished">Dokumen:</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuswin.cpp" line="112"/>
        <source>has been changed since the last save.</source>
        <translation type="unfinished">telah dirubah sejak terakhir disimpan.</translation>
    </message>
</context>
<context>
    <name>ScriptPlugin</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="144"/>
        <source>Embedded Python scripting support.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="199"/>
        <source>Scripter</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScripterCore</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="588"/>
        <source>Script error</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="357"/>
        <source>If you are running an official script report it at &lt;a href=&quot;http://bugs.scribus.net&quot;&gt;bugs.scribus.net&lt;/a&gt; please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="359"/>
        <source>This message is in your clipboard too. Use Ctrl+V to paste it into bug tracker.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="435"/>
        <source>There was an internal error while trying the command you entered. Details were printed to stderr. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="511"/>
        <source>Examine Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="590"/>
        <source>Setting up the Python plugin failed. Error details were printed to stderr. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="524"/>
        <source>Documentation for:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="529"/>
        <source>Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="529"/>
        <source> doesn&apos;t contain any docstring!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="511"/>
        <source>Python Scripts (*.py *.PY);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ScripterPrefsGui</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.cpp" line="60"/>
        <source>Scripter Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="89"/>
        <source>Enable Extension Scripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="50"/>
        <source>Extensions</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="118"/>
        <source>Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="70"/>
        <source>Startup Script:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="80"/>
        <source>Change...</source>
        <translation type="unfinished">Ubah...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.cpp" line="129"/>
        <source>Locate Startup Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="13"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="164"/>
        <source>Comments:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="171"/>
        <source>Keywords:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="178"/>
        <source>Signs:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="185"/>
        <source>Strings:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="192"/>
        <source>Numbers:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="199"/>
        <source>Errors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scripterprefsgui.ui" line="206"/>
        <source>Base Texts:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SeList</name>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="59"/>
        <source>Show Page Previews</source>
        <translation type="unfinished">Tampilkan Prapandang Halaman</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="119"/>
        <source>Delete Master Page?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="120"/>
        <source>Are you sure you want to delete this master page?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SeView</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Show Template Names</source>
        <translation type="obsolete">Pilih Nama Template</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="388"/>
        <source>Delete Page?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="389"/>
        <source>Are you sure you want to delete this page?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SearchReplace</name>
    <message>
        <location filename="../../scribus/search.cpp" line="608"/>
        <source>Search/Replace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="59"/>
        <source>Search for:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="154"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="160"/>
        <source>Font</source>
        <translation type="unfinished">Font</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="163"/>
        <source>Font Size</source>
        <translation type="unfinished">Ukuran Font</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="166"/>
        <source>Font Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="169"/>
        <source>Fill Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="172"/>
        <source>Fill Shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="175"/>
        <source>Stroke Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="178"/>
        <source>Stroke Shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="96"/>
        <source>Left</source>
        <translation type="unfinished">Kiri</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="96"/>
        <source>Center</source>
        <translation type="unfinished">Tengah</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="96"/>
        <source>Right</source>
        <translation type="unfinished">Kanan</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="96"/>
        <source>Block</source>
        <translation type="unfinished">Blok</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="96"/>
        <source>Forced</source>
        <translation type="unfinished">Paksakan</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <translation type="obsolete">Kosong</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="148"/>
        <source>Replace with:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="238"/>
        <source>&amp;Whole Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="242"/>
        <source>&amp;Ignore Case</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="251"/>
        <source>&amp;Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="254"/>
        <source>&amp;Replace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="257"/>
        <source>Replace &amp;All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="262"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Tutup</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="515"/>
        <source>Search finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="260"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/search.cpp" line="609"/>
        <source>Search fi