<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS><TS version="1.1">
<context>
    <name></name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="21"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="35"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="50"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="64"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="77"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="94"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="106"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="22"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="46"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="88"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="101"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="111"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="55"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="96"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="108"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="117"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="128"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="141"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="152"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="162"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="173"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="185"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="196"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="206"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="218"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="226"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="233"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="241"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="249"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="256"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="21"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="31"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="41"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="51"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="61"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="71"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="81"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="91"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="102"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="113"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="124"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="134"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="145"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="155"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="165"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="177"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="189"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="200"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="209"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="83"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="101"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="135"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="165"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="23"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="35"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="48"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="59"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="69"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="80"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="89"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="98"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="107"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="118"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="126"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="141"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="153"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="166"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="177"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="187"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="199"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="24"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="33"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="43"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="62"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="71"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="83"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="92"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="105"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="118"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="131"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="144"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="157"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="170"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="182"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="194"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="208"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="222"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="236"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="250"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="263"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="275"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="287"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="300"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="311"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="320"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="329"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="338"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="26"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="43"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="60"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="75"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="90"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="108"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="128"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="149"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="165"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="177"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="193"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="211"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="227"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="240"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="252"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="26"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="36"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="45"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="54"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="65"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="78"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="91"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="100"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="110"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="123"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="132"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="141"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="151"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="167"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="181"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="198"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="22"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="33"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="43"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="53"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="63"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="73"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="83"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="96"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="110"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="121"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="132"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="143"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="157"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="169"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="181"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="43"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="80"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="23"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="35"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="45"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="55"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="67"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="79"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="89"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="100"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="110"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="120"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="132"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="146"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="159"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="173"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="186"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="199"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="211"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="223"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="236"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="250"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="261"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="272"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="282"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="295"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="308"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="325"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="338"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="352"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="365"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="379"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="394"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="406"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="21"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="34"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="47"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="61"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="69"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="83"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="95"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="106"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="21"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="33"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="45"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="57"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>@default</name>
    <message>
        <location filename="../plugins/fileloader/scribus12format/scribus12format.cpp" line="1593"/>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Kopie #%1 van</translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="124"/>
        <source>Importing: %1</source>
        <translation type="unfinished">Importeren: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="127"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="264"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="2226"/>
        <source>Generating Items</source>
        <translation type="unfinished">Verwerk items</translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../scribus/about.cpp" line="187"/>
        <source>&amp;About</source>
        <translation>Inf&amp;o</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="304"/>
        <source>Contributions from:</source>
        <translation>Bijdragen van:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="200"/>
        <source>A&amp;uthors</source>
        <translation>A&amp;uteurs</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="214"/>
        <source>&amp;Translations</source>
        <translation>Ver&amp;talingen</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="225"/>
        <source>&amp;Online</source>
        <translation>&amp;Online</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="264"/>
        <source>&amp;Close</source>
        <translation>&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="296"/>
        <source>Development Team:</source>
        <translation>Ontwikkelteam:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="306"/>
        <source>Official Documentation:</source>
        <translation>Officiële documentatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="310"/>
        <source>Other Documentation:</source>
        <translation>Andere documentatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="344"/>
        <source>Homepage</source>
        <translation>Homepage</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="346"/>
        <source>Online Reference</source>
        <translation>Online handleiding</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="350"/>
        <source>Bugs and Feature Requests</source>
        <translation>Fouten en wensen</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="354"/>
        <source>Mailing List</source>
        <translation>Mailinglijst</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>Info over Scribus %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="328"/>
        <source>Official Translations and Translators:</source>
        <translation>Officiële vertalingen en vertalers:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="330"/>
        <source>Previous Translation Contributors:</source>
        <translation>Eerdere bijdragers van vertalingen:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="348"/>
        <source>Wiki</source>
        <translation>Wiki</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="124"/>
        <source>%1 %2 %3</source>
        <translation>%1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="132"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation>%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="182"/>
        <source>Using Ghostscript version %1</source>
        <translation>Ghostscript versie %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="184"/>
        <source>No Ghostscript version available</source>
        <translation>Geen Ghostscript beschikbaar</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="132"/>
        <source>&lt;b&gt;Scribus Version %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</source>
        <translation type="obsolete">&lt;b&gt;Scribus Versie %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Build ID:</source>
        <translation>Build ID:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="298"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation>Mac OS&amp;#174; X Aqua Port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="302"/>
        <source>Windows&amp;#174; Port:</source>
        <translation>Windows&amp;#174; Port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="316"/>
        <source>Tango Project Icons:</source>
        <translation>Tango project iconen:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="300"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation>OS/2&amp;#174;/eComStation&amp;#8482; Port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="228"/>
        <source>&amp;Updates</source>
        <translation>&amp;Updates</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="411"/>
        <source>Check for &amp;Updates</source>
        <translation type="obsolete">Zoek naar &amp;updates</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus. The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support. Last Letter is the renderer C=cairo or A=libart Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected. The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="obsolete">Dit scherm toont de versie, build datum en gecompileerde bibliotheek ondersteuning in Scribus. C-C-T-F staat gelijk aan C=littlecms C=CUPS T=TIFF ondersteuning F=Fontconfig ondersteuning. De laatste letter is de renderer C=cairo of A=libart. Ontbrekende bibliotheek ondersteuning wordt aangegeven met een *. Ook de door Scribus gevonden versie van Ghostscript wordt aangegeven. De Windows versie maakt geen gebruik van fontconfig of CUPS bibliotheken.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="276"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation>Zoeken naar updates voor Scribus. Door deze computer wordt geen data verzonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="314"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="272"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="273"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="274"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="275"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Scribus Version</source>
        <translation type="unfinished">Scribus versie</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="648"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="646"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="352"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="239"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="248"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="308"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="312"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="624"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation>Naam van het bestand:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation>Versie:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation>Aangezet:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation>Datum van publicatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation>Omschrijving:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation>Auteur(s):</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation>Auteursrecht:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation>Licentie:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished">Scribus: Over Plug-ins</translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="obsolete">Scribus: Over Plug-ins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1254"/>
        <source>&amp;New</source>
        <translation>&amp;Nieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1255"/>
        <source>&amp;Open...</source>
        <translation>&amp;Openen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1256"/>
        <source>&amp;Close</source>
        <translation>S&amp;luiten</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;Save</source>
        <translation>Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1258"/>
        <source>Save &amp;As...</source>
        <translation>Opslaan &amp;als...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1259"/>
        <source>Re&amp;vert to Saved</source>
        <translation>Terug&amp;zetten naar opgeslagen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1260"/>
        <source>Collect for O&amp;utput...</source>
        <translation>Verzamelen voor &amp;uitvoer...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1261"/>
        <source>Get Text...</source>
        <translation>Tekst verkrijgen ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1262"/>
        <source>Append &amp;Text...</source>
        <translation>Tekst &amp;toevoegen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1263"/>
        <source>Get Image...</source>
        <translation>Afbeelding verkrijgen ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1266"/>
        <source>Save &amp;Text...</source>
        <translation>&amp;Tekst opslaan...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1268"/>
        <source>Save as P&amp;DF...</source>
        <translation>Opslaan als P&amp;DF...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1269"/>
        <source>Document &amp;Setup...</source>
        <translation>Documentin&amp;stellingen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1271"/>
        <source>&amp;Print...</source>
        <translation>Afdru&amp;kken...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1273"/>
        <source>&amp;Quit</source>
        <translation>A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaan maken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1276"/>
        <source>&amp;Redo</source>
        <translation>O&amp;pnieuw doen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Item Action Mode</source>
        <translation>&amp;Item Actie Mode</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1278"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;ppen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1282"/>
        <source>&amp;Paste</source>
        <translation>Pla&amp;kken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1285"/>
        <source>Select &amp;All</source>
        <translation>&amp;Alles selecteren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1287"/>
        <source>&amp;Deselect All</source>
        <translation>Alle&amp;s deselecteren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1288"/>
        <source>&amp;Search/Replace...</source>
        <translation>&amp;Zoeken/vervangen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1289"/>
        <source>Edit Image...</source>
        <translation>Afbeelding bewerken ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1291"/>
        <source>C&amp;olors...</source>
        <translation>Kle&amp;uren...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1295"/>
        <source>&amp;Master Pages...</source>
        <translation>S&amp;jablonen ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1270"/>
        <source>P&amp;references...</source>
        <translation>&amp;Voorkeuren...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1303"/>
        <source>%1 pt</source>
        <translation>%1 pt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1305"/>
        <source>&amp;Other...</source>
        <translation>&amp;Overig...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1306"/>
        <source>&amp;Left</source>
        <translation>&amp;Links</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1307"/>
        <source>&amp;Center</source>
        <translation>&amp;Midden</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1308"/>
        <source>&amp;Right</source>
        <translation>&amp;Rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Block</source>
        <translation>&amp;Blok</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Forced</source>
        <translation>Ge&amp;forceerd</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1321"/>
        <source>&amp;Normal</source>
        <translation>&amp;Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1322"/>
        <source>&amp;Underline</source>
        <translation>&amp;Onderstreept</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1323"/>
        <source>Underline &amp;Words</source>
        <translation>Onderstreep &amp;woorden</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1324"/>
        <source>&amp;Strike Through</source>
        <translation>Door&amp;haalen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;All Caps</source>
        <translation>K&amp;apitalen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1326"/>
        <source>Small &amp;Caps</source>
        <translation>Kleinkap&amp;itaal</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1327"/>
        <source>Su&amp;perscript</source>
        <translation>S&amp;uperscript</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1328"/>
        <source>Su&amp;bscript</source>
        <translation>Su&amp;bscript</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1330"/>
        <source>S&amp;hadow</source>
        <translation>Schadu&amp;w</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1332"/>
        <source>&amp;Image Effects</source>
        <translation>&amp;Afbeelding effecten</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Tabulators...</source>
        <translation>&amp;Tabstops...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1336"/>
        <source>D&amp;uplicate</source>
        <translation>D&amp;upliceren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Multiple Duplicate</source>
        <translation>&amp;Meervoudig dupliceren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1338"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1339"/>
        <source>&amp;Group</source>
        <translation>&amp;Groeperen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1340"/>
        <source>&amp;Ungroup</source>
        <translation>&amp;Groep losmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1341"/>
        <source>Is &amp;Locked</source>
        <translation>Is &amp;vergrendeld</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1342"/>
        <source>Si&amp;ze is Locked</source>
        <translation>Groo&amp;tte is vergrendeld</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1346"/>
        <source>Lower to &amp;Bottom</source>
        <translation>Naar achte&amp;rgrond</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1347"/>
        <source>Raise to &amp;Top</source>
        <translation>Naar voorgron&amp;d</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Lower</source>
        <translation>&amp;Lager</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Raise</source>
        <translation>&amp;Hoger</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1350"/>
        <source>Send to S&amp;crapbook</source>
        <translation>In &amp;kladblok zetten</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Attributes...</source>
        <translation>Eigensch&amp;appen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1354"/>
        <source>I&amp;mage Visible</source>
        <translation>Af&amp;beelding zichtbaar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1355"/>
        <source>&amp;Update Image</source>
        <translation>Afbeelding bij&amp;werken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1356"/>
        <source>Adjust Frame to Image</source>
        <translation>Frame aan afbeelding aanpassen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1358"/>
        <source>Extended Image Properties</source>
        <translation>Uitgebreide afbeeldingseigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Low Resolution</source>
        <translation>&amp;Lage resolutie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1360"/>
        <source>&amp;Normal Resolution</source>
        <translation>&amp;Normale resolutie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1361"/>
        <source>&amp;Full Resolution</source>
        <translation>&amp;Volledige resolutie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1362"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation>Dit is een PDF-&amp;bladwijzer</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1363"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation>Dit is een PDF-a&amp;nnotatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1364"/>
        <source>Annotation P&amp;roperties</source>
        <translation>&amp;Eigenschappen van annotatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1365"/>
        <source>Field P&amp;roperties</source>
        <translation>&amp;Veldeigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1366"/>
        <source>&amp;Edit Shape...</source>
        <translation>Vorm b&amp;ewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1367"/>
        <source>&amp;Attach Text to Path</source>
        <translation>Tekst &amp;aan pad toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1368"/>
        <source>&amp;Detach Text from Path</source>
        <translation>Tekst van &amp;pad losmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1369"/>
        <source>&amp;Combine Polygons</source>
        <translation>Polygonen &amp;samenvoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1370"/>
        <source>Split &amp;Polygons</source>
        <translation>&amp;Polygonen opsplitsen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Bezier Curve</source>
        <translation>&amp;Beziercurve</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Image Frame</source>
        <translation>&amp;Afbeeldingsframe</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1374"/>
        <source>&amp;Polygon</source>
        <translation>&amp;Polygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Text Frame</source>
        <translation>&amp;Tekstframe</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Glyph...</source>
        <translation>&amp;Symboolteken...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1380"/>
        <source>Sample Text</source>
        <translation>Voorbeeldtekst</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1384"/>
        <source>&amp;Insert...</source>
        <translation>&amp;Invoegen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1385"/>
        <source>Im&amp;port...</source>
        <translation>Im&amp;porteren ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1386"/>
        <source>&amp;Delete...</source>
        <translation>Verwij&amp;deren...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1387"/>
        <source>&amp;Copy...</source>
        <translation>&amp;Kopiëren ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Move...</source>
        <translation>&amp;Verplaatsen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1389"/>
        <source>&amp;Apply Master Page...</source>
        <translation>Pa&amp;gina sjabloon toepassen ...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1391"/>
        <source>Manage &amp;Guides...</source>
        <translation>&amp;Hulplijnen beheren...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1392"/>
        <source>Manage Page Properties...</source>
        <translation>Paginaeigenschappen bewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1397"/>
        <source>&amp;50%</source>
        <translation>&amp;50%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1398"/>
        <source>&amp;75%</source>
        <translation>&amp;75%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;100%</source>
        <translation>&amp;100%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1400"/>
        <source>&amp;200%</source>
        <translation>&amp;200%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">Minia&amp;turen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1403"/>
        <source>Show &amp;Margins</source>
        <translation>&amp;Marges tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1405"/>
        <source>Show &amp;Frames</source>
        <translation>&amp;Frames tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Images</source>
        <translation>Afbeeld&amp;ingen tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show &amp;Grid</source>
        <translation>R&amp;aster tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show G&amp;uides</source>
        <translation>H&amp;ulplijnen tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Baseline Grid</source>
        <translation>&amp;Basislijn-raster tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Text Chain</source>
        <translation>&amp;Tekstkoppeling tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show Control Characters</source>
        <translation>Opmaaktekens tonen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1399"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Lineaal relatief naar pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1416"/>
        <source>Sn&amp;ap to Grid</source>
        <translation>Ma&amp;gnetisch raster</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1417"/>
        <source>Sna&amp;p to Guides</source>
        <translation>Magnetische hul&amp;plijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1422"/>
        <source>&amp;Properties</source>
        <translation>&amp;Eigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1424"/>
        <source>&amp;Scrapbook</source>
        <translation>&amp;Kladblok</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1425"/>
        <source>&amp;Layers</source>
        <translation>&amp;Lagen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Arrange Pages</source>
        <translation>&amp;Paginatablet</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Bladwijzers</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Measurements</source>
        <translation>&amp;Afstanden</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1429"/>
        <source>Action &amp;History</source>
        <translation>Actie&amp;geschiedenis</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1430"/>
        <source>Preflight &amp;Verifier</source>
        <translation>Preflight &amp;controle</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Align and Distribute</source>
        <translation>&amp;Verdelen en uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Tools</source>
        <translation>&amp;Gereedschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1433"/>
        <source>P&amp;DF Tools</source>
        <translation>P&amp;DF-gereedschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1436"/>
        <source>Select Item</source>
        <translation>Item selecteren</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1351"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1352"/>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Vorm</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1354"/>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Lijn</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1356"/>
        <source>&amp;Freehand Line</source>
        <translation type="obsolete">&amp;Vrijehand-curve</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1437"/>
        <source>Rotate Item</source>
        <translation>Item roteren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1438"/>
        <source>Zoom in or out</source>
        <translation>In- of uitzoomen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1439"/>
        <source>Zoom in</source>
        <translation>Inzoomen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1440"/>
        <source>Zoom out</source>
        <translation>Uitzoomen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1441"/>
        <source>Edit Contents of Frame</source>
        <translation>Frameinhoud bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1442"/>
        <source>Edit Text...</source>
        <translation>Tekst bewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1443"/>
        <source>Link Text Frames</source>
        <translation>Tekstframes koppelen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1444"/>
        <source>Unlink Text Frames</source>
        <translation>Tekstframes loskoppelen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1445"/>
        <source>&amp;Eye Dropper</source>
        <translation>&amp;Pipet</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1446"/>
        <source>Copy Item Properties</source>
        <translation>Itemeigenschappen kopiëren</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1368"/>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Tekst met de story-editor bewerken</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1370"/>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Tekstframe invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1371"/>
        <source>Insert Image Frame</source>
        <translation type="obsolete">Afbeelding invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1372"/>
        <source>Insert Table</source>
        <translation type="obsolete">Tabel invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1373"/>
        <source>Insert Shape</source>
        <translation type="obsolete">Vorm invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1374"/>
        <source>Insert Polygon</source>
        <translation type="obsolete">Polygoon invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1375"/>
        <source>Insert Line</source>
        <translation type="obsolete">Lijn invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1376"/>
        <source>Insert Bezier Curve</source>
        <translation type="obsolete">Beziercurve invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1377"/>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Vrijehand-curve invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1412"/>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">Afbeeldingen &amp;beheren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1469"/>
        <source>&amp;Hyphenate Text</source>
        <translation>Tekst a&amp;fbreken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1470"/>
        <source>Dehyphenate Text</source>
        <translation>Afbreking ongedaan maken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1471"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation>&amp;Inhoudsopgave aanmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;About Scribus</source>
        <translation>&amp;Info over Scribus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1480"/>
        <source>About &amp;Qt</source>
        <translation>Info over &amp;Qt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1481"/>
        <source>Toolti&amp;ps</source>
        <translation>Hul&amp;pballonnen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1483"/>
        <source>Scribus &amp;Manual...</source>
        <translation>Scribus &amp;handboek...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1501"/>
        <source>Smart &amp;Hyphen</source>
        <translation>Slimme &amp;woordafbraak</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1502"/>
        <source>Non Breaking Dash</source>
        <translation>Niet afbrekende streep</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1503"/>
        <source>Non Breaking &amp;Space</source>
        <translation>Niet afbrekende &amp;spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1504"/>
        <source>Page &amp;Number</source>
        <translation>Pagina&amp;nummer</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1506"/>
        <source>New Line</source>
        <translation>Nieuwe regel</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1507"/>
        <source>Frame Break</source>
        <translation>Frame-einde</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1508"/>
        <source>Column Break</source>
        <translation>Kolomeinde</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1511"/>
        <source>Copyright</source>
        <translation>Copyright</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1512"/>
        <source>Registered Trademark</source>
        <translation>Geregistreerd handelsmerk</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1513"/>
        <source>Trademark</source>
        <translation>Handelsmerk</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1515"/>
        <source>Bullet</source>
        <translation>Opsomteken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1517"/>
        <source>Em Dash</source>
        <translation>Kastlijn (Em-streepje)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1518"/>
        <source>En Dash</source>
        <translation>Halve kastlijn (En-streepje)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1519"/>
        <source>Figure Dash</source>
        <translation>Nummer streep</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1520"/>
        <source>Quotation Dash</source>
        <translation>Quote streep</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apostrophe</source>
        <translation type="obsolete">Apostrof</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Straight Double</source>
        <translation type="obsolete">Dubbel recht</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left</source>
        <translation type="obsolete">Enkel links</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right</source>
        <translation type="obsolete">Enkel rechts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left</source>
        <translation type="obsolete">Dubbel links</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right</source>
        <translation type="obsolete">Dubbel rechts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Reversed</source>
        <translation type="obsolete">Enkel omgedraaid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Reversed</source>
        <translation type="obsolete">Dubbel omgedraaid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left Guillemet</source>
        <translation type="obsolete">Enkele linker Guillemet</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right Guillemet</source>
        <translation type="obsolete">Enkele rechter Guillemet</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left Guillemet</source>
        <translation type="obsolete">Dubbele linker Guillemets</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right Guillemet</source>
        <translation type="obsolete">Dubbele rechter Guillemets</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Single Comma</source>
        <translation type="obsolete">Lage enkele komma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Double Comma</source>
        <translation type="obsolete">Lage dubbele komma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Left</source>
        <translation type="obsolete">CJK enkel links</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Right</source>
        <translation type="obsolete">CJK enkel rechts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Left</source>
        <translation type="obsolete">CJK dubbel links</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Right</source>
        <translation type="obsolete">CJK dubbel rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1491"/>
        <source>Toggle Palettes</source>
        <translation>Paletten wisselen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1492"/>
        <source>Toggle Guides</source>
        <translation>Hulplijnen wisselen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1272"/>
        <source>Print Previe&amp;w</source>
        <translation>Afdruk&amp;voorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1296"/>
        <source>&amp;JavaScripts...</source>
        <translation>&amp;JavaScripts...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1390"/>
        <source>Convert to Master Page...</source>
        <translation>Omzetten naar pagina sjabloon...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1474"/>
        <source>&amp;Cascade</source>
        <translation>&amp;Trapsgewijs</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Tile</source>
        <translation>&amp;Tegels</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1423"/>
        <source>&amp;About Plug-ins</source>
        <translation type="obsolete">Over &amp;Plug-ins</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1353"/>
        <source>More Info...</source>
        <translation>Meer informatie...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Printing Enabled</source>
        <translation>&amp;Printen toegestaan</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Flip Horizontally</source>
        <translation>&amp;Draai horizontaal</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1345"/>
        <source>&amp;Flip Vertically</source>
        <translation>&amp;Draai verticaal</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Rulers</source>
        <translation>Toon linealen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1423"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation>&amp;Outline</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1514"/>
        <source>Solidus</source>
        <translation>Slash</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1516"/>
        <source>Middle Dot</source>
        <translation>Interpunt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1541"/>
        <source>En Space</source>
        <translation>En-spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1542"/>
        <source>Em Space</source>
        <translation>Em-spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1543"/>
        <source>Thin Space</source>
        <translation>Halfspatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1544"/>
        <source>Thick Space</source>
        <translation>Brede spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1545"/>
        <source>Mid Space</source>
        <translation>Midden spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1546"/>
        <source>Hair Space</source>
        <translation>Haarspatie</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1461"/>
        <source>Insert Smart Hyphen</source>
        <translation type="obsolete">Pas slimme woordafbreking toe</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1462"/>
        <source>Insert Non Breaking Dash</source>
        <translation type="obsolete">Niet afbrekende streep invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1463"/>
        <source>Insert Non Breaking Space</source>
        <translation type="obsolete">Niet afbrekende spatie invoegen</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1464"/>
        <source>Insert Page Number</source>
        <translation type="obsolete">Paginanummer invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1558"/>
        <source>ff</source>
        <translation>ff</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1559"/>
        <source>fi</source>
        <translation>fi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1560"/>
        <source>fl</source>
        <translation>fl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1561"/>
        <source>ffi</source>
        <translation>ffi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1562"/>
        <source>ffl</source>
        <translation>ffl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1563"/>
        <source>ft</source>
        <translation>ft</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1564"/>
        <source>st</source>
        <translation>st</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>S&amp;tyles...</source>
        <translation>S&amp;tijlen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation>&amp;Outline</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation>C&amp;urven</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1283"/>
        <source>Paste (&amp;Absolute)</source>
        <translation>Plakken (&amp;Absoluut)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1284"/>
        <source>C&amp;lear</source>
        <translation>W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Text Frame Columns</source>
        <translation>Toon tekstframe kolomlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1267"/>
        <source>Save as &amp;EPS...</source>
        <translation>Opslaan als &amp;EPS...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1293"/>
        <source>Patterns...</source>
        <translation>Patronen...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1351"/>
        <source>Send to Patterns</source>
        <translation>In patroon zetten</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Frame...</source>
        <translation>&amp;Frame...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1381"/>
        <source>Sticky Tools</source>
        <translation>Magnetisch gereedschap</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1395"/>
        <source>&amp;Fit to Height</source>
        <translation>Aanpassen aan &amp;hoogte</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1396"/>
        <source>Fit to Width</source>
        <translation>Aanpassen aan breedte</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1402"/>
        <source>Preview Mode</source>
        <translation>Voorbeeldmodus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1404"/>
        <source>Show Bleeds</source>
        <translation>Toon afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1406"/>
        <source>Show Layer Indicators</source>
        <translation>Toon laag indicatoren</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert PDF Push Button</source>
        <translation>Voeg PDF knop in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert PDF Text Field</source>
        <translation>Voet PDF tekst veld in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert PDF Check Box</source>
        <translation>Voeg PDF check box in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1461"/>
        <source>Insert PDF Combo Box</source>
        <translation>Voeg PDF Combo Box in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF List Box</source>
        <translation>Voeg PDF List Box in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert Text Annotation</source>
        <translation>Voeg Tekst annotatie in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert Link Annotation</source>
        <translation>Voeg Link annotatie in</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1509"/>
        <source>&amp;Zero Width Space</source>
        <translation>&amp;Nul breedte spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1510"/>
        <source>Zero Width NB Space</source>
        <translation>Nul breedte NB spatie</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1522"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished">Apostrof</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1523"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished">Dubbel recht</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1524"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished">Enkel links</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1525"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished">Enkel rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1526"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished">Dubbel links</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1527"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished">Dubbel rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished">Enkel omgedraaid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1529"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished">Dubbel omgedraaid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1530"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished">Enkele linker Guillemet</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1531"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished">Enkele rechter Guillemet</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1532"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished">Dubbele linker Guillemets</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished">Dubbele rechter Guillemets</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1534"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished">Lage enkele komma</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1535"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished">Lage dubbele komma</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1536"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished">CJK enkel links</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1537"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished">CJK enkel rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1538"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished">CJK dubbel links</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1539"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished">CJK dubbel rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;400%</source>
        <translation type="unfinished">&amp;200% {400%?}</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1448"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1449"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1451"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1484"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1485"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1486"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1487"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1468"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1493"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1264"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1286"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1290"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1292"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1415"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished">Lineaal relatief naar pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1450"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1488"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1505"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1357"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>File</source>
        <translation type="unfinished">Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>Edit</source>
        <translation type="unfinished">Bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>Style</source>
        <translation type="unfinished">Stijl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Item</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished">I&amp;nvoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>Page</source>
        <translation type="unfinished">Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>&amp;View</source>
        <translation type="unfinished">Beel&amp;d</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">E&amp;xtras</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Venster</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>&amp;Help</source>
        <translation type="unfinished">&amp;Help</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1871"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1873"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1875"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1482"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished">&amp;Geselecteerde hulplijn:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished">&amp;Relatief ten opzichte van:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished">Verdelen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished">&amp;Afstand:</translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Align and Distribute</source>
        <translation type="obsolete">Verdelen/uitlijnen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align</source>
        <translation type="obsolete">Uitlijnen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Selected Guide:</source>
        <translation type="obsolete">&amp;Geselecteerde hulplijn:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relative To:</source>
        <translation type="obsolete">&amp;Relatief ten opzichte van:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute</source>
        <translation type="obsolete">Verdelen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Distance:</source>
        <translation type="obsolete">&amp;Afstand:</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation>Verdelen/uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation>Uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation>&amp;Relatief ten opzichte van:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation>Eerste geselecteerde</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation>Laatste geselecteerde</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation>Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation>Marges</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation>Hulplijn</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation>Selectie</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation>Onderkanten uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation>Rechterkanten uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation>Centreer op verticale as</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation>Linkerkanten uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation>Centreer op horizontale as</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation>Bovenkanten uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation>&amp;Geselecteerde hulplijn:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation>Verdelen</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation>Verdeel rechterkanten met gelijke afstand</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation>Verdeel onderkanten met gelijke afstand</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation>Verdeel middens met gelijke afstanden horizontaal</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation>Verdeel linkerkanten met gelijke afstand</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation>Verdeel middens met gelijke afstanden verticaal</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation>Verdeel bovenkanten met gelijke afstand</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation>&amp;Afstand:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation>Verdeel de items met de opgegeven afstand</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation>Niets geselecteerd</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="443"/>
        <source>Y: %1%2</source>
        <translation>Y: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="451"/>
        <source>X: %1%2</source>
        <translation>X: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation>Rechterzijde van items uitlijnen op linkerzijde van referentie</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation>Linkerzijde van items uitlijnen op rechterzijde referentie</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation>Bovenzijde items uitlijnen op onderzijde referentie</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation>Onderzijde items uitlijnen op bovenzijde referentie</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation>Maak horizontale ruimte tussen items gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation>Maak horizontale ruimte tussen items volgens aangegeven waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation>Maak verticale ruimte tussen items gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation>Maak verticale ruimte tussen items volgens aangegeven waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation>Maak horizontale ruimte tussen items en zijden van de pagina gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation>Maak verticale ruimte tussen items en boven- en onderzijde van de pagina gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation>Maak horizontale ruimte tussen items en zijden van de pagina-marges gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation>Maak verticale ruimte tussen items en boven- en onderzijde van de pagina-marges gelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Tekst links uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Tekst rechts uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Tekst centreren</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Tekst uitvullen</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Tekst geforceerd uitvullen</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Veldeigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Type:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Knop</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Tekstveld</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Keuzevakje</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Combobox</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Lijst</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Eigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Fonts voor gebruik met PDF 1.3:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Rand</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Kleur:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2087"/>
        <source>None</source>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Smal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Breed</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Stijl:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Effen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>Gestreept</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Onderstreept</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Afgeschuind</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Inliggend</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Overig</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Alleen-lezen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Vereist</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Zichtbaarheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Zichtbaar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Onzichtbaar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>Niet afdrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>Niet weergeven</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Uiterlijk</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Tekst voor ingedrukte knop</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Tekst voor muis-over</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Pictogrammen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Pictogrammen gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Ingedrukt</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Muis-over</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Plaatsing van pictogram...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Accentueren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Inverteren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Outline</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Druk</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Meerregelig</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Wachtwoord</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Limiet van</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>Niet schuiven</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>Geen spellingcontrole</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Stijl controleren:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>Controleren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Kruis</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Diamant</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Cirkel</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Ster</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Vierkant</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>Standaard is geselecteerd</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Bewerkbaar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>Go To</source>
        <translation>Ga naar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Submit Form</source>
        <translation>Formulier verzenden</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Reset Form</source>
        <translation>Formulier wissen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Import Data</source>
        <translation>Gegevens importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Gebeurtenis:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Up</source>
        <translation>Muisknop omhoog</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Down</source>
        <translation>Muisknop omlaag</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Enter</source>
        <translation>Muis komt over</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>Mouse Exit</source>
        <translation>Muis gaat weg</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Focus</source>
        <translation>Bij focus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Blur</source>
        <translation>Bij verlaten van focus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Script:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1095"/>
        <source>Edit...</source>
        <translation>Bewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Verzenden naar URL:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="678"/>
        <source>Submit Data as HTML</source>
        <translation>Gegevens als HTML versturen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="691"/>
        <source>Import Data from:</source>
        <translation>Gegevens importeren van:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Doel</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>Naar bestand:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>X-positie:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Y-positie:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="700"/>
        <source>Action</source>
        <translation>Actie</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="731"/>
        <source>Field is formatted as:</source>
        <translation>Veld is geformatteerd als:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Plain</source>
        <translation>Eenvoudig</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Number</source>
        <translation>Nummer</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Percentage</source>
        <translation>Percentage</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Date</source>
        <translation>Datum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Time</source>
        <translation>Tijd</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Custom</source>
        <translation>Aangepast</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="752"/>
        <source>Number Format</source>
        <translation>Nummerformaat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="820"/>
        <source>Decimals:</source>
        <translation>Decimalen:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="775"/>
        <source>Use Currency Symbol</source>
        <translation>Geldwaarde-symbool gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="784"/>
        <source>Prepend Currency Symbol</source>
        <translation>Waarde-symbool vooraan plaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="831"/>
        <source>Formatting</source>
        <translation>Formattering</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="811"/>
        <source>Percent Format</source>
        <translation>Percentageformaat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="854"/>
        <source>Date Format</source>
        <translation>Datumformaat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="880"/>
        <source>Time Format</source>
        <translation>Tijdformaat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="902"/>
        <source>Custom Scripts</source>
        <translation>Eigen scripts</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="914"/>
        <source>Format:</source>
        <translation>Formaat:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="940"/>
        <source>Keystroke:</source>
        <translation>Toetsaanslag:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="964"/>
        <source>Format</source>
        <translation>Formaat</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="980"/>
        <source>Value is not validated</source>
        <translation>Waarde is niet gevalideerd</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="989"/>
        <source>Value must be greater than or equal to:</source>
        <translation>Waarde moet groter of gelijk zijn aan:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="993"/>
        <source>and less or equal to:</source>
        <translation>en kleiner of gelijk aan:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1004"/>
        <source>Custom validate script:</source>
        <translation>Eigen validatiescript:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1025"/>
        <source>Validate</source>
        <translation>Valideren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1042"/>
        <source>Value is not calculated</source>
        <translation>Waarde is niet berekend</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1051"/>
        <source>Value is the</source>
        <translation>Waarde is</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>sum</source>
        <translation>de som</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>product</source>
        <translation>het produkt</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>average</source>
        <translation>het gemiddelde</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>minimum</source>
        <translation>het minimum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1057"/>
        <source>maximum</source>
        <translation>het maximum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1064"/>
        <source>of the following fields:</source>
        <translation>van de volgende velden:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1074"/>
        <source>Pick...</source>
        <translation>Selecteren...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1079"/>
        <source>Custom calculation script:</source>
        <translation>Eigen calculatiescript:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1099"/>
        <source>Calculate</source>
        <translation>Berekenen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1118"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1122"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1174"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>Deze vlag wordt genegeerd in PDF 1.3</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1175"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Voer hier een door komma&apos;s gescheiden lijst van velden in</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1176"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>U hebt tenminste een pictogram &apos;Normaal&apos; nodig om pictogrammen voor knoppen te kunnen gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1453"/>
        <source>Example:</source>
        <translation>Voorbeeld:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2079"/>
        <source>Selection Change</source>
        <translation>Selectie wijzigen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF-bestanden (*.pdf);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2088"/>
        <source>JavaScript</source>
        <translation>JavaScript</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>None</source>
        <comment>action</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation>Hulpballon:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation>Waarde niet exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1342"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation>Afbeeldingen  (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1287"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Annotatie-eigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Koppeling</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Externe koppeling</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Externe webkoppeling</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Doel</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../annota.cpp" line="351"/>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">PDF-bestanden (*.pdf);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Type:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>&amp;X-pos</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation>Pagina sjabloon toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Pagina sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply To</source>
        <translation>Toepassen op</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;page</source>
        <translation>Huidige &amp;pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even pages</source>
        <translation>&amp;Even pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd pages</source>
        <translation>O&amp;neven pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All pages</source>
        <translation>A&amp;lle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within range</source>
        <translation>&amp;Toepassen vanaf</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation>Alt+W</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation>tot</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation>Atl+O</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation>Geselecteerde paginasjabloon op even, oneven of alle pagina&apos;s binnen het bereik toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished">Mogelijke afbreking</translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <location filename="../arrowchooser.cpp" line="33"/>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="69"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="351"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished">&amp;Afbreken</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Sluiten</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="79"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="86"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="337"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="338"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="218"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="405"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="57"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="407"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished">Pijlen</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished">Specials</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode Generator...</source>
        <translation type="obsolete">&amp;Streepjescodegenerator...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure Postscript Barcode Writer</source>
        <translation type="obsolete">Scribus frontend om zuivere Postscript streepjescode te schrijven</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation>Fout bij het openen van bestand: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation>12 of 13 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation>8 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation>11 of 12 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation>7 of 8 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation>5 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation>2 cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation>Variabele aantal tekens, cijfers en de symbolen -. *$/+%.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation>textLabel16Variabele aantal van ADCII tekens en symbolen voor speciale functies, beginnend met het correcte teken voor het tekenstel. UCC/EAN-128-codes hebben in ieder geval een FNC1-symbool na het startteken nodig.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation>Varaibele aantal cijfers en de symbolen -$:/.+ABCD.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation>Variabele aantal cijfers. Een ITF-14-code bestaat uit 14 tekens en heeft geen controlecijfer</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation>Variabele aantal cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation>Variabele aantal cijfers en hoofdletters</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation>Variabele aantal hexadecimale tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation>Streepjescode onvolledig</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation>12 of 13 cijfers met streepjes. Het oorspronkelijke ISBN-10 formaat accepteert 9 of 10 cijfers met streepjes, maar deze standaard is beïndigd voor publiek gebruik na 1 januari 2007. (Noot: om een oud ISBN-10 naar een nieuw ISBN-13 nummer om zetten. Zet 978 voor de eerste 9 cijfers, dus 1-56592-47907 -&gt; 978-1-56592-47907. Het uiteindelijke controle-cijfer wordt automatisch berekend.)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Barcode Creator</source>
        <translation type="obsolete">Streepjescodegenerator</translation>
    </message>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="193"/>
        <source>Barcode</source>
        <translation type="obsolete">Streepjescode</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="152"/>
        <source>&amp;Type:</source>
        <translation>&amp;Type:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="145"/>
        <source>Select one of the available barcode type here</source>
        <translation>Kies een van de beschikbare streepjescodes</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="125"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation>De numerieke uitdrukking van de code. Bekijk de uitleg hieronder</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="115"/>
        <source>Reset the barcode samples</source>
        <translation>Reset de streepjescodevoorbeelden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="90"/>
        <source>&amp;Include text in barcode</source>
        <translation>Tekst in streepjescode &amp;invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="93"/>
        <source>Alt+I</source>
        <translation>Alt+I</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="87"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation>Als geselecteerd, zullen er ook cijfers in de streepjescode staan</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="77"/>
        <source>&amp;Guard whitespace</source>
        <translation>&amp;Bewaak witruimte</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="80"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="74"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation>Tekent een pijl om een afstand tussen tekst en streepjescode te waarborgen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="168"/>
        <source>Colors</source>
        <translation>Kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="208"/>
        <source>&amp;Background</source>
        <translation>&amp;Achtergrond</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="211"/>
        <source>Alt+B</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="205"/>
        <source>Background color - under the code lines</source>
        <translation>Kleur van de achtergrond - onder de codestreepjes</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="240"/>
        <source>&amp;Lines</source>
        <translation>&amp;Lijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="243"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="237"/>
        <source>Color of the lines in barcode</source>
        <translation>Kleur van de streepjes in code</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="272"/>
        <source>&amp;Text</source>
        <translation>&amp;Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="275"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="269"/>
        <source>Color of the text and numbers</source>
        <translation>Kleur van tekst en cijfers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="304"/>
        <source>Hints and help is shown here</source>
        <translation>Tips en hulp worden hier getoond</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="314"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation>Voorbeeld van het resultaat in 72 dpi.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="132"/>
        <source>Co&amp;de:</source>
        <translation>Co&amp;de:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="64"/>
        <source>I&amp;nclude checksum</source>
        <translation>Controlenummer &amp;bijvoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="67"/>
        <source>Alt+N</source>
        <translation>Alt+B</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="61"/>
        <source>Generate and include a checksum in barcode</source>
        <translation>Controlenummer in streepjescode aanmaken en bijvoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="51"/>
        <source>Incl&amp;ude checksum digit</source>
        <translation>Controlenummer&amp;cijfer invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="54"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="48"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation>Controlenummer in streepjescodetekst invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Formaat</translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation>Kladblok</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation>Hernoemen</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation>Verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation>Object</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation>Nieuwe ingang</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation>De naam &quot;%1&quot; is niet uniek.
Kies een andere naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation>Kies een kladblokmap</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation>Kies een map</translation>
    </message>
    <message>
        <location filename="../scrapbookpalette.cpp" line="747"/>
        <source>Scrapbook (*.scs)</source>
        <translation type="obsolete">Kladblok (*.scs)</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation>Kies een kladblokbestand om te importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation>Hoofd</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation>Gekopieerde items</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation>Kopieer naar:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation>Verplaats naar:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation>Nieuwe kladblok pagina aanmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation>Bestaand kladblok laden</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation>Geselecteerd kladblok opslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation>Kladblok bestand van Scribus &lt;=1.3.2 importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation>Geslecteerd kladblok sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <location filename="../bookmwin.cpp" line="554"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Bladwijzers</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="219"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Bladwijzer verplaatsen</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="220"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Bladwijzer invoegen</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="221"/>
        <source>Cancel</source>
        <translation type="obsolete">Annuleren</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Bladwijzers</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Plaatsing van pictogrammen</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Layout:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Alleen tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Alleen pictogrammen</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Tekst onder pictogram</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Tekst boven pictogram</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Tekst rechts van pictogram</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Tekst links van pictogram</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Tekst over pictogram heen</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Altijd</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>Als pictogram te klein is</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>Als pictogram te groot is</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Nooit</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Schaalmethode:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Proportioneel</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>Niet proportioneel</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Pictogram</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Opnieuw instellen</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="31"/>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">Kleurbeheer &amp;activeren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="34"/>
        <source>System Profiles</source>
        <translation type="obsolete">Systeemprofielen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="75"/>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Beeldscherm:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="83"/>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">&amp;Printer:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="89"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Rendering intents</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Perceptueel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Relatief colorimetrisch</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Verzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluut colorimetrisch</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="113"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Printerweergave op scherm sim&amp;uleren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="130"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Kleuren buiten de &amp;gamut markeren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="134"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">&amp;Zwartpuntcompensatie gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="143"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Door uzelf aangemaakt of via fabrikant verkregen kleurprofiel.
Dit profiel is specifiek voor uw beeldscherm en niet algemeen (zoals bijv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="144"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Kleurprofiel voor uw printer van de printerfabrikant.
Dit profiel is specifiek voor uw printer en niet algemeen (zoals bijv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="147"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Laat een weergave op uw scherm zien, gebaseerd
op het gekozen printerprofiel.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="149"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Hiermee kunnen kleurgebieden gemarkeerd worden die niet correct zouden worden
afgedrukt. Dit vereist zeer accurate profielen en dient enkel als waarschuwing.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="150"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">Zwartpuntcompensatie is een methode om het contrast in foto&apos;s te verbeteren.
Als uw document foto&apos;s bevat wordt deze instelling aangeraden.</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="43"/>
        <source>&amp;RGB Pictures:</source>
        <translation type="obsolete">&amp;RGB-afbeeldingen:</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="51"/>
        <source>&amp;CMYK Pictures:</source>
        <translation type="obsolete">&amp;CMYK-afbeeldingen:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="139"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Standaard-kleurprofiel voor geïmporteerde CMYK-afbeeldingen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="140"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Standaard-kleurprofiel voor geïmporteerde RGB-afbeeldingen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="59"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="obsolete">&amp;RGB effen kleuren:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="67"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="obsolete">&amp;CMYK effen kleuren:</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="98"/>
        <source>Pictures:</source>
        <translation type="obsolete">Afbeeldingen:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="106"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="obsolete">Effen kl&amp;euren:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="121"/>
        <source>Convert all colors to printer space</source>
        <translation type="obsolete">Zet alle kleuren om naar printer kleurruimte</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="141"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="obsolete">Standaard kleurprofiel voor effen RGB kleuren op de pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="142"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="obsolete">Standaard kleurprofiel voor effen CMYK kleuren op de pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="145"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Standaard render keuze voor effen kleuren. Kies relatief colorimetrisch of perceptueel.
Tenzij er een reden is voor een andere keuze.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="146"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Standaard render keuze voor afbeeldingen. Kies relatief colorimetrisch of perceptueel.
Tenzij er een reden is voor een andere keuze.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="148"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="obsolete">Simuleer een full colour management omgeving:
Alle kleuren, rgb of cmyk, worden omgezet naar printer kleurruimte.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="98"/>
        <source>Images:</source>
        <translation type="obsolete">Afbeeldingen:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">Kleurbeheer &amp;activeren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Systeemprofielen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished">Standaard-kleurprofiel voor geïmporteerde RGB-afbeeldingen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished">Standaard-kleurprofiel voor geïmporteerde CMYK-afbeeldingen</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished">&amp;RGB effen kleuren:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished">Standaard kleurprofiel voor effen RGB kleuren op de pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished">&amp;CMYK effen kleuren:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished">Standaard kleurprofiel voor effen CMYK kleuren op de pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Beeldscherm:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Door uzelf aangemaakt of via fabrikant verkregen kleurprofiel.
Dit profiel is specifiek voor uw beeldscherm en niet algemeen (zoals bijv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">&amp;Printer:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Kleurprofiel voor uw printer van de printerfabrikant.
Dit profiel is specifiek voor uw printer en niet algemeen (zoals bijv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Rendering intents</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Afbeeldingen:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Standaard render keuze voor afbeeldingen. Kies relatief colorimetrisch of perceptueel.
Tenzij er een reden is voor een andere keuze.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished">Effen kl&amp;euren:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Standaard render keuze voor effen kleuren. Kies relatief colorimetrisch of perceptueel.
Tenzij er een reden is voor een andere keuze.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Laat een weergave op uw scherm zien, gebaseerd
op het gekozen printerprofiel.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Printerweergave op scherm sim&amp;uleren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished">Simuleer een full colour management omgeving:
Alle kleuren, rgb of cmyk, worden omgezet naar printer kleurruimte.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished">Zet alle kleuren om naar printer kleurruimte</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Hiermee kunnen kleurgebieden gemarkeerd worden die niet correct zouden worden
afgedrukt. Dit vereist zeer accurate profielen en dient enkel als waarschuwing.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished">Kleuren buiten de &amp;gamut markeren</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished">Zwartpuntcompensatie is een methode om het contrast in foto&apos;s te verbeteren.
Als uw document foto&apos;s bevat wordt deze instelling aangeraden.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished">&amp;Zwartpuntcompensatie gebruiken</translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation>Kleur bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation>Kleur&amp;model</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation>RGB voor web</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation>Nieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation>Oud</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="195"/>
        <source>HSV-Colormap</source>
        <translation type="obsolete">HSV-kleurenkaart</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation>Dynamische kleurbalken</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation>Statische kleurbalken</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation>Is een steunkleur</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="128"/>
        <source>Is Registration Color</source>
        <translation type="obsolete">Is een registratie kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation>U kan niet een kleur maken genaamd &quot;%1&quot;.
De naam is gereserveerd voor transparantkleur</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="385"/>
        <source>Choosing this will enable printing this on all plates. Registration colors are used for printer marks such as crop marks, registration marks and the like. These are not typically used in the layout itself.</source>
        <translation type="obsolete">Hiermee worden alle platen afgedrukt. Registratiekleuren worden gebruikt voor afdrukmarkeringen zoals, snijtekens, registratietekens en dergelijke. Deze worden gebruikelijk buiten de de layout zelf geplaatst.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation>Hiermee wordt van deze kleur een steunkleur gemaakt. Voor elke steunkleur wordt een separatie gemaakt bij het maken van platen of films. Steunkleuren worden meestal gebruikt als een kleur exact moet worden weergegeven en niet kan worden samengesteld met cmyk kleuren. Metallic en fluoriserende inkten zijn specifieke voorbeelden welke niet met cmyk inkten kunnen worden aangemaakt.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Als kleuren management is ingeschakeld, geeft een driehoekig teken aan dat de kleur buiten het kleurenspectrum van het huidige geselecteerde printerprofiel is. De afdruk op papier kan afwijken van de kleur op het beeldscherm. Meer informatie hierover zijn te vinden in de on-line help onder Color Management.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation>De naam van de kleur bestaat reeds,
kies een andere.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CStyleP</name>
    <message>
        <location filename="../smcstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Form1</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="109"/>
        <source>Colors</source>
        <translation type="obsolete">Kleuren</translation>
    </message>
</context>
<context>
    <name>CStylePBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Form1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Parent</translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation>Vermeng kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation>Fout: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation>Kleur %1 bestaat al!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation>Kleur %1 toegevoegd.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation>Opent nu het kleurbeheer.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation>Kleursamenvoeging</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="488"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation>Kan de gevraagde kleur niet vinden. Waarschijnlijk is zwart, grijs of wit geselecteerd. Deze kleur kan niet worden verwerkt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished">Kleurwiel</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="47"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished">Klik op het wiel om de basiskleur te verkrijgen. Het kleur model hangt af van de gekozen tab.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="54"/>
        <source>Result Colors</source>
        <translation type="unfinished">Resulterende kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="311"/>
        <source>CMYK</source>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="532"/>
        <source>RGB</source>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="718"/>
        <source>HSV</source>
        <translation type="unfinished">HSV</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="108"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished">Kleuren van het gekozen schema.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="118"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished">Kleuren schema methode</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="144"/>
        <source>Angle:</source>
        <translation type="unfinished">Hoek:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="154"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished">Verschil tussen de geselecteerde en de berekende waarden. Lees de documentatie voor meer informatie.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="169"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished">Selecteer een van de methoden om een kleurenschema aan te maken. Lees de documentatie voor meer informatie.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="203"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished">Voeg aangemaakte kleuren in de documentkleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="206"/>
        <source>&amp;Merge</source>
        <translation type="unfinished">Sa&amp;menvoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="209"/>
        <source>Alt+M</source>
        <translation type="unfinished">Alt+M</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="216"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished">Vervang aangemaakte kleuren in documentkleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="219"/>
        <source>&amp;Replace</source>
        <translation type="unfinished">&amp;Vervangen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="222"/>
        <source>Alt+R</source>
        <translation type="unfinished">Alt+R</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="229"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished">Laat kleur onaangeraakt</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="232"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="235"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="244"/>
        <source>Preview:</source>
        <translation type="unfinished">Voorbeeld:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="268"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished">Voorbeeld kleurenschema.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="287"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished">Simuleer voorkomende gezichtsbeperkingen. Selecteer het type beperking.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="294"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished">Type visuele beperking:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="331"/>
        <source>C:</source>
        <translation type="unfinished">C:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="431"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="361"/>
        <source>M:</source>
        <translation type="unfinished">M:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="391"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="421"/>
        <source>K:</source>
        <translation type="unfinished">K:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="827"/>
        <source>RGB:</source>
        <translation type="unfinished">RGB:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="674"/>
        <source>HSV:</source>
        <translation type="unfinished">HSV:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="560"/>
        <source>R:</source>
        <translation type="unfinished">R:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="587"/>
        <source>G:</source>
        <translation type="unfinished">G:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="614"/>
        <source>B:</source>
        <translation type="unfinished">B:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="863"/>
        <source>CMYK:</source>
        <translation type="unfinished">CMYK:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="746"/>
        <source>H:</source>
        <translation type="unfinished">H:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="773"/>
        <source>S:</source>
        <translation type="unfinished">S:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="800"/>
        <source>V:</source>
        <translation type="unfinished">V:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="907"/>
        <source>Document</source>
        <translation type="unfinished">Document</translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Kleurwiel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="obsolete">Klik op het wiel om de basiskleur te verkrijgen. Het kleur model hangt af van de gekozen tab.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Scheme Method</source>
        <translation type="obsolete">Kleuren schema methode</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="obsolete">Selecteer een van de methoden om een kleurenschema aan te maken. Lees de documentatie voor meer informatie.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle:</source>
        <translation type="obsolete">Hoek:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="obsolete">Verschil tussen de geselecteerde en de berekende waarden. Lees de documentatie voor meer informatie.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview:</source>
        <translation type="obsolete">Voorbeeld:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vision Defect Type:</source>
        <translation type="obsolete">Type visuele beperking:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="obsolete">Simuleer voorkomende gezichtsbeperkingen. Selecteer het type beperking.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample color scheme.</source>
        <translation type="obsolete">Voorbeeld kleurenschema.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB:</source>
        <translation type="obsolete">RGB:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV:</source>
        <translation type="obsolete">HSV:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK:</source>
        <translation type="obsolete">CMYK:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document</source>
        <translation type="obsolete">Document</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Result Colors</source>
        <translation type="obsolete">Resulterende kleuren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="obsolete">Kleuren van het gekozen schema.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Merge</source>
        <translation type="obsolete">Sa&amp;menvoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+M</source>
        <translation type="obsolete">Alt+M</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge created colors into the document colors</source>
        <translation type="obsolete">Voeg aangemaakte kleuren in de documentkleuren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Vervangen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace created colors in the document colors</source>
        <translation type="obsolete">Vervang aangemaakte kleuren in documentkleuren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Leave colors untouched</source>
        <translation type="obsolete">Laat kleur onaangeraakt</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2252"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2243"/>
        <source>X: %1</source>
        <translation type="unfinished">X: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2245"/>
        <source>Y: %1</source>
        <translation type="unfinished">Y: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2260"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2262"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1822"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Alle ondersteunde formaten</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1852"/>
        <source>Open</source>
        <translation type="unfinished">Openen</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <location filename="../../scribus/charselect.ui" line="100"/>
        <source>Font:</source>
        <translation type="obsolete">Font:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="123"/>
        <source>Character Class:</source>
        <translation type="obsolete">Lettertekenklasse:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="203"/>
        <source>&amp;Insert</source>
        <translation type="obsolete">&amp;Invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="213"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="200"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Voegt de tekens in op de huidige cursorpositie</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="210"/>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Verwijdert de huidige selectie(s).</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="250"/>
        <source>Full Character Set</source>
        <translation type="obsolete">Volledige lettertekenset</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="255"/>
        <source>Basic Latin</source>
        <translation type="obsolete">Basis latijn</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="261"/>
        <source>Latin-1 Supplement</source>
        <translation type="obsolete">Latijn-1 toevoeging</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="267"/>
        <source>Latin Extended-A</source>
        <translation type="obsolete">Latijn uitgebreid-A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="273"/>
        <source>Latin Extended-B</source>
        <translation type="obsolete">Latijn uitgebreid-B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="279"/>
        <source>General Punctuation</source>
        <translation type="obsolete">Algemene puntuatie</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="285"/>
        <source>Super- and Subscripts</source>
        <translation type="obsolete">Super- en subscripts</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="291"/>
        <source>Currency Symbols</source>
        <translation type="obsolete">Valutasymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Letterlike Symbols</source>
        <translation type="obsolete">Lettersymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="303"/>
        <source>Number Forms</source>
        <translation type="obsolete">Getalvormen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="309"/>
        <source>Arrows</source>
        <translation type="obsolete">Pijlen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="315"/>
        <source>Mathematical Operators</source>
        <translation type="obsolete">Mathematische lettertekens</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="321"/>
        <source>Box Drawing</source>
        <translation type="obsolete">Blok tekensymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="327"/>
        <source>Block Elements</source>
        <translation type="obsolete">Blokelementen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="333"/>
        <source>Geometric Shapes</source>
        <translation type="obsolete">Geometrische vormen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="339"/>
        <source>Miscellaneous Symbols</source>
        <translation type="obsolete">Diverse symbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="345"/>
        <source>Dingbats</source>
        <translation type="obsolete">Dingbats</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="351"/>
        <source>Small Form Variants</source>
        <translation type="obsolete">Small Form Variants</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="357"/>
        <source>Ligatures</source>
        <translation type="obsolete">Ligaturen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="363"/>
        <source>Specials</source>
        <translation type="obsolete">Specials</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="369"/>
        <source>Greek</source>
        <translation type="obsolete">Grieks</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="375"/>
        <source>Greek Extended</source>
        <translation type="obsolete">Grieks uitgebreid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="381"/>
        <source>Cyrillic</source>
        <translation type="obsolete">Cyrillisch</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="387"/>
        <source>Cyrillic Supplement</source>
        <translation type="obsolete">Cyrillisch supplement</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="393"/>
        <source>Arabic</source>
        <translation type="obsolete">Arabisch</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="399"/>
        <source>Arabic Extended A</source>
        <translation type="obsolete">Arabisch uitgebreid A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="405"/>
        <source>Arabic Extended B</source>
        <translation type="obsolete">Arabisch uitgebreid B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="411"/>
        <source>Hebrew</source>
        <translation type="obsolete">Hebreeuws</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation>Letterteken palet</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation>Scribus letterteken palet (*.ucp);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="88"/>
        <source>Enhanced Palette</source>
        <translation type="obsolete">Uitgebreid palet</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="19"/>
        <source>Quick Palette</source>
        <translation type="obsolete">Snel palet</translation>
    </message>
    <message>
        <location filename="../charselect.ui" line="49"/>
        <source>Hide Enhanced</source>
        <translation type="obsolete">Verberg uitbreiding</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="164"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">U kunt een miniatuurweergave zien als u de rechter muisknop ingedrukt houdt. De insert-toets voegt een teken in de selectie hieronder en de delete-toets verwijderd de laatst ingevoegde</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="226"/>
        <source>Choose a filename to open</source>
        <translation>Kies een bestandsnaam om te openen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Error</source>
        <translation>Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="256"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation>Fout tijdens lezen bestand %1 - bestand is mogelijk beschadigd.</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="625"/>
        <source>Choose a filename to save under</source>
        <translation type="obsolete">Kies een bestandsnaam om op te slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="298"/>
        <source>Cannot write file %1</source>
        <translation>Kan bestand %1 niet schrijven</translation>
    </message>
    <message>
        <location filename="../charselect.cpp" line="634"/>
        <source>Clean the Palette?</source>
        <translation type="obsolete">Palet wissen?</translation>
    </message>
    <message>
        <location filename="../charselect.cpp" line="635"/>
        <source>You will clean all characters from this palette. Are you sure?</source>
        <translation type="obsolete">Alle lettertekens van dit palet worden gewist. Zeker weten?</translation>
    </message>
    <message>
        <location filename="../charselect.ui" line="56"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="306"/>
        <source>Empty the Palette?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="307"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="24"/>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="272"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="205"/>
        <source>Full Character Set</source>
        <translation type="unfinished">Volledige lettertekenset</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="210"/>
        <source>Basic Latin</source>
        <translation type="unfinished">Basis latijn</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="216"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished">Latijn-1 toevoeging</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="222"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished">Latijn uitgebreid-A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="228"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished">Latijn uitgebreid-B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="234"/>
        <source>General Punctuation</source>
        <translation type="unfinished">Algemene puntuatie</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="240"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished">Super- en subscripts</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="246"/>
        <source>Currency Symbols</source>
        <translation type="unfinished">Valutasymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="252"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished">Lettersymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="258"/>
        <source>Number Forms</source>
        <translation type="unfinished">Getalvormen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="264"/>
        <source>Arrows</source>
        <translation type="unfinished">Pijlen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="270"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished">Mathematische lettertekens</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="276"/>
        <source>Box Drawing</source>
        <translation type="unfinished">Blok tekensymbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="282"/>
        <source>Block Elements</source>
        <translation type="unfinished">Blokelementen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="288"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished">Geometrische vormen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="294"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished">Diverse symbolen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="300"/>
        <source>Dingbats</source>
        <translation type="unfinished">Dingbats</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="306"/>
        <source>Small Form Variants</source>
        <translation type="unfinished">Small Form Variants</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="312"/>
        <source>Ligatures</source>
        <translation type="unfinished">Ligaturen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="318"/>
        <source>Specials</source>
        <translation type="unfinished">Specials</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="324"/>
        <source>Greek</source>
        <translation type="unfinished">Grieks</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="330"/>
        <source>Greek Extended</source>
        <translation type="unfinished">Grieks uitgebreid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="336"/>
        <source>Cyrillic</source>
        <translation type="unfinished">Cyrillisch</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="342"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished">Cyrillisch supplement</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="348"/>
        <source>Arabic</source>
        <translation type="unfinished">Arabisch</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="354"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished">Arabisch uitgebreid A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="360"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished">Arabisch uitgebreid B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="366"/>
        <source>Hebrew</source>
        <translation type="unfinished">Hebreeuws</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished">Voegt de tekens in op de huidige cursorpositie</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">&amp;Invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="181"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished">Verwijdert de huidige selectie(s).</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="184"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation>Geen stijl</translation>
    </message>
</context>
<context>
    <name>CharTable</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete</source>
        <translation type="obsolete">Verwijderen</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation type="unfinished">Verwijderen</translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="869"/>
        <source>Current Profile:</source>
        <translation>Huidige profiel:</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="865"/>
        <source>Items</source>
        <translation>Items</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="866"/>
        <source>Problems</source>
        <translation>Problemen</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="877"/>
        <source>Glyphs missing</source>
        <translation>Missende symbooltekens</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="878"/>
        <source>Text overflow</source>
        <translation>Tekstoverloop</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="879"/>
        <source>Object is not on a Page</source>
        <translation>Object staat niet op een pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="880"/>
        <source>Missing Image</source>
        <translation>Missende afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="884"/>
        <source>Object has transparency</source>
        <translation>Object is doorzichtig</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="886"/>
        <source>Object is a placed PDF</source>
        <translation>Object is een geplaatste PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="250"/>
        <source>Document</source>
        <translation>Document</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="254"/>
        <source>No Problems found</source>
        <translation>Geen problemen gevonden</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="656"/>
        <source>Page </source>
        <translation>Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="837"/>
        <source>Free Objects</source>
        <translation>Vrije objecten</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="843"/>
        <source>Problems found</source>
        <translation>Gevonden problemen</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="863"/>
        <source>Preflight Verifier</source>
        <translation>Preflight controle</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="885"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation>Object is een PDF annotatie of veld</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="870"/>
        <source>&amp;Ignore Errors</source>
        <translation>&amp;Negeer fouten</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="255"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="276"/>
        <source>Transparency used</source>
        <translation>Transparatie gebruikt</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="279"/>
        <source>Blendmode used</source>
        <translation>Vermeng modus gebruikt</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="286"/>
        <source>Layer &quot;%1&quot;</source>
        <translation>Laag &quot;%1&quot;</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="871"/>
        <source>Check again</source>
        <translation>Check opnieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="882"/>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation>Afbeeldingsresolutie minder dan %1 DPI, huidige %2 x %3 DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="883"/>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation>Afbeeldingsresolutie meer dan %1 DPI, huidige %2 x %3 DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="887"/>
        <source>Image is GIF</source>
        <translation>Afbeelding is GIF</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="888"/>
        <source>Annotation uses a non TrueType font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="873"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="874"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="875"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="881"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ChooseStyles</name>
    <message>
        <location filename="../editformats.cpp" line="95"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Kies stijlen</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="100"/>
        <source>Available Styles</source>
        <translation type="obsolete">Beschikbare stijlen</translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation>Kies een map</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="68"/>
        <source>Collecting...</source>
        <translation>Verzamelen...</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="73"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation>Kan niet alle bestanden vinden voor de output van bestand:
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="87"/>
        <source>Cannot collect the file: 
%1</source>
        <translation>Verzamelen niet gelukt van bestand:
%1</translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation>Kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="80"/>
        <source>&amp;Import</source>
        <translation>&amp;Importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="82"/>
        <source>&amp;New</source>
        <translation>&amp;Nieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="84"/>
        <source>&amp;Edit</source>
        <translation>Be&amp;werken</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="88"/>
        <source>D&amp;uplicate</source>
        <translation>D&amp;upliceren</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="91"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="96"/>
        <source>&amp;Remove Unused</source>
        <translation>Ongebruikte ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="103"/>
        <source>Color Sets</source>
        <translation>Kleurensets</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="109"/>
        <source>Current Color Set:</source>
        <translation>Huidige kleurenset:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="140"/>
        <source>&amp;Save Color Set</source>
        <translation>Kleurenset op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="159"/>
        <source>Choose a color set to load</source>
        <translation>Kies de te laden kleurenset</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="160"/>
        <source>Save the current color set</source>
        <translation>De huidige kleurenset opslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="165"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation>Verwijdert de ongebruikte kleuren uit de kleurenset van dit document</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="167"/>
        <source>Import colors to the current set from an existing document</source>
        <translation>Importeer kleuren naar de huidige set uit een bestaand document</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="168"/>
        <source>Create a new color within the current set</source>
        <translation>Een nieuwe kleur aanmaken in de huidige set</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="169"/>
        <source>Edit the currently selected color</source>
        <translation>De geselecteerde kleur bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="170"/>
        <source>Make a copy of the currently selected color</source>
        <translation>Een kopie van de geselecteerde kleur maken</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="171"/>
        <source>Delete the currently selected color</source>
        <translation>De geselecteerde kleur verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="172"/>
        <source>Make the current colorset the default color set</source>
        <translation>Stelt de huidige kleurenset in als standaard</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>Choose a Name</source>
        <translation>Kies een naam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open</source>
        <translation type="obsolete">Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="353"/>
        <source>Copy of %1</source>
        <translation>Kopie van %1</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="364"/>
        <source>New Color</source>
        <translation>Nieuwe kleur</translation>
    </message>
    <message>
        <location filename="../colorm.cpp" line="172"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected.What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. Registration colors will have a registration mark next to the color. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Als het kleurbeheer is ingeschakeld, een driehoekig teken is een waarschuwing dat de kleur buiten het kleurspectrum van het huidige printerprofiel is. Dit betekend dat de kleur misschien niet geprint wordt zoals op het scherm getoond. Steunkleuren zijn gemerkt door een rode cirkel. Registratietekens hebben een registratiemerk naast de kleur. Meer hints over spectrumwaarschuwingen staan in de on-lin help onder kleurbeheer (Color Management).</translation>
    </message>
    <message>
        <location filename="../colorm.cpp" line="428"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;Other Files (*.eps *.epsi *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Documenten (*.sla *.sla.gz *.scd *.scd.gz);;Other Files (*.eps *.epsi *.ps *.ai);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Information</source>
        <translation>Informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation>Het bestand %1 bevat geen kleuren die kunnen worden geïmporteerd.
Als het een bestand is op PostScript basis, probeer dan Bestand -&amp;; Import.
Niet alle bestand hebben DSC conform commentaar over de locatie van de kleurbeschrijving.
Dit voorkomt import van kleuren bij bepaalde bestanden.
Zie het Bewerk Kleuren deel van het document voor details.</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Import</source>
        <translation type="obsolete">Importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="173"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="311"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="312"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation>Monochroom</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation>Analoog</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="224"/>
        <source>Complementary</source>
        <translation>Complementair</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation>Gesplitst complementair</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation>Triadisch</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation>Tetradisch (Dubbel complementair)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation>Basiskleur</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="206"/>
        <source>Monochromatic Light</source>
        <translation>Monochromatisch licht</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="209"/>
        <source>Monochromatic Dark</source>
        <translation>Monochromatisch donker</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="216"/>
        <source>1st. Analogous</source>
        <translation>1e Analoog</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="217"/>
        <source>2nd. Analogous</source>
        <translation>2e Analoog</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="231"/>
        <source>1st. Split</source>
        <translation>1e Splitsing</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="232"/>
        <source>2nd. Split</source>
        <translation>2e Splitsing</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="233"/>
        <source>3rd. Split</source>
        <translation>3e Splitsing</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="234"/>
        <source>4th. Split</source>
        <translation>4e Splitsing</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="241"/>
        <source>1st. Triadic</source>
        <translation>1e Triade</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="242"/>
        <source>2nd. Triadic</source>
        <translation>2e Triade</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="249"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation>1e Tetrade (basis tegengesteld)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="250"/>
        <source>2nd. Tetradic (angle)</source>
        <translation>2e Tetrade (hoek)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="251"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation>3e Tetrade (hoek tegengesteld)</translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation>&amp;Kleurwiel...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation>Kleurinstellingen helper</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation>Kleur selecteren inclusief kleurtheorie.</translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="244"/>
        <source>&amp;Apply</source>
        <translation>Toe&amp;passen</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="247"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="254"/>
        <source>&amp;OK</source>
        <translation>&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="257"/>
        <source>&amp;Save</source>
        <translation>Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="260"/>
        <source>Warning</source>
        <translation>Waarschuwing</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <comment>color name</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="285"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation>Aangepast</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="291"/>
        <source>Single Page</source>
        <translation>Enkele pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="292"/>
        <source>Double Sided</source>
        <translation>Dubbelzijdig</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="293"/>
        <source>3-Fold</source>
        <translation>Drieluik</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="294"/>
        <source>4-Fold</source>
        <translation>Vierluik</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="330"/>
        <source>Monday</source>
        <translation>Maandag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="331"/>
        <source>Tuesday</source>
        <translation>Dinsdag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="332"/>
        <source>Wednesday</source>
        <translation>Woensdag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="333"/>
        <source>Thursday</source>
        <translation>Donderdag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="334"/>
        <source>Friday</source>
        <translation>Vrijdag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="335"/>
        <source>Saturday</source>
        <translation>Zaterdag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="336"/>
        <source>Sunday</source>
        <translation>Zondag</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="337"/>
        <source>January</source>
        <translation>Januari</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="338"/>
        <source>February</source>
        <translation>Februari</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="339"/>
        <source>March</source>
        <translation>Maart</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="340"/>
        <source>April</source>
        <translation>April</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="341"/>
        <source>May</source>
        <translation>Mei</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="342"/>
        <source>June</source>
        <translation>Juni</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="343"/>
        <source>July</source>
        <translation>Juli</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="344"/>
        <source>August</source>
        <translation>Augustus</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="345"/>
        <source>September</source>
        <translation>September</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="346"/>
        <source>October</source>
        <translation>Oktober</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="347"/>
        <source>November</source>
        <translation>November</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="348"/>
        <source>December</source>
        <translation>December</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="262"/>
        <source>Yes</source>
        <translation>Ja</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="263"/>
        <source>No</source>
        <translation>Nee</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="264"/>
        <source>&amp;Yes</source>
        <translation>&amp;Ja</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;No</source>
        <translation>&amp;Nee</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="301"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation>Linker pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="302"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation>Midden</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation>Midden links</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation>Midden rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="305"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation>Rechter pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="308"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="310"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation>Normaal links</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="312"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation>Normaal midden</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="314"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation>Normaal rechts</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="356"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation>Normaal zicht</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="357"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation>Protanopia (Rood)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="358"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation>Deuteranopia (Groen)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="359"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation>Tritanopia (Blauw)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="360"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation>Volledig kleurenblind</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="362"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation>Aangepast: </translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="316"/>
        <source>Solid Line</source>
        <translation>Ononderbroken lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="317"/>
        <source>Dashed Line</source>
        <translation>Gestreepte lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="318"/>
        <source>Dotted Line</source>
        <translation>Stippellijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="319"/>
        <source>Dash Dot Line</source>
        <translation>Streep-stip lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Dot Line</source>
        <translation>Streep-stip-stip lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="364"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="365"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="366"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="367"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="368"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="369"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished">Standaard</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="372"/>
        <source>Min. Word Tracking</source>
        <translation>Min. woord tracking</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="373"/>
        <source>Max. Word Tracking</source>
        <translation>Max. woord tracking</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="376"/>
        <source>Min. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="377"/>
        <source>Max. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="250"/>
        <source>None</source>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="350"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="351"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="352"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="353"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">Duotoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="354"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="381"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="267"/>
        <source>Text Frame</source>
        <translation type="unfinished">Tekstframe</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="268"/>
        <source>Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="269"/>
        <source>Line</source>
        <translation type="unfinished">Lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="270"/>
        <source>Polygon</source>
        <translation type="unfinished">Polygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="271"/>
        <source>Polyline</source>
        <translation type="unfinished">Polylijn</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="272"/>
        <source>Text on a Path</source>
        <translation type="unfinished">Tekst op een pad</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="274"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="275"/>
        <source>PDF Push Button</source>
        <translation type="unfinished">PDF knop</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Text Field</source>
        <translation type="unfinished">PDF tekstveld</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Check Box</source>
        <translation type="unfinished">PDF check box</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished">PDF Combo Box</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF List Box</source>
        <translation type="unfinished">PDF List Box</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished">PDF tekst annotatie</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished">PDF link annotatie</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="388"/>
        <source>PostScript Level 1</source>
        <translation type="unfinished">PostScript Level 1</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 2</source>
        <translation type="unfinished">PostScript Level 2</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 3</source>
        <translation type="unfinished">PostScript Level 3</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="394"/>
        <source>Windows GDI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="273"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="325"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished">Standaard alineastijl</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Character Style</source>
        <translation type="unfinished">Standaard teken stijl</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="210"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="421"/>
        <source>Paste File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="454"/>
        <source>Delete Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="182"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation type="unfinished">Zet Pagina om naar pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation type="unfinished">Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpagedialog.cpp" line="18"/>
        <source>New Master Page %1</source>
        <translation type="unfinished">Nieuw pagina sjabloon %1</translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1001"/>
        <source>Shade:</source>
        <translation>Tint:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="985"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1002"/>
        <source>Opacity:</source>
        <translation>Ondoorzichtigheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1020"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1008"/>
        <source>Horizontal Gradient</source>
        <translation>Horizontaal verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1009"/>
        <source>Vertical Gradient</source>
        <translation>Verticaal verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1010"/>
        <source>Diagonal Gradient</source>
        <translation>Diagonaal verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1011"/>
        <source>Cross Diagonal Gradient</source>
        <translation>Kruislings diagonaal verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1012"/>
        <source>Radial Gradient</source>
        <translation>Straalsgewijs verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1013"/>
        <source>Free linear Gradient</source>
        <translation>Vrij lineair verloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1014"/>
        <source>Free radial Gradient</source>
        <translation>Vrij straalsgewijs verloop</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="922"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="923"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="984"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="924"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="925"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1038"/>
        <source>Edit Line Color Properties</source>
        <translation>Lijnkleur bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1039"/>
        <source>Edit Fill Color Properties</source>
        <translation>Vulkleur bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1040"/>
        <source>Saturation of color</source>
        <translation>Kleurverzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1041"/>
        <source>Normal or gradient fill method</source>
        <translation>Vulmethode: normaal of kleurverloop</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1042"/>
        <source>Set the transparency for the color selected</source>
        <translation>Geeft de mate van ondoorschijnendheid aan</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1003"/>
        <source>Move Vector</source>
        <translation>Verplaats vector</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1043"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation>Verplaats het begin van de gradiëntvector met de linker muisknop ingedrukt en verplaats het einde van de gradiëntvector met de rechter muisknop ingedrukt</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1017"/>
        <source>Transparency Settings</source>
        <translation>Instellingen transparantie</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="988"/>
        <source>Offsets</source>
        <translation>Verschuiving</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="989"/>
        <source>X:</source>
        <translation>X:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="991"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="993"/>
        <source>Scaling</source>
        <translation>Schalen</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="994"/>
        <source>X-Scale:</source>
        <translation>X-schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="996"/>
        <source>Y-Scale:</source>
        <translation>Y-schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="998"/>
        <source>Rotation</source>
        <translation>Rotatie</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="999"/>
        <source>Angle</source>
        <translation>Hoek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1015"/>
        <source>Pattern</source>
        <translation>Patroon</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1018"/>
        <source>Blend Mode:</source>
        <translation>Vermeng Mode:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1021"/>
        <source>Darken</source>
        <translation>Donkerder</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1022"/>
        <source>Lighten</source>
        <translation>Lichter</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1023"/>
        <source>Multiply</source>
        <translation>Vermenigvuldig</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1024"/>
        <source>Screen</source>
        <translation>Scherm</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1025"/>
        <source>Overlay</source>
        <translation>Maskerlaag</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1026"/>
        <source>Hard Light</source>
        <translation>Hard licht</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1027"/>
        <source>Soft Light</source>
        <translation>Zacht licht</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1028"/>
        <source>Difference</source>
        <translation>Verschil</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1029"/>
        <source>Exclusion</source>
        <translation>Uitsluiting</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1030"/>
        <source>Color Dodge</source>
        <translation>Kleur tegenhouden</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1031"/>
        <source>Color Burn</source>
        <translation>Kleur doordrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1032"/>
        <source>Hue</source>
        <translation>Tint</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1033"/>
        <source>Saturation</source>
        <translation>Verzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1034"/>
        <source>Color</source>
        <translation>Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1035"/>
        <source>Luminosity</source>
        <translation>Helderheid</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1036"/>
        <source>Display only used Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1044"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation type="unfinished">Maak bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation type="unfinished">Aantal pagina&apos;s in document:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation type="unfinished">Doc pagina bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation type="unfinished">Standaardselectie bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Bereik van pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">Ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation type="unfinished">Naar on&amp;der</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation type="unfinished">Naar bove&amp;n</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation type="unfinished">Voeg bereik van pagina&apos;s toe</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation type="unfinished">Opeenvolgende pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation type="unfinished">Even pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation type="unfinished">Van:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation type="unfinished">&amp;Aan bereik toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation type="unfinished">Oneven pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation type="unfinished">Lijst met kommagescheiden-waarden</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation type="unfinished">Geavanceerd herschikken</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation type="unfinished">Pagina volgorde</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation type="unfinished">Voorbeeld pagina volgorde:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation type="unfinished">Pagina groep formaat:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRangeBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Create Range</source>
        <translation type="obsolete">Maak bereik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Pages in Document:</source>
        <translation type="obsolete">Aantal pagina&apos;s in document:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc Page Range</source>
        <translation type="obsolete">Doc pagina bereik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basic Range Selection</source>
        <translation type="obsolete">Standaardselectie bereik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a Range of Pages</source>
        <translation type="obsolete">Voeg bereik van pagina&apos;s toe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Consecutive Pages</source>
        <translation type="obsolete">Opeenvolgende pagina&apos;s</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From:</source>
        <translation type="obsolete">Van:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To:</source>
        <translation type="obsolete">Tot:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comma Separated List</source>
        <translation type="obsolete">Lijst met kommagescheiden-waarden</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Even Pages</source>
        <translation type="obsolete">Even pagina&apos;s</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Odd Pages</source>
        <translation type="obsolete">Oneven pagina&apos;s</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add To Range</source>
        <translation type="obsolete">&amp;Aan bereik toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages</source>
        <translation type="obsolete">Bereik van pagina&apos;s</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Up</source>
        <translation type="obsolete">Naar bove&amp;n</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+U</source>
        <translation type="obsolete">Alt+U</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Down</source>
        <translation type="obsolete">Naar on&amp;der</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">Ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Advanced Reordering</source>
        <translation type="obsolete">Geavanceerd herschikken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Group Size:</source>
        <translation type="obsolete">Pagina groep formaat:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample Page Order:</source>
        <translation type="obsolete">Voorbeeld pagina volgorde:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Order</source>
        <translation type="obsolete">Pagina volgorde</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+O</source>
        <translation type="obsolete">Alt+O</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation>Opties voor importeren CSV</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation>Veldscheidingsteken:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation>(TAB)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation>Waardescheidingsteken:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation>Eerste regel is een kopregel</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation>Geen</translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="52"/>
        <source>Printer Options</source>
        <translation>Afdrukinstellingen</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="143"/>
        <source>Page Set</source>
        <translation>Bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="147"/>
        <source>All Pages</source>
        <translation>Alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="141"/>
        <source>Even Pages only</source>
        <translation>Even pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="142"/>
        <source>Odd Pages only</source>
        <translation>Oneven pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="160"/>
        <source>Mirror</source>
        <translation>Spiegelen</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="177"/>
        <source>Orientation</source>
        <translation>Oriëntatie</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="181"/>
        <source>Portrait</source>
        <translation>Staand</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="175"/>
        <source>Landscape</source>
        <translation>Liggend</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="197"/>
        <source>N-Up Printing</source>
        <translation>Pagina&apos;s per vel</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="201"/>
        <source>Page per Sheet</source>
        <translation>pagina per vel</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="196"/>
        <source>Pages per Sheet</source>
        <translation>pagina&apos;s per vel</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="63"/>
        <source>Option</source>
        <translation>Optie</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="64"/>
        <source>Value</source>
        <translation>Waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="224"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation>Dit scherm toont diverse CUPS- printopties. Exacte parameters zijn afhankelijk van de beschikbare printerdriver. CUPS support kan worden bevestigd door Help &gt; Over te selecteren. Kijk naar de lijst: C-C-T Dit is gelijk aan C=CUPS C=littlecms T=Tiff support. Ontbrekende bibliotheken worden aangegeven met een *</translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="414"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation>Curve bestanden (*.scu);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Save as</source>
        <translation>Opslaan als</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="483"/>
        <source>Cannot write the file: 
%1</source>
        <translation>Kan bestand niet schrijven:
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="509"/>
        <source>Inverts the curve</source>
        <translation>Curve inverteren</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="510"/>
        <source>Resets the curve</source>
        <translation>Curve herstellen</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="511"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation>Schakel tussen lineaire en kubieke interpolatie van de curve</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="512"/>
        <source>Loads a curve</source>
        <translation>Laad een curve</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="513"/>
        <source>Saves this curve</source>
        <translation>Bewaar deze curve</translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="327"/>
        <source>&amp;Compress File</source>
        <translation>Bestand &amp;comprimeren</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Fonts</source>
        <translation>Fonts &amp;insluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="355"/>
        <source>Encoding:</source>
        <translation>Codering:</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="366"/>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Gaat naar uw documentenmap.
Deze kan worden ingesteld in de voorkeuren.</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="314"/>
        <source>&amp;Include ICC Profiles</source>
        <translation type="obsolete">&amp;ICC profielen insluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="274"/>
        <source>Show Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="308"/>
        <source>&amp;Include Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="275"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="342"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="344"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="346"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="363"/>
        <source>Value:</source>
        <translation type="unfinished">Waarde:</translation>
    </message>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="364"/>
        <source>Offset:</source>
        <translation type="unfinished">Verschuiving:</translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation>Geannuleerd door gebruiker</translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="28"/>
        <source>Delete Color</source>
        <translation>Kleur verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="36"/>
        <source>Delete Color:</source>
        <translation>Kleur verwijderen:</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="45"/>
        <source>Replace With:</source>
        <translation>Vervangen door:</translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation>Pagina&apos;s verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation>tot:</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation>Verwijder van:</translation>
    </message>
</context>
<context>
    <name>DelStyle</name>
    <message>
        <location filename="../editformats.cpp" line="36"/>
        <source>Delete Style</source>
        <translation type="obsolete">Verwijder stijl</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="42"/>
        <source>Delete Style:</source>
        <translation type="obsolete">Verwijder stijl:</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="46"/>
        <source>Replace With:</source>
        <translation type="obsolete">Vervangen door:</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="49"/>
        <source>No Style</source>
        <translation type="obsolete">Geen stijl</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="160"/>
        <source>Importing failed</source>
        <translation>Importeren mislukt</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="161"/>
        <source>Importing Word document failed 
%1</source>
        <translation>Het importeren mislukt bij het bestand:
%1 </translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation>Documentinformatie</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation>&amp;Titel:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation>&amp;Auteur:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Keywords:</source>
        <translation>T&amp;refwoorden:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="61"/>
        <source>Descri&amp;ption:</source>
        <translation>Om&amp;schrijving:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="74"/>
        <source>P&amp;ublisher:</source>
        <translation>&amp;Uitgever:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="81"/>
        <source>&amp;Contributors:</source>
        <translation>&amp;Medewerkers:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="89"/>
        <source>Dat&amp;e:</source>
        <translation>&amp;Datum:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="96"/>
        <source>T&amp;ype:</source>
        <translation>T&amp;ype:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="103"/>
        <source>F&amp;ormat:</source>
        <translation>&amp;Formaat:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="110"/>
        <source>Identi&amp;fier:</source>
        <translation>&amp;Identifier:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="117"/>
        <source>&amp;Source:</source>
        <translation>Br&amp;on:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Language:</source>
        <translation>T&amp;aal:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Relation:</source>
        <translation>R&amp;elatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="138"/>
        <source>Co&amp;verage:</source>
        <translation>Gaat o&amp;ver:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="145"/>
        <source>Ri&amp;ghts:</source>
        <translation>Rec&amp;hten:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="153"/>
        <source>Further &amp;Information</source>
        <translation>Meer &amp;informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="163"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation>De persoon of organisatie die dit document beschikbaar maakt</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="164"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation>Personen of organisaties die hebben bijgedragen aan dit document</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="165"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation>Datum die bij het document hoort, bijv. de aanmaakdatum, in JJJJ-MM-DD formaat, zoals in ISO 8601</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="166"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation>Genre, categorie of type van dit document</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="168"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation>Een exacte referentie naar dit document, zoals een ISBN-nummer of een URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="169"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation>Een verwijzing naar een document waar dit document van is afgelijk, bijv. ISBN of een URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="171"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation>Een verwijzing naar een gerelateerd document, mogelijk via een ISBN-nummer of URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="172"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation>Het bereik dat door het document wordt omvat, bijvoorbeeld in plaats, tijd of jurisdictie</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="173"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation>Informatie over rechten die voor dit document gelden, zoals copyright, patenten of handelsmerken</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="152"/>
        <source>Documen&amp;t</source>
        <translation>Documen&amp;t</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="159"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Persoon of organisatie verantwoordelijk voor de inhoud van het document. Dit veld kan worden ingesloten in het Scribus document ter referentie, alsmede in de PDF metadata</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="160"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Naam van een document. Dit veld kan worden ingebed in het Scribus document ter referentie, evenals in de PDF metadata</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="161"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation>Omschrijving van de inhoud van het document. Dit veld is een korte omschrijving van het document. Wordt bij export naar PDF ingebed</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="162"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation>Trefwoorden over de inhoud van het document. Dit veld is voor trefwoorden die in een PDF moeten worden ingebd, om zoeken en indexeren van PDF bestanden eenvoudiger te maken</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="167"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation>Fysieke of digitale staat van het document. Media type en afmetingen zijn goed om te vermelden evenals RFC2045,RFC2046 for MIME types</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="170"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation>De taal waarin de inhoud van het document is geschreven, vaak wordt een ISO-639 taalcode geschreven met een afbreekstreepje en een ISO-3166 landcode, als en-GB, fr-CH</translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation>Voeg een sectie voor paginanummering toe aan het document. De nieuwe sectie wordt toegevoegd na de huidige geselecteerde sectie.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation>Wis de geselecteerde sectie.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation>1, 2, 3, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation>i, ii, iii, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation>I, II, III, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation>a, b, c, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation>A, B, C, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="79"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation>&lt;b&gt;Naam:&lt;/b&gt;Optionele naam voor sectie bijv. Index&lt;br/&gt;&lt;b&gt;Getoond:&lt;/b&gt;Selecteer om paginanummers in deze sectie tonen als dit voor meerdere tekstframes geldt.&lt;br/&gt;Van:&lt;/b&gt;De start van de pagina index voor deze sectie.&lt;br/&gt;&lt;b&gt;Tot:&lt;/b&gt;Het eind van de pagina index voor deze sectie.&lt;br/&gt;&lt;b&gt;Stijl:&lt;/b&gt; Selecteer de te gebruiken stijl voor de paginanummering.&lt;br/&gt;&lt;b&gt;Start:,/b&gt; De index waarbinnen binnen de nummeringsstijl moet worden gestart. Bijv. Als Start=2 en Stijl=a,b,c,..., zal de nummering beginnen bij b. Voor de eerste sectie in het document zal dit het oudere Eerste Pagina Nummer in het nieuwe bestandsvenster vervangen.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation>Paginanummer buiten bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation>De ingevoerde waarde ligt buiten de waarde van de paginanummering in dit document (%1-%2).</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation type="unfinished">Document Secties</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation type="unfinished">Getoond</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation type="unfinished">Van</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation type="unfinished">Naar</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation type="unfinished">Stijl</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation type="unfinished">Start</translation>
    </message>
</context>
<context>
    <name>DocSectionsBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Sections</source>
        <translation type="obsolete">Document Secties</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From</source>
        <translation type="obsolete">Van</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To</source>
        <translation type="obsolete">Naar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style</source>
        <translation type="obsolete">Stijl</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start</source>
        <translation type="obsolete">Start</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shown</source>
        <translation type="obsolete">Getoond</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation>Relatie tot</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation>Is Parent van</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation>Is kind van</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation>Tekstframes</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation>Afbeeldingsframe</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation>Boolean</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation>Integer</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation>String</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation>Getal</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished">Document Item attributen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation type="unfinished">Type</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation type="unfinished">Waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation type="unfinished">Parameter</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation type="unfinished">Relatie</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation type="unfinished">Relatie tot</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation type="unfinished">Voeg automatisch toe aan</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributesBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Item Attributes</source>
        <translation type="obsolete">Document Item attributen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Type</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value</source>
        <translation type="obsolete">Waarde</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parameter</source>
        <translation type="obsolete">Parameter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship</source>
        <translation type="obsolete">Relatie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship To</source>
        <translation type="obsolete">Relatie tot</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Auto Add To</source>
        <translation type="obsolete">Voeg automatisch toe aan</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+K</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">W&amp;issen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="473"/>
        <source>Importing File:
%1
failed!</source>
        <translation>Het importeren van het bestand:
%1
is mislukt!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="474"/>
        <source>Fatal Error</source>
        <translation>Fatale fout</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="872"/>
        <source>Error</source>
        <translation>Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="83"/>
        <source>Analyzing PostScript:</source>
        <translation>Analyseer Postscript:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="479"/>
        <source>Generating Items</source>
        <translation>Verwerk items</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="871"/>
        <source>Converting of %1 images failed!</source>
        <translation>Verwerken van %1 afbeelding mislukt!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="80"/>
        <source>Importing: %1</source>
        <translation>Importeren: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="738"/>
        <source>Group%1</source>
        <translation>Groep %1</translation>
    </message>
</context>
<context>
    <name>EditStyle</name>
    <message>
        <location filename="../edit1format.cpp" line="47"/>
        <source>Edit Style</source>
        <translation type="obsolete">Stijl bewerken</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="67"/>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="80"/>
        <source>Character</source>
        <translation type="obsolete">Teken</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="272"/>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="268"/>
        <source>&amp;Lines:</source>
        <translation type="obsolete">Rege&amp;ls:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="300"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en inspringing</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="360"/>
        <source>Name of your paragraph style</source>
        <translation type="obsolete">Naam van uw alineastijl</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="361"/>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Font van object of geselecteerde tekst</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="362"/>
        <source>Font Size</source>
        <translation type="obsolete">Tekengrootte</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="363"/>
        <source>Color of text fill</source>
        <translation type="obsolete">Kleur van de tekstvulling</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="364"/>
        <source>Color of text stroke</source>
        <translation type="obsolete">Kleur van de tekstomlijning</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="366"/>
        <source>Determines the overall height, in line numbers, of the Drop Caps</source>
        <translation type="obsolete">Geeft de hoogte van de kapitaal aan in het aantal regels dat deze beslaat</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="369"/>
        <source>Spacing above the paragraph</source>
        <translation type="obsolete">Witruimte boven de alinea</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="370"/>
        <source>Spacing below the paragraph</source>
        <translation type="obsolete">Witruimte onder de alinea</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="373"/>
        <source>Line Spacing</source>
        <translation type="obsolete">Tussenruimte tussen de regels</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="239"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="200"/>
        <source>Distances</source>
        <translation type="obsolete">Afstanden</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="209"/>
        <source>Fixed Linespacing</source>
        <translation type="obsolete">Vaste regelspatiëring</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="210"/>
        <source>Automatic Linespacing</source>
        <translation type="obsolete">Automatische regelspatiëring</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="211"/>
        <source>Align to Baseline Grid</source>
        <translation type="obsolete">Aan de basislijn van het raster uitlijnen</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="257"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Beginkapitaal</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="274"/>
        <source>Distance from Text:</source>
        <translation type="obsolete">Afstand van tekst:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="324"/>
        <source>Preview of the Paragraph Style</source>
        <translation type="obsolete">Preview Alineastijl</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="367"/>
        <source>Determines the gap between the DropCaps and the Text</source>
        <translation type="obsolete">Bepaalt ruimte tussen beginkapitaal en tekst</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="375"/>
        <source>Toggles sample text of this paragraph style</source>
        <translation type="obsolete">Verwissel voorbeeldtekst van deze alineastijl</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="508"/>
        <source>Name of the style is not unique</source>
        <translation type="obsolete">Naam van de stijl is niet uniek</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="328"/>
        <source>Background</source>
        <translation type="obsolete">Achtergrond</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="371"/>
        <source>Manual Tracking</source>
        <translation type="obsolete">Handmatige tracking</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="372"/>
        <source>Offset to baseline of characters</source>
        <translation type="obsolete">Offset ten opzichte van basislijn tekens</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="448"/>
        <source>Auto</source>
        <translation type="obsolete">Automatisch</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="359"/>
        <source>Select for easier reading of light colored text styles</source>
        <translation type="obsolete">Selecteer voor makkelijker lezen van licht gekleurde tekststijlen</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="374"/>
        <source>Click to select the line spacing mode</source>
        <translation type="obsolete">Klik om regelafstand modus te selecteren</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation type="unfinished">Bewerken</translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../scribus/editor.cpp" line="30"/>
        <source>Editor</source>
        <translation>Editor</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="36"/>
        <source>&amp;New</source>
        <translation>&amp;Nieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="39"/>
        <source>&amp;Open...</source>
        <translation>&amp;Openen...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="41"/>
        <source>Save &amp;As...</source>
        <translation>Opslaan &amp;als...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="43"/>
        <source>&amp;Save and Exit</source>
        <translation>Op&amp;slaan en sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="45"/>
        <source>&amp;Exit without Saving</source>
        <translation>Sluit&amp;en zonder opslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="47"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaan maken</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="50"/>
        <source>&amp;Redo</source>
        <translation>O&amp;pnieuw doen</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="52"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;ppen</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="55"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="58"/>
        <source>&amp;Paste</source>
        <translation>P&amp;lakken</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="61"/>
        <source>C&amp;lear</source>
        <translation>W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="63"/>
        <source>&amp;Get Field Names</source>
        <translation>Veldnamen opvra&amp;gen</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="65"/>
        <source>&amp;File</source>
        <translation>&amp;Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="72"/>
        <source>&amp;Edit</source>
        <translation>Be&amp;werken</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="127"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation>JavaScripts (*.js);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="37"/>
        <source>Ctrl+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="48"/>
        <source>Ctrl+Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="53"/>
        <source>Ctrl+X</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="56"/>
        <source>Ctrl+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="59"/>
        <source>Ctrl-V</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="44"/>
        <source>Image Effects</source>
        <translation>Afbeeldingseffecten</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="81"/>
        <source>Options:</source>
        <translation>Opties:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="98"/>
        <source>Color:</source>
        <translation>Kleur:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="109"/>
        <source>Shade:</source>
        <translation>Tint:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="125"/>
        <source>Brightness:</source>
        <translation>Helderheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="147"/>
        <source>Contrast:</source>
        <translation>Contrast:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="198"/>
        <source>Radius:</source>
        <translation>Radius:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="180"/>
        <source>Value:</source>
        <translation>Waarde:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="216"/>
        <source>Posterize:</source>
        <translation>Poster effect:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="500"/>
        <source>Available Effects</source>
        <translation>Beschikbare effecten</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1393"/>
        <source>Blur</source>
        <translation>Vervagen</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1371"/>
        <source>Brightness</source>
        <translation>Helderheid</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1362"/>
        <source>Colorize</source>
        <translation>Colorizeren</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1377"/>
        <source>Contrast</source>
        <translation>Contrast</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="981"/>
        <source>Grayscale</source>
        <translation>Grijsttinten</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="983"/>
        <source>Invert</source>
        <translation>Inverteren</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1406"/>
        <source>Posterize</source>
        <translation>Poster effect</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1383"/>
        <source>Sharpen</source>
        <translation>Verscherpen</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="482"/>
        <source>&gt;&gt;</source>
        <translation>&gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="486"/>
        <source>&lt;&lt;</source>
        <translation>&lt;&lt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="497"/>
        <source>Effects in use</source>
        <translation>Effect in gebruik</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="616"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="620"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="351"/>
        <source>Color 1:</source>
        <translation>Kleur 1:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="371"/>
        <source>Color 2:</source>
        <translation>Kleur 2:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="391"/>
        <source>Color 3:</source>
        <translation>Kleur 3:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="411"/>
        <source>Color 4:</source>
        <translation>Kleur 4:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1412"/>
        <source>Duotone</source>
        <translation>Duotoon</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1448"/>
        <source>Tritone</source>
        <translation>Tritoon</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1499"/>
        <source>Quadtone</source>
        <translation>Quadtoon</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1565"/>
        <source>Curves</source>
        <translation>Curven</translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>File exists. Overwrite?</source>
        <translation>Bestand bestaat. Wilt u het overschrijven?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="205"/>
        <source>exists already. Overwrite?</source>
        <translation>bestaat al. Wilt u het overschrijven?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All</source>
        <translation type="obsolete">Alles</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Save as Image</source>
        <translation type="unfinished">Opslaan als afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="192"/>
        <source>Insufficient memory for this image size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="219"/>
        <source>Error writing the output file(s).</source>
        <translation type="unfinished">Fout tijdens het schrijven naar uitvoerbestand(en).</translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation>Kies een map om naar te exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation>Exporteren als afbeelding(en)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation>&amp;Exporteren naar map:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation>Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation>Afbeeldings&amp;type:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation>&amp;Kwaliteit:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation>&amp;Resolutie:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation>dpi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation>Bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation>Huidige pa&amp;gina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation>Alle &amp;pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation>&amp;Bereik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation>Een bepaald bereik exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation>Voer hier de paginanummer(s) in die u wilt exporteren,
bijvoorbeeld 1,3,5 of 1-5 (pag. 1 t/m 5 exporteren).
Een * staat voor alle pagina&apos;s.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation>Alle pagina&apos;s exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation>Alleen de huidige pagina exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation>Oplossend vermogen (resolutie). Gebruik 72dpi voor
afbeeldingen bedoeld voor schermweergave</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="114"/>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">De gewenste kwaliteit: 100% geeft de hoogste kwaliteit, 1% de laagste</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation>Beschikbare exportformaten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation>De plaats waar de afbeeldingen moeten worden opgeslagen.
De naam van het bestand zal zijn &apos;documentnaam-pagina.type&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation>De uitvoermap wijzigen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation>Grootte van de afbeeldingen. 100% voor geen verandering, 200% voor twee maal groter, etc.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation>Afbeeldingsgrootte in pixels</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished">Automatisch</translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="39"/>
        <source>Extended Image Properties</source>
        <translation>Uitgebreide afbeeldingseigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="102"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="103"/>
        <source>Darken</source>
        <translation>Donkerder</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="104"/>
        <source>Lighten</source>
        <translation>Lichter</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="105"/>
        <source>Hue</source>
        <translation>Tint</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="106"/>
        <source>Saturation</source>
        <translation>Verzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="107"/>
        <source>Color</source>
        <translation>Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="108"/>
        <source>Luminosity</source>
        <translation>Helderheid</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="109"/>
        <source>Multiply</source>
        <translation>Vermenigvuldig</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="110"/>
        <source>Screen</source>
        <translation>Scherm</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="111"/>
        <source>Dissolve</source>
        <translation>Oplossen</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="112"/>
        <source>Overlay</source>
        <translation>Maskerlaag</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="113"/>
        <source>Hard Light</source>
        <translation>Hard licht</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="114"/>
        <source>Soft Light</source>
        <translation>Zacht licht</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="115"/>
        <source>Difference</source>
        <translation>Verschil</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="116"/>
        <source>Exclusion</source>
        <translation>Uitsluiting</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="117"/>
        <source>Color Dodge</source>
        <translation>Kleur tegenhouden</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="118"/>
        <source>Color Burn</source>
        <translation>Kleur doordrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="98"/>
        <source>Blend Mode:</source>
        <translation>Vermeng Mode:</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="121"/>
        <source>Opacity:</source>
        <translation>Doorschijnendheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="127"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="133"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="214"/>
        <source>Layers</source>
        <translation>Lagen</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="267"/>
        <source>Don&apos;t use any Path</source>
        <translation>Gebruik geen enkel pad</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="269"/>
        <source>Paths</source>
        <translation>Lokaties</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="276"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="198"/>
        <source>Size:</source>
        <translation>Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="216"/>
        <source>Title:</source>
        <translation>Titel:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="219"/>
        <source>No Title</source>
        <translation>Geen titel</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="221"/>
        <source>Author:</source>
        <translation>Auteur:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="229"/>
        <source>Unknown</source>
        <translation>Onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="231"/>
        <source>Scribus Document</source>
        <translation>Scribus document</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>Resolution:</source>
        <translation>Resolutie:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>DPI</source>
        <translation>DPI</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="193"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="190"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="205"/>
        <source>Colorspace:</source>
        <translation>Kleurruimte: </translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="196"/>
        <source>Grayscale</source>
        <translation type="obsolete">Grijstinten</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="199"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotoon</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="226"/>
        <source>File Format:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="593"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation>Enkele in dit document gebruikte fonts zijn vervangen:</translation>
    </message>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="597"/>
        <source> was replaced by: </source>
        <translation> vervangen door: </translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation type="unfinished">Bestand</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="148"/>
        <source>Face:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation type="unfinished">Stijl:</translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation type="unfinished">Font gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation type="unfinished">Stijl</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation type="unfinished">Type</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation type="unfinished">Formaat</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation type="unfinished">Insluiten in PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation type="unfinished">Subset</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation type="unfinished">Toegang</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation type="unfinished">Pad naar fontbestand</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="unfinished">Gebruiker</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="unfinished">Systeem</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation>Beschikbare fonts</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation>Font-vervangingen</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation>Additionele lokaties</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation>Font Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation>Beschikbare &amp;fonts</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation>Vervanging</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation>Font-&amp;vervangingen</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation>&amp;Toevoegen...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation>Ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation>Additionele l&amp;okaties</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="247"/>
        <source>Choose a Directory</source>
        <translation>Kies een map</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="48"/>
        <source>Font Name</source>
        <comment>font preview</comment>
        <translation type="obsolete">Font Naam</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="49"/>
        <source>Use Font</source>
        <comment>font preview</comment>
        <translation type="obsolete">Font gebruiken</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="53"/>
        <source>Subset</source>
        <comment>font preview</comment>
        <translation type="obsolete">Subset</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="55"/>
        <source>Path to Font File</source>
        <comment>font preview</comment>
        <translation type="obsolete">Pad naar fontbestand</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="51"/>
        <source>Embed in PostScript</source>
        <comment>font preview</comment>
        <translation type="obsolete">Insluiten in PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="130"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation>Een font zoekpad kan alleen worden ingesteld in Bestand &gt; Voorkeuren, en alleen als er geen document is geopend. Sluiten alle documenten, en gebruik Bestand &gt; Voorkeuren &gt; Fonts om het font zoekpad te wijzigen.</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="57"/>
        <source>Use Font</source>
        <translation type="obsolete">Font gebruiken</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="58"/>
        <source>Embed in PostScript</source>
        <translation type="obsolete">Insluiten in PostScript</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="59"/>
        <source>Subset</source>
        <translation type="obsolete">Subset</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="60"/>
        <source>Path to Font File</source>
        <translation type="obsolete">Pad naar fontbestand</translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="97"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="obsolete">Gebruiker</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="98"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="obsolete">Systeem</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="164"/>
        <source>Append selected font into Style, Font menu</source>
        <comment>font preview</comment>
        <translation type="obsolete">Het geselecteerde font toepassen in het menu Stijl, Font</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation>Voorbeeld sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation>Sexy qua lijf, doch bang voor &apos;t zwempak</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="114"/>
        <source>Start searching</source>
        <translation type="obsolete">Start zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation>Grootte van geselecteerde font</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample will be shown after key release</source>
        <translation type="obsolete">Voorbeeld wordt getoond nadat toets is losgelaten</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="165"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. You can provide a common wild cards (*, ?, [...]) in your phrase. Examples: t* will list all fonts starting with t or T. *bold* will list all fonts with word bold, bolder etc. in the name.</source>
        <translation type="obsolete">De tekst hier getyped zal snel gezocht worden in de fontnamen. Zoeken is hoofdletterongevoelig. U kunt gebruik maken van wildcards (*, ?, [...]) in de tekst. Voorbeeld: t* zal alle fonts beginnend met t of T opsommen. *bold* zal alle fonts met het woord bold, bolder enz. opsommen.</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="43"/>
        <source>Doc</source>
        <translation type="obsolete">Doc</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Type</source>
        <translation type="obsolete">Type</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="45"/>
        <source>Subset</source>
        <translation type="obsolete">Subset</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="46"/>
        <source>Access</source>
        <translation type="obsolete">Toegang</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation type="unfinished">Fontvoorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation type="unfinished">&amp;Snel zoeken:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="38"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation type="unfinished">&amp;Lettergrootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation type="unfinished">Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation type="unfinished">Te tonen voorbeeldtekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation type="unfinished">Se&amp;t</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation type="unfinished">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation type="unfinished">Herstel de tekst</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.ui" line="209"/>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts Preview</source>
        <translation type="obsolete">Fontvoorbeeld</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quick Search:</source>
        <translation type="obsolete">&amp;Snel zoeken:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Name</source>
        <translation type="obsolete">Fontnaam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc</source>
        <translation type="obsolete">Doc</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Type</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Subset</source>
        <translation type="obsolete">Subset</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Access</source>
        <translation type="obsolete">Toegang</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">&amp;Lettergrootte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text</source>
        <translation type="obsolete">Tekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample text to display</source>
        <translation type="obsolete">Te tonen voorbeeldtekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Se&amp;t</source>
        <translation type="obsolete">Se&amp;t</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset the text</source>
        <translation type="obsolete">Herstel de tekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation>&amp;Fontweergave...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation>Fontvoorbeeldvenster</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation>Sorteer, zoek en blader door beschikbare fonts.</translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation>Fontvervanging</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation>Orginele font</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation>Vervangend font</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation>Maak deze vervanging definitief</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation>Dit document bevat enkele fonts die niet op uw systeem geïnstalleerd zijn, kies vervangende fonts. Annuleren stop het laden van dit document.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation>Annuleert de fontvervanging en stopt het laden van het document.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation>Bij inschakelen zal Scribus deze vervangingen voor ontbrekende fonts permanent gebruiken in toekomstige layouts. Dit kan ongedaan worden gemaakt of aangepast worden in Bestand&gt; Voorkeuren&gt; Fonts.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation>Als u OK selecteert, dan bewaren, zullen deze vervangingen definitief gemaakt worden in dit document.</translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="327"/>
        <source>Position:</source>
        <translation>Positie:</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="328"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="336"/>
        <source>Add, change or remove color stops here</source>
        <translation>Verander, verwijder of voeg kleurstops hier toe</translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <location filename="../guidemanager.cpp" line="229"/>
        <source>Edit Guide</source>
        <translation type="obsolete">Hulplijn bewerken</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="257"/>
        <source>Enter a position:</source>
        <translation type="obsolete">Positie invoeren:</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="256"/>
        <source>New Guide</source>
        <translation type="obsolete">Nieuwe hulplijn</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="31"/>
        <source>&amp;Single</source>
        <translation type="unfinished">&amp;Enkele</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="146"/>
        <source>Horizontals</source>
        <translation type="unfinished">Horizontalen</translation>
    </message>
    <message>
        <location filename="../guidemanager.ui" line="99"/>
        <source>Guide</source>
        <translation type="obsolete">Hulplijn</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="55"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="356"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="65"/>
        <source>D&amp;elete</source>
        <translation type="unfinished">V&amp;erwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="307"/>
        <source>Alt+E</source>
        <translation type="unfinished">Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="233"/>
        <source>Verticals</source>
        <translation type="unfinished">Verticalen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="94"/>
        <source>A&amp;dd</source>
        <translation type="unfinished">Toe&amp;voegen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="97"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="104"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">Ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="122"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="119"/>
        <source>&amp;Lock Guides</source>
        <translation type="unfinished">Hulplijnen vast&amp;zetten</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="320"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="unfinished">Op all&amp;e pagina&apos;s toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="323"/>
        <source>Alt+Y</source>
        <translation type="unfinished">Alt+Y</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="140"/>
        <source>&amp;Column/Row</source>
        <translation type="unfinished">&amp;Kolom/Rij</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="152"/>
        <source>&amp;Number:</source>
        <translation type="unfinished">&amp;Nummer:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="175"/>
        <source>U&amp;se Gap:</source>
        <translation type="unfinished">Gebru&amp;ik tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="178"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="275"/>
        <source>Refer To</source>
        <translation type="unfinished">Refereer aan</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="281"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="343"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="294"/>
        <source>M&amp;argins</source>
        <translation type="unfinished">M&amp;arges</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="304"/>
        <source>S&amp;election</source>
        <translation type="unfinished">S&amp;electie</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="239"/>
        <source>Nu&amp;mber:</source>
        <translation type="unfinished">Nu&amp;mmer:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="262"/>
        <source>Use &amp;Gap:</source>
        <translation type="unfinished">&amp;Gebruik tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="265"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="331"/>
        <source>&amp;Misc</source>
        <translation type="unfinished">&amp;Diversen</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="337"/>
        <source>Delete all guides from the current page</source>
        <translation type="unfinished">Verwijder alle hulplijnen op de huidige pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="340"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="unfinished">Verwijder alle hulplijnen op de huidige &amp;pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="350"/>
        <source>Delete all guides from the current document</source>
        <translation type="unfinished">Verwijder alle hulplijnen van het huidige document</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="353"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="unfinished">Verwijder hulplijnen op &amp;alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="15"/>
        <source>Guide Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManagerBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Hulplijnen beheren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Single</source>
        <translation type="obsolete">&amp;Enkele</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontals</source>
        <translation type="obsolete">Horizontalen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guide</source>
        <translation type="obsolete">Hulplijn</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;elete</source>
        <translation type="obsolete">V&amp;erwijderen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+E</source>
        <translation type="obsolete">Alt+E</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Verticals</source>
        <translation type="obsolete">Verticalen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;dd</source>
        <translation type="obsolete">Toe&amp;voegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">Ve&amp;rwijderen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lock Guides</source>
        <translation type="obsolete">Hulplijnen vast&amp;zetten</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="obsolete">Op all&amp;e pagina&apos;s toepassen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+Y</source>
        <translation type="obsolete">Alt+Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Column/Row</source>
        <translation type="obsolete">&amp;Kolom/Rij</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number:</source>
        <translation type="obsolete">&amp;Nummer:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>U&amp;se Gap:</source>
        <translation type="obsolete">Gebru&amp;ik tussenruimte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Refer To</source>
        <translation type="obsolete">Refereer aan</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Page</source>
        <translation type="obsolete">&amp;Pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M&amp;argins</source>
        <translation type="obsolete">M&amp;arges</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;election</source>
        <translation type="obsolete">S&amp;electie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Nu&amp;mber:</source>
        <translation type="obsolete">Nu&amp;mmer:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use &amp;Gap:</source>
        <translation type="obsolete">&amp;Gebruik tussenruimte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Misc</source>
        <translation type="obsolete">&amp;Diversen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current page</source>
        <translation type="obsolete">Verwijder alle hulplijnen op de huidige pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current document</source>
        <translation type="obsolete">Verwijder alle hulplijnen van het huidige document</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="obsolete">Verwijder alle hulplijnen op de huidige &amp;pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="obsolete">Verwijder hulplijnen op &amp;alle pagina&apos;s</translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <location filename="../helpbrowser.cpp" line="265"/>
        <source>Sorry, no manual available! Please see: http://docs.scribus.net for updated docs
and www.scribus.net for downloads.</source>
        <translation type="obsolete">Helaas, geen handleiding beschikbaar! Kijk op http://docs.scribus.net/ voor bijgewerkte
documentatie en op http://www.scribus.net/ voor downloads.</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="457"/>
        <source>Contents</source>
        <translation type="obsolete">Inhoud</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="343"/>
        <source>Link</source>
        <translation type="obsolete">Koppeling</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="287"/>
        <source>Scribus Online Help</source>
        <translation>Scribus online hulp</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation>&amp;Inhoud</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation>&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation>Zo&amp;eken</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation>&amp;Nieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="178"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="355"/>
        <source>De&amp;lete All</source>
        <translation type="obsolete">A&amp;lles verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation>&amp;Bladwijzers</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="148"/>
        <source>&amp;Print...</source>
        <translation>Afdru&amp;kken...</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="216"/>
        <source>E&amp;xit</source>
        <translation type="obsolete">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="461"/>
        <source>Searching is case unsensitive</source>
        <translation type="obsolete">Zoeken is niet hoofdlettergevoelig</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Find</source>
        <translation>Vind</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Search Term:</source>
        <translation>Zoekterm:</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark</source>
        <translation>Nieuwe bladwijzer</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation>Nieuwe bladwijzertitel:</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;File</source>
        <translation>&amp;Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="158"/>
        <source>&amp;Find...</source>
        <translation>&amp;Vind...</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Next</source>
        <translation>Vind v&amp;olgende</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="297"/>
        <source>Find &amp;Previous</source>
        <translation>Vind vo&amp;rige</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Edit</source>
        <translation>Be&amp;werken</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Add Bookmark</source>
        <translation>Bl&amp;adwijzer toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="183"/>
        <source>D&amp;elete All</source>
        <translation>All&amp;es verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="291"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Bladwijzers</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="325"/>
        <source>Relevance</source>
        <translation type="obsolete">Relevantie</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation type="unfinished">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="715"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HelpBrowser2</name>
    <message>
        <location filename="../ui/hb2.ui" line="30"/>
        <source>&amp;Contents</source>
        <translation type="obsolete">&amp;Inhoud</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="49"/>
        <source>Se&amp;arch</source>
        <translation type="obsolete">Zo&amp;eken</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="64"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="77"/>
        <source>Book&amp;marks</source>
        <translation type="obsolete">&amp;Bladwijzers</translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation>Mogelijke afbreking</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation>Accepteren</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation>Overslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <location filename="../hysettings.cpp" line="40"/>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Taal:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="46"/>
        <source>&amp;Smallest Word:</source>
        <translation type="obsolete">&amp;Kleinste woord:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="58"/>
        <source>Length of the smallest word to be hyphenated.</source>
        <translation type="obsolete">Woorden korter dan deze lengte worden niet afgebroken.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="59"/>
        <source>Maximum number of Hyphenations following each other.
A value of 0 means unlimited hyphenations.</source>
        <translation type="obsolete">Maximaal aantal afbrekingen dat elkaar mag opvolgen.
De waarde 0 betekent onbeperkt.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="20"/>
        <source>&amp;Hyphenation Suggestions</source>
        <translation type="obsolete">A&amp;fbreeksuggesties</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="23"/>
        <source>Hyphenate Text Automatically &amp;During Typing</source>
        <translation type="obsolete">Automatisch afbreken tij&amp;dens typen</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="56"/>
        <source>A dialog box showing all possible hyphens for each word will show up when you use the Extras, Hyphenate Text option.</source>
        <translation type="obsolete">Met de optie Extra, Tekst afbreken krijgt u een dialoogvenster te zien met alle afbreekmogelijkheden voor elk woord.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="57"/>
        <source>Enables automatic hyphenation of your text while typing.</source>
        <translation type="obsolete">Voorziet tekst tijdens het typen direct van afbreektekens.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="52"/>
        <source>Consecutive Hyphenations &amp;Allowed:</source>
        <translation type="obsolete">Opeenvolgende &amp;afbrekingen toegestaan:</translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="92"/>
        <source>Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="121"/>
        <source>Add a new Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Edit Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Exception List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation>Afbeelding informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation>Algemene informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation>Datum / Tijd:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation>Heeft ingebed profiel:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation>Profielnaam:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation>Heeft ingebedde paden:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation>Heeft lagen:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation>EXIF Informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation>Artiest:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation>Commentaar:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation>Gebruikerscommentaar:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation>Cameramodel:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation>Camerafabrikant:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation>Omschrijving:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation>Auteursrecht:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation>Scannermodel:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation>Scannerfabrikant:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation>Belichtingstijd</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation>Diafragma:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation>ISO equiv.:</translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished">Het bestand kan niet worden geïmporteerd</translation>
    </message>
</context>
<context>
    <name>ImportDialog</name>
    <message>
        <location filename="../smstyleimport.cpp" line="30"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Kies stijlen</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="35"/>
        <source>Available Styles</source>
        <translation type="obsolete">Beschikbare stijlen</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="40"/>
        <source>Character Styles</source>
        <translation type="obsolete">Teken stijlen</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="49"/>
        <source>Paragraph Styles</source>
        <translation type="obsolete">Alineastijlen</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="58"/>
        <source>Line Styles</source>
        <translation type="obsolete">Lijnstijlen</translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">&amp;EPS/PS importeren...</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports EPS Files</source>
        <translation type="obsolete">EPS bestanden importeren</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most EPS files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Importeert de meeste EPS bestanden naar het huidige document,
zet de vectordata om naar Scribus objecten.</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="92"/>
        <source>PostScript</source>
        <translation type="obsolete">Postscript</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="105"/>
        <source>PDF</source>
        <translation type="obsolete">PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Alle ondersteunde formaten</translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation type="unfinished">Staand</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation type="unfinished">Liggend</translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation type="unfinished">Dubbelzijdig</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation type="unfinished">Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation type="unfinished">Oriëntatie</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation type="unfinished">Breedte</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation type="unfinished">Hoogte</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation>Pagina invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation>pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation>voor pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation>na pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation>aan het eind</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation>&amp;Invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation>Pagina sjablonen</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="77"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Pagina sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="205"/>
        <source>Page Size</source>
        <translation>Paginagrootte</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="209"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="224"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orië&amp;ntatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="227"/>
        <source>Portrait</source>
        <translation>Staand</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="228"/>
        <source>Landscape</source>
        <translation>Liggend</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="233"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="240"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="245"/>
        <source>Move Objects with their Page</source>
        <translation>Verplaats objecten met hun pagina</translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="115"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable format from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the simple Story Editor.</source>
        <translation type="obsolete">&lt;b&gt;Tekst frame invoegen&lt;/b&gt;&lt;br/&gt;In een tekstframe kan tekst worden ingevoegd op een bepaalde plaats in een bepaalde gekozen vormgeving.. Tekst mag worden geselecteerd bij de Opties tab, als een document onmiddelijk in een tekstframe moet worden geïmporteerd. Scribus ondersteunt een groot aantal bestandsformaten, van platte tekst tot OpenOffice.org&lt;br/&gt;Tekst kan worden bewerkt direct op de pagina of in de eenvoudige Story Editor.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="119"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="obsolete">&lt;b&gt;Voeg een afbeeldingenframe in&lt;/b&gt;&lt;br/&gt;Met een afbeeldingenframe kunnen afbeeldingen op een pagina worden geplaatst. Verschillende effecten kunnen worden toegepast en gecombineerd, waaronder transparatie, aanpassen helderheid, posterisatie voor interessante visuele resultaten. Aanpassen van grootte en vorm kan via het eigenschappen palet.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="13"/>
        <source>Insert A Frame</source>
        <translation type="unfinished">Frame invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="37"/>
        <source>T&amp;ype</source>
        <translation type="unfinished">T&amp;ype</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="75"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Tekstframe</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="73"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="85"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished">&amp;Afbeeldingsframe</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="83"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="93"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="106"/>
        <source>Shape</source>
        <translation type="obsolete">Vorm</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="116"/>
        <source>Polygon</source>
        <translation type="obsolete">Polygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="122"/>
        <source>&amp;Location</source>
        <translation type="unfinished">&amp;Locatie</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="137"/>
        <source>Page Placement</source>
        <translation type="unfinished">Pagina plaatsing</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="195"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Selectie zal dit frame uitsluitend op de huidige pagina plaatsen.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="152"/>
        <source>Current Page</source>
        <translation type="unfinished">Huidige pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="162"/>
        <source>All Pages</source>
        <translation type="unfinished">Alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="205"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Selectie zal dit frame uitsluitend in het huidige bereik plaatsen. </translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="208"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Bereik van pagina&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="773"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="225"/>
        <source>Position of Frame</source>
        <translation type="unfinished">Frame positie</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="310"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Selectie zal dit frame plaatsen in de linker bovenzijde van de paginamarges vastgesteld in de document instellingen.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="240"/>
        <source>Top Left of Margins</source>
        <translation type="unfinished">Linkerboven zijde van marges</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="320"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Selectie plaatst het frame linksboven in de positie 0,0</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="250"/>
        <source>Top Left of Page</source>
        <translation type="unfinished">Linker bovenzijde van de pagina</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="330"/>
        <source>Selecting this places the frame in the upper left of the page bleed defined in your doc setup.</source>
        <translation type="obsolete">Selectie zal dit frame plaatsen in de linker bovenzijde van de pagina afloop vastgesteld in de document instellingen.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="260"/>
        <source>Top Left of Bleed</source>
        <translation type="unfinished">Linker bovenzijde van afloop</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="340"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Stel de gewenste afmetingen vast in de X: Y: dialoog hieronder.</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="343"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Aangepaste positie:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="316"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="309"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="379"/>
        <source>&amp;Size</source>
        <translation type="unfinished">&amp;Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="409"/>
        <source>Same as the Page Margins</source>
        <translation type="unfinished">Gelijk aan pagina marges</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="419"/>
        <source>Same as the Page</source>
        <translation type="unfinished">Gelijk aan de pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="429"/>
        <source>Same as the Bleed</source>
        <translation type="unfinished">Gelijk aan afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="439"/>
        <source>Same as the Imported Image</source>
        <translation type="unfinished">Gelijk aan de geimporteerde afbeelding</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="539"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Aangepast formaat:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="488"/>
        <source>Height:</source>
        <translation type="unfinished">Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="495"/>
        <source>Width:</source>
        <translation type="unfinished">Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="558"/>
        <source>&amp;Options</source>
        <translation type="unfinished">&amp;Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="759"/>
        <source>Source Image:</source>
        <translation type="unfinished">Bron afbeelding:</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="914"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">Be&amp;stand selecteren...</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="917"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="813"/>
        <source>There are no options for this type of frame</source>
        <translation type="unfinished">Voor dit type frame zijn geen opties</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="625"/>
        <source>Columns:</source>
        <translation type="unfinished">Kolommen:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="611"/>
        <source>Gap:</source>
        <translation type="unfinished">Tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="531"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Koppel tekstframes</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="697"/>
        <source>Source Document:</source>
        <translation type="unfinished">Bron document:</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="974"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="990"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="172"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Bereik van pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="270"/>
        <source>Custom Position</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="449"/>
        <source>Custom Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="72"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="82"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="134"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="149"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="159"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="169"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="187"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="222"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="237"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="247"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="257"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="267"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="323"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="330"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="406"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="416"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="426"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="436"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="446"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="502"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="509"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="601"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="618"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="649"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="652"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="661"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="664"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="680"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="704"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="766"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrameBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert A Frame</source>
        <translation type="obsolete">Frame invoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;ype</source>
        <translation type="obsolete">T&amp;ype</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">&amp;Tekstframe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Image Frame</source>
        <translation type="obsolete">&amp;Afbeeldingsframe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shape</source>
        <translation type="obsolete">Vorm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polygon</source>
        <translation type="obsolete">Polygoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Location</source>
        <translation type="obsolete">&amp;Locatie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Placement</source>
        <translation type="obsolete">Pagina plaatsing</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Page</source>
        <translation type="obsolete">Huidige pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Selectie zal dit frame uitsluitend op de huidige pagina plaatsen.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Pages</source>
        <translation type="obsolete">Alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Bereik van pagina&apos;s:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Selectie zal dit frame uitsluitend in het huidige bereik plaatsen. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Position of Frame</source>
        <translation type="obsolete">Frame positie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Margins</source>
        <translation type="obsolete">Linkerboven zijde van marges</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Selectie zal dit frame plaatsen in de linker bovenzijde van de paginamarges vastgesteld in de document instellingen.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Page</source>
        <translation type="obsolete">Linker bovenzijde van de pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Selectie plaatst het frame linksboven in de positie 0,0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Bleed</source>
        <translation type="obsolete">Linker bovenzijde van afloop</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this places the frame in the upper left of the page bleed defined in your doc setup.</source>
        <translation type="obsolete">Selectie zal dit frame plaatsen in de linker bovenzijde van de pagina afloop vastgesteld in de document instellingen.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Aangepaste positie:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Stel de gewenste afmetingen vast in de X: Y: dialoog hieronder.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X:</source>
        <translation type="obsolete">X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Size</source>
        <translation type="obsolete">&amp;Grootte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page Margins</source>
        <translation type="obsolete">Gelijk aan pagina marges</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page</source>
        <translation type="obsolete">Gelijk aan de pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Bleed</source>
        <translation type="obsolete">Gelijk aan afloop</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Imported Image</source>
        <translation type="obsolete">Gelijk aan de geimporteerde afbeelding</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Aangepast formaat:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height:</source>
        <translation type="obsolete">Hoogte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width:</source>
        <translation type="obsolete">Breedte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Options</source>
        <translation type="obsolete">&amp;Opties</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Image:</source>
        <translation type="obsolete">Bron afbeelding:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">Be&amp;stand selecteren...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>There are no options for this type of frame</source>
        <translation type="obsolete">Voor dit type frame zijn geen opties</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Columns:</source>
        <translation type="obsolete">Kolommen:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gap:</source>
        <translation type="obsolete">Tussenruimte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Koppel tekstframes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Document:</source>
        <translation type="obsolete">Bron document:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation>Tabel invoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation>Aantal rijen:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation>Aantal kolommen:</translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="27"/>
        <source>Edit JavaScripts</source>
        <translation>JavaScripts bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="46"/>
        <source>&amp;Edit...</source>
        <translation>B&amp;ewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="49"/>
        <source>&amp;Add...</source>
        <translation>&amp;Toevoegen...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="52"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="57"/>
        <source>&amp;Close</source>
        <translation>&amp;Sluiten&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="77"/>
        <source>&amp;New Script:</source>
        <translation>&amp;Nieuw script:</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="78"/>
        <source>New Script</source>
        <translation>Nieuw script</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation>Wilt u dit script werkelijk verwijderen?</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="71"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation>Voegt een nieuw Script toe, benoemt een functie met dezelfde naam. Als u dit script als een &quot;Open Actie&quot; script wilt gebruiken, verander dan de naam van de functie.</translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="32"/>
        <source>Enter Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="44"/>
        <source>Update</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="51"/>
        <source>Revert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="130"/>
        <source>Program Messages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="181"/>
        <source>Status: Unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="165"/>
        <source>Kill Program</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="73"/>
        <source>Options</source>
        <translation type="unfinished">Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="81"/>
        <source>Resolution:</source>
        <translation type="unfinished">Resolutie:</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="88"/>
        <source>Automatic</source>
        <translation type="unfinished">Automatisch</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="91"/>
        <source> DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="104"/>
        <source>Program:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="116"/>
        <source>Use Preamble</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="330"/>
        <source>Status: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="334"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="336"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="339"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="518"/>
        <source>No item selected!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="520"/>
        <source>Insert symbol</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="13"/>
        <source>Editor</source>
        <translation type="unfinished">Editor</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished">Informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="124"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="132"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="167"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="222"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="225"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="155"/>
        <source>Run external editor...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../scribus/layers.cpp" line="567"/>
        <source>Layers</source>
        <translation>Lagen</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="290"/>
        <source>Delete Layer</source>
        <translation>Laag verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="588"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="291"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation>Wilt u alle objecten op deze laag ook verwijderen?</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="596"/>
        <source>Add a new layer</source>
        <translation>Voeg een nieuwe laag toe</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="598"/>
        <source>Delete layer</source>
        <translation>Laag verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="599"/>
        <source>Raise layer</source>
        <translation>Laag omhoog</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="600"/>
        <source>Lower layer</source>
        <translation>Verlaag laag</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="586"/>
        <source>Opacity:</source>
        <translation>Ondoorschijnendheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="587"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="568"/>
        <source>Blend Mode:</source>
        <translation>Vermeng Mode:</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="570"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="571"/>
        <source>Darken</source>
        <translation>Donkerder</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="572"/>
        <source>Lighten</source>
        <translation>Lichter</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="573"/>
        <source>Multiply</source>
        <translation>Vermenigvuldig</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="574"/>
        <source>Screen</source>
        <translation>Scherm</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="575"/>
        <source>Overlay</source>
        <translation>Maskerlaag</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="576"/>
        <source>Hard Light</source>
        <translation>Hard licht</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="577"/>
        <source>Soft Light</source>
        <translation>Zacht licht</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="578"/>
        <source>Difference</source>
        <translation>Verschil</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="579"/>
        <source>Exclusion</source>
        <translation>Uitsluiting</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="580"/>
        <source>Color Dodge</source>
        <translation>Kleur tegenhouden</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="581"/>
        <source>Color Burn</source>
        <translation>Kleur doordrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="582"/>
        <source>Hue</source>
        <translation>Tint</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="583"/>
        <source>Saturation</source>
        <translation>Verzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="584"/>
        <source>Color</source>
        <translation>Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="585"/>
        <source>Luminosity</source>
        <translation>Helderheid</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="597"/>
        <source>Duplicates the current layer</source>
        <translation>Dupliceer de huidige laag</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="603"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="unfinished">Kleur van de laag indicator - Elke laag wordt een kleur voor weergave toegewezen als de laag indicatoren zijn ingeschakeld. Dubbelklik om de kleur te bewerken.</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="604"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="unfinished">Maak laag zichtbaar - Uitschakelen om de laag  te verbergen </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="605"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="unfinished">Afdruklaag - Uitschakelen om printen uit te schakelen. </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="606"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="unfinished">Vergrendel of ontgrendel laag - Uitgeschakeld is ontgrendeld </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="607"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="unfinished">Tekst loopt om object in onderliggende lagen - Inschakelen zorgt voor tekstomloop rond andere objecten, zelfs in onderliggende lagen</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="608"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished">Outline modus - Schakelt &apos;draadmodel-weergave&apos; van objecten in om weergave van complexe objecten te versnellen.</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="609"/>
        <source>Name of the Layer - Double clicking on the name of a layer enabled editing</source>
        <translation type="unfinished">Naam van de laag - Dubbelklikken op de naam van de laag maakt bewerken mogelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="601"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="602"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <location filename="../canvasmode_legacy.cpp" line="4973"/>
        <source>All Files (*)</source>
        <translation type="obsolete">Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="5023"/>
        <source>Open</source>
        <translation type="unfinished">Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="4993"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Alle ondersteunde formaten</translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="198"/>
        <source>Radius:</source>
        <translation type="obsolete">Radius:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LineFormate</name>
    <message>
        <location filename="../lineformats.cpp" line="33"/>
        <source>Edit Line Styles</source>
        <translation type="obsolete">Lijnstijlen bewerken</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="52"/>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Nieuw</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="55"/>
        <source>&amp;Edit</source>
        <translation type="obsolete">B&amp;ewerken</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="60"/>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">D&amp;upliceren</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="64"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="68"/>
        <source>&amp;Save</source>
        <translation type="obsolete">Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="125"/>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="154"/>
        <source>New Style</source>
        <translation type="obsolete">Nieuwe stijl</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Open</source>
        <translation type="obsolete">Openen</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Documenten (*.sla *.sla.gz *.scd *.scd.gz);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="49"/>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Importeren</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="194"/>
        <source>Do you really want to delete this style?</source>
        <translation type="obsolete">Wilt u deze stijl werkelijk verwijderen?</translation>
    </message>
</context>
<context>
    <name>LineStyleW</name>
    <message>
        <location filename="../smlinestylew.ui" line="184"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="../smlinestylew.ui" line="208"/>
        <source>Line Width:</source>
        <translation type="obsolete">Lijndikte:</translation>
    </message>
</context>
<context>
    <name>LineStyleWBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Width:</source>
        <translation type="obsolete">Lijndikte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>LineStyleWBase</source>
        <translation type="obsolete">LijnstijlWBase</translation>
    </message>
</context>
<context>
    <name>LineStyleWidget</name>
    <message>
        <location filename="../smlinestyle.cpp" line="180"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="52"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Plat eind</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="53"/>
        <source>Square Cap</source>
        <translation type="obsolete">Vierkant eind</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="54"/>
        <source>Round Cap</source>
        <translation type="obsolete">Rond eind</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="56"/>
        <source>Miter Join</source>
        <translation type="obsolete">Verstekverbinding</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="57"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Schuine verbinding</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="58"/>
        <source>Round Join</source>
        <translation type="obsolete">Ronde verbinding</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="70"/>
        <source>Add a new line</source>
        <translation type="obsolete">Nieuwe lijn toevoegen</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="71"/>
        <source>Remove a line</source>
        <translation type="obsolete">Lijn verwijderen</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="72"/>
        <source>Line style</source>
        <translation type="obsolete">Lijnstijl</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="73"/>
        <source>Line width</source>
        <translation type="obsolete">Lijndikte</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="74"/>
        <source>End style</source>
        <translation type="obsolete">Eindstijl</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="75"/>
        <source>Join style</source>
        <translation type="obsolete">Stijl verbinding</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="76"/>
        <source>Line color</source>
        <translation type="obsolete">Lijnkleur</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="77"/>
        <source>Line shade</source>
        <translation type="obsolete">Lijntint</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation>Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation>Selecteer Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation>Auteur:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation>Meer verkrijgen:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation>XML bestand:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation>Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation>Alinea&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation>Atl+O</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation>Standaard Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation>Paginaeigenschappen bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation>Paginagrootte</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orië&amp;ntatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation>Staand</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation>Liggend</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation>Verplaats objecten met hun pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation>Type:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation>Marge hulplijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation>Andere instellingen</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation>Sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="43"/>
        <source>&amp;Bottom:</source>
        <translation>On&amp;der:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="45"/>
        <source>&amp;Top:</source>
        <translation>&amp;Boven:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>&amp;Right:</source>
        <translation>&amp;Rechts:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Left:</source>
        <translation>&amp;Links:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation>Afstand tussen de bovenkant van de marge en de rand van het papier</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation>Afstand tussen de onderkant van de marge en de rand van het papier</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Inside:</source>
        <translation>B&amp;innenkant:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>O&amp;utside:</source>
        <translation>B&amp;uitenkant:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="33"/>
        <source>Preset Layouts:</source>
        <translation>Vooringestelde Layouts:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation>De geselecteerde margeinstellingen op alle bestaande pagina&apos;s van het document toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="102"/>
        <source>Printer Margins...</source>
        <translation>Printer marges...</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="104"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation>Importeer de marges voor de geselecteerde paginagrootte bij de beschikbare printers.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="79"/>
        <source>Apply settings to:</source>
        <translation>Instellingen toepassen op:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="82"/>
        <source>All Document Pages</source>
        <translation>Alle document pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="86"/>
        <source>All Master Pages</source>
        <translation>Alle pagina sjablonen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="91"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation>De geselecteerde margeinstellingen op alle bestaande pagina sjablonen van het document toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="108"/>
        <source>Margin Guides</source>
        <translation>Marge hulplijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="126"/>
        <source>Top:</source>
        <translation>Boven:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="131"/>
        <source>Bottom:</source>
        <translation>Onder:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation>Afstand voor afloop vanaf de bovenkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation>Afstand voor afloop vanaf de onderkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation>Afstand voor afloop vanaf de linkerkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="146"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation>Afstand voor afloop vanaf de rechterkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="152"/>
        <source>Bleeds</source>
        <translation>Afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation>Afstand tussen de linker marge hulplijn en de rand van de pagina. Als een dubbelzijdige,3 of 4 slag layout is geselecteerd, kan deze marge-ruimte worden gebruikt om correcte bindmarges te verkrijgen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="159"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation>Afstand tussen de rechter marge hulplijn en de rand van de pagina. Als een dubbelzijdige,3 of 4 slag layout is geselecteerd, kan deze marge-ruimte worden gebruikt om correcte bindmarges te verkrijgen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="217"/>
        <source>Inside:</source>
        <translation>Binnenzijde:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="218"/>
        <source>Outside:</source>
        <translation>Buitenzijde:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="222"/>
        <source>Left:</source>
        <translation>Links:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="223"/>
        <source>Right:</source>
        <translation>Rechts:</translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="39"/>
        <source>Edit Master Pages</source>
        <translation>Bewerk pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="116"/>
        <source>Do you really want to delete this master page?</source>
        <translation>Wilt u dit pagina sjabloon werkelijk verwijderen?</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>New Master Page</source>
        <translation>Nieuw pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>Name:</source>
        <translation>Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New MasterPage</source>
        <translation>Nieuw pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="325"/>
        <source>Copy #%1 of </source>
        <translation>Kopie #%1 van</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="79"/>
        <source>Duplicate the selected master page</source>
        <translation>Dupliceer het geselecteerd pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="80"/>
        <source>Delete the selected master page</source>
        <translation>Verwijder het geselecteerde pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="81"/>
        <source>Add a new master page</source>
        <translation>Voeg een nieuw pagina sjabloon toe</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="82"/>
        <source>Import master pages from another document</source>
        <translation>Importeer pagina sjablonen vanuit een ander document</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New Master Page %1</source>
        <translation>Nieuw pagina sjabloon %1</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>Unable to Rename Master Page</source>
        <translation>Kan pagina sjabloon niet hernoemen</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation>De standaard pagina is niet hernoembaar.</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>Rename Master Page</source>
        <translation>Hernoem pagina sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>New Name:</source>
        <translation>Nieuwe naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="141"/>
        <source>Copy #%1 of %2</source>
        <translation>Kopie #%1 van %2</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="112"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Mdup</name>
    <message>
        <location filename="../mdup.cpp" line="29"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Meervoudig dupliceren</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="48"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Aa&amp;ntal kopieën:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="50"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Horizontale verplaatsing:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="52"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Verticale verplaatsing:</translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>Measurements</name>
    <message>
        <location filename="../../scribus/measurements.cpp" line="127"/>
        <source>Distances</source>
        <translation type="obsolete">Afstanden</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="129"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="130"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="131"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="132"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="133"/>
        <source>DX:</source>
        <translation type="obsolete">dX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="134"/>
        <source>DY:</source>
        <translation type="obsolete">dY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="135"/>
        <source>Angle:</source>
        <translation type="obsolete">Hoek:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="136"/>
        <source>Length:</source>
        <translation type="obsolete">Lengte:</translation>
    </message>
    <message>
        <location filename="../measurements.cpp" line="49"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/measurements.cpp" line="51"/>
        <source> °</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished">Afstanden</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Lengte:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished">dX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished">dY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Hoek:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation>Pagina(&apos;s) importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation>van 0</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation>Pagina(&apos;s) aanmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation>Documenten (*.sla *.sla.gz *.scd *.scd.gz);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation>van %1</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation>&amp;Van document:</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>Chan&amp;ge...</source>
        <translation type="obsolete">Wijzi&amp;gen...</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation>Pagina(&apos;s) &amp;importeren:</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation>Voor pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation>Na pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation>Aan het einde</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation>&amp;Importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation>Pagina sjabloon importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation>Pag&amp;ina sjabloon importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="72"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation>Voer hier de paginanummer(s) in die u wilt importeren,bijvoorbeeld 1,3,5 of 1-5 (pag. 1 t/m 5 exporteren). Een * staat voor alle pagina&apos;s.</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished">He&amp;rstel</translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation>Missend font</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation>Font %1 is niet geïnstalleerd.</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation>Gebruik</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="336"/>
        <source>instead</source>
        <translation>in plaats van</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation>Gereedschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="121"/>
        <source>Properties...</source>
        <translation>Eigenschappen...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation>Pagina&apos;s verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation>Pagina kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation>Pagina(&apos;s) verplaatsen:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation>Pagina(&apos;s) verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation>Voor pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation>Na pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation>Aan het einde</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation>tot:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="58"/>
        <source>Number of copies:</source>
        <translation>Aantal Kopieën:</translation>
    </message>
</context>
<context>
    <name>MultiLine</name>
    <message>
        <location filename="../multiline.cpp" line="32"/>
        <source>Edit Style</source>
        <translation type="obsolete">Stijl bewerken</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="86"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Plat eind</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="87"/>
        <source>Square Cap</source>
        <translation type="obsolete">Vierkant eind</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="88"/>
        <source>Round Cap</source>
        <translation type="obsolete">Rond eind</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="92"/>
        <source>Miter Join</source>
        <translation type="obsolete">Verstekverbinding</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="93"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Schuine verbinding</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="94"/>
        <source>Round Join</source>
        <translation type="obsolete">Ronde verbinding</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="100"/>
        <source>Line Width:</source>
        <translation type="obsolete">Lijndikte:</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="105"/>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="118"/>
        <source> %</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="obsolete">Naam &quot;%1&quot; is niet uniek.&lt;br/&gt;Kies een andere naam.</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="270"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation type="unfinished">Voortgang</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation type="unfinished">Algehele voortgang:</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiProgressDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Progress</source>
        <translation type="obsolete">Voortgang</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overall Progress:</source>
        <translation type="obsolete">Algehele voortgang:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="112"/>
        <source>&amp;Horizontal Shift:</source>
        <translation>&amp;Horizontale verplaatsing:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="165"/>
        <source>&amp;Vertical Shift:</source>
        <translation>&amp;Verticale verplaatsing:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation>&amp;Horizontale tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation>&amp;Verticale tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation type="unfinished">Meervoudig dupliceren</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation type="unfinished">&amp;Met aantal kopieën</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation type="unfinished">Aa&amp;ntal kopieën:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished">Ver&amp;schuif gemaakte items met </translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="unfinished">Maak &amp;tussenruimte tussen items van</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation type="unfinished">Rotatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="unfinished">Bij &amp;rijen &amp;&amp; kolommen</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation type="unfinished">Verticale tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation type="unfinished">Horizontale tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation type="unfinished">Aantal rijen:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation type="unfinished">Aantal kolommen:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicateBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Meervoudig dupliceren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;By Number of Copies</source>
        <translation type="obsolete">&amp;Met aantal kopieën</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Aa&amp;ntal kopieën:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="obsolete">Ver&amp;schuif gemaakte items met </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="obsolete">Maak &amp;tussenruimte tussen items van</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Horizontale verplaatsing:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Verticale verplaatsing:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="obsolete">Bij &amp;rijen &amp;&amp; kolommen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical Gap:</source>
        <translation type="obsolete">Verticale tussenruimte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal Gap:</source>
        <translation type="obsolete">Horizontale tussenruimte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Rows:</source>
        <translation type="obsolete">Aantal rijen:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Columns:</source>
        <translation type="obsolete">Aantal kolommen:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotation:</source>
        <translation type="obsolete">Rotatie:</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation>Mijn &amp;plug-in</translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation>Scribus - Mijn plug-in</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation>De plug-in werkt!</translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <location filename="../../scribus/newfile.cpp" line="100"/>
        <source>New Document</source>
        <translation>Nieuw document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="218"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="227"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orië&amp;ntatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="230"/>
        <source>Portrait</source>
        <translation>Staand</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="231"/>
        <source>Landscape</source>
        <translation>Liggend</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="237"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="243"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="259"/>
        <source>Margin Guides</source>
        <translation>Marge hulplijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="278"/>
        <source>Options</source>
        <translation>Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="291"/>
        <source>&amp;Default Unit:</source>
        <translation>Stan&amp;daard eenheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="301"/>
        <source>&amp;Automatic Text Frames</source>
        <translation>&amp;Automatische tekstframes</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="311"/>
        <source>&amp;Gap:</source>
        <translation>&amp;Tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="303"/>
        <source>Colu&amp;mns:</source>
        <translation>Kolo&amp;mmen:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="140"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation>Paginagrootte, standaard of aangepast</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="141"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation>Oriëntatie van de pagina&apos;s van dit document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="142"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Breedte van de pagina&apos;s in dit document, kies &apos;Aangepast&apos; om hier een waarde in te kunnen stellen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="143"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Hoogte van de pagina&apos;s in dit document, kies &apos;Aangepast&apos; om hier een waarde in te kunnen stellen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="145"/>
        <source>Default unit of measurement for document editing</source>
        <translation>Standaard meeteenheid voor het bewerken van dit document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="146"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation>Automatisch tekstframes aanmaken zodra nieuwe pagina&apos;s worden toegevoegd</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="147"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation>Aantal kolommen dat in automatisch aangemaakte tekstframes moet worden opgenomen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="148"/>
        <source>Distance between automatically created columns</source>
        <translation>Afstand tussen de automatisch aangemaakte kolommen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="126"/>
        <source>Do not show this dialog again</source>
        <translation>Toon dit venster niet opnieuw</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="144"/>
        <source>Initial number of pages of the document</source>
        <translation>Gewenst aantal pagina&apos;s voor het document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="285"/>
        <source>N&amp;umber of Pages:</source>
        <translation>&amp;Aantal pagina&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="356"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="110"/>
        <source>&amp;New Document</source>
        <translation>&amp;Nieuw document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="112"/>
        <source>Open &amp;Existing Document</source>
        <translation>Open B&amp;estaand document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="115"/>
        <source>Open Recent &amp;Document</source>
        <translation>Open recent &amp;document</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="175"/>
        <source>Document Layout</source>
        <translation>Document layout</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="250"/>
        <source>First Page is:</source>
        <translation>Eerste pagina is:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="323"/>
        <source>Show Document Settings After Creation</source>
        <translation>Toon document instelling na aanmaak</translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation>Nieuw &amp;van sjabloon...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation>Laad documenten met vooringestelde layout</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="81"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation>Begin een document vanuit een sjabloon gemaakt door anderen of uzelf.(zodat u meerdere documenten in dezelfde stijl kunt maken).</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="898"/>
        <source>Nodes</source>
        <translation>Knooppunten</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="901"/>
        <source>&amp;Absolute Coordinates</source>
        <translation>&amp;Absolute coördinaten</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="904"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-pos:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="905"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>Edit &amp;Contour Line</source>
        <translation>&amp;Contourlijn bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>&amp;Reset Contour Line</source>
        <translation>Contou&amp;rlijn opnieuw instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>&amp;End Editing</source>
        <translation>B&amp;ewerking beëindigen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Move Nodes</source>
        <translation>Knooppunten verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>Move Control Points</source>
        <translation>Controlepunten verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Add Nodes</source>
        <translation>Knooppunten toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Delete Nodes</source>
        <translation>Knooppunten verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>Move Control Points Independently</source>
        <translation>Controlepunten onafhankelijk verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Move Control Points Symmetrical</source>
        <translation>Controlepunten symmetrisch verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Reset Control Points</source>
        <translation>Controlepunten opnieuw instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Reset this Control Point</source>
        <translation>Dit controlepunt opnieuw instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation>Veelhoek starten of beziercurve knippen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Close this Bezier Curve</source>
        <translation>Deze beziercurve sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Mirror the Path Horizontally</source>
        <translation>Pad horizontaal spiegelen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Mirror the Path Vertically</source>
        <translation>Pad verticaal spiegelen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation>Pad horizontaal naar rechts scheeftrekken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation>Pad horizontaal naar links scheeftrekken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Shear the Path Vertically Up</source>
        <translation>Pad verticaal omhoog scheeftrekken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Shear the Path Vertically Down</source>
        <translation>Pad verticaal naar beneden scheeftrekken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation>Pad tegen de klok in roteren</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Rotate the Path Clockwise</source>
        <translation>Pad met de klok mee roteren</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation>Pad met getoonde % verkleinen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>Angle of Rotation</source>
        <translation>Rotatiehoek</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation>Contourlijnen bewerken</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation>Contourlijnen terugzetten naar oorspronkelijke framevorm</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="899"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="940"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation>Als aangevinkt; gebruik coordinaten gerelateerd aan de pagina, anders relatief aan het object.</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation>Verklein Pad met getoonde %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation>Verklein het formaat van het pad me de getoonde waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation>Vergroot het formaat van het pad met de getoonde waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>% to Enlarge or Shrink By</source>
        <translation>% te vergroten of te verkleinen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation>Waarde om te vergroten of te verkleinen</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>Set Contour to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="902"/>
        <source>to Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="297"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation>Dit bestand lijkt geen OpenOffice.org Draw bestand te zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="613"/>
        <source>Group%1</source>
        <translation>Groep%1</translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="96"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation>&amp;OpenOffice.org Draw importeren...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="111"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation>Importeer OpenOffice.org Draw bestanden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation>Importeert de meeste OpenOffice.org Draw bestanden in het huidige document, de vectordata omzettend in Scribus objecten.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="126"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenDocument 1.0 Draw</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="138"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenOffice.org 1.x Draw</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="208"/>
        <source>This file contains some unsupported features</source>
        <translation>Dit bestand bevat enkele niet ondersteunde functies</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="206"/>
        <source>The file could not be imported</source>
        <translation>Het bestand kan niet worden geïmporteerd</translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation>OpenDocument importeeropties</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation>Overschrijf alineastijlen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation>Hiermee worden bestaande stijlen in het huidige Scribus document overschreven</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation>Voeg alineastijlen samen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation>Voeg de alineastijl samen op basis van attributen. Dit resulteert in een minder aantal op elkaar lijkende alineastijlen, zelfs als de originele stijlen anders zijn genoemd.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation>Documentnaam als prefix voor alineastijlen gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation>Voeg documtennaam toe aan de alineastijlnaam in Scribus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation>Deze vraag niet meer stellen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation>Maak deze instellingen standaard, vraag niet opnieuw bij importeren van een OASIS OpenDocument.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation>Scribus document</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation>Scribus 1.2.x document</translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation>Oorsprong</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation>Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation>Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation>Lengte:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation>Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation>Hoek:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation>Waarden onthouden</translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="908"/>
        <source>Element</source>
        <translation type="unfinished">Element</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="287"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished">Naam &quot;%1&quot; is niet uniek.&lt;br/&gt;Kies een andere naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="876"/>
        <source>Group </source>
        <translation type="unfinished">Groep</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="751"/>
        <source>Page </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="806"/>
        <source>Free Objects</source>
        <translation type="unfinished">Vrije objecten</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="907"/>
        <source>Outline</source>
        <translation type="unfinished">Outline</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="140"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="909"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="141"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation>Lijndikte</translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="152"/>
        <source>Save as PDF</source>
        <translation>Opslaan als PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="65"/>
        <source>O&amp;utput to File:</source>
        <translation>&amp;Uitvoeren naar bestand:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="94"/>
        <source>Cha&amp;nge...</source>
        <translation>Wijzige&amp;n...</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="97"/>
        <source>Output one file for eac&amp;h page</source>
        <translation>Uitvoeren van &amp;een bestand per pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="110"/>
        <source>&amp;Save</source>
        <translation>Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save as</source>
        <translation type="obsolete">Opslaan als</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF-bestanden (*.pdf);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="122"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation>Hiermee wordt van elke pagina van het een afzonderlijk genummerd PDF bestand gemaakt. Dit is een bruikbare methode voor maken van plaatsbare PDF&apos;s voor commercieel drukwerk.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="123"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation>De Opslaan button wordt uitgeschakeld bij export naar PDF/X3 als de info string ontbreekt in de PDF/X3 tab.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="153"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation>%1 bestaat niet en wordt aangemaakt, doorgaan?</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="170"/>
        <source>Cannot create directory: 
%1</source>
        <translation>Kan map niet aanmaken:
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save As</source>
        <translation type="unfinished">Opslaan als</translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="135"/>
        <source>Saving PDF</source>
        <translation type="unfinished">Opslaan als PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Master Page:</source>
        <translation type="unfinished">Exporteer pagina sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="unfinished">Exporteer items op huidige pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2536"/>
        <source>Page:</source>
        <translation type="unfinished">Pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2549"/>
        <source>Date:</source>
        <translation type="unfinished">Datum:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7702"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7707"/>
        <source>Failed to write an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7712"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7717"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7697"/>
        <source>A write error occured, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation>PDF-gereedschappen</translation>
    </message>
</context>
<context>
    <name>PDFlib</name>
    <message>
        <location filename="../pdflib.cpp" line="119"/>
        <source>Saving PDF</source>
        <translation type="obsolete">Opslaan als PDF</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="obsolete">Exporteer items op huidige pagina:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Master Page:</source>
        <translation type="obsolete">Exporteer pagina sjabloon:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Page:</source>
        <translation type="obsolete">Exporteer pagina:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="2275"/>
        <source>Page:</source>
        <translation type="obsolete">Pagina:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="2288"/>
        <source>Date:</source>
        <translation type="obsolete">Datum:</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../scribus/preview.cpp" line="81"/>
        <source>Print Preview</source>
        <translation>Afdrukvoorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="133"/>
        <source>Display Trans&amp;parency</source>
        <translation>Trans&amp;parantie weergeven</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="248"/>
        <source>&amp;Under Color Removal</source>
        <translation>Onderliggende kle&amp;uren verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="138"/>
        <source>&amp;Display CMYK</source>
        <translation>CMYK &amp;weergeven</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="206"/>
        <source>&amp;C</source>
        <translation>&amp;C</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="211"/>
        <source>&amp;M</source>
        <translation>&amp;M</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="216"/>
        <source>&amp;Y</source>
        <translation>&amp;Y</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="221"/>
        <source>&amp;K</source>
        <translation>&amp;K</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="326"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation>Toont doorschijnende elementen in uw document. Ghostscript 7.07 of hoger is hiervoor vereist</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="327"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation>Geeft een afdrukvoorbeeld weer met simulaties van CMYK-inkten, inplaats van RGB-kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="350"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation>Schakelt de C (Cyaan) inktplaat in of uit</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="351"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation>Schakelt de M (Magenta) inktplaat in of uit</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="352"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation>Schakelt de Y (Yellow = geel) inktplaat in of uit</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="353"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation>Schakelt de K (Black = zwart) inktplaat in of uit</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="619"/>
        <source>All</source>
        <translation>Alles</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="150"/>
        <source>Separation Name</source>
        <translation>Scheidingsnaam</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="162"/>
        <source>Cyan</source>
        <translation>Cyaan</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="169"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="176"/>
        <source>Yellow</source>
        <translation>Geel</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="183"/>
        <source>Black</source>
        <translation>Zwart</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="269"/>
        <source>Scaling:</source>
        <translation>Schalen:</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="297"/>
        <source>Print...</source>
        <translation>Afdrukken...</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="328"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation>Een manier om uit cyaan, geel en magenta samengestelde tonen door zwarte tonen te vervangen. UCR heeft het meeste effect op delen van afbeeldingen met neutrale of grijsachtige tonen. Gebruik hiervan kan afdrukken van bepaalde afbeeldingen verbeteren. UCR reduceert de mogelijkheid van oververzadiging met CMY inkten. </translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="329"/>
        <source>Resize the scale of the page.</source>
        <translation>Pas afdrukformaat aan.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="294"/>
        <source>Close</source>
        <translation>Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="1106"/>
        <source>File</source>
        <translation>Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="128"/>
        <source>Enable &amp;Antialiasing</source>
        <translation>&amp;Antialiasing toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="122"/>
        <source>Display Settings</source>
        <translation>Scherminstellingen</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="230"/>
        <source>Print Settings</source>
        <translation>Printer instellingen</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="236"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation>Spiegel pagina(&apos;s) horizontaal</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="239"/>
        <source>Mirror Page(s) Vertical</source>
        <translation>Spiegel pagina(&apos;s) verticaal</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Afsnijden bij paginarand</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="245"/>
        <source>Print in Grayscale</source>
        <translation>Druk af in grijstinten</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="252"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Overprint modus forceren</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="251"/>
        <source>Convert Spot Colors</source>
        <translation>Steunkleuren omzetten</translation>
    </message>
    <message>
        <location filename="../preview.cpp" line="255"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">ICC-profielen toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="281"/>
        <source>Fit to Width</source>
        <translation>Aanpassen aan breedte</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="282"/>
        <source>Fit to Height</source>
        <translation>Aanpassen aan hoogte</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="283"/>
        <source>Fit to Page</source>
        <translation>Aanpassen aan pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="325"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation>Geeft een verbeterd beeld van Type 1 Fonts, TrueType Fonts, OpenType Fonts, EPS, PDF en vectorafbeeldingen in een preview. Ten koste van licht snelheidsverlies in de weergave</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="330"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation>Steunkleuren worden omgezet naar composiet-kleuren. Bij voorkeur aanvinken. Tenzij steunkleuren in een drukkerij gedrukt moeten worden.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="335"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Inschakelen globale Overprint modus voor dit document, object instellingen worden genegeerd</translation>
    </message>
    <message>
        <location filename="../preview.cpp" line="326"/>
        <source>Allows you to embed ICC profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Staat toe ICC-profielen in te sluiten als kleurbeheer ingeschakeld is</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="254"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="331"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Processing Master Page:</source>
        <translation>Bewerk pagina sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Exporting Page:</source>
        <translation>Exporteren pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1726"/>
        <source>Failed to write data for an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1731"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1736"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1741"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PStyleW</name>
    <message>
        <location filename="../smpstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Form1</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="26"/>
        <source>Properties</source>
        <translation type="obsolete">Eigenschappen</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="46"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en inspringing</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="104"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Afstanden en uitlijning</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="130"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Beginkapitaal</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="146"/>
        <source>Parent&apos;s Drop Cap Status</source>
        <translation type="obsolete">Beginkapitaal status van Parent</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="190"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">L&amp;etterteken stijl</translation>
    </message>
</context>
<context>
    <name>PStyleWBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Form1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Properties</source>
        <translation type="obsolete">Eigenschappen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en inspringing</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Parent</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Afstanden en uitlijning</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Beginkapitaal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent&apos;s Drop Cap Status</source>
        <translation type="obsolete">Beginkapitaal status van Parent</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">L&amp;etterteken stijl</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="388"/>
        <source>Image</source>
        <translation>Afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="392"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="396"/>
        <source>Line</source>
        <translation>Lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="400"/>
        <source>Polygon</source>
        <translation>Polygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="404"/>
        <source>Polyline</source>
        <translation>Polylijn</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="408"/>
        <source>PathText</source>
        <translation>Tekstpad</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="3612"/>
        <source>Copy of</source>
        <translation>Kopie van</translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation>Relatie tot</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation>Is Parent van</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation>Is kind van</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../pageitemattributes.ui" line="13"/>
        <source>Page Item Attributes</source>
        <translation type="obsolete">Pagina item attributen</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">W&amp;issen</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation type="unfinished">Type</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation type="unfinished">Waarde</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation type="unfinished">Parameter</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation type="unfinished">Relatie</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation type="unfinished">Relatie tot</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation type="unfinished">Attributen</translation>
    </message>
</context>
<context>
    <name>PageItemAttributesBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Item Attributes</source>
        <translation type="obsolete">Pagina item attributen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Type</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value</source>
        <translation type="obsolete">Waarde</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parameter</source>
        <translation type="obsolete">Parameter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship</source>
        <translation type="obsolete">Relatie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship To</source>
        <translation type="obsolete">Relatie tot</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoegen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+K</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">W&amp;issen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Annuleren</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <location filename="../pageitem_imageframe.cpp" line="244"/>
        <source>Picture</source>
        <translation type="obsolete">Afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="394"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="463"/>
        <source>Image</source>
        <translation type="unfinished">Afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="469"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="472"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="473"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="104"/>
        <source>Size:</source>
        <translation type="unfinished">Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="474"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Kleurruimte: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="478"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="485"/>
        <source>Page:</source>
        <translation type="unfinished">Pagina:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="487"/>
        <source>Pages:</source>
        <translation type="unfinished">Pagina&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="496"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="501"/>
        <source>No Image Loaded</source>
        <translation type="unfinished">Geen afbeelding geladen</translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="564"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Running the external application failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="239"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="248"/>
        <source>Information</source>
        <translation type="obsolete">Informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="415"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../pageitem_latexframe.cpp" line="647"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="569"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="405"/>
        <source>The application &quot;%1&quot; failed to start!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="409"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="558"/>
        <source>Application</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="559"/>
        <source>DPI</source>
        <translation type="unfinished">DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="561"/>
        <source>State</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="566"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="260"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="557"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="224"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="421"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="319"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Alinea&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="327"/>
        <source>Lines: </source>
        <translation type="unfinished">Lijnen: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="333"/>
        <source>Words: </source>
        <translation type="unfinished">Woorden:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="341"/>
        <source>Chars: </source>
        <translation type="unfinished">Tekens:</translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3422"/>
        <source>Linked Text</source>
        <translation type="unfinished">Gekoppelde tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3424"/>
        <source>Text Frame</source>
        <translation type="unfinished">Tekstframe</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3428"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Alinea&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3436"/>
        <source>Lines: </source>
        <translation type="unfinished">Lijnen: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3442"/>
        <source>Words: </source>
        <translation type="unfinished">Woorden:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3450"/>
        <source>Chars: </source>
        <translation type="unfinished">Tekens:</translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation>Eerste pagina is:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation>Document layout</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <location filename="../pagepalette.cpp" line="533"/>
        <source>Double sided</source>
        <translation type="obsolete">Dubbelzijdig</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="541"/>
        <source>Middle Right</source>
        <translation type="obsolete">Midden rechts</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="573"/>
        <source>Drag pages or master pages onto the trashbin to delete them</source>
        <translation type="obsolete">Sleep pagina&apos;s of pagina sjablonen in de prullenbak om ze te verwijderen</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="574"/>
        <source>Here are all your master pages. To create a new page, drag a master page to the page view below</source>
        <translation type="obsolete">Hier zijn al uw pagina sjablonen. Om een nieuwe pagina aan te maken, sleep een pagina sjabloon naar pagina hieronder</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="933"/>
        <source>Arrange Pages</source>
        <translation>Rangschik pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="934"/>
        <source>Available Master Pages:</source>
        <translation>Beschikbare pagina sjablonen:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="935"/>
        <source>Document Pages:</source>
        <translation>Documentpagina&apos;s:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="938"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="939"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="937"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="628"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="632"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished">Wilt u dit pagina sjabloon werkelijk verwijderen?</translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="266"/>
        <source>%1 of %2</source>
        <translation>%1 van %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 of %1</source>
        <translation type="obsolete">%1 van %1</translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation>Geen stijl</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect first Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>with:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>PathDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="13"/>
        <source>Boolean Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="97"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="195"/>
        <source>=</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="274"/>
        <source>Operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="357"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="381"/>
        <source>Swap Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="386"/>
        <source>Options</source>
        <translation type="obsolete">Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="41"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="139"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="234"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="286"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="321"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="337"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="353"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="462"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="488"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="158"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="161"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="305"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="378"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="418"/>
        <source>Result takes color from:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="424"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="427"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="437"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="440"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="447"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="478"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Lijnkleur</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="498"/>
        <source>Fill Color</source>
        <translation type="unfinished">Vulkleur</translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="74"/>
        <source>Path Operations...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="78"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="103"/>
        <source>Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="104"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="95"/>
        <source>Create Path from Stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="74"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="134"/>
        <source>Choose a Directory</source>
        <translation>Kies een map</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="162"/>
        <source>Loading Patterns</source>
        <translation>Patronen laden</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="296"/>
        <source>All Files (*)</source>
        <translation>Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="310"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="14"/>
        <source>Patterns</source>
        <translation type="unfinished">Patronen</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="56"/>
        <source>Load</source>
        <translation type="unfinished">Laden</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="63"/>
        <source>Load Set</source>
        <translation type="unfinished">Set laden</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="77"/>
        <source>Remove</source>
        <translation type="unfinished">Verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="84"/>
        <source>Remove All</source>
        <translation type="unfinished">Alle verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="107"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="114"/>
        <source>Cancel</source>
        <translation type="unfinished">Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="213"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Alle ondersteunde formaten</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="70"/>
        <source>Rename</source>
        <translation type="unfinished">Hernoemen</translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation type="unfinished">Grootte:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation type="unfinished">Resolutie:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation type="unfinished">DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="118"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="121"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="127"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotoon</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Kleurruimte: </translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation type="unfinished">Resultaat</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation type="unfinished">Zoekresultaten voor: </translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation type="unfinished">&amp;Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation type="unfinished">&amp;Selecteer</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation type="unfinished">Annuleren</translation>
    </message>
</context>
<context>
    <name>PicSearchBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Result</source>
        <translation type="obsolete">Resultaat</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Results for: </source>
        <translation type="obsolete">Zoekresultaten voor: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Voorbeeld</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select</source>
        <translation type="obsolete">&amp;Selecteer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="51"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="unfinished">Bij inschakelen wordt het bestandssysyteem doorzocht op case-ongevoelige bestandsnamen. Dit is niet standaard in de meeste operating systems met uitzondering van MS Winsows</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="58"/>
        <source>Cancel Search</source>
        <translation type="unfinished">Annuleer zoekopdracht</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="124"/>
        <source>Start Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="91"/>
        <source>Select a base directory for search</source>
        <translation type="unfinished">Selecteer een te doorzoeken map</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished">Scribus - Afbeelding zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>The search failed: %1</source>
        <translation type="unfinished">De zoekopdracht is mislukt: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation type="unfinished">Zoeken naar:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation type="unfinished">Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation type="unfinished">Niet hoofdlettergevoelig zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="103"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Path</source>
        <translation type="obsolete">Lokatie</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page</source>
        <translation type="obsolete">Pagina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print</source>
        <translation type="obsolete">Afdrukken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Status</source>
        <translation type="obsolete">Status</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="575"/>
        <source>Goto</source>
        <translation type="obsolete">Ga naar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Missing</source>
        <translation type="obsolete">Ontbrekend</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search</source>
        <translation type="obsolete">Zoeken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancel Search</source>
        <translation type="obsolete">Annuleer zoekopdracht</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="16"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Afbeelingen beheren</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>Scribus - Image Search</source>
        <translation>Scribus - Afbeelding zoeken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The search failed: %1</source>
        <translation type="obsolete">De zoekopdracht is mislukt: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation>Geen afbeelding genaamd &quot;%1&quot; werd gevonden.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for search</source>
        <translation type="obsolete">Selecteer een te doorzoeken map</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Case insensitive search</source>
        <translation type="obsolete">Niet hoofdlettergevoelig zoeken</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show thumbnails</source>
        <translation type="obsolete">Toon miniaturen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Directory</source>
        <translation type="obsolete">Zoek map</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation>Sluiten</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set a new location for the selected items. Useful when you may have moved the document but not the images.</source>
        <translation type="obsolete">Stel nieuwe locatie in voor geselecteerde items. Handig als het document is verplaatst maar niet de afbeeldingen.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show/hide image thumbnails</source>
        <translation type="obsolete">Toon/verberg miniaturen afbeeldingen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="obsolete">Bij inschakelen wordt het bestandssysyteem doorzocht op case-ongevoelige bestandsnamen. Dit is niet standaard in de meeste operating systems met uitzondering van MS Winsows</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for your selected rows</source>
        <translation type="obsolete">Selecteer een basis map voor de geselecteerde rijen</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="253"/>
        <source>Not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="278"/>
        <source>JPG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="281"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="284"/>
        <source>PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="287"/>
        <source>EPS/PS</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="290"/>
        <source>PDF</source>
        <translation type="unfinished">PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="293"/>
        <source>JPG2000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="299"/>
        <source>emb. PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="305"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="194"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="197"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="203"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotoon</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="322"/>
        <source>n/a</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation type="unfinished">Informatie</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation type="unfinished">Naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation type="unfinished">Afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation type="unfinished">Formaat:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Kleurruimte: </translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation type="unfinished">Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation type="unfinished">Schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation type="unfinished">Afbeelding bewerken ...</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="264"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="59"/>
        <source>Save as &amp;Image...</source>
        <translation>Opslaan als &amp;afbeelding...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="78"/>
        <source>Export As Image</source>
        <translation>Exporteren als afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="79"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation>Exporteer geselecteerde pagina&apos;s als bitmap afbeeldingen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="123"/>
        <source>Save as Image</source>
        <translation type="unfinished">Opslaan als afbeelding</translation>
    </message>
    <message>
        <location filename="../plugins/pixmapexport/export.cpp" line="130"/>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Fout tijdens het schrijven naar uitvoerbestand(en).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="145"/>
        <source>Export successful</source>
        <translation>Export geslaagd</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="118"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="124"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="72"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation>Kan plug-in niet vinden</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="61"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation>onbekende fout</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="97"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation>Kan symbool (%1) niet vinden</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="157"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation>Plug-in: laadt %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="261"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation>init mislukt</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="267"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation>onbekend plug-in type</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="271"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 geladen</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="275"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 kan %2 niet laden</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="228"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation>Er is en probleem met het laden van %1 of %2 plugins. %3 Dit kan worden veroorzaakt door ontbreken van een afhankelijkheid of een oude plugin in de installatie map. Als de oude installatie map is leeggemaakt en de fout blijft optreden, rapporteer dit dan op bugs.scribus.net.</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="341"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation>Pluginin: %1 initialisering ok </translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="343"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 post initialisatie mislukt</translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="19"/>
        <source>Plugin Manager</source>
        <translation>Plug-in beheerder</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="35"/>
        <source>Plugin</source>
        <translation>Plug-in</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="40"/>
        <source>How to run</source>
        <translation>Hoe te starten</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="45"/>
        <source>Type</source>
        <translation>Type</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="50"/>
        <source>Load it?</source>
        <translation>Laden?</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="55"/>
        <source>Plugin ID</source>
        <translation>Plug-in ID</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="60"/>
        <source>File</source>
        <translation>Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="68"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation>Het programma dient opnieuw te worden opgestart om de verandering toe te passen.</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="13"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation>Polygoon-eigenschappen</translation>
    </message>
</context>
<context>
    <name>PolygonWidget</name>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="55"/>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">Ho&amp;eken:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="75"/>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="91"/>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">&amp;Factor toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="106"/>
        <source> %</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="110"/>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Factor:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="140"/>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Aantal hoeken voor polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="142"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Rotatiegraden voor polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Convex/concaaf-factor toepassen op de vorm van polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="144"/>
        <source>Sample Polygon</source>
        <translation type="obsolete">Voobeeldpolygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="146"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="obsolete">Een negatieve waarde zal de polygoon concaaf (of stervormig) maken, een positieve waarde zal het convex maken</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished">Ho&amp;eken:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished">Aantal hoeken voor polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished">&amp;Rotatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished">Rotatiegraden voor polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished">Voobeeldpolygoon</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished">Convex/concaaf-factor toepassen op de vorm van polygonen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished">&amp;Factor toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished">&amp;Factor:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished">Een negatieve waarde zal de polygoon concaaf (of stervormig) maken, een positieve waarde zal het convex maken</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="../../scribus/prefs.cpp" line="72"/>
        <source>Preferences</source>
        <translation>Voorkeuren</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="75"/>
        <source>General</source>
        <translation>Algemeen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="78"/>
        <source>Document</source>
        <translation>Document</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="81"/>
        <source>Guides</source>
        <translation>Hulplijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="84"/>
        <source>Typography</source>
        <translation>Typografie</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="87"/>
        <source>Tools</source>
        <translation>Gereedschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="138"/>
        <source>Display</source>
        <translation>Tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="141"/>
        <source>External Tools</source>
        <translation>Externe hulpprogramma&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="90"/>
        <source>Hyphenator</source>
        <translation>Afbreekfunctie</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="93"/>
        <source>Fonts</source>
        <translation>Fonts</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="104"/>
        <source>Color Management</source>
        <translation>Kleurbeheer</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="119"/>
        <source>PDF Export</source>
        <translation>PDF Exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="132"/>
        <source>Keyboard Shortcuts</source>
        <translation>Toetsenbord sneltoetssets</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="148"/>
        <source>Plugins</source>
        <translation>Plug-ins</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="99"/>
        <source>Preflight Verifier</source>
        <translation>Preflight controle</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="124"/>
        <source>Document Item Attributes</source>
        <translation>Document Item attributen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="129"/>
        <source>Table of Contents and Indexes</source>
        <translation>Inhoudsopgave en indices</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="144"/>
        <source>Miscellaneous</source>
        <translation>Diversen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="96"/>
        <source>Printer</source>
        <translation>Printer</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="135"/>
        <source>Scrapbook</source>
        <translation>Kladblok</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="191"/>
        <source>&amp;Defaults</source>
        <translation>Stan&amp;daard</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="200"/>
        <source>Save Preferences</source>
        <translation>Voorkeuren opslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="190"/>
        <source>Export...</source>
        <translation>Exporteren...</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="192"/>
        <source>&amp;Apply</source>
        <translation>Toe&amp;passen</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="193"/>
        <source>All preferences can be reset here</source>
        <translation>Alle voorkeuren kunnen hier worden hersteld</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="194"/>
        <source>Apply all changes without closing the dialog</source>
        <translation>Alle veranderingen toepassen zonder dialoog te sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="195"/>
        <source>Export current preferences into file</source>
        <translation>Exporteer huidige voorkeuren naar bestand</translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>Postscript</source>
        <translation>Postscript</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="809"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation>Migreer oude instellingen van Scribus?</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="811"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation>Scribus heeft bestaande Scribus 1.2 voorkeurbestanden gedetecteerd.
Wilt u deze migreren naar de nieuwe Scribus versie?</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>PostScript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1684"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation>Kan voorkeurbestand &quot;%1&quot; niet openen om te schrijven: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1696"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation>Schrijft naar voorkeurbestand &quot;%1&quot; mislukt: QIODevice status code %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1710"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation>Openen van voorkeurbestand &quot;%1&quot; mislukt: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1720"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation>Lezen van voorkeur XML &quot;%1&quot; mislukt: %2 op regel %3, col %4</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2099"/>
        <source>PDF 1.3</source>
        <translation type="obsolete">PDF 1.3</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2101"/>
        <source>PDF 1.4</source>
        <translation type="obsolete">PDF 1.4</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2106"/>
        <source>PDF/X-3</source>
        <translation type="obsolete">PDF/X-3</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2393"/>
        <source>Error Writing Preferences</source>
        <translation>Schrijffout voorkeuren</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2399"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation>Scribus was niet in staat om de voorkeuren op te slaan:&lt;br&gt;%1&lt;br&gt;Controleer bestands- en maprechten en beschikbare schrijfruimte.</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2412"/>
        <source>Error Loading Preferences</source>
        <translation>Laadfout voorkeuren</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2417"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation>Scribus was niet in staat om de voorkeuren te laden: &lt;br&gt;%1&lt;br&gt;Standaard instellingen worden geladen.</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2102"/>
        <source>PDF 1.5</source>
        <translation type="obsolete">PDF 1.5</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2125"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="555"/>
        <source>Magazine</source>
        <translation>Magazine</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="556"/>
        <source>Fibonacci</source>
        <translation>Fibonacci</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="557"/>
        <source>Golden Mean</source>
        <translation>Gulden snede</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="558"/>
        <source>Nine Parts</source>
        <translation>Negen Delen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="554"/>
        <source>Gutenberg</source>
        <translation>Gutenberg</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="553"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="490"/>
        <source>You can select a predefined page layout here. &apos;None&apos; leave margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins for same value. Leading is Left/Inside value.</source>
        <translation type="obsolete">U kunt hier een vooringestelde paginalayout selecteren. &apos;None&apos;&apos; laat de marges ongewijzigd. Gutenberg stelt marges in op de klassieke wijze. &apos;Magazine&apos; stelt alle marges in op dezelfde waarde. Leidend is Links/Binnen waarde.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="561"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <location filename="../printdialog.cpp" line="67"/>
        <source>Setup Printer</source>
        <translation type="obsolete">Printer instellen</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="74"/>
        <source>Print Destination</source>
        <translation type="obsolete">Afdrukken naar</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="563"/>
        <source>File</source>
        <translation>Bestand</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="89"/>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Opties...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="100"/>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Bestand:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="106"/>
        <source>C&amp;hange...</source>
        <translation type="obsolete">&amp;Wijzigen...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="113"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">A&amp;lternatieve printer opdracht</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="122"/>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">Co&amp;mmando:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="130"/>
        <source>Range</source>
        <translation type="obsolete">Bereik</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="135"/>
        <source>Print &amp;All</source>
        <translation type="obsolete">&amp;Alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="373"/>
        <source>Print Current Pa&amp;ge</source>
        <translation>Huidige pa&amp;gina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="139"/>
        <source>Print &amp;Range</source>
        <translation type="obsolete">Be&amp;reik</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="378"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Voer hier de paginanummer(s) in die u wilt afdrukken,
bijvoorbeeld 1,3,5 of 1-5 (pag. 1 t/m 5 afdrukken).
Een * staat voor alle pagina&apos;s.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="159"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">Aantal &amp;kopieën:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="190"/>
        <source>Options</source>
        <translation type="obsolete">Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="507"/>
        <source>All</source>
        <translation>Alles</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="506"/>
        <source>Cyan</source>
        <translation>Cyaan</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="505"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="504"/>
        <source>Yellow</source>
        <translation>Geel</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="503"/>
        <source>Black</source>
        <translation>Zwart</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="308"/>
        <source>&amp;Print</source>
        <translation type="obsolete">Afdru&amp;kken</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save as</source>
        <translation type="obsolete">Opslaan als</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="334"/>
        <source>Print Normal</source>
        <translation>Druk Normaal af</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="172"/>
        <source>Print Separations</source>
        <translation type="obsolete">Druk Separaties</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="176"/>
        <source>Print in Color if Available</source>
        <translation type="obsolete">Druk bij beschikbaarheid in kleur af</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="177"/>
        <source>Print in Grayscale</source>
        <translation type="obsolete">Druk in grijstinten af</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="221"/>
        <source>PostScript Level 1</source>
        <translation type="obsolete">PostScript Level 1</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="222"/>
        <source>PostScript Level 2</source>
        <translation type="obsolete">PostScript Level 2</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>PostScript Level 3</source>
        <translation type="obsolete">PostScript Level 3</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="196"/>
        <source>Page</source>
        <translation type="obsolete">Pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="202"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="obsolete">Spiegel pagina(&apos;s) horizontaal</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="205"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="obsolete">Spiegel pagina(&apos;s) verticaal</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="208"/>
        <source>Set Media Size</source>
        <translation type="obsolete">Papierformaat instellen</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="214"/>
        <source>Color</source>
        <translation type="obsolete">Kleur</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="220"/>
        <source>Apply Under Color Removal</source>
        <translation type="obsolete">Onderliggende kleurvlakken verwijderen</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="obsolete">Steunkleuren naar Process kleuren omzetten</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="263"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">ICC-profielen toepassen</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="232"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Geavanceerde opties</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="303"/>
        <source>Preview...</source>
        <translation type="obsolete">Voorbeeld...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="380"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="obsolete">Stelt het PostScript Level in.
Instellen op Level 1 of 2 kan leiden tot grote bestanden</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation>Postscript bestanden (*.ps);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="379"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="obsolete">Gebruik een alternatieve print manager, bijvoorbeeld kprinter of gtklp, voor additionele opties</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="381"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Een manier om uit cyaan, geel en magenta samengestelde tonen door zwarte tonen te vervangen. UCR heeft het meeste effect op delen van afbeeldingen met neutrale of grijsachtige tonen. Gebruik hiervan kan afdrukken van bepaalde afbeeldingen verbeteren. UCR reduceert de mogelijkheid van oververzadiging met CMY inkten.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="382"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Steunkleuren worden omgezet naar composiet-kleuren. Bij voorkeur aanvinken. Tenzij steunkleuren in een drukkerij gedrukt moeten worden.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="383"/>
        <source>Allows you to embed ICC profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Staat toe ICC-profielen te embedden in de printstroom als kleurbeheer ingeschakeld is</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="385"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Geef hiermee het papierformaat in het PostScript bestand aan. Wordt niet aanbevolen tenzij de drukker hier uitdrukkelijk om vraagt.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="210"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Afsnijden bij paginarand</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="309"/>
        <source>Failed to retrieve printer settings</source>
        <translation>Ontvangen printerinstellingen niet gelukt</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="375"/>
        <source>Do not show objects outside the margins on the printed page</source>
        <translation type="obsolete">Verberg objecten buiten de marges van de pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="226"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Overprint modus forceren</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="239"/>
        <source>Printer Marks</source>
        <translation type="obsolete">Merktekens</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="244"/>
        <source>Crop Marks</source>
        <translation type="obsolete">Snijtekens</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="246"/>
        <source>Bleed Marks</source>
        <translation type="obsolete">Afloop merktekens</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="248"/>
        <source>Registration Marks</source>
        <translation type="obsolete">Registratietekens</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="250"/>
        <source>Color Bars</source>
        <translation type="obsolete">Kleurcontrole balk</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="253"/>
        <source>Offset:</source>
        <translation type="obsolete">Verschuiving:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="258"/>
        <source>Marks</source>
        <translation type="obsolete">Merktekens</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="265"/>
        <source>Bleed Settings</source>
        <translation type="obsolete">Instelling afloop</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="271"/>
        <source>Top:</source>
        <translation type="obsolete">Boven:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="276"/>
        <source>Bottom:</source>
        <translation type="obsolete">Onder:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="281"/>
        <source>Left:</source>
        <translation type="obsolete">Links:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="286"/>
        <source>Right:</source>
        <translation type="obsolete">Rechts:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="290"/>
        <source>Use Document Bleeds</source>
        <translation type="obsolete">Gebruik document afloop</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="294"/>
        <source>Bleeds</source>
        <translation type="obsolete">Afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="103"/>
        <source>Inside:</source>
        <translation>Binnenzijde:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="104"/>
        <source>Outside:</source>
        <translation>Buitenzijde:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="391"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Afstand voor afloop vanaf de bovenkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="392"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Afstand voor afloop vanaf de onderkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="393"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Afstand voor afloop vanaf de linkerkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="394"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Afstand voor afloop vanaf de rechterkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="383"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Inschakelen globale Overprint modus, object instellingen worden genegeerd</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save As</source>
        <translation type="unfinished">Opslaan als</translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="13"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Printer instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="22"/>
        <source>Print Destination</source>
        <translation type="unfinished">Afdrukken naar</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="49"/>
        <source>&amp;Options...</source>
        <translation type="unfinished">&amp;Opties...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="85"/>
        <source>&amp;File:</source>
        <translation type="unfinished">&amp;Bestand:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="101"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished">&amp;Wijzigen...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="116"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished">Gebruik een alternatieve print manager, bijvoorbeeld kprinter of gtklp, voor additionele opties</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="119"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished">A&amp;lternatieve printer opdracht</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="137"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished">Co&amp;mmando:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="159"/>
        <source>Range</source>
        <translation type="unfinished">Bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="171"/>
        <source>Print &amp;All</source>
        <translation type="unfinished">&amp;Alle pagina&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="191"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished">Aantal &amp;kopieën:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="211"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished">Huidige pa&amp;gina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="218"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished">Be&amp;reik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="228"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="273"/>
        <source>Options</source>
        <translation type="unfinished">Opties</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="280"/>
        <source>Print Normal</source>
        <translation type="unfinished">Druk Normaal af</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="285"/>
        <source>Print Separations</source>
        <translation type="unfinished">Druk Separaties</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="294"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="299"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="314"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished">Stelt het PostScript Level in.
Instellen op Level 1 of 2 kan leiden tot grote bestanden</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="334"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Geavanceerde opties</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="340"/>
        <source>Page</source>
        <translation type="unfinished">Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="346"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished">Spiegel pagina(&apos;s) horizontaal</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="353"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished">Spiegel pagina(&apos;s) verticaal</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Geef hiermee het papierformaat in het PostScript bestand aan. Wordt niet aanbevolen tenzij de drukker hier uitdrukkelijk om vraagt.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="363"/>
        <source>Set Media Size</source>
        <translation type="unfinished">Papierformaat instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Afsnijden bij paginarand</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="380"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Een manier om uit cyaan, geel en magenta samengestelde tonen door zwarte tonen te vervangen. UCR heeft het meeste effect op delen van afbeeldingen met neutrale of grijsachtige tonen. Gebruik hiervan kan afdrukken van bepaalde afbeeldingen verbeteren. UCR reduceert de mogelijkheid van oververzadiging met CMY inkten.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="389"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished">Onderliggende kleurvlakken verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="396"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished">Steunkleuren worden omgezet naar composiet-kleuren. Bij voorkeur aanvinken. Tenzij steunkleuren in een drukkerij gedrukt moeten worden.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="399"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished">Steunkleuren naar Process kleuren omzetten</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="419"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Overprint modus forceren</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="406"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="409"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="436"/>
        <source>Marks</source>
        <translation type="unfinished">Merktekens</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="442"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="445"/>
        <source>Crop Marks</source>
        <translation type="unfinished">Snijtekens</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="452"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="455"/>
        <source>Registration Marks</source>
        <translation type="unfinished">Registratietekens</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="462"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="465"/>
        <source>Bleed Marks</source>
        <translation type="unfinished">Afloop merktekens</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="472"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="475"/>
        <source>Color Bars</source>
        <translation type="unfinished">Kleurcontrole balk</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="484"/>
        <source>Offset:</source>
        <translation type="unfinished">Verschuiving:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="491"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="514"/>
        <source>Bleeds</source>
        <translation type="unfinished">Afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="520"/>
        <source>Top:</source>
        <translation type="unfinished">Boven:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="527"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Afstand voor afloop vanaf de bovenkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="534"/>
        <source>Left:</source>
        <translation type="unfinished">Links:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="541"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Afstand voor afloop vanaf de rechterkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="548"/>
        <source>Bottom:</source>
        <translation type="unfinished">Onder:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="555"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Afstand voor afloop vanaf de onderkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="562"/>
        <source>Right:</source>
        <translation type="unfinished">Rechts:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="569"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Afstand voor afloop vanaf de linkerkant van de fysieke pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="576"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="579"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished">Gebruik document afloop</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="605"/>
        <source>Preview...</source>
        <translation type="unfinished">Voorbeeld...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="615"/>
        <source>&amp;Print</source>
        <translation type="unfinished">Afdru&amp;kken</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="625"/>
        <source>Cancel</source>
        <translation type="unfinished">Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="322"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="326"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished">Een manier om uit cyaan, geel en magenta samengestelde tonen door zwarte tonen te vervangen. UCR heeft het meeste effect op delen van afbeeldingen met neutrale of grijsachtige tonen. Gebruik hiervan kan afdrukken van bepaalde afbeeldingen verbeteren. UCR reduceert de mogelijkheid van oververzadiging met CMY inkten. </translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4890"/>
        <source>Properties</source>
        <translation>Eigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4892"/>
        <source>X, Y, &amp;Z</source>
        <translation>X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4895"/>
        <source>&amp;Shape</source>
        <translation>&amp;Vorm</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4893"/>
        <source>&amp;Text</source>
        <translation>&amp;Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4894"/>
        <source>&amp;Image</source>
        <translation>Afbeeld&amp;ing</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4896"/>
        <source>&amp;Line</source>
        <translation>&amp;Lijn</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4897"/>
        <source>&amp;Colors</source>
        <translation>&amp;Kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4900"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4901"/>
        <source>Geometry</source>
        <translation>Geometrie</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5093"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5005"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-pos:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5006"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4904"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4905"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4906"/>
        <source>&amp;Rotation:</source>
        <translation>&amp;Rotatie:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4907"/>
        <source>Basepoint:</source>
        <translation>Basispunt:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4908"/>
        <source>Level</source>
        <translation>Niveau</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4914"/>
        <source>Shape:</source>
        <translation>Vorm:</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4341"/>
        <source>&amp;Edit Shape...</source>
        <translation type="obsolete">Vorm b&amp;ewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4934"/>
        <source>R&amp;ound
Corners:</source>
        <translation>R&amp;onde
hoeken:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Distance of Text</source>
        <translation type="obsolete">Afstand tot tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4935"/>
        <source>Colu&amp;mns:</source>
        <translation>Kolo&amp;mmen:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4942"/>
        <source>To&amp;p:</source>
        <translation>&amp;Boven:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4943"/>
        <source>&amp;Bottom:</source>
        <translation>On&amp;der:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4944"/>
        <source>&amp;Left:</source>
        <translation>&amp;Links:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4945"/>
        <source>&amp;Right:</source>
        <translation>&amp;Rechts:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4946"/>
        <source>T&amp;abulators...</source>
        <translation>T&amp;abulators...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5000"/>
        <source>Path Text Properties</source>
        <translation>Tekstpad-eigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4953"/>
        <source>Show Curve</source>
        <translation>Curve weergeven</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4955"/>
        <source>Start Offset:</source>
        <translation>Beginafstand:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4956"/>
        <source>Distance from Curve:</source>
        <translation>Afstand van curve:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4969"/>
        <source>Use &amp;Bounding Box</source>
        <translation>&amp;Bounding Box gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4970"/>
        <source>&amp;Use Contour Line</source>
        <translation>Contourlijn gebr&amp;uiken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5079"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5002"/>
        <source>&amp;Free Scaling</source>
        <translation>&amp;Vrije schaal</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5007"/>
        <source>X-Sc&amp;ale:</source>
        <translation>&amp;X-schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5008"/>
        <source>Y-Scal&amp;e:</source>
        <translation>&amp;Y-schaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5009"/>
        <source>Scale &amp;To Frame Size</source>
        <translation>Schalen naar &amp;framegrootte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5010"/>
        <source>P&amp;roportional</source>
        <translation>&amp;Proportioneel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5013"/>
        <source>Input Profile:</source>
        <translation>Invoerprofiel:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5014"/>
        <source>Rendering Intent:</source>
        <translation>Rendering intent:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5024"/>
        <source>Perceptual</source>
        <translation>Perceptueel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5025"/>
        <source>Relative Colorimetric</source>
        <translation>Relatief colorimetrisch</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5026"/>
        <source>Saturation</source>
        <translation>Verzadiging</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5027"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluut colorimetrisch</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5036"/>
        <source>Left Point</source>
        <translation>Linker punt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5037"/>
        <source>End Points</source>
        <translation>Eindpunt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5039"/>
        <source>&amp;Basepoint:</source>
        <translation>&amp;Basispunt:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5040"/>
        <source>T&amp;ype of Line:</source>
        <translation>Lijnt&amp;ype:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5052"/>
        <source>Line &amp;Width:</source>
        <translation>Linedi&amp;kte:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5056"/>
        <source>Miter Join</source>
        <translation>Verstek</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5057"/>
        <source>Bevel Join</source>
        <translation>Schuin</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5058"/>
        <source>Round Join</source>
        <translation>Rond</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5053"/>
        <source>Ed&amp;ges:</source>
        <translation>&amp;Hoeken:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5063"/>
        <source>Flat Cap</source>
        <translation>Plat</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5064"/>
        <source>Square Cap</source>
        <translation>Vierkant</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5065"/>
        <source>Round Cap</source>
        <translation>Rond</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5067"/>
        <source>&amp;Endings:</source>
        <translation>&amp;Einden:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5120"/>
        <source>No Style</source>
        <translation>Geen stijl</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5069"/>
        <source>Cell Lines</source>
        <translation>Cellijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5070"/>
        <source>Line at Top</source>
        <translation>Bovenlijn</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5071"/>
        <source>Line at the Left</source>
        <translation>Linkerlijn</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5072"/>
        <source>Line at the Right </source>
        <translation>Rechterlijn</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5073"/>
        <source>Line at Bottom</source>
        <translation>Onderlijn</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5215"/>
        <source>Name of selected object</source>
        <translation>Naam van geselecteerd object</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5216"/>
        <source>Horizontal position of current basepoint</source>
        <translation>Horizontale positie van het huidige basispunt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5217"/>
        <source>Vertical position of current basepoint</source>
        <translation>Verticale positie van het huidige basispunt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5218"/>
        <source>Width</source>
        <translation>Breedte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5219"/>
        <source>Height</source>
        <translation>Hoogte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5220"/>
        <source>Rotation of object at current basepoint</source>
        <translation>Rotatie van object op huidig basispunt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5221"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation>Punt waarvandaan de rotatiehoeken worden berekend</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4783"/>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Linksboven als basispunt gebruiken</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4784"/>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Rechtsboven als basispunt gebruiken</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4785"/>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Linksonder als basispunt gebruiken</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4786"/>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Rechtsonder als basispunt gebruiken</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4787"/>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Midden als basispunt gebruiken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5229"/>
        <source>Flip Horizontal</source>
        <translation>Horizontaal spiegelen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5230"/>
        <source>Flip Vertical</source>
        <translation>Verticaal spiegelen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5231"/>
        <source>Move one level up</source>
        <translation>Een niveau hoger</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5232"/>
        <source>Move one level down</source>
        <translation>Een niveau lager</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5233"/>
        <source>Move to front</source>
        <translation>Naar voorgrond</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5234"/>
        <source>Move to back</source>
        <translation>Naar achtergrond</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5235"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation>Geeft weer op welk niveau dit opject is, 0 betekent onderaan</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5236"/>
        <source>Lock or unlock the object</source>
        <translation>Object vergrendelen of losmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5237"/>
        <source>Lock or unlock the size of the object</source>
        <translation>Grootte van het object vergrendelen of losmaken</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4619"/>
        <source>Enable or disable printing of the object</source>
        <translation type="obsolete">Dit object wel of niet afdrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5251"/>
        <source>Font of selected text or object</source>
        <translation>Font van geselecteerde tekst of object</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5252"/>
        <source>Font Size</source>
        <translation>Tekengrootte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5254"/>
        <source>Scaling width of characters</source>
        <translation>Schaalbreedte van tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5258"/>
        <source>Saturation of color of text stroke</source>
        <translation>Verzadiging van kleur van tekstlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5259"/>
        <source>Saturation of color of text fill</source>
        <translation>Verzadiging van kleur van tekstinvulling</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5262"/>
        <source>Line Spacing</source>
        <translation>Regelspatiëring</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5281"/>
        <source>Change settings for left or end points</source>
        <translation>Instellingen voor linkerpunt of eindpunt aanpassen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5282"/>
        <source>Pattern of line</source>
        <translation>Lijnpatroon</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5283"/>
        <source>Thickness of line</source>
        <translation>Lijndikte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5284"/>
        <source>Type of line joins</source>
        <translation>Type lijnverbindingen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5285"/>
        <source>Type of line end</source>
        <translation>Type lijneinden</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5286"/>
        <source>Line style of current object</source>
        <translation>Lijnstijl van huidig object</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5288"/>
        <source>Choose the shape of frame...</source>
        <translation>Vorm van het frame kiezen...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5289"/>
        <source>Edit shape of the frame...</source>
        <translation>Vorm van het frame bewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5290"/>
        <source>Set radius of corner rounding</source>
        <translation>Straal van ronde hoeken instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5291"/>
        <source>Number of columns in text frame</source>
        <translation>Aantal kolommen in tekstframe</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5292"/>
        <source>Switches between Gap or Column width</source>
        <translation>Schakelt tussen Tussenruimte of Kolombreedte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5293"/>
        <source>Distance between columns</source>
        <translation>Afstand tussen kolommen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5294"/>
        <source>Distance of text from top of frame</source>
        <translation>Afstand van tekst tot bovenkant frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5295"/>
        <source>Distance of text from bottom of frame</source>
        <translation>Afstand van tekst tot onderkant frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5296"/>
        <source>Distance of text from left of frame</source>
        <translation>Afstand van tekst tot linkerkant frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5297"/>
        <source>Distance of text from right of frame</source>
        <translation>Afstand van tekst tot rechterkant frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5298"/>
        <source>Edit tab settings of text frame...</source>
        <translation>Tabinstellingen van tekstframe bewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5300"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation>Toestaan dat een afbeelding een andere grootte heeft dan het frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5301"/>
        <source>Horizontal offset of image within frame</source>
        <translation>Horizontale afstand van afbeelding in frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5302"/>
        <source>Vertical offset of image within frame</source>
        <translation>Verticale afstand van afbeelding in frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5303"/>
        <source>Resize the image horizontally</source>
        <translation>De afbeelding horizontaal schalen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5304"/>
        <source>Resize the image vertically</source>
        <translation>De afbeelding verticaal schalen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5305"/>
        <source>Keep the X and Y scaling the same</source>
        <translation>X- en Y-schaling gelijk houden</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5306"/>
        <source>Keep the aspect ratio</source>
        <translation>Beeldverhouding behouden</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5307"/>
        <source>Make the image fit within the size of the frame</source>
        <translation>Afbeelding passend maken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5308"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation>De afbeeldingsverhoudingen gebruiken in plaats van die van het frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5309"/>
        <source>Source profile of the image</source>
        <translation>Bronprofiel van de afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5310"/>
        <source>Rendering intent for the image</source>
        <translation>Rendering intent van de afbeelding</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3869"/>
        <source>&amp;X1:</source>
        <translation>&amp;X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3870"/>
        <source>X&amp;2:</source>
        <translation>X&amp;2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3871"/>
        <source>Y&amp;1:</source>
        <translation>Y&amp;1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3872"/>
        <source>&amp;Y2:</source>
        <translation>&amp;Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3633"/>
        <source>Column width</source>
        <translation>Kolombreedte</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5260"/>
        <source>Right to Left Writing</source>
        <translation>Rechts naar links scrijven</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5041"/>
        <source>Start Arrow:</source>
        <translation>Begin pijl:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5042"/>
        <source>End Arrow:</source>
        <translation>Eind pijl:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5019"/>
        <source>Fixed Linespacing</source>
        <translation>Vaste regelspatiëring</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5020"/>
        <source>Automatic Linespacing</source>
        <translation>Automatische regelspatiëring</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5021"/>
        <source>Align to Baseline Grid</source>
        <translation>Aan de basislijn van het raster uitlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5003"/>
        <source>Actual X-DPI:</source>
        <translation>Werkelijk X-DPI:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5004"/>
        <source>Actual Y-DPI:</source>
        <translation>Werkelijk Y-DPI:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5253"/>
        <source>Offset to baseline of characters</source>
        <translation>Offset ten opzichte van basislijn tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5255"/>
        <source>Scaling height of characters</source>
        <translation>Schaalhoogte van tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5261"/>
        <source>Manual Tracking</source>
        <translation>Handmatige tracking</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4766"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation>Naam &quot;%1&quot; is niet uniek.&lt;br/&gt;Kies een andere naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4957"/>
        <source>Fill Rule</source>
        <translation>Vulmethode</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4958"/>
        <source>Even-Odd</source>
        <translation>Even-oneven</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4959"/>
        <source>Non Zero</source>
        <translation>Niet nul</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5256"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation>Kleur van tekstomlijning en/of valschaduw, afhankelijk van welke is gekozen. Als beiden zijn gekozen, gebruiken ze dezelfde kleur.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5257"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation>Kleur van de geselecteerde tekst. Als Outline tekt decoratie is ingeschakeld, zal deze kleur de vulkleur zijn. Als Valschaduw Tekst is ingeschakeld, is dit de bovenliggende kleur.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5247"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation>Gebruik de omliggende rechthoek, in plaats van de vorm van het frame voor de tekstomloop.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3009"/>
        <source>Auto</source>
        <translation>Automatisch</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4774"/>
        <source>Click and hold down to select the line spacing mode.</source>
        <translation type="obsolete">Klik en houd ingedrukt om regelafstand modus te selecteren.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4915"/>
        <source>Transparency Settings</source>
        <translation>Instellingen transparantie</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4898"/>
        <source>&amp;Group</source>
        <translation>&amp;Groeperen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4916"/>
        <source>Opacity:</source>
        <translation>Ondoorschijnendheid:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4917"/>
        <source>Blend Mode:</source>
        <translation>Vermeng Modus:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4919"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4920"/>
        <source>Darken</source>
        <translation>Donkerder</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4921"/>
        <source>Lighten</source>
        <translation>Lichter</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4922"/>
        <source>Multiply</source>
        <translation>Vermenigvuldig</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Screen</source>
        <translation>Scherm</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4924"/>
        <source>Overlay</source>
        <translation>Maskerlaag</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4925"/>
        <source>Hard Light</source>
        <translation>Hard licht</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4926"/>
        <source>Soft Light</source>
        <translation>Zacht licht</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4927"/>
        <source>Difference</source>
        <translation>Verschil</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4928"/>
        <source>Exclusion</source>
        <translation>Uitsluiting</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4929"/>
        <source>Color Dodge</source>
        <translation>Kleur tegenhouden</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4930"/>
        <source>Color Burn</source>
        <translation>Kleur doordrukken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4931"/>
        <source>Hue</source>
        <translation>Tint</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4933"/>
        <source>Color</source>
        <translation>Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4938"/>
        <source>Gap:</source>
        <translation>Tussenruimte:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4939"/>
        <source>Width:</source>
        <translation>Breedte:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4966"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation>Tekstomloop rond &amp;frame</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4967"/>
        <source>Disabled</source>
        <translation>Uitgeschakeld</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4968"/>
        <source>Use Frame &amp;Shape</source>
        <translation>Gebruik frame &amp;vorm</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5011"/>
        <source>Image Effects</source>
        <translation>Afbeeldingseffecten</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5012"/>
        <source>Extended Image Properties</source>
        <translation>Uitgebreide afbeeldingseigenschappen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5075"/>
        <source>Overprinting</source>
        <translation>Overprinten</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5076"/>
        <source>Knockout</source>
        <translation>Uitsparen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5077"/>
        <source>Overprint</source>
        <translation>Overprint</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5227"/>
        <source>Group the selected objects</source>
        <translation>Geselecteerde objecten groeperen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4739"/>
        <source>Destroys the selected group</source>
        <translation type="obsolete">Vernietigt de geselecteerde groep</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5245"/>
        <source>Disable text flow from lower frames around object</source>
        <translation>Tekstomloop van onderliggende frames rond objecten uitschakelen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5246"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation>Gebruik de frame vorm van onderliggende frames voor tekstomloop rond object.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5248"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object. T</source>
        <translation>Indien gekozen, kan de contour lijn worden bewerkt met het Bewerk Vorm gereedschap in het palet boven. Indien bewerkt via het Vorm palet, wordt het een tweede separate lijn gebaseerd op de vorm van het frame voor tekstomloop of tekstframes onder het object. T</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4949"/>
        <source>Default</source>
        <translation>Standaard</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4950"/>
        <source>Stair Step</source>
        <translation>Getrapt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4951"/>
        <source>Skew</source>
        <translation>Schuintrekken</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4954"/>
        <source>Type:</source>
        <translation>Type:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4972"/>
        <source>Paragraph St&amp;yle:</source>
        <translation>Alinea st&amp;ijl:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4973"/>
        <source>Character St&amp;yle:</source>
        <translation>Teken st&amp;ijl:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4902"/>
        <source>Optical Margins:</source>
        <translation type="obsolete">Optische marges:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4989"/>
        <source>Word Tracking</source>
        <translation>Woord tracking</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4993"/>
        <source>Min:</source>
        <translation>Min:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4994"/>
        <source>Max:</source>
        <translation>Max:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4992"/>
        <source>Glyph Extension</source>
        <translation>Symboolteken extensie</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5265"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation>Alineastijl van de huidige geselecteerde tekst of alinea</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5266"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation>Tekenstijl van de huidige geselecteerde tekst of alinea</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4952"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4971"/>
        <source>Use Image Clip Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4991"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5249"/>
        <source>Use the clipping path of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5267"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5268"/>
        <source>Remove Direct Character Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5275"/>
        <source>Minimal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5276"/>
        <source>Normal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5277"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5278"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5238"/>
        <source>Enable or disable exporting of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5032"/>
        <source>Custom</source>
        <translation type="unfinished">Aangepast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4913"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished">B&amp;ewerken...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4998"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="832"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="833"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4995"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4996"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4997"/>
        <source>Style Settings</source>
        <translation type="unfinished">Stijlinstellingen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3011"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5228"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5264"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5271"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5272"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5273"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5001"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4999"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4984"/>
        <source>Left Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4985"/>
        <source>Right Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4986"/>
        <source>Left Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4987"/>
        <source>Right Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4988"/>
        <source>Reset</source>
        <translation type="unfinished">Opnieuw instellen</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="937"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5102"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation>&amp;Openen...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation>Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation>Opslaan &amp;als...</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/pconsole.ui" line="96"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation>&amp;Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation>&amp;Uitvoeren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation>Voer als &amp;console uit</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation>Op&amp;slaan Output...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation>&amp;Script</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation>Scribus Python Console</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This is derived from standard Python console so it contains some limitations esp. in the case of whitespaces. Please consult Scribus manual for more informations.</source>
        <translation type="obsolete">Dit is een afgeleide van de standaard Python console en bevat beperkingen, speciaal in het geval van witruimten. Lees de Scribus handleiding voor meer informatie.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation>Scriptconsole</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="117"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation>Voer commando&apos;s hier in. Een selectie wordt als script uitgevoerd</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="118"/>
        <source>Output of your script</source>
        <translation>Output van het script</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="195"/>
        <source>Save the Python Commands in File</source>
        <translation>Sla Python commando&apos;s op in bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="220"/>
        <source>Text Files (*.txt)</source>
        <translation>Tekstbestanden (*.txt)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="218"/>
        <source>Save Current Output</source>
        <translation>Bewaar huidige output</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="161"/>
        <source>Open Python Script File</source>
        <translation>Open Python Script bestand</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line: %1 Column: %2</source>
        <translation type="obsolete">Regel: %1 Kolom: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="197"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation>Python Scripts (*.py *.PY)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="33"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="44"/>
        <source>Ctrl+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="65"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="130"/>
        <source>Hu&amp;e:</source>
        <translation>Tin&amp;t:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="131"/>
        <source>&amp;Sat:</source>
        <translation>&amp;Verz.:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="132"/>
        <source>&amp;Val:</source>
        <translation>&amp;Waarde:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="133"/>
        <source>&amp;Red:</source>
        <translation>&amp;Rood:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="134"/>
        <source>&amp;Green:</source>
        <translation>&amp;Groen:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="135"/>
        <source>Bl&amp;ue:</source>
        <translation>&amp;Blauw:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="136"/>
        <source>A&amp;lpha channel:</source>
        <translation>&amp;Alfakanaal:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Basic colors</source>
        <translation>&amp;Basiskleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Custom colors</source>
        <translation>&amp;Aangepaste kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="139"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation>Aangepaste kleuren &amp;instellen &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="140"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="141"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Add to Custom Colors</source>
        <translation>&amp;Toevoegen aan kleuren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="143"/>
        <source>Select color</source>
        <translation>Kleur kiezen</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation>Bestand kopiëren of verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation>Lezen: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation>Schrijven: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation>Bestands&amp;naam:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation>Bestands&amp;type:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="19"/>
        <source>One directory up</source>
        <translation>Bovenliggende map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="20"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="21"/>
        <source>All Files (*)</source>
        <translation>Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="22"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="23"/>
        <source>Size</source>
        <translation>Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="24"/>
        <source>Type</source>
        <translation>Type</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="25"/>
        <source>Date</source>
        <translation>Datum</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="26"/>
        <source>Attributes</source>
        <translation>Attributen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="27"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="28"/>
        <source>Look &amp;in:</source>
        <translation>Zoeken &amp;in:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="29"/>
        <source>Back</source>
        <translation>Terug</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="30"/>
        <source>Create New Folder</source>
        <translation>Nieuwe map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="31"/>
        <source>List View</source>
        <translation>Lijstweergave</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="32"/>
        <source>Detail View</source>
        <translation>Detailweergave</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="33"/>
        <source>Preview File Info</source>
        <translation>Bestandsinfo tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="34"/>
        <source>Preview File Contents</source>
        <translation>Bestandsinhoud tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="35"/>
        <source>Read-write</source>
        <translation>Lezen en schrijven</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="36"/>
        <source>Read-only</source>
        <translation>Alleen-lezen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="37"/>
        <source>Write-only</source>
        <translation>Alleen-schrijven</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="38"/>
        <source>Inaccessible</source>
        <translation>Niet toegankelijk</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="39"/>
        <source>Symlink to File</source>
        <translation>Symlink naar bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="40"/>
        <source>Symlink to Directory</source>
        <translation>Symlink naar map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="41"/>
        <source>Symlink to Special</source>
        <translation>Symlink naar speciaal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="42"/>
        <source>File</source>
        <translation>Bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="43"/>
        <source>Dir</source>
        <translation>Map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="44"/>
        <source>Special</source>
        <translation>Speciaal</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="45"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="46"/>
        <source>Save As</source>
        <translation>Opslaan als</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="47"/>
        <source>&amp;Open</source>
        <translation>&amp;Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="48"/>
        <source>&amp;Save</source>
        <translation>Op&amp;slaan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="49"/>
        <source>&amp;Rename</source>
        <translation>He&amp;rnoemen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="50"/>
        <source>&amp;Delete</source>
        <translation>Verwij&amp;deren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="51"/>
        <source>R&amp;eload</source>
        <translation>Opni&amp;euw laden</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="52"/>
        <source>Sort by &amp;Name</source>
        <translation>Sorteren op &amp;naam</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="53"/>
        <source>Sort by &amp;Size</source>
        <translation>Sorteren op &amp;grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="54"/>
        <source>Sort by &amp;Date</source>
        <translation>Sorteren op &amp;datum</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="55"/>
        <source>&amp;Unsorted</source>
        <translation>Niet &amp;sorteren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort</source>
        <translation>Sorteren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="57"/>
        <source>Show &amp;hidden files</source>
        <translation>&amp;Verborgen bestanden tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="58"/>
        <source>the file</source>
        <translation>het bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="59"/>
        <source>the directory</source>
        <translation>de map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="60"/>
        <source>the symlink</source>
        <translation>de symlink</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="61"/>
        <source>Delete %1</source>
        <translation>%1 verwijderen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="62"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation>&lt;qt&gt;Wilt u werkelijk %1 &quot;%2&quot; verwijderen?&lt;/qt&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="65"/>
        <source>New Folder 1</source>
        <translation>Nieuwe map 1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="66"/>
        <source>New Folder</source>
        <translation>Nieuwe map</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="67"/>
        <source>New Folder %1</source>
        <translation>Nieuwe map %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="68"/>
        <source>Find Directory</source>
        <translation>Map zoeken</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="69"/>
        <source>Directories</source>
        <translation>Mappen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="70"/>
        <source>Save</source>
        <translation>Opslaan</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="71"/>
        <source>Error</source>
        <translation>Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="72"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation>%1
Bestand niet gevonden.
Controleer het pad en de bestandsnaam.</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="73"/>
        <source>All Files (*.*)</source>
        <translation>Alle bestanden (*.*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="74"/>
        <source>Select a Directory</source>
        <translation>Map kiezen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="75"/>
        <source>Directory:</source>
        <translation>Map:</translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="147"/>
        <source>&amp;Font</source>
        <translation>&amp;Font</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="148"/>
        <source>Font st&amp;yle</source>
        <translation>St&amp;ijl</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="149"/>
        <source>&amp;Size</source>
        <translation>&amp;Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="150"/>
        <source>Effects</source>
        <translation>Effecten</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="151"/>
        <source>Stri&amp;keout</source>
        <translation>Door&amp;halen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="152"/>
        <source>&amp;Underline</source>
        <translation>&amp;Onderstrepen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Color</source>
        <translation>&amp;Kleur</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="154"/>
        <source>Sample</source>
        <translation>Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="155"/>
        <source>Scr&amp;ipt</source>
        <translation>Scr&amp;ipt</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="156"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="157"/>
        <source>Apply</source>
        <translation>Toepassen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="158"/>
        <source>Cancel</source>
        <translation>Annuleren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="159"/>
        <source>Close</source>
        <translation>Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="160"/>
        <source>Select Font</source>
        <translation>Font selecteren</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="79"/>
        <source>Clear</source>
        <translation>Leegmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="80"/>
        <source>Select All</source>
        <translation>Alles selecteren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="81"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaan maken</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="82"/>
        <source>&amp;Redo</source>
        <translation>O&amp;pnieuw doen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="83"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;ppen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="84"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Paste</source>
        <translation>P&amp;lakken</translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="99"/>
        <source>Line up</source>
        <translation>Naast elkaar</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="100"/>
        <source>Customize...</source>
        <translation>Aanpassen...</translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation>&lt;h3&gt;Info over Qt&lt;/h3&gt;&lt;p&gt;Dit programma gebruikt Qt versie %1.&lt;/p&gt;&lt;p&gt;Qt is een C++-toolkit voor het ontwikkelen van toepassingen op verschillende platformen.&lt;/p&gt;&lt;p&gt;Qt biedt broncode-compatibiliteit tussen MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, en alle belangrijke UNIX-varianten.&lt;br&gt;Qt is ook beschikbaar voor ingebedde apparaten.&lt;/p&gt;&lt;p&gt;Qt is een product van Trolltech. Zie &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; voor meer informatie.&lt;/p&gt;</translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../scribus/gtaction.cpp" line="76"/>
        <source>Importing text</source>
        <translation>Tekst wordt geïmporteerd</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="195"/>
        <source>All Supported Formats</source>
        <translation>Alle ondersteunde formaten</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="242"/>
        <source>All Files (*)</source>
        <translation>Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="240"/>
        <source>Initializing...</source>
        <translation>Bezig te initialiseren...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1100"/>
        <source>Background</source>
        <translation>Achtergrond</translation>
    </message>
    <message>
        <location filename="../plugins/svgexplugin/svgexplugin.cpp" line="139"/>
        <source>Do you really want to overwrite the File:
%1 ?</source>
        <translation type="obsolete">Wilt u werkelijk het bestand %1 overschrijven:?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Newsletters</source>
        <translation>Nieuwsbrieven</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Brochures</source>
        <translation>Brochures</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Catalogs</source>
        <translation>Catalogi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Flyers</source>
        <translation>Flyers</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Signs</source>
        <translation>Tekens</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Cards</source>
        <translation>Kaarten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Letterheads</source>
        <translation>Briefhoofden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Envelopes</source>
        <translation>Enveloppen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Business Cards</source>
        <translation>Visitekaartjes</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Calendars</source>
        <translation>Kalenders</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Advertisements</source>
        <translation>Advertenties</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>Labels</source>
        <translation>Labels</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>Menus</source>
        <translation>Menu&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Programs</source>
        <translation>Programma&apos;s</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>PDF Forms</source>
        <translation>PDF-formulieren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>PDF Presentations</source>
        <translation>PDF-presentaties</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Magazines</source>
        <translation>Magazines</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Posters</source>
        <translation>Posters</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Announcements</source>
        <translation>Aankondigingen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <source>Text Documents</source>
        <translation>Tekstdocumenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="175"/>
        <source>Folds</source>
        <translation>Gevouwen documenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation>Eigen sjablonen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>Open</source>
        <translation>Openen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="566"/>
        <source>&amp;Scribus Scripts</source>
        <translation>&amp;Scribus scripts</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="561"/>
        <source>&amp;Execute Script...</source>
        <translation>Script &amp;uitvoeren...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="567"/>
        <source>&amp;Recent Scripts</source>
        <translation>&amp;Recente scripts</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="562"/>
        <source>Show &amp;Console</source>
        <translation>&amp;Console tonen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>Save as</source>
        <translation>Opslaan als</translation>
    </message>
    <message>
        <location filename="../plugins/svgimplugin/svgplugin.cpp" line="151"/>
        <source>SVG-Images (*.svg *.svgz);;All Files (*)</source>
        <translation type="obsolete">SVG-afbeeldingen (*.svg *.svgz);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="12"/>
        <source>Comma Separated Value Files</source>
        <translation>Bestanden met kommagescheiden-waarden (CSV)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="58"/>
        <source>CSV_data</source>
        <translation>CSV_gegevens</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="62"/>
        <source>CSV_header</source>
        <translation>CSV_kopregel</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="43"/>
        <source>HTML Files</source>
        <translation>HTML-bestanden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="48"/>
        <source>html</source>
        <translation>html</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlreader.cpp" line="616"/>
        <source>
External Links
</source>
        <translation>
Externe koppelingen
</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/txtim/txtim.cpp" line="21"/>
        <source>Text Files</source>
        <translation>Tekstbestanden</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="327"/>
        <source>Font %1 is broken, discarding it</source>
        <translation>Het font %1 is beschadigd en wordt weggelaten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/textfilter/textfilter.cpp" line="26"/>
        <source>Text Filters</source>
        <translation>Tekstfilters</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="60"/>
        <source>Albanian</source>
        <translation>Albanees</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="61"/>
        <source>Basque</source>
        <translation>Baskisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation>Bulgaars</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="65"/>
        <source>Catalan</source>
        <translation>Catalaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="66"/>
        <source>Chinese</source>
        <translation>Chinees</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation>Tsjechisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="72"/>
        <source>Danish</source>
        <translation>Deens</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="74"/>
        <source>Dutch</source>
        <translation>Nederlands</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="228"/>
        <source>English</source>
        <translation>Engels</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="77"/>
        <source>English (British)</source>
        <translation>Engels (Brits)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="79"/>
        <source>Esperanto</source>
        <translation>Esperanto</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="81"/>
        <source>German</source>
        <translation>Duits</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="84"/>
        <source>Finnish</source>
        <translation>Fins</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="85"/>
        <source>French</source>
        <translation>Frans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="88"/>
        <source>Galician</source>
        <translation>Galiciaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="89"/>
        <source>Greek</source>
        <translation>Grieks</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="91"/>
        <source>Hungarian</source>
        <translation>Hongaars</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="94"/>
        <source>Indonesian</source>
        <translation>Indonesisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="95"/>
        <source>Italian</source>
        <translation>Italiaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="98"/>
        <source>Korean</source>
        <translation>Koreaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="102"/>
        <source>Lithuanian</source>
        <translation>Litouws</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="108"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation>Noors (Nnyorsk)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="110"/>
        <source>Norwegian</source>
        <translation>Noors</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="112"/>
        <source>Polish</source>
        <translation>Pools</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="116"/>
        <source>Russian</source>
        <translation>Russisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="124"/>
        <source>Swedish</source>
        <translation>Zweeds</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="119"/>
        <source>Spanish</source>
        <translation>Spaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="120"/>
        <source>Spanish (Latin)</source>
        <translation>Spaans (Latijn)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="121"/>
        <source>Slovak</source>
        <translation>Slovaaks</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="122"/>
        <source>Slovenian</source>
        <translation>Sloveens</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="123"/>
        <source>Serbian</source>
        <translation>Servisch</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="176"/>
        <source>Media Cases</source>
        <translation>Media-cases</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="563"/>
        <source>&amp;About Script...</source>
        <translation>&amp;Over script...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="534"/>
        <source>About Script</source>
        <translation>Over script</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan fontgrootte niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan font niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekstgrootte niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan kolomtelling niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan regelspaciering niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan kolomruimte niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekst niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekst niet plaatsen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="291"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekst niet intvoegen in non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="329"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation>Uitlijning buiten bereik. Gebruik een van de scribus.ALIGN* constanten.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="554"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation>Selectie index buiten bereik</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="216"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <comment>python error</comment>
        <translation>Eenheid buiten bereik. Gebruik een van de scribus.UNIT_* constanten.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="27"/>
        <source>Target is not an image frame.</source>
        <comment>python error</comment>
        <translation>Doel is geen afbeeldingsframe.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="334"/>
        <source>Corner radius must be a positive number.</source>
        <comment>python error</comment>
        <translation>Hoekradius moet een positief nummer zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="64"/>
        <source>Cannot get a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Kan een kleur niet verkrijgen met een lege naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="87"/>
        <source>Cannot change a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Kan een kleur niet veranderen met een lege naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="123"/>
        <source>Cannot create a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Kan een kleur niet aanmaken met een lege naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="159"/>
        <source>Cannot delete a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Kan een kleur niet verwijderen met een lege naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="204"/>
        <source>Cannot replace a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Kan een kleur niet vervangen met een lege naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/sxwim/sxwim.cpp" line="45"/>
        <source>OpenOffice.org Writer Documents</source>
        <translation>OpenOffice.org Writer-documenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.cpp" line="65"/>
        <source>Color not found - python error</source>
        <comment>python error</comment>
        <translation>Kleur niet gevonden - pythonfout</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="153"/>
        <source>Custom (optional) configuration: </source>
        <comment>short words plugin</comment>
        <translation>Handmatige (optioneel) configuratie: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="149"/>
        <source>Standard configuration: </source>
        <comment>short words plugin</comment>
        <translation>Standaard configuratie: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="129"/>
        <source>Short Words processing. Wait please...</source>
        <comment>short words plugin</comment>
        <translation>Korte woorden in bewerking. Wachten aub...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="148"/>
        <source>Short Words processing. Done.</source>
        <comment>short words plugin</comment>
        <translation>Korte woorden in bewerking. Gereed.</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="58"/>
        <source>Afrikaans</source>
        <translation>Afrikaans</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="128"/>
        <source>Turkish</source>
        <translation>Turks</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="129"/>
        <source>Ukranian</source>
        <translation>Oekraïens</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="131"/>
        <source>Welsh</source>
        <translation>Welsh</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="75"/>
        <source>The filename must be a string.</source>
        <comment>python error</comment>
        <translation>De bestandsnaam moet een string zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="98"/>
        <source>Cannot delete image type settings.</source>
        <comment>python error</comment>
        <translation>Kan afbeeldingtype instellingenniet verwijderen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="102"/>
        <source>The image type must be a string.</source>
        <comment>python error</comment>
        <translation>Het afbeeldingstype moet een string zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="127"/>
        <source>&apos;allTypes&apos; attribute is READ-ONLY</source>
        <comment>python error</comment>
        <translation>&apos;allTypes&apos; attribuut is ALLEEN LEZEN</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="188"/>
        <source>Failed to export image</source>
        <comment>python error</comment>
        <translation>Exporteren van afbeelding mislukt</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="271"/>
        <source>Cannot scale by 0%.</source>
        <comment>python error</comment>
        <translation>Kan niet schalen met 0%.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="386"/>
        <source>Specified item not an image frame.</source>
        <comment>python error</comment>
        <translation>Item is geen afbeeldingsframe.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="417"/>
        <source>Font not found.</source>
        <comment>python error</comment>
        <translation>Font niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="104"/>
        <source>Cannot render an empty sample.</source>
        <comment>python error</comment>
        <translation>Kan geen leeg voorbeeld renderen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="690"/>
        <source>Cannot have an empty layer name.</source>
        <comment>python error</comment>
        <translation>Naam van de laag ontbreekt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="729"/>
        <source>Layer not found.</source>
        <comment>python error</comment>
        <translation>Laag niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="695"/>
        <source>Cannot remove the last layer.</source>
        <comment>python error</comment>
        <translation>Kan laatste laag niet verwijderen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="746"/>
        <source>Cannot create layer without a name.</source>
        <comment>python error</comment>
        <translation>Kan geen nieuwe laag aanmaken zonder naam.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="300"/>
        <source>Insert index out of bounds.</source>
        <comment>python error</comment>
        <translation>In te voegen index buiten bereik.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="337"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan regeluitlijning niet verkrijgen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="363"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <comment>python error</comment>
        <translation>Fontgrootte buiten bereik - moet 1 &lt;= grootte &lt;= 512 zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="372"/>
        <source>Cannot set font size on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan fontgrootte niet instellen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="401"/>
        <source>Cannot set font on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan font niet instellen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="435"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <comment>python error</comment>
        <translation>Spatiëring buiten bereik, moet zijn &gt;= 0.1.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="443"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan regelspaciering niet instellen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="488"/>
        <source>Column gap out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation>Kolomruimte buiten bereik, moet positief zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="496"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan kolomruimte niet instellen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="515"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <comment>python error</comment>
        <translation>Kolomtelling buiten bereik, moet &gt; 1 zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="523"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan aantal kolommen niet instellen in non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="559"/>
        <source>Cannot select text in a non-text frame</source>
        <comment>python error</comment>
        <translation>Kan tekst niet selecteren in non-tekst frame</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="596"/>
        <source>Cannot delete text from a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekst niet wissen in een non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="628"/>
        <source>Cannot set text fill on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tekenvulkleur niet instellen in een non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="664"/>
        <source>Cannot set text stroke on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan kleur tekenomlijning niet instellen in een non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="706"/>
        <source>Cannot set text shade on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan tint tekst niet instellen in een non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="746"/>
        <source>Can only link text frames.</source>
        <comment>python error</comment>
        <translation>Kan alleen tekstframes verbinden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="756"/>
        <source>Target frame links to another frame.</source>
        <comment>python error</comment>
        <translation>Doel frame linkt naar ander frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="761"/>
        <source>Target frame is linked to by another frame.</source>
        <comment>python error</comment>
        <translation>Naar doelframe wordt gelinkt door ander frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="766"/>
        <source>Source and target are the same object.</source>
        <comment>python error</comment>
        <translation>Bron en doel zijn het zelfde object.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="791"/>
        <source>Cannot unlink a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan een non-tekst frame niet loskoppelen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="846"/>
        <source>Cannot convert a non-text frame to outlines.</source>
        <comment>python error</comment>
        <translation>Kan een non-tekst frame niet naar curven omzetten.</translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="82"/>
        <source>Page</source>
        <translation>Pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="581"/>
        <source>Scribus Development Version</source>
        <translation>Scribus ontwikkelings versie</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="135"/>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="136"/>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="137"/>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="138"/>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="155"/>
        <source>pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="156"/>
        <source>mm</source>
        <translation>mm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="157"/>
        <source>in</source>
        <translation>in</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="158"/>
        <source>p</source>
        <translation>p</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="207"/>
        <source>Points (pt)</source>
        <translation>Punten (pt)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="209"/>
        <source>Inches (in)</source>
        <translation>Inches (in)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="210"/>
        <source>Picas (p)</source>
        <translation>Picas (p)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="362"/>
        <source>File exists</source>
        <translation>Bestand bestaat</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Vervangen</translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="486"/>
        <source>All</source>
        <translation>Alles</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="149"/>
        <source>Failed to open document.</source>
        <comment>python error</comment>
        <translation>Openen van document mislukt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="178"/>
        <source>Failed to save document.</source>
        <comment>python error</comment>
        <translation>Bewaren van document mislukt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="39"/>
        <source>Argument must be page item name, or PyCObject instance</source>
        <translation>Argument moet een pagina item naam zijn, of PyCObject instance</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="90"/>
        <source>Property not found</source>
        <translation>Eigenschap niet gevonden</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/cmdgetsetprop.cpp" line="202"/>
        <source>Child not found</source>
        <translation type="obsolete">Child niet gevonden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="310"/>
        <source>Couldn&apos;t convert result type &apos;%1&apos;.</source>
        <translation>Kan niet omzetten resultaat type &apos;%1&apos;.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="442"/>
        <source>Property type &apos;%1&apos; not supported</source>
        <translation>Eigenschap type &apos;%1&apos; niet ondersteunt</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="461"/>
        <source>Couldn&apos;t convert &apos;%1&apos; to property type &apos;%2&apos;</source>
        <translation>Kan &apos;%1&apos; eigenschap niet omzetten naar type &apos;%2&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="469"/>
        <source>Types matched, but setting property failed.</source>
        <translation>Types komen overeen, maar instellen eigenschappen lukt niet.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="138"/>
        <source>Unable to save pixmap</source>
        <comment>scripter error</comment>
        <translation>Kan pixmap niet opslaan</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/cmdobj.cpp" line="432"/>
        <source>An object with the requested name already exists.</source>
        <comment>python error</comment>
        <translation type="obsolete">Een object met deze naam bestaat reeds.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="214"/>
        <source>Point list must contain at least two points (four values).</source>
        <comment>python error</comment>
        <translation>Puntenlijst moet tenminste twee punten bevatten (vier waarden).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="299"/>
        <source>Point list must contain an even number of values.</source>
        <comment>python error</comment>
        <translation>Puntenlijst moet een even aantal waarden bevatten.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="294"/>
        <source>Point list must contain at least three points (six values).</source>
        <comment>python error</comment>
        <translation>Puntenlijst moet tenminste drie punten bevatten (zes waarden).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="376"/>
        <source>Point list must contain at least four points (eight values).</source>
        <comment>python error</comment>
        <translation>Puntenlijst moet tenminste vier punten bevatten (acht waarden).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="381"/>
        <source>Point list must have a multiple of six values.</source>
        <comment>python error</comment>
        <translation>Puntenlijst moet een veelvoud van zes waarden bevatten.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="480"/>
        <source>Object not found.</source>
        <comment>python error</comment>
        <translation>Object niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="606"/>
        <source>Style not found.</source>
        <comment>python error</comment>
        <translation>Stijl niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="632"/>
        <source>Cannot set style on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan stijl niet instellen van non-tekst frame.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="58"/>
        <source>Failed to save EPS.</source>
        <comment>python error</comment>
        <translation>Opslaan van EPS mislukt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="149"/>
        <source>Page number out of range.</source>
        <comment>python error</comment>
        <translation>Paginanummer buiten bereik.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="292"/>
        <source>argument is not list: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument is geen lijst: moet een lijst van zwevende waarden (float values) zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="252"/>
        <source>argument contains non-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument bevat niet-nummerieke waarden: moet een lijst van zwevende waarden (float values) zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="303"/>
        <source>argument contains no-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument bevat niet-nummerieke waarden: moet een lijst van zwevende waarden (float values) zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="217"/>
        <source>Line width out of bounds, must be 0 &lt;= line_width &lt;= 12.</source>
        <comment>python error</comment>
        <translation>Lijnbreedte buiten bereik, moet zijn 0 &lt;= line_width &lt;=12.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="239"/>
        <source>Line shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation>Lijn tint buiten bereik, moet zijn 0 &lt;= shade &lt;=100.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="261"/>
        <source>Fill shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation>Vul tint buiten bereik, moet zijn 0 &lt;= shade &lt;=100.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="363"/>
        <source>Line style not found.</source>
        <comment>python error</comment>
        <translation>Lijn stijl niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="797"/>
        <source>Object is not a linked text frame, can&apos;t unlink.</source>
        <comment>python error</comment>
        <translation>Object is een niet gekoppeld tekst frame, kan niet ontkoppelen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="871"/>
        <source>Only text frames can be checked for overflowing</source>
        <comment>python error</comment>
        <translation>Alleeen tekst frames kunnen worden gecontroleerd op overloop</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="565"/>
        <source>&amp;Script</source>
        <translation>&amp;Script</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="68"/>
        <source>Croatian</source>
        <translation>Kroatisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="113"/>
        <source>Portuguese</source>
        <translation>Portugees</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="114"/>
        <source>Portuguese (BR)</source>
        <translation>Portugees (Br)</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="259"/>
        <source>Scribus Crash</source>
        <translation>Scribus is gecrashed</translation>
    </message>
    <message>
        <location filename="../../scribus/main_nix.cpp" line="128"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation>Scribus is gecrashed met signaal #%1</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="261"/>
        <source>&amp;OK</source>
        <translation>&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="91"/>
        <source>Master Page </source>
        <translation>Pagina sjabloon </translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="124"/>
        <source>4A0</source>
        <translation>4A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="130"/>
        <source>2A0</source>
        <translation>2A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="220"/>
        <source>Comm10E</source>
        <translation>Comm10E</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="226"/>
        <source>DLE</source>
        <translation>DLE</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="40"/>
        <source>Could not open output file %1</source>
        <translation>Kan output bestand %1 niet openen</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="56"/>
        <source>Output stream not writeable</source>
        <translation>Kan output stream %1 niet schrijven</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="79"/>
        <source>Verification of settings failed: %1</source>
        <translation>Verificatie van instellingen mislukt: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="281"/>
        <source>Could not open input file %1</source>
        <translation>Kan input bestand %1 niet openen</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="663"/>
        <source>Unable to read settings XML:</source>
        <translation>Kan XML instellingen niet lezen:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="297"/>
        <source>%1 (line %2 col %3)</source>
        <comment>Load PDF settings</comment>
        <translation>%1 [line %2 col %3)</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>Unable to read settings XML: %1</source>
        <translation>Kan XML instellingen niet lezen: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>null root node</source>
        <comment>Load PDF settings</comment>
        <translation>null root node</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="441"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <comment>Load PDF settings</comment>
        <translation>&lt;pdfVersion&gt; niet correct</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="454"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <comment>Load PDF settings</comment>
        <translation>gevonden %1 &lt;%2&gt; nodes, benodigd 1.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="469"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <comment>Load PDF settings</comment>
        <translation>onverwachte null &lt;%2&gt; node</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="477"/>
        <source>node &lt;%1&gt; not an element</source>
        <comment>Load PDF settings</comment>
        <translation>node &lt;%1&gt; is geen element</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="497"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>in element &lt;%1&gt; ontbreekt &apos;value&apos; attribuut</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="526"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <comment>Load PDF settings</comment>
        <translation>element &lt;%1&gt; moet waarde &apos;true&apos; of &apos;false&apos; zijn</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="664"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>in element &lt;lpiSettingsEntry&gt; ontbreekt &apos;name&apos; attribuut</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="48"/>
        <source>Freetype2 library not available</source>
        <translation>Freetype2 library niet beschikbaar</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="186"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation>Het font %1 is beschadigd (read stream), wordt niet ingesloten</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="53"/>
        <source>Font %1 is broken (no Face), discarding it</source>
        <translation>Font %1 is beschadigd (no Face), wordt genegeerd</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="390"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation>Font %1 heeft beschadigde symboolteken %2 (charcode %3)</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="216"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation>Font %1 kan niet worden gelezen, wordt niet ingesloten</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="334"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation>Font %1 kan niet worden geladen, font type onbekend</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="538"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation>Font %1 geladen uit %2(%3)</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="554"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation>Font %1(%2) is een duplicaat van %3</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="666"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation>Laden font %1 (gevonden met fontconfig)</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="671"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation>Laden van een font niet gelukt - freetype2 kan font bestand niet vinden</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="72"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation>extractie face %1 van font %2 (offset=%3, nTables=%4)</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="85"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation>memcpy header: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="94"/>
        <source>table &apos;%1&apos;</source>
        <translation>tabel &apos;%1&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="95"/>
        <source>memcpy table: %1 %2 %3</source>
        <translation>memcpy tabel: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="98"/>
        <source>memcpy offset: %1 %2 %3</source>
        <translation>memcpy positie: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="139"/>
        <source> cm</source>
        <translation type="obsolete"> cm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="140"/>
        <source> c</source>
        <translation type="obsolete"> c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="159"/>
        <source>cm</source>
        <translation>cm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="160"/>
        <source>c</source>
        <translation>c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="208"/>
        <source>Millimeters (mm)</source>
        <translation>Millimeters (mm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="211"/>
        <source>Centimeters (cm)</source>
        <translation>Centimeters (cm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="212"/>
        <source>Cicero (c)</source>
        <translation>Cicero (c)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="525"/>
        <source>page</source>
        <comment>page export</comment>
        <translation>pagina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="117"/>
        <source>Document Template: </source>
        <translation>Document Sjabloon:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="213"/>
        <source>Color not found.</source>
        <comment>python error</comment>
        <translation>Kleur niet gevonden.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="173"/>
        <source>Color not found in document.</source>
        <comment>python error</comment>
        <translation>Kleur niet gevonden in document.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="184"/>
        <source>Color not found in default colors.</source>
        <comment>python error</comment>
        <translation>Kleur niet gevonden in standaard kleuren.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="204"/>
        <source>Cannot group less than two items</source>
        <comment>python error</comment>
        <translation>Kan minder dan twee items niet groeperen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="229"/>
        <source>Can&apos;t group less than two items</source>
        <comment>python error</comment>
        <translation>Kan minder dan twee items niet groeperen</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="237"/>
        <source>Need selection or argument list of items to group</source>
        <comment>python error</comment>
        <translation>Benodig selectie of argumentenlijst van te groeperen items</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="963"/>
        <source>Can&apos;t set bookmark on a non-text frame</source>
        <comment>python error</comment>
        <translation>Kan geen bookmark instellen van non-tekst frame</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="997"/>
        <source>Can&apos;t get info from a non-text frame</source>
        <comment>python error</comment>
        <translation>Kan geen informatie krijgen van non-tekst frame</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="80"/>
        <source>The filename should not be empty string.</source>
        <comment>python error</comment>
        <translation>De bestandsnaam kan geen lege string zijn.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="759"/>
        <source>Scribus Python interface module

This module is the Python interface for Scribus. It provides functions
to control scribus and to manipulate objects on the canvas. Each
function is documented individually below.

A few things are common across most of the interface.

Most functions operate on frames. Frames are identified by their name,
a string - they are not real Python objects. Many functions take an
optional (non-keyword) parameter, a frame name.
Many exceptions are also common across most functions. These are
not currently documented in the docstring for each function.
- Many functions will raise a NoDocOpenError if you try to use them
without a document to operate on.
- If you do not pass a frame name to a function that requires one,
the function will use the currently selected frame, if any, or
raise a NoValidObjectError if it can&apos;t find anything to operate
on.
- Many functions will raise WrongFrameTypeError if you try to use them
on a frame type that they do not make sense with. For example, setting
the text color on a graphics frame doesn&apos;t make sense, and will result
in this exception being raised.
- Errors resulting from calls to the underlying Python API will be
passed through unaltered. As such, the list of exceptions thrown by
any function as provided here and in its docstring is incomplete.

Details of what exceptions each function may throw are provided on the
function&apos;s documentation, though as with most Python code this list
is not exhaustive due to exceptions from called functions.
</source>
        <translation>Scribus Python interface module

Deze module is de Python interface voor Scribus. Het bevat functies
om Scribus te beheersen en voor manipulatie van objecten op het werkblad. 
Elke functie is hieronder afzonderlijk gedocumenteerd.

De meeste functies zijn bewerkingen van frames. Frames worden 
geïdentificeerd bij hun naam - zij zijn geen echte Python objecten.
Veel functies benodigen een optionele (non-keyword) parameter, een frame naam.
Veel uitzonderingen komen regelmatig bij de meeste functies voor. Zij zijn
niet gedocumenteerd in de docstring voor elke functie.
- Vele functies roepen een NoDocOpenError op als zij worden gebruikt 
zonder te bewerken document.
- Als er geen frame naam wordt toegekend aan een functie waarbij dat nodig is,
zal de functie het actieve frame gebruiken, als aanwezig, of een NoValidObjectError 
oproepen als er niets is om te bewerken.
- Meerdere functies zullen een WrongFrameTypeError oproepen als getracht wordt
deze toe te passen op een frame waar dit niet mogeljk is. Bijvoorbeeld,
instellen van de tekstkleur in een afbeeldingenframe is niet relevant, en zal een
WrongFrameTypeError oproepen.
- Fouten die resulteren uit aanroepen de van de onderliggende Python API
worden ongewijzigd doorgegeven. Zodoende is de lijst met uitzonderingen die
elke functie die hier wordt gebruikt incompleet.

Details van welke uitzonderingen elke functie oproept worden meegegeven in de
documentatie van de functie, maar zoals met het grootste deel van de Python code
is deze documentatie niet uitputtend ten gevolge van uitzonderingen van
aangeroepen functies.
</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtim.cpp" line="47"/>
        <source>OpenDocument Text Documents</source>
        <translation>OpenDocument Text Documenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="2620"/>
        <source>Copy #%1 of </source>
        <translation>Kopie #%1 van</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1967"/>
        <source>Black</source>
        <translation>Zwart</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1969"/>
        <source>Cyan</source>
        <translation>Cyaan</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1971"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1973"/>
        <source>Yellow</source>
        <translation>Geel</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="56"/>
        <source>Color Wheel</source>
        <translation>Kleurwiel</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="58"/>
        <source>Font Preview</source>
        <translation>Fontvoorbeeld</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="45"/>
        <source>My Plugin</source>
        <translation>Mijn plug-in</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="71"/>
        <source>New From Template</source>
        <translation>Nieuw van sjabloon</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PS/EPS Importer</source>
        <translation type="obsolete">PS/EPS importfilter</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="66"/>
        <source>Save As Template</source>
        <translation>Opslaan als sjabloon</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="133"/>
        <source>Scripter</source>
        <translation>Scripter</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="84"/>
        <source>Short Words</source>
        <translation>Korte woorden</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="98"/>
        <source>SVG Export</source>
        <translation>SVG exporteren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="101"/>
        <source>SVG Import</source>
        <translation>SVG importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="104"/>
        <source>OpenOffice.org Draw Importer</source>
        <translation>OpenOffice.org Draw Importfilter</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="236"/>
        <source>Scribus crashes due to the following exception : %1</source>
        <translation>Scribus wordt gestopt ten gevolge van de volgende uitzondering : %1</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="318"/>
        <source>Creating Font Cache</source>
        <translation>Maak Font Cache aan</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="344"/>
        <source>New Font found, checking...</source>
        <translation>Nieuw Font gevonden, controleren...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="381"/>
        <source>Modified Font found, checking...</source>
        <translation>Bijgewerkt Font gevonden, controleren...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="767"/>
        <source>Reading Font Cache</source>
        <translation>Lees Font Cache</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="814"/>
        <source>Writing updated Font Cache</source>
        <translation>Schrijf bijgewerkte Font Cache</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="831"/>
        <source>Searching for Fonts</source>
        <translation>Zoekt naar fonts</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4287"/>
        <source>The changes to your document have not been saved and you have requested to revert them. Do you wish to continue?</source>
        <translation>De veranderingen in het document zijn nog niet opgeslagen en u heeft gevraagd deze terug te zetten. Wilt u doorgaan?</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="363"/>
        <source>A file named &apos;%1&apos; already exists.&lt;br/&gt;Do you want to replace it with the file you are saving?</source>
        <translation>Een bestand met de naam &apos;%1&apos; bestaat reeds.&lt;br/&gt;Wilt u dit bestand vervangen door de nieuwe versie?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="45"/>
        <source>firstPageOrder is bigger than allowed.</source>
        <comment>python error</comment>
        <translation>firstPageOrder is groter dan toegestaan.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="40"/>
        <source>Old .sla format support</source>
        <translation>Oud .sla bestandsformaat ondersteuning</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="83"/>
        <source>German (Trad.)</source>
        <translation>Duits (Trad.)</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1783"/>
        <source>Exporting PostScript File</source>
        <translation>Exporteren PostScript bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1785"/>
        <source>Printing File</source>
        <translation>Afdrukken bestand</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3635"/>
        <source>&lt;p&gt;You are trying to import more pages than there are available in the current document counting from the active page.&lt;/p&gt;Choose one of the following:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Create&lt;/b&gt; missing pages&lt;/li&gt;&lt;li&gt;&lt;b&gt;Import&lt;/b&gt; pages until the last page&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancel&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</source>
        <translation>&lt;p&gt;U probeert meer pagina&apos;s te importeren dan er beschikbaar zijn in het huidige document geteld vanaf de actieve pagina.&lt;/p&gt;Maak een keuze:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Aanmaken&lt;/b&gt; ontbrekende pagina&apos;s&lt;/li&gt;&lt;li&gt;&lt;b&gt;Importeren&lt;/b&gt; Pagina&apos;s tot de laatste pagina&lt;/li&gt;&lt;li&gt;&lt;b&gt;Afbreken&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3636"/>
        <source>C&amp;reate</source>
        <translation>&amp;Aanmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3637"/>
        <source>&amp;Import</source>
        <translation>&amp;Importeren</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="126"/>
        <source>Thai</source>
        <translation>Thais</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="31"/>
        <source>Barcode Generator</source>
        <translation>Streepjescodegenerator</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="172"/>
        <source>OpenOffice.org Draw (*.sxd *.odg);;All Files (*)</source>
        <translation>OpenOffice.org Draw (*.sxd *.odg);;Alle bestanden (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="52"/>
        <source>Word Documents</source>
        <translation>Word documenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="32"/>
        <source>Palm PDB Documents</source>
        <comment>PDB Importer</comment>
        <translation>Palm PDB documenten</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="75"/>
        <source>PDB_data</source>
        <comment>PDB Importer</comment>
        <translation type="obsolete">PDB_data</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="100"/>
        <source>PDB Import</source>
        <comment>PDB Importer</comment>
        <translation>PDB import</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="92"/>
        <source>Could not open file %1</source>
        <comment>PDB Importer</comment>
        <translation>Kan bestand %1 niet openen</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="103"/>
        <source>Luxembourgish</source>
        <translation>Luxemburgs</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="59"/>
        <source>Arabic</source>
        <translation>Arabisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="80"/>
        <source>Estonian</source>
        <translation>Estisch</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="96"/>
        <source>Japanese</source>
        <translation>Japans</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="139"/>
        <source>Given master page name does not match any existing.</source>
        <comment>python error</comment>
        <translation>Deze pagina sjabloon naam komt niet overeen met een bestaande.</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="93"/>
        <source>Icelandic</source>
        <translation>IJslands</translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_tiff.cpp" line="957"/>
        <source>%1 may be corrupted : missing resolution tags</source>
        <translation>%1 kan beschadigd zijn: ontbrekende resolutie labels</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="101"/>
        <source>This file is not recognized as a PDB document. Please, report this as a bug if you are sure it is one.</source>
        <comment>PDB Importer</comment>
        <translation>Bestand wordt niet herkend als een PDF document. Meldt dit als een bug.</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="63"/>
        <source>Breton</source>
        <translation>Bretons</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="78"/>
        <source>English (American)</source>
        <translation>Engels (Amerikaans)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="76"/>
        <source>English (Australian)</source>
        <translation>Engels (Australisch)</translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_jpeg.cpp" line="314"/>
        <source>%1 may be corrupted : missing or wrong resolution tags</source>
        <translation>%1 kan beschadigd zijn: ontbrekende of verkeerde resolutie labels</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="73"/>
        <source>Dzongkha</source>
        <translation>Dzongkha</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="82"/>
        <source>German (Swiss)</source>
        <translation>Duits (Zwitsers)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="90"/>
        <source>Hebrew</source>
        <translation>Hebreeuws</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="100"/>
        <source>Latin</source>
        <translation>Latijn</translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/langmgr.cpp" line="106"/>
        <source>Norwegian (Bokmål)</source>
        <translation type="unfinished">Noors (Bokmål)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="115"/>
        <source>Romanian</source>
        <translation>Roemeens</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Quarto</source>
        <translation>Quarto</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Foolscap</source>
        <translation>Folio</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Letter</source>
        <translation>Letter (US)</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Govt. Letter</source>
        <translation>Govt. Letter</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Legal</source>
        <translation>Legal</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Ledger</source>
        <translation>Tabloid</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Executive</source>
        <translation>Executive</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Post</source>
        <translation>Post</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Crown</source>
        <translation>Crown</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Large Post</source>
        <translation>Large Post</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Demy</source>
        <translation>Demy</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Medium</source>
        <translation>Medium</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Royal</source>
        <translation>Royal</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Elephant</source>
        <translation>Elephant</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Double Demy</source>
        <translation>Double Demy</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>Quad Demy</source>
        <translation>Quad Demy</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>STMT</source>
        <translation>STMT</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>A</source>
        <translation>A</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>B</source>
        <translation>B</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>C</source>
        <translation>C</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>D</source>
        <translation>D</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>E</source>
        <translation>E</translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_ps.cpp" line="486"/>
        <source>The Font(s):
%1 are not available.
They have been replaced by &quot;Courier&quot;
Therefore the image may be not correct</source>
        <translation type="obsolete">De Font(s):
%1 zijn niet beschikbaar.
Deze worden vervangen door &quot;Courier&quot;
Weergave is mogelijk niet correct</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="582"/>
        <source>You are running a development version of Scribus 1.3.x. The document you are working with was created in Scribus 1.2.x.  Saving the current file under 1.3.x renders it unable to be edited in Scribus 1.2.x versions. To preserve the ability to edit in 1.2.x, save this file under a different name and further edit the newly named file and the original will be untouched. Are you sure you wish to proceed with this operation?</source>
        <translation>U werkt met een ontwikkelversie van Scribus 1.3.x. Het document waarin u werkt is oorspronkelijk opgezet in Scribus 1.2.x  Opslaan van dit bestand maakt het onbruikbaar voor Scribus 1.2.x versies. Om toch in 1.2.x te bewerken, bewaar dit bestand onder een andere naam bewerk het onder deze nieuwe naam en het originele bestand zal niet worden gewijzigd. Weet u zeker dat u wilt doorgaan?</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="80"/>
        <source>Font %1(%2) is broken</source>
        <translation>Font %1 (%2) is beschadigd</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="177"/>
        <source>Font %1 has broken glyph %2</source>
        <translation>Font %1 heeft beschadigde symboolteken %2</translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="170"/>
        <source>font %1 </source>
        <translation>font %1 </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="172"/>
        <source>size %1 </source>
        <translation>grootte %1 </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="174"/>
        <source>+style </source>
        <translation>+stijl </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="176"/>
        <source>+color </source>
        <translation>+kleur </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="178"/>
        <source>+underline </source>
        <translation>+onderlijnen</translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="178"/>
        <source>-underline </source>
        <translation>-onderlijnen </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="180"/>
        <source>+strikeout </source>
        <translation>+doorstrepen </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="180"/>
        <source>-strikeout </source>
        <translation>-doorstrepen </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="182"/>
        <source>+shadow </source>
        <translation>+schaduw </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="182"/>
        <source>-shadow </source>
        <translation>-schaduw </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="184"/>
        <source>+outline </source>
        <translation>-tekstomlijning </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="184"/>
        <source>-outline </source>
        <translation>-tekstomlijning </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="186"/>
        <source>+tracking %1 </source>
        <translation>+tracking %1 </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="186"/>
        <source>-tracking </source>
        <translation>-tracking </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="188"/>
        <source>+baseline %1 </source>
        <translation>+basislijn %1</translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="190"/>
        <source>+stretch </source>
        <translation>+rekken </translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="192"/>
        <source>parent= %1</source>
        <translation>parent= %1</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="141"/>
        <source>All Supported Formats (*.eps *.EPS *.epsi *.EPSI *.ps *.PS);;</source>
        <translation type="obsolete">Alle ondersteunde formaten (*.eps *.EPS *.epsi *.EPSI *.ps *.PS);;</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="173"/>
        <source>Transparency out of bounds, must be 0 &lt;= transparency &lt;= 1.</source>
        <comment>python error</comment>
        <translation>Transparantie buiten bereik, moet zijn 0 &lt;=transparatie &lt;= 1.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="195"/>
        <source>Blendmode out of bounds, must be 0 &lt;= blendmode &lt;= 15.</source>
        <comment>python error</comment>
        <translation>Meng modus buiten bereik, moet zijn 0 &lt;=mengmodus &lt;=15.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="98"/>
        <source>Cannot get number of lines of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan aantal regels van niet-tekst frames niet vaststellen.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="57"/>
        <source>Scribus 1.2.x Support</source>
        <translation>Scribus 1.2.x ondersteuning</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="64"/>
        <source>Scribus 1.3.4 Support</source>
        <translation type="obsolete">Scribus 1.3.4 ondersteuning</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="72"/>
        <source>Image</source>
        <translation type="obsolete">Afbeelding</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="78"/>
        <source>PDF Push Button</source>
        <translation type="obsolete">PDF knop</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="81"/>
        <source>PDF Text Field</source>
        <translation type="obsolete">PDF tekstveld</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="84"/>
        <source>PDF Check Box</source>
        <translation type="obsolete">PDF check box</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="87"/>
        <source>PDF Combo Box</source>
        <translation type="obsolete">PDF Combo Box</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="90"/>
        <source>PDF List Box</source>
        <translation type="obsolete">PDF List Box</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="93"/>
        <source>PDF Text Annotation</source>
        <translation type="obsolete">PDF tekst annotatie</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="96"/>
        <source>PDF Link Annotation</source>
        <translation type="obsolete">PDF link annotatie</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="99"/>
        <source>Text</source>
        <translation type="obsolete">Tekst</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="104"/>
        <source>Line</source>
        <translation type="obsolete">Lijn</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="107"/>
        <source>Polygon</source>
        <translation type="obsolete">Polygoon</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="110"/>
        <source>Polyline</source>
        <translation type="obsolete">Polylijn</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="113"/>
        <source>PathText</source>
        <translation type="obsolete">Tekstpad</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.3.0-&gt;1.3.3.7 Support</source>
        <translation type="obsolete">Scribus 1.3.0-&gt;1.3.3.7 ondersteuning</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="98"/>
        <source>Font %1 has broken metrics in file %2, ignoring metrics</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="67"/>
        <source>Chinese (Trad.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="61"/>
        <source>Scribus 1.3.0-&gt;1.3.3.x Support</source>
        <translation type="unfinished">Scribus 1.2.x ondersteuning {1.3.0-&gt;1.3.3.?}</translation>
    </message>
    <message>
        <location filename="../../scribus/serializer.cpp" line="380"/>
        <source>Copy of %1 (%2)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="163"/>
        <source>%</source>
        <translation type="unfinished">%</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="97"/>
        <source>Khmer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="99"/>
        <source>Lao</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="130"/>
        <source>Vietnamese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="107"/>
        <source>An error occurred while initializing icc transforms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="134"/>
        <source>Output profile is not supported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/wmfimplugin/wmfimportplugin.cpp" line="89"/>
        <source>WMF Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/sclayer.cpp" line="388"/>
        <source>New Layer</source>
        <translation type="unfinished">Nieuwe laag</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="71"/>
        <source>Adobe Illustrator Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="61"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PostScript Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="169"/>
        <source>Do you really want to overwrite the file:
%1 ?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="34"/>
        <source>Encapsulated PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="35"/>
        <source>GIF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="36"/>
        <source>JPEG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="37"/>
        <source>Pattern Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="38"/>
        <source>PDF Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="39"/>
        <source>PNG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="40"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="41"/>
        <source>Adobe Photoshop</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="42"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="43"/>
        <source>XPM</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="44"/>
        <source>Windows Meta File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="45"/>
        <source>Scalable Vector Graphics</source>
        <translation type="unfinished">Scalable Vector Graphics</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="46"/>
        <source>Adobe Illustrator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="104"/>
        <source>Valid metrics were found for font %1, using metrics in file %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="111"/>
        <source>No metrics found for font %1, ignoring font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="378"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="375"/>
        <source>Configfile %1 not found or the file is not readable</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="386"/>
        <source>second argument is not tuple: must be tuple of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="398"/>
        <source>second argument contains non-numeric values: must be list of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="50"/>
        <source>Cannot have an empty paragraph style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="70"/>
        <source>hasdropcap has to be 0 or 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="122"/>
        <source>Cannot have an empty char style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="920"/>
        <source>Can only hyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="943"/>
        <source>Can only dehyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="82"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="91"/>
        <source>PathCutter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="95"/>
        <source>PathFinder</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="87"/>
        <source>PathStroker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="56"/>
        <source>Spell check (aspell)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/subdivide/subdivide.cpp" line="79"/>
        <source>Subdivide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="71"/>
        <source>Xfig Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="47"/>
        <source>Xfig File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="380"/>
        <source>Parsing the configfile %1 failed! Depending on the type of the error render frames might not work correctly!
%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="86"/>
        <source>MeshDistortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="88"/>
        <source>PathAlongPath</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/transform/transformeffect.cpp" line="78"/>
        <source>Transform Effect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="161"/>
        <source>&#xb0;</source>
        <comment>degrees, unicode 0xB0</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="152"/>
        <source>Cannot get text distances of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="462"/>
        <source>Text distances out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="470"/>
        <source>Cannot set text distances on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="62"/>
        <source>Bengali</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="117"/>
        <source>Sanskrit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="64"/>
        <source>Scribus 1.3.4+ Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="82"/>
        <source>PathConnect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_ps.cpp" line="502"/>
        <source>The Font(s):
%1 are not embedded or available for Scribus.
They might be replaced by &quot;Courier&quot;, depending how your Ghostscript is configured.
Therefore the image may be not correct</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="108"/>
        <source>Save As</source>
        <translation type="unfinished">Opslaan als</translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="257"/>
        <source>Printing...</source>
        <translation type="unfinished">Afdrukken...</translation>
    </message>
</context>
<context>
    <name>QTextEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="89"/>
        <source>Clear</source>
        <translation>Leegmaken</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="90"/>
        <source>Select All</source>
        <translation>Alles selecteren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="91"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaan maken</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="92"/>
        <source>&amp;Redo</source>
        <translation>O&amp;pnieuw doen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="93"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;ppen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="94"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiëren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="95"/>
        <source>&amp;Paste</source>
        <translation>P&amp;lakken</translation>
    </message>
</context>
<context>
    <name>QTitleBar</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="104"/>
        <source>System Menu</source>
        <translation>Systeemmenu</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="105"/>
        <source>Shade</source>
        <translation>Oprollen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="106"/>
        <source>Unshade</source>
        <translation>Tevoorschijn halen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="107"/>
        <source>Normalize</source>
        <translation>Normaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="108"/>
        <source>Minimize</source>
        <translation>Minimaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="109"/>
        <source>Maximize</source>
        <translation>Maximaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="110"/>
        <source>Close</source>
        <translation>Sluiten</translation>
    </message>
</context>
<context>
    <name>QWorkspace</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="114"/>
        <source>&amp;Restore</source>
        <translation>&amp;Herstellen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="115"/>
        <source>&amp;Move</source>
        <translation>&amp;Verplaatsen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="116"/>
        <source>&amp;Size</source>
        <translation>&amp;Grootte</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="117"/>
        <source>Mi&amp;nimize</source>
        <translation>Mi&amp;nimaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="118"/>
        <source>Ma&amp;ximize</source>
        <translation>Ma&amp;ximaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="119"/>
        <source>&amp;Close</source>
        <translation>&amp;Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="120"/>
        <source>Stay on &amp;Top</source>
        <translation>Altijd op &amp;voorgrond</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="121"/>
        <source>Minimize</source>
        <translation>Minimaliseren</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="122"/>
        <source>Restore Down</source>
        <translation>Herstellen onder</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="123"/>
        <source>Close</source>
        <translation>Sluiten</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="124"/>
        <source>Sh&amp;ade</source>
        <translation>&amp;Oprollen</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="125"/>
        <source>%1 - [%2]</source>
        <translation>%1 - [%2]</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="126"/>
        <source>&amp;Unshade</source>
        <translation>&amp;Tevoorschijn halen</translation>
    </message>
</context>
<context>
    <name>ReformDoc</name>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="63"/>
        <source>Document Setup</source>
        <translation>Instellingen voor document</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="66"/>
        <source>Document</source>
        <translation>Document</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="72"/>
        <source>Guides</source>
        <translation>Hulplijnen</translation>
    </message>
    <message>
        <lo