<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS><TS version="1.1">
<context>
    <name></name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="21"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="35"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="50"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="64"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="77"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="94"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="106"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="22"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="46"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="88"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="101"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="111"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="55"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="96"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="108"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="117"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="128"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="141"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="152"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="162"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="173"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="185"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="196"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="206"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="218"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="226"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="233"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="241"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="249"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="256"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="21"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="31"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="41"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="51"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="61"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="71"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="81"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="91"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="102"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="113"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="124"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="134"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="145"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="155"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="165"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="177"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="189"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="200"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="209"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="83"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="101"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="135"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="165"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="23"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="35"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="48"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="59"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="69"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="80"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="89"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="98"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="107"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="118"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="126"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="141"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="153"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="166"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="177"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="187"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="199"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="24"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="33"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="43"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="62"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="71"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="83"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="92"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="105"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="118"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="131"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="144"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="157"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="170"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="182"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="194"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="208"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="222"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="236"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="250"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="263"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="275"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="287"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="300"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="311"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="320"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="329"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="338"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="26"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="43"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="60"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="75"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="90"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="108"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="128"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="149"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="165"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="177"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="193"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="211"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="227"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="240"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="252"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="26"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="36"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="45"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="54"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="65"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="78"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="91"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="100"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="110"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="123"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="132"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="141"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="151"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="167"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="181"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="198"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="22"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="33"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="43"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="53"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="63"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="73"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="83"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="96"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="110"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="121"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="132"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="143"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="157"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="169"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="181"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="43"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="80"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="23"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="35"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="45"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="55"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="67"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="79"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="89"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="100"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="110"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="120"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="132"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="146"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="159"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="173"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="186"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="199"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="211"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="223"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="236"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="250"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="261"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="272"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="282"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="295"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="308"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="325"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="338"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="352"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="365"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="379"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="394"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="406"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="21"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="34"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="47"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="61"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="69"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="83"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="95"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="106"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="21"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="33"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="45"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="57"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>@default</name>
    <message>
        <location filename="" line="136966688"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B</source>
        <translation type="obsolete">B</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>c</source>
        <translation type="obsolete">c</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> c</source>
        <translation type="obsolete">c</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> p</source>
        <translation type="obsolete"> p</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;C</source>
        <translation type="obsolete">&amp;C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;K</source>
        <translation type="obsolete">&amp;K</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;M</source>
        <translation type="obsolete">&amp;M</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Y</source>
        <translation type="obsolete">&amp;Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;&lt;</source>
        <translation type="obsolete">&lt;&lt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&gt;&gt;</source>
        <translation type="obsolete">&gt;&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OK</source>
        <translation type="obsolete">Ok</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Não</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To</source>
        <translation type="obsolete">Até</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X:</source>
        <translation type="obsolete">X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>cm</source>
        <translation type="obsolete">cm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ff</source>
        <translation type="obsolete">ff</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>fi</source>
        <translation type="obsolete">fi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>fl</source>
        <translation type="obsolete">fl</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ft</source>
        <translation type="obsolete">ft</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>in</source>
        <translation type="obsolete">pol</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>st</source>
        <translation type="obsolete">st</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>to</source>
        <translation type="obsolete">para</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> cm</source>
        <translation type="obsolete"> cm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> in</source>
        <translation type="obsolete"> pol</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> mm</source>
        <translation type="obsolete"> mm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> ms</source>
        <translation type="obsolete"> cm</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> px</source>
        <translation type="obsolete"> px </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;&lt;&lt;</source>
        <translation type="obsolete">&amp;&lt;&lt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;&gt;&gt;</source>
        <translation type="obsolete">&amp;&gt;&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Ok</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Não</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2A0</source>
        <translation type="obsolete">2A0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>4A0</source>
        <translation type="obsolete">4A0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All</source>
        <translation type="obsolete">Todos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt</source>
        <translation type="obsolete">Alt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>DLE</source>
        <translation type="obsolete">DLE</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>DPI</source>
        <translation type="obsolete">DPI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Box</source>
        <translation type="obsolete">Caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>DX:</source>
        <translation type="obsolete">DX:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>DY:</source>
        <translation type="obsolete">DY:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cut</source>
        <translation type="obsolete">Cortar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dir</source>
        <translation type="obsolete">Dir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc</source>
        <translation type="obsolete">Doc</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dot</source>
        <translation type="obsolete">Ponto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hex</source>
        <translation type="obsolete">Hex</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hue</source>
        <translation type="obsolete">Matiz</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low</source>
        <translation type="obsolete">Baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>May</source>
        <translation type="obsolete">Maio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF</source>
        <translation type="obsolete">PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New</source>
        <translation type="obsolete">Novo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Old</source>
        <translation type="obsolete">Antigo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To:</source>
        <translation type="obsolete">para:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply unbreakable space on:</source>
        <translation type="obsolete">Aplicar espaço não separável em:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top</source>
        <translation type="obsolete">Topo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use</source>
        <translation type="obsolete">Usar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Sim</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>and</source>
        <translation type="obsolete">e</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ffi</source>
        <translation type="obsolete">ffi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ffl</source>
        <translation type="obsolete">ffl</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>min</source>
        <translation type="obsolete">min</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>sum</source>
        <translation type="obsolete">a soma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>to:</source>
        <translation type="obsolete">a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Destination</source>
        <translation type="obsolete">Destino</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> dpi</source>
        <translation type="obsolete"> dpi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> pt </source>
        <translation type="obsolete"> pt </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> sec</source>
        <translation type="obsolete"> sec</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;50%</source>
        <translation type="obsolete">&amp;50%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;75%</source>
        <translation type="obsolete">&amp;75%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Adicionar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Novo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Run</source>
        <translation type="obsolete">Executa&amp;r</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;X1:</source>
        <translation type="obsolete">&amp;X1:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Y2:</source>
        <translation type="obsolete">&amp;Y2:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Sim</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;dd</source>
        <translation type="obsolete">A&amp;dicionar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+</source>
        <translation type="obsolete">Alt+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Back</source>
        <translation type="obsolete">Voltar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Auto</source>
        <translation type="obsolete">Automático</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Blur</source>
        <translation type="obsolete">Desfoque</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cu&amp;t</source>
        <translation type="obsolete">Cor&amp;tar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Date</source>
        <translation type="obsolete">Data</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ctrl</source>
        <translation type="obsolete">Ctrl</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cyan</source>
        <translation type="obsolete">Ciano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit</source>
        <translation type="obsolete">Editar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>End:</source>
        <translation type="obsolete">Fim:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File</source>
        <translation type="obsolete">Ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Find</source>
        <translation type="obsolete">Localizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font</source>
        <translation type="obsolete">Fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gap:</source>
        <translation type="obsolete">&amp;Espaço:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV:</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From</source>
        <translation type="obsolete">De</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Goto</source>
        <translation type="obsolete">Ir para</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>High</source>
        <translation type="obsolete">Alta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icon</source>
        <translation type="obsolete">Ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>July</source>
        <translation type="obsolete">Julho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>June</source>
        <translation type="obsolete">Junho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left</source>
        <translation type="obsolete">Esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line</source>
        <translation type="obsolete">Linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Link</source>
        <translation type="obsolete">Ligação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load</source>
        <translation type="obsolete">Carregar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock</source>
        <translation type="obsolete">Bloquear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Main</source>
        <translation type="obsolete">Principal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Meta</source>
        <translation type="obsolete">Meta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move</source>
        <translation type="obsolete">Mover</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>None</source>
        <translation type="obsolete">Nenhum</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open</source>
        <translation type="obsolete">Abrir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page</source>
        <translation type="obsolete">Página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Path</source>
        <translation type="obsolete">Caminho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB:</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Post</source>
        <translation type="obsolete">Posters</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Push</source>
        <translation type="obsolete">Apertar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Se&amp;t</source>
        <translation type="obsolete">Defin&amp;ir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save</source>
        <translation type="obsolete">Salvar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Size</source>
        <translation type="obsolete">Tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Skip</source>
        <translation type="obsolete">Ignorar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sort</source>
        <translation type="obsolete">Ordenar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X&amp;2:</source>
        <translation type="obsolete">X&amp;2:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Star</source>
        <translation type="obsolete">Estrela</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text</source>
        <translation type="obsolete">Texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thai</source>
        <translation type="obsolete">Tailandês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thin</source>
        <translation type="obsolete">Estreito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Time</source>
        <translation type="obsolete">Hora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top:</source>
        <translation type="obsolete">Cimo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y&amp;1:</source>
        <translation type="obsolete">Y&amp;1:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Tipo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User</source>
        <translation type="obsolete">Usuário</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Wide</source>
        <translation type="obsolete">Largo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Wiki</source>
        <translation type="obsolete">Wiki</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Wipe</source>
        <translation type="obsolete">Apagar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zoom</source>
        <translation type="obsolete">Ampliar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>html</source>
        <translation type="obsolete">html</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>page</source>
        <translation type="obsolete">página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>with</source>
        <translation type="obsolete">com</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set style on a non-text frame.</source>
        <translation type="obsolete">Não é possível configurar um estilo em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shortcut for Selected Action</source>
        <translation type="obsolete">Atalho para a acção seleccionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select for easier reading of light colored text styles</source>
        <translation type="obsolete">Seleccione para uma leitura mais fácil dos estilos de texto que usam cores claras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing: %1</source>
        <translation type="obsolete">Importando texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set start arrow</source>
        <translation type="obsolete">Define a seta de início</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Move para seu directório de documentos.
Isto pode ser definido nas Preferências.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">Comando &amp;alternativo para impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Font found, checking...</source>
        <translation type="obsolete">Nova fonte encontrada, analisando...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alternative Printer Command</source>
        <translation type="obsolete">Comando &amp;alternativo para impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Strikethru</source>
        <translation type="obsolete">Riscado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Get Field Names</source>
        <translation type="obsolete">&amp;Obter os nomes dos campos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages</source>
        <translation type="obsolete">Organizar as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Preview</source>
        <translation type="obsolete">Visualizar impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Short &amp;Words...</source>
        <translation type="obsolete">&amp;Abreviaturas...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Offset to baseline of characters</source>
        <translation type="obsolete">Espaço entre a pauta e os caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start searching</source>
        <translation type="obsolete">Iniciar procura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Could not open output file %1</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro de saída: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot collect the file: 
%1</source>
        <translation type="obsolete">Não foi possível recolher o ficheiro:
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Freetype2 library not available</source>
        <translation type="obsolete">A biblioteca Freetype2 não está disponível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Directory</source>
        <translation type="obsolete">Pesquise um directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Build ID:</source>
        <translation type="obsolete">ID da versão:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User settings</source>
        <translation type="obsolete">Configurações de utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 pt</source>
        <translation type="obsolete">%1 pt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;tyles...</source>
        <translation type="obsolete">E&amp;stilos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>F&amp;ill Color:</source>
        <translation type="obsolete">Cor do preench&amp;imento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;100%</source>
        <translation type="obsolete">&amp;100%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;200%</source>
        <translation type="obsolete">&amp;200%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Copiar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Done</source>
        <translation type="obsolete">&amp;Feito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Edit</source>
        <translation type="obsolete">&amp;Editar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+strikeout </source>
        <translation type="obsolete">+riscado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Sair</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;File</source>
        <translation type="obsolete">&amp;Ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font</source>
        <translation type="obsolete">&amp;Fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Gap:</source>
        <translation type="obsolete">&amp;Espaço:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Help</source>
        <translation type="obsolete">&amp;Ajuda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Item</source>
        <translation type="obsolete">&amp;Item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Left</source>
        <translation type="obsolete">&amp;Esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Load</source>
        <translation type="obsolete">&amp;Abrir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Misc</source>
        <translation type="obsolete">&amp;Misc</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Move</source>
        <translation type="obsolete">&amp;Mover</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Open</source>
        <translation type="obsolete">&amp;Abrir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Page</source>
        <translation type="obsolete">&amp;Página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Red:</source>
        <translation type="obsolete">Ve&amp;rmelho:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Redo</source>
        <translation type="obsolete">&amp;Refazer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quit</source>
        <translation type="obsolete">&amp;Sair</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Sat:</source>
        <translation type="obsolete">&amp;Sat:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Save</source>
        <translation type="obsolete">&amp;Salvar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Size</source>
        <translation type="obsolete">&amp;Tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Text</source>
        <translation type="obsolete">&amp;Texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Tile</source>
        <translation type="obsolete">&amp;Lado-a-lado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Top:</source>
        <translation type="obsolete">&amp;Superior:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Undo</source>
        <translation type="obsolete">&amp;Desfazer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Val:</source>
        <translation type="obsolete">&amp;Val:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;View</source>
        <translation type="obsolete">&amp;Visualizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>filename</source>
        <translation type="obsolete">nome de ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>(TAB)</source>
        <translation type="obsolete">(TAB)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Antialias text for EPS and PDF onscreen rendering</source>
        <translation type="obsolete">Suaviza o texto para a renderização no ecrã de EPS e PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Compress File</source>
        <translation type="obsolete">&amp;Compactar o ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-strikeout </source>
        <translation type="obsolete">-riscado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load the selected shortcut set</source>
        <translation type="obsolete">Carrega o conjunto de teclas de atalho selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Prepend Currency Symbol</source>
        <translation type="obsolete">Adicionar à frente do símbolo da moeda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Annotation P&amp;roperties</source>
        <translation type="obsolete">P&amp;ropriedades da anotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Images:</source>
        <translation type="obsolete">Imagens:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set fill color transparency</source>
        <translation type="obsolete">Define a cor de preenchimento da transparência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation type="obsolete">A fonte %1 possui caracteres %2 problemáticos (charcode%3)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add Bookmark</source>
        <translation type="obsolete">&amp;Adicionar marcador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loads a curve</source>
        <translation type="obsolete">Carrega uma curva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page &amp;Number</source>
        <translation type="obsolete">Página &amp;número</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Submit Form</source>
        <translation type="obsolete">Enviar formulário</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Update Text Frame and Exit</source>
        <translation type="obsolete">At&amp;ualizar o quadro de texto e sair</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Limit of</source>
        <translation type="obsolete">Limite de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview Settings</source>
        <translation type="obsolete">Configurações de visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source and target are the same object.</source>
        <translation type="obsolete">A origem e o destino são os mesmos objetos.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Text Control Characters</source>
        <translation type="obsolete">Mostrar invisíveis de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation type="obsolete">Adiciona uma seção numérica de página ao documento. A nova seção será adicionada após a atual seleção.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>E&amp;xit</source>
        <translation type="obsolete">Sai&amp;r</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK:</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align</source>
        <translation type="obsolete">Alinhar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+B</source>
        <translation type="obsolete">Alt+B</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+X</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+E</source>
        <translation type="obsolete">Alt+E</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+H</source>
        <translation type="obsolete">Alt+H</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+K</source>
        <translation type="obsolete">Alt+K</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+M</source>
        <translation type="obsolete">Alt+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+N</source>
        <translation type="obsolete">Alt+N</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+O</source>
        <translation type="obsolete">Alt+O</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+U</source>
        <translation type="obsolete">Alt+U</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+W</source>
        <translation type="obsolete">Alt+W</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+Y</source>
        <translation type="obsolete">Alt+Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle</source>
        <translation type="obsolete">Ângulo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply</source>
        <translation type="obsolete">Aplicar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>April</source>
        <translation type="obsolete">Abril</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Black</source>
        <translation type="obsolete">Preto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Block</source>
        <translation type="obsolete">Bloco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cards</source>
        <translation type="obsolete">Cartões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check</source>
        <translation type="obsolete">X</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clear</source>
        <translation type="obsolete">Limpar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clone</source>
        <translation type="obsolete">Clonar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Close</source>
        <translation type="obsolete">Fechar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color</source>
        <translation type="obsolete">Cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comma</source>
        <translation type="obsolete">Vírgula</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Date:</source>
        <translation type="obsolete">Data:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cross</source>
        <translation type="obsolete">Cruz</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Crown</source>
        <translation type="obsolete">Coroa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ctrl+</source>
        <translation type="obsolete">Ctrl+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Binding:</source>
        <translation type="obsolete">&amp;Encadernação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Czech</source>
        <translation type="obsolete">Tcheco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dutch</source>
        <translation type="obsolete">Holandês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reload the default Scribus shortcuts</source>
        <translation type="obsolete">Recarrega o padrão de teclas de atalhos do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Email</source>
        <translation type="obsolete">E-mail</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error</source>
        <translation type="obsolete">Erro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saving PDF</source>
        <translation type="obsolete">Salvando PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>On Focus</source>
        <translation type="obsolete">On focus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Folds</source>
        <translation type="obsolete">Dobras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font:</source>
        <translation type="obsolete">Fonte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts</source>
        <translation type="obsolete">Fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Formulário1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Placement</source>
        <translation type="obsolete">Colocação da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dingbats</source>
        <translation type="obsolete">Bobeiras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From:</source>
        <translation type="obsolete">De:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Go To</source>
        <translation type="obsolete">Ir para</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Greek</source>
        <translation type="obsolete">Grego</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Group</source>
        <translation type="obsolete">Agrupar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guide</source>
        <translation type="obsolete">Guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hu&amp;e:</source>
        <translation type="obsolete">&amp;Matiz:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icons</source>
        <translation type="obsolete">Ícones</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>In&amp;fo</source>
        <translation type="obsolete">In&amp;formações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image</source>
        <translation type="obsolete">Imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move to back</source>
        <translation type="obsolete">Move para trás</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Minimize</source>
        <translation type="obsolete">Minimizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inset</source>
        <translation type="obsolete">Recuada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute left sides equidistantly</source>
        <translation type="obsolete">Distribuir os lados esquerdos uniformemente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Items</source>
        <translation type="obsolete">Ítems</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R&amp;ound
Corners:</source>
        <translation type="obsolete">C&amp;antos
Arredondados:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="obsolete">Imprimir camada - desassinale para desactivar a impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>An object with the requested name already exists.</source>
        <translation type="obsolete">Já existe um objeto com o nome requisitado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Latin</source>
        <translation type="obsolete">Latim</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Even Pages</source>
        <translation type="obsolete">Páginas pares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left:</source>
        <translation type="obsolete">Esquerda:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Legal</source>
        <translation type="obsolete">Ofício</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Level</source>
        <translation type="obsolete">Nível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lines</source>
        <translation type="obsolete">Linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>March</source>
        <translation type="obsolete">Março</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Marks</source>
        <translation type="obsolete">Miras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Luminosity</source>
        <translation type="obsolete">Luminosidade</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Menus</source>
        <translation type="obsolete">Menus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Meta+</source>
        <translation type="obsolete">Meta+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name:</source>
        <translation type="obsolete">Nome:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Even Pages only</source>
        <translation type="obsolete">Somente páginas pares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Never</source>
        <translation type="obsolete">Nunca</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Nodes</source>
        <translation type="obsolete">Nós</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page </source>
        <translation type="obsolete">Página </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page:</source>
        <translation type="obsolete">Página:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paste</source>
        <translation type="obsolete">Colar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paths</source>
        <translation type="obsolete">Caminhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Other</source>
        <translation type="obsolete">Outro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;ype</source>
        <translation type="obsolete">T&amp;ipo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plain</source>
        <translation type="obsolete">Texto simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print</source>
        <translation type="obsolete">Imprimir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File %1 is not in an acceptable format</source>
        <translation type="obsolete">O ficheiro %1 não está num formato aceitável</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert PDF Push Button</source>
        <translation type="obsolete">Inserir um botão de acção PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range</source>
        <translation type="obsolete">Intervalo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">O perfil de cores que gerou ou recebeu do fabricante.
Este perfil deve ser específico para o seu monitor e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ready</source>
        <translation type="obsolete">Pronto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quote</source>
        <translation type="obsolete">Citação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset</source>
        <translation type="obsolete">Reconfigurar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right</source>
        <translation type="obsolete">Direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Round</source>
        <translation type="obsolete">Arredondado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>3rd. Split</source>
        <translation type="obsolete">3° Separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shade</source>
        <translation type="obsolete">Intensidade</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shape</source>
        <translation type="obsolete">Forma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>4th. Split</source>
        <translation type="obsolete">4° Separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shift</source>
        <translation type="obsolete">Shift</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shown</source>
        <translation type="obsolete">Exibir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Inside:</source>
        <translation type="obsolete">&amp;Interna:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>1st. Split</source>
        <translation type="obsolete">1° Separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inside:</source>
        <translation type="obsolete">Interna:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Signs</source>
        <translation type="obsolete">Letreiros</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2nd. Split</source>
        <translation type="obsolete">2° Separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Size:</source>
        <translation type="obsolete">Tamanho:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exiting now.</source>
        <translation type="obsolete">Saindo agora.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solid</source>
        <translation type="obsolete">Sólido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>En Space</source>
        <translation type="obsolete">Espaço en</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Space</source>
        <translation type="obsolete">Espaço</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Split</source>
        <translation type="obsolete">Separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start</source>
        <translation type="obsolete">Início</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>instead</source>
        <translation type="obsolete">no lugar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Integer</source>
        <translation type="obsolete">Numérico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style</source>
        <translation type="obsolete">Estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text:</source>
        <translation type="obsolete">Texto:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To&amp;p:</source>
        <translation type="obsolete">&amp;Superior:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tools</source>
        <translation type="obsolete">Ferramentas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type:</source>
        <translation type="obsolete">Tipo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value</source>
        <translation type="obsolete">Valor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Usage</source>
        <translation type="obsolete">Uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Even pages</source>
        <translation type="obsolete">Páginas par&amp;es</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>There are no fonts found on your system.</source>
        <translation type="obsolete">Não foram encontradas fontes no seu sistema.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Welsh</source>
        <translation type="obsolete">Galês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clear All Text</source>
        <translation type="obsolete">Apagar todo o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width</source>
        <translation type="obsolete">Largura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation type="obsolete">Desenha setas para reafirmar o espaço próximo ao código</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thin Space</source>
        <translation type="obsolete">Espaço fino</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>1, 2, 3, ...</source>
        <translation type="obsolete">1, 2, 3, ...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>a, b, c, ...</source>
        <translation type="obsolete">a, b, c, ...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A, B, C, ...</source>
        <translation type="obsolete">A, B, C, ...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation type="obsolete">Algumas fonte utilizadas por este documento foram substituidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of hexadecimal characters</source>
        <translation type="obsolete">Número variável de caracteres hexadecimais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing failed</source>
        <translation type="obsolete">A importação falhou</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Name of Executable:</source>
        <translation type="obsolete">&amp;Nome do executável:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Line Styles...</source>
        <translation type="obsolete">Estilos de &amp;linha...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initializing...</source>
        <translation type="obsolete">Iniciando...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Display</source>
        <translation type="obsolete">Exibir página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Target frame links to another frame.</source>
        <translation type="obsolete">O quadro alvo associa-se a outro quadro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Information</source>
        <translation type="obsolete">Informação de página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a scrapbook file to import</source>
        <translation type="obsolete">Seleccione um ficheiro de Bloco de Rascunhos a importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left Guillemet</source>
        <translation type="obsolete">Guillemet dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation type="obsolete">O Scribus não conseguiu carregar estas preferências:&lt;br&gt;%1&lt;br&gt;As configurações padrões serão carregadas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>memcpy table: %1 %2 %3</source>
        <translation type="obsolete">tabela do memcpy : %1 %2 %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>words</source>
        <translation type="obsolete">palavras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation type="obsolete">Não foi possível encontrar a cor requisitada. Você provavelmente selecionou a cor preta, cinza ou branca. Não há maneiras de processar essas cores.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Join style</source>
        <translation type="obsolete">Sem estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shear the Path Vertically Down</source>
        <translation type="obsolete">Deforma o caminho verticalmente para baixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Transparency used</source>
        <translation type="obsolete">Transparência utilizada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align Text Left</source>
        <translation type="obsolete">Alinhar o texto à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not use custom line style</source>
        <translation type="obsolete">Não utiliza estilos de linhas personalizados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>January</source>
        <translation type="obsolete">Janeiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font height</source>
        <translation type="obsolete">Definir altura da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Automatic &amp;Line Spacing</source>
        <translation type="obsolete">Espaçamento automático de &amp;linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copyright:</source>
        <translation type="obsolete">Direitos de autor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to Scrapbook</source>
        <translation type="obsolete">Enviar para o Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Opções...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Size of the selected font</source>
        <translation type="obsolete">Tamanho da fonte selecionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation type="obsolete">Tamanho da página, pode ser um tamanho padrão ou personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cyrillic</source>
        <translation type="obsolete">Cirílico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display Layers Tab</source>
        <translation type="obsolete">Exibir aba de camadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of digits</source>
        <translation type="obsolete">Número de dígitos variáveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color not found.</source>
        <translation type="obsolete">Cor não encontrada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Target frame is linked to by another frame.</source>
        <translation type="obsolete">O quadro alvo está associado a outro quadro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Save to File...</source>
        <translation type="obsolete">&amp;Salvar para ficheiro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Disabled</source>
        <translation type="obsolete">Desabilitado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla *.sla.gz *.scd *.scd.gz);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The following programs are missing:</source>
        <translation type="obsolete">Os seguintes programas estão faltando:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Bezier Curve</source>
        <translation type="obsolete">Inserir uma curva de Bezier</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Baseline offset</source>
        <translation type="obsolete">&amp;Deslocamento da pauta:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not show this dialog again</source>
        <translation type="obsolete">Não exibir esta janela novamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output &amp;Profile:</source>
        <translation type="obsolete">&amp;Perfil de saída:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a filename to open</source>
        <translation type="obsolete">Escolha um nome de ficheiro para abrir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default Character Style</source>
        <translation type="obsolete">Estilo de caracter padrão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color %1 appended.</source>
        <translation type="obsolete">A cor  %1 foi adicionada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keep aspect ratio</source>
        <translation type="obsolete">Manter proporção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keep the X and Y scaling the same</source>
        <translation type="obsolete">Mantém a mesma escala entre X e Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>List Box</source>
        <translation type="obsolete">Caixa de listagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Editar o texto com o Editor de História</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Collecting...</source>
        <translation type="obsolete">Recolhendo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Italian</source>
        <translation type="obsolete">Italiano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Write: %1</source>
        <translation type="obsolete">Escrever: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to lose all your changes?</source>
        <translation type="obsolete">Você realmente deseja perder todas as suas alterações?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports SVG Files</source>
        <translation type="obsolete">Importa ficheiros SVG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dissolve</source>
        <translation type="obsolete">Dissolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Page</source>
        <translation type="obsolete">Página esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The item %1 is currently being edited by Story Editor. The convert to outlines operation for this item will be skipped</source>
        <translation type="obsolete">O item %1 está atualmente sendo editado pelo Editor de História. A operação de conversão para traços será ignorada para este item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Starting position for the box and split effects.</source>
        <translation type="obsolete">Posição inicial dos efeitos Caixa e Separação.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Currency Symbol</source>
        <translation type="obsolete">Usar símbolo de moeda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation type="obsolete">Este documento não parece ser um ficheiro do OpenOffice Draw.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exports SVG Files</source>
        <translation type="obsolete">Exporta ficheiros SVG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selected Page Border:</source>
        <translation type="obsolete">Borda de página seleccionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style Settings</source>
        <translation type="obsolete">Configurações do estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Vision</source>
        <translation type="obsolete">Visão normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror the Path Horizontally</source>
        <translation type="obsolete">Espelha o caminho horizontalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Import Page(s):</source>
        <translation type="obsolete">&amp;Importar página(s):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation type="obsolete">Activa/Desabilita a visualização da tinta M (Magenta)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal displacement of page items</source>
        <translation type="obsolete">Deslocação horizontal dos itens de página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>First line indent</source>
        <translation type="obsolete">Indentação da primeira linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation type="obsolete">O caminho de busca das fontes só pode ser configurado pelas Preferências e apenas quando não há documentos abertos.
 Feche todos os documentos e então use o menu Ficheiro-&gt;Preferências-&gt;Fontes para alterar o caminho de busca das fontes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The filename should not be empty string.</source>
        <translation type="obsolete">O nome do ficheiro não deve ser nulo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Portuguese (BR)</source>
        <translation type="obsolete">Português (BR)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Chan&amp;ge...</source>
        <translation type="obsolete">&amp;Alterar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Seleciona o ponto-base abaixo e à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Using Ghostscript version %1</source>
        <translation type="obsolete">Usando a versão %1 do GhostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User configuration exists elready. Do you really want to overwrite it?</source>
        <translation type="obsolete">Já existe uma configuração do utilizador. Você realmente deseja sobrescrevê-la?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation type="obsolete">O texto &amp;flui à volta da caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The filename must be a string.</source>
        <translation type="obsolete">O nome do ficheiro deve ser uma sequência de caracteres.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font effect</source>
        <translation type="obsolete">Definir efeito de fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line style not found.</source>
        <translation type="obsolete">Estilo de linha não encontrado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;User Defined Key</source>
        <translation type="obsolete">Tecla definida pelo &amp;utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to save document.</source>
        <translation type="obsolete">Não foi possível salvar o documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Field P&amp;roperties</source>
        <translation type="obsolete">Propriedades do &amp;campo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Types matched, but setting property failed.</source>
        <translation type="obsolete">Os tipos se casam, mas a configuração de propriedade falhou.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use ICC Profile</source>
        <translation type="obsolete">Usar perfil ICC</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Smart &amp;Hyphen</source>
        <translation type="obsolete">&amp;Hifenização inteligente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin Manager</source>
        <translation type="obsolete">Gestão de plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polygon Drawing Properties</source>
        <translation type="obsolete">Propriedades do desenho de polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation type="obsolete">Um resumo do conteúdo do documento.Esse campo é usado para uma descrição breve ou um resumo do documento. Ele é Incorporado ao PDF durante a exportação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hide Viewers Menubar</source>
        <translation type="obsolete">Ocultar visualização da barra do menu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow &amp;Changing the Document</source>
        <translation type="obsolete">Permite a &amp;alteração no documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing text</source>
        <translation type="obsolete">Importando texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Profile Name:</source>
        <translation type="obsolete">Nome do perfil:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export successful</source>
        <translation type="obsolete">A exportação foi bem-sucedida.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output profile for printing. If possible, get some guidance from your printer on profile selection.</source>
        <translation type="obsolete">Perfil de saída para impressão. Se possível, obtenha alguma referência da sua impressora na seleção do perfil.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paste Recent</source>
        <translation type="obsolete">Colar &amp;recente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Keywords:</source>
        <translation type="obsolete">&amp;Palavras-chave:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Generate PDF Articles, which is useful for navigating linked articles in a PDF.</source>
        <translation type="obsolete">Gera Artigos PDF, que são úteis para navegar por artigos associados em um PDF.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keywords:</source>
        <translation type="obsolete">Palavras-chave:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bezier curve</source>
        <translation type="obsolete">Curva de Bezier</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation type="obsolete">&amp;Definir cores personalizadas &gt;&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Document</source>
        <translation type="obsolete">Novo documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color profile for solid colors</source>
        <translation type="obsolete">Perfil de cores para cores sólidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">&amp;Seleccione ficheiro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tab Fill Character:</source>
        <translation type="obsolete">Preenchimento de caracter:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">O perfil de cores do fabricante para o seu modelo de impressora.
Este perfil deve ser específico para a sua impressora e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line S&amp;tyle:</source>
        <translation type="obsolete">Es&amp;tilos de linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="obsolete">Diferença entre o valor selecionado e o contado. Veja a documentação para maiores detalhes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guides are visible above all objects on the page</source>
        <translation type="obsolete">AS guias são visíveis através de objetos na página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a file to import</source>
        <translation type="obsolete">Seleccione um ficheiro para importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>remove match</source>
        <translation type="obsolete">remover correspondência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation type="obsolete">Activar isso irá sobrescrever os estilos existentes no documento atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Full Color Blindness</source>
        <translation type="obsolete">Perda de total da perc. de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Path Text Properties</source>
        <translation type="obsolete">Propriedades do caminho do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quick Search:</source>
        <translation type="obsolete">Busca &amp;rápida:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>size %1 </source>
        <translation type="obsolete">tamanho %1 </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Deselect All</source>
        <translation type="obsolete">&amp;Deselecionar tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation type="obsolete">Deforma o caminho horizontalmente para a direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Tabulators...</source>
        <translation type="obsolete">&amp;Tabulações...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number Forms</source>
        <translation type="obsolete">Formulários numéricos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line: %1 Column: %2</source>
        <translation type="obsolete">Linhas: %1, Colunas: %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Story Editor</source>
        <translation type="obsolete">Editor de História</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Import Master Page</source>
        <translation type="obsolete">&amp;Importar Página Mestre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal</source>
        <translation type="obsolete">Horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation type="obsolete">A gravação do ficheiro de preferências &quot;%1&quot; falhou: QIODevice, código de status %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number Format</source>
        <translation type="obsolete">Formato do número</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sn&amp;ap to Grid</source>
        <translation type="obsolete">&amp;Atrair à grelha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Can&apos;t get info from a non-text frame</source>
        <translation type="obsolete">Não é possível obter informações de um quadro que não seja de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2nd. Tetradic (angle)</source>
        <translation type="obsolete">2° Quadritônico (ângulo)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change settings for left or end points</source>
        <translation type="obsolete">Altera as configurações para os pontos esquerdos ou finais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start Arrow:</source>
        <translation type="obsolete">Seta inicial:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin: %1 initialized ok </source>
        <translation type="obsolete">Plugin: %1 iniciado sem erros</translation>
    </message>
    <message>
        <location filename="../plugins/fileloader/scribus12format/scribus12format.cpp" line="1593"/>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Copiar #%1 de </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Master Pages</source>
        <translation type="obsolete">Editar páginas modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left Guillemet</source>
        <translation type="obsolete">Guillemet simples à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Barcode Generator</source>
        <translation type="obsolete">Gerador de código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption overlays Icon</source>
        <translation type="obsolete">Legenda sobreposta ao ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">Número de &amp;cópias:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal:</source>
        <translation type="obsolete">Horizontal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontals</source>
        <translation type="obsolete">Horizontais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image size in Pixels</source>
        <translation type="obsolete">Tamanho da imagem em pixels</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>German (Trad.)</source>
        <translation type="obsolete">Alemão (Tradi.)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview of the Paragraph Style</source>
        <translation type="obsolete">Visualizar o estilo de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir o alinhamento de texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Bookmark</source>
        <translation type="obsolete">Novo marcador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering Settings</source>
        <translation type="obsolete">Configurações de renderização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flip Horizontal</source>
        <translation type="obsolete">Espelhamento horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <translation type="obsolete">&lt;pdfVersion&gt; inválido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Startup Script:</source>
        <translation type="obsolete">Script de inicialização:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No object frame</source>
        <translation type="obsolete">Moldura sem objecto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check Style:</source>
        <translation type="obsolete">Estilo da marca:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Disable Item Printing</source>
        <translation type="obsolete">Desactivar impressão do item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default ICC profiles directory. This cannot be changed with a document open. By default, Scribus will look in the System Directories under Mac OSX and Windows. On Linux and Unix, Scribus will search $home/.color/icc,/usr/share/color/icc and /usr/local/share/color/icc </source>
        <translation type="obsolete">Diretório padrão dos perfis ICC. Isto não pode ser alterado com um documento aberto. Por padrão, o Scribus irá procurar nos diretórios do sistema no MAC OSX e no Windows. No Linux e no Unix, o Scribus irá procurar em $home/.color/icc,/usr/share/color/icc e /usr/local/share/color/icc</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Smart Hyphen</source>
        <translation type="obsolete">Inserir Hifenização inteligente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Absolute Colorimetric</source>
        <translation type="obsolete">Absoluta Colorimétrica</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The template creator should also make sure that the Installing Templates section above applies to their templates as well. This means a user should be able to download a template package and be able to extract them to the template directory and start using them.</source>
        <translation type="obsolete">O criador de modelo também deve certificar-se de que a seção Instalando Modelos acima aplica-se também ao seus modelos. Isso significa que um utilizador deve ser capaz de transferir um pacote de modelo e ser capaz de extrai-lo ao directório de modelos e começar a usá-lo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zoom in or out</source>
        <translation type="obsolete">Amplia ou reduz a visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initializing Plugins</source>
        <translation type="obsolete">Iniciando plugins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You are trying to link to a filled frame, or a frame to itself.</source>
        <translation type="obsolete">Você está tentando ligar à um quadro preenchido ou ao próprio quadro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>German (Swiss)</source>
        <translation type="obsolete">Alemão (Suiço)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sort by &amp;Size</source>
        <translation type="obsolete">Ordenar por &amp;tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>An error occurred while looking for updates for Scribus, please check your internet connection.</source>
        <translation type="obsolete">Ocorreu um erro ao procurar actualizações para o Scribus, por favor verifique a sua ligação à internet:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Moving Lines:</source>
        <translation type="obsolete">Linhas &amp;móveis:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import styles from another document</source>
        <translation type="obsolete">Importar estilos doutro documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sort by &amp;Date</source>
        <translation type="obsolete">Ordenar por &amp;data</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sort by &amp;Name</source>
        <translation type="obsolete">Ordenar por &amp;nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align bottoms</source>
        <translation type="obsolete">Alinhar ao fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Previous Translation Contributors:</source>
        <translation type="obsolete">Colaboradores das traduções anteriores:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All items in document processed.</source>
        <translation type="obsolete">Todos os ítens do documento são processados.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable printing of layer</source>
        <translation type="obsolete">Activar impressão da camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="obsolete">Scribus - Sobre os Plug-ins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To File:</source>
        <translation type="obsolete">Para o ficheiro:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Standard configuration: </source>
        <translation type="obsolete">Configuração padrão: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comma Separated List</source>
        <translation type="obsolete">Lista de valores separados por vírgulas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Destroys the selected group</source>
        <translation type="obsolete">Apagar o grupo seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scribus Scripts</source>
        <translation type="obsolete">Scripts do &amp;Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Print</source>
        <translation type="obsolete">Sem impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Style</source>
        <translation type="obsolete">Sem estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Title</source>
        <translation type="obsolete">Sem título</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert all glyphs in the document to outlines.</source>
        <translation type="obsolete">Não é possível converter em contorno um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of copies: %1
Horizontal gap: %2
Vertical gap: %3</source>
        <translation type="obsolete">Números de cópias: %1
Deslocamento horizontal: %2
Deslocamento vertical: %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Importa a maioria dos ficheiros OpenOffice.org Draw para o documento actual, convertendo seus dados vectoriais em objectos do Scribus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unicode Search</source>
        <translation type="obsolete">Pesquisa Unicode</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dzongkha</source>
        <translation type="obsolete">Dzongkha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zoom in</source>
        <translation type="obsolete">Ampliar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Folder 1</source>
        <translation type="obsolete">Nova pasta 1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Free Objects</source>
        <translation type="obsolete">Objetos livres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Strike Through</source>
        <translation type="obsolete">Risca&amp;do</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Master Pages</source>
        <translation type="obsolete">Todas as páginas Modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed a color profile for solid colors</source>
        <translation type="obsolete">Incorpora um perfil de cores para cores sólidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Original Font</source>
        <translation type="obsolete">Fonte original</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Normal Resolution</source>
        <translation type="obsolete">&amp;Média resolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Master Pages</source>
        <translation type="obsolete">Páginas Mestre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Master Page:</source>
        <translation type="obsolete">Página modelo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Master Page </source>
        <translation type="obsolete">Página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy an existing template.xml to a file called template.lang_COUNTRY.xml (use the same lang code that is present in the qm file for your language), for example template.fi.xml for Finnish language template.xml. The copy must be located in the same directory as the original template.xml so Scribus can load it.</source>
        <translation type="obsolete">Copie um template.xml existente para um ficheiro chamado template.idioma_PAÍS.xml (use o mesmo código de idioma que está presente no ficheiro qm do seu idioma). Por exemplo, template.fi.xml para o idioma finlandês. A cópia deve estar localizada no mesmo directório do template.xml original assim, o Scribus poderá abri-la.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Resolution:</source>
        <translation type="obsolete">&amp;Resolução:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Use Encryption</source>
        <translation type="obsolete">&amp;Usar criptografia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement below the baseline of the normal font on a line</source>
        <translation type="obsolete">Deslocamento da fonte abaixo da pauta em uma linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drop cap offset</source>
        <translation type="obsolete">Capitulação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No style</source>
        <translation type="obsolete">Sem estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for used transparencies</source>
        <translation type="obsolete">Procurar as transparências utilizadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Short Words processing. Wait please...</source>
        <translation type="obsolete">Processando abreviaturas. Por favor, aguarde...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables the Preview Mode</source>
        <translation type="obsolete">Activa pré-visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You are running a development version of Scribus 1.3.x. The document you are working with was created in Scribus 1.2.x.  Saving the current file under 1.3.x renders it unable to be edited in Scribus 1.2.x versions. To preserve the ability to edit in 1.2.x, save this file under a different name and further edit the newly named file and the original will be untouched. Are you sure you wish to proceed with this operation?</source>
        <translation type="obsolete">Você está executando uma versão de desenvolvimento do Scribus 1.3.X. O documento com o qual você está trabalhando foi criado com o Scribus 1.2.3 ou anterior. O processo de salvamento tornará este ficheiro inutilizável no Scribus 1.2.3, ao menos que você use &apos;Ficheiro&apos; &gt; &apos;Salvar como&apos;. Tem acerteza que deseja prosseguir com essa operação?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <translation type="obsolete">A intensidade do preenchimento está fora do limite, deve ser &gt;=0 e &lt;=100.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation type="obsolete">Activar/Desactivar a visualização da tinta K (Preto)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Leave colors untouched</source>
        <translation type="obsolete">Não alterar as cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scanner Manufacturer:</source>
        <translation type="obsolete">Fabricante do digitalizador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print help (this message) and exit</source>
        <translation type="obsolete">Ajuda de impressão (essa mensagem) e sai</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. You can provide a common wild cards (*, ?, [...]) in your phrase. Examples: t* will list all fonts starting with t or T. *bold* will list all fonts with word bold, bolder etc. in the name.</source>
        <translation type="obsolete">Digite um nome de uma fonte para encontra-lá rapidamente. A busca é insensitiva à maiúsculas e minúsculas. Você pode usar funções como (*, ?, [...]) nas sua composição. Exemplos: t* listará todas as fontes começando com t ou T. &apos;Bold&apos; listará todas as fonte que possuam Bold em seu nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set kerning</source>
        <translation type="obsolete">Definir entre-letras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">Mudança &amp;horizontal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle of Rotation</source>
        <translation type="obsolete">Ângulo de rotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Bleed</source>
        <translation type="obsolete">Tal como a sangria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute bottoms equidistantly</source>
        <translation type="obsolete">Distribuir os fundos uniformemente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>EPS Files (*.eps);;All Files (*)</source>
        <translation type="obsolete">Ficheiros EPS (*.eps);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation type="obsolete">Importa as margens das impressoras disponíveis para o tamanho de página selecionado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Distância para sangria do lado esquerdo da página física</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin: %1 failed post initialization</source>
        <translation type="obsolete">Plugin: %1 falhou após a iniciação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unable to save pixmap</source>
        <translation type="obsolete">Não foi possível salvar a imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Management</source>
        <translation type="obsolete">Gestão de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus frontend for Pure Postscript Barcode Writer</source>
        <translation type="obsolete">Interface do Scribus para o criador de códigos de barras totalmente em Postscript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Profile:</source>
        <translation type="obsolete">Perfil atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation type="obsolete">O objeto é uma anotação ou campo PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of digits and capital letters</source>
        <translation type="obsolete">Número de dígitos variáveis e letras maiúsculas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="obsolete">Distância entre a guia da margem inferior e a borda da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character Palette</source>
        <translation type="obsolete">Paleta de Caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set text shade on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir a intensidade do texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+color </source>
        <translation type="obsolete">+cor </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stay on &amp;Top</source>
        <translation type="obsolete">Ficar no &amp;alto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Input Dialog</source>
        <translation type="obsolete">Diálogo de entrada:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flip Vertical</source>
        <translation type="obsolete">Espelhamento vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the minor grid lines</source>
        <translation type="obsolete">Distância entre as linhas da grelha menor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the major grid lines</source>
        <translation type="obsolete">Distância entre as linhas da grelha maior</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable the security features in your exported PDF. If you selected PDF 1.3, the PDF will be protected by 40 bit encryption. If you selected PDF 1.4, the PDF will be protected by 128 bit encryption. Disclaimer: PDF encryption is not as reliable as GPG or PGP encryption and does have some limitations.</source>
        <translation type="obsolete">Activa os recursos de segurança no seu PDF a ser exportado. Se você selecionar PDF 1.3, o PDF será protegido por uma criptografia de 40 bit. Se você selecionar PDF 1.4, o PDF será protegido por uma criptografia de 128 bit.Aviso: a criptografia PDF não é tão confiável quanto a encriptação GPG ou PGP e possui algumas limitações.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remember association</source>
        <translation type="obsolete">Lembrar da associação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mailing List</source>
        <translation type="obsolete">Lista de discussão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Gama de páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="obsolete">Apl&amp;icar em todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Console</source>
        <translation type="obsolete">Mostrar &amp;console</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of the style is not unique</source>
        <translation type="obsolete">Já existe um estilo com esse nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Seleciona o ponto-base acima e à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Info String:</source>
        <translation type="obsolete">Seqüência de &amp;informação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus detected some errors.
Consider using the Preflight Verifier  to correct them.</source>
        <translation type="obsolete">O Scribus detectou alguns erros.
Considere o uso do Verificador pré-vôo para corrigi-los.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Background</source>
        <translation type="obsolete">&amp;Plano de Fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get font of non-text frame.</source>
        <translation type="obsolete">Não é possível obter uma fonte de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Usar Compensação de &amp;Pontos Negros</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line color transparency</source>
        <translation type="obsolete">Define a cor da transparência da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Previe&amp;w</source>
        <translation type="obsolete">&amp;Visualizar impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Page</source>
        <translation type="obsolete">Página actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Govt. Letter</source>
        <translation type="obsolete">Carta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>12 or 13 digits</source>
        <translation type="obsolete">12 ou 13 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>11 or 12 digits</source>
        <translation type="obsolete">11 ou 12 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation type="obsolete">Aumenta o tamanho do caminho no percentual definido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow modifying of the PDF. If un-checked, modifying the PDF is prevented.</source>
        <translation type="obsolete">Permite a modificação do PDF. Se desmarcado, não se consegue modificá-lo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Run as Extension Script</source>
        <translation type="obsolete">Executa como script de extensão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>paragraphs starting with</source>
        <translation type="obsolete">parágrafos começando com</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get text of non-text frame.</source>
        <translation type="obsolete">Não é possível obter um texto de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set text of non-text frame.</source>
        <translation type="obsolete">Não é possível configurar o texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Missing Font</source>
        <translation type="obsolete">Fonte ausente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation type="obsolete">Número de dígitos variáveis. Um ITF-14 possui 14 caracteres e não tem um dígito de checagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Inserir os caracteres no texto a partir do cursor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 is broken (no Face), discarding it</source>
        <translation type="obsolete">A fonte %1 foi descartada por apresentar problemas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> was replaced by: </source>
        <translation type="obsolete"> foi substituído por: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export as Image(s)</source>
        <translation type="obsolete">Exportar como imagem(ns)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image Frames</source>
        <translation type="obsolete">Quadros de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Settings</source>
        <translation type="obsolete">Configurações da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available export formats</source>
        <translation type="obsolete">Formatos de exportação disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>About Script</source>
        <translation type="obsolete">Sobre o script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Pages in Document:</source>
        <translation type="obsolete">Número de páginas no documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Camera Manufacturer:</source>
        <translation type="obsolete">Fabricante da câmera:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation type="obsolete">A fonte %1 possui problemas(FreeType2). Descartando-a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>English (American)</source>
        <translation type="obsolete">Inglês (Americano)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation type="obsolete">Quando selecionado as coordenadas são relativas à página,caso contrário as coordenadas são relativas ao objeto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hints and help is shown here</source>
        <translation type="obsolete">As Dicas e a ajuda é mostrada aqui</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke Color Settings</source>
        <translation type="obsolete">Configurações da cor da borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Background</source>
        <translation type="obsolete">Plano de Fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a Export Directory</source>
        <translation type="obsolete">Selecione o directório de exportação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The program %1 is already running!</source>
        <translation type="obsolete">O programa %1 já está em execução!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Announcements</source>
        <translation type="obsolete">Anúncios</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation type="obsolete">Rotaciona o caminho no sentido anti-horário</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>External Tools</source>
        <translation type="obsolete">Ferramentas externas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Block Elements</source>
        <translation type="obsolete">Elementos do bloco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot delete a color with an empty name.</source>
        <translation type="obsolete">Não é possível apagar uma cor sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>paragraph style</source>
        <translation type="obsolete">estilo de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Display CMYK</source>
        <translation type="obsolete">&amp;Mostrar CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open Python Script File</source>
        <translation type="obsolete">Abrir ficheiro de Script Python</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import Page(s)</source>
        <translation type="obsolete">Importar página(s)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc Page Range</source>
        <translation type="obsolete">Página dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Append selected font into Style, Font menu</source>
        <translation type="obsolete">Acrescenta a fonte selecionada no menu Estilo-&gt;Fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set fill color</source>
        <translation type="obsolete">Definir cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation type="obsolete">Activar essa opção fará com que o Scribus use essas fontes substitutas toda vez em que um documento possuir uma fonte perdida/faltante. Isto pode ser revertido ou alterado através do menu Editar &gt; Preferências &gt; Fontes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to export image</source>
        <translation type="obsolete">Não foi possível exportar a imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenOffice.org Draw (*.sxd *.odg);;All Files (*)</source>
        <translation type="obsolete">OpenOffice.org Draw (*.sxd*.odg);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Actual X-DPI:</source>
        <translation type="obsolete">X-DPI atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Web Safe RGB</source>
        <translation type="obsolete">RGB seguro para a Web</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Page Grid</source>
        <translation type="obsolete">Mostrar grelha de página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation type="obsolete">Versão para OS/2&amp;#174;/eComStation&amp;#8482;:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="obsolete">Converter separações (spot colors) em cores de processo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to clear all your text?</source>
        <translation type="obsolete">Você realmente deseja apagar todo o seu texto?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paragraph Style</source>
        <translation type="obsolete">Estilo do parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export As Image</source>
        <translation type="obsolete">Exportar como imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;qt&gt;File system location for graphics editor. If you use gimp and your distribution includes it, we recommend &apos;gimp-remote&apos;, as it allows you to edit the image in an already running instance of gimp.&lt;/qt&gt;</source>
        <translation type="obsolete">Localização no sistema de ficheiros do editor gráfico. Se você utiliza o Gimp e sua distribuição o inclui, recomendamos comando &apos;gimp-remote&apos;, já que ele permite que você edite a imagem em um instância já existente do Gimp.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation of color of fill</source>
        <translation type="obsolete">Saturação da cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle Left</source>
        <translation type="obsolete">Centro-esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.sla.gz);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla *.sla.gz);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Actual Y-DPI:</source>
        <translation type="obsolete">Y-DPI atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample Text</source>
        <translation type="obsolete">Texto de amostra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Barcode Creator</source>
        <translation type="obsolete">Gerador de código de barra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus has detected some errors. Consider using the Preflight Verifier to correct them</source>
        <translation type="obsolete">O Scribus detectou alguns erros. Considere o uso do Verificador pré-vôo para corrigi-los</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left</source>
        <translation type="obsolete">Esquerda simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Page</source>
        <translation type="obsolete">Página simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Text Frame Columns</source>
        <translation type="obsolete">Mostrar colunas de molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering intent for the image</source>
        <translation type="obsolete">Renderização pretendida para a imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Document:</source>
        <translation type="obsolete">Documento fonte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Parent Font</source>
        <translation type="obsolete">Usar fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Recent Scripts</source>
        <translation type="obsolete">Scripts &amp;recentes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance of text from bottom of frame</source>
        <translation type="obsolete">Distância entre o texto e a borda inferior do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed the bookmarks you created in your document. These are useful for navigating long PDF documents.</source>
        <translation type="obsolete">Incorpora os marcadores criados em seu documento. Eles são úteis para navegação em documentos PDF longos.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a master password which enables or disables all the security features in your exported PDF</source>
        <translation type="obsolete">Escolha uma senha mestra que habilite ou impeça todos os recursos de segurança no PDF exportado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>I&amp;mage Visible</source>
        <translation type="obsolete">I&amp;magem visível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Demy</source>
        <translation type="obsolete">Dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left</source>
        <translation type="obsolete">Dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation type="obsolete">Imagens (*.tif *.png *.jpg *.xpm);;PostScript (*.eps*.epsi);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Currency Symbols</source>
        <translation type="obsolete">Símbolos de moedas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paragraph Style:</source>
        <translation type="obsolete">Estilo do parágrafo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paragraph Styles</source>
        <translation type="obsolete">Estilos de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>External Web Browser Failed to Start</source>
        <translation type="obsolete">Falhou o lançamento do navegador web externo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scripter Preferences</source>
        <translation type="obsolete">Preferências do Scripter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Move o marcador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Normal</source>
        <translation type="obsolete">Impressão normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show page previews of each page listed above.</source>
        <translation type="obsolete">Mostra a visualização de cada uma das páginas listadas acima.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Centimeters (cm)</source>
        <translation type="obsolete">Centímetros (cm)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Middle</source>
        <translation type="obsolete">Normal centro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Crop Marks</source>
        <translation type="obsolete">Miras de corte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview of current Paragraph Style visible when editing Styles</source>
        <translation type="obsolete">Visualizar o estilo de parágrafo atual ao editar os estilos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color not found - python error</source>
        <translation type="obsolete">Cor não encontrada - erro python</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Invalid argument: </source>
        <translation type="obsolete">Argumento inválido: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>External Web-Link</source>
        <translation type="obsolete">Ligação externa Web</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y-Offset</source>
        <translation type="obsolete">Deslocamento-Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X-Offset</source>
        <translation type="obsolete">Deslocamento-X</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>the directory</source>
        <translation type="obsolete">o directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Whole Word</source>
        <translation type="obsolete">&amp;Palavra inteira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error when attempting to get update file: %1</source>
        <translation type="obsolete">Erro ao tentar actualizar o ficheiro %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle Right</source>
        <translation type="obsolete">Centro-direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-Page%1</source>
        <translation type="obsolete">-Página%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation type="obsolete">Falha no carregamento de fonte - o freetype2 não pode encontrar o ficheiro da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Seleccionar isto colocará a caixa no topo esquerdo, na posição 0,0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scale How:</source>
        <translation type="obsolete">Redimensionar como:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initializing Story Editor</source>
        <translation type="obsolete">Iniciando Editor de História</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Locate your image editor</source>
        <translation type="obsolete">Localização do editor de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>table &apos;%1&apos;</source>
        <translation type="obsolete">tabela &apos;%1&apos;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save Current Output</source>
        <translation type="obsolete">Salva a saída atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot write file %1.</source>
        <translation type="obsolete">Não é possível escrever o ficheiro %1.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit &amp;Contour Line</source>
        <translation type="obsolete">Editar a linha de &amp;contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get line space of non-text frame.</source>
        <translation type="obsolete">Não é possível obter a altura da linha em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Submit to URL:</source>
        <translation type="obsolete">Enviar para a URL:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1: %2</source>
        <translation type="obsolete">%1: %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Ponta achatada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Guard whitespace</source>
        <translation type="obsolete">&amp;Manter espaço livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenOffice.org Writer Documents</source>
        <translation type="obsolete">Documentos do OpenOffice.org Writer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character Settings</source>
        <translation type="obsolete">Configurações do caracter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ukranian</source>
        <translation type="obsolete">Ucraniano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Albanian</source>
        <translation type="obsolete">Albanês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relation:</source>
        <translation type="obsolete">&amp;Relação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Disable or enable this filter row</source>
        <translation type="obsolete">Desactivar ou activar essa linha do filtro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable &amp;Presentation Effects</source>
        <translation type="obsolete">H&amp;abilitar efeitos de apresentação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Radial Gradient</source>
        <translation type="obsolete">Gradiente radial</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage &amp;Guides...</source>
        <translation type="obsolete">Gerir &amp;guias...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Advertisements</source>
        <translation type="obsolete">Anúncios</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Layout:</source>
        <translation type="obsolete">Aparência:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Usage: scribus [option ... ] [file]</source>
        <translation type="obsolete">Uso: scribus [opção ...] [ficheiro]</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Own Templates</source>
        <translation type="obsolete">Modelos pessoais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Property type &apos;%1&apos; not supported</source>
        <translation type="obsolete">A propriedade &apos;%1&apos; não é suportada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File &amp;type:</source>
        <translation type="obsolete">&amp;Tipo de ficheiro:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export Range</source>
        <translation type="obsolete">Intervalo de exportação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point list must contain at least three points (six values).</source>
        <translation type="obsolete">A lista de pontos deve conter ao menos três pontos (seis valores).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;hoose Pages</source>
        <translation type="obsolete">&amp;Selecionar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check image resolution</source>
        <translation type="obsolete">Verificar resolução da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File &amp;name:</source>
        <translation type="obsolete">&amp;Nome do ficheiro:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X-Scale:</source>
        <translation type="obsolete">Escala-X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y-Scale:</source>
        <translation type="obsolete">Escala-Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Linha de traço ponto ponto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation of color of lines</source>
        <translation type="obsolete">Saturação da cor das linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Indentation from the right for the whole paragraph</source>
        <translation type="obsolete">Indentação a partir da direita para todo o parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption only</source>
        <translation type="obsolete">Somente legenda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Newsletters</source>
        <translation type="obsolete">Jornais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="obsolete">Bloquear ou desbloquear camada - desassinalada é desbloqueada </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation type="obsolete">1° Quadritônico (base oposta)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert PDF Combo Box</source>
        <translation type="obsolete">Inserir uma caixa de seleção PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Abort</source>
        <translation type="obsolete">&amp;Abortar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;About</source>
        <translation type="obsolete">&amp;Sobre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Apply</source>
        <translation type="obsolete">&amp;Aplicar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Block</source>
        <translation type="obsolete">&amp;Bloco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Clone</source>
        <translation type="obsolete">&amp;Clonar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Fechar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation type="obsolete">Resolução das imagens Use 72 dpi para imagens que serão exibidas no ecrã</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Color</source>
        <translation type="obsolete">&amp;Cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File Options</source>
        <translation type="obsolete">Opções do ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+style </source>
        <translation type="obsolete">+estilo </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The Font %1 is not installed.</source>
        <translation type="obsolete">A fonte %1 não está instalada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Calculate</source>
        <translation type="obsolete">Calcular</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keyboard shortcut sets available to load</source>
        <translation type="obsolete">Conjunto de teclas de atalho disponível para ser carregado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Ficheiro:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Fonts</source>
        <translation type="obsolete">&amp;Fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Group</source>
        <translation type="obsolete">A&amp;grupar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spacing above the paragraph</source>
        <translation type="obsolete">Espaço acima do parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Image</source>
        <translation type="obsolete">&amp;Imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Aplicar &amp;fator</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Left:</source>
        <translation type="obsolete">&amp;Esquerda:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Level</source>
        <translation type="obsolete">Níve&amp;l</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot remove the last layer.</source>
        <translation type="obsolete">Não é possível remover a última camada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lines</source>
        <translation type="obsolete">&amp;Linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lower</source>
        <translation type="obsolete">&amp;Baixar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot unlink a non-text frame.</source>
        <translation type="obsolete">Não é possível separar um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Merge</source>
        <translation type="obsolete">Página &amp;Mestre:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal Gradient</source>
        <translation type="obsolete">Gradiente horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Nome:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation type="obsolete">O nome de cor que escolheu já existe,
por favor, escolha outro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Page:</source>
        <translation type="obsolete">&amp;Página:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Paste</source>
        <translation type="obsolete">&amp;Colar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right Margin</source>
        <translation type="obsolete">Margem direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Print</source>
        <translation type="obsolete">&amp;Imprimir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Raise</source>
        <translation type="obsolete">&amp;Elevar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Range</source>
        <translation type="obsolete">&amp;Intervalo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quote</source>
        <translation type="obsolete">&amp;Citação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Reset</source>
        <translation type="obsolete">&amp;Reconfigurar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Right</source>
        <translation type="obsolete">Di&amp;reita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shade</source>
        <translation type="obsolete">&amp;Intensidade</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Forma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Size:</source>
        <translation type="obsolete">&amp;Tamanho:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selected:</source>
        <translation type="obsolete">Seleccionados:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selection</source>
        <translation type="obsolete">Seleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;X-Pos</source>
        <translation type="obsolete">Pos.&amp;X</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Tools</source>
        <translation type="obsolete">&amp;Ferramentas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Type:</source>
        <translation type="obsolete">&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation type="obsolete">Ficheiros PostScript (*.ps);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;User:</source>
        <translation type="obsolete">&amp;Usuário:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;election</source>
        <translation type="obsolete">S&amp;eleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Has Layers:</source>
        <translation type="obsolete">Possui camadas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Python Scripts (*.py *.PY);;All Files (*)</source>
        <translation type="obsolete">Scripts Python (*.py *.PY);; Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation type="obsolete">&amp;Importar ficheiro de Bloco de Rascunhos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow Cop&amp;ying Text and Graphics</source>
        <translation type="obsolete">Permite a &amp;cópia de texto e imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke color</source>
        <translation type="obsolete">Cor da borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Filename:</source>
        <translation type="obsolete">Nome do ficheiro:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Right</source>
        <translation type="obsolete">CJK simples à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Calendars</source>
        <translation type="obsolete">Calendários</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Length:</source>
        <translation type="obsolete">Comprimento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Com&amp;press Text and Vector Graphics</source>
        <translation type="obsolete">Com&amp;primir texto e imagens vetoriais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Strike Out. Hold down the button momentarily to set line width and displacement options.</source>
        <translation type="obsolete">Tacha o texto. Pressione e segure o botão por um momento para definir as opções de largura e posicionamento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Elephant</source>
        <translation type="obsolete">Elefante</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Document Bleeds</source>
        <translation type="obsolete">Usar sangrias do Documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete...</source>
        <translation type="obsolete">&amp;Apagar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font stroke color shade</source>
        <translation type="obsolete">Definir intensidade cor de traço da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Displacement:</source>
        <translation type="obsolete">&amp;Deslocamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement:</source>
        <translation type="obsolete">Deslocamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete %1</source>
        <translation type="obsolete">Apagar %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript Level 1</source>
        <translation type="obsolete">PostScript nível 1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript Level 2</source>
        <translation type="obsolete">PostScript nível 2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript Level 3</source>
        <translation type="obsolete">PostScript nível 3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;Other Files (*.eps *.epsi *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla *.scd);;Outros Ficheiros (*.eps *.epsi *.ps *.ai);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font fill color</source>
        <translation type="obsolete">Definir cor de preenchimento da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relevance</source>
        <translation type="obsolete">Relevância</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Level 1</source>
        <translation type="obsolete">Nível 1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Level 2</source>
        <translation type="obsolete">Nível 2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Level 3</source>
        <translation type="obsolete">Nível 3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Paragraph Styles...</source>
        <translation type="obsolete">Estilos de &amp;parágrafo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset this Control Point</source>
        <translation type="obsolete">Reconfigura esse ponto de controle</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke shade</source>
        <translation type="obsolete">Intensidade da borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Single Comma</source>
        <translation type="obsolete">Vírgula baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply all changes</source>
        <translation type="obsolete">Apl&amp;icar em todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bulgarian</source>
        <translation type="obsolete">Búlgaro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Altura das páginas do documento. Editável se você escolheu um tamanho de página personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation type="obsolete">Falhou ao carregar o ficheiro %1 - tipo de fonte desconhecido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>LineStyleWBase</source>
        <translation type="obsolete">LineStyleWBase</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Small Caps</source>
        <translation type="obsolete">Caixa baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke Color</source>
        <translation type="obsolete">Cor da borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Caps</source>
        <translation type="obsolete">Caixa Alta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;All Caps</source>
        <translation type="obsolete">Caixa &amp;Alta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Roll Over</source>
        <translation type="obsolete">Sobre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Rule</source>
        <translation type="obsolete">Medida de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Full Stop</source>
        <translation type="obsolete">Ponto final</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value is not validated</source>
        <translation type="obsolete">O valor não está validado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point list must have a multiple of six values.</source>
        <translation type="obsolete">A lista de pontos deve ter um múltiplo de seis valores.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset the text</source>
        <translation type="obsolete">Reconfigurar o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="obsolete">É um &amp;marcardor de PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabulações e endentamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save &amp;As...</source>
        <translation type="obsolete">Salv&amp;ar como...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke Shade</source>
        <translation type="obsolete">Intensidade da borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 - [%2]</source>
        <translation type="obsolete">%1 - [%2]</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copied Items</source>
        <translation type="obsolete">Itens copiados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert to Master Page...</source>
        <translation type="obsolete">Converter em página modelo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right</source>
        <translation type="obsolete">Direita simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lighten</source>
        <translation type="obsolete">Clarear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align to Baseline Grid</source>
        <translation type="obsolete">Alinhar à grelha da pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rename layer</source>
        <translation type="obsolete">Renomear camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Position of Frame</source>
        <translation type="obsolete">Posição da caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line up</source>
        <translation type="obsolete">Alinhar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printing File</source>
        <translation type="obsolete">Imprimindo ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lines: </source>
        <translation type="obsolete">Linhas: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Linked:</source>
        <translation type="obsolete">Ligado(a):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Preview dialog</source>
        <translation type="obsolete">Diálogo de visualização de fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="obsolete">Utiliza um gerenciador de impressão alternativo, como o kprinter ou o gtklp, para ter acesso a opções adicionais de impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The program %1 is missing!</source>
        <translation type="obsolete">O programa %1 está faltando!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Ghostscript version available</source>
        <translation type="obsolete">Nenhuma versão de GhostScript disponível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User Interface</source>
        <translation type="obsolete">Interface de utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV-Colormap</source>
        <translation type="obsolete">Mapa de cores HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create a new color within the current set</source>
        <translation type="obsolete">Cria uma nova cor dentro do conjunto actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent style</source>
        <translation type="obsolete">&amp;Estilo da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Size of font for new text frames</source>
        <translation type="obsolete">Tamanho da fonte para as novas molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot Delete In-Use Item</source>
        <translation type="obsolete">Não é possível apagar um item em uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts to embed:</source>
        <translation type="obsolete">Fontes a incorporar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation type="obsolete">Tornar os espaços horizontais entre os objectos iguais ao valor especificado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Media Cases</source>
        <translation type="obsolete">Estojos de mídia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shadowed Text. Hold down the button momentarily to enable the offset spacing.</source>
        <translation type="obsolete">Sombrea o texto. Pressione e segure o botão por um momento para activar o deslocamento de sombra.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resa&amp;mple Images to:</source>
        <translation type="obsolete">&amp;Re-escalar a resolução das imagens para:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rows: %1, Cols: %2</source>
        <translation type="obsolete">Linhas: %1, Colunas: %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between items equal</source>
        <translation type="obsolete">Uniformizar os espaços horizontais entre os objectos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 %2 %3</source>
        <translation type="obsolete">%1 %2 %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export resolution of text and vector graphics. This does not affect the resolution of bitmap images like photos.</source>
        <translation type="obsolete">Resolução de exportação de texto e gráficos vetoriais. Isso não afeta a resolução de imagens bitmap como fotos.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="obsolete">Exportando ítens da página atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not show objects outside the margins in the exported file</source>
        <translation type="obsolete">Não mostrar os objectos fora das margens da página no ficheiro exportado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement</source>
        <translation type="obsolete">Deslocamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y Displacement</source>
        <translation type="obsolete">Deslocamento Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X Displacement</source>
        <translation type="obsolete">Deslocamento X</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation type="obsolete">Exporta as páginas selecionadas como imagens bitmap.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Parent Value</source>
        <translation type="obsolete">É pai de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Distância para sangria do lado direito da página física</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> Parent Tabs </source>
        <translation type="obsolete">É pai de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>General Info</source>
        <translation type="obsolete">informações gerais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Page(s)</source>
        <translation type="obsolete">Mover 4</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus. The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support. Last Letter is the renderer C=cairo or A=libart Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected. The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="obsolete">Esse painel mostra a versão, data de construção e o suporte às bibliotecas compiladas no Scribus.O C-C-T-F indica suporte a C=littlecms  C=CUPS T=TIFF F=Fontconfig. A última letra é o tipo de renderizador C=cairo ou A=libart. Bibliotecas não suportadas são indicadas por *. Isto também indica a versão do Ghostscript que o Scribus detectou. A versão Windows não usa fontconfig nem bibliotecas CUPS.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save &amp;Text...</source>
        <translation type="obsolete">Salvar &amp;texto...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Multiple duplicate</source>
        <translation type="obsolete">Duplicações múltiplas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Duplicações múltiplas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation type="obsolete">Nome: Nome opcional para a seção. Ex. Índice&lt;br/&gt;Exibir: Selecione para  mostrar o número da página nesta seção se houver uma ou mais molduras designadas para essa função.&lt;br/&gt;De: O índice de página para iniciar essa seção.&lt;br/&gt;Para: O índice de página para terminar essa seção.&lt;br/&gt;Estilo: Selecione o estilo de número de página a ser usado.&lt;br/&gt;Início: O índice com o intervalo de estilos a iniciar. Ex. Se Início=2 e Estilo=a,b,c ..., os números começarão no b. Isto substitui o antigo  &apos;Número da Primeira Página&apos;.usado na primeira seção do documento, na janela de novo ficheiro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample text to display</source>
        <translation type="obsolete">Amostra de texto a exibir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You can select a predefined page layout here. &apos;None&apos; leave margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins for same value. Leading is Left/Inside value.</source>
        <translation type="obsolete">Pode selecionar aqui um layout de página predefinido.&apos;Nenhum&apos; deixa as margens como estão. &apos;Gutenberg&apos; deixa as margens na forma clássica. &apos;Revista&apos; deixa todas as margens com o mesmo valor. Leading é o valor Esquerda/Interior.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search/Replace</source>
        <translation type="obsolete">Procurar/Substituir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Method of compression to use for images. Automatic allows Scribus to choose the best method. ZIP is lossless and good for images with solid colors. JPEG is better at creating smaller PDF files which have many photos (with slight image quality loss possible). Leave it set to Automatic unless you have a need for special compression options.</source>
        <translation type="obsolete">Método de compressão a ser utilizado para as imagens. Automático permite ao Scribus escolher o melhor método. ZIP é sem perdas e bom para imagens com cores sólida. JPEG tem uma compactação maior e é melhor para ficheiros PDF que possuam várias fotos (uma leve perda de qualidade na imagem é possível). Deixe configurado no automático, ao menos que você tenha necessidade de opções de compressão especiais. Isto apenas afeta imagens JPEG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Free Scaling</source>
        <translation type="obsolete">Escala &amp;livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set Media Size</source>
        <translation type="obsolete">Definir o tamanho da mídia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Posição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove horizontal guide</source>
        <translation type="obsolete">Remover guia horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Only text frames can be checked for overflowing</source>
        <translation type="obsolete">O excesso de texto apenas pode ser checado em molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Has Embedded Paths:</source>
        <translation type="obsolete">Possui caminhos incorporados:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Active &amp;page</source>
        <translation type="obsolete">&amp;Página ativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a new master page</source>
        <translation type="obsolete">Adicionar uma nova página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relative size of the subscript compared to the normal font</source>
        <translation type="obsolete">Tamanho relativo do subscrito, comparado à fonte normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose the importer to use</source>
        <translation type="obsolete">Selecione o importador a ser usado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Locked:</source>
        <translation type="obsolete">Bloqueado(os)(as):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Preview</source>
        <translation type="obsolete">Visualizar fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>P&amp;ublisher:</source>
        <translation type="obsolete">&amp;Editor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save user configuration</source>
        <translation type="obsolete">Salvar configuração de utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Shape</source>
        <translation type="obsolete">Inserir uma forma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Table</source>
        <translation type="obsolete">Inserir uma tabela</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>3-Fold</source>
        <translation type="obsolete">Página tripla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line spacing mode</source>
        <translation type="obsolete">Modo de entrelinhamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select &amp;Printer:</source>
        <translation type="obsolete">Selecione a im&amp;pressora:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Distância entre a guia da margem direita e a borda da página. Se for selecionado Páginas Espelhadas, essa medida pode ser usada para ajustar as margens para encadernação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert frame</source>
        <translation type="obsolete">Insere uma caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit tab settings of text frame...</source>
        <translation type="obsolete">Edita as tabulações do quadro de texto...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill color of picture frames</source>
        <translation type="obsolete">Cor de preenchimento das molduras de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance from Curve:</source>
        <translation type="obsolete">Distância da curva:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical scaling</source>
        <translation type="obsolete">Escala vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;olors...</source>
        <translation type="obsolete">C&amp;ores...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Compression Metho&amp;d:</source>
        <translation type="obsolete">Méto&amp;do de compressão:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Reset Contour Line</source>
        <translation type="obsolete">&amp;Reconfigurar a linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>4-Fold</source>
        <translation type="obsolete">Página quadrupla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Frame size</source>
        <translation type="obsolete">Tamanho do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Table Of Contents</source>
        <translation type="obsolete">Tabela de conteúdos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 of %1</source>
        <translation type="obsolete">%1 de %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 of %2</source>
        <translation type="obsolete">%1 de %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Detach Text from Path</source>
        <translation type="obsolete">&amp;Separar o texto do caminho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cyrillic Supplement</source>
        <translation type="obsolete">Cirílico suplementar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert value</source>
        <translation type="obsolete">Inserir valor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shape Drawing Properties</source>
        <translation type="obsolete">Propriedades do desenho de formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Numbers Placed:</source>
        <translation type="obsolete">Posicionamento dos números de página:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colu&amp;mns:</source>
        <translation type="obsolete">Colu&amp;nas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Magenta</source>
        <translation type="obsolete">Magenta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a color set to load</source>
        <translation type="obsolete">Seleccione um conjunto de cores para carregar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selection/Group</source>
        <translation type="obsolete">Seleção/Grupo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lossless - Zip</source>
        <translation type="obsolete">Sem perdas - Zip</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Control Characters:</source>
        <translation type="obsolete">Caracteres de controle:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Margins</source>
        <translation type="obsolete">Margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Give a name for saving</source>
        <translation type="obsolete">Dê um nome para salvar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right indent</source>
        <translation type="obsolete">Indentação direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply image effects</source>
        <translation type="obsolete">Aplicar efeitos de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page per Sheet</source>
        <translation type="obsolete">página por folha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>maximum</source>
        <translation type="obsolete">o máximo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Maximum</source>
        <translation type="obsolete">Máxima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Formatting</source>
        <translation type="obsolete">Formatação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space right of the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Define a quantidade de espaço -- à direita da ecrã do documento -- disponívelcomo um área de colagem para criar e modificar elementos, arrastando-os para a página ativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Previe&amp;w Settings</source>
        <translation type="obsolete">Visualizar &amp;configurações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Combo Box</source>
        <translation type="obsolete">Caixa de seleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Raise to &amp;Top</source>
        <translation type="obsolete">Elevar ao &amp;topo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resolution:</source>
        <translation type="obsolete">Resolução:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Measurements</source>
        <translation type="obsolete">&amp;Medidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation type="obsolete">Inicia um documento usando um modelo criado por outros utilizador ou por você (ex. um documento que possui um estilo contínuo).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align Text Forced Justified</source>
        <translation type="obsolete">Forçar Justificação do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ghostscript : You cannot use EPS images or PostScript Print Preview</source>
        <translation type="obsolete">Ghostscript : Você não pode utilizar imagens EPS ou visualizar impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>all instances of</source>
        <translation type="obsolete">todas os exemplos de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation type="obsolete">Alinhar os lados direitos dos objectos ao lado esquerdo da âncora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Standard Lorem Ipsum</source>
        <translation type="obsolete">Texto de amostra padrão (Lorem Ipsum)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comma Separated Value Files</source>
        <translation type="obsolete">Ficheiros de valores separados por vírgulas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of your paragraph style</source>
        <translation type="obsolete">Nome do seu estilo de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Contributors:</source>
        <translation type="obsolete">&amp;Colaboradores:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font not found.</source>
        <translation type="obsolete">Fonte não encontrada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation type="obsolete">Ponto de referência para as medições e ângulos de rotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Meaning</source>
        <translation type="obsolete">Significado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical offset of image within frame</source>
        <translation type="obsolete">Deslocamento vertical da imagem dentro do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>SVG-Images (*.svg *.svgz);;All Files (*)</source>
        <translation type="obsolete">Imagens SVG (*.svg *.svgz);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Save Output...</source>
        <translation type="obsolete">&amp;Salvar saída...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loading Patterns</source>
        <translation type="obsolete">Carregando os padrões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Page(s):</source>
        <translation type="obsolete">Mover página(s):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Files (*.txt)</source>
        <translation type="obsolete">Ficheiros de texto (*.txt)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File %1 does not exist, aborting.</source>
        <translation type="obsolete">O ficheiro %1 não existe, abortando.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom validate script:</source>
        <translation type="obsolete">Script de validação personalizado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Searching for Fonts</source>
        <translation type="obsolete">Procurando por fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between columns</source>
        <translation type="obsolete">Distância entre as colunas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">&amp;Miniaturas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Underline Words Only. Hold down the button momentarily to set line width and displacement options.</source>
        <translation type="obsolete">Sublinha apenas palavras. Pressione e segure o botão por um momento para definir as opções de largura e posicionamento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of the selected style</source>
        <translation type="obsolete">Nome do estilo seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;dd...</source>
        <translation type="obsolete">A&amp;dicionar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Horizontal Scaling:</source>
        <translation type="obsolete">Escala &amp;horizontal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;pot Function:</source>
        <translation type="obsolete">F&amp;unção direcional:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>argument contains no-numeric values: must be list of float values.</source>
        <translation type="obsolete">o argumento contém valores não numéricos: deve ser uma lista de valores flutuantes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Corner radius must be a positive number.</source>
        <translation type="obsolete">O raio do canto deve ser um número positivo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double sided</source>
        <translation type="obsolete">Página dupla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset the barcode samples</source>
        <translation type="obsolete">Reconfigurar amostras de código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create table</source>
        <translation type="obsolete">Criar tabela</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set language</source>
        <translation type="obsolete">Definir idioma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scratch space</source>
        <translation type="obsolete">Área4 de rabisco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Marcar cores fora de &amp;gama</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Color</source>
        <translation type="obsolete">Selecionar cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete pages</source>
        <translation type="obsolete">Apagar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a Scrapbook Directory</source>
        <translation type="obsolete">Selecione um directório do Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete layer</source>
        <translation type="obsolete">Apagar camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Writing updated Font Cache</source>
        <translation type="obsolete">Gravando cache de fonte atualizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color1: %1, Color2: %2</source>
        <translation type="obsolete">Cor1: %1, Cor2: %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete From:</source>
        <translation type="obsolete">Apagar de:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source profile of the image</source>
        <translation type="obsolete">Perfil de origem da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printer Marks</source>
        <translation type="obsolete">Miras de impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mandatory string for PDF/X-3 or the PDF will fail PDF/X-3 conformance. We recommend you use the title of the document.</source>
        <translation type="obsolete">Informação obrigatória para o PDF/X-3 ou o PDF terá problemascom a conformação PDF/X-3. Nós recomendamos o uso do título do seu documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left to Right</source>
        <translation type="obsolete">Da esquerda para direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show options</source>
        <translation type="obsolete">Mostrar opções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Color</source>
        <translation type="obsolete">Apagar cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resize the image vertically</source>
        <translation type="obsolete">Redimensiona a imagem verticalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move horizontal guide</source>
        <translation type="obsolete">Mover guia horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Right</source>
        <translation type="obsolete">CJK dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right to Left</source>
        <translation type="obsolete">Da direita para esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation type="obsolete">Isto habilita a exportação individual de cada página do documento para um ficheiro PDF. Os números de páginas são adicionados automáticamente. Isto é útil na imposição de PDF para impressão comercial.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export current preferences into file</source>
        <translation type="obsolete">Exportar as actuais configurações para um ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right</source>
        <translation type="obsolete">Dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Item Attributes</source>
        <translation type="obsolete">Atributos de item do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Sided</source>
        <translation type="obsolete">Página dupla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create Range</source>
        <translation type="obsolete">Criar página(s)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>More than one style selected</source>
        <translation type="obsolete">Há mais do que um estilo seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scratch Space</source>
        <translation type="obsolete">Área de rabisco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Setup</source>
        <translation type="obsolete">Configurações do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Script error</source>
        <translation type="obsolete">Erro de script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select color</source>
        <translation type="obsolete">Selecionar cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Style</source>
        <translation type="obsolete">Apagar estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>System Profiles</source>
        <translation type="obsolete">Perfis do sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Nodes</source>
        <translation type="obsolete">Apagar um nó</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Pages</source>
        <translation type="obsolete">Apagar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation type="obsolete">Se você selecionar OK e então salvar, essas substituições feitas no documento serão permanentes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Double Comma</source>
        <translation type="obsolete">Vírgula dupla baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;From Document:</source>
        <translation type="obsolete">&amp;Do documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import EPS image</source>
        <translation type="obsolete">Importar imagem EPS</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>About Scribus %1</source>
        <translation type="obsolete">Sobre o Scribus %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Line Styles</source>
        <translation type="obsolete">Editar estilos de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Layer</source>
        <translation type="obsolete">Apagar camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Dodge</source>
        <translation type="obsolete">Esmaecer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Flip Horizontally</source>
        <translation type="obsolete">&amp;Espelhar horizontalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>minimum</source>
        <translation type="obsolete">o mínimo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Minimum</source>
        <translation type="obsolete">Mínima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Image Frame</source>
        <translation type="obsolete">Inserir caixa de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image is GIF</source>
        <translation type="obsolete">A imagem é GIF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Glyph...</source>
        <translation type="obsolete">Caractere e&amp;special...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption below Icon</source>
        <translation type="obsolete">Legenda abaixo do ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Missing</source>
        <translation type="obsolete">Faltando</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotate the Path Clockwise</source>
        <translation type="obsolete">Rotaciona o caminho no sentido horário</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Can&apos;t set bookmark on a non-text frame</source>
        <translation type="obsolete">Não é possível definir um marcador em um quadro que não seja de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="obsolete">Insira as páginas desejadas, separadas por vírgulas.Você pode usar * para todas as páginas, 1-5 para umaseqüência de páginas ou o número de uma única página.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Absolute Coordinates</source>
        <translation type="obsolete">Coordenadas &amp;absolutas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Roda de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Attributes...</source>
        <translation type="obsolete">&amp;Atributos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>paragraphs with less than</source>
        <translation type="obsolete">parágrafos com menos de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object is a placed PDF</source>
        <translation type="obsolete">O objecto é um PDF colocado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>unknown plugin type</source>
        <translation type="obsolete">tipo de plugin desconhecido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for missing glyphs</source>
        <translation type="obsolete">Procurar por caracteres em falta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement above the baseline of the font on a line</source>
        <translation type="obsolete">Deslocamento da fonte acima da pauta em uma linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Seleccionar isto colocará a caixa na gama de páginas seleccionada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Renderização pretendida para o seu monitor. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Version</source>
        <translation type="obsolete">Versão do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Antialias graphics for EPS and PDF onscreen rendering</source>
        <translation type="obsolete">Suaviza as imagens para a renderização no ecrã de EPS e PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exports the current page into an SVG file.</source>
        <translation type="obsolete">Exporta a página actual para um ficheiro SVG.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Auto Add To</source>
        <translation type="obsolete">Adicionar automáticamente à</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing File:
%1
failed!</source>
        <translation type="obsolete">Não foi possível importar o ficheiro:%1!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select your default language for Scribus to run with. Leave this blank to choose based on environment variables. You can still override this by passing a command line option when starting Scribus</source>
        <translation type="obsolete">Selecione o idioma padrão que o Scribus deve utilizar. Deixe isso em branco para escolher o idioma através das variáveis do sistema. Você ainda pode sobrescrever essa opção através de um comando no terminal usado durante a iniciação do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Latin-1 Supplement</source>
        <translation type="obsolete">Latim-1 Suplementar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.3.0-&gt;1.3.3.7 Support</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comments:</source>
        <translation type="obsolete">Comentários:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Python Scripts (*.py *.PY);; All Files (*)</source>
        <translation type="obsolete">Scripts Python (*.py *.PY);; Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solid Colors:</source>
        <translation type="obsolete">Cores sólidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lower layer</source>
        <translation type="obsolete">Rebaixar camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change name of the layer</source>
        <translation type="obsolete">Alterar nome da camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for missing images</source>
        <translation type="obsolete">Procurar imagens em falta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Resolution for EPS Graphics:</source>
        <translation type="obsolete">&amp;Resolução para gráficos EPS:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports most SVG files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Importa a maioria dos ficheiros SVG para o documento actual,
convertendo seus dados vectoriais em objectos do Scribus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the length of the action history in steps. If set to 0 infinite amount of actions will be stored.</source>
        <translation type="obsolete">Define o número de ações no histórico de ações. Se o valor configurado for 0, um número infinito de ações serão gravadas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add to Custom Colors</source>
        <translation type="obsolete">&amp;Adicionar às cores personalizadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X1: %1, Y1: %2
X2: %4, Y2: %5</source>
        <translation type="obsolete">X1: %1, Y1: %2
X2: %4, Y2: %5</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace created colors in the document colors</source>
        <translation type="obsolete">Substitui as cores criadas nas cores do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow printing of the PDF. If un-checked, printing is prevented. </source>
        <translation type="obsolete">Permite a impressão do PDF. Se desmarcado, não se consegue imprimir. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Automatic Linespacing</source>
        <translation type="obsolete">Espaçamento automático de linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Page Left</source>
        <translation type="obsolete">Página dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">&amp;Limpar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;olor</source>
        <translation type="obsolete">C&amp;or</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hair Space</source>
        <translation type="obsolete">Espaço mínimo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Selected frames</source>
        <translation type="obsolete">Quadros &amp;selecionados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save a document as a template. Good way to ease the initial work for documents with a constant look</source>
        <translation type="obsolete">Salva um documento como modelo. Uma boa maneira de facilitar o trabalho inicial em documentos que possuem uma aparência constante</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Round Join</source>
        <translation type="obsolete">Junção arredondada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Transparency out of bounds, must be 0 &lt;= transparency &lt;= 1.</source>
        <translation type="obsolete">A intensidade da linha está fora do limite, deve ser &gt;=0 e &lt;=100.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2nd. Analogous</source>
        <translation type="obsolete">2° corespondente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Vertical Scaling:</source>
        <translation type="obsolete">Escala &amp;vertical:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal or gradient fill method</source>
        <translation type="obsolete">Método de preenchimento normal ou em gradiente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Break aspect ratio</source>
        <translation type="obsolete">Quebrar proporção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Move...</source>
        <translation type="obsolete">&amp;Mover...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right to Left Writing</source>
        <translation type="obsolete">Escrita da direita para a esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style of lines</source>
        <translation type="obsolete">Estilo das linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation type="obsolete">Remover as cores não utilizadas do conjunto de cores desse documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Advanced Reordering</source>
        <translation type="obsolete">Reordenação avançada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Free linear Gradient</source>
        <translation type="obsolete">Gradiente linear livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enabled:</source>
        <translation type="obsolete">Activado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Accept</source>
        <translation type="obsolete">Aceitar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Access</source>
        <translation type="obsolete">Acesso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Action</source>
        <translation type="obsolete">Ação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preset Layouts:</source>
        <translation type="obsolete">Aparência:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exposure time</source>
        <translation type="obsolete">Tempo de exposição</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Frames</source>
        <translation type="obsolete">Mostrar molduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Renderização pretendida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering Intent:</source>
        <translation type="obsolete">Renderização pretendida:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering-Intent:</source>
        <translation type="obsolete">Renderização pretendida:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Frames</source>
        <translation type="obsolete">Quadros de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Always</source>
        <translation type="obsolete">Sempre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle:</source>
        <translation type="obsolete">Ângulo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>At End</source>
        <translation type="obsolete">Para o final</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Snapping</source>
        <translation type="obsolete">Atrair</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Append</source>
        <translation type="obsolete">&amp;Acrescentar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import master pages from another document</source>
        <translation type="obsolete">Importar página modelo de um outro documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arabic</source>
        <translation type="obsolete">Arábico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basque</source>
        <translation type="obsolete">Basco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arrows</source>
        <translation type="obsolete">Setas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align Text Center</source>
        <translation type="obsolete">Alinhar o texto ao centro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change Image Scale</source>
        <translation type="obsolete">Alterar escala da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>August</source>
        <translation type="obsolete">Agosto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Author</source>
        <translation type="obsolete">Autor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>End Arrow:</source>
        <translation type="obsolete">Seta final:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Separation Name</source>
        <translation type="obsolete">Nome da separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bl&amp;ue:</source>
        <translation type="obsolete">Az&amp;ul:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation type="obsolete">Orientação das páginas do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Resolução de imagem abaixo de %1 DPI. Atualmente %2 X %3 DPI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bleeds</source>
        <translation type="obsolete">Sangrias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Blinds</source>
        <translation type="obsolete">Persiana</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>argument contains non-numeric values: must be list of float values.</source>
        <translation type="obsolete">o argumento contém valores não numéricos: deve ser uma lista de valores flutuantes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="obsolete">Ficheiros PDF (*.pdf);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Border</source>
        <translation type="obsolete">Borda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bottom</source>
        <translation type="obsolete">Fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable or disable  the display of linked frames.</source>
        <translation type="obsolete">Activar ou desactivar a visualização das molduras conectadas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancel</source>
        <translation type="obsolete">Cancelar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Breton</source>
        <translation type="obsolete">Bretão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Date Format</source>
        <translation type="obsolete">Formato da data</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bullet</source>
        <translation type="obsolete">Marcador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Center</source>
        <translation type="obsolete">Centro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Button</source>
        <translation type="obsolete">Botão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output of your script</source>
        <translation type="obsolete">Saída do seu script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Circle</source>
        <translation type="obsolete">Círculo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Co&amp;de:</source>
        <translation type="obsolete">Có&amp;digo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color:</source>
        <translation type="obsolete">Cor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colors</source>
        <translation type="obsolete">Cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align Text Justified</source>
        <translation type="obsolete">Justificar o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Field Properties</source>
        <translation type="obsolete">Propriedades do campo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Danish</source>
        <translation type="obsolete">Dinamarquês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dat&amp;e:</source>
        <translation type="obsolete">Dat&amp;a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Darken</source>
        <translation type="obsolete">Escurecer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dashed</source>
        <translation type="obsolete">Pontilhado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create</source>
        <translation type="obsolete">Criar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Low Resolution</source>
        <translation type="obsolete">Baixa reso&amp;lução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete</source>
        <translation type="obsolete">Apagar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Curves</source>
        <translation type="obsolete">Curvas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Time Format</source>
        <translation type="obsolete">Formato da hora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The frame the table of contents will be placed into</source>
        <translation type="obsolete">O quadro em que será posto a tabela de conteúdos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation type="obsolete">Activa/desactiva a visualização da tinta C (ciano)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Endings:</source>
        <translation type="obsolete">T&amp;erminações:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Guides</source>
        <translation type="obsolete">Mostrar guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Undo: %1</source>
        <translation type="obsolete">&amp;Desfazer: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Landscape</source>
        <translation type="obsolete">Paisagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>landscape</source>
        <translation type="obsolete">paisagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Editor</source>
        <translation type="obsolete">Editor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit custom configuration. If you save it, it will be used over system wide configuration</source>
        <translation type="obsolete">Edita um configuração personalizada. Se você salvar, isto será usado sobre as configurações do sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Effect</source>
        <translation type="obsolete">Sem efeito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line color of shapes</source>
        <translation type="obsolete">Cor da linha das formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color not found in default colors.</source>
        <translation type="obsolete">Cor não encontrada nas cores padrão.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Non Breaking Space</source>
        <translation type="obsolete">Inserir espaço sem quebra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Given master page name does not match any existing.</source>
        <translation type="obsolete">Não existe nenhuma Página Mestre com o nome fornecido.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style not found.</source>
        <translation type="obsolete">Estilo não encontrado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Don&apos;t use embedded ICC profiles</source>
        <translation type="obsolete">Não usar perfis ICC incorporados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;isplacement:</source>
        <translation type="obsolete">D&amp;eslocamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF Export</source>
        <translation type="obsolete">Exportação de PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>SVG Export</source>
        <translation type="obsolete">Exportação de SVG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R&amp;eload</source>
        <translation type="obsolete">R&amp;ecarregar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Event:</source>
        <translation type="obsolete">Evento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value is the</source>
        <translation type="obsolete">O valor é</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Linewidth</source>
        <translation type="obsolete">Espessura da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;PDF Options</source>
        <translation type="obsolete">Opções de &amp;PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File: </source>
        <translation type="obsolete">Ficheiro: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Folder</source>
        <translation type="obsolete">Nova pasta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line at Bottom</source>
        <translation type="obsolete">Linha abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flyers</source>
        <translation type="obsolete">Panfletos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill color of shapes</source>
        <translation type="obsolete">Cor de preenchimento das formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Script Console</source>
        <translation type="obsolete">Console de scripts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Description:</source>
        <translation type="obsolete">Descrição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Forced</source>
        <translation type="obsolete">Forçado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Format</source>
        <translation type="obsolete">Formato</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line width expressed as a percentage of the font size</source>
        <translation type="obsolete">Espessura da linha expressa em percentagem de tamanho de fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Frames</source>
        <translation type="obsolete">Molduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hungarian</source>
        <translation type="obsolete">Húngaro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>French</source>
        <translation type="obsolete">Francês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Friday</source>
        <translation type="obsolete">Sexta-Feira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Item Attributes</source>
        <translation type="obsolete">Atributos de item da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printer Margins...</source>
        <translation type="obsolete">Margens da impressora...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Column width</source>
        <translation type="obsolete">Largura da coluna</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>German</source>
        <translation type="obsolete">Alemão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Master Pages:</source>
        <translation type="obsolete">Páginas Mestre disponíveis:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Polygon</source>
        <translation type="obsolete">Inserir um polígono</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Color:</source>
        <translation type="obsolete">Cor do texto:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flip horizontally</source>
        <translation type="obsolete">Espelhamento horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to delete this script?</source>
        <translation type="obsolete">Você realmente deseja apagar esse Script?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set custom line style</source>
        <translation type="obsolete">Definir um estilo de linha personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enter a value then press OK</source>
        <translation type="obsolete">Entre com um valor e pressione Ok</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Color:</source>
        <translation type="obsolete">Cor do preenchimento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Group </source>
        <translation type="obsolete">Agrupar </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Idioma:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keep horizontal and vertical scaling the same</source>
        <translation type="obsolete">Manter as escalas horizontal e vertical iguais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Bleeds</source>
        <translation type="obsolete">Mostrar sangrias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hebrew</source>
        <translation type="obsolete">Hebreu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guides</source>
        <translation type="obsolete">Guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height</source>
        <translation type="obsolete">Altura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Fields</source>
        <translation type="obsolete">Campos disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of selected object</source>
        <translation type="obsolete">Nome do objeto selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hidden</source>
        <translation type="obsolete">Oculto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Column Break</source>
        <translation type="obsolete">Quebra de coluna</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom calculation script:</source>
        <translation type="obsolete">Script de cálculo personalizado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation type="obsolete">Esse painel mostra várias opções do CUPS durante a impressão.
Os parâmetros exatos disponíveis dependem do driver da sua impressora.
Você pode confirmar o suporte ao CUPS selecionando Ajuda &gt; Sobre.
Procure pelas listagens: C-C-T equivalente ao suporte a C=CUPS C=littlecms T=TIFF.
As bibliotecas nao suportadas são indicadas por um *</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Fonts:</source>
        <translation type="obsolete">Fontes disponíveis:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enter a comma separated list of fields here</source>
        <translation type="obsolete">Insira aqui uma lista de campos separados por vírgulas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New &amp;from Template...</source>
        <translation type="obsolete">Novo a partir do &amp;modelo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Destination Frame:</source>
        <translation type="obsolete">Quadro de destino:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Registered Trademark</source>
        <translation type="obsolete">Marca registrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overwrite Paragraph Styles</source>
        <translation type="obsolete">Sobrescrever estilos de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hyphen</source>
        <translation type="obsolete">Hífen</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scaling height of characters</source>
        <translation type="obsolete">Escalona a altura dos caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDB Import</source>
        <translation type="obsolete">Importar PDB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete the currently selected color</source>
        <translation type="obsolete">Apagar a cor seleccionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>SVG Import</source>
        <translation type="obsolete">Importação de SVG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move to front</source>
        <translation type="obsolete">Move para a frente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Images</source>
        <translation type="obsolete">Imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Scripts</source>
        <translation type="obsolete">Scripts personalizados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import</source>
        <translation type="obsolete">Importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Barcode Generator...</source>
        <translation type="obsolete">Gerador de Código de &amp;Barras...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Real Number</source>
        <translation type="obsolete">Número real</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color %1 exists already!</source>
        <translation type="obsolete">A cor %1 já existe!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inside</source>
        <translation type="obsolete">Dentro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Invert</source>
        <translation type="obsolete">Inverter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation type="obsolete">O valor fornecido está fora do intervalo de números de páginas do documento atual (%1,-%2).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Luxembourgish</source>
        <translation type="obsolete">Luxemburguês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Letterlike Symbols</source>
        <translation type="obsolete">Letras como símbolos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page %1 to %2</source>
        <translation type="obsolete">Página %1 a %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Issues</source>
        <translation type="obsolete">Problemas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Baseline Grid</source>
        <translation type="obsolete">Mostrar &amp;pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation type="obsolete">Nenhuma imagem com o nome &quot;%1&quot; foi encontrada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>all paragraphs</source>
        <translation type="obsolete">todos os parágrafos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Updating Pictures</source>
        <translation type="obsolete">Refrescando imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Group Size:</source>
        <translation type="obsolete">Tamanho da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Número de cantos dos polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No View</source>
        <translation type="obsolete">Invisível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Master Page</source>
        <translation type="obsolete">Nova página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output one file for eac&amp;h page</source>
        <translation type="obsolete">Cria um arqu&amp;ivo para cada página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basic Latin</source>
        <translation type="obsolete">Latim básico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add horizontal guide</source>
        <translation type="obsolete">Adicionar guia horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation type="obsolete">Número variável de caracteres ASCII e símbolos de funções especiais, começando com o caracter de início apropriado para o cojunto de caracteres inicial. UCC/EAN-128s devem possuir um símbolo mandatário FNC 1 logo após ao caracter inicial.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus was not able to start the external web browser application %1. Please check the setting in Preferences</source>
        <translation type="obsolete">Scribus foi incapaz de lançar o navegador web externo %1. Por favor verifique a configuração nas Preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clean the Palette?</source>
        <translation type="obsolete">Limpar a paleta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initializing Hyphenator</source>
        <translation type="obsolete">Iniciando Hifenizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show thumbnails</source>
        <translation type="obsolete">Mostrar &amp;miniaturas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Korean</source>
        <translation type="obsolete">Coreano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation type="obsolete">Lista, procura e navega entre as fonte disponíveis.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Labels</source>
        <translation type="obsolete">Etiquetas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Le&amp;vel</source>
        <translation type="obsolete">Ní&amp;vel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Layers</source>
        <translation type="obsolete">Camadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Not Found</source>
        <translation type="obsolete">Cor não encontrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Styles...</source>
        <translation type="obsolete">Editar estilos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Edit Styles...</source>
        <translation type="obsolete">&amp;Editar estilos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a previously saved filter</source>
        <translation type="obsolete">Selecione um filtro salvo anteriormente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ledger</source>
        <translation type="obsolete">Carta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Letter</source>
        <translation type="obsolete">Carta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Leave preview</source>
        <translation type="obsolete">Sai da visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If you are running an official script report it at &lt;a href=&quot;http://bugs.scribus.net&quot;&gt;bugs.scribus.net&lt;/a&gt; please.</source>
        <translation type="obsolete">Se você está executando um script oficial, por favor, informe-o em &lt;a href=&quot;http://bugs.scribus.net&quot;&gt;bugs.scribus.net&lt;/a&gt;.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Edit Shape...</source>
        <translation type="obsolete">&amp;Editar a forma...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete the currently selected section.</source>
        <translation type="obsolete">Apagar a seleção atual.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output stream not writeable</source>
        <translation type="obsolete">Não é possível escrever no fluxo da saída</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Seleccionar isto colocará a caixa ao cimo e à esquerda das margens da página definida na sua configuração de documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>W1: %1, H1: %2
W2: %3, H2: %4</source>
        <translation type="obsolete">L1: %1, A1: %2
L2: %3, A2: %4</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Medium</source>
        <translation type="obsolete">Média</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle</source>
        <translation type="obsolete">Central</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation of color of text stroke</source>
        <translation type="obsolete">Saturação da cor da borda de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose the default window decoration and looks. Scribus inherits any available KDE or Qt themes, if Qt is configured to search KDE plugins.</source>
        <translation type="obsolete">Selecione a decoração de janelas e a aparência padrão. O Scribus aceita qualquer tema que estiver disponível do KDE e da Qt, se o Qt estiver configurado para procurar por plugins do KDE.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror</source>
        <translation type="obsolete">Espelho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Deuteranopia (Green)</source>
        <translation type="obsolete">Deuteranopia (Verde)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation type="obsolete">Cor do traço do texto e/ou da sombra, dependendo de qual for selecionada. Eles compartilharão as mesmas cores caso ambos sejam selecionados.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Direction of the glitter or wipe effects.</source>
        <translation type="obsolete">Direção dos efeitos Brilho e Apagar.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Monday</source>
        <translation type="obsolete">Segunda-Feira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Layer Indicators</source>
        <translation type="obsolete">Mostrar indicadores de Camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New %1</source>
        <translation type="obsolete">Novo %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send your value to the script</source>
        <translation type="obsolete">Envia o valor para o script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value delimiter:</source>
        <translation type="obsolete">Delimitador de valor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation type="obsolete">Mescla os estilos de parágrafos pelos atributos. Isto resultará em menos estilos de paragrafos similares, retendo os atributos, mesmo que os estilos do documento original sejam nomeados diferentemente.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation type="obsolete">Uma pessoa ou organização responsável por fazer contribuições ao conteúdo do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Time period between saving automatically</source>
        <translation type="obsolete">Intervalo de tempo para salvar automaticamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a password for users to be able to read your PDF.</source>
        <translation type="obsolete">Escolha uma senha para habilitar os usuários a lerem o seu PDF.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arabic Extended A</source>
        <translation type="obsolete">Arábico Extendido A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arabic Extended B</source>
        <translation type="obsolete">Arábico Extendido B</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Maximum number of Hyphenations following each other.
A value of 0 means unlimited hyphenations.</source>
        <translation type="obsolete">O número máximo de hifenizações seguidas.
Um valor 0 significa hifenizações ilimitadas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object</source>
        <translation type="obsolete">Objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Substitution</source>
        <translation type="obsolete">Fontes substitutas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number</source>
        <translation type="obsolete">Número</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User settings saved</source>
        <translation type="obsolete">As configurações de utilizador foram salvas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Text Annotation</source>
        <translation type="obsolete">Inserir anotações de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Name</source>
        <translation type="obsolete">Nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Size</source>
        <translation type="obsolete">Tamanho da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font face</source>
        <translation type="obsolete">Nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Page Right</source>
        <translation type="obsolete">Página dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Option</source>
        <translation type="obsolete">Opções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pages:</source>
        <translation type="obsolete">Páginas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print &amp;All</source>
        <translation type="obsolete">Imprimir &amp;todas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font size</source>
        <translation type="obsolete">Tamanho da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Pai</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Origin</source>
        <translation type="obsolete">Origem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal:</source>
        <translation type="obsolete">Normal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Argument must be page item name, or PyCObject instance</source>
        <translation type="obsolete">O argumento deve ser um nome de um item da página ou uma instância PyCObject</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left Margin</source>
        <translation type="obsolete">Margem esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation type="obsolete">A fonte %1 foi carregada de %2(%3) </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>When enabled, Scribus saves a backup copy of your file with the .bak extension each time the time period elapses</source>
        <translation type="obsolete">Quando activado, o Scribus salva uma cópia de seu ficheiro com a extensão .bak a cada intervalo de tempo definido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Duplicate the selected master page</source>
        <translation type="obsolete">Duplicar a página modelo selecionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abela</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;ype:</source>
        <translation type="obsolete">T&amp;ipo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>End Points</source>
        <translation type="obsolete">Terminações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Columns:</source>
        <translation type="obsolete">Número de colunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of columns:</source>
        <translation type="obsolete">Número de colunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin</source>
        <translation type="obsolete">Plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>My Plugin</source>
        <translation type="obsolete">Meu Plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polish</source>
        <translation type="obsolete">Polonês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load Set</source>
        <translation type="obsolete">Carregar conjunto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load it?</source>
        <translation type="obsolete">Carregar?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Reload Text from Frame</source>
        <translation type="obsolete">&amp;Recarregar o texto a partir do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load an existing scrapbook</source>
        <translation type="obsolete">Carregar um Bloco de Rascunhos existente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Development Team:</source>
        <translation type="obsolete">Equipa de desenvolvimento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the margins on or off</source>
        <translation type="obsolete">Activa ou desactiva as margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spanish (Latin)</source>
        <translation type="obsolete">Espanhol (Latino)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Spacing:</source>
        <translation type="obsolete">Espaçamento de linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin: %1 failed to load: %2</source>
        <translation type="obsolete">Plugin: %1 falou ao carregar: %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Monochromatic Dark</source>
        <translation type="obsolete">Sombra monocromática</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A dialog box showing all possible hyphens for each word will show up when you use the Extras, Hyphenate Text option.</source>
        <translation type="obsolete">Surgirá uma caixa de diálogo mostrando todos os possíveis hífens para cada palavra,
quando você usar a opção Extras, Hifenizar texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation type="obsolete">Ficheiros PostScript (*.ps);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Styles</source>
        <translation type="obsolete">Estilos disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quarto</source>
        <translation type="obsolete">Quarto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove</source>
        <translation type="obsolete">Remover</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rename</source>
        <translation type="obsolete">Renomear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resize</source>
        <translation type="obsolete">Redimensionar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Result</source>
        <translation type="obsolete">Resultado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Width:</source>
        <translation type="obsolete">Espessura da linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fit to Width</source>
        <translation type="obsolete">Ajustar à &amp;Largura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Margins</source>
        <translation type="obsolete">Margem esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Color Settings</source>
        <translation type="obsolete">Configurações da cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right:</source>
        <translation type="obsolete">Direita:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Background color - under the code lines</source>
        <translation type="obsolete">Cor de plano de fundo - abaixo das linhas de código</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotate</source>
        <translation type="obsolete">Rotacionar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>(No data on your computer will be sent to an external location)</source>
        <translation type="obsolete">(Não será enviado nenhum dado do seu computador para o exterior)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resize the scale of the page.</source>
        <translation type="obsolete">Redimensiona a escala da página.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample</source>
        <translation type="obsolete">Exemplo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Location</source>
        <translation type="obsolete">&amp;Localização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align/Distribute</source>
        <translation type="obsolete">Alinhar/Distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scale%</source>
        <translation type="obsolete">Escalar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scale:</source>
        <translation type="obsolete">Escala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Screen</source>
        <translation type="obsolete">Tela</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Script</source>
        <translation type="obsolete">Script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sh&amp;ade</source>
        <translation type="obsolete">So&amp;mbrear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Script</source>
        <translation type="obsolete">Sem Script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search</source>
        <translation type="obsolete">Procurar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lock All</source>
        <translation type="obsolete">&amp;Bloquear todos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>There are no options for this type of frame</source>
        <translation type="obsolete">Não há opções para este tipo de caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shade:</source>
        <translation type="obsolete">Intensidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shape:</source>
        <translation type="obsolete">Forma:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shapes</source>
        <translation type="obsolete">Formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shift+</source>
        <translation type="obsolete">Shift+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Brochures</source>
        <translation type="obsolete">Brochuras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Vector</source>
        <translation type="obsolete">Mover vetor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Script</source>
        <translation type="obsolete">Novo Script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Signs:</source>
        <translation type="obsolete">Assinaturas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla *.scd);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>node &lt;%1&gt; not an element</source>
        <translation type="obsolete">o nó &lt;%1&gt; não é um elemento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as &amp;Image...</source>
        <translation type="obsolete">Salvar como &amp;imagem...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation type="obsolete">Uniformizar os espaços verticais entre os objectos e o topo e fundo das margens da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Slovak</source>
        <translation type="obsolete">Eslovaco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Substitutions</source>
        <translation type="obsolete">Fontes substitutas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Unsorted</source>
        <translation type="obsolete">&amp;Desordenado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>St&amp;yle</source>
        <translation type="obsolete">E&amp;stilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot find plugin</source>
        <translation type="obsolete">Não é possível encontrar o plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Perfil de cor padrão para imagens CMYK importadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Square</source>
        <translation type="obsolete">Quadrado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Supported Formats</source>
        <translation type="obsolete">Todos os formatos suportados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Installed interface languages for Scribus are as follows:</source>
        <translation type="obsolete">Os idiomas de interface instalados no Scribus são os seguintes:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start:</source>
        <translation type="obsolete">início:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Status</source>
        <translation type="obsolete">Status</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>October</source>
        <translation type="obsolete">Outubro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>String</source>
        <translation type="obsolete">String</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Subset</source>
        <translation type="obsolete">Sublistar (subset)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style:</source>
        <translation type="obsolete">Estilo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document</source>
        <translation type="obsolete">Documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sunday</source>
        <translation type="obsolete">Domingo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Specified item not an image frame.</source>
        <translation type="obsolete">O item especificado não é um quadro de imagem.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>System</source>
        <translation type="obsolete">Sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Title:</source>
        <translation type="obsolete">Título:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X-Pos:</source>
        <translation type="obsolete">Pos.X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation type="obsolete">Distribuir os centros uniformemente na vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Unlock All</source>
        <translation type="obsolete">&amp;Destravar todos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Renderização pretendida para a sua impressora. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert PDF List Box</source>
        <translation type="obsolete">Inserir uma caixa de listagem PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot find symbol (%1)</source>
        <translation type="obsolete">Não é possível encontrar o símbolo (%1)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Contrast:</source>
        <translation type="obsolete">Contraste:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Field is formatted as:</source>
        <translation type="obsolete">O campo está formatado como:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Action History</source>
        <translation type="obsolete">Histórico de ações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="obsolete">Indicador da cor de camada - Cada camada tem atribuída uma cor para exibir no no ecrã quando os indicadores de camada estão activados. pode fazer um duplo clique para editar a cor.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Settings</source>
        <translation type="obsolete">Configurações de impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y-Pos:</source>
        <translation type="obsolete">Pos.Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Other Documentation:</source>
        <translation type="obsolete">Outras documentações:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number:</source>
        <translation type="obsolete">&amp;Número:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Rulers</source>
        <translation type="obsolete">Mostrar réguas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Units:</source>
        <translation type="obsolete">Unidades:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unlock</source>
        <translation type="obsolete">Destravar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation type="obsolete">&lt;h3&gt;Sobre o Qt&lt;/h3&gt;&lt;p&gt;Esse programa usa versão %1 da Qt.&lt;/p&gt;&lt;p&gt;Qt é um conjunto de bibliotecas C++ para desenvolvimento de interfaces &amp;amp; aplicações multiplataforma.&lt;/p&gt;&lt;p&gt;A Qt oferece portabilidade de fontes entre MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, e a maioria das variantes comerciais de Unix.&lt;br&gt;A Qt também é disponível para dispositivos acoplados.&lt;/p&gt;&lt;p&gt;A Qt é um produto Trolltech. Acesse &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; para mais informações.&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Disable text flow from lower frames around object</source>
        <translation type="obsolete">Inactivar o fluir do texto das molduras inferiores ao redor do objecto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value:</source>
        <translation type="obsolete">Valor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply text style</source>
        <translation type="obsolete">Aplicar estilo de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation type="obsolete">Mostra transparência e ítens transparentes no seu documento. Requer o Ghostscript 7.07 ou mais recente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Screen / Web</source>
        <translation type="obsolete">Tela / Web</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancelled by user</source>
        <translation type="obsolete">Cancelado pelo utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Offset:</source>
        <translation type="obsolete">Deslocamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Offsets</source>
        <translation type="obsolete">Deslocamentos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>In the Foreground</source>
        <translation type="obsolete">Na frente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;hadow</source>
        <translation type="obsolete">S&amp;ombra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Viewer</source>
        <translation type="obsolete">Visualizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Look &amp;in:</source>
        <translation type="obsolete">Procurar &amp;em:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font System Initialized</source>
        <translation type="obsolete">Sistema de fontes inicializado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical position of current basepoint</source>
        <translation type="obsolete">Posição vertical do ponto-base atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;reate</source>
        <translation type="obsolete">C&amp;riar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tango Project Icons:</source>
        <translation type="obsolete">Ícones do projeto Tango:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tab Width:</source>
        <translation type="obsolete">Largura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object the last frame in a series, can&apos;t unlink. Unlink the previous frame instead.</source>
        <translation type="obsolete">Não é possível desconectar o último objeto de uma série. Separe o quadro anterior no lugar.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Generating Items</source>
        <translation type="obsolete">Gerando itens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Smallest Word:</source>
        <translation type="obsolete">&amp;Menor Palavra:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width:</source>
        <translation type="obsolete">Largura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Styles</source>
        <translation type="obsolete">Edita os estilos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Base Texts:</source>
        <translation type="obsolete">Textos de base:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Setting up the Python plugin failed. Error details were printed to stderr. </source>
        <translation type="obsolete">A configuração do plugin em Python falhou. Detalhes do erro foram impressos no stderr. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>TabDisplayBase</source>
        <translation type="obsolete">Exibir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Determines the overall height, in line numbers, of the Drop Caps</source>
        <translation type="obsolete">Determina o tamanho total, em número de linhas, da Capitulação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Typography</source>
        <translation type="obsolete">Tipografia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Limitar-se às margens da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print in Color if Available</source>
        <translation type="obsolete">Imprimir em cores, se disponível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CSV_header</source>
        <translation type="obsolete">Cabeçalho do CSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="obsolete">Espelhar página(s) horizontalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">Pode ver uma miniatura se você pressionar e segurar o botão direito do rato. A tecla &apos;Insert&apos; insere um caracter na seleção abaixo e &apos;Delete&apos; apaga o último item inserido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Date / Time:</source>
        <translation type="obsolete">Data / Hora:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>F&amp;rom the:</source>
        <translation type="obsolete">A partir &amp;de:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation type="obsolete">Uniformizar os espaços horizontais entre os objectos e os lados das margens da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make these settings the default and do not prompt again when importing an OpenOffice.org 1.x document.</source>
        <translation type="obsolete">Torna esta opção padrão e não solicita futuras confirmações quando importar um documento OpenOffice.org 1.x.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;By Number of Copies</source>
        <translation type="obsolete">&amp;Por número de cópias:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Styles</source>
        <translation type="obsolete">Estilos de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Style:</source>
        <translation type="obsolete">Estilos de linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yellow</source>
        <translation type="obsolete">Amarelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Image Frame</source>
        <translation type="obsolete">Moldura de &amp;imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Orientation</source>
        <translation type="obsolete">Orientação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of lines Scribus will scroll for each move of the mouse wheel</source>
        <translation type="obsolete">Número de linha roladas pelo programa a cada movimento da &quot;roda&quot; do mouse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot select text in a non-text frame</source>
        <translation type="obsolete">Não é possível selecionar um texto em um quadro que não seja de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>On Blur</source>
        <translation type="obsolete">On blur</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point list must contain at least two points (four values).</source>
        <translation type="obsolete">A lista de pontos deve conter ao menos dois pontos (quatro valores).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Short Words</source>
        <translation type="obsolete">Abreviaturas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the display of pictures on or off</source>
        <translation type="obsolete">Activa ou desactiva a visualização de imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remember Values</source>
        <translation type="obsolete">Lembrar valores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Non Zero</source>
        <translation type="obsolete">Diferentes de 0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icon only</source>
        <translation type="obsolete">Somente ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>List the currently installed interface languages</source>
        <translation type="obsolete">Lista os idiomas de interface atualmente instalados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text overflow</source>
        <translation type="obsolete">Excesso de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Hyphenation Suggestions</source>
        <translation type="obsolete">Sugestões de &amp;hifenização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Splashscreen on Startup</source>
        <translation type="obsolete">Mostrar a ecrã de entrada no início</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Some ICC profiles used by this document are not installed:</source>
        <translation type="obsolete">Alguns perfis ICC utilizados por esse documento não estão instalados:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Action &amp;History</source>
        <translation type="obsolete">&amp;Histórico de ações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font for new text frames</source>
        <translation type="obsolete">Fonte para novas molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>has been changed since the last save.</source>
        <translation type="obsolete">foi alterado desde o último salvamento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get number of lines of non-text frame.</source>
        <translation type="obsolete">Não é possível definir o número de colunas em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color &amp;Model</source>
        <translation type="obsolete">&amp;Modelo de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview File Contents</source>
        <translation type="obsolete">Visualizar conteúdo do ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Margins</source>
        <translation type="obsolete">Mostrar margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bleed Marks</source>
        <translation type="obsolete">Miras de sangria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Fonte selecionada para o texto ou o objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Blend Mode:</source>
        <translation type="obsolete">Modo de mistura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is Spot Color</source>
        <translation type="obsolete">É uma cor de separação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 (line %2 col %3)</source>
        <translation type="obsolete">%1 (linha %2 coluna %3)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printer Options</source>
        <translation type="obsolete">Opções da impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Bookmarks</source>
        <translation type="obsolete">&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Paragraph:</source>
        <translation type="obsolete">Parágrafo atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Marcadores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This is derived from standard Python console so it contains some limitations esp. in the case of whitespaces. Please consult Scribus manual for more informations.</source>
        <translation type="obsolete">Isto é uma derivação do console Python padrão, possuindo algumas limitações como no caso de espaços em branco. Por favor, consulte o manual do Scribus para maiores informações.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Capitulação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot insert text into non-text frame.</source>
        <translation type="obsolete">Não é possível inserir texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preflight Verifier</source>
        <translation type="obsolete">Verificador pré-publicação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.2.x Support</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.3.4 Support</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Results for: </source>
        <translation type="obsolete">Pesquisar resultados para: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Find &amp;Next</source>
        <translation type="obsolete">Procurar pró&amp;ximo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Odd Pages only</source>
        <translation type="obsolete">Somente páginas ímpares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Could not open version file: %1
Error:%2 at line: %3, row: %4</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro de preferências &quot;%1&quot; para gravar %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set font on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir a fonte em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color 3:</source>
        <translation type="obsolete">Cor 3:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color 4:</source>
        <translation type="obsolete">Cor 4:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color 1:</source>
        <translation type="obsolete">Cor 1:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color 2:</source>
        <translation type="obsolete">Cor 2:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colorize</source>
        <translation type="obsolete">Colorir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>When Icon is too small</source>
        <translation type="obsolete">Quando o ícone for muito pequeno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Line Color:</source>
        <translation type="obsolete">Cor da &amp;linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Romanian</source>
        <translation type="obsolete">Romeno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Toolti&amp;ps</source>
        <translation type="obsolete">Di&amp;cas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>paragraphs with more than</source>
        <translation type="obsolete">parágrafos com mais de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of &amp;Executable:</source>
        <translation type="obsolete">Nome do &amp;executável:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Columns:</source>
        <translation type="obsolete">Colunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Homepage</source>
        <translation type="obsolete">Página da Web</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>First row is a header</source>
        <translation type="obsolete">A primeira linha é um cabeçalho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Need selection or argument list of items to group</source>
        <translation type="obsolete">Para agrupar é necessária um seleção ou uma lista de argumentos de ítens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Minimum magnification allowed</source>
        <translation type="obsolete">Redução mínima permitida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Maximum magnification allowed</source>
        <translation type="obsolete">Ampliação máxima permitida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polyline</source>
        <translation type="obsolete">Linha poligonal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Bars</source>
        <translation type="obsolete">Barras de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Burn</source>
        <translation type="obsolete">Queimar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resize the image horizontally</source>
        <translation type="obsolete">Redimensiona a imagem horizontalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Sets</source>
        <translation type="obsolete">Conjuntos de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Minor Grid</source>
        <translation type="obsolete">Grelha menor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Major Grid</source>
        <translation type="obsolete">Grelha maior</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <translation type="obsolete">falta um &apos;value&apos; de atributo para elemento &lt;%1&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Command:</source>
        <translation type="obsolete">Comando:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comment:</source>
        <translation type="obsolete">Comentário:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption left to Icon</source>
        <translation type="obsolete">Legenda á esquerda do ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation of color of text fill</source>
        <translation type="obsolete">Saturação da cor do preenchimento de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply Under Color Removal</source>
        <translation type="obsolete">Aplicar Remoção de Sub-Cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro de preferências &quot;%1&quot; para gravar %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Submit Data as HTML</source>
        <translation type="obsolete">Enviar os dados como HTML</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Frame</source>
        <translation type="obsolete">Quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show location ICC profile information on console while starting</source>
        <translation type="obsolete">Mostrar informação de localização do perfil ICC na consola quando as arranca</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align right sides</source>
        <translation type="obsolete">Alinhar à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Fill Color:</source>
        <translation type="obsolete">Cor do &amp;preenchimento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Field</source>
        <translation type="obsolete">Campo de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Files</source>
        <translation type="obsolete">Ficheiros texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Indonesian</source>
        <translation type="obsolete">Indonésio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Guide</source>
        <translation type="obsolete">Editar guia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Child not found</source>
        <translation type="obsolete">Objeto filho não encontrado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Color</source>
        <translation type="obsolete">Editar cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Geometric Shapes</source>
        <translation type="obsolete">Formas geométricas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New MasterPage</source>
        <translation type="obsolete">Nova página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Selected Guide:</source>
        <translation type="obsolete">Guias &amp;selecionadas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not show objects outside the margins on the printed page</source>
        <translation type="obsolete">Não mostra os objetos fora das margens na página impressa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Get More:</source>
        <translation type="obsolete">Obter mais:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left Point</source>
        <translation type="obsolete">Ponto esquerdo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;ype of Line:</source>
        <translation type="obsolete">T&amp;ipo de linha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add Nodes</source>
        <translation type="obsolete">Adiciona um nó</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Documents</source>
        <translation type="obsolete">Documentos texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hard Light</source>
        <translation type="obsolete">Luz dura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Odd Pages</source>
        <translation type="obsolete">Páginas ímpares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>font %1 </source>
        <translation type="obsolete">fonte %1 </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Other Settings</source>
        <translation type="obsolete">Outras configurações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Soft Light</source>
        <translation type="obsolete">Luz suave</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the page size changes to all existing pages in the document</source>
        <translation type="obsolete">Aplica a alteração de tamanho de página em todas as páginas existentes do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Contents of Frame</source>
        <translation type="obsolete">Editar o conteúdo da caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lock Guides</source>
        <translation type="obsolete">&amp;Bloquear guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption right to Icon</source>
        <translation type="obsolete">Legenda á direita do ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Not Shown</source>
        <translation type="obsolete">Escondida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="obsolete">Um nome dado ao documento.Esse campo pode ser incorporado ao documento do Scribus para referência, assim como nos metadados do PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mid Space</source>
        <translation type="obsolete">Espaço médio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Contents</source>
        <translation type="obsolete">&amp;Conteúdo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Contents</source>
        <translation type="obsolete">Conteúdo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Contrast</source>
        <translation type="obsolete">Contraste</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Pictures</source>
        <translation type="obsolete">Mostrar imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Style</source>
        <translation type="obsolete">Editar estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zoom out</source>
        <translation type="obsolete">Reduzir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initializing Keyboard Shortcuts</source>
        <translation type="obsolete">Iniciando atalhos de teclado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Foolscap</source>
        <translation type="obsolete">Ferramentas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tooltip:</source>
        <translation type="obsolete">Di&amp;ca:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Frame &amp;Shape</source>
        <translation type="obsolete">Usar caixa e &amp;forma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Folder %1</source>
        <translation type="obsolete">Nova pasta %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">Moldura de &amp;texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text frame</source>
        <translation type="obsolete">Quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set fill color shade</source>
        <translation type="obsolete">Definir intensidade da cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Open...</source>
        <translation type="obsolete">&amp;Abrir...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Adjust frame to the image size</source>
        <translation type="obsolete">Ajustar caixa ao tamanho da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow copying of text or graphics from the PDF. If unchecked, text and graphics cannot be copied.</source>
        <translation type="obsolete">Permite a cópia de texto ou imagens do PDF. Se desmarcado, não se pode copiar texto nem imagens.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal offset of image within frame</source>
        <translation type="obsolete">Deslocamento horizontal da imagem dentro do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Get image</source>
        <translation type="obsolete">Obter imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of copies:</source>
        <translation type="obsolete">Número de cópias:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add layer</source>
        <translation type="obsolete">Adicionar nova camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>O&amp;dd pages</source>
        <translation type="obsolete">Páginas í&amp;mpares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus, Open Source Desktop Publishing</source>
        <translation type="obsolete">Scribus, Desktop Publishing de código aberto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">Tamanho da &amp;fonte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selected Fields</source>
        <translation type="obsolete">Campos selecionados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add pages</source>
        <translation type="obsolete">Adicionar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spacing:</source>
        <translation type="obsolete">Espaçamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Opacity:</source>
        <translation type="obsolete">Opacidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>End style</source>
        <translation type="obsolete">Editar estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Options</source>
        <translation type="obsolete">Opções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Options</source>
        <translation type="obsolete">&amp;Opções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy To:</source>
        <translation type="obsolete">Copiar para:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Postscript Options</source>
        <translation type="obsolete">Opções de PostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a Range of Pages</source>
        <translation type="obsolete">Organizar as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit shape</source>
        <translation type="obsolete">Editar Forma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page %1</source>
        <translation type="obsolete">Página %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page(s)</source>
        <translation type="obsolete">página(s)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to delete this style?</source>
        <translation type="obsolete">Você realmente deseja apagar esse estilo?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Underline Text. Hold down the button momentarily to set line width and displacement options.</source>
        <translation type="obsolete">Sublinha o texto. Pressione e segure o botão por um momento para definir as opções de largura e posicionamento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Official Documentation:</source>
        <translation type="obsolete">Documentação oficial:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to retrieve printer settings</source>
        <translation type="obsolete">Falha ao requisitar as configurações da impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File exists</source>
        <translation type="obsolete">Ficheiro existente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Item Attribute Name:</source>
        <translation type="obsolete">Nome de atributo do item:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>at End</source>
        <translation type="obsolete">no final</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro de preferências &quot;%1&quot; : %2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript Interpreter</source>
        <translation type="obsolete">Interpretador PostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Downloading Templates</source>
        <translation type="obsolete">Transferindo modelos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X1: %1, Y1: %2, %3
X2: %4, Y2: %5, %6</source>
        <translation type="obsolete">X1: %1, Y1: %2, %3
X2: %4, Y2: %5, %6</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Largura das páginas do documento. Editável se você escolheu um tamanho personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pattern</source>
        <translation type="obsolete">Padrão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Miscellaneous</source>
        <translation type="obsolete">Variados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add vertical guide</source>
        <translation type="obsolete">Adicionar guia vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation type="obsolete">Aplica a página modelo seleccionada nas páginas pares, ímpares ou em todas as páginas dentro do intervalo especificado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move vertical guide</source>
        <translation type="obsolete">Mover guia vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove vertical guide</source>
        <translation type="obsolete">Remover guia vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icon Placement...</source>
        <translation type="obsolete">Posicionamento do ícone...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Locate Startup Script</source>
        <translation type="obsolete">Localização do Script de inicialização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>portrait</source>
        <translation type="obsolete">retrato</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Portrait</source>
        <translation type="obsolete">Retrato</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>JavaScript</source>
        <translation type="obsolete">JavaScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation type="obsolete">Alinhar os fundos dos objectos ao topo da âncora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use &amp;Bounding Box</source>
        <translation type="obsolete">Usar &amp;delimitador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No shortcut for the style</source>
        <translation type="obsolete">Não há atalho para o estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="obsolete">Clique na roda para obter uma cor base. No modo HSV é chamado de tom.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotation</source>
        <translation type="obsolete">Rotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation type="obsolete">Escreva seus comandos aqui. Uma seleção é processada como um script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Original PPI: </source>
        <translation type="obsolete">PPI original: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>custom</source>
        <translation type="obsolete">personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document &amp;Templates:</source>
        <translation type="obsolete">&amp;Modelos de documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>8 digits</source>
        <translation type="obsolete">8 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>5 digits</source>
        <translation type="obsolete">5 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2 digits</source>
        <translation type="obsolete">2 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font stroke color</source>
        <translation type="obsolete">Definir cor de traço da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance of text from top of frame</source>
        <translation type="obsolete">Distância entre o texto e a borda superior do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font fill color shade</source>
        <translation type="obsolete">Definir intensidade da cor de preenchimento da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left indent</source>
        <translation type="obsolete">Indentação esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="obsolete">Cores &amp;sólidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Drawing Properties</source>
        <translation type="obsolete">Propriedades do desenho de linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>init failed</source>
        <translation type="obsolete">falhou ao iniciar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock guides</source>
        <translation type="obsolete">Bloquear guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to overwrite the File:
%1 ?</source>
        <translation type="obsolete">Deseja realmente sobrescrever o ficheiro:
%1?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Specials</source>
        <translation type="obsolete">Especiais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color model for the output of your PDF. Choose Screen/Web for PDFs which are used for screen display and for printing on typical inkjets. Choose Printer when printing to a true 4 color CMYK printer. Choose Grayscale when you want a grey scale PDF.</source>
        <translation type="obsolete">Modelo de cor para a saída do seu PDF. Selecione Tela/Web para PDF&apos;s que serão exibidos no no ecrã ou enviados para impressoras jato-de-tinta típicas.Selecione Impressora para enviar para uma impressora que suporte 4 cores CMYK. Selecione Tons de Cinza quando você desejar um PDF nessa escala.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save &amp;Linked Text Frames as PDF Articles</source>
        <translation type="obsolete">Sa&amp;lvar molduras de texto associadas
como artigos PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove All</source>
        <translation type="obsolete">Remover tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Contributions from:</source>
        <translation type="obsolete">Contribuições de:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>About &amp;Qt</source>
        <translation type="obsolete">Sobre a &amp;Qt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Up</source>
        <translation type="obsolete">Mover para cima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move To:</source>
        <translation type="obsolete">Mover para:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation type="obsolete">Você precisa reiniciar o aplicativo para efetuar as alterações.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Esperanto</source>
        <translation type="obsolete">Esperanto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mouse Up</source>
        <translation type="obsolete">Mouse up</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Don&apos;t use any Path</source>
        <translation type="obsolete">Não usar nenhum caminho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Outline</source>
        <translation type="obsolete">C&amp;ontorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Outline</source>
        <translation type="obsolete">Delineado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Outside</source>
        <translation type="obsolete">Fora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Slovenian</source>
        <translation type="obsolete">Esloveno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;elete</source>
        <translation type="obsolete">&amp;Apagar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>November</source>
        <translation type="obsolete">Novembro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overlay</source>
        <translation type="obsolete">Sobrepor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Properties</source>
        <translation type="obsolete">Propriedades</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Now opening the color manager.</source>
        <translation type="obsolete">Abrindo o gerenciador de cor.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export a range of pages to PDF</source>
        <translation type="obsolete">Exportar um intervalo de páginas para PDF </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation type="obsolete">%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert A Frame</source>
        <translation type="obsolete">Inserir uma caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as &amp;EPS...</source>
        <translation type="obsolete">Salvar como &amp;EPS...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lower to &amp;Bottom</source>
        <translation type="obsolete">Baixar para o &amp;fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement below the baseline of the normal font expressed as a percentage of the fonts descender</source>
        <translation type="obsolete">Deslocamento baixo da pauta de uma fonte normal expressa em percentagem de fontes descendentes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line at Top</source>
        <translation type="obsolete">Linha acima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Windows&amp;#174; Port:</source>
        <translation type="obsolete">Versão para Windows&amp;#174;:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Layers in your document are exported to the PDF Only available if PDF 1.5 is chosen.</source>
        <translation type="obsolete">As camadas em seu documento são exportadas para o PDF .Disponível somente se o PDF 1.5 for selecionado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> from 0</source>
        <translation type="obsolete"> de 0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Outline. Hold down the button momentarily to change the outline stroke width.</source>
        <translation type="obsolete">Delinea o texto. Pressione e segure o botão por um momento para alterar a espessura do traço.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as PDF</source>
        <translation type="obsolete">Salvar como PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Insira as páginas desejadas, separadas por vírgulas.
Você pode usar * para todas as páginas, 1-5 para uma
seqüência de páginas ou o número de uma única página.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top-left to Bottom-Right</source>
        <translation type="obsolete">Do esquerda-acima para direita-abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image Processing Tool</source>
        <translation type="obsolete">Ferramenta de processamento de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the default zoom level</source>
        <translation type="obsolete">Define o nível padrão do zoom</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This message is in your clipboard too. Use Ctrl+V to paste it into bug tracker.</source>
        <translation type="obsolete">Essa mensagem também está na sua área de transferências. Use Ctrl+V para colá-la no registro de erros.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation type="obsolete">Número variável de caracteres, dígitos e qualquer outro símbolo -. *$/+%.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Properties</source>
        <translation type="obsolete">&amp;Propriedades</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation type="obsolete">Uma referência não ambígua ao documento, com um determinado contexto, tal como ISBN ou URI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Control Points Independently</source>
        <translation type="obsolete">Move os pontos de controle de forma independente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Automatic check before printing or exporting</source>
        <translation type="obsolete">Verificar automaticamente antes de imprimir ou exportar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Automatically scaled pictures keep their original proportions</source>
        <translation type="obsolete">As imagens dimensionadas automaticamente mantém suas proporções originais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documentation for:</source>
        <translation type="obsolete">Documentação para:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="obsolete">Perfil de cor padrão para cores sólidas CMYK na página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed a color profile for images</source>
        <translation type="obsolete">Incorpora um perfil de cores para as imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export only the current page</source>
        <translation type="obsolete">Exportar somente a página atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a new line</source>
        <translation type="obsolete">Adicionar uma nova linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preflight &amp;Verifier</source>
        <translation type="obsolete">&amp;Verificador pré-publicação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation type="obsolete">Adiciona o nome do documento na frente do nome do estilo de parágrafo no Scribus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pick...</source>
        <translation type="obsolete">Seleccionar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Picture</source>
        <translation type="obsolete">Imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert PDF Text Field</source>
        <translation type="obsolete">Inserir um campo de texto PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Baseline &amp;Offset:</source>
        <translation type="obsolete">&amp;Deslocamento da pauta:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Frame Break</source>
        <translation type="obsolete">Quebra de caixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Objects with their Page</source>
        <translation type="obsolete">Mover objetos junto com suas páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Include Fonts</source>
        <translation type="obsolete">&amp;Incluir as fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation type="obsolete">Adiciona um novo Script predefinindo a função com o mesmo nome. Se você deseja usar esse script como um script &quot;Open Action&quot;, não deve alterar o nome da função.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Execute Script...</source>
        <translation type="obsolete">&amp;Executar script...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selection index out of bounds</source>
        <translation type="obsolete">O índice de seleção está fora do limite</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Further &amp;Information</source>
        <translation type="obsolete">Outras &amp;informações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Tabulators</source>
        <translation type="obsolete">Gerir tabulações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>One or more updates for your version of Scribus (%1) are available:</source>
        <translation type="obsolete">Estão disponíveis uma ou mais actualizações para a sua versão do Scribus (%1):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation type="obsolete">Scripts Python (*.py)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;abulators...</source>
        <translation type="obsolete">T&amp;abulações...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Greek Extended</source>
        <translation type="obsolete">Grego Extendido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export a range of pages</source>
        <translation type="obsolete">Exportar um intervalo de páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color for paper</source>
        <translation type="obsolete">Cor do papel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to replace your existing image?</source>
        <translation type="obsolete">Você realmente deseja substituir a imagem existente?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You will clean all characters from this palette. Are you sure?</source>
        <translation type="obsolete">Apagará todos os caracteres desta paleta. Tem a certeza?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mouse Enter</source>
        <translation type="obsolete">Mouse enter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation type="obsolete">Se marcado, também haverá números no código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Always ask before fonts are replaced when loading a document</source>
        <translation type="obsolete">Sempre perguntar antes de substituir fontes ao carregar um documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simple Dot</source>
        <translation type="obsolete">Ponto simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>At the beginning</source>
        <translation type="obsolete">Ao começo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use &amp;Gap:</source>
        <translation type="obsolete">Usar &amp;lacuna:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">D&amp;uplicar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Down</source>
        <translation type="obsolete">Mover para baixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="obsolete">Selecione um do métodos para criar um esquema de cor. Veja a documentação para maiores informações.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Space below</source>
        <translation type="obsolete">Espaço abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Graus de rotação dos polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Display Font...</source>
        <translation type="obsolete">&amp;Exibir fonte...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type of line joins</source>
        <translation type="obsolete">Tipo de junção de linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Split &amp;Polygons</source>
        <translation type="obsolete">Separar os &amp;polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sna&amp;p to Guides</source>
        <translation type="obsolete">A&amp;trair às guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color for the margin lines</source>
        <translation type="obsolete">Cor das linhas da margem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugins</source>
        <translation type="obsolete">Plugins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add, change or remove color stops here</source>
        <translation type="obsolete">Adiciona, altera ou remove os pontos de mudança de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image frame</source>
        <translation type="obsolete">Quadro de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Space above</source>
        <translation type="obsolete">Espaço acima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Center on vertical axis</source>
        <translation type="obsolete">Centraliza no eixo vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clone of %1</source>
        <translation type="obsolete">Clone de %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation type="obsolete">Uma pessoa ou organização responsável por tornar o documento disponível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Printer Margins</source>
        <translation type="obsolete">Usar margens da impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom (optional) configuration: </source>
        <translation type="obsolete">Configuração (opcional) personalizada: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to save EPS.</source>
        <translation type="obsolete">Não foi possível salvar o EPS.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Toggles sample text of this paragraph style</source>
        <translation type="obsolete">Alterna o nome texto de amostra deste estilo de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Raise layer</source>
        <translation type="obsolete">Elevar camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Read-write</source>
        <translation type="obsolete">Leitura-escrita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>First Page is:</source>
        <translation type="obsolete">Primeira página:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Distância para sangria do topo da página física</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Base Color</source>
        <translation type="obsolete">Cor base</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Icons</source>
        <translation type="obsolete">Usar ícones</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Nodes</source>
        <translation type="obsolete">Move o nó</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Pages</source>
        <translation type="obsolete">Mover páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Nine Parts</source>
        <translation type="obsolete">Nove partes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Order</source>
        <translation type="obsolete">Ordem de paginação </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reading Font Cache</source>
        <translation type="obsolete">Lendo cache de fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenOffice.org 1.x Draw</source>
        <translation type="obsolete">Desenho do OpenOffice.org 1.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation type="obsolete">O tópico do conteúdo do documento.Esse campo é usado para as palavras-chaves que você deseja incorporar ao PDF, para auxiliar nas buscas e indexações dos ficheiros PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Compression &amp;Quality:</source>
        <translation type="obsolete">&amp;Qualidade da compressão:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between automatically created columns</source>
        <translation type="obsolete">Distância entre as colunas criadas automaticamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply Master Page</source>
        <translation type="obsolete">Aplicar página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Reversed</source>
        <translation type="obsolete">Revertida dupla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Style</source>
        <translation type="obsolete">Estilo de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Margin Guides</source>
        <translation type="obsolete">Guias das margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Size (Menus):</source>
        <translation type="obsolete">Tamanho da &amp;fonte (Menus):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polygon</source>
        <translation type="obsolete">Polígono</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Polygon</source>
        <translation type="obsolete">&amp;Polígono</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Read Only</source>
        <translation type="obsolete">Somente leitura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export...</source>
        <translation type="obsolete">Exportar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importer:</source>
        <translation type="obsolete">Importador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Posters</source>
        <translation type="obsolete">Posters</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color profile for images</source>
        <translation type="obsolete">Perfil de cores para imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Export...</source>
        <translation type="obsolete">&amp;Exportar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Import...</source>
        <translation type="obsolete">&amp;Importar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line color</source>
        <translation type="obsolete">Cor da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Im&amp;port...</source>
        <translation type="obsolete">Im&amp;portar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Control Points</source>
        <translation type="obsolete">Move os pontos de controle</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Gerir guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Uma forma de trocar alguns dos tons de cinza que são compostos de ciano, amarelo e magenta, usando preto no lugar. A RSC afeta mais as partes da imagem que são neutras ou em tons escuros, mais próximos do cinza. O uso disso pode melhorar a impressão de algumas imagens,mas recomenda-se que se façam testes para definir um melhor resultado para cada caso. A RSC reduz a possibilidade de supersaturação com tintas CMY.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply To</source>
        <translation type="obsolete">Aplicar a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Read-only</source>
        <translation type="obsolete">Somente leitura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Free items</source>
        <translation type="obsolete">Itens livres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line width</source>
        <translation type="obsolete">Espessura da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="obsolete">O texto flui à volta dos objectos nas camadas inferiores - Activando isto força as molduras de texto a fluir à volta dos outros objectos, mesmo nas camadas abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Document Pages</source>
        <translation type="obsolete">Todas as páginas do documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line shade</source>
        <translation type="obsolete">Dessombrear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Python Console</source>
        <translation type="obsolete">Console de Python do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <translation type="obsolete">A contagem das colunas está fora do limite, deve ser &gt;1.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation type="obsolete">Informação sobre os direitos associados ao e sobre o documento, por ex. direitos autorais, patente ou marca registrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display Trans&amp;parency</source>
        <translation type="obsolete">Mostrar trans&amp;parência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin: %1 loaded</source>
        <translation type="obsolete">Plugin: %1 carregado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line style</source>
        <translation type="obsolete">Estilos de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font of selected text</source>
        <translation type="obsolete">Fonte de texto selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Fonts Preview...</source>
        <translation type="obsolete">Visualizar &amp;fontes...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>There was an internal error while trying the command you entered. Details were printed to stderr. </source>
        <translation type="obsolete">Ocorreu um erro interno enquanto tentava o comando que você forneceu. Detalhes foram impressos no stderr. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ALT+SHIFT+T</source>
        <translation type="obsolete">ALT+SHIFT+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Converting of %1 images failed!</source>
        <translation type="obsolete">A converção de %1 imagens falharam!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pressed</source>
        <translation type="obsolete">Premido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Visualizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Color Set:</source>
        <translation type="obsolete">Conjunto de cores atual:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print: </source>
        <translation type="obsolete">Imprimir: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printer</source>
        <translation type="obsolete">Impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thickness of line</source>
        <translation type="obsolete">Espessura da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Length of the smallest word to be hyphenated.</source>
        <translation type="obsolete">Comprimento da menor palavra a ser hifenizada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Split Complementary</source>
        <translation type="obsolete">Separar complementares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Conve&amp;rt to</source>
        <translation type="obsolete">Conve&amp;rter em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>product</source>
        <translation type="obsolete">o produto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use filename as path for user given preferences</source>
        <translation type="obsolete">Usar o nome de ficheiro como caminho para as preferências do utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="obsolete">Definir estilo de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation type="obsolete">Erro de leitura do ficheiro %1 - provávelmente está corrompido.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Get Image...</source>
        <translation type="obsolete">Obter imagem...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-tracking </source>
        <translation type="obsolete">-espaçamento </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Annotation Properties</source>
        <translation type="obsolete">Propriedades da anotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>When Icon is too big</source>
        <translation type="obsolete">Quando o ícone for muito grande</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample Page Order:</source>
        <translation type="obsolete">Apagar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New From Template</source>
        <translation type="obsolete">Novo a partir do modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>September</source>
        <translation type="obsolete">Setembro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Trademark</source>
        <translation type="obsolete">Trademark</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the style of line end</source>
        <translation type="obsolete">Definir estilo de final de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot create directory: 
%1</source>
        <translation type="obsolete">Não é possível criar directório: 
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;qt&gt;Add the path for the Ghostscript interpreter. On Windows, please note it is important to note you need to use the program named gswin32c.exe - NOT gswin32.exe. Otherwise, this maybe cause a hang when starting Scribus.&lt;/qt&gt;</source>
        <translation type="obsolete">Adicione o caminho para o interpretador Ghostscript. É importante notar que, no Windows, precisa usar o programa com o nome gswin32c.exe e NÃO o gswin32.exe, caso contrário isto poderá causar o travamento do Scribus durante a sua abertura.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Options:</source>
        <translation type="obsolete">Opções:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Could not open input file %1</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro de entrada %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical Gradient</source>
        <translation type="obsolete">Gradiente vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Left</source>
        <translation type="obsolete">Normal Esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Descri&amp;ption:</source>
        <translation type="obsolete">Descri&amp;ção:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy Here</source>
        <translation type="obsolete">Copiar aqui</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy Page</source>
        <translation type="obsolete">Copiar página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>How to run</source>
        <translation type="obsolete">Como executar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image &amp;Type:</source>
        <translation type="obsolete">&amp;Tipo de imagem:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polygon Properties</source>
        <translation type="obsolete">Propriedades do polígono</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unable to Rename Master Page</source>
        <translation type="obsolete">Não foi possível mudar o nome da página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert a comma separated list of tokens where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="obsolete">Insira as páginas desejadas, separadas por vírgulas. Você pode usar * para todas as páginas, 1-5 para uma seqüência de páginas ou o número de uma única página.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation type="obsolete">Uniformizar os espaços verticais entre os objectos e o topo e fundo da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print &amp;Range</source>
        <translation type="obsolete">Imprimir inte&amp;rvalo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical displacement of page items</source>
        <translation type="obsolete">Deslocação vertical dos itens de página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lossy - JPEG</source>
        <translation type="obsolete">Com perdas - JPEG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replacement</source>
        <translation type="obsolete">Substituta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the transparency for the color selected</source>
        <translation type="obsolete">Definir a transparência para a cor selecionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Startup Dialog</source>
        <translation type="obsolete">Mostrar diálogo inicial</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shear the Path Vertically Up</source>
        <translation type="obsolete">Deforma o caminho verticalmente para cima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add Profile</source>
        <translation type="obsolete">Adicionar perfil</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Nu&amp;mber:</source>
        <translation type="obsolete">Nú&amp;mero:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PS/EPS Importer</source>
        <translation type="obsolete">Importador de PS/EPS</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Perfil de cor padrão para imagens RGB importadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show information on the console when fonts are being loaded</source>
        <translation type="obsolete">Mostra informações no console quando as fontes estão sendo carregadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Set</source>
        <translation type="obsolete">Conjunto das páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Magazine</source>
        <translation type="obsolete">Revista</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Miscellaneous Symbols</source>
        <translation type="obsolete">Símbolos variados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">A Compensação de Pontos Negros é um método para melhorar o contraste nas fotos.
Recomenda-se que você active esta opção caso tenha fotos em seu documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Defina as dimensões desejadas no diálogo X: Y: abaixo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing Pages...</source>
        <translation type="obsolete">Importando páginas...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>E&amp;xtras</source>
        <translation type="obsolete">E&amp;xtras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you want to save your changes?</source>
        <translation type="obsolete">Deseja salvar suas alterações?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit styles</source>
        <translation type="obsolete">Editar estilos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal scaling of images</source>
        <translation type="obsolete">Escala horizontal das imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scale &amp;To Frame Size</source>
        <translation type="obsolete">Redimensionar para o &amp;tamanho do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a filename to save under</source>
        <translation type="obsolete">Seleccione um nome de ficheiro para salvar como</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width of lines</source>
        <translation type="obsolete">Espessura das linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font st&amp;yle</source>
        <translation type="obsolete">&amp;Estilo da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Locate your web browser</source>
        <translation type="obsolete">Localize o ser navegador web</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A file named &apos;%1&apos; already exists.&lt;br/&gt;Do you want to replace it with the file you are saving?</source>
        <translation type="obsolete">O ficheiro %1 já existe.&lt;br/&gt;Deseja realmente substitui-lo pelo que está a salvar?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exporting Master Page:</source>
        <translation type="obsolete">Exportando página modelo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Full Character Set</source>
        <translation type="obsolete">Conjunto completo de caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error Writing Preferences</source>
        <translation type="obsolete">Erro de gravação das preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Close this Bezier Curve</source>
        <translation type="obsolete">Fecha essa curva de Bezier</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as &amp;SVG...</source>
        <translation type="obsolete">Salvar a página como &amp;SVG...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line style of shapes</source>
        <translation type="obsolete">Estilo da linha das formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply settings to:</source>
        <translation type="obsolete">Aplicar configurações a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy or Move a File</source>
        <translation type="obsolete">Copiar ou mover um ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Attach Text to Path</source>
        <translation type="obsolete">&amp;Unir o texto ao caminho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>1st. Triadic</source>
        <translation type="obsolete">1° tritom</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not ask again</source>
        <translation type="obsolete">Não pergunte novamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Include La&amp;yers</source>
        <translation type="obsolete">Inc&amp;luir camadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <translation type="obsolete">falta um &apos;name&apos; de atributo para elemento &lt;lpiSettingsEntry&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default font size for the menus and windows</source>
        <translation type="obsolete">Tamanho padrão da fonte dos menus e janelas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Some objects are locked.</source>
        <translation type="obsolete">Alguns objetos estão travados.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copyright</source>
        <translation type="obsolete">Direitos de autor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Page Number</source>
        <translation type="obsolete">Inserir número de página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Glyphs missing</source>
        <translation type="obsolete">Caracteres faltando</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation type="obsolete">&lt;qt&gt;Deseja realmente apagar %1 &quot;%2&quot;?&lt;/qt&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to S&amp;crapbook</source>
        <translation type="obsolete">Enviar para o Bloco de &amp;Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Monochromatic Light</source>
        <translation type="obsolete">Luz monocromática</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Removing a template</source>
        <translation type="obsolete">Removendo um modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert all colors to printer space</source>
        <translation type="obsolete">Converte todas as cores para o espaço de cor da impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preparing a template</source>
        <translation type="obsolete">Preparando um modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>2nd. Triadic</source>
        <translation type="obsolete">2° Tritom</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <translation type="obsolete">abcdefghijklmnopqrstuvxyzáéíóúàãõâêôü</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>before Page</source>
        <translation type="obsolete">antes da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Activa a conversão de cores de separações (Spot Colors) por cores de composição. Ao menos que você esteja planejando imprimir por separações em uma impressora comercial, provavelmente é melhor deixar essa opção habilitada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pre-Press</source>
        <translation type="obsolete">Pré-Impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>General Punctuation</source>
        <translation type="obsolete">Pontuação geral</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text for Roll Over</source>
        <translation type="obsolete">Texto ao passar o ponteiro do mouse (roll over)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Reversed</source>
        <translation type="obsolete">Revertida simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Galician</source>
        <translation type="obsolete">Galego</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Validate</source>
        <translation type="obsolete">Validar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Percentage increase over the font size for the line spacing</source>
        <translation type="obsolete">Incremento percentual sobre o tamanho da fonte, para a altura da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation type="obsolete">Oferece uma visualização da impressão usando simulações de tintas CMYK genéricas, ao invés de cores RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 (%2)</source>
        <translation type="obsolete">%1 (%2)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value at the left is a regular expression</source>
        <translation type="obsolete">O valor  à esquerda é uma expressão regular</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tetradic (Double Complementary)</source>
        <translation type="obsolete">Tritônico (duplo complementar)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Analogous</source>
        <translation type="obsolete">Análogas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scaling width of characters</source>
        <translation type="obsolete">Largura percentual dos caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Figure Dash</source>
        <translation type="obsolete">Marca de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Before Page</source>
        <translation type="obsolete">Antes da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Translating template.xml</source>
        <translation type="obsolete">Traduzindo o template.xml</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation type="obsolete">Uniformizar os espaços horizontais entre os objectos e os lados da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style of current paragraph</source>
        <translation type="obsolete">Estilo do parágrafo atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drag pages or master pages onto the trashbin to delete them</source>
        <translation type="obsolete">Arraste as páginas ou páginas modelo para a lixeira para exclui-las</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;hange...</source>
        <translation type="obsolete">Alt&amp;erar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ch&amp;ange...</source>
        <translation type="obsolete">Alter&amp;ar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Couldn&apos;t convert &apos;%1&apos; to property type &apos;%2&apos;</source>
        <translation type="obsolete">Não foi possível converter &apos;%1&apos; em uma propriedade tipo &apos;%2&apos;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The image type must be a string.</source>
        <translation type="obsolete">.O tipo de imagem deve ser uma seqüência de caracteres.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Adjusting Colors</source>
        <translation type="obsolete">Ajustando as cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF Forms</source>
        <translation type="obsolete">Formulários PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change...</source>
        <translation type="obsolete">Alterar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Language</source>
        <translation type="obsolete">Idioma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Size (&amp;Palettes):</source>
        <translation type="obsolete">Tamanho da &amp;fonte (Paletas):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports most EPS files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Importa a maioria dos ficheiros EPS para o documento actual,
convertendo seus dados vetoriais em objectos do Scribus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Change...</source>
        <translation type="obsolete">&amp;Alterar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Creating Font Cache</source>
        <translation type="obsolete">Criando cache de fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>argument is not list: must be list of float values.</source>
        <translation type="obsolete">o argumento não é lista: deve ser uma lista de valores flutuantes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align Text Right</source>
        <translation type="obsolete">Alinhar o texto à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF Tools</source>
        <translation type="obsolete">Ferramentas de PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;p&gt;You are trying to import more pages than there are available in the current document counting from the active page.&lt;/p&gt;Choose one of the following:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Create&lt;/b&gt; missing pages&lt;/li&gt;&lt;li&gt;&lt;b&gt;Import&lt;/b&gt; pages until the last page&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancel&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</source>
        <translation type="obsolete">&lt;p&gt;Você está tentando importar mais páginas do que as disponíveis no documento atual, contando a partir da página ativa.&lt;/p&gt;Escolha uma das opções:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Criar&lt;/b&gt; as páginas que faltam&lt;/li&gt;&lt;li&gt;&lt;b&gt;Importar&lt;/b&gt; as páginas até a última página&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancelar&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Percent Format</source>
        <translation type="obsolete">Formato da Percentagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Seleciona o ponto-base abaixo e à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>P&amp;DF Tools</source>
        <translation type="obsolete">Ferramentas de P&amp;DF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;CMYK Pictures:</source>
        <translation type="obsolete">Imagens &amp;CMYK:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CSV Importer Options</source>
        <translation type="obsolete">Opções do importador CSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Japanese</source>
        <translation type="obsolete">Japonês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical scaling of images</source>
        <translation type="obsolete">Escala vertical das imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Place a ruler against your screen and drag the slider to set the zoom level so Scribus will display your pages and objects on them at the correct size</source>
        <translation type="obsolete">Coloque uma régua sobre seu monitor e arraste o barra deslizante para configurar o nível de aproximação (zoom), assim o Scribus irá exibir suas páginas e objetos no tamanho correto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make these substitutions permanent</source>
        <translation type="obsolete">Tornar essas substituições permanentes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Determines the binding of pages in the PDF. Unless you know you need to change it leave the default choice - Left.</source>
        <translation type="obsolete">Determina o encardenamento das páginas no PDF. Ao menos que você saiba que precisa alterar essa opção, deixe o padrão marcado (Esquerda).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Ocorreu um erro na gravação do(s) ficheiro(s) de saída.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No updates are available for your version of Scribus %1</source>
        <translation type="obsolete">Não há actualizações disponíveis para a sua versão do Scribus %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set text fill on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir o preenchimento de texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Additional &amp;Paths</source>
        <translation type="obsolete">&amp;Caminhos adicionais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Determines the PDF compatibility.&lt;br/&gt;The default is &lt;b&gt;PDF 1.3&lt;/b&gt; which gives the widest compatibility.&lt;br/&gt;Choose &lt;b&gt;PDF 1.4&lt;/b&gt; if your file uses features such as transparency or you require 128 bit encryption.&lt;br/&gt;&lt;b&gt;PDF 1.5&lt;/b&gt; is necessary when you wish to preserve objects in separate layers within the PDF.&lt;br/&gt;&lt;b&gt;PDF/X-3&lt;/b&gt; is for exporting the PDF when you want color managed RGB for commercial printing and is selectable when you have activated color management. Use only when advised by your printer or in some cases printing to a 4 color digital color laser printer.</source>
        <translation type="obsolete">Determina a compatibilidade do PDF. O padrão é o PDF 1.3, que oferece a compatibilidade mais ampla. Seleccione PDF 1.4 se o seu ficheiro possuir características de transparência, ou se você necessitar de criptografia de 128 bit. PDF 1.5 é necessário quando você deseja preservar os objetos em camadas separadas dentro do PDF. O PDF/X-3 é usado quando você deseja gerir as cores RGB para impressoras comerciais e é seleccionável quando a gestão de cores está activada. Use apenas quando requerido por sua impressora ou em alguns casos de impressão em impressoras digitais a laser de 4 cores.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The file %1 does not contain any new colors.
If the file was an EPS try to import it with File -&gt; Import</source>
        <translation type="obsolete">O ficheiro %1 não contém nenhuma cor nova.
Se o ficheiro era um EPS tente importá-lo com Ficheiro-&gt;Importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tracking</source>
        <translation type="obsolete">-espaçamento </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align left sides</source>
        <translation type="obsolete">Alinhar à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Radius:</source>
        <translation type="obsolete">Raio:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Characters</source>
        <translation type="obsolete">Caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Square Cap</source>
        <translation type="obsolete">Ponta quadrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Frame...</source>
        <translation type="obsolete">&amp;Moldura...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parameter</source>
        <translation type="obsolete">Parâmetro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scrapbook</source>
        <translation type="obsolete">&amp;Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Character</source>
        <translation type="obsolete">&amp;Caractere</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDB_data</source>
        <translation type="obsolete">Dados_PDB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scrapbook</source>
        <translation type="obsolete">Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot scale by 0%.</source>
        <translation type="obsolete">Não é possível escalar em 0%.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Adjust Frame to Image</source>
        <translation type="obsolete">Ajustar quadro à imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character</source>
        <translation type="obsolete">Caractere</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <translation type="obsolete">A intensidade da linha está fora do limite, deve ser &gt;=0 e &lt;=100.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Barcode</source>
        <translation type="obsolete">Código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Online Help</source>
        <translation type="obsolete">Ajuda online do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Find &amp;Previous</source>
        <translation type="obsolete">Procurar a&amp;nterior</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Use Contour Line</source>
        <translation type="obsolete">&amp;Usar linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Color Wheel...</source>
        <translation type="obsolete">&amp;Roda de Cor...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text flows around contour line</source>
        <translation type="obsolete">O texto flui ao redor da linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space below the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Define a quantidade de espaço -- abaixo da ecrã do documento -- disponívelcomo um área de colagem para criar e modificar elementos, arrastando-os para a página ativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Activar uma &apos;previsão calculada&apos; de como serão impressas
as cores do seu documento, baseada no perfil de impressora selecionado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute the items with the distance specified</source>
        <translation type="obsolete">Distribuir os ítens com a distância especificada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation type="obsolete">Você não pode criar uma cor chamada &quot;%1&quot;.
 Este nome é reservado para cor transparente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">&amp;Número de Cópias:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotation of object at current basepoint</source>
        <translation type="obsolete">Rotação do objeto no ponto-base atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to Layer</source>
        <translation type="obsolete">Enviar para a camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reading Scrapbook</source>
        <translation type="obsolete">Lendo o Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arrows:</source>
        <translation type="obsolete">Setas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Artist:</source>
        <translation type="obsolete">Artista:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Based on</source>
        <translation type="obsolete">Baseado em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space above the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Define a quantidade de espaço -- acima da ecrã do documento -- disponívelcomo um área de colagem para criar e modificar elementos, arrastando-os para a página ativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save the current color set</source>
        <translation type="obsolete">Salvar o conjunto de cores actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font for use with PDF 1.3:</source>
        <translation type="obsolete">Fonte a ser usada com o PDF 1.3:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To adjust the display drag the ruler below with the slider.</source>
        <translation type="obsolete">Para ajustar a exibição, arraste a régua abaixo com o controle deslizante.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Picture Frame Properties</source>
        <translation type="obsolete">Propriedades do quadro de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Catalogs</source>
        <translation type="obsolete">Catálogos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relates To</source>
        <translation type="obsolete">Relativo a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Transparency Settings</source>
        <translation type="obsolete">Configurações de transparência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Display Duration:</source>
        <translation type="obsolete">&amp;Duração da exibição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Password</source>
        <translation type="obsolete">Senha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation type="obsolete">Alterna entre interpolação linear e cúbica da curva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Category</source>
        <translation type="obsolete">Categoria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Apply Effect on all Pages</source>
        <translation type="obsolete">&amp;Aplicar o efeito em todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PathText</source>
        <translation type="obsolete">Caminho de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Load from File...</source>
        <translation type="obsolete">&amp;Ler a partir do ficheiro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="obsolete">Apagar guias da &amp;página actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <translation type="obsolete">O tamanho da fonte está fora do limite, deve ser &gt;=1 e &lt;=512.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Analyzing PostScript:</source>
        <translation type="obsolete">Analizando PostScript:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Blendmode used</source>
        <translation type="obsolete">Modo de mistura utilizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Embed all</source>
        <translation type="obsolete">&amp;Incorporar todas as fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to layer</source>
        <translation type="obsolete">Enviar para camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Patterns</source>
        <translation type="obsolete">Padrões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embedding</source>
        <translation type="obsolete">Incorporações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;ICC Profiles:</source>
        <translation type="obsolete">Perfis &amp;ICC:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert Spot Colors</source>
        <translation type="obsolete">Converter em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Has Embedded Profile:</source>
        <translation type="obsolete">Possui perfil embarcado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturday</source>
        <translation type="obsolete">Sábado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Customize...</source>
        <translation type="obsolete">Personalizar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;JavaScripts...</source>
        <translation type="obsolete">&amp;JavaScripts...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Visibility:</source>
        <translation type="obsolete">Visibilidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Scheme Method</source>
        <translation type="obsolete">Selecione o método:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CSV_data</source>
        <translation type="obsolete">Dados do CSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">Substitui&amp;r</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace</source>
        <translation type="obsolete">Substituir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow &amp;Printing the Document</source>
        <translation type="obsolete">Permite a &amp;impressão do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Restore</source>
        <translation type="obsolete">&amp;Restaurar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Author:</source>
        <translation type="obsolete">&amp;Autor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Author:</source>
        <translation type="obsolete">Autor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>average</source>
        <translation type="obsolete">a média</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Beveled</source>
        <translation type="obsolete">Chanfrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview:</source>
        <translation type="obsolete">Visualizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Image...</source>
        <translation type="obsolete">Editar imagem...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Switches Color Management on or off</source>
        <translation type="obsolete">Activa ou desactiva a gestão de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation type="obsolete">Aplicar as alterações de margem a todas as páginas modelo existentes no documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Floating Orientation...</source>
        <translation type="obsolete">Flutuar na...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line at the Right </source>
        <translation type="obsolete">Linha á direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search finished</source>
        <translation type="obsolete">Fim da procura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Full Resolution</source>
        <translation type="obsolete">&amp;Alta resolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This file contains some unsupported features</source>
        <translation type="obsolete">Este ficheiro SVG possui alguns recursos não suportados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export all pages</source>
        <translation type="obsolete">Exportar todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stop the showing of the splashscreen on startup. Writes an empty file called .neversplash in ~/.scribus.</source>
        <translation type="obsolete">Inibe o splashscreen no arranque. Escreve um ficheiro vazio chamado .neversplash in ~/.scribus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Highest allowed resolution</source>
        <translation type="obsolete">Maior resolução permitida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot create layer without a name.</source>
        <translation type="obsolete">Não é possível criar uma camada sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Maximize</source>
        <translation type="obsolete">Maximizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reading ICC Profiles</source>
        <translation type="obsolete">Lendo perfis ICC</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Generate &amp;Thumbnails</source>
        <translation type="obsolete">Gerar &amp;miniaturas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save the Python Commands in File</source>
        <translation type="obsolete">Salvar os comandos Python num ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as &amp;Template...</source>
        <translation type="obsolete">Salvar como &amp;modelo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fre&amp;quency:</source>
        <translation type="obsolete">Fre&amp;qüência:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get column count of non-text frame.</source>
        <translation type="obsolete">Não é possível contar as colunas de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the display of layer indicators on or off</source>
        <translation type="obsolete">Mostra ou esconde indicadores de camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Common Settings</source>
        <translation type="obsolete">Configurações comuns</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Find Directory</source>
        <translation type="obsolete">Encontrar o directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Attributes</source>
        <translation type="obsolete">Atributos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Afrikaans</source>
        <translation type="obsolete">Africano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for placed PDF Files</source>
        <translation type="obsolete">Procurar ficheiros PDF incorporados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Print...</source>
        <translation type="obsolete">Im&amp;primir...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print...</source>
        <translation type="obsolete">Imprimir...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">Imp&amp;ressora:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute tops equidistantly</source>
        <translation type="obsolete">Distribuir os topos  uniformemente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables lossless compression of text and graphics. Unless you have a reason, leave this checked. This reduces PDF file size.</source>
        <translation type="obsolete">Compressão sem perdas de texto e gráficos. Ao menos que você tenha uma razão, deixe isto selecionado. Isso reduz o tamanho do ficheiro PDF.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Grayscale</source>
        <translation type="obsolete">Tons de cinza</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">&amp;Cantos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">Aplicar perfis ICC</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="obsolete">Perfil de cor padrão para cores sólidas RGB na página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Template: </source>
        <translation type="obsolete">Modelos de documento: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page</source>
        <translation type="obsolete">Tal como a página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line at the Left</source>
        <translation type="obsolete">Linha á esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;hidden files</source>
        <translation type="obsolete">Exibir ficheiros &amp;ocultos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Re-sample your bitmap images to the selected DPI. Leaving this unchecked will render them at their native resolution. Enabling this will increase memory usage and slow down export.</source>
        <translation type="obsolete">Re-escala a resolução de suas imagens bitmap para o DPI selecionado. Se desmarcado, renderiza as imagens em sua resolução nativa. Isso pode aumentar o uso de memória e reduzir a velocidade de exportação.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;End Editing</source>
        <translation type="obsolete">Finalizar &amp;edição</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Magnification Level Defaults</source>
        <translation type="obsolete">Padrão do nível de ampliação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default Scripter scripts directory</source>
        <translation type="obsolete">Diretório padrão dos scripts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Include ICC Profiles</source>
        <translation type="obsolete">&amp;Incluir perfis ICC</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Grid</source>
        <translation type="obsolete">Mostrar &amp;grelha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Translations</source>
        <translation type="obsolete">&amp;Traduções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import Data</source>
        <translation type="obsolete">Importar dados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Page</source>
        <translation type="obsolete">Inserir Página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Line</source>
        <translation type="obsolete">Inserir uma linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import done</source>
        <translation type="obsolete">Importação concluída</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type of line end</source>
        <translation type="obsolete">Tipo de terminação de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unable to read settings XML:</source>
        <translation type="obsolete">Não foi possível ler as configurações do XML:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normalize</source>
        <translation type="obsolete">Normalizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saves this curve</source>
        <translation type="obsolete">Salva esta curva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default font size for the tool windows</source>
        <translation type="obsolete">Tamanho padrão de fonte para as janelas de ferramentas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Eye Dropper</source>
        <translation type="obsolete">&amp;Pipeta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point list must contain an even number of values.</source>
        <translation type="obsolete">A lista de pontos deve conter um número par de valores.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ca&amp;ncel</source>
        <translation type="obsolete">Ca&amp;ncelar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cross Diagonal Gradient</source>
        <translation type="obsolete">Gradiente diagonal cruzado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CTRL+ALT+SHIFT+W</source>
        <translation type="obsolete">CTRL+ALT+SHIFT+W</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space left of the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Define a quantidade de espaço -- à esquerda da ecrã do documento -- disponível como um área de colagem para criar e modificar elementos, arrastando-os para a página ativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change the output directory</source>
        <translation type="obsolete">Muda o directório de saída</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Group the selected objects</source>
        <translation type="obsolete">Agrupar objectos seleccionados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exporting PostScript File</source>
        <translation type="obsolete">Exportando ficheiro PostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Control Characters</source>
        <translation type="obsolete">Mostrar invisíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation type="obsolete">Usar a caixa rectangular circundante em vez do formato da caixa para o fluxo do texto de molduras de texto abaixo do objecto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Multiple Duplicate</source>
        <translation type="obsolete">Duplicações &amp;múltiplas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>i, ii, iii, ...</source>
        <translation type="obsolete">i, ii, iii, ...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Color</source>
        <translation type="obsolete">Nova cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Static Color Bars</source>
        <translation type="obsolete">Barras de cor estáticas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Entry</source>
        <translation type="obsolete">Nova entrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Description</source>
        <translation type="obsolete">Descrição</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Guide</source>
        <translation type="obsolete">Nova guia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Curve</source>
        <translation type="obsolete">Mostrar curva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Layer</source>
        <translation type="obsolete">Nova camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Name:</source>
        <translation type="obsolete">Novo nome:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Search/Replace...</source>
        <translation type="obsolete">Procurar/&amp;Substituir...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>scribus -l xx or scribus --lang xx, where xx is the language of choice.</source>
        <translation type="obsolete">scribus -l xx ou scribus --idioma xx, onde xx é o idioma escolhido.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Croatian</source>
        <translation type="obsolete">Croata</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Problems</source>
        <translation type="obsolete">Problemas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Style</source>
        <translation type="obsolete">Novo estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X-Sc&amp;ale:</source>
        <translation type="obsolete">Escala &amp;X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Profile:</source>
        <translation type="obsolete">Perfil:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Programs</source>
        <translation type="obsolete">Programas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Progress</source>
        <translation type="obsolete">Progesso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Can only link text frames.</source>
        <translation type="obsolete">Só é possível associar molduras de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Target is not an image frame.</source>
        <translation type="obsolete">O alvo não é um quadro de imagem.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Baseline Grid</source>
        <translation type="obsolete">Mostrar pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Apagar a(s) seleção(ões) atual(is).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fibonacci</source>
        <translation type="obsolete">Fibonacci</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to La&amp;yer</source>
        <translation type="obsolete">Enviar para a &amp;camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>I, II, III, ...</source>
        <translation type="obsolete">I, II, III, ...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Boolean</source>
        <translation type="obsolete">Booleano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object is not on a Page</source>
        <translation type="obsolete">o objecto não está numa página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Information</source>
        <translation type="obsolete">Informação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bottom:</source>
        <translation type="obsolete">Fundo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Bottom:</source>
        <translation type="obsolete">&amp;Inferior:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>About Qt</source>
        <translation type="obsolete">Sobre a Qt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Grouped:</source>
        <translation type="obsolete">Agrupado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Fill Color Properties</source>
        <translation type="obsolete">Edita propriedades da cor do preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Filters</source>
        <translation type="obsolete">Filtros de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation type="obsolete">O botão salvar será desactivado se você estiver tentando exportar para PDF/X-3 e a string de informação não aparecerá na aba PDF/X-3.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Column gap out of bounds, must be positive.</source>
        <translation type="obsolete">O espaço entre colunas está fora do limite, deve ser positivo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mouse Exit</source>
        <translation type="obsolete">Mouse exit</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mouse Down</source>
        <translation type="obsolete">Mouse down</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>U&amp;se Gap:</source>
        <translation type="obsolete">U&amp;sar lacuna:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Font</source>
        <translation type="obsolete">Usar fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Se&amp;arch</source>
        <translation type="obsolete">Procur&amp;ar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;caling:</source>
        <translation type="obsolete">Es&amp;cala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scaling:</source>
        <translation type="obsolete">E&amp;scala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scaling:</source>
        <translation type="obsolete">Escala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Picas (p)</source>
        <translation type="obsolete">Picas (p)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do Not Export Value</source>
        <translation type="obsolete">Não exportar valores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The name you have selected already exists. Please enter a different name for this new color.</source>
        <translation type="obsolete">O nome que você escolheu já existe. Por favor, forneça um nome diferente para essa nova cor.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Link Text Frames</source>
        <translation type="obsolete">Ligar molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cascade</source>
        <translation type="obsolete">&amp;Cascata</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Catalan</source>
        <translation type="obsolete">Catalão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unlock size</source>
        <translation type="obsolete">Liberar tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save As</source>
        <translation type="obsolete">Salvar como</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as</source>
        <translation type="obsolete">Salvar como</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the text and numbers</source>
        <translation type="obsolete">A Cor do texto e dos números</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot have an empty layer name.</source>
        <translation type="obsolete">Não é possível haver camadas sem nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y-Scal&amp;e:</source>
        <translation type="obsolete">Escala &amp;Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scaling</source>
        <translation type="obsolete">Escala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use embedded Clipping Path</source>
        <translation type="obsolete">Usar caminho incorporado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation type="obsolete">Activa/Desabilita a visualização da tinta Y (Amarelo)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Subscript</source>
        <translation type="obsolete">Subscrito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Preview...</source>
        <translation type="obsolete">Visualizar &amp;fontes...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pages per Sheet</source>
        <translation type="obsolete">páginas por Folha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Su&amp;bscript</source>
        <translation type="obsolete">Subsc&amp;rito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript</source>
        <translation type="obsolete">PostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Use Custom Rendering Settings</source>
        <translation type="obsolete">&amp;Usar configurações de renderização personalizadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Old .sla format support</source>
        <translation type="obsolete">Antigos formatos de .sla suportados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Isto permite que você definaexplicitamente o tamanho da mídia do ficheiro postscript.Não é recomendável, a menosque tenha sido requisitado porsua impressora.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Apply Master Page...</source>
        <translation type="obsolete">&amp;Aplicar página modelo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scr&amp;ipt</source>
        <translation type="obsolete">Sc&amp;ript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Script:</source>
        <translation type="obsolete">Script:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts to outline:</source>
        <translation type="obsolete">Fontes a sublistar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Merging</source>
        <translation type="obsolete">Mesclagem de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock or unlock the object</source>
        <translation type="obsolete">Trava ou destrava o objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inaccessible</source>
        <translation type="obsolete">Inacessível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Protanopia (Red)</source>
        <translation type="obsolete">Protanopia (Vermelho)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical:</source>
        <translation type="obsolete">Vertical:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Verticals</source>
        <translation type="obsolete">Verticais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete selected styles</source>
        <translation type="obsolete">Apagar estilo selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation type="obsolete">A fonte %1(%2) é um cópia da %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sorry, no manual available! Please see: http://docs.scribus.net for updated docs
and www.scribus.net for downloads.</source>
        <translation type="obsolete">Desculpe, mas ainda não existe nenhum manual disponível.
Por favor, acesse http://docs.scribus.net para encontrar
documentos atualizados e http://www.scribus.net para downloads.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search:</source>
        <translation type="obsolete">Procurar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Search:</source>
        <translation type="obsolete">&amp;Pesquisar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current document</source>
        <translation type="obsolete">Apagar todas as guias do documento actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Direction of the effect of moving lines for the split and blind effects.</source>
        <translation type="obsolete">Direção de movimentação das linhas para os efeitos Separação e Persiana.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guides are not visible through objects on the page</source>
        <translation type="obsolete">AS guias não são visíveis através de objetos na página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation type="obsolete">Você também deseja apagar todos objetos dessa camada?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation type="obsolete">O tamanho das imagens. 100% para tamanho normal, 200% para o dobro, etc.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Superscript</source>
        <translation type="obsolete">Sobrescrito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Percentage</source>
        <translation type="obsolete">Percentagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Perceptual</source>
        <translation type="obsolete">Perceptual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style Manager</source>
        <translation type="obsolete">Gerenciador de estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Switches between Gap or Column width</source>
        <translation type="obsolete">Alterna entre a largura do espaçamento e da coluna</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Development Version</source>
        <translation type="obsolete">Versão de desenvolvimento do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Exit without Saving</source>
        <translation type="obsolete">Sair s&amp;em salvar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Serbian</source>
        <translation type="obsolete">Sérvio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Russian</source>
        <translation type="obsolete">Russo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Insert...</source>
        <translation type="obsolete">&amp;Inserir...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ghostscript : You cannot use EPS images or Print Preview</source>
        <translation type="obsolete">Ghostscript: Você não pode utilizar imagens EPS ou visualizar impressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot change a color with an empty name.</source>
        <translation type="obsolete">Não é possível mudar uma cor sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printing failed!</source>
        <translation type="obsolete">Erro na impressão!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This key sequence is already in use</source>
        <translation type="obsolete">Essa seqüência de teclas já está em uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search finished, found %1 matches</source>
        <translation type="obsolete">Fim da procura, %1 item(s) encontrado(s)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock size</source>
        <translation type="obsolete">Bloquear tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the lines of the baseline grid</source>
        <translation type="obsolete">Distância entre as linhas de grelha da pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Norwegian</source>
        <translation type="obsolete">Norueguês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save the selected scrapbook</source>
        <translation type="obsolete">Salvar o Bloco de Rascunhos seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>English (British)</source>
        <translation type="obsolete">Inglês (Britânico)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation type="obsolete">O directório de saída - o lugar para armazenar suas imagens.
O nome do ficheiro exportado será &apos;nomedodocumento-númerodapágina.tipodoficheiro&apos;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Complementary</source>
        <translation type="obsolete">Complementar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Locate Ghostscript</source>
        <translation type="obsolete">Localização do Ghostscript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of text stroke</source>
        <translation type="obsolete">Cor da borda do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+shadow </source>
        <translation type="obsolete">+sombra </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-shadow </source>
        <translation type="obsolete">-sombra </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation type="obsolete">Cancela a substituição das fonte e o carregamento do documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Chars: </source>
        <translation type="obsolete">Caracteres: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sharpen</source>
        <translation type="obsolete">Nítidez</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of columns in a text frame</source>
        <translation type="obsolete">Número de colunas em um quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>N-Up Printing</source>
        <translation type="obsolete">Páginas por folha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Business Cards</source>
        <translation type="obsolete">Cartões de visita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colorspace:</source>
        <translation type="obsolete">Espaço de cor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Fit to Height</source>
        <translation type="obsolete">Ajustar à &amp;Altura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fit to Height</source>
        <translation type="obsolete">Ajustar à altura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview Mode</source>
        <translation type="obsolete">Prévisualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering intent for solid colors</source>
        <translation type="obsolete">Renderização pretendida para cores sólidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Chinese</source>
        <translation type="obsolete">Chinês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Freehand Line</source>
        <translation type="obsolete">Linha à mão-li&amp;vre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus - My Plugin</source>
        <translation type="obsolete">Scribus - Meu Plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">Documentos PDF (*.pdf);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation type="obsolete">%1
Ficheiro não encontrado.
Verifique o caminho e o nome do ficheiro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import Text Only</source>
        <translation type="obsolete">Importar apenas o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set image scaling</source>
        <translation type="obsolete">Definir escalamento de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenDocument Text Documents</source>
        <translation type="obsolete">Documentos de texto OpenDocument</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export all pages to PDF</source>
        <translation type="obsolete">Exportar todas páginas para PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Page Pre&amp;views</source>
        <translation type="obsolete">Mostrar &amp;visualização da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Here are all your master pages. To create a new page, drag a master page to the page view below</source>
        <translation type="obsolete">Aqui estão todas as páginas modelo. Para criar uma nova página, arraste uma página modelo para a visualização de páginas abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Effects</source>
        <translation type="obsolete">Efeitos disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This is an advanced setting which is not enabled by default. This should only be enabled when specifically requested by your printer and they have given you the exact details needed. Otherwise, your exported PDF may not print properly and is truly not portable across systems.</source>
        <translation type="obsolete">Essa é uma configuração avançada que não está habilitada por padrão. Ela deve ser ativada somente quando especificamente requerido pela sua impressora e você tiver os detalhes necessários exatos. Caso contrário, o seu PDF exportado poderá não imprimir corretamente e certamente não será portável para outros sistemas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search for:</source>
        <translation type="obsolete">Procurar por:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Decimals:</source>
        <translation type="obsolete">Decimais:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Could not open file %1</source>
        <translation type="obsolete">Não foi possível abrir o ficheiro %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Position:</source>
        <translation type="obsolete">&amp;Posição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the gridlines on or off</source>
        <translation type="obsolete">Activa ou desactiva as linhas da grelha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Position:</source>
        <translation type="obsolete">Posição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relative size of the superscript compared to the normal font</source>
        <translation type="obsolete">Tamanho relativo do sobrescrito, comparado à fonte normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Persistent</source>
        <translation type="obsolete">Persistente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>of the following fields:</source>
        <translation type="obsolete">dos seguintes campos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Regular Polygons</source>
        <translation type="obsolete">Polígonos regulares</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error Loading Preferences</source>
        <translation type="obsolete">Erro de leitura das preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relative Colorimetric</source>
        <translation type="obsolete">Relativa Colorimétrica</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not show the splashscreen on startup</source>
        <translation type="obsolete">Não exibe a ecrã de entrada no início</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">A qualidade das suas imagens - 100% é a melhor, 1% a pior</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>System wide configuration</source>
        <translation type="obsolete">Configuração do sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color selector with color theory included.</source>
        <translation type="obsolete">Seletor de cor que inclui a teoria das cores.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Hyphenate Text</source>
        <translation type="obsolete">&amp;Hifenizar o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font width</source>
        <translation type="obsolete">Definir largura da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hide Enhanced</source>
        <translation type="obsolete">Esconder melhorado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dehyphenate Text</source>
        <translation type="obsolete">Remove a hifenação do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Count of the Paragraphs:</source>
        <translation type="obsolete">Contagem de parágrafos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation type="obsolete">JavaScripts (*.js);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror the Path Vertically</source>
        <translation type="obsolete">Espelha o caminho verticalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot write file %1</source>
        <translation type="obsolete">Não é possível escrever o ficheiro %1.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merging colors</source>
        <translation type="obsolete">Mesclando cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Run As &amp;Console</source>
        <translation type="obsolete">Executar como &amp;console</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotate Item</source>
        <translation type="obsolete">Rodar item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Actual PPI: </source>
        <translation type="obsolete">PPI atual: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relative size of the small caps font compared to the normal font</source>
        <translation type="obsolete">Tamanho relativo da caixa baixa, comparado à fonte normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image Compression Method</source>
        <translation type="obsolete">Método de compressão de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow Docking To...</source>
        <translation type="obsolete">Acoplagem...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Document</source>
        <translation type="obsolete">Documento do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>O&amp;utput to File:</source>
        <translation type="obsolete">&amp;Ficheiro de saída:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reload system wide configuration and remove user defined one</source>
        <translation type="obsolete">Recarrega todas a configurações do sistema e remove as configurações definidas pelo o utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No text flow</source>
        <translation type="obsolete">Sem fuidez de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <translation type="obsolete">A altura da linha está fora do limite, deve ser &gt;=0,1.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Table of Contents and Indexes</source>
        <translation type="obsolete">Tabela de conteúdos e índices</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation type="obsolete">O Scribus detectou a existência de ficheiros de preferências do Scribus 1.2.
Você deseja migra-las para a nova versão do Scribus?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation type="obsolete">&amp;Gerar tabela de conteúdos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Free radial Gradient</source>
        <translation type="obsolete">Gradiente radial livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select &amp;All</source>
        <translation type="obsolete">Selecionar &amp;tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exclusion</source>
        <translation type="obsolete">Exclusão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Font</source>
        <translation type="obsolete">Selecionar fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation type="obsolete">Procurar actualizações do Scribus. Nenhum dado será transferido da sua máquina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete page</source>
        <translation type="obsolete">Apagar página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Item</source>
        <translation type="obsolete">Seleccionar item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hide Viewers Toolbar</source>
        <translation type="obsolete">Ocultar visualização da barra de ferramentas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set text stroke on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir a borda do texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Special plug-in for adding non-breaking spaces before or after so called short words. Available in the following languages: </source>
        <translation type="obsolete">Plugin especial para adicionar espaços sem quebra antes ou depois das abreviações. Disponíveis nos seguintes idiomas: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Imported Image</source>
        <translation type="obsolete">Tal como a imagem importada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation type="obsolete">Visualização do resultado da amostra em 72dpi.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>null root node</source>
        <translation type="obsolete">nó de raiz vazio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Método de mostrar, no no ecrã, as cores que podem não ser impressas corretamente.
Isso requer perfis muito precisos e serve apenas como um alerta.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Effects in use</source>
        <translation type="obsolete">Efeitos em uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot replace a color with an empty name.</source>
        <translation type="obsolete">Não é possível substituir uma cor sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Skip locked objects</source>
        <translation type="obsolete">&amp;Salta os objectos bloqueados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the selected effect to all pages.</source>
        <translation type="obsolete">Aplicar o efeito selecionado a todas as páginas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Millimeters (mm)</source>
        <translation type="obsolete">Milímetros (mm)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Destination</source>
        <translation type="obsolete">Imprimir em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import Data from:</source>
        <translation type="obsolete">Importar dados de:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Picture frames allow pictures to scale to any size</source>
        <translation type="obsolete">As imagens no quadro podem ser dimensionadas para qualquer tamanho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Encoding:</source>
        <translation type="obsolete">Codificação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot Cut In-Use Item</source>
        <translation type="obsolete">Não é possível cortar um item em uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Activa a sobreimpressão de modo global nesse documento, sobrescrevendo as configurações dos objetos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solidus</source>
        <translation type="obsolete">Barra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comm10E</source>
        <translation type="obsolete">Comm10E</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>List View</source>
        <translation type="obsolete">Visualizar lista</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Console</source>
        <translation type="obsolete">Console</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add page</source>
        <translation type="obsolete">Adicionar página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy of</source>
        <translation type="obsolete">Copiar de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy...</source>
        <translation type="obsolete">&amp;Copiar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spanish</source>
        <translation type="obsolete">Espanhol</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>and less or equal to:</source>
        <translation type="obsolete">e menor ou igual a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Largura das páginas do documento. Editável se você escolheu um tamanho de página personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Special</source>
        <translation type="obsolete">Especial</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Source:</source>
        <translation type="obsolete">&amp;Fonte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation type="obsolete">Torna essa configuração padrão e não solicita futuras confirmações quando importar um OpenDocument do OÁSIS.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>St&amp;yle:</source>
        <translation type="obsolete">Est&amp;ilo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quotation Dash</source>
        <translation type="obsolete">Travessão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert index out of bounds.</source>
        <translation type="obsolete">Índice de inserção fora do limite.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation type="obsolete">O Scribus travou devido ao Sinal #%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation type="obsolete">O nome &quot;%1&quot; já existe.
Por favor, escolha outro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change Image Offset</source>
        <translation type="obsolete">Alterar deslocamento da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tabloid</source>
        <translation type="obsolete">Tablóide</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add...</source>
        <translation type="obsolete">&amp;Adicionar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">Exc&amp;luir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Margins</source>
        <translation type="obsolete">Mostrar &amp;margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the minor grid lines</source>
        <translation type="obsolete">Cor das linhas da grelha menor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the major grid lines</source>
        <translation type="obsolete">Cor das linhas da grelha maior</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Get Text...</source>
        <translation type="obsolete">Obter texto...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;Other Files (*.eps *.epsi *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Documentos (*.sla *.sla.gz *.scd *.scd.gz);;Outros Ficheiros (*.eps *.epsi *.ps *.ai);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Angle:</source>
        <translation type="obsolete">&amp;Ângulo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="obsolete">Selecciona o nível de PostScript.
Os níveis 1 ou 2 podem criar ficheiros enormes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Acrescentar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Write-only</source>
        <translation type="obsolete">Somente escrita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert PDF Check Box</source>
        <translation type="obsolete">Inserir uma caixa de verificação PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Other Properties</source>
        <translation type="obsolete">Outras propriedades</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus </source>
        <translation type="obsolete">Scribus </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scripts:</source>
        <translation type="obsolete">&amp;Scripts:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scripter</source>
        <translation type="obsolete">Scripter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Layer not found.</source>
        <translation type="obsolete">Camada não encontrada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Resolução de imagem acima de %1 DPI. Atualmente %2 X %3 DPI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bugs and Feature Requests</source>
        <translation type="obsolete">Erros e pedidos de funcionalidades</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>the symlink</source>
        <translation type="obsolete">o link simbólico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Center</source>
        <translation type="obsolete">&amp;Centro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation type="obsolete">A fonte %1 possui problemas (stream de leitura), não será embarcada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The paragraph style used for the entry lines</source>
        <translation type="obsolete">O estilo de parágrafo usado pelas linhas de entrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Last Selected</source>
        <translation type="obsolete">Última seleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Colors</source>
        <translation type="obsolete">&amp;Cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Distance:</source>
        <translation type="obsolete">&amp;Distância:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distances</source>
        <translation type="obsolete">Medidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.3.0-&gt;1.3.3.7 Document</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Detected some errors.
Consider using the Preflight Verifier to correct them</source>
        <translation type="obsolete">Alguns erros foram encontrados.
Considere usar o verificador pré-vôo para corrigi-los</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit contour line</source>
        <translation type="obsolete">Editar linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Apagar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Posterize</source>
        <translation type="obsolete">Posterizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Passwords</source>
        <translation type="obsolete">Senhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Bleed</source>
        <translation type="obsolete">Página esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Property not found</source>
        <translation type="obsolete">Propriedade não encontrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create a new style</source>
        <translation type="obsolete">Criar novo estilo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation type="obsolete">O marcador (flag) é ignorado no PDF 1.3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Printing...</source>
        <translation type="obsolete">Imprimindo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation type="obsolete">Indica o nível onde está o objeto; 0 significa que o objeto está no fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Estonian</source>
        <translation type="obsolete">Estónio</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between items equal</source>
        <translation type="obsolete">Uniformizar os espaços verticais entre os objectos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unlock guides</source>
        <translation type="obsolete">Liberar guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pictures:</source>
        <translation type="obsolete">Imagens:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Target frame must be empty.</source>
        <translation type="obsolete">O quadro alvo deve estar vazio.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apostrophe</source>
        <translation type="obsolete">Apóstrofo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keystroke:</source>
        <translation type="obsolete">Teclas pressionadas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Modified Font found, checking...</source>
        <translation type="obsolete">Fonte modificada encontrada, analisando...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>User Comment:</source>
        <translation type="obsolete">Comentário do utilizador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Point list must contain at least four points (eight values).</source>
        <translation type="obsolete">A lista de pontos deve conter ao menos quatro pontos (oito valores).</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Annotation:</source>
        <translation type="obsolete">Anotação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Generates thumbnails of each page in the PDF. Some viewers can use the thumbnails for navigation.</source>
        <translation type="obsolete">Gera miniaturas de cada página no PDF. Alguns visualizadores podem utilizar a galeria de miniaturas para a navegação.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text on a Path</source>
        <translation type="obsolete">Texto em um caminho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documen&amp;t</source>
        <translation type="obsolete">Documen&amp;to</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document:</source>
        <translation type="obsolete">O documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 is broken, discarding it</source>
        <translation type="obsolete">A fonte %1 foi descartada por apresentar problemas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gutenberg</source>
        <translation type="obsolete">Gutenberg</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Multi-Line</source>
        <translation type="obsolete">Multi-linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import colors to the current set from an existing document</source>
        <translation type="obsolete">Importar cores para o actual conjunto de um documento existente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Underline</source>
        <translation type="obsolete">Sublinhado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Indentation for first line of the paragraph</source>
        <translation type="obsolete">Deslocamento da primeira linha do parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Please visit www.scribus.net for details.</source>
        <translation type="obsolete">Por favor, visite www.scribus.net para mais detalhes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Interval:</source>
        <translation type="obsolete">&amp;Intervalo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Underline</source>
        <translation type="obsolete">S&amp;ublinhado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choosing this will enable printing this on all plates. Registration colors are used for printer marks such as crop marks, registration marks and the like. These are not typically used in the layout itself.</source>
        <translation type="obsolete">Escolher isto activará a impressão em todas as chapas. As cores de registo são usadas para miras de impressão, tais como miras de corte, miras de registo e similares. Normalmente não são usadas no próprio layout</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Posterize:</source>
        <translation type="obsolete">Posterizar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Export</source>
        <translation type="obsolete">&amp;Exportar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenOffice.org Draw Importer</source>
        <translation type="obsolete">Importador de desenhos do OpenOffice.org</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;About Plug-ins</source>
        <translation type="obsolete">&amp;Sobre os Plug-ins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Forced</source>
        <translation type="obsolete">&amp;Forçado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Frame Properties</source>
        <translation type="obsolete">Propriedades do quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default documents directory</source>
        <translation type="obsolete">Diretório padrão dos documentos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display non-printing characters such as paragraph markers in text frames</source>
        <translation type="obsolete">Exibe caracteres não imprimíveis como marcadores de parágrafo nas molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Ignore Case</source>
        <translation type="obsolete">&amp;Não diferenciar maiús./minús.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Swedish</source>
        <translation type="obsolete">Suíço</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Flip Vertically</source>
        <translation type="obsolete">&amp;Espelhar verticalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Flip vertically</source>
        <translation type="obsolete">Espelhamento vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No bounding box</source>
        <translation type="obsolete">Sem delimitador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>exists already. Overwrite?</source>
        <translation type="obsolete">já existe. Sobrescrever?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get a color with an empty name.</source>
        <translation type="obsolete">Não é possível obter uma cor sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No contour line</source>
        <translation type="obsolete">Sem linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the style of line join</source>
        <translation type="obsolete">Definir estilo de junção de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Automatic Text Frames</source>
        <translation type="obsolete">Quadros de texto &amp;automáticos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>List Non-Printing Entries</source>
        <translation type="obsolete">Listar entradas não imprimíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>At the end</source>
        <translation type="obsolete">No final</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tritanopia (Blue)</source>
        <translation type="obsolete">Tritanopia (Azul)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Green:</source>
        <translation type="obsolete">V&amp;erde:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables automatic hyphenation of your text while typing.</source>
        <translation type="obsolete">Activa hifenização automática do texto durante a digitação.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Give a name to this filter for saving</source>
        <translation type="obsolete">Dê um nome a esse filtro para salvar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts Preview</source>
        <translation type="obsolete">Visualizar fontes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Files (*)</source>
        <translation type="obsolete">Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default orientation of document pages</source>
        <translation type="obsolete">Orientação padrão das páginas do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Other...</source>
        <translation type="obsolete">Outro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Other...</source>
        <translation type="obsolete">&amp;Outro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Can&apos;t group less than two items</source>
        <translation type="obsolete">Não é possível agrupar menos de dois ítens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the guide lines you insert</source>
        <translation type="obsolete">Cor das linhas-guia inseridas pelo utilizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scale Picture to Frame Size</source>
        <translation type="obsolete">&amp;Ajustar a figura ao tamanho do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Diamond</source>
        <translation type="obsolete">Losango</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Directories</source>
        <translation type="obsolete">Diretórios</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set font size on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir o tamanho da fonte em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Ignore</source>
        <translation type="obsolete">&amp;Ignorar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keyboard Shortcuts</source>
        <translation type="obsolete">Atalhos de teclado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Continuous</source>
        <translation type="obsolete">Contínuo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loading...</source>
        <translation type="obsolete">Carregando...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object has transparency</source>
        <translation type="obsolete">O objeto possui transparência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Points (pt)</source>
        <translation type="obsolete">Pontos (pt)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Insert</source>
        <translation type="obsolete">&amp;Inserir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="obsolete">Um valor negativo irá tornar o polígono côncavo (ou estrelado),um valor positivo irá torná-lo convexo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Discard</source>
        <translation type="obsolete">&amp;Descartar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Super- and Subscripts</source>
        <translation type="obsolete">Sobre e subscrito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display</source>
        <translation type="obsolete">Exibir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Editable</source>
        <translation type="obsolete">Editável</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Determines the gap between the DropCaps and the Text</source>
        <translation type="obsolete">Determina a lacuna entre a Capitulação e o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>More Info...</source>
        <translation type="obsolete">Mais informações...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Symlink to Special</source>
        <translation type="obsolete">Link simbólico para especial</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Right</source>
        <translation type="obsolete">Normal direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line color</source>
        <translation type="obsolete">Definir cor da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="obsolete">Imprimir a pá&amp;gina atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drop cap lines</source>
        <translation type="obsolete">Capitulação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation type="obsolete">Deforma o caminho horizontalmente para a esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot group less than two items</source>
        <translation type="obsolete">Não é possível agrupar menos de dois ítens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line width</source>
        <translation type="obsolete">Definir espessura de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Searching is case unsensitive</source>
        <translation type="obsolete">A procura não diferencia maiúsculas de minúsculas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line style</source>
        <translation type="obsolete">Definir estilo de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;New Script:</source>
        <translation type="obsolete">&amp;Novo Script:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation type="obsolete">Aplica as configurações de margem em todas as páginas existentes do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Examine Script</source>
        <translation type="obsolete">Analisar Script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>External Link</source>
        <translation type="obsolete">Ligação externa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page Margins</source>
        <translation type="obsolete">Tal como as margens da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add To Range</source>
        <translation type="obsolete">Adicionar página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle Dot</source>
        <translation type="obsolete">Ponto central</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Files (*.txt);;All Files(*)</source>
        <translation type="obsolete">Ficheiros de texto (*.txt);;Todos os ficheiros(*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export the current shortcuts into an importable file</source>
        <translation type="obsolete">Exporta as teclas de atalho actuais para um ficheiro importável</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Undo/Redo</source>
        <translation type="obsolete">Desfazer/Refazer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Generate and include a checksum in barcode</source>
        <translation type="obsolete">Gera e inclui um código de checagem da soma (checksum) no código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Layers</source>
        <translation type="obsolete">&amp;Camadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zero Width NB Space</source>
        <translation type="obsolete">Espaço sem quebra com espessura zero</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Zero Width Space</source>
        <translation type="obsolete">Espaço com espessura &amp;zero</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Ignore Errors</source>
        <translation type="obsolete">&amp;Ignorar erros</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Vertical Gap:</source>
        <translation type="obsolete">Vertical:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical Gap:</source>
        <translation type="obsolete">Vertical:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ghostscript is missing : Postscript Print Preview is not available</source>
        <translation type="obsolete">O Ghostscript não está instalado: A visualização de impressão de Postscript não está disponível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Page Previews</source>
        <translation type="obsolete">Mostrar visualização da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dashed Line</source>
        <translation type="obsolete">Linha tracejada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dotted Line</source>
        <translation type="obsolete">Linha pontilhada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lines:</source>
        <translation type="obsolete">&amp;Linhas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is &amp;Locked</source>
        <translation type="obsolete">&amp;Bloqueado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mathematical Operators</source>
        <translation type="obsolete">Operadores matemáticos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Si&amp;ze is Locked</source>
        <translation type="obsolete">Tamanho &amp;Bloqueado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Linked Text</source>
        <translation type="obsolete">Texto associado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load documents with predefined layout</source>
        <translation type="obsolete">Carrega documentos com um layout pré-definido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal scaling</source>
        <translation type="obsolete">Escala horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Duplicates the current layer</source>
        <translation type="obsolete">Duplica a camada actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Exit Without Updating Text Frame</source>
        <translation type="obsolete">&amp;Sair sem atualizar o quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Compression quality levels for lossy compression methods: Minimum (25%), Low (50%), Medium (75%), High (85%), Maximum (95%). Note that a quality level does not directly determine the size of the resulting image - both size and quality loss vary from image to image at any given quality level. Even with Maximum selected, there is always some quality loss with jpeg.</source>
        <translation type="obsolete">Níveis de qualidade de compressão para métodos de compressão com perdas: Mínima (25%), Baixa (50%), Média (75%), Alta (85%), Máxima (95%). Note que o nível de qualidade não determina directamente o tamanho da imagem resultante - ambos tamanho e qualidade da compressão variam de imagem para imagem para um dado nível de qualidade. Até com o Máximo seleccionado há sempre alguma perda de qualidadecom jpeg.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a Directory</source>
        <translation type="obsolete">Selecione um directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a Directory</source>
        <translation type="obsolete">Seleccione um directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy Item Properties</source>
        <translation type="obsolete">Copiar propriedades do item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.2.x Document</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This list may contain development versions.</source>
        <translation type="obsolete">Esta lista pode conter versões de desenvolvimento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relative to:</source>
        <translation type="obsolete">&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relative To:</source>
        <translation type="obsolete">&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Wednesday</source>
        <translation type="obsolete">Quarta-Feira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No Key</source>
        <translation type="obsolete">&amp;Nenhuma tecla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of recently edited documents to show in the File menu</source>
        <translation type="obsolete">Número de documentos recentes a serem mostrados no menu Ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Normal</source>
        <translation type="obsolete">&amp;Normal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The selected color does not exist in the document&apos;s color set. Please enter a name for this new color.</source>
        <translation type="obsolete">A cor selecionada não existe na conjunto de cores do documento. Por favor, forneça um nome para essa nova cor.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fit to Page</source>
        <translation type="obsolete">Ajustar à página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="obsolete">Apagar guias de %todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Automatic</source>
        <translation type="obsolete">Automático</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Online</source>
        <translation type="obsolete">&amp;Online</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge created colors into the document colors</source>
        <translation type="obsolete">Mescla as cores criadas nas cores do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Files (*.*)</source>
        <translation type="obsolete">Todos os ficheiros (*.*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Item Action Mode</source>
        <translation type="obsolete">Modo Acção de &amp;item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unable to read settings XML: %1</source>
        <translation type="obsolete">Não foi possível ler as configurações do XML: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Totals:</source>
        <translation type="obsolete">Totais:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make the image fit within the size of the frame</source>
        <translation type="obsolete">Acomodar a imagem ao tamanho do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Baseline &amp;Grid:</source>
        <translation type="obsolete">&amp;Pauta:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ed&amp;ges:</source>
        <translation type="obsolete">Bor&amp;das:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Owner:</source>
        <translation type="obsolete">Pr&amp;oprietário:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Palm PDB Documents</source>
        <translation type="obsolete">Documentos Palm PDB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy of %1</source>
        <translation type="obsolete">Cópia de %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus 1.3.4 Document</source>
        <translation type="obsolete">Documento do Scribus 1.2.x</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>My &amp;Plugin</source>
        <translation type="obsolete">Meu &amp;Plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>P&amp;roportional</source>
        <translation type="obsolete">P&amp;roporcional</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Read: %1</source>
        <translation type="obsolete">Ler: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship To</source>
        <translation type="obsolete">Relacionado a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quadtone</source>
        <translation type="obsolete">Citação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation type="obsolete">3° Quadritônico (ângulo oposto)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quality:</source>
        <translation type="obsolete">&amp;Qualidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF/X-3 Output Intent</source>
        <translation type="obsolete">Intenção de saída PDF/X-3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Page Properties...</source>
        <translation type="obsolete">Gerir propriedades de página...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation type="obsolete">A natureza ou estilo do conteúdo do documento, por ex. categorias, funções, gêneros, etc</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute</source>
        <translation type="obsolete">Distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Remove</source>
        <translation type="obsolete">&amp;Remover</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Rename</source>
        <translation type="obsolete">&amp;Renomear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Rescan</source>
        <translation type="obsolete">Scanea&amp;r novamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+stretch </source>
        <translation type="obsolete">+alargar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Appearance</source>
        <translation type="obsolete">Aparência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Triadic</source>
        <translation type="obsolete">Tritônico</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Right:</source>
        <translation type="obsolete">&amp;Direita:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Strings:</source>
        <translation type="obsolete">Valores:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tritone</source>
        <translation type="obsolete">Título:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Adjust Display Size</source>
        <translation type="obsolete">Ajustar ao tamanho do no ecrã</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display Settings</source>
        <translation type="obsolete">Exibir configurações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Within range</source>
        <translation type="obsolete">&amp;No intervalo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>February</source>
        <translation type="obsolete">Fevereiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Script</source>
        <translation type="obsolete">&amp;Script</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Master Page %1</source>
        <translation type="obsolete">Nova página modelo %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Procurar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select</source>
        <translation type="obsolete">&amp;Seleccionar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>December</source>
        <translation type="obsolete">Dezembro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check Box</source>
        <translation type="obsolete">Caixa de verificação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shade:</source>
        <translation type="obsolete">&amp;Intensidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for overflow in text frames</source>
        <translation type="obsolete">Procurar excesso de texto nas molduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Postscript</source>
        <translation type="obsolete">Postscript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Single</source>
        <translation type="obsolete">&amp;Único</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Length of time the effect runs. A shorter time will speed up the effect, a longer one will slow it down.</source>
        <translation type="obsolete">Período de tempo de duração do efeito. Um tempo menor irá acelerar o efeito, já um tempo maior irá deixá-lo mais lento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Save Color Set</source>
        <translation type="obsolete">&amp;Salvar o conjunto de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select All</source>
        <translation type="obsolete">Selecionar tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hyphenate Text Automatically &amp;During Typing</source>
        <translation type="obsolete">Hifenizar automaticamente, durante a &amp;digitação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value is not calculated</source>
        <translation type="obsolete">O valor não está calculado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation type="obsolete">Falha ao ler as preferências no XML de &quot;%1&quot;: %2 na linha %3, coluna %4</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sections</source>
        <translation type="obsolete">Seções</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lock or unlock the size of the object</source>
        <translation type="obsolete">Trava ou destrava o tamanho do objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;ecurity</source>
        <translation type="obsolete">S&amp;egurança</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Executive</source>
        <translation type="obsolete">Executivo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Theme:</source>
        <translation type="obsolete">&amp;Tema:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Possible Hyphenation</source>
        <translation type="obsolete">Hifenização possível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation type="obsolete">Valor de redimensionamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Directory:</source>
        <translation type="obsolete">Diretório:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>System Menu</source>
        <translation type="obsolete">Menu do sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Edit &gt;&gt;</source>
        <translation type="obsolete">&amp;Editar &gt;&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit...</source>
        <translation type="obsolete">Editar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Edit...</source>
        <translation type="obsolete">&amp;Editar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Title:</source>
        <translation type="obsolete">&amp;Título:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;X-Pos:</source>
        <translation type="obsolete">Posição &amp;X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Redo: %1</source>
        <translation type="obsolete">Desfaze&amp;r: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1(%2) is broken</source>
        <translation type="obsolete">A fonte %1 (%2) possui problemas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initial number of pages of the document</source>
        <translation type="obsolete">Número inicial de páginas do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Seleciona o ponto-base acima e à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample color scheme.</source>
        <translation type="obsolete">Esquema de amostra de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation type="obsolete">Usar as proporções da imagem e não as do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Portuguese</source>
        <translation type="obsolete">Português</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tuesday</source>
        <translation type="obsolete">Terça-Feira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Box Drawing</source>
        <translation type="obsolete">Caixa de desenho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set paragraph style</source>
        <translation type="obsolete">Definir estilo de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Y-Pos:</source>
        <translation type="obsolete">Posição &amp;Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X: %1%2</source>
        <translation type="obsolete">X: %1%2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Duotone</source>
        <translation type="obsolete">Citação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Resolution Preview</source>
        <translation type="obsolete">Visualizar em média resolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Defaults</source>
        <translation type="obsolete">Pa&amp;drões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turkish</source>
        <translation type="obsolete">Turco</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Refer To</source>
        <translation type="obsolete">Referenciar à</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Effects</source>
        <translation type="obsolete">&amp;Efeitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Effects</source>
        <translation type="obsolete">Efeitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Insert Glyph...</source>
        <translation type="obsolete">&amp;Inserir caracter...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ri&amp;ghts:</source>
        <translation type="obsolete">Dir&amp;eitos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Toggle Palettes</source>
        <translation type="obsolete">Mostrar/Ocultar paletas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir a altura das linhas em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove Profile</source>
        <translation type="obsolete">Remover perfil</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>% to Enlarge or Shrink By</source>
        <translation type="obsolete">% para alargar ou encolher por</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">&amp;Gerir imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stri&amp;keout</source>
        <translation type="obsolete">Tach&amp;ado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Rows:</source>
        <translation type="obsolete">Número de linhas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>I&amp;nsert</source>
        <translation type="obsolete">&amp;Inserir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Indentation from the left for the whole paragraph</source>
        <translation type="obsolete">Deslocamento esquerdo do parágrafo inteiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Gerir imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation type="obsolete">Cria molduras de texto automaticamente ao adicionar novas páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Distância para sangria da base da página física</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Resets the curve</source>
        <translation type="obsolete">Reconfigurar o texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save Preferences</source>
        <translation type="obsolete">Salvar preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move one level up</source>
        <translation type="obsolete">Move um nível acima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Width:</source>
        <translation type="obsolete">&amp;Largura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin ID</source>
        <translation type="obsolete">ID do Plugin</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color for the baseline grid</source>
        <translation type="obsolete">Cor de grelha da pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Seleccionar isto colocará a caixa só na corrente página.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Junção chanfrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation of color</source>
        <translation type="obsolete">Saturação da cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship</source>
        <translation type="obsolete">Relacionamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line style of current object</source>
        <translation type="obsolete">Estilo de linha do objeto atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;irection:</source>
        <translation type="obsolete">D&amp;ireção:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="obsolete">É uma a&amp;notação de PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make sure images and fonts you use can be used freely. If fonts cannot be shared do not collect them when saving as a template.</source>
        <translation type="obsolete">Certifique-se de que as imagens e fontes que você usar sejam de livre distribuição. Se as fontes não puderem ser compartilhadas, não as acrescente ao salvar o modelo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Em Dash</source>
        <translation type="obsolete">Linha Em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <translation type="obsolete">encontrados %1 &lt;%2&gt; nós, 1 necessário.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of rows:</source>
        <translation type="obsolete">Número de linhas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Tamanho personalizado:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image Effects</source>
        <translation type="obsolete">Efeitos de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Image Effects</source>
        <translation type="obsolete">Efeitos de &amp;imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move one level down</source>
        <translation type="obsolete">Move um nível abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inches (in)</source>
        <translation type="obsolete">Polegadas (pol)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>En Dash</source>
        <translation type="obsolete">Linha En</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Aplicar fator côncavo/convexo para mudar a forma dos polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Orie&amp;ntation:</source>
        <translation type="obsolete">Orie&amp;ntação:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all Tabulators</source>
        <translation type="obsolete">Apagar todas as tabulações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute right sides equidistantly</source>
        <translation type="obsolete">Distribuir os lados direitos uniformemente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;RGB Pictures:</source>
        <translation type="obsolete">Imagens &amp;RGB:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Uma forma de trocar alguns dos tons de cinza que são compostos de ciano, amarelo e magenta, usando preto no lugar. A RSC afeta mais as partes da imagem que são neutras ou em tons escuros, mais próximos do cinza. O uso disso pode melhorar a impressão de algumas imagens,mas recomenda-se que se façam testes para definir um melhorresultado para cada caso. A RSC reduz a possibilidade de supersaturação com tintas CMY.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Append &amp;Text...</source>
        <translation type="obsolete">Acrescentar &amp;texto...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>do not remove match</source>
        <translation type="obsolete">não remover correspondência</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected.What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. Registration colors will have a registration mark next to the color. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Se a gestão de cor está activada, um indicador triangular de aviso significa que a cor pode estar fora do espaço de cor do perfil de cor da impressora corrente. Isto significa que a cor poderá não ser impressa exactamente como é mostrado no no ecrã. As cores lisas são indicadas por um circulo vermelho. As cores de registo terão uma mira de registo junto delas. Mais pistas acerca de avisos de gamut podem ser encontradas na ajuda em linha sob Gestão de Cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Python interface module

This module is the Python interface for Scribus. It provides functions
to control scribus and to manipulate objects on the canvas. Each
function is documented individually below.

A few things are common across most of the interface.

Most functions operate on frames. Frames are identified by their name,
a string - they are not real Python objects. Many functions take an
optional (non-keyword) parameter, a frame name.
Many exceptions are also common across most functions. These are
not currently documented in the docstring for each function.
- Many functions will raise a NoDocOpenError if you try to use them
without a document to operate on.
- If you do not pass a frame name to a function that requires one,
the function will use the currently selected frame, if any, or
raise a NoValidObjectError if it can&apos;t find anything to operate
on.
- Many functions will raise WrongFrameTypeError if you try to use them
on a frame type that they do not make sense with. For example, setting
the text color on a graphics frame doesn&apos;t make sense, and will result
in this exception being raised.
- Errors resulting from calls to the underlying Python API will be
passed through unaltered. As such, the list of exceptions thrown by
any function as provided here and in its docstring is incomplete.

Details of what exceptions each function may throw are provided on the
function&apos;s documentation, though as with most Python code this list
is not exhaustive due to exceptions from called functions.
</source>
        <translation type="obsolete">Módulo de interface Python do Scribus

Esse é o módulo de interface Python para o Scribus. Ele fornece funções
de controle do Scribus e de manipulação de objetos no no ecrã. Cada função
é documentada individualmente logo abaixo.

Algumas coisas são comuns à maior parte da interface.

Várias funções operam em molduras. As molduras são identificadas por
seus nomes, uma seqüência - eles não são objetos Python reais. Muitas
funções levam um parâmetro opcional (não palavra-chave), o nome
de um quadro.
Várias exceções são também comuns à maioria das funções. Elas não
estão atualmente documentadas no docstring de cada função.
- Várias funções abrirão uma janela de NoDocOpenError se você tentar
usá-las sem um documento onde possam operar.
- Se você não fornecer o nome de um quadro a uma função que necessite
disso, a função usará o quadro atualmente selecionado, ou abrirá uma
janela de NoValidObjectError caso ela não encontre nenhum para operar.
- Várias funções abrirão a janela WrongFrameTypeError se você tentar
usá-las em um tipo quadro que não faça sentido com elas. Por exemplo,
definir a cor do texto em um quadro de imagem não faz sentido e resultará
na abertura da janela de erro.- Erros resultantes de chamadas para API Python subjacente serão
enviados de maneira inalterada. Dessa forma a lista de exceções enviada
por qualquer função, como indicado aqui, e em seus docstrings está
incompleta.
Detalhes de quais exceções cada função pode apresentar são
fornecidos na documentação da função.
</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation type="obsolete">Distribuir os centros uniformemente na horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Number Out Of Bounds</source>
        <translation type="obsolete">Número da página fora do intervalo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Documents:</source>
        <translation type="obsolete">&amp;Documentos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font &amp;Substitutions</source>
        <translation type="obsolete">Fontes &amp;substitutas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Change in magnification for each zoom operation</source>
        <translation type="obsolete">Intervalos de ampliação/redução para cada operação do zoom</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text flows around the frame</source>
        <translation type="obsolete">O texto flui ao redor do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display Bookmarks Tab</source>
        <translation type="obsolete">Exibir aba de marcadores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancel Search</source>
        <translation type="obsolete">Cancelar procura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>DPI (Dots Per Inch) for image export.</source>
        <translation type="obsolete">DPI (pontos por polegada) para exportação da imagem.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>P&amp;references...</source>
        <translation type="obsolete">P&amp;referências...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot open file %1</source>
        <translation type="obsolete">Não é possível abrir o ficheiro %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Extended Image Properties</source>
        <translation type="obsolete">Propriedades estendidas de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation type="obsolete">Importa desenhos do OpenOffice.org</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icelandic</source>
        <translation type="obsolete">Islandês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&apos;allTypes&apos; attribute is READ-ONLY</source>
        <translation type="obsolete">O atributo &apos;allTypes&apos; (todos os tipos) é somente leitura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Column/Row</source>
        <translation type="obsolete">&amp;Coluna/Fila</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Element</source>
        <translation type="obsolete">Elemento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gap between text frame columns</source>
        <translation type="obsolete">Espaço entre as colunas no quadro de texto </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tabulators</source>
        <translation type="obsolete">Tabuladores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation type="obsolete">Oferece uma visão mais agradável das fontes Type 1 True Type e Open Type, EPS, PDF e imagens vetoriais na pré-visualização, ao custo de uma ligeira lentidão na visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Basic colors</source>
        <translation type="obsolete">&amp;Cores básicas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation type="obsolete">Alinhar os topos dos objectos ao fundo da âncora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation type="obsolete">A representação númerica do código por sí só. Veja a mensagem de ajuda abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Visual Appearance</source>
        <translation type="obsolete">Aparência visual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ellipse</source>
        <translation type="obsolete">Elipse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">Mudança &amp;vertical:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a new filter row</source>
        <translation type="obsolete">Adicionar uma nova linha ao filtro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Special Actions</source>
        <translation type="obsolete">Ações especiais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Problems found</source>
        <translation type="obsolete">Problemas encontrados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable Item Printing</source>
        <translation type="obsolete">Activar impressão do item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scrapbook (*.scs)</source>
        <translation type="obsolete">Bloco de Rascunhos (*.scs)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Numbers:</source>
        <translation type="obsolete">Números:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Multiply</source>
        <translation type="obsolete">Multiplicar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Su&amp;perscript</source>
        <translation type="obsolete">So&amp;brescrito</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>unknown error</source>
        <translation type="obsolete">erro desconhecido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Incl&amp;ude checksum digit</source>
        <translation type="obsolete">Incl&amp;uir dígito de checksum</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>After Page</source>
        <translation type="obsolete">Depois da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Miter Join</source>
        <translation type="obsolete">Junção angulada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>after Page</source>
        <translation type="obsolete">depois da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show G&amp;uides</source>
        <translation type="obsolete">Mostrar g&amp;uias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default page size, either a standard size or a custom size</source>
        <translation type="obsolete">Tamanho padrão da página; pode ser um tamanho padrão ou personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create filter</source>
        <translation type="obsolete">Criar filtro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gaps Between Pages</source>
        <translation type="obsolete">Lacuna entre-páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Word Documents</source>
        <translation type="obsolete">Documentos do Word</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Round Cap</source>
        <translation type="obsolete">Ponta arredondada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Layer &quot;%1&quot;</source>
        <translation type="obsolete">Camada &quot;%1&quot;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enabled</source>
        <translation type="obsolete">Activado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fixed Linespacing</source>
        <translation type="obsolete">Espaço entre as linhas fixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unlink Text Frames</source>
        <translation type="obsolete">Desligar molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">&amp;Activar a gestão de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Latin Extended-A</source>
        <translation type="obsolete">Latim Extendido-A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Latin Extended-B</source>
        <translation type="obsolete">Latim Extendido-B</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Golden Mean</source>
        <translation type="obsolete">Moderado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>English</source>
        <translation type="obsolete">Inglês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Ungroup</source>
        <translation type="obsolete">Desagr&amp;upar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ungroup</source>
        <translation type="obsolete">Desagrupar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove this filter row</source>
        <translation type="obsolete">Remover essa linha do filtro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>parent= %1</source>
        <translation type="obsolete">pai= %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line width out of bounds, must be 0 &lt;= line_width &lt;= 12.</source>
        <translation type="obsolete">A espessura da linha está fora do limite, deve ser &gt;=0 e &lt;=12.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unknown</source>
        <translation type="obsolete">Desconhecido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation type="obsolete">Aumenta o tamanho do caminho no valor definido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir o número de colunas em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Compatibilit&amp;y:</source>
        <translation type="obsolete">Compat&amp;ibilidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Unshade</source>
        <translation type="obsolete">&amp;Dessombrear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unshade</source>
        <translation type="obsolete">Dessombrear</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Extensions</source>
        <translation type="obsolete">Extensões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Selecionar estilos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Basepoint:</source>
        <translation type="obsolete">Ponto-&amp;base:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document &amp;Setup...</source>
        <translation type="obsolete">&amp;Configurações do documento...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset Form</source>
        <translation type="obsolete">Limpa o formulário</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set &amp;Key</source>
        <translation type="obsolete">Definir &amp;tecla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No Problems found</source>
        <translation type="obsolete">Nenhum problema encontrado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Geometry</source>
        <translation type="obsolete">Geometria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font</source>
        <translation type="obsolete">Definir fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The search failed: %1</source>
        <translation type="obsolete">A procura falhou: %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color setting helper</source>
        <translation type="obsolete">Auxilio de configuração de cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Updates</source>
        <translation type="obsolete">&amp;Acualizações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lowest allowed resolution</source>
        <translation type="obsolete">Menor resolução permitida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File not found on server</source>
        <translation type="obsolete">O ficheiro não foi encontrado no servidor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Page Properties</source>
        <translation type="obsolete">Gerir Propriedades de Página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Custom colors</source>
        <translation type="obsolete">&amp;Cores personalizadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Result Colors</source>
        <translation type="obsolete">Apagar cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance of text from left of frame</source>
        <translation type="obsolete">Distância entre o texto e a borda esquerda do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basepoint:</source>
        <translation type="obsolete">Ponto-base:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line width of shapes</source>
        <translation type="obsolete">Espessura da linha das formas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Inserir uma linha à mão-livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Stepping:</source>
        <translation type="obsolete">&amp;Intervalo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Here</source>
        <translation type="obsolete">Mover aqui</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Only actual page processed.</source>
        <translation type="obsolete">Somente a página atual é processada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>An error occurred while opening ICC profiles, color management is not enabled.</source>
        <translation type="obsolete">Um erro ocorreu ao abrir os perfis ICC, a gestão de cor não será activada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply the page size changes to all existing master pages in the document</source>
        <translation type="obsolete">Aplica a alteração de tamanho de página a todas as páginas modelo do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Fator:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation type="obsolete">A manifestação física ou digital do documento. Tipo de mídia e dimensões devem aparecer aqui.RFC2045, RFC2046 para tipos MIME também são úteis aqui</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the display of frames on or off</source>
        <translation type="obsolete">Activa ou desactiva a visualização de molduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The plugin worked!</source>
        <translation type="obsolete">O plugin funcionou!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus &amp;Manual...</source>
        <translation type="obsolete">&amp;Manual do Scribus...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sc&amp;aling:</source>
        <translation type="obsolete">Esc&amp;ala:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation type="obsolete">Tornar os espaços verticais entre os objectos iguais ao valor especificado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Displacement above the baseline of the normal font expressed as a percentage of the fonts ascender</source>
        <translation type="obsolete">Deslocamento da baixo da pauta de uma fonte normal expressa em percentagem de fontes descendentes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M&amp;argins</source>
        <translation type="obsolete">M&amp;argens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Online Reference</source>
        <translation type="obsolete">Referência online</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Update Image</source>
        <translation type="obsolete">At&amp;ualizar imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Required</source>
        <translation type="obsolete">Requerido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;onvert To</source>
        <translation type="obsolete">Conv&amp;erter em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saturation</source>
        <translation type="obsolete">Saturação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>SVG file contains some unsupported features</source>
        <translation type="obsolete">Este ficheiro SVG possui alguns recursos não suportados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print in Grayscale</source>
        <translation type="obsolete">Imprimir em tons de cinza</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Grab Radius:</source>
        <translation type="obsolete">Raio da aderência:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable or disable printing of the object</source>
        <translation type="obsolete">Activa ou desactiva a impressão do objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Line</source>
        <translation type="obsolete">Nova linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cicero (c)</source>
        <translation type="obsolete">Cícero (c)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Found nothing to import</source>
        <translation type="obsolete">Não foi encontrado nada para importar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overprint</source>
        <translation type="obsolete">Sobreimpressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation type="obsolete">Reconfigura a linha de contorno à forma original do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of text fill</source>
        <translation type="obsolete">Cor de preenchimento do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error: </source>
        <translation type="obsolete">Erro: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Errors:</source>
        <translation type="obsolete">Erros:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Version:</source>
        <translation type="obsolete">Versão:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="obsolete">Você realmente deseja apagar essa página modelo?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample of your font</source>
        <translation type="obsolete">Visualização da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical</source>
        <translation type="obsolete">Vertical</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Aperture:</source>
        <translation type="obsolete">Abertura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Non Breaking &amp;Space</source>
        <translation type="obsolete">E&amp;spaço sem quebra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Underscore</source>
        <translation type="obsolete">Desordenado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import a shortcut set into the current configuration</source>
        <translation type="obsolete">Importa um conjunto de teclas de atalho para configuração atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set font size</source>
        <translation type="obsolete">Definir tamanho da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do Not Spell Check</source>
        <translation type="obsolete">Não verificar ortografia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete All</source>
        <translation type="obsolete">Apagar tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rulers Relative to Page</source>
        <translation type="obsolete">Réguas relativas à página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Imports EPS Files</source>
        <translation type="obsolete">Importa ficheiros EPS</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom: </source>
        <translation type="obsolete">Personalizado: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Réguas relativas à página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embedded Python scripting support.</source>
        <translation type="obsolete">Suporte a scriptis Python embarcados.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scalable Vector Graphics</source>
        <translation type="obsolete">Gráficos Vetoriais Escaláveis (SVG)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenOffice.org Writer Importer Options</source>
        <translation type="obsolete">Opções do importador do OpenOffice.org Writer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Consecutive Pages</source>
        <translation type="obsolete">Páginas seguidas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>First Selected</source>
        <translation type="obsolete">Primeira seleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-outline </source>
        <translation type="obsolete">-delineado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+outline </source>
        <translation type="obsolete">+delineado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Outlines</source>
        <translation type="obsolete">&amp;Contornos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Outlined</source>
        <translation type="obsolete">Contornado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Always use standard Lorem Ipsum</source>
        <translation type="obsolete">Sempre utilizar o texto de amostra padrão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation type="obsolete">Aumenta o tamanho do caminho na percentagem mostrada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Autosave</source>
        <translation type="obsolete">Auto-salvamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Barcode incomplete</source>
        <translation type="obsolete">Código de barras incompleto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>O&amp;utside:</source>
        <translation type="obsolete">&amp;Externa:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Outside:</source>
        <translation type="obsolete">Externa:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Settings</source>
        <translation type="obsolete">&amp;Configurações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Settings</source>
        <translation type="obsolete">Configurações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Lorem Ipsum</source>
        <translation type="obsolete">Selecione o texto de amostra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+underline </source>
        <translation type="obsolete">+sublinhado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Additional directory for document templates</source>
        <translation type="obsolete">Diretório adicional para modelos de documentos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Even-Odd</source>
        <translation type="obsolete">Par-Ímpar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y: %1%2</source>
        <translation type="obsolete">Y: %1%2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Envelopes</source>
        <translation type="obsolete">Envelopes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as Image</source>
        <translation type="obsolete">Salva como imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>-underline </source>
        <translation type="obsolete">-sublinhado </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ISO equiv.:</source>
        <translation type="obsolete">Equiv. ISO:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation type="obsolete">Migrar configurações passadas do Scribus?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do not use color profiles that are embedded in source images</source>
        <translation type="obsolete">Não usa perfis de cores que estejam incorporados nas imagens de origem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation type="obsolete">Escolher isto tornará esta cor uma cor de separação, criando assim outra chapa quando se proceder à separação de cores. Isto é usado quando um objecto gráfico necessita uma representação de cor exacta ou que não consegue ser reproduzida com tintas CMYK. Tintas metálicas e fluorecentes ou cores que estão fora do espaço de cor CMYK são os melhores exemplos de utilização.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Difference</source>
        <translation type="obsolete">Diferença</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit shape of the frame...</source>
        <translation type="obsolete">Edição da forma do quadro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Co&amp;verage:</source>
        <translation type="obsolete">Cobe&amp;rtura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert to</source>
        <translation type="obsolete">Converter em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type of the display effect.</source>
        <translation type="obsolete">Tipo do efeito de exibição.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <translation type="obsolete">nó vazio &lt;%2&gt; inesperado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Non Proportional</source>
        <translation type="obsolete">Desproporcional</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keep the aspect ratio</source>
        <translation type="obsolete">Mantém a proporção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current page</source>
        <translation type="obsolete">Apagar todas as guias da página actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color not found in document.</source>
        <translation type="obsolete">Cor não encontrada no documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Proportional</source>
        <translation type="obsolete">Proporcional</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">Estilo de C&amp;aracter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Close the selected scrapbook</source>
        <translation type="obsolete">Fechar o Bloco de Rascunhos seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset control point</source>
        <translation type="obsolete">Reconfigura o ponto de controle</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Letterheads</source>
        <translation type="obsolete">Cabeçalho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Information</source>
        <translation type="obsolete">Informações do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character Style</source>
        <translation type="obsolete">Estilo de caracter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preferences</source>
        <translation type="obsolete">Preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for items not on a page</source>
        <translation type="obsolete">Procurar objectos fora da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;elete All</source>
        <translation type="obsolete">&amp;Apagar tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Crash</source>
        <translation type="obsolete">Erro no Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Patterns...</source>
        <translation type="obsolete">Padrões...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable &amp;Antialiasing</source>
        <translation type="obsolete">Activar &amp;suavização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current &amp;page</source>
        <translation type="obsolete">&amp;Página actual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>(converted)</source>
        <translation type="obsolete">(convertido)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Default Unit:</source>
        <translation type="obsolete">Uni&amp;dade padrão:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Straight Double</source>
        <translation type="obsolete">Aspas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="obsolete">&lt;b&gt;Insira uma caixa de imagem&lt;/b&gt;&lt;br/&gt;Uma caixa de imagem permite-lhe colocar uma imagem na sua página. Vários efeitos de imagem podem ser aplicados ou combinados, incluindo transparências, luminosidade e posterização, que permitem a criação de resultados visuais interessantes. A escala da imagem e o contorno são controlados na Paleta Propriedades.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete All</source>
        <translation type="obsolete">Exc&amp;luir tudo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Linha de traço ponto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text flows around bounding box</source>
        <translation type="obsolete">O texto flui ao redor do delimitador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview...</source>
        <translation type="obsolete">Visualizar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace with</source>
        <translation type="obsolete">Substituir por</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character Class:</source>
        <translation type="obsolete">Classe de caracteres:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace &amp;All</source>
        <translation type="obsolete">Substituir tod&amp;as</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thick Space</source>
        <translation type="obsolete">Espaço largo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object is not a linked text frame, can&apos;t unlink.</source>
        <translation type="obsolete">O objeto não é um quadro de texto associado, não é possível separar.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Object not found.</source>
        <translation type="obsolete">Objeto não encontrado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="obsolete">O nome &quot;%1&quot; já existe.&lt;br/&gt;Por favor, escolha outro.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Find...</source>
        <translation type="obsolete">&amp;Procurar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Saving...</source>
        <translation type="obsolete">Salvando...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Finnish</source>
        <translation type="obsolete">Finlandês</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right Guillemet</source>
        <translation type="obsolete">Guillemet dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;paces &amp;&amp; Breaks</source>
        <translation type="obsolete">E&amp;spaços &amp;&amp; Quebras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation type="obsolete">Carregando fonte %1 (encontrada usando o fontconfig)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Visible</source>
        <translation type="obsolete">Visível</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Wheel Jump:</source>
        <translation type="obsolete">&amp;Deslocamento da roda:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing Word document failed 
%1</source>
        <translation type="obsolete">A importação do documento do Word falhou
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save As Template</source>
        <translation type="obsolete">Salva como modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Fields</source>
        <translation type="obsolete">Selecionar campos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation type="obsolete">A referência a um documento relacionado, preferencialmente usando um identificador formal tal como ISBN ou URI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation type="obsolete">Abre um polígono ou corta uma curva de Bezier</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Include Bookmarks</source>
        <translation type="obsolete">&amp;Incluir marcadores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Align and Distribute</source>
        <translation type="obsolete">&amp;Alinhar e distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align and Distribute</source>
        <translation type="obsolete">Alinhar e distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot Convert In-Use Item</source>
        <translation type="obsolete">Não é possível converter um item em uso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Effec&amp;t Duration:</source>
        <translation type="obsolete">Duração do &amp;efeito:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot delete text from a non-text frame.</source>
        <translation type="obsolete">Não é possível apagar texto em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance from Text:</source>
        <translation type="obsolete">Distância do texto:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>memcpy offset: %1 %2 %3</source>
        <translation type="obsolete">offset do memcpy: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Full Screen Mode</source>
        <translation type="obsolete">Usar modo ecrã-cheia</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;lpha channel:</source>
        <translation type="obsolete">Canal a&amp;lfa:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as Template</source>
        <translation type="obsolete">Salva como modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation type="obsolete">O idioma no qual esse documento foi escrito, normalmente um código de idioma ISO-639com um hífen opcional e um código de país ISO-3166, por ex. en-GB, fr-CH, pt-BR</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check again</source>
        <translation type="obsolete">Procurar novamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value must be greater than or equal to:</source>
        <translation type="obsolete">O valor deve ser maior ou igual a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation type="obsolete">Uma data associada a um evento durante o ciclo de vida do documento, no formato AAAA-MM-DD, como no ISO-8601</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click to select the line spacing mode</source>
        <translation type="obsolete">Clique para selecionar o modo de espaçamento de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Liga&amp;ture</source>
        <translation type="obsolete">Liga&amp;dura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">Co&amp;mando:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of copies: %1
Horizontal shift: %2
Vertical shift: %3</source>
        <translation type="obsolete">Números de cópias: %1
Deslocamento horizontal: %2
Deslocamento vertical: %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Missing Image</source>
        <translation type="obsolete">imagem em falta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Monochromatic</source>
        <translation type="obsolete">Monocromático</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>I&amp;nclude checksum</source>
        <translation type="obsolete">I&amp;ncluir checksum</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cha&amp;nge...</source>
        <translation type="obsolete">A&amp;lterar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Non Breaking Dash</source>
        <translation type="obsolete">Traço sem quebra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line spacing</source>
        <translation type="obsolete">Definir espaçamento de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mi&amp;nimum:</source>
        <translation type="obsolete">Mí&amp;nimo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mi&amp;nimize</source>
        <translation type="obsolete">Mi&amp;nimizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The changes to your document have not been saved and you have requested to revert them. Do you wish to continue?</source>
        <translation type="obsolete">As alterações feitas no seu documento não foram salvas e você requisitou que elas sejam revertidas. Você deseja continuar?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation type="obsolete">Número de colunas a serem criadas nas molduras de texto criadas automaticamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Free scaling</source>
        <translation type="obsolete">Escala livre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>On Screen Preview</source>
        <translation type="obsolete">Visualização em ecrã</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PDF Presentations</source>
        <translation type="obsolete">Apresentações PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Story Editor - %1</source>
        <translation type="obsolete">Editor de História - %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spaces &amp;&amp; Breaks</source>
        <translation type="obsolete">Espaços &amp;&amp; Quebras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Place page numbers of the entries at the beginning or the end of the line, or not at all</source>
        <translation type="obsolete">Coloque os números das entradas no início ou no final da linha, ou não forneça nenhum</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation type="obsolete">Reduz o tamanho do caminho no valor definido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="obsolete">A principal pessoa ou organização responsável pelo conteúdo do documento.Esse campo pode ser incorporado ao documento do Scribus para referência, assim como nos metadados do PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Path to Font File</source>
        <translation type="obsolete">Localização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left Page</source>
        <translation type="obsolete">Página esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Format:</source>
        <translation type="obsolete">Formato:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>F&amp;ormat:</source>
        <translation type="obsolete">F&amp;ormato:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Minimum Margins for Page Size %1</source>
        <translation type="obsolete">Margens mínimas para uma página %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation type="obsolete">extraindo face %1 de fonte %2 (offset=%3, nTables=%4)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Properties...</source>
        <translation type="obsolete">Propriedades...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File exists. Overwrite?</source>
        <translation type="obsolete">O ficheiro já existe. Sobrescrever?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reading Preferences</source>
        <translation type="obsolete">Lendo preferências</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save &amp;Document</source>
        <translation type="obsolete">Salvar o &amp;documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation type="obsolete">Ficheiros EPS (*.eps);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rotation Tool</source>
        <translation type="obsolete">Ferramenta de Rotação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Large Post</source>
        <translation type="obsolete">Ponto esquerdo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Image Info</source>
        <translation type="obsolete">Informações da imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Master Pages...</source>
        <translation type="obsolete">Páginas &amp;modelo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete the selected master page</source>
        <translation type="obsolete">Apagar a página modelo selecionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Size</source>
        <translation type="obsolete">Tamanho da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">Importar &amp;EPS/PS...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="obsolete">Espelhar página(s) verticalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get text size of non-text frame.</source>
        <translation type="obsolete">Não é possível obter o tamanho do texto de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get font size of non-text frame.</source>
        <translation type="obsolete">Não é possível obter o tamanho da fonte de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Remove Unused</source>
        <translation type="obsolete">&amp;Remover não utilizadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>EXIF Info</source>
        <translation type="obsolete">Informação do EXIF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Only selected frames processed.</source>
        <translation type="obsolete">Somente as molduras seleccionadas são processadas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Warning</source>
        <translation type="obsolete">Aviso</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Blendmode out of bounds, must be 0 &lt;= blendmode &lt;= 15.</source>
        <translation type="obsolete">A intensidade da linha está fora do limite, deve ser &gt;=0 e &lt;=100.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ligatures</source>
        <translation type="obsolete">Ligaduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for search</source>
        <translation type="obsolete">Selecione um directório base de busca</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display &amp;Unprintable Area in Margin Color</source>
        <translation type="obsolete">Exibir área &amp;não-imprimível na cor das margens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overall Progress:</source>
        <translation type="obsolete">Progresso geral:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Processing Master Page:</source>
        <translation type="obsolete">Processando Páginas Modelo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Magazines</source>
        <translation type="obsolete">Revistas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Item Duplicate</source>
        <translation type="obsolete">Duplicado de item</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From %1
to %2</source>
        <translation type="obsolete">De %1
para %2 </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Re&amp;vert to Saved</source>
        <translation type="obsolete">Re&amp;verter para última versão salva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> from %1</source>
        <translation type="obsolete"> de %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> doesn&apos;t contain any docstring!</source>
        <translation type="obsolete"> não possui nenhuma docstring!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Constrain to:</source>
        <translation type="obsolete">Constranger a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Uses xx as shortcut for a language, eg `en&apos; or `de&apos;</source>
        <translation type="obsolete">Use xx ou xx_XX como atalho para um idioma, exemplo: en, de ou pt_BR</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed in PostScript</source>
        <translation type="obsolete">Incluir no PostScript</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Inserir um marcador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overprinting</source>
        <translation type="obsolete">Sobreimpressão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="obsolete">Simula defeitos comuns de visão. Selecione o tipo de defeito.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance of text from right of frame</source>
        <translation type="obsolete">Distância entre o texto e a borda direita do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>TabPrinterBase</source>
        <translation type="obsolete">Margens da impressora...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset control points</source>
        <translation type="obsolete">Reconfigura os pontos de controle</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open &amp;Existing Document</source>
        <translation type="obsolete">Abrir documento &amp;existente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pictures in picture frames are scaled to the size of the frame</source>
        <translation type="obsolete">As imagens são dimensionadas no tamanho do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Marks &amp;&amp; Bleeds</source>
        <translation type="obsolete">Miras &amp;&amp; Sangrias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <translation type="obsolete">Alinhamento fora do limite. Use uma das constantes scribus.ALIGN*.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Spacing below the paragraph</source>
        <translation type="obsolete">Espaço abaixo do parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mask the area outside the margins in the margin color</source>
        <translation type="obsolete">Preenche a área fora das margens com a cor da margem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is Parent Of</source>
        <translation type="obsolete">É pai de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Text Chains</source>
        <translation type="obsolete">Mostrar conexões de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>General</source>
        <translation type="obsolete">Geral</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;General</source>
        <translation type="obsolete">&amp;Geral</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="obsolete">Cores selecionadas pelo seu esquema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Smart text selection</source>
        <translation type="obsolete">&amp;Seleção inteligente de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Export to Directory:</source>
        <translation type="obsolete">&amp;Exportar para o directório:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;uthors</source>
        <translation type="obsolete">A&amp;utores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation type="obsolete">Importar do &amp;OpenOffice.org Draw...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="obsolete">Cores sólidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Manual Tracking</source>
        <translation type="obsolete">Espaçamento entre letras manual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dynamic Color Bars</source>
        <translation type="obsolete">Barras de cor dinâmicas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Character Styles</source>
        <translation type="obsolete">Estilos de caracteres</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Book&amp;marks</source>
        <translation type="obsolete">&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>One directory up</source>
        <translation type="obsolete">Um directório acima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for PDF Annotations and Fields</source>
        <translation type="obsolete">Procurar anotações e campos de PDF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Include frames that are set to not print as well</source>
        <translation type="obsolete">Incluir também as molduras que estão configuradas como &apos;não imprimir&apos;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Setting up Shortcuts</source>
        <translation type="obsolete">Configurando teclas de atalho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation type="obsolete">Versão para Mac OS&amp;#174; X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation type="obsolete">Inclui o dígito de checagem da soma no texto do código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Recent Documents:</source>
        <translation type="obsolete">Documentos &amp;recentes:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Save and Exit</source>
        <translation type="obsolete">&amp;Salvar e sair</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview File Info</source>
        <translation type="obsolete">Visualizar informações do ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="obsolete">Simular um meio de cor inteiramente gerido:
Todas as cores, rgb ou cmyk, são convertidas para o espaço de cor da impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <translation type="obsolete">Não é possível definir o espaço entre colunas em um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paragraphs: </source>
        <translation type="obsolete">Parágrafos: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ma&amp;ximum:</source>
        <translation type="obsolete">Má&amp;ximo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Bleed Area</source>
        <translation type="obsolete">Mostrar área de sangria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ma&amp;ximize</source>
        <translation type="obsolete">Ma&amp;ximizar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>TabScrapbookBase</source>
        <translation type="obsolete">Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Highlight</source>
        <translation type="obsolete">Destaque</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>N&amp;umber of Pages:</source>
        <translation type="obsolete">N&amp;úmero de páginas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Radius of the area where Scribus will allow you to grab an objects handles</source>
        <translation type="obsolete">Raio da área onde um manuseador de objetos pode ser selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Restore Down</source>
        <translation type="obsolete">Restaurar abaixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open Recent &amp;Document</source>
        <translation type="obsolete">Abrir documento &amp;recente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set start and end arrows</source>
        <translation type="obsolete">Define setas no início e fim</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 has broken glyph %2</source>
        <translation type="obsolete">A fonte %1 possui caracteres %2 problemáticos (charcode%3)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Icon Placement</source>
        <translation type="obsolete">Posicionamento do ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot create a color with an empty name.</source>
        <translation type="obsolete">Não é possível criar uma cor sem um nome.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Brightness</source>
        <translation type="obsolete">Brilho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fatal Error</source>
        <translation type="obsolete">Erro fatal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bleed Settings</source>
        <translation type="obsolete">Configurações de sangria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for &amp;Updates</source>
        <translation type="obsolete">Procurar &amp;Actualizações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align text</source>
        <translation type="obsolete">Alinhar texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align tops</source>
        <translation type="obsolete">Alinhar topos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Windows</source>
        <translation type="obsolete">&amp;Janelas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right Guillemet</source>
        <translation type="obsolete">Guillemet simples à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Initial State</source>
        <translation type="obsolete">Estado inicial</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Check for GIF images</source>
        <translation type="obsolete">Procurar imagens GIF</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation type="obsolete">O documento possui algumas fonte que não estão instaladas em seu sistema. Por favor, selecione as fontes que podem substitui-las. &apos;Cancelar&apos; fará que o documento pare de ser carregado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Input Profile:</source>
        <translation type="obsolete">Perfil de entrada:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror Page(s) vertically</source>
        <translation type="obsolete">Espelhar página(s) verticalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default is Checked</source>
        <translation type="obsolete">O padrão é selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enter a position:</source>
        <translation type="obsolete">Forneça uma posição:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Snap Distance:</source>
        <translation type="obsolete">Distância de atração:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation type="obsolete">cabeçalho do memcpy: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation type="obsolete">Alinhar os lados esquerdos dos objectos ao lado direito da âncora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Underline &amp;Words</source>
        <translation type="obsolete">Sublinhar &amp;palavras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Pattern of line</source>
        <translation type="obsolete">Padrão da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Glitter</source>
        <translation type="obsolete">Brilho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation type="obsolete">Cor do texto selecionado. Se o estilo &apos;delineado&apos; estiver activado, esta cor será a cor de preenchimento. Se o estilo &apos;sombra&apos; estiver activado, então esta será a cor frontal.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To override the default language choice:</source>
        <translation type="obsolete">Para sobrescrever o idioma padrão selecione:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Opções avançadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Placing in Documents</source>
        <translation type="obsolete">Posição no documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Send to Patterns</source>
        <translation type="obsolete">Enviar para os Padrões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Stroke Color:</source>
        <translation type="obsolete">Cor do traço:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This file is not recognized as a PDB document. Please, report this as a bug if you are sure it is one.</source>
        <translation type="obsolete">Este ficheiro não é reconhecido como um documento PDB. Por favor, reporte isto como um erro caso você tenha certeza que este é um ficheiro válido.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;About Scribus</source>
        <translation type="obsolete">&amp;Sobre o Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exporting Page:</source>
        <translation type="obsolete">Exportando página:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation type="obsolete">Não foi possível recolher todos os ficheiros para a saída:
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output &amp;Intended For:</source>
        <translation type="obsolete">&amp;Intenção de saída:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Seleciona o ponto-base ao centro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Setup Printer</source>
        <translation type="obsolete">Configurar impressora</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save a document as a template</source>
        <translation type="obsolete">Salva um documento como modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HTML Files</source>
        <translation type="obsolete">Ficheiros HTML</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the basegrid on or off</source>
        <translation type="obsolete">Torna a pauta ativa ou inativa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable format from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the simple Story Editor.</source>
        <translation type="obsolete">&lt;b&gt;Insira uma caixa de texto&lt;/b&gt;&lt;br/&gt;Uma caixa de texto permite-lhe inserir qualquer texto numa posição definida com a formatação que escolher. Pode escolher um ficheiro de texto no aba Opções se quiser importar directamente um documento para uma caixa . O Scribus suporta uma grande variedade de formatos importáveis de texto simples a documentos openOffice.org.&lt;br/&gt;O seu texto pode ser editado e formatado directamente na página ou no simples Editor de História.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is Registration Color</source>
        <translation type="obsolete">É uma cor de registro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>XML File:</source>
        <translation type="obsolete">Ficheiro XML:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Non Breaking Dash</source>
        <translation type="obsolete">Inserir traço sem quebra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Char:</source>
        <translation type="obsolete">Cor do preenchimento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Color</source>
        <translation type="obsolete">Cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enhanced Palette</source>
        <translation type="obsolete">Paleta melhorada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Center on horizontal axis</source>
        <translation type="obsolete">Centralizar no eixo horizontal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>SVG-Images (*.svg);;All Files (*)</source>
        <translation type="obsolete">Imagens SVG (*.svg);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Registration Marks</source>
        <translation type="obsolete">Miras de registo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Plugin: loading %1</source>
        <translation type="obsolete">Plugin: carregando %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;All Pages</source>
        <translation type="obsolete">&amp;Todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow adding annotations and fields to the PDF. If unchecked, editing annotations and fields is prevented.</source>
        <translation type="obsolete">Permite acrescentar anotações e campos ao PDF. Se desmarcado, a edição de anotações e campos é prevenida.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Pages</source>
        <translation type="obsolete">Todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cell Lines</source>
        <translation type="obsolete">Linhas da célula</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default Paragraph Style</source>
        <translation type="obsolete">Estilo de parágrafo padrão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X, Y, &amp;Z</source>
        <translation type="obsolete">X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal position of current basepoint</source>
        <translation type="obsolete">Posição horizontal do ponto-base atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default unit of measurement for document editing</source>
        <translation type="obsolete">Unidade de medida padrão para edição do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill Shade</source>
        <translation type="obsolete">Intensidade do preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rendering intent for images</source>
        <translation type="obsolete">Renderização pretendida para imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Field delimiter:</source>
        <translation type="obsolete">Delimitador de campo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of lines</source>
        <translation type="obsolete">Cor das linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>1st. Analogous</source>
        <translation type="obsolete">1° corespondente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Words: </source>
        <translation type="obsolete">Palavras: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Color:</source>
        <translation type="obsolete">Apagar cor:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>English (Australian)</source>
        <translation type="obsolete">Inglês (Australiano)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill color</source>
        <translation type="obsolete">Cor de preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance from the top of the page for the first baseline</source>
        <translation type="obsolete">Distância do topo da página para a primeira linha de pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Small &amp;Caps</source>
        <translation type="obsolete">Minús&amp;culas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;All items</source>
        <translation type="obsolete">&amp;Todos os ítens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Text...</source>
        <translation type="obsolete">Editar texto...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation type="obsolete">A extensão ou escopo do conteúdo do documento, preferencialmente incluindo os limites de localização, tempo e jurisdição</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;All pages</source>
        <translation type="obsolete">&amp;Todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Baseline Settings</source>
        <translation type="obsolete">Configurações de pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>the file</source>
        <translation type="obsolete">o ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation type="obsolete">Permitir que a imagem seja de tamanho diferente do quadro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Diagonal Gradient</source>
        <translation type="obsolete">Gradiente diagonal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Altura das páginas do documento. Editável se você escolheu um tamanho personalizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;hading:</source>
        <translation type="obsolete">Inten&amp;sidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shading:</source>
        <translation type="obsolete">&amp;Intensidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shading:</source>
        <translation type="obsolete">Intensidade:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enter a value then press OK.</source>
        <translation type="obsolete">Entre com um valor e pressione Ok.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Fill shade</source>
        <translation type="obsolete">Intensidade do preenchimento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Update Text Frame</source>
        <translation type="obsolete">At&amp;ualizar o quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Example:</source>
        <translation type="obsolete">Exemplo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print Separations</source>
        <translation type="obsolete">Imprimir por separações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Change..</source>
        <translation type="obsolete">&amp;Alterar...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Action history length</source>
        <translation type="obsolete">Tamanho do histórico de ações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Linking Text Frames</source>
        <translation type="obsolete">Liga molduras de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenDocument Importer Options</source>
        <translation type="obsolete">Opções do importador do OpenOffice.org Writer</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample will be shown after key release</source>
        <translation type="obsolete">Uma amostra será mostrada antes da versão final</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="obsolete">Tornar a camada visível - desassinale para esconder a camada no no ecrã</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OpenDocument 1.0 Draw</source>
        <translation type="obsolete">Desenho em OpenDocument 1.0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move Control Points Symmetrical</source>
        <translation type="obsolete">Move os pontos de controle simetricamente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot write the file: 
%1</source>
        <translation type="obsolete">Não é possível escrever o ficheiro: 
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Do Not Scroll</source>
        <translation type="obsolete">Não rolar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Inverts the curve</source>
        <translation type="obsolete">Inverte a curva</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set radius of corner rounding</source>
        <translation type="obsolete">Configurar o raio do arredondamento do canto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of the lines in barcode</source>
        <translation type="obsolete">A Cor das linhas no código de barras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Group%1</source>
        <translation type="obsolete">Agrupar%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rename Master Page</source>
        <translation type="obsolete">Renomear página modelo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Sim&amp;ular o resultado da impressão no no ecrã</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Effect T&amp;ype:</source>
        <translation type="obsolete">&amp;Tipo de efeito:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <translation type="obsolete">Unidade fora do limite. Use uma das constantes scribus.UNIT_*.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import text without any formatting</source>
        <translation type="obsolete">Importa o texto sem nenhuma formatação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Resolution Preview</source>
        <translation type="obsolete">Visualizar em baixa resolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Under Color Removal</source>
        <translation type="obsolete">&amp;Remoção de Sub-Cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable or disable drop cap</source>
        <translation type="obsolete">Activa ou desactiva a impressão do objeto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Image:</source>
        <translation type="obsolete">Imagem fonte:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Failed to open document.</source>
        <translation type="obsolete">Não foi possível abrir o documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enables presentation effects when using Adobe&amp;#174; Reader&amp;#174; and other PDF viewers which support this in full screen mode.</source>
        <translation type="obsolete">Activa os efeitos de apresentação quando usado o Adobe&amp;#174; Reader&amp;#174; ou  outro visualizador de PDF que suporte esse recurso em modo ecrã-cheia.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Is Child Of</source>
        <translation type="obsolete">É filho de</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Removing a template from the New From Template dialog will only remove the entry from the template.xml, it will not delete the document files. A popup menu with remove is only shown if you have write access to the template.xml file.</source>
        <translation type="obsolete">Remover um modelo da janela de diálogo &quot;Novo a partir do modelo&quot; apagará só a entrada do template.xml, mas não apagará os ficheiros. Um menu com a opção de apagar só aparecerá se você tiver acesso de escrita ao ficheiro template.xml.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Se a gestão de cor está activada, um indicador triangular de aviso significa que a cor pode estar fora do espaço de cor do perfil de cor da impressora corrente. Isto significa que a cor poderá não ser impressa exactamente como é mostrado no no ecrã. Mais pistas acerca de avisos de gamut podem ser encontradas na ajuda em linha sob Gestão de Cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text for Button Down</source>
        <translation type="obsolete">Texto para botão premido</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation type="obsolete">É necessário pelo menos o ícone para Normal para usar ícones para botões</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Height:</source>
        <translation type="obsolete">&amp;Altura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height:</source>
        <translation type="obsolete">Altura:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scanner Model:</source>
        <translation type="obsolete">Modelo de digitalizador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hyphenator</source>
        <translation type="obsolete">Hifenizador</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colorspace: </source>
        <translation type="obsolete">Espaço de cores: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="obsolete">Cores &amp;sólidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create Page(s)</source>
        <translation type="obsolete">Criar página(s)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Camera Model:</source>
        <translation type="obsolete">Modelo de câmera:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Couldn&apos;t convert result type &apos;%1&apos;.</source>
        <translation type="obsolete">Não foi possível converter o tipo de resultado &apos;%1&apos;.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Bezier Curve</source>
        <translation type="obsolete">Curva de &amp;Bezier</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use right to left dialog button ordering (eg. Cancel/No/Yes instead of Yes/No/Cancel)</source>
        <translation type="obsolete">Usar ordem direita para esquerda de botões da caixa de diálogo (exemplo Cancelar/Não/Sim ao invés de Sim/Não/Cancelar)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Combine Polygons</source>
        <translation type="obsolete">&amp;Combinar polígonos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation type="obsolete">Aciona o modo de edição da linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Official Translations and Translators:</source>
        <translation type="obsolete">Traduções e tradutores oficiais:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Bottom to Top</source>
        <translation type="obsolete">De baixo para cima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quick Palette</source>
        <translation type="obsolete">Paleta rápida</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as P&amp;DF...</source>
        <translation type="obsolete">Salvar como P&amp;DF...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Background...</source>
        <translation type="obsolete">&amp;Fundo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paragraphs:</source>
        <translation type="obsolete">Parágrafos:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus - Image Search</source>
        <translation type="obsolete">Scribus - Procura de imagem</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allow Adding &amp;Annotations and Fields</source>
        <translation type="obsolete">Permite a adição de &amp;anotações e campos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Full Resolution Preview</source>
        <translation type="obsolete">Visualizar em alta resolução</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The Item Attribute that will be set on frames used as a basis for creation of the entries</source>
        <translation type="obsolete">O atributo do item que será definido nas molduras utilizadas como base para criação de entradas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;New Document</source>
        <translation type="obsolete">&amp;Novo documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Caption above Icon</source>
        <translation type="obsolete">Legenda acima do ícone</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mirror Page(s) horizontally</source>
        <translation type="obsolete">Espelhar página(s) horizontalmente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open &amp;Recent</source>
        <translation type="obsolete">Abrir &amp;recente</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Link Annotation</source>
        <translation type="obsolete">Inserir anotações de ligações</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error opening file: %1</source>
        <translation type="obsolete">Erro ao abrir o ficheiro %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line &amp;Width:</source>
        <translation type="obsolete">Espessura da l&amp;inha:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ignore all errors</source>
        <translation type="obsolete">Ignorar todos os erros</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Horizontal Gap:</source>
        <translation type="obsolete">Horizontal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+tracking %1 </source>
        <translation type="obsolete">+espaçamento %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Outline all</source>
        <translation type="obsolete">&amp;Esquema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sticky Tools</source>
        <translation type="obsolete">Ferramentas persistentes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documentation</source>
        <translation type="obsolete">Documentação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remove a line</source>
        <translation type="obsolete">&amp;Remove uma linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal Gap:</source>
        <translation type="obsolete">Horizontal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Zoom Pages to fit Viewer Window</source>
        <translation type="obsolete">Redimensionar páginas para ajustar à janela de visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Include text in barcode</source>
        <translation type="obsolete">&amp;Incluir texto no código de barra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Additional Paths</source>
        <translation type="obsolete">Caminhos adicionais</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose the shape of frame...</source>
        <translation type="obsolete">Seleção da forma do quadro...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance of Text</source>
        <translation type="obsolete">Distância do texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page number out of range.</source>
        <translation type="obsolete">Número da página fora do limite.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keep Aspect &amp;Ratio</source>
        <translation type="obsolete">Manter a &amp;proporção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Disable printing of layer</source>
        <translation type="obsolete">Desactivar impressão da camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create New Folder</source>
        <translation type="obsolete">Criar nova pasta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Consecutive Hyphenations &amp;Allowed:</source>
        <translation type="obsolete">Hifenizações consecutivas &amp;permitidas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>System wide configuration reloaded</source>
        <translation type="obsolete">Recarregar configuração de sistema</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a new layer</source>
        <translation type="obsolete">Adicionar uma nova camada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Items involved</source>
        <translation type="obsolete">Ítens relacionados</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import Master Page</source>
        <translation type="obsolete">Importar Páginas Mestre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text Stroke:</source>
        <translation type="obsolete">Traço do texto:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation type="obsolete">Número de dígitos variáveis e qualquer um dos símbolos -$:/.+ABCD.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Extract the package to the template directory ~/.scribus/templates for the current user or PREFIX/share/scribus/templates for all users in the system.</source>
        <translation type="obsolete">Extraia o pacote para o directório de modelos (~/.scribus/templates) do utilizador atual ou PREFIXO/share/scribus/templates para todos os usuários do sistema.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Effects</source>
        <translation type="obsolete">Efeitos da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import OpenOffice.org Draw image</source>
        <translation type="obsolete">Importar imagem do OpenOffice.org Draw</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot delete image type settings.</source>
        <translation type="obsolete">Não é possível apagar as configurações da imagem.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Miscellaneous Settings</source>
        <translation type="obsolete">Configurações várias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Distância entre a guia da margem esquerda e a borda da página. Se for seleccionado Páginas Espelhadas ou layout de 3 ou 4 dobras, essa medida pode ser usada para ajustar as margens para encadernação</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lorem Ipsum</source>
        <translation type="obsolete">Texto de amostra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Symlink to File</source>
        <translation type="obsolete">Link simbólico para ficheiro</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample Polygon</source>
        <translation type="obsolete">Polígono de exemplo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Força modo de sobreimpressão (overprint)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation type="obsolete">Mova o início do gradiente do vetor com o botão esquerdo do mouse pressionado e mova até o fim com o botão direito do mouse pressionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>TabGeneralBase</source>
        <translation type="obsolete">Geral</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click and hold down to select the line spacing mode.</source>
        <translation type="obsolete">Clique e mantenha premido para seleccionar o modo de espaçamento de linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Left</source>
        <translation type="obsolete">CJK simples à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selection Change</source>
        <translation type="obsolete">Alteração da seleção</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge Paragraph Styles</source>
        <translation type="obsolete">Mesclar os estilos de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for your selected rows</source>
        <translation type="obsolete">Seleccione um directório base para as suas linhas seleccionadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Clone selected style</source>
        <translation type="obsolete">Clonar estilo seleccionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Identi&amp;fier:</source>
        <translation type="obsolete">Identi&amp;ficador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Javascript to be executed
when PDF document is opened:</source>
        <translation type="obsolete">Javascript a ser executado
quando o PDF estiver aberto:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit the currently selected color</source>
        <translation type="obsolete">Editar a cor seleccionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document templates can be found at http://www.scribus.net/ in the Downloads section.</source>
        <translation type="obsolete">Modelos de documentos podem ser encontrados em http://www.scribus.net/, na seção Dowloads.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paste (&amp;Absolute)</source>
        <translation type="obsolete">Colar (&amp;Absoluto)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Left</source>
        <translation type="obsolete">CJK dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load/Save/Import/Export</source>
        <translation type="obsolete">Carregar/Salvar/Importar/Exportar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the guides on or off</source>
        <translation type="obsolete">Activa ou desactiva as guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Frames</source>
        <translation type="obsolete">Mostrar &amp;Molduras</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Convert Page to Master Page</source>
        <translation type="obsolete">Converter página em Página Mestre</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Symlink to Directory</source>
        <translation type="obsolete">Link simbólico para directório</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Timed out when attempting to get update file.</source>
        <translation type="obsolete">Expirou o tempo ao tentar obter ficheiro actualizado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Available Fonts</source>
        <translation type="obsolete">Fontes &amp;disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Allows you to embed ICC profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Permite-lhe incorporar perfis ICC no fluxo de impressão quando a gestão de cor está activada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Available Fonts</source>
        <translation type="obsolete">Fontes disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>None Selected</source>
        <translation type="obsolete">Nenhum selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select one of the available barcode type here</source>
        <translation type="obsolete">Selecione aqui um dos estilos de código de barras disponíveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The item %1 is currently being edited by Story Editor. The delete operation will be cancelled</source>
        <translation type="obsolete">O item %1 está atualmente sendo editado pelo Editor de História. A operação de exclusão será cancelada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of columns in text frame</source>
        <translation type="obsolete">Número de colunas no quadro de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Substitution Font</source>
        <translation type="obsolete">Fontes substitutas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Spacing</source>
        <translation type="obsolete">Espaço entre as linhas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line spacing</source>
        <translation type="obsolete">Entrelinhamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Antialias &amp;Graphics</source>
        <translation type="obsolete">Suavizar as &amp;imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Em Space</source>
        <translation type="obsolete">Espaço em</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Remember the file extension - importer association and do not ask again to select an importer for files of this type.</source>
        <translation type="obsolete">Lembrar da extensão do ficheiro - associação do importador
e não pedir novamente para seleccionar um importador
para ficheiros desse tipo.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Author(s):</source>
        <translation type="obsolete">Autor(es):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right Page</source>
        <translation type="obsolete">Página direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solid Line</source>
        <translation type="obsolete">Linha contínua</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Ligar molduras criadas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start Offset:</source>
        <translation type="obsolete">Deslocamento inicial:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Text Chain</source>
        <translation type="obsolete">Mostrar conexões de &amp;texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Style:</source>
        <translation type="obsolete">Apagar estilo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete Styles</source>
        <translation type="obsolete">Apagar estilos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shortcut</source>
        <translation type="obsolete">Atalho</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&lt;b&gt;Scribus Version %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</source>
        <translation type="obsolete">&lt;b&gt; Scribus Versão %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset contour line</source>
        <translation type="obsolete">Redefinir linha de contorno</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Master Page:</source>
        <translation type="obsolete">Página &amp;Modelo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation type="obsolete">Título do novo marcador:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use Viewers Defaults</source>
        <translation type="obsolete">Usar visualização padrão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set line color shade</source>
        <translation type="obsolete">Definir intensidade da cor da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Inserir caixa de texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show &amp;Images</source>
        <translation type="obsolete">Mostrar &amp;imagens</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot convert a non-text frame to outlines.</source>
        <translation type="obsolete">Não é possível converter em contorno um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Output version information and exit</source>
        <translation type="obsolete">Mostra as informações sobre versão e sai</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Collect for O&amp;utput...</source>
        <translation type="obsolete">Reunir para &amp;saída</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Release Date:</source>
        <translation type="obsolete">Data de lançamento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="obsolete">Distância entre a guia da margem superior e a borda da página</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>More Details</source>
        <translation type="obsolete">Mais detalhes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Verification of settings failed: %1</source>
        <translation type="obsolete">A verificação das configurações falhou: %1 </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Installing Templates</source>
        <translation type="obsolete">Instalando modelos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display Thumbnails</source>
        <translation type="obsolete">Exibir miniaturas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Short Words processing. Done.</source>
        <translation type="obsolete">Processamento de abreviaturas concluído.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <translation type="obsolete">o valor do elemento &lt;%1&gt; deve ser &apos;false&apos; ou &apos;true&apos;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The item %1 is currently being edited by Story Editor. The cut operation will be cancelled</source>
        <translation type="obsolete">O item %1 está atualmente sendo editado pelo Editor de História. A operação de corte será cancelada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basic Range Selection</source>
        <translation type="obsolete">Configurações de pauta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace With:</source>
        <translation type="obsolete">Substituir por:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>License:</source>
        <translation type="obsolete">Licença:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation type="obsolete">Uma referência ao documento do qual esse derivou, por ex. ISBN ou URI</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>firstPageOrder is bigger than allowed.</source>
        <translation type="obsolete">firstPageOrder é maior que o permitido.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Distâncias e alinhamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus crashes due to the following exception : %1</source>
        <translation type="obsolete">O Scribus travou devido a seguinte excessão:%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Pages:</source>
        <translation type="obsolete">Páginas do documento:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Sections</source>
        <translation type="obsolete">Seções do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot render an empty sample.</source>
        <translation type="obsolete">Não é possível renderizar um exemplo vazio.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Key Set XML Files (*.ksxml)</source>
        <translation type="obsolete">Ficheiro XML de definições de teclas (*.ksxml)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset all changes</source>
        <translation type="obsolete">Exportar todas as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set end arrow</source>
        <translation type="obsolete">Define a seta de fim</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Detail View</source>
        <translation type="obsolete">Visualizar detalhes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show selected object only</source>
        <translation type="obsolete">Mostrar apenas o objeto selecionado</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable Extension Scripts</source>
        <translation type="obsolete">Activa os scripts de extensão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset Control Points</source>
        <translation type="obsolete">Reconfigura os pontos de controle</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed fonts into the PDF. Embedding the fonts will preserve the layout and appearance of your document.</source>
        <translation type="obsolete">Incorpora as fontes ao PDF. Isso preserva o layout e a aparência do seu documento.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lithuanian</source>
        <translation type="obsolete">Lituano</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Toggle Guides</source>
        <translation type="obsolete">Mostrar/Ocultar guias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus Manual</source>
        <translation type="obsolete">Manual do Scribus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <translation type="obsolete">O Scribus não conseguiu salvar estas preferências:&lt;br&gt;%1&lt;br&gt;Por favor verifique o ficheiro, as permissões de acesso do directório e o espaço disponível em disco.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace with:</source>
        <translation type="obsolete">Substituir por:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cannot get column gap of non-text frame.</source>
        <translation type="obsolete">Não é possível obter o espaço entre colunas de um quadro que não seja de texto.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Term:</source>
        <translation type="obsolete">Procurar o termo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Printing Enabled</source>
        <translation type="obsolete">Im&amp;pressão activada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a Name</source>
        <translation type="obsolete">Escolha um nome</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="obsolete">Por &amp;linhas &amp;&amp;colunas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;About Script...</source>
        <translation type="obsolete">&amp;Sobre o script...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Thursday</source>
        <translation type="obsolete">Quinta-Feira</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Current page</source>
        <translation type="obsolete">&amp;Página atual</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Length of time the page is shown before the presentation starts on the selected page. Setting 0 will disable automatic page transition.</source>
        <translation type="obsolete">Período de tempo em que a página é exibida antes que a apresentação comece na página selecionada. O valor 0 desactiva a transição automática.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loadable Shortcut Sets</source>
        <translation type="obsolete">Atalhos de teclados carregáveis</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>In the Background</source>
        <translation type="obsolete">No fundo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Arrange Pages</source>
        <translation type="obsolete">Organizar as páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Arrange Pages</source>
        <translation type="obsolete">Organiz&amp;ar páginas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Supported Formats (*.eps *.EPS *.epsi *.EPSI *.ps *.PS);;</source>
        <translation type="obsolete">Todos os formatos suportados (*.eps *.EPS *.ps *.PS);;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Created with</source>
        <translation type="obsolete">Criado com</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>+baseline %1 </source>
        <translation type="obsolete">+pauta %1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance within which an object will snap to your placed guides</source>
        <translation type="obsolete">Distância dentro da qual um objeto será atraído para a guia mais próxima</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Antialias &amp;Text</source>
        <translation type="obsolete">Suavizar o &amp;texto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ligature</source>
        <translation type="obsolete">Ligadura</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>7 or 8 digits</source>
        <translation type="obsolete">7 ou 8 dígitos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Small Form Variants</source>
        <translation type="obsolete">Variantes de pequenos formulários</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alignment</source>
        <translation type="obsolete">Alinhamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color of font</source>
        <translation type="obsolete">Cor da fonte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Less Details</source>
        <translation type="obsolete">Menos detalhes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Alignment</source>
        <translation type="obsolete">&amp;Alinhamento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>
External Links
</source>
        <translation type="obsolete">
Ligações externas
</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X: %1, Y: %2
W: %3, H: %4</source>
        <translation type="obsolete">X: %1, Y: %2
L: %3, A: %4</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Layout</source>
        <translation type="obsolete">Layout do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X: %1, Y: %2
X: %4, Y: %5</source>
        <translation type="obsolete">X: %1, Y: %2
X: %4, Y: %5</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation type="obsolete">Norueguês (Nnyorsk)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top to Bottom</source>
        <translation type="obsolete">De cima para baixo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation type="obsolete">Use o nome do documento como um prefixo para os estilos de parágrafo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vision Defect Type:</source>
        <translation type="obsolete">Cegueira cromática:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import &amp;SVG...</source>
        <translation type="obsolete">Importar &amp;SVG...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit JavaScripts</source>
        <translation type="obsolete">Editar Javascripts</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Brightness:</source>
        <translation type="obsolete">Brilho:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import SVG image</source>
        <translation type="obsolete">Importar imagem SVG</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Edit Line Color Properties</source>
        <translation type="obsolete">Edita propriedades da cor da linha</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make a copy of the currently selected color</source>
        <translation type="obsolete">Fazer uma cópia da cor seleccionada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make the current colorset the default color set</source>
        <translation type="obsolete">Tornar o actual conjunto de cores o conjunto padrão</translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="124"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="127"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="264"/>
        <source>Group%1</source>
        <translation type="unfinished">Agrupar%1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="2226"/>
        <source>Generating Items</source>
        <translation type="unfinished">Gerando itens</translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>Sobre o Scribus %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="124"/>
        <source>%1 %2 %3</source>
        <translation>%1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="132"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation>%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="182"/>
        <source>Using Ghostscript version %1</source>
        <translation>Usando a versão %1 do GhostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="184"/>
        <source>No Ghostscript version available</source>
        <translation>Nenhuma versão de GhostScript disponível</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="132"/>
        <source>&lt;b&gt;Scribus Version %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</source>
        <translation type="obsolete">&lt;b&gt; Scribus Versão %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Build ID:</source>
        <translation>ID da versão:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="187"/>
        <source>&amp;About</source>
        <translation>&amp;Sobre</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="296"/>
        <source>Development Team:</source>
        <translation>Equipa de desenvolvimento:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="304"/>
        <source>Contributions from:</source>
        <translation>Contribuições de:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="298"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation>Versão para Mac OS&amp;#174; X:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="300"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation>Versão para OS/2&amp;#174;/eComStation&amp;#8482;:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="302"/>
        <source>Windows&amp;#174; Port:</source>
        <translation>Versão para Windows&amp;#174;:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="306"/>
        <source>Official Documentation:</source>
        <translation>Documentação oficial:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="310"/>
        <source>Other Documentation:</source>
        <translation>Outras documentações:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="316"/>
        <source>Tango Project Icons:</source>
        <translation>Ícones do projeto Tango:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="200"/>
        <source>A&amp;uthors</source>
        <translation>A&amp;utores</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="328"/>
        <source>Official Translations and Translators:</source>
        <translation>Traduções e tradutores oficiais:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="330"/>
        <source>Previous Translation Contributors:</source>
        <translation>Colaboradores das traduções anteriores:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="214"/>
        <source>&amp;Translations</source>
        <translation>&amp;Traduções</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="344"/>
        <source>Homepage</source>
        <translation>Página da Web</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="346"/>
        <source>Online Reference</source>
        <translation>Referência online</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="348"/>
        <source>Wiki</source>
        <translation>Wiki</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="350"/>
        <source>Bugs and Feature Requests</source>
        <translation>Erros e pedidos de funcionalidades</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="354"/>
        <source>Mailing List</source>
        <translation>Lista de discussão</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="225"/>
        <source>&amp;Online</source>
        <translation>&amp;Online</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="228"/>
        <source>&amp;Updates</source>
        <translation>&amp;Acualizações</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="411"/>
        <source>Check for &amp;Updates</source>
        <translation type="obsolete">Procurar &amp;Actualizações</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="264"/>
        <source>&amp;Close</source>
        <translation>&amp;Fechar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus. The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support. Last Letter is the renderer C=cairo or A=libart Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected. The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="obsolete">Esse painel mostra a versão, data de construção e o suporte às bibliotecas compiladas no Scribus.O C-C-T-F indica suporte a C=littlecms  C=CUPS T=TIFF F=Fontconfig. A última letra é o tipo de renderizador C=cairo ou A=libart. Bibliotecas não suportadas são indicadas por *. Isto também indica a versão do Ghostscript que o Scribus detectou. A versão Windows não usa fontconfig nem bibliotecas CUPS.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="276"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation>Procurar actualizações do Scribus. Nenhum dado será transferido da sua máquina.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="314"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="272"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="273"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="274"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="275"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Scribus Version</source>
        <translation type="unfinished">Versão do Scribus</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="648"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="646"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="352"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="239"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="248"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="308"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="312"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="624"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation>Nome do ficheiro:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation>Versão:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation>Activado:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation>Data de lançamento:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation>Descrição:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation>Autor(es):</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation>Direitos de autor:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation>Licença:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished">Scribus - Sobre os Plug-ins</translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="obsolete">Scribus - Sobre os Plug-ins</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Fechar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1254"/>
        <source>&amp;New</source>
        <translation>&amp;Novo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1255"/>
        <source>&amp;Open...</source>
        <translation>&amp;Abrir...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1256"/>
        <source>&amp;Close</source>
        <translation>&amp;Fechar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1258"/>
        <source>Save &amp;As...</source>
        <translation>Salv&amp;ar como...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1259"/>
        <source>Re&amp;vert to Saved</source>
        <translation>Re&amp;verter para última versão salva</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1260"/>
        <source>Collect for O&amp;utput...</source>
        <translation>Reunir para &amp;saída...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1261"/>
        <source>Get Text...</source>
        <translation>Obter texto...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1262"/>
        <source>Append &amp;Text...</source>
        <translation>Acrescentar &amp;texto...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1263"/>
        <source>Get Image...</source>
        <translation>Obter imagem...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1266"/>
        <source>Save &amp;Text...</source>
        <translation>Salvar &amp;texto...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1267"/>
        <source>Save as &amp;EPS...</source>
        <translation>Salvar como &amp;EPS...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1268"/>
        <source>Save as P&amp;DF...</source>
        <translation>Salvar como P&amp;DF...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1269"/>
        <source>Document &amp;Setup...</source>
        <translation>&amp;Configurações do documento...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1270"/>
        <source>P&amp;references...</source>
        <translation>P&amp;referências...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1271"/>
        <source>&amp;Print...</source>
        <translation>Im&amp;primir...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1272"/>
        <source>Print Previe&amp;w</source>
        <translation>Pré-&amp;visualizar impressão</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1273"/>
        <source>&amp;Quit</source>
        <translation>&amp;Sair</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Undo</source>
        <translation>&amp;Desfazer</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1276"/>
        <source>&amp;Redo</source>
        <translation>&amp;Refazer</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Item Action Mode</source>
        <translation>Modo Acção de &amp;item</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1278"/>
        <source>Cu&amp;t</source>
        <translation>Cor&amp;tar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1282"/>
        <source>&amp;Paste</source>
        <translation>&amp;Colar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1283"/>
        <source>Paste (&amp;Absolute)</source>
        <translation>Colar (&amp;Absoluto)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1284"/>
        <source>C&amp;lear</source>
        <translation>&amp;Limpar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1285"/>
        <source>Select &amp;All</source>
        <translation>Selecionar &amp;tudo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1287"/>
        <source>&amp;Deselect All</source>
        <translation>&amp;Deselecionar tudo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1288"/>
        <source>&amp;Search/Replace...</source>
        <translation>Procurar/&amp;Substituir...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1289"/>
        <source>Edit Image...</source>
        <translation>Editar imagem...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1291"/>
        <source>C&amp;olors...</source>
        <translation>C&amp;ores...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1293"/>
        <source>Patterns...</source>
        <translation>Padrões...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>S&amp;tyles...</source>
        <translation>E&amp;stilos...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Paragraph Styles...</source>
        <translation type="obsolete">Estilos de &amp;parágrafo...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Line Styles...</source>
        <translation type="obsolete">Estilos de &amp;linha...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1295"/>
        <source>&amp;Master Pages...</source>
        <translation>Páginas &amp;modelo...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1296"/>
        <source>&amp;JavaScripts...</source>
        <translation>&amp;JavaScripts...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1303"/>
        <source>%1 pt</source>
        <translation>%1 pt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1305"/>
        <source>&amp;Other...</source>
        <translation>&amp;Outro...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1306"/>
        <source>&amp;Left</source>
        <translation>&amp;Esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1307"/>
        <source>&amp;Center</source>
        <translation>&amp;Centro</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1308"/>
        <source>&amp;Right</source>
        <translation>Di&amp;reita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Block</source>
        <translation>&amp;Bloco</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Forced</source>
        <translation>&amp;Forçado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1321"/>
        <source>&amp;Normal</source>
        <translation>&amp;Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1322"/>
        <source>&amp;Underline</source>
        <translation>S&amp;ublinhado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1323"/>
        <source>Underline &amp;Words</source>
        <translation>Sublinhar &amp;palavras</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1324"/>
        <source>&amp;Strike Through</source>
        <translation>Risca&amp;do</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;All Caps</source>
        <translation>Caixa &amp;Alta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1326"/>
        <source>Small &amp;Caps</source>
        <translation>&amp;Versaletes</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1327"/>
        <source>Su&amp;perscript</source>
        <translation>So&amp;brescrito</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1328"/>
        <source>Su&amp;bscript</source>
        <translation>Subsc&amp;rito</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation>C&amp;ontorno</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1330"/>
        <source>S&amp;hadow</source>
        <translation>S&amp;ombra</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1332"/>
        <source>&amp;Image Effects</source>
        <translation>Efeitos de &amp;imagem</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Tabulators...</source>
        <translation>&amp;Tabuladores...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1336"/>
        <source>D&amp;uplicate</source>
        <translation>D&amp;uplicar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Multiple Duplicate</source>
        <translation>Duplicações &amp;múltiplas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1338"/>
        <source>&amp;Delete</source>
        <translation>&amp;Apagar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1339"/>
        <source>&amp;Group</source>
        <translation>A&amp;grupar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1340"/>
        <source>&amp;Ungroup</source>
        <translation>Desagr&amp;upar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1341"/>
        <source>Is &amp;Locked</source>
        <translation>Está b&amp;loqueado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1342"/>
        <source>Si&amp;ze is Locked</source>
        <translation>Tamanho &amp;Bloqueado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Printing Enabled</source>
        <translation>Im&amp;pressão activada</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Flip Horizontally</source>
        <translation>&amp;Espelhar horizontalmente</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1345"/>
        <source>&amp;Flip Vertically</source>
        <translation>&amp;Espelhar verticalmente</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1346"/>
        <source>Lower to &amp;Bottom</source>
        <translation>Baixar para o &amp;fundo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1347"/>
        <source>Raise to &amp;Top</source>
        <translation>Pôr no &amp;cimo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Lower</source>
        <translation>&amp;Baixar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Raise</source>
        <translation>&amp;Elevar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1350"/>
        <source>Send to S&amp;crapbook</source>
        <translation>Enviar para o Bloco de &amp;Rascunhos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1351"/>
        <source>Send to Patterns</source>
        <translation>Enviar para os Padrões</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Attributes...</source>
        <translation>&amp;Atributos...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1353"/>
        <source>More Info...</source>
        <translation>Mais informações...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1354"/>
        <source>I&amp;mage Visible</source>
        <translation>I&amp;magem visível</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1355"/>
        <source>&amp;Update Image</source>
        <translation>At&amp;ualizar imagem</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1356"/>
        <source>Adjust Frame to Image</source>
        <translation>Ajustar caixa à imagem</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1358"/>
        <source>Extended Image Properties</source>
        <translation>Propriedades estendidas de imagem</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Low Resolution</source>
        <translation>Baixa reso&amp;lução</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1360"/>
        <source>&amp;Normal Resolution</source>
        <translation>&amp;Média resolução</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1361"/>
        <source>&amp;Full Resolution</source>
        <translation>&amp;Alta resolução</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1362"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation>É um &amp;marcardor de PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1363"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation>É uma a&amp;notação de PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1364"/>
        <source>Annotation P&amp;roperties</source>
        <translation>P&amp;ropriedades da anotação</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1365"/>
        <source>Field P&amp;roperties</source>
        <translation>Propriedades do &amp;campo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1366"/>
        <source>&amp;Edit Shape...</source>
        <translation>&amp;Editar a forma...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1367"/>
        <source>&amp;Attach Text to Path</source>
        <translation>&amp;Unir o texto ao caminho</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1368"/>
        <source>&amp;Detach Text from Path</source>
        <translation>&amp;Separar o texto do caminho</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1369"/>
        <source>&amp;Combine Polygons</source>
        <translation>&amp;Combinar polígonos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1370"/>
        <source>Split &amp;Polygons</source>
        <translation>Separar os &amp;polígonos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Bezier Curve</source>
        <translation>Curva de &amp;Bezier</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Image Frame</source>
        <translation>Caixa de &amp;imagem</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation>&amp;Contornos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1374"/>
        <source>&amp;Polygon</source>
        <translation>&amp;Polígono</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Text Frame</source>
        <translation>Caixa de &amp;texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Frame...</source>
        <translation>&amp;Caixa...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Glyph...</source>
        <translation>Caracter e&amp;special...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1380"/>
        <source>Sample Text</source>
        <translation>Texto de amostra</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1381"/>
        <source>Sticky Tools</source>
        <translation>Ferramentas persistentes</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1384"/>
        <source>&amp;Insert...</source>
        <translation>&amp;Inserir...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1385"/>
        <source>Im&amp;port...</source>
        <translation>Im&amp;portar...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1386"/>
        <source>&amp;Delete...</source>
        <translation>&amp;Apagar...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1387"/>
        <source>&amp;Copy...</source>
        <translation>&amp;Copiar...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Move...</source>
        <translation>&amp;Mover...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1389"/>
        <source>&amp;Apply Master Page...</source>
        <translation>&amp;Aplicar página modelo...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1390"/>
        <source>Convert to Master Page...</source>
        <translation>Converter em página modelo...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1391"/>
        <source>Manage &amp;Guides...</source>
        <translation>Gerir &amp;guias...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1392"/>
        <source>Manage Page Properties...</source>
        <translation>Gerir propriedades de página...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1395"/>
        <source>&amp;Fit to Height</source>
        <translation>Ajustar à &amp;Altura</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1396"/>
        <source>Fit to Width</source>
        <translation>Ajustar à Largura</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1397"/>
        <source>&amp;50%</source>
        <translation>&amp;50%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1398"/>
        <source>&amp;75%</source>
        <translation>&amp;75%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;100%</source>
        <translation>&amp;100%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1400"/>
        <source>&amp;200%</source>
        <translation>&amp;200%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1402"/>
        <source>Preview Mode</source>
        <translation>Pré-visualização</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">&amp;Miniaturas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1403"/>
        <source>Show &amp;Margins</source>
        <translation>Mostrar &amp;margens</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1404"/>
        <source>Show Bleeds</source>
        <translation>Mostrar sangrias</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1405"/>
        <source>Show &amp;Frames</source>
        <translation>Mostrar &amp;Caixas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1406"/>
        <source>Show Layer Indicators</source>
        <translation>Mostrar indicadores de Camada</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Images</source>
        <translation>Mostrar &amp;imagens</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show &amp;Grid</source>
        <translation>Mostrar &amp;grelha</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show G&amp;uides</source>
        <translation>Mostrar g&amp;uias</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Text Frame Columns</source>
        <translation>Mostrar colunas de molduras de texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Baseline Grid</source>
        <translation>Mostrar &amp;pauta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Text Chain</source>
        <translation>Mostrar ligações de &amp;texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show Control Characters</source>
        <translation>Mostrar invisíveis</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Rulers</source>
        <translation>Mostrar réguas</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1399"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Réguas relativas à página</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1416"/>
        <source>Sn&amp;ap to Grid</source>
        <translation>&amp;Atrair à grelha</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1417"/>
        <source>Sna&amp;p to Guides</source>
        <translation>A&amp;trair às guias</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1422"/>
        <source>&amp;Properties</source>
        <translation>&amp;Propriedades</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1423"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation>C&amp;ontorno</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1424"/>
        <source>&amp;Scrapbook</source>
        <translation>&amp;Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1425"/>
        <source>&amp;Layers</source>
        <translation>&amp;Camadas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Arrange Pages</source>
        <translation>Organiz&amp;ar páginas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Measurements</source>
        <translation>&amp;Medidas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1429"/>
        <source>Action &amp;History</source>
        <translation>&amp;Histórico de ações</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1430"/>
        <source>Preflight &amp;Verifier</source>
        <translation>&amp;Verificador pré-publicação</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Align and Distribute</source>
        <translation>&amp;Alinhar e distribuir</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Tools</source>
        <translation>&amp;Ferramentas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1433"/>
        <source>P&amp;DF Tools</source>
        <translation>Ferramentas de P&amp;DF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1436"/>
        <source>Select Item</source>
        <translation>Seleccionar item</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1351"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abela</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1352"/>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Forma</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1354"/>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Linha</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1356"/>
        <source>&amp;Freehand Line</source>
        <translation type="obsolete">Linha à mão-li&amp;vre</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1437"/>
        <source>Rotate Item</source>
        <translation>Rodar item</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1438"/>
        <source>Zoom in or out</source>
        <translation>Amplia ou reduz a visualização</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1439"/>
        <source>Zoom in</source>
        <translation>Ampliar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1440"/>
        <source>Zoom out</source>
        <translation>Reduzir</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1441"/>
        <source>Edit Contents of Frame</source>
        <translation>Editar o conteúdo da caixa</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1442"/>
        <source>Edit Text...</source>
        <translation>Editar texto...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1443"/>
        <source>Link Text Frames</source>
        <translation>Ligar molduras de texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1444"/>
        <source>Unlink Text Frames</source>
        <translation>Desligar molduras de texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1445"/>
        <source>&amp;Eye Dropper</source>
        <translation>&amp;Pipeta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1446"/>
        <source>Copy Item Properties</source>
        <translation>Copiar propriedades do item</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1368"/>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Editar o texto com o Editor de História</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1370"/>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Inserir caixa de texto</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1371"/>
        <source>Insert Image Frame</source>
        <translation type="obsolete">Inserir caixa de imagem</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1372"/>
        <source>Insert Table</source>
        <translation type="obsolete">Inserir uma tabela</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1373"/>
        <source>Insert Shape</source>
        <translation type="obsolete">Inserir uma forma</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1374"/>
        <source>Insert Polygon</source>
        <translation type="obsolete">Inserir um polígono</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1375"/>
        <source>Insert Line</source>
        <translation type="obsolete">Inserir uma linha</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1376"/>
        <source>Insert Bezier Curve</source>
        <translation type="obsolete">Inserir uma curva de Bezier</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1377"/>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Inserir uma linha à mão-livre</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert PDF Push Button</source>
        <translation>Inserir um botão de acção PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert PDF Text Field</source>
        <translation>Inserir um campo de texto PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert PDF Check Box</source>
        <translation>Inserir uma caixa de verificação PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1461"/>
        <source>Insert PDF Combo Box</source>
        <translation>Inserir uma caixa de seleção PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF List Box</source>
        <translation>Inserir uma caixa de listagem PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert Text Annotation</source>
        <translation>Inserir anotações de texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert Link Annotation</source>
        <translation>Inserir anotações de ligações</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1412"/>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">&amp;Gerir imagens</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1469"/>
        <source>&amp;Hyphenate Text</source>
        <translation>&amp;Hifenizar o texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1470"/>
        <source>Dehyphenate Text</source>
        <translation>Remover a hifenação do texto</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1471"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation>&amp;Gerar tabela de conteúdos</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1474"/>
        <source>&amp;Cascade</source>
        <translation>&amp;Cascata</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Tile</source>
        <translation>&amp;Lado-a-lado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;About Scribus</source>
        <translation>&amp;Sobre o Scribus</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1423"/>
        <source>&amp;About Plug-ins</source>
        <translation type="obsolete">&amp;Sobre os Plug-ins</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1480"/>
        <source>About &amp;Qt</source>
        <translation>Sobre a &amp;Qt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1481"/>
        <source>Toolti&amp;ps</source>
        <translation>Di&amp;cas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1483"/>
        <source>Scribus &amp;Manual...</source>
        <translation>&amp;Manual do Scribus...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1491"/>
        <source>Toggle Palettes</source>
        <translation>Mostrar/Ocultar paletas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1492"/>
        <source>Toggle Guides</source>
        <translation>Mostrar/Ocultar guias</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1501"/>
        <source>Smart &amp;Hyphen</source>
        <translation>&amp;Hifenização inteligente</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1502"/>
        <source>Non Breaking Dash</source>
        <translation>Traço sem quebra</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1503"/>
        <source>Non Breaking &amp;Space</source>
        <translation>E&amp;spaço sem quebra</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1504"/>
        <source>Page &amp;Number</source>
        <translation>Página &amp;número</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1506"/>
        <source>New Line</source>
        <translation>Nova linha</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1507"/>
        <source>Frame Break</source>
        <translation>Quebra de caixa</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1508"/>
        <source>Column Break</source>
        <translation>Quebra de coluna</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1509"/>
        <source>&amp;Zero Width Space</source>
        <translation>Espaço com espessura &amp;zero</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1510"/>
        <source>Zero Width NB Space</source>
        <translation>Espaço sem quebra com espessura zero</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1511"/>
        <source>Copyright</source>
        <translation>Direitos de autor</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1512"/>
        <source>Registered Trademark</source>
        <translation>Marca registrada</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1513"/>
        <source>Trademark</source>
        <translation>Trademark</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1514"/>
        <source>Solidus</source>
        <translation>Barra (Solidus)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1515"/>
        <source>Bullet</source>
        <translation>Marcador</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1516"/>
        <source>Middle Dot</source>
        <translation>Ponto centrado</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1517"/>
        <source>Em Dash</source>
        <translation>Traço Em</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1518"/>
        <source>En Dash</source>
        <translation>Traço En</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1519"/>
        <source>Figure Dash</source>
        <translation>Traço para numerais</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1520"/>
        <source>Quotation Dash</source>
        <translation>Travessão</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apostrophe</source>
        <translation type="obsolete">Apóstrofo</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Straight Double</source>
        <translation type="obsolete">Aspas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left</source>
        <translation type="obsolete">Esquerda simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right</source>
        <translation type="obsolete">Direita simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left</source>
        <translation type="obsolete">Dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right</source>
        <translation type="obsolete">Dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Reversed</source>
        <translation type="obsolete">Revertida simples</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Reversed</source>
        <translation type="obsolete">Revertida dupla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left Guillemet</source>
        <translation type="obsolete">Guillemet simples à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right Guillemet</source>
        <translation type="obsolete">Guillemet simples à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left Guillemet</source>
        <translation type="obsolete">Guillemet dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right Guillemet</source>
        <translation type="obsolete">Guillemet dupla à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Single Comma</source>
        <translation type="obsolete">Vírgula baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Double Comma</source>
        <translation type="obsolete">Vírgula dupla baixa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Left</source>
        <translation type="obsolete">CJK simples à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Right</source>
        <translation type="obsolete">CJK simples à direita</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Left</source>
        <translation type="obsolete">CJK dupla à esquerda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Right</source>
        <translation type="obsolete">CJK dupla à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1541"/>
        <source>En Space</source>
        <translation>Espaço en</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1542"/>
        <source>Em Space</source>
        <translation>Espaço em</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1543"/>
        <source>Thin Space</source>
        <translation>Espaço fino</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1544"/>
        <source>Thick Space</source>
        <translation>Espaço largo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1545"/>
        <source>Mid Space</source>
        <translation>Espaço médio</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1546"/>
        <source>Hair Space</source>
        <translation>Espaço mínimo</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1461"/>
        <source>Insert Smart Hyphen</source>
        <translation type="obsolete">Inserir Hifenização inteligente</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1462"/>
        <source>Insert Non Breaking Dash</source>
        <translation type="obsolete">Inserir traço sem quebra</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1463"/>
        <source>Insert Non Breaking Space</source>
        <translation type="obsolete">Inserir espaço sem quebra</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1464"/>
        <source>Insert Page Number</source>
        <translation type="obsolete">Inserir número de página</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1558"/>
        <source>ff</source>
        <translation>ff</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1559"/>
        <source>fi</source>
        <translation>fi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1560"/>
        <source>fl</source>
        <translation>fl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1561"/>
        <source>ffi</source>
        <translation>ffi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1562"/>
        <source>ffl</source>
        <translation>ffl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1563"/>
        <source>ft</source>
        <translation>ft</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1564"/>
        <source>st</source>
        <translation>st</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1522"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished">Apóstrofo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1523"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished">Aspas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1524"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished">Esquerda simples</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1525"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished">Direita simples</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1526"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished">Dupla à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1527"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished">Dupla à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished">Revertida simples</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1529"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished">Revertida dupla</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1530"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished">Guillemet simples à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1531"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished">Guillemet simples à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1532"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished">Guillemet dupla à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished">Guillemet dupla à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1534"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished">Vírgula baixa</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1535"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished">Vírgula dupla baixa</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1536"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished">CJK simples à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1537"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished">CJK simples à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1538"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished">CJK dupla à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1539"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished">CJK dupla à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;400%</source>
        <translation type="unfinished">&amp;200% {400%?}</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1448"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1449"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1451"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1484"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1485"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1486"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1487"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1468"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1493"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1264"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1286"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1290"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1292"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1415"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished">Réguas relativas à página</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1450"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1488"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1505"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1357"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>File</source>
        <translation type="unfinished">Ficheiro</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Ficheiro</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>Edit</source>
        <translation type="unfinished">Editar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>&amp;Edit</source>
        <translation type="unfinished">&amp;Editar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>Style</source>
        <translation type="unfinished">Estilo</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Item</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished">&amp;Inserir</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>Page</source>
        <translation type="unfinished">Página</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Página</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>&amp;View</source>
        <translation type="unfinished">&amp;Visualizar</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">E&amp;xtras</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Janelas</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>&amp;Help</source>
        <translation type="unfinished">&amp;Ajuda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1871"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1873"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1875"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1482"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Alinhar</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished">Guias &amp;selecionadas:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished">&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished">Distribuir</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished">&amp;Distância:</translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Align and Distribute</source>
        <translation type="obsolete">Alinhar e distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align</source>
        <translation type="obsolete">Alinhar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Selected Guide:</source>
        <translation type="obsolete">Guias &amp;selecionadas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relative To:</source>
        <translation type="obsolete">&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute</source>
        <translation type="obsolete">Distribuir</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Distance:</source>
        <translation type="obsolete">&amp;Distância:</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation>Alinhar e distribuir</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation>Alinhar</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation>Distribuir</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation>&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation>Primeira seleção</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation>Última seleção</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation>Página</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation>Margens</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation>Guias</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation>Seleção</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation>Alinhar os lados direitos dos objectos ao lado esquerdo da âncora</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation>Alinhar os lados esquerdos dos objectos ao lado direito da âncora</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation>Alinhar fundos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation>Alinhar lados direitos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation>Alinhar os topos dos objectos ao fundo da âncora</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation>Centrar no eixo vertical</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation>Alinhar lados esquerdos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation>Centrar no eixo horizontal</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation>Alinhar os fundos dos objectos ao topo da âncora</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation>Alinhar topos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation>Guias &amp;selecionadas:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation>Uniformizar os espaços horizontais entre os objectos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation>Tornar os espaços horizontais entre os objectos iguais ao valor especificado</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation>Distribuir os lados direitos uniformemente</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation>Distribuir os fundos uniformemente</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation>Distribuir os centros uniformemente na horizontal</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation>Uniformizar os espaços verticais entre os objectos</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation>Tornar os espaços verticais entre os objectos iguais ao valor especificado</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation>Distribuir os lados esquerdos uniformemente</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation>Distribuir os centros uniformemente na vertical</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation>Distribuir os topos  uniformemente</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation>Uniformizar os espaços horizontais entre os objectos e os lados da página</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation>Uniformizar os espaços verticais entre os objectos e o topo e fundo da página</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation>Uniformizar os espaços horizontais entre os objectos e os lados das margens da página</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation>Uniformizar os espaços verticais entre os objectos e o topo e fundo das margens da página</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation>&amp;Distância:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation>Distribuir os ítens com a distância especificada</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation>Nenhum selecionado</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="443"/>
        <source>Y: %1%2</source>
        <translation>Y: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="451"/>
        <source>X: %1%2</source>
        <translation>X: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Alinhar o texto à esquerda</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Alinhar o texto à direita</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Alinhar o texto ao centro</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Justificar o texto</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Justificação Forçada do texto</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Propriedades do campo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Tipo:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Botão</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Campo de texto</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Caixa de verificação</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Caixa de seleção</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Caixa de listagem</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Propriedades</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Nome:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation>Dica:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Fonte a ser usada com o PDF 1.3:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Borda</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Cor:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Largura:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Estreito</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Largo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Estilo:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Sólido</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>Tracejado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Sublinhado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Chanfrada</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Recuada</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Outro</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Somente leitura</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Requerido</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation>Não exportar valores</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Visibilidade:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Visível</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Oculto</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>Sem impressão</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>Invisível</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Aparência</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Texto para botão premido</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Texto ao passar o ponteiro do rato (roll over)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Ícones</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Usar ícones</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Remover</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Premido</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Sobre</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Posicionamento do ícone...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Destaque</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation>Nenhum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Inverter</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Contornado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Apertar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Multi-linha</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Senha</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Limite de</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>Caracteres</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>Não rolar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>Não verificar ortografia</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Estilo da marca:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>X</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Cruz</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Losango</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Círculo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Estrela</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Quadrado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>O padrão é selecionado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Editável</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Opções</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>None</source>
        <comment>action</comment>
        <translation>Nenhum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2088"/>
        <source>JavaScript</source>
        <translation>JavaScript</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>Go To</source>
        <translation>Ir para</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Submit Form</source>
        <translation>Enviar formulário</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Reset Form</source>
        <translation>Limpa o formulário</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Import Data</source>
        <translation>Importar dados</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Evento:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Up</source>
        <translation>Mouse up</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Down</source>
        <translation>Mouse down</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Enter</source>
        <translation>Mouse enter</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>Mouse Exit</source>
        <translation>Mouse exit</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Focus</source>
        <translation>On focus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Blur</source>
        <translation>On blur</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Script:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1095"/>
        <source>Edit...</source>
        <translation>Editar...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Enviar para a URL:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="678"/>
        <source>Submit Data as HTML</source>
        <translation>Enviar os dados como HTML</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="691"/>
        <source>Import Data from:</source>
        <translation>Importar dados de:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Destino</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>Para o ficheiro:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Alterar...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Página:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>Pos.X:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Pos.Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="700"/>
        <source>Action</source>
        <translation>Ação</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="731"/>
        <source>Field is formatted as:</source>
        <translation>O campo está formatado como:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Plain</source>
        <translation>Texto simples</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Number</source>
        <translation>Número</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Percentage</source>
        <translation>Percentagem</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Date</source>
        <translation>Data</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Time</source>
        <translation>Hora</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Custom</source>
        <translation>Personalizado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="752"/>
        <source>Number Format</source>
        <translation>Formato do número</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="820"/>
        <source>Decimals:</source>
        <translation>Decimais:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="775"/>
        <source>Use Currency Symbol</source>
        <translation>Usar símbolo de moeda</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="784"/>
        <source>Prepend Currency Symbol</source>
        <translation>Adicionar à frente do símbolo da moeda</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="831"/>
        <source>Formatting</source>
        <translation>Formatação</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="811"/>
        <source>Percent Format</source>
        <translation>Formato da Percentagem</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="854"/>
        <source>Date Format</source>
        <translation>Formato da data</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="880"/>
        <source>Time Format</source>
        <translation>Formato da hora</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="902"/>
        <source>Custom Scripts</source>
        <translation>Scripts personalizados</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="914"/>
        <source>Format:</source>
        <translation>Formato:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="940"/>
        <source>Keystroke:</source>
        <translation>Teclas pressionadas:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="964"/>
        <source>Format</source>
        <translation>Formato</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="980"/>
        <source>Value is not validated</source>
        <translation>O valor não está validado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="989"/>
        <source>Value must be greater than or equal to:</source>
        <translation>O valor deve ser maior ou igual a:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="993"/>
        <source>and less or equal to:</source>
        <translation>e menor ou igual a:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1004"/>
        <source>Custom validate script:</source>
        <translation>Script de validação personalizado:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1025"/>
        <source>Validate</source>
        <translation>Validar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1042"/>
        <source>Value is not calculated</source>
        <translation>O valor não está calculado</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1051"/>
        <source>Value is the</source>
        <translation>O valor é</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>sum</source>
        <translation>a soma</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>product</source>
        <translation>o produto</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>average</source>
        <translation>a média</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>minimum</source>
        <translation>o mínimo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1057"/>
        <source>maximum</source>
        <translation>o máximo</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1064"/>
        <source>of the following fields:</source>
        <translation>dos seguintes campos:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1074"/>
        <source>Pick...</source>
        <translation>Seleccionar...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1079"/>
        <source>Custom calculation script:</source>
        <translation>Script de cálculo personalizado:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1099"/>
        <source>Calculate</source>
        <translation>Calcular</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1118"/>
        <source>OK</source>
        <translation>Ok</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1122"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1174"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>O marcador (flag) é ignorado no PDF 1.3</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1175"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Insira aqui uma lista de campos separados por vírgulas</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1176"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>É necessário pelo menos o ícone para Normal para usar ícones para botões</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1342"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation>Imagens (*.tif *.png *.jpg *.xpm);;PostScript (*.eps*.epsi);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1453"/>
        <source>Example:</source>
        <translation>Exemplo:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2079"/>
        <source>Selection Change</source>
        <translation>Alteração da seleção</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2087"/>
        <source>None</source>
        <translation>Nenhum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>Ficheiros PDF (*.pdf);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1287"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Propriedades da anotação</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Ligação</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Ligação externa</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Ligação externa Web</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Destino</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>Alt&amp;erar...</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Página:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>Pos.&amp;X</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>Posição &amp;Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../annota.cpp" line="351"/>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">Documentos PDF (*.pdf);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation>Aplicar página modelo</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation>Página &amp;Modelo:</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply To</source>
        <translation>Aplicar a</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;page</source>
        <translation>&amp;Página actual</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even pages</source>
        <translation>Páginas par&amp;es</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd pages</source>
        <translation>Páginas í&amp;mpares</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All pages</source>
        <translation>&amp;Todas as páginas</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within range</source>
        <translation>&amp;No intervalo</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation>Alt+W</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation>Aplica a página modelo seleccionada nas páginas pares, ímpares ou em todas as páginas dentro do intervalo especificado</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation>para</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished">Hifenização possível</translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <location filename="../arrowchooser.cpp" line="33"/>
        <source>None</source>
        <translation type="obsolete">Nenhum</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="69"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="351"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Sair</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished">&amp;Ignorar</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Fechar</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="79"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="86"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="337"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="338"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="218"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="405"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="57"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="407"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished">Setas</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished">Especiais</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode Generator...</source>
        <translation type="obsolete">Gerador de Código de &amp;Barras...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure Postscript Barcode Writer</source>
        <translation type="obsolete">Interface do Scribus para o criador de códigos de barras totalmente em Postscript Barcode Writer</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation>12 ou 13 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation>8 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation>11 ou 12 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation>7 ou 8 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation>5 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation>2 dígitos</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation>12 ou 13 dígitos com traços. O formato antigo ISBN-10 aceita 9 ou 10 digitos com traços, mas este standard foi retirado de uso publico após 1 de Janeiro de 2007. (Nota: Para converter um velho ISBN-10 para o novo ISBN-13, prefixe 978- aos primeiros 9 dígitos, por ex. 1-56592-479-7 -&gt; 978-1-56592-479. O dígito final de verificação será calculado automáticamente.)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation>Número variável de caracteres, dígitos e qualquer outro símbolo -. *$/+%.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation>Número variável de caracteres ASCII e símbolos de funções especiais, começando com o caracter de início apropriado para o conjunto de caracteres inicial. UCC/EAN-128s devem possuir obrigatóriamente um símbolo FNC 1 logo após ao caracter inicial.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation>Número de dígitos variáveis e qualquer um dos símbolos -$:/.+ABCD.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation>Número de dígitos variáveis</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation>Número de dígitos variáveis. Um ITF-14 possui 14 caracteres e não tem dígito de verificação</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation>Número de dígitos variáveis e letras maiúsculas</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation>Número variável de caracteres hexadecimais</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation>Erro ao abrir o ficheiro %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation>Código de barras incompleto</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Barcode Creator</source>
        <translation type="obsolete">Gerador de código de barra</translation>
    </message>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="193"/>
        <source>Barcode</source>
        <translation type="obsolete">Código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="152"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="132"/>
        <source>Co&amp;de:</source>
        <translation>Có&amp;digo:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="145"/>
        <source>Select one of the available barcode type here</source>
        <translation>Selecione aqui um dos tipos de código de barras disponíveis</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="125"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation>A representação númerica do código por sí só. Veja a mensagem de ajuda abaixo</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="115"/>
        <source>Reset the barcode samples</source>
        <translation>Reconfigurar amostras de código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="90"/>
        <source>&amp;Include text in barcode</source>
        <translation>&amp;Incluir texto no código de barra</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="93"/>
        <source>Alt+I</source>
        <translation>Alt+I</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="87"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation>Se marcado, também haverá números no código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="77"/>
        <source>&amp;Guard whitespace</source>
        <translation>&amp;Manter espaço livre</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="80"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="74"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation>Desenha setas para reafirmar o espaço próximo ao código</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="64"/>
        <source>I&amp;nclude checksum</source>
        <translation>I&amp;ncluir checksum</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="67"/>
        <source>Alt+N</source>
        <translation>Alt+N</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="61"/>
        <source>Generate and include a checksum in barcode</source>
        <translation>Gera e inclui um código de verificaçãao da soma (checksum) no código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="51"/>
        <source>Incl&amp;ude checksum digit</source>
        <translation>Incl&amp;uir dígito de checksum</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="54"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="48"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation>Inclui o dígito de verificação da soma no texto do código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="168"/>
        <source>Colors</source>
        <translation>Cores</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="208"/>
        <source>&amp;Background</source>
        <translation>&amp;Fundo</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="211"/>
        <source>Alt+B</source>
        <translation>Alt+B</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="205"/>
        <source>Background color - under the code lines</source>
        <translation>Cor do fundo - abaixo das linhas de código</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="240"/>
        <source>&amp;Lines</source>
        <translation>&amp;Linhas</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="243"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="237"/>
        <source>Color of the lines in barcode</source>
        <translation>Cor das linhas no código de barras</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="272"/>
        <source>&amp;Text</source>
        <translation>&amp;Texto</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="275"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="269"/>
        <source>Color of the text and numbers</source>
        <translation>A Cor do texto e dos números</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="304"/>
        <source>Hints and help is shown here</source>
        <translation>As Dicas e a ajuda é mostrada aqui</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="314"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation>Pré-visualização do resultado da amostra em 72dpi.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Formato</translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation>Principal</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation>Itens copiados</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation>Selecione um directório do Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="../scrapbookpalette.cpp" line="747"/>
        <source>Scrapbook (*.scs)</source>
        <translation type="obsolete">Bloco de Rascunhos (*.scs)</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation>Seleccione um ficheiro de Bloco de Rascunhos a importar</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation>Seleccione um directório</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation>Renomear</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation>Apagar</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation>Copiar para:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation>Mover para:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nome:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation>Nova entrada</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation>O nome &quot;%1&quot; já existe.
Por favor, escolha outro.</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation>Objeto</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation>Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation>Criar uma nova página de Bloco de Rascunhos</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation>Carregar um Bloco de Rascunhos existente</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation>Salvar o Bloco de Rascunhos seleccionado</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation>Importar ficheiro de Bloco de Rascunhos do Scribus &lt;=1.3.2</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation>Fechar o Bloco de Rascunhos seleccionado</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Fechar</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <location filename="../bookmwin.cpp" line="219"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Move o marcador</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="220"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Inserir um marcador</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="221"/>
        <source>Cancel</source>
        <translation type="obsolete">Cancelar</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="554"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Marcadores</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Marcadores</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Posicionamento do ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Layout:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Somente legenda</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Somente ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Legenda abaixo do ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Legenda acima do ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Legenda á direita do ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Legenda á esquerda do ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Legenda sobreposta ao ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Escala:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Sempre</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>Quando o ícone for muito pequeno</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>Quando o ícone for muito grande</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Nunca</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Redimensionar como:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Proporcional</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>Desproporcional</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Ícone</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>Ok</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Reconfigurar</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="31"/>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">&amp;Activar a gestão de cores</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="34"/>
        <source>System Profiles</source>
        <translation type="obsolete">Perfis do sistema</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="43"/>
        <source>&amp;RGB Pictures:</source>
        <translation type="obsolete">Imagens &amp;RGB:</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="51"/>
        <source>&amp;CMYK Pictures:</source>
        <translation type="obsolete">Imagens &amp;CMYK:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="59"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="obsolete">Cores &amp;sólidas RGB:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="67"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="obsolete">Cores &amp;sólidas CMYK:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="75"/>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="83"/>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">Imp&amp;ressora:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="89"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Renderização pretendida</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="98"/>
        <source>Pictures:</source>
        <translation type="obsolete">Imagens:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="106"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="obsolete">Cores sól&amp;idas:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="113"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Sim&amp;ular o resultado da impressão no no ecrã</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="121"/>
        <source>Convert all colors to printer space</source>
        <translation type="obsolete">Converte todas as cores para o espaço de cor da impressora</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="130"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Marcar cores fora de &amp;gamut</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="134"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Usar Compensação de &amp;Ponto Negro</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="139"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Perfil de cor padrão para imagens CMYK importadas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="140"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Perfil de cor padrão para imagens RGB importadas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="141"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="obsolete">Perfil de cor padrão para cores sólidas RGB na página</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="142"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="obsolete">Perfil de cor padrão para cores sólidas CMYK na página</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="143"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">O perfil de cores que gerou ou recebeu do fabricante.
Este perfil deve ser específico para o seu monitor e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="144"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">O perfil de cores do fabricante para o seu modelo de impressora.
Este perfil deve ser específico para a sua impressora e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="145"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Renderização pretendida para o seu monitor. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="146"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Renderização pretendida para a sua impressora. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="147"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Activar uma &apos;previsão calculada&apos; de como serão impressas
as cores do seu documento, baseada no perfil de impressora selecionado.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="148"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="obsolete">Simular um meio de cor inteiramente gerido:
Todas as cores, rgb ou cmyk, são convertidas para o espaço de cor da impressora.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="149"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Método de mostrar, no no ecrã, as cores que podem não ser impressas corretamente.
Isso requer perfis muito precisos e serve apenas como um alerta.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="150"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">A Compensação de Ponto Negro é um método para melhorar o contraste nas fotos.
Recomenda-se que você active esta opção caso tenha fotos em seu documento.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Perceptual</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Relativa Colorimétrica</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Saturação</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluta Colorimétrica</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="98"/>
        <source>Images:</source>
        <translation type="obsolete">Imagens:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">&amp;Activar a gestão de cores</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Perfis do sistema</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished">Perfil de cor padrão para imagens RGB importadas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished">Perfil de cor padrão para imagens CMYK importadas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished">Perfil de cor padrão para cores sólidas RGB na página</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished">Perfil de cor padrão para cores sólidas CMYK na página</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">O perfil de cores que gerou ou recebeu do fabricante.
Este perfil deve ser específico para o seu monitor e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">Imp&amp;ressora:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">O perfil de cores do fabricante para o seu modelo de impressora.
Este perfil deve ser específico para a sua impressora e não genérico (ex. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Renderização pretendida</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Imagens:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Renderização pretendida para a sua impressora. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Renderização pretendida para o seu monitor. A menos que você tenha um motivo
para mudar isso, seleccione Relativa Colorimétrica ou Perceptiva.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Activar uma &apos;previsão calculada&apos; de como serão impressas
as cores do seu documento, baseada no perfil de impressora selecionado.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Sim&amp;ular o resultado da impressão no no ecrã</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished">Converte todas as cores para o espaço de cor da impressora</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Método de mostrar, no no ecrã, as cores que podem não ser impressas corretamente.
Isso requer perfis muito precisos e serve apenas como um alerta.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation>Editar cor</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nome:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation>&amp;Modelo de cor</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation>RGB seguro para a Web</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation>É uma cor lisa</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="128"/>
        <source>Is Registration Color</source>
        <translation type="obsolete">É uma cor de registro</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation>Novo</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation>Antigo</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="195"/>
        <source>HSV-Colormap</source>
        <translation type="obsolete">Mapa de cores HSV</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="385"/>
        <source>Choosing this will enable printing this on all plates. Registration colors are used for printer marks such as crop marks, registration marks and the like. These are not typically used in the layout itself.</source>
        <translation type="obsolete">Escolher isto activará a impressão em todas as chapas. As cores de registo são usadas para miras de impressão, tais como miras de corte, miras de registo e similares. Normalmente não são usadas no próprio layout.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation>Escolher isto tornará esta cor uma cor lisa ou de separação, criando assim outra chapa quando se proceder à separação de cores. Isto é usado quando um objecto gráfico necessita uma representação de cor exacta ou que não consegue ser reproduzida com tintas CMYK. Tintas metálicas e fluorecentes ou cores que estão fora do espaço de cor CMYK são os melhores exemplos de utilização.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation>Barras de cor dinâmicas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation>Barras de cor estáticas</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Se a gestão de cor está activada, um indicador triangular de aviso significa que a cor pode estar fora do gamute de cor do perfil de cor da impressora corrente. Isto significa que a cor poderá não ser impressa exactamente como é mostrado no no ecrã. Mais pistas acerca de avisos de gamute podem ser encontradas na ajuda em linha sob Gestão de Cor.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation>Você não pode criar uma cor chamada &quot;%1&quot;.
 Este nome é reservado para a cor transparente</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation>O nome de cor que escolheu já existe,
por favor, escolha outro.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CStyleP</name>
    <message>
        <location filename="../smcstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Formulário1</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="109"/>
        <source>Colors</source>
        <translation type="obsolete">Cores</translation>
    </message>
</context>
<context>
    <name>CStylePBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Formulário1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Pai</translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation>Combinando cores</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation>Erro: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation>A cor %1 já existe!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation>A cor  %1 foi adicionada.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation>Abrindo o gestor de cor.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation>Combinação de cor</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="488"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation>Não foi possível encontrar a cor requisitada. Você provavelmente selecionou a cor preta, cinza ou branca. Não há maneira de processar essa cor.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished">Roda de cores</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="47"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="54"/>
        <source>Result Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="311"/>
        <source>CMYK</source>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="532"/>
        <source>RGB</source>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="718"/>
        <source>HSV</source>
        <translation type="unfinished">HSV</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="108"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="118"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="144"/>
        <source>Angle:</source>
        <translation type="unfinished">Ângulo:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="154"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished">Diferença entre o valor selecionado e o contado. Veja a documentação para maiores detalhes.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="169"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished">Selecione um do métodos para criar um esquema de cor. Veja a documentação para maiores informações.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="203"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="206"/>
        <source>&amp;Merge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="209"/>
        <source>Alt+M</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="216"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished">Substitui as cores criadas nas cores do documento</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="219"/>
        <source>&amp;Replace</source>
        <translation type="unfinished">Substitui&amp;r</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="222"/>
        <source>Alt+R</source>
        <translation type="unfinished">Alt+R</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="229"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished">Não alterar as cores</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="232"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="235"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="244"/>
        <source>Preview:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="268"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="287"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished">Simula defeitos comuns de visão. Selecione o tipo de defeito.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="294"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="331"/>
        <source>C:</source>
        <translation type="unfinished">C:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="431"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="361"/>
        <source>M:</source>
        <translation type="unfinished">M:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="391"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="421"/>
        <source>K:</source>
        <translation type="unfinished">K:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="827"/>
        <source>RGB:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="674"/>
        <source>HSV:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="560"/>
        <source>R:</source>
        <translation type="unfinished">R:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="587"/>
        <source>G:</source>
        <translation type="unfinished">G:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="614"/>
        <source>B:</source>
        <translation type="unfinished">B:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="863"/>
        <source>CMYK:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="746"/>
        <source>H:</source>
        <translation type="unfinished">H:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="773"/>
        <source>S:</source>
        <translation type="unfinished">S:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="800"/>
        <source>V:</source>
        <translation type="unfinished">V:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="907"/>
        <source>Document</source>
        <translation type="unfinished">Documento</translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Roda de cores</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="obsolete">Clique na roda para obter a cor base. O seu modelo de cor depende da aba escolhida.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Scheme Method</source>
        <translation type="obsolete">Método do esquema de Cor</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="obsolete">Selecione um do métodos para criar um esquema de cor. Veja a documentação para maiores informações.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle:</source>
        <translation type="obsolete">Ângulo:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="obsolete">Diferença entre o valor selecionado e o contado. Veja a documentação para maiores detalhes.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview:</source>
        <translation type="obsolete">Pré-visualizar:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vision Defect Type:</source>
        <translation type="obsolete">Tipos de cegueira cromática:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="obsolete">Simula defeitos comuns de visão. Selecione o tipo de defeito.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample color scheme.</source>
        <translation type="obsolete">Esquema de amostra de cor.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB:</source>
        <translation type="obsolete">RGB:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV:</source>
        <translation type="obsolete">HSV:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK:</source>
        <translation type="obsolete">CMYK:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document</source>
        <translation type="obsolete">Documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Result Colors</source>
        <translation type="obsolete">Cores resultantes</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="obsolete">Cores do seu esquema seleccionado.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Merge</source>
        <translation type="obsolete">&amp;Juntar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+M</source>
        <translation type="obsolete">Alt+M</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge created colors into the document colors</source>
        <translation type="obsolete">Juntar as cores criadas às cores do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">Substitui&amp;r</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace created colors in the document colors</source>
        <translation type="obsolete">Substitui as cores criadas nas cores do documento</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Leave colors untouched</source>
        <translation type="obsolete">Não alterar as cores</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2252"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2243"/>
        <source>X: %1</source>
        <translation type="unfinished">X: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2245"/>
        <source>Y: %1</source>
        <translation type="unfinished">Y: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2260"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2262"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1822"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos os formatos suportados</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1852"/>
        <source>Open</source>
        <translation type="unfinished">Abrir</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <location filename="../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation>Paleta de Caracteres</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation>Ficheiros Scribus Char Palette (*.ucp);;Todos os ficheiros (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="88"/>
        <source>Enhanced Palette</source>
        <translation type="obsolete">Paleta melhorada</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="100"/>
        <source>Font:</source>
        <translation type="obsolete">Fonte:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="123"/>
        <source>Character Class:</source>
        <translation type="obsolete">Classe de caracteres:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="203"/>
        <source>&amp;Insert</source>
        <translation type="obsolete">&amp;Inserir</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="213"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">&amp;Limpar</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="19"/>
        <source>Quick Palette</source>
        <translation type="obsolete">Paleta rápida</translation>
    </message>
    <message>
        <location filename="../charselect.ui" line="49"/>
        <source>Hide Enhanced</source>
        <translation type="obsolete">Esconder melhorado</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="200"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Inserir os caracteres no texto a partir do cursor</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="210"/>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Apagar a(s) seleção(ões) atual(is).</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="164"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">Pode ver uma miniatura se você pressionar e segurar o botão direito do rato. A tecla &apos;Insert&apos; insere um caracter na seleção abaixo e &apos;Delete&apos; apaga o último item inserido</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="250"/>
        <source>Full Character Set</source>
        <translation type="obsolete">Conjunto completo de caracteres</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="255"/>
        <source>Basic Latin</source>
        <translation type="obsolete">Latino básico</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="261"/>
        <source>Latin-1 Supplement</source>
        <translation type="obsolete">Latin-1 Suplement</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="267"/>
        <source>Latin Extended-A</source>
        <translation type="obsolete">Latin Extended-A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="273"/>
        <source>Latin Extended-B</source>
        <translation type="obsolete">Latin Extended-B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="279"/>
        <source>General Punctuation</source>
        <translation type="obsolete">Pontuação geral</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="285"/>
        <source>Super- and Subscripts</source>
        <translation type="obsolete">Sobre e subscritos</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="291"/>
        <source>Currency Symbols</source>
        <translation type="obsolete">Símbolos de moedas</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Letterlike Symbols</source>
        <translation type="obsolete">Símbolos semelhantes a letras</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp