/*
 *  $Id: reltransfer.h,v 1.4 2003/06/01 01:42:30 ajung Exp $
 *
 * SCTP implementation according to RFC 2960.
 * Copyright (C) 2000 by Siemens AG, Munich, Germany.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * Acknowledgement
 * This work was partially funded by the Bundesministerium fr Bildung und
 * Forschung (BMBF) of the Federal Republic of Germany (Frderkennzeichen 01AK045).
 * The authors alone are responsible for the contents.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * There are two mailinglists available at http://www.sctp.de which should be
 * used for any discussion related to this implementation.
 *
 * Contact: discussion@sctp.de
 *          Michael.Tuexen@icn.siemens.de
 *          ajung@exp-math.uni-essen.de
 *
 * This module implements the retransmission mechanism, and stores
 * all data that has not been acknowledged by the peer.
 *
 */


#ifndef RELTRANSFER_H
#define RELTRANSFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "globals.h"
#include "distribution.h"


void *rtx_new_reltransfer(Association* asok,
                          unsigned int number_of_destination_addresses,
                          unsigned int iTSN);

void rtx_delete_reltransfer(Association* asok);


int rtx_get_obpa(Association* asok, unsigned int addressKey, unsigned int *totalInFlight);

gboolean rtx_is_in_fast_recovery(Association* asok);

int rtx_enter_fast_recovery(Association* asok);

/**
 * this is called by bundling, when a SACK needs to be processed
 */
int rtx_process_sack(Association* asok, unsigned int addrKey, void *sack_chunk, unsigned int totalLen);

/**
 * TODO : does nothing right now
 * a callback function for initiating retransmission after T3 has elapsed
 */
int rtx_timer_cb(TimerID tid, void *data1, void *data2);

/**
 * a function called by WinFlowCtrl, when chunks have been given to the bundling
 * instance, but need to be kept in the buffer until acknowledged
 * In SDL digram signal is called (RetransChunks)
 *
 * TODO : - add possibility for more than one data_chunk ????
 *
 */
int rtx_save_retrans_chunks(Association* asok, void *data_chunk);

/**
 * a function called by FlowCtrl, when chunk has been given to the bundling
 * instance, but is already contained in the reliable transfer list.
 * some data in that chunks must be updated.
 */
int rtx_update_retrans_chunks(void *data_chunk, unsigned int dest);

/**
 * called from flow-control to trigger retransmission of chunks that have previously
 * been sent to the address that timed out
 */
int rtx_t3_timeout(Association* asok, unsigned int addressKey,
                   unsigned int mtu, chunk_data ** chunks);


void chunk_list_debug(short event_log_level, GList * chunk_list);

/**
 * function to return the last a_rwnd value we got from our peer
 */
unsigned int rtx_read_remote_receiver_window(Association* asok);

/**
 * Function returns the number of chunks that are waiting in the queue to be acked
 */
int rtx_readNumberOfUnackedChunks(Association* asok);

/**
 * function to set the a_rwnd value we got from our peer (from INIT/INIT ACK)
 */
int rtx_set_remote_receiver_window(Association* asok, unsigned int new_arwnd);


/**
 * this function returns what we have got as ctsna from the peer
 */
unsigned int rtx_readLocalTSNacked(Association* asok);


gboolean rtx_is_lowest_tsn(Association* asok, unsigned int atsn);

/**
 * is called, in case we receive a Cookie in the ESTABLISHED state,
 * that indicates the peers restart -> we need to restart too
 */
void* rtx_restart_reliable_transfer(Association* asok, unsigned int numOfPaths, unsigned int iTSN);

/**
 * function that is called by SCTP-Control, when ULP requests
 * shutdown in an established association
 */
int rtx_shutdown(Association* asok);


/**
 * function that is called by SCTP-Control, when peer indicates
 * shutdown and sends us his last ctsna...this function dequeues
 * all chunks, and returns the number of chunks left in the queue
 */
unsigned int rtx_rcv_shutdown_ctsna(Association* asok, unsigned int fromAddressKey, unsigned int ctsna);


int rtx_dequeueOldestUnackedChunk(Association* asok,
                                  unsigned char *buf, unsigned int *len, unsigned int *tsn,
                                  unsigned short *sID, unsigned short *sSN,unsigned int* pID,
                                  unsigned char* flags, gpointer* ctx);




int rtx_addDestinationAddress(Association* asok,
                             unsigned int newKey,
                             int newIndex);

int rtx_delDestinationAddress(Association* asok,
                             unsigned int delKey,
                             int delIndex,
                             unsigned int altKey,
                             int altIndex);

#endif
