/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-1-2-1/engines/mohawk/riven_cursors.h $
 * $Id: riven_cursors.h 52661 2010-09-09 17:27:02Z mthreepwood $
 *
 */

namespace Mohawk {

//////////////////////////////////////////////
// Cursors and Cursor Palettes
//////////////////////////////////////////////

////////////////////////////////////////
// Zip Mode Cursor (16x16):
//    Shown when a zip mode spot is active
//
//    0 = Transparent
//    1 = Black		(0x000000)
//    2 = Yellow	(0xDCFF00)
////////////////////////////////////////
static const byte s_zipModeCursor[] = {
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 2, 1, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 2, 1, 1, 2, 2, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 2, 2, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 1, 2, 2, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 2, 2, 1, 1, 2, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 1, 2, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 1, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
};


////////////////////////////////////////
// Zip Mode Cursor Palette:
//    Palette For The Zip Mode Cursor
////////////////////////////////////////
static const byte s_zipModeCursorPalette[] = {
	0x00, 0x00, 0x00,	0x00,		// Black
	0xDC, 0xFF, 0x00,	0x00,		// Yellow
};


////////////////////////////////////////
// Hand Over Object Cursor (16x16):
//    Shown when over a hotspot that's interactive
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_objectHandCursor[] = {
	0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0,
	0, 0, 1, 2, 3, 1, 1, 2, 3, 1, 2, 3, 1, 0, 0, 0,
	0, 0, 1, 2, 3, 1, 1, 4, 3, 1, 2, 3, 1, 0, 1, 0,
	0, 0, 0, 1, 2, 3, 1, 2, 3, 1, 4, 3, 1, 1, 2, 1,
	0, 0, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1,
	0, 1, 1, 0, 1, 2, 2, 2, 2, 2, 2, 3, 1, 2, 3, 1,
	1, 2, 2, 1, 1, 2, 2, 2, 4, 2, 4, 2, 2, 4, 2, 1,
	1, 3, 4, 2, 1, 2, 4, 2, 2, 2, 2, 2, 4, 4, 1, 0,
	0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1, 0,
	0, 0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 3, 1, 0,
	0, 0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1, 0, 0,
	0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 0, 0,
	0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 4, 3, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 4, 3, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 4, 3, 1, 0, 0, 0
};


////////////////////////////////////////
// Grabbing Hand Cursor (13x13):
//    Shown when interacting with an object
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_grabbingHandCursor[] = {
	0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 2, 3, 1, 1, 1, 0, 0, 0,
	0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 1, 0,
	0, 1, 2, 2, 2, 2, 2, 2, 2, 3, 1, 2, 1,
	0, 1, 1, 2, 2, 2, 4, 2, 4, 2, 2, 4, 1,
	1, 2, 1, 2, 4, 2, 2, 2, 2, 2, 4, 4, 1,
	1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1,
	1, 3, 2, 2, 2, 2, 2, 2, 2, 4, 4, 3, 1,
	1, 3, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1, 0,
	0, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 0,
	0, 0, 1, 2, 2, 2, 2, 2, 4, 3, 1, 0, 0,
	0, 0, 0, 1, 2, 2, 2, 2, 4, 3, 1, 0, 0,
	0, 0, 0, 1, 2, 2, 2, 2, 4, 3, 1, 0, 0
};


////////////////////////////////////////
// Standard Hand Cursor (15x16):
//    Standard Cursor
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_standardHandCursor[] = {
	0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 4, 4, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 3, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 0, 0, 1, 2, 4, 1, 1, 1, 1, 1, 0, 0,
	1, 4, 2, 1, 0, 1, 2, 4, 1, 4, 1, 4, 1, 1, 1,
	0, 1, 3, 2, 1, 1, 2, 4, 1, 4, 1, 4, 1, 4, 1,
	0, 0, 1, 4, 2, 1, 2, 2, 4, 2, 4, 2, 1, 4, 1,
	0, 0, 1, 4, 2, 1, 2, 2, 2, 2, 2, 2, 2, 3, 1,
	0, 0, 0, 1, 4, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1,
	0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 4, 3, 1,
	0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 3, 1, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 4, 3, 1, 0,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 4, 3, 1, 0
};


////////////////////////////////////////
// Pointing Left Cursor (15x13):
//    Cursor When Over A Hotspot That Allows You To Move Left
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingLeftCursor[] = {
	0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 3, 2, 2, 2, 1, 1, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 4, 3, 1, 1,
	1, 4, 2, 2, 2, 2, 1, 2, 3, 2, 2, 2, 4, 4, 4,
	1, 4, 4, 4, 4, 4, 1, 2, 1, 3, 4, 2, 2, 2, 2,
	0, 1, 1, 1, 1, 1, 1, 2, 1, 3, 3, 4, 2, 2, 2,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 4, 4, 2,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 4, 1, 3, 4, 2, 2,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 4, 2, 2,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 1, 4, 2, 4,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1,
	0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 1, 1, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0
};


////////////////////////////////////////
// Pointing Right Cursor (15x13):
//    Cursor When Over A Hotspot That Allows You To Move Right
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingRightCursor[] = {
	0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 2, 2, 2, 3, 1, 0, 0, 0, 0, 0, 0,
	1, 1, 3, 4, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0,
	4, 4, 4, 2, 2, 2, 3, 2, 1, 4, 4, 4, 4, 4, 1,
	2, 2, 2, 2, 4, 3, 1, 2, 1, 2, 2, 2, 2, 4, 1,
	2, 2, 2, 4, 3, 3, 1, 2, 1, 1, 1, 1, 1, 1, 0,
	2, 4, 4, 3, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	2, 2, 4, 3, 1, 4, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	2, 2, 4, 3, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	4, 2, 4, 1, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
};


////////////////////////////////////////
// Pointing Down Cursor (Palm Up)(13x16):
//    Cursor When Over A Hotspot That Allows You To Move Down
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingDownCursorPalmUp[] = {
	0, 0, 1, 4, 2, 2, 2, 2, 2, 4, 1, 0, 0,
	0, 0, 1, 4, 2, 2, 4, 2, 2, 2, 4, 1, 0,
	0, 1, 3, 4, 2, 2, 4, 4, 4, 4, 4, 1, 0,
	0, 1, 4, 2, 2, 4, 3, 3, 3, 1, 1, 1, 1,
	1, 2, 2, 2, 4, 3, 3, 1, 1, 2, 1, 2, 1,
	1, 2, 2, 2, 3, 3, 3, 4, 1, 2, 1, 2, 1,
	1, 2, 2, 3, 1, 1, 1, 2, 1, 2, 1, 2, 1,
	1, 3, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1,
	0, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1,
	0, 0, 1, 2, 4, 1, 1, 1, 1, 1, 1, 0, 0,
	0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0
};


////////////////////////////////////////
// Pointing Up Cursor (Palm Up)(13x16):
//    Cursor When Over A Hotspot That Allows You To Move Up
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingUpCursorPalmUp[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 4, 4, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 1, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1, 2, 4, 1, 0, 0,
	1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 0,
	1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 3, 1,
	1, 2, 1, 2, 1, 2, 1, 1, 1, 3, 2, 2, 1,
	1, 2, 1, 2, 1, 4, 3, 3, 3, 2, 2, 2, 1,
	1, 2, 1, 2, 1, 1, 3, 3, 4, 2, 2, 2, 1,
	1, 1, 1, 1, 3, 3, 3, 4, 2, 2, 4, 1, 0,
	0, 1, 4, 4, 4, 4, 4, 2, 2, 4, 3, 1, 0,
	0, 1, 4, 2, 2, 2, 4, 2, 2, 4, 1, 0, 0,
	0, 0, 1, 4, 2, 2, 2, 2, 2, 4, 1, 0, 0
};


////////////////////////////////////////
// Pointing Left Cursor (Bent)(15x13):
//    Cursor When Over A Hotspot That Allows You To Turn Left 180 Degrees
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingLeftCursorBent[] = {
	0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 3, 2, 2, 2, 1, 1, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 4, 3, 1, 1,
	1, 3, 2, 4, 4, 2, 1, 2, 3, 3, 2, 2, 4, 4, 4,
	1, 2, 4, 3, 3, 4, 1, 2, 1, 3, 4, 2, 2, 2, 2,
	1, 4, 4, 1, 1, 1, 1, 2, 1, 1, 3, 4, 2, 2, 2,
	1, 1, 1, 0, 0, 1, 1, 1, 1, 3, 3, 3, 4, 4, 2,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 4, 1, 3, 4, 3, 2,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 4, 2, 2,
	0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 1, 4, 2, 4,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1,
	0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 1, 1, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0
};


////////////////////////////////////////
// Pointing Right Cursor (Bent)(15x13):
//    Cursor When Over A Hotspot That Allows You To Turn Right 180 Degrees
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingRightCursorBent[] = {
	0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 2, 2, 2, 3, 1, 0, 0, 0, 0, 0, 0,
	1, 1, 3, 4, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0,
	4, 4, 4, 2, 2, 3, 3, 2, 1, 2, 4, 4, 2, 3, 1,
	2, 2, 2, 2, 4, 3, 1, 2, 1, 4, 3, 3, 4, 2, 1,
	2, 2, 2, 4, 3, 1, 1, 2, 1, 1, 1, 1, 4, 4, 1,
	2, 4, 4, 3, 3, 3, 1, 1, 1, 1, 0, 0, 1, 1, 1,
	2, 3, 4, 3, 1, 4, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	2, 2, 4, 3, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	4, 2, 4, 1, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
};


////////////////////////////////////////
// Pointing Down Cursor (Palm Down)(15x16):
//    Similar to Standard Cursor
//
//    0 = Transparent
//    1 = Black 		(0x000000)
//    2 = Light Peach 	(0xEDCD96)
//    3 = Brown			(0x8A672F)
//    4 = Dark Peach	(0xE89A62)
////////////////////////////////////////
static const byte s_pointingDownCursorPalmDown[] = {
	0, 1, 3, 4, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	0, 1, 3, 4, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0,
	0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0,
	1, 3, 4, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0,
	1, 3, 4, 2, 2, 2, 2, 2, 2, 2, 4, 1, 0, 0, 0,
	1, 3, 2, 3, 2, 2, 2, 2, 2, 1, 2, 4, 1, 0, 0,
	1, 4, 1, 2, 2, 3, 2, 3, 2, 1, 2, 4, 1, 0, 0,
	1, 4, 1, 4, 1, 4, 1, 4, 4, 1, 1, 2, 3, 1, 0,
	0, 1, 1, 4, 1, 4, 1, 4, 2, 1, 0, 1, 2, 4, 1,
	0, 0, 1, 1, 1, 1, 1, 4, 2, 1, 0, 0, 1, 1, 0,
	0, 0, 0, 0, 0, 0, 1, 4, 4, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 4, 2, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 4, 2, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 3, 2, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 4, 4, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0
};

////////////////////////////////////////
// Hand Cursor Palette:
//    Palette For All Hand Cursors
////////////////////////////////////////
static const byte s_handCursorPalette[] = {
	0x00, 0x00, 0x00,	0x00,		// Black
	0xED, 0xCD, 0x96,	0x00,		// Light Peach
	0x8A, 0x67, 0x2F,	0x00,		// Brown
	0xE8, 0x9A, 0x62,	0x00		// Dark Peach
};


////////////////////////////////////////
// Pellet Cursor (8x8):
//    Cursor When Using The Pellet In The Frog Trap
//
//    0 = Transparent
//    1 = Light Olive Green 	(0x5D6730)
//    2 = Maroon				(0x5E3333)
//    3 = Light Gray			(0x555555)
//    4 = Medium Gray			(0x444444)
//    5 = Dark Gray				(0x333333)
//    6 = Dark Green			(0x2D3300)
//    7 = Darkest Gray			(0x222222)
////////////////////////////////////////
static const byte s_pelletCursor[] = {
	0, 0, 1, 1, 2, 3, 0, 0,
	0, 2, 1, 4, 1, 2, 5, 0,
	4, 1, 4, 1, 2, 1, 5, 4,
	4, 2, 1, 2, 1, 1, 2, 6,
	6, 4, 2, 1, 4, 4, 1, 5,
	5, 6, 5, 2, 1, 2, 4, 4,
	0, 7, 5, 5, 4, 2, 5, 0,
	0, 0, 5, 6, 6, 5, 0, 0
};

////////////////////////////////////////
// Pellet Cursor Palette:
//    Palette For The Pellet Cursor
////////////////////////////////////////
static const byte s_pelletCursorPalette[] = {
	0x5D, 0x67, 0x30,	0x00,
	0x5E, 0x33, 0x33,	0x00,
	0x55, 0x55, 0x55,	0x00,
	0x44, 0x44, 0x44,	0x00,
	0x33, 0x33, 0x33,	0x00,
	0x2D, 0x33, 0x00,	0x00,
	0x22, 0x22, 0x22,	0x00
};

////////////////////////////////////////
// Red Marble Cursor (12x12):
//    Cursor When Holding The Red Marble
////////////////////////////////////////
static const byte s_redMarbleCursor[] = {
	0, 0, 0, 0, 1, 2, 2, 2, 0, 0, 0, 0,
	0, 0, 3, 4, 2, 5, 2, 2, 2, 2, 0, 0,
	0, 6, 1, 1, 2, 2, 5, 2, 2, 2, 2, 0,
	0, 6, 3, 4, 5, 2, 2, 7, 8, 5, 2, 0,
	9, 6, 10,11,2, 2, 2, 12,13,2, 2, 2,
	14,10,6, 4, 1, 2, 8, 2, 2, 5, 2, 2,
	15,16,6, 3, 1, 2, 2, 2, 2, 2, 2, 5,
	17,9,18, 3, 4, 4, 4, 5, 2, 5, 1, 2,
	0, 16,9, 6, 6, 19,1, 20,1, 4, 11,0,
	0, 17,15,18,9, 10,6, 10,3, 21,4, 0,
	0, 0, 18,15,9, 18,6, 22,10,23,0, 0,
	0, 0, 0, 0, 15,15,16,9, 0, 0, 0, 0
};


////////////////////////////////////////
// Red Marble Cursor Palette:
//    Palette For The Red Marble Cursor
////////////////////////////////////////
static const byte s_redMarbleCursorPalette[] = {
	0xb8, 0x33, 0x32,	0x00,
	0xe5, 0x33, 0x31,	0x00,
	0x98, 0x06, 0x00,	0x00,
	0xb8, 0x00, 0x34,	0x00,
	0xe6, 0x00, 0x34,	0x00,
	0x7a, 0x04, 0x00,	0x00,
	0xe8, 0x9a, 0x62,	0x00,
	0xea, 0x31, 0x67,	0x00,
	0x6a, 0x03, 0x00,	0x00,
	0x8c, 0x00, 0x35,	0x00,
	0xb6, 0x36, 0x00,	0x00,
	0xed, 0xcd, 0x96,	0x00,
	0xe9, 0x66, 0x65,	0x00,
	0x5b, 0x35, 0x00,	0x00,
	0x5b, 0x02, 0x00,	0x00,
	0x5f, 0x00, 0x35,	0x00,
	0x4c, 0x01, 0x00,	0x00,
	0x5e, 0x33, 0x33,	0x00,
	0x89, 0x05, 0x00,	0x00,
	0xb6, 0x08, 0x00,	0x00,
	0xa7, 0x07, 0x00,	0x00,
	0x88, 0x36, 0x00,	0x00,
	0x8b, 0x33, 0x33,	0x00
};

////////////////////////////////////////
// Orange Marble Cursor (12x12):
//    Cursor When Holding The Orange Marble
////////////////////////////////////////
static const byte s_orangeMarbleCursor[] = {
	0, 0, 0, 0, 1, 2, 2, 3, 0, 0, 0, 0,
	0, 0, 4, 5, 2, 2, 3, 3, 3, 3, 0, 0,
	0, 6, 7, 4, 2, 1, 2, 2, 3, 3, 3, 0,
	0, 6, 6, 7, 1, 2, 3, 8, 9, 2, 10,0,
	11,12,7, 4, 2, 3, 3, 13,9, 2, 2, 1,
	14,15,6, 4, 2, 16,3, 3, 2, 1, 1, 1,
	14,14,12,17,4, 2, 2, 1, 2, 1, 2, 1,
	14,18,12,6, 4, 4, 4, 19,2, 19,20,4,
	0, 14,14,15,6, 15,6, 4, 4, 4, 4, 0,
	0, 14,11,14,14,12,12,12,17,6, 17,0,
	0, 0, 14,14,17,14,17,6, 6, 17,0, 0,
	0, 0, 0, 0, 14,11,14,11,0, 0, 0, 0
};

////////////////////////////////////////
// Orange Marble Cursor Palette:
//    Palette For The Orange Marble Cursor
////////////////////////////////////////
static const byte s_orangeMarbleCursorPalette[] = {
	0xe1, 0x9e, 0x00,	0x00,
	0xe3, 0x9b, 0x28,	0x00,
	0xe2, 0xcf, 0x20,	0x00,
	0xb5, 0x6a, 0x00,	0x00,
	0xb6, 0x9b, 0x29,	0x00,
	0x87, 0x69, 0x00,	0x00,
	0xb7, 0x67, 0x2f,	0x00,
	0xe9, 0xff, 0x93,	0x00,
	0xe1, 0xff, 0x5a,	0x00,
	0xe0, 0xd0, 0x00,	0x00,
	0x5e, 0x33, 0x33,	0x00,
	0x88, 0x36, 0x00,	0x00,
	0xf3, 0xff, 0xc9,	0x00,
	0x5b, 0x35, 0x00,	0x00,
	0x8b, 0x33, 0x33,	0x00,
	0xe6, 0xce, 0x5f,	0x00,
	0x8a, 0x67, 0x2f,	0x00,
	0x5d, 0x67, 0x30,	0x00,
	0xe2, 0x6a, 0x00,	0x00,
	0xb3, 0x9d, 0x00,	0x00
};

////////////////////////////////////////
// Yellow Marble Cursor (12x12):
//    Cursor When Holding The Yellow Marble
////////////////////////////////////////
static const byte s_yellowMarbleCursor[] = {
	0, 0, 0, 0, 1, 1, 1, 2, 0, 0, 0, 0,
	0, 0, 3, 4, 1, 1, 1, 5, 6, 6, 0, 0,
	0, 3, 3, 7, 1, 1, 1, 1, 2, 1, 6, 0,
	0, 3, 3, 3, 3, 1, 1, 8, 6, 1, 6, 0,
	9, 9, 3, 3, 1, 1, 2, 10,8, 1, 1, 2,
	11,9, 3, 3, 1, 1, 1, 1, 1, 1, 5, 1,
	9, 9, 12,3, 3, 1, 1, 1, 1, 1, 1, 1,
	9, 9, 9, 3, 3, 3, 3, 3, 1, 1, 1, 1,
	0, 11,9, 9, 12,3, 3, 3, 3, 3, 3, 0,
	0, 9, 9, 13,9, 14,12,3, 3, 3, 3, 0,
	0, 0, 9, 9, 9, 12,14,3, 13,3, 0, 0,
	0, 0, 0, 0, 11,9, 11,9, 0, 0, 0, 0
};

////////////////////////////////////////
// Yellow Marble Cursor Palette:
//    Palette For The Yellow Marble Cursor
////////////////////////////////////////
static const byte s_yellowMarbleCursorPalette[] = {
	0xb3, 0xd0, 0x00,	0x00,
	0xb0, 0xff, 0x00,	0x00,
	0x86, 0x9c, 0x00,	0x00,
	0x87, 0xd0, 0x00,	0x00,
	0xe0, 0xd0, 0x00,	0x00,
	0xdc, 0xff, 0x00,	0x00,
	0xb3, 0x9d, 0x00,	0x00,
	0xdc, 0xff, 0x11,	0x00,
	0x5a, 0x68, 0x00,	0x00,
	0xe1, 0xff, 0x5a,	0x00,
	0x5d, 0x67, 0x30,	0x00,
	0x87, 0x69, 0x00,	0x00,
	0x88, 0x9b, 0x2a,	0x00,
	0x5a, 0x9c, 0x00,	0x00
};

////////////////////////////////////////
// Green Marble Cursor (12x12):
//    Cursor When Holding The Green Marble
////////////////////////////////////////
static const byte s_greenMarbleCursor[] = {
	0, 0, 0, 0, 1, 2, 3, 3, 0, 0, 0, 0,
	0, 0, 4, 5, 2, 1, 2, 3, 6, 6, 0, 0,
	0, 7, 5, 8, 8, 1, 1, 2, 3, 6, 6, 0,
	0, 7, 7, 4, 8, 1, 2, 9, 6, 2, 6, 0,
	10,7, 7, 4, 1, 2, 3, 11,12,2, 2, 3,
	13,13,7, 4, 1, 2, 3, 2, 1, 2, 2, 3,
	14,13,7, 7, 5, 1, 1, 8, 2, 1, 1, 2,
	15,16,13,7, 4, 4, 5, 5, 1, 8, 1, 1,
	0, 15,13,7, 7, 7, 4, 4, 4, 5, 8, 0,
	0, 14,16,15,13, 7, 7, 7, 4,17,5, 0,
	0, 0, 10,16,13,13,13,17,18,17,0, 0,
	0, 0, 0, 0, 15,10,19,10,0, 0, 0, 0
};

////////////////////////////////////////
// Green Marble Cursor Palette:
//    Palette For The Green Marble Cursor
////////////////////////////////////////
static const byte s_greenMarbleCursorPalette[] = {
	0x0e, 0xd0, 0x00,	0x00,
	0x0f, 0xe1, 0x00,	0x00,
	0x10, 0xf2, 0x00,	0x00,
	0x0b, 0x9c, 0x00,	0x00,
	0x0c, 0xad, 0x00,	0x00,
	0x11, 0xff, 0x00,	0x00,
	0x09, 0x8a, 0x00,	0x00,
	0x0d, 0xbe, 0x00,	0x00,
	0x30, 0xff, 0x5a,	0x00,
	0x0d, 0x67, 0x30,	0x00,
	0x6b, 0xff, 0x92,	0x00,
	0x00, 0xff, 0x28,	0x00,
	0x08, 0x79, 0x00,	0x00,
	0x05, 0x57, 0x00,	0x00,
	0x30, 0x67, 0x30,	0x00,
	0x06, 0x68, 0x00,	0x00,
	0x00, 0x9b, 0x2c,	0x00,
	0x2e, 0x9c, 0x00,	0x00,
	0x2e, 0x68, 0x00,	0x00
};

////////////////////////////////////////
// Blue Marble Cursor (12x12):
//    Cursor When Holding The Blue Marble
////////////////////////////////////////
static const byte s_blueMarbleCursor[] = {
	0, 0, 0, 0, 1, 2, 3, 3, 0, 0, 0, 0,
	0, 0, 4, 5, 2, 2, 6, 3, 7, 3, 0, 0,
	0, 8, 9, 5, 10,11,2, 6, 3, 3, 7, 0,
	0, 12,13,9, 10,11,6, 14,7, 6, 3, 0,
	15,8, 4, 13,2, 6, 3, 16,17,6, 6, 3,
	18,15,19,13,10,7, 3, 6, 2, 2, 6, 7,
	20,8, 18,4, 21,11,2, 10,6, 2, 2, 2,
	15,15,18,8, 13,9, 21,5, 11,10,2, 1,
	0, 8, 15,19,15,13,13,21,21,5, 9, 0,
	0, 22,20,15, 8,19,15,19,4, 9, 4, 0,
	0, 0, 15,20,15,15,19,15,9, 15,0, 0,
	0, 0, 0, 0, 20,15, 8,15,0, 0, 0, 0
};

////////////////////////////////////////
// Blue Marble Cursor Palette:
//    Palette For The Blue Marble Cursor
////////////////////////////////////////
static const byte s_blueMarbleCursorPalette[] = {
	0x6b, 0x00, 0xd2,	0x00,
	0x66, 0x00, 0xe3,	0x00,
	0x72, 0x00, 0xff,	0x00,
	0x53, 0x2d, 0x9d,	0x00,
	0x4e, 0x00, 0xaf,	0x00,
	0x6d, 0x00, 0xf5,	0x00,
	0x7d, 0x00, 0xff,	0x00,
	0x44, 0x00, 0x69,	0x00,
	0x56, 0x00, 0x9d,	0x00,
	0x56, 0x00, 0xc0,	0x00,
	0x5e, 0x00, 0xd2,	0x00,
	0x2b, 0x31, 0x68,	0x00,
	0x3f, 0x00, 0x8c,	0x00,
	0x91, 0x22, 0xff,	0x00,
	0x41, 0x31, 0x68,	0x00,
	0xd7, 0x95, 0xff,	0x00,
	0x77, 0x22, 0xff,	0x00,
	0x2f, 0x00, 0x69,	0x00,
	0x37, 0x00, 0x7a,	0x00,
	0x27, 0x00, 0x58,	0x00,
	0x46, 0x00, 0x9d,	0x00,
	0x33, 0x33, 0x33,	0x00
};

////////////////////////////////////////
// Violet Marble Cursor (12x12):
//    Cursor When Holding The Violet Marble
////////////////////////////////////////
static const byte s_violetMarbleCursor[] = {
	0, 0, 0, 0, 1, 1, 1, 2, 0, 0, 0, 0,
	0, 0, 3, 3, 1, 1, 1, 4, 2, 4, 0, 0,
	0, 3, 3, 3, 1, 5, 1, 1, 4, 2, 4, 0,
	0, 3, 3, 3, 3, 1, 1, 6, 4, 1, 2, 0,
	3, 7, 8, 3, 1, 1, 4, 9, 4, 1, 1, 4,
	8, 7, 8, 3, 10,4, 1, 1, 1, 1, 4, 1,
	8, 3, 8, 7, 3, 1, 1, 5, 1, 1, 1, 1,
	7, 7, 11,3, 3, 3, 3, 3, 1, 3, 1, 1,
	0, 8, 7, 7, 8, 8, 7, 3, 3, 3, 1, 0,
	0, 7, 8, 3, 11,7, 3, 11,3, 10,3, 0,
	0, 0, 8, 7, 3, 3, 7, 3, 3, 3, 0, 0,
	0, 0, 0, 0, 8, 7, 11,3, 0, 0, 0, 0
};

////////////////////////////////////////
// Violet Marble Cursor Palette:
//    Palette For The Violet Marble Cursor
////////////////////////////////////////
static const byte s_violetMarbleCursorPalette[] = {
	0xaa, 0x00, 0xd1,	0x00,
	0xd8, 0x00, 0xff,	0x00,
	0x76, 0x00, 0x9d,	0x00,
	0xb5, 0x00, 0xff,	0x00,
	0x87, 0x00, 0xd2,	0x00,
	0xd7, 0x22, 0xff,	0x00,
	0x68, 0x00, 0x69,	0x00,
	0x44, 0x00, 0x69,	0x00,
	0xd7, 0x5e, 0xff,	0x00,
	0x9c, 0x00, 0x9d,	0x00,
	0x56, 0x00, 0x9d,	0x00
};

} // End of namespace Mohawk
