/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef ANDROID_EVENTS_H
#define ANDROID_EVENTS_H

#include "common/events.h"

// $ANDROID_NDK/platforms/android-9/arch-arm/usr/include/android/keycodes.h
// http://android.git.kernel.org/?p=platform/frameworks/base.git;a=blob;f=libs/ui/Input.cpp
// http://android.git.kernel.org/?p=platform/frameworks/base.git;a=blob;f=core/java/android/view/KeyEvent.java
// https://static.javadoc.io/io.appium/java-client/5.0.4/constant-values.html#io.appium.java_client.android.AndroidKeyCode.FLAG_SOFT_KEYBOARD

// event type
enum {
	JE_SYS_KEY = 0,
	JE_KEY = 1,
	JE_DPAD = 2,
	JE_DOWN = 3,
	JE_SCROLL = 4,
	JE_TAP = 5,
	JE_DOUBLE_TAP = 6,
	JE_MULTI = 7,
	JE_BALL = 8,
	JE_LMB_DOWN = 9,
	JE_LMB_UP = 10,
	JE_RMB_DOWN = 11,
	JE_RMB_UP = 12,
	JE_MOUSE_MOVE = 13,
	JE_GAMEPAD = 14,
	JE_JOYSTICK = 15,
	JE_MMB_DOWN = 16,
	JE_MMB_UP = 17,
	JE_BMB_DOWN = 18,
	JE_BMB_UP = 19,
	JE_FMB_DOWN = 20,
	JE_FMB_UP = 21,
	JE_QUIT = 0x1000
};

// action type
enum {
	JACTION_DOWN = 0,
	JACTION_UP = 1,
	JACTION_MULTIPLE = 2,
	JACTION_POINTER_DOWN = 5,
	JACTION_POINTER_UP = 6
};

// five-way navigation control
enum {
	JKEYCODE_DPAD_UP = 19,
	JKEYCODE_DPAD_DOWN = 20,
	JKEYCODE_DPAD_LEFT = 21,
	JKEYCODE_DPAD_RIGHT = 22,
	JKEYCODE_DPAD_CENTER = 23
};

// gamepad
enum {
	JKEYCODE_BUTTON_A = 96,
	JKEYCODE_BUTTON_B = 97,
	JKEYCODE_BUTTON_C = 98,
	JKEYCODE_BUTTON_X = 99,
	JKEYCODE_BUTTON_Y = 100,
	JKEYCODE_BUTTON_Z = 101,
	JKEYCODE_BUTTON_L1 = 102,
	JKEYCODE_BUTTON_R1 = 103,
	JKEYCODE_BUTTON_L2 = 104,
	JKEYCODE_BUTTON_R2 = 105,
	JKEYCODE_BUTTON_THUMBL = 106,
	JKEYCODE_BUTTON_THUMBR = 107,
	JKEYCODE_BUTTON_START = 108,
	JKEYCODE_BUTTON_SELECT = 109,
	JKEYCODE_BUTTON_MODE = 110,
};

// meta modifier
enum {
	JMETA_SHIFT_ON = 0x01,
	JMETA_ALT_ON = 0x02,
	JMETA_SYM_ON = 0x04,
	JMETA_FUNCTION_ON = 0x08,
	JMETA_ALT_LEFT_ON = 0x10,
	JMETA_ALT_RIGHT_ON = 0x20,
	JMETA_SHIFT_LEFT_ON = 0x40,
	JMETA_SHIFT_RIGHT_ON = 0x80,
	JMETA_CTRL_ON = 0x1000,
	JMETA_CTRL_LEFT_ON = 0x2000,
	JMETA_CTRL_RIGHT_ON = 0x4000,
	JMETA_META_ON = 0x10000,
	JMETA_META_LEFT_ON = 0x20000,
	JMETA_META_RIGHT_ON = 0x40000,
	JMETA_CAPS_LOCK_ON = 0x100000,
	JMETA_NUM_LOCK_ON = 0x200000,
	JMETA_SCROLL_LOCK_ON = 0x400000,

	JMETA_CTRL_MASK = JMETA_CTRL_ON | JMETA_CTRL_LEFT_ON | JMETA_CTRL_RIGHT_ON,
	JMETA_META_MASK = JMETA_META_ON | JMETA_META_LEFT_ON | JMETA_META_RIGHT_ON,
	JMETA_SHIFT_MASK = JMETA_SHIFT_ON | JMETA_SHIFT_LEFT_ON | JMETA_SHIFT_RIGHT_ON,
	JMETA_ALT_MASK = JMETA_ALT_ON | JMETA_ALT_LEFT_ON | JMETA_ALT_RIGHT_ON
};

// map android key codes to our kbd codes
static const Common::KeyCode jkeymap[] = {
	Common::KEYCODE_INVALID, // KEYCODE_UNKNOWN
	Common::KEYCODE_LEFTSOFT, // KEYCODE_SOFT_LEFT
	Common::KEYCODE_RIGHTSOFT, // KEYCODE_SOFT_RIGHT
	Common::KEYCODE_AC_HOME, // KEYCODE_HOME
	Common::KEYCODE_AC_BACK, // KEYCODE_BACK
	Common::KEYCODE_CALL, // KEYCODE_CALL
	Common::KEYCODE_HANGUP, // KEYCODE_ENDCALL
	Common::KEYCODE_0, // KEYCODE_0
	Common::KEYCODE_1, // KEYCODE_1
	Common::KEYCODE_2, // KEYCODE_2
	Common::KEYCODE_3, // KEYCODE_3
	Common::KEYCODE_4, // KEYCODE_4
	Common::KEYCODE_5, // KEYCODE_5
	Common::KEYCODE_6, // KEYCODE_6
	Common::KEYCODE_7, // KEYCODE_7
	Common::KEYCODE_8, // KEYCODE_8
	Common::KEYCODE_9, // KEYCODE_9
	Common::KEYCODE_ASTERISK, // KEYCODE_STAR
	Common::KEYCODE_HASH, // KEYCODE_POUND
	Common::KEYCODE_UP, // KEYCODE_DPAD_UP
	Common::KEYCODE_DOWN, // KEYCODE_DPAD_DOWN
	Common::KEYCODE_LEFT, // KEYCODE_DPAD_LEFT
	Common::KEYCODE_RIGHT, // KEYCODE_DPAD_RIGHT
	Common::KEYCODE_SELECT, // KEYCODE_DPAD_CENTER
	Common::KEYCODE_VOLUMEUP, // KEYCODE_VOLUME_UP
	Common::KEYCODE_VOLUMEDOWN, // KEYCODE_VOLUME_DOWN
	Common::KEYCODE_POWER, // KEYCODE_POWER
	Common::KEYCODE_CAMERA, // KEYCODE_CAMERA
	Common::KEYCODE_CLEAR, // KEYCODE_CLEAR
	Common::KEYCODE_a, // KEYCODE_A
	Common::KEYCODE_b, // KEYCODE_B
	Common::KEYCODE_c, // KEYCODE_C
	Common::KEYCODE_d, // KEYCODE_D
	Common::KEYCODE_e, // KEYCODE_E
	Common::KEYCODE_f, // KEYCODE_F
	Common::KEYCODE_g, // KEYCODE_G
	Common::KEYCODE_h, // KEYCODE_H
	Common::KEYCODE_i, // KEYCODE_I
	Common::KEYCODE_j, // KEYCODE_J
	Common::KEYCODE_k, // KEYCODE_K
	Common::KEYCODE_l, // KEYCODE_L
	Common::KEYCODE_m, // KEYCODE_M
	Common::KEYCODE_n, // KEYCODE_N
	Common::KEYCODE_o, // KEYCODE_O
	Common::KEYCODE_p, // KEYCODE_P
	Common::KEYCODE_q, // KEYCODE_Q
	Common::KEYCODE_r, // KEYCODE_R
	Common::KEYCODE_s, // KEYCODE_S
	Common::KEYCODE_t, // KEYCODE_T
	Common::KEYCODE_u, // KEYCODE_U
	Common::KEYCODE_v, // KEYCODE_V
	Common::KEYCODE_w, // KEYCODE_W
	Common::KEYCODE_x, // KEYCODE_X
	Common::KEYCODE_y, // KEYCODE_Y
	Common::KEYCODE_z, // KEYCODE_Z
	Common::KEYCODE_COMMA, // KEYCODE_COMMA
	Common::KEYCODE_PERIOD, // KEYCODE_PERIOD
	Common::KEYCODE_LALT, // KEYCODE_ALT_LEFT
	Common::KEYCODE_RALT, // KEYCODE_ALT_RIGHT
	Common::KEYCODE_LSHIFT, // KEYCODE_SHIFT_LEFT
	Common::KEYCODE_RSHIFT, // KEYCODE_SHIFT_RIGHT
	Common::KEYCODE_TAB, // KEYCODE_TAB
	Common::KEYCODE_SPACE, // KEYCODE_SPACE
	Common::KEYCODE_LCTRL, // KEYCODE_SYM
	Common::KEYCODE_WWW, // KEYCODE_EXPLORER
	Common::KEYCODE_MAIL, // KEYCODE_ENVELOPE
	Common::KEYCODE_RETURN, // KEYCODE_ENTER
	Common::KEYCODE_BACKSPACE, // KEYCODE_DEL
	Common::KEYCODE_BACKQUOTE, // KEYCODE_GRAVE
	Common::KEYCODE_MINUS, // KEYCODE_MINUS
	Common::KEYCODE_EQUALS, // KEYCODE_EQUALS
	Common::KEYCODE_LEFTPAREN, // KEYCODE_LEFT_BRACKET
	Common::KEYCODE_RIGHTPAREN, // KEYCODE_RIGHT_BRACKET
	Common::KEYCODE_BACKSLASH, // KEYCODE_BACKSLASH
	Common::KEYCODE_SEMICOLON, // KEYCODE_SEMICOLON
	Common::KEYCODE_QUOTE, // KEYCODE_APOSTROPHE
	Common::KEYCODE_SLASH, // KEYCODE_SLASH
	Common::KEYCODE_AT, // KEYCODE_AT
	Common::KEYCODE_INVALID, // KEYCODE_NUM
	Common::KEYCODE_INVALID, // KEYCODE_HEADSETHOOK
	Common::KEYCODE_INVALID, // KEYCODE_FOCUS
	Common::KEYCODE_PLUS, // KEYCODE_PLUS
	Common::KEYCODE_MENU, // KEYCODE_MENU
	Common::KEYCODE_INVALID, // KEYCODE_NOTIFICATION
	Common::KEYCODE_AC_SEARCH, // KEYCODE_SEARCH
	Common::KEYCODE_AUDIOPLAYPAUSE, // KEYCODE_MEDIA_PLAY_PAUSE
	Common::KEYCODE_AUDIOSTOP, // KEYCODE_MEDIA_STOP
	Common::KEYCODE_AUDIONEXT, // KEYCODE_MEDIA_NEXT
	Common::KEYCODE_AUDIOPREV, // KEYCODE_MEDIA_PREVIOUS
	Common::KEYCODE_AUDIOREWIND, // KEYCODE_MEDIA_REWIND
	Common::KEYCODE_AUDIOFASTFORWARD, // KEYCODE_MEDIA_FAST_FORWARD
	Common::KEYCODE_MUTE, // KEYCODE_MUTE
	Common::KEYCODE_PAGEUP, // KEYCODE_PAGE_UP
	Common::KEYCODE_PAGEDOWN, // KEYCODE_PAGE_DOWN
	Common::KEYCODE_INVALID, // KEYCODE_PICTSYMBOLS
	Common::KEYCODE_INVALID, // KEYCODE_SWITCH_CHARSET
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_A
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_B
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_C
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_X
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_Y
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_Z
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_L1
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_R1
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_L2
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_R2
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_THUMBL
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_THUMBR
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_START
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_SELECT
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_MODE
	Common::KEYCODE_ESCAPE, // KEYCODE_ESCAPE
	Common::KEYCODE_DELETE, // KEYCODE_FORWARD_DEL
	Common::KEYCODE_LCTRL, // KEYCODE_CTRL_LEFT
	Common::KEYCODE_RCTRL, // KEYCODE_CTRL_RIGHT
	Common::KEYCODE_CAPSLOCK, // KEYCODE_CAPS_LOCK
	Common::KEYCODE_SCROLLOCK, // KEYCODE_SCROLL_LOCK
	Common::KEYCODE_LSUPER, // KEYCODE_META_LEFT
	Common::KEYCODE_RSUPER, // KEYCODE_META_RIGHT
	Common::KEYCODE_INVALID, // KEYCODE_FUNCTION
	Common::KEYCODE_SYSREQ, // KEYCODE_SYSRQ
	Common::KEYCODE_BREAK, // KEYCODE_BREAK
	Common::KEYCODE_HOME, // KEYCODE_MOVE_HOME
	Common::KEYCODE_END, // KEYCODE_MOVE_END
	Common::KEYCODE_INSERT, // KEYCODE_INSERT
	Common::KEYCODE_AC_FORWARD, // KEYCODE_FORWARD
	Common::KEYCODE_AUDIOPLAY, // KEYCODE_MEDIA_PLAY
	Common::KEYCODE_AUDIOPAUSE, // KEYCODE_MEDIA_PAUSE
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_CLOSE
	Common::KEYCODE_EJECT, // KEYCODE_MEDIA_EJECT
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_RECORD
	Common::KEYCODE_F1, // KEYCODE_F1
	Common::KEYCODE_F2, // KEYCODE_F2
	Common::KEYCODE_F3, // KEYCODE_F3
	Common::KEYCODE_F4, // KEYCODE_F4
	Common::KEYCODE_F5, // KEYCODE_F5
	Common::KEYCODE_F6, // KEYCODE_F6
	Common::KEYCODE_F7, // KEYCODE_F7
	Common::KEYCODE_F8, // KEYCODE_F8
	Common::KEYCODE_F9, // KEYCODE_F9
	Common::KEYCODE_F10, // KEYCODE_F10
	Common::KEYCODE_F11, // KEYCODE_F11
	Common::KEYCODE_F12, // KEYCODE_F12
	Common::KEYCODE_NUMLOCK, // KEYCODE_NUM_LOCK
	Common::KEYCODE_KP0, // KEYCODE_NUMPAD_0
	Common::KEYCODE_KP1, // KEYCODE_NUMPAD_1
	Common::KEYCODE_KP2, // KEYCODE_NUMPAD_2
	Common::KEYCODE_KP3, // KEYCODE_NUMPAD_3
	Common::KEYCODE_KP4, // KEYCODE_NUMPAD_4
	Common::KEYCODE_KP5, // KEYCODE_NUMPAD_5
	Common::KEYCODE_KP6, // KEYCODE_NUMPAD_6
	Common::KEYCODE_KP7, // KEYCODE_NUMPAD_7
	Common::KEYCODE_KP8, // KEYCODE_NUMPAD_8
	Common::KEYCODE_KP9, // KEYCODE_NUMPAD_9
	Common::KEYCODE_KP_DIVIDE, // KEYCODE_NUMPAD_DIVIDE
	Common::KEYCODE_KP_MULTIPLY, // KEYCODE_NUMPAD_MULTIPLY
	Common::KEYCODE_KP_MINUS, // KEYCODE_NUMPAD_SUBTRACT
	Common::KEYCODE_KP_PLUS, // KEYCODE_NUMPAD_ADD
	Common::KEYCODE_KP_PERIOD, // KEYCODE_NUMPAD_DOT
	Common::KEYCODE_INVALID, // KEYCODE_NUMPAD_COMMA
	Common::KEYCODE_KP_ENTER, // KEYCODE_NUMPAD_ENTER
	Common::KEYCODE_KP_EQUALS, // KEYCODE_NUMPAD_EQUALS
	Common::KEYCODE_INVALID, // KEYCODE_NUMPAD_LEFT_PAREN
	Common::KEYCODE_INVALID, // KEYCODE_NUMPAD_RIGHT_PAREN
	Common::KEYCODE_INVALID, // KEYCODE_VOLUME_MUTE
	Common::KEYCODE_INVALID, // KEYCODE_INFO
	Common::KEYCODE_INVALID, // KEYCODE_CHANNEL_UP
	Common::KEYCODE_INVALID, // KEYCODE_CHANNEL_DOWN
	Common::KEYCODE_INVALID, // KEYCODE_ZOOM_IN
	Common::KEYCODE_INVALID, // KEYCODE_ZOOM_OUT
	Common::KEYCODE_INVALID, // KEYCODE_TV
	Common::KEYCODE_INVALID, // KEYCODE_WINDOW
	Common::KEYCODE_INVALID, // KEYCODE_GUIDE
	Common::KEYCODE_INVALID, // KEYCODE_DVR
	Common::KEYCODE_AC_BOOKMARKS, // KEYCODE_BOOKMARK
	Common::KEYCODE_INVALID, // KEYCODE_CAPTIONS
	Common::KEYCODE_INVALID, // KEYCODE_SETTINGS
	Common::KEYCODE_INVALID, // KEYCODE_TV_POWER
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT
	Common::KEYCODE_INVALID, // KEYCODE_STB_POWER
	Common::KEYCODE_INVALID, // KEYCODE_STB_INPUT
	Common::KEYCODE_INVALID, // KEYCODE_AVR_POWER
	Common::KEYCODE_INVALID, // KEYCODE_AVR_INPUT
	Common::KEYCODE_INVALID, // KEYCODE_PROG_RED
	Common::KEYCODE_INVALID, // KEYCODE_PROG_GREEN
	Common::KEYCODE_INVALID, // KEYCODE_PROG_YELLOW
	Common::KEYCODE_INVALID, // KEYCODE_PROG_BLUE
	Common::KEYCODE_INVALID, // KEYCODE_APP_SWITCH
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_1
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_2
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_3
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_4
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_5
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_6
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_7
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_8
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_9
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_10
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_11
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_12
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_13
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_14
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_15
	Common::KEYCODE_INVALID, // KEYCODE_BUTTON_16
	Common::KEYCODE_INVALID, // KEYCODE_LANGUAGE_SWITCH
	Common::KEYCODE_INVALID, // KEYCODE_MANNER_MODE
	Common::KEYCODE_INVALID, // KEYCODE_3D_MODE
	Common::KEYCODE_INVALID, // KEYCODE_CONTACTS
	Common::KEYCODE_INVALID, // KEYCODE_CALENDAR
	Common::KEYCODE_INVALID, // KEYCODE_MUSIC
	Common::KEYCODE_CALCULATOR, // KEYCODE_CALCULATOR
	Common::KEYCODE_INVALID, // KEYCODE_ZENKAKU_HANKAKU
	Common::KEYCODE_INVALID, // KEYCODE_EISU
	Common::KEYCODE_INVALID, // KEYCODE_MUHENKAN
	Common::KEYCODE_INVALID, // KEYCODE_HENKAN
	Common::KEYCODE_INVALID, // KEYCODE_KATAKANA_HIRAGANA
	Common::KEYCODE_INVALID, // KEYCODE_YEN
	Common::KEYCODE_INVALID, // KEYCODE_RO
	Common::KEYCODE_INVALID, // KEYCODE_KANA
	Common::KEYCODE_INVALID, // KEYCODE_ASSIST
	Common::KEYCODE_INVALID, // KEYCODE_BRIGHTNESS_DOWN
	Common::KEYCODE_INVALID, // KEYCODE_BRIGHTNESS_UP
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_AUDIO_TRACK
	Common::KEYCODE_SLEEP, // KEYCODE_SLEEP
	Common::KEYCODE_INVALID, // KEYCODE_WAKEUP
	Common::KEYCODE_INVALID, // KEYCODE_PAIRING
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_TOP_MENU
	Common::KEYCODE_INVALID, // KEYCODE_11
	Common::KEYCODE_INVALID, // KEYCODE_12
	Common::KEYCODE_INVALID, // KEYCODE_LAST_CHANNEL
	Common::KEYCODE_INVALID, // KEYCODE_TV_DATA_SERVICE
	Common::KEYCODE_INVALID, // KEYCODE_VOICE_ASSIST
	Common::KEYCODE_INVALID, // KEYCODE_TV_RADIO_SERVICE
	Common::KEYCODE_INVALID, // KEYCODE_TV_TELETEXT
	Common::KEYCODE_INVALID, // KEYCODE_TV_NUMBER_ENTRY
	Common::KEYCODE_INVALID, // KEYCODE_TV_TERRESTRIAL_ANALOG
	Common::KEYCODE_INVALID, // KEYCODE_TV_TERRESTRIAL_DIGITAL
	Common::KEYCODE_INVALID, // KEYCODE_TV_SATELLITE
	Common::KEYCODE_INVALID, // KEYCODE_TV_SATELLITE_BS
	Common::KEYCODE_INVALID, // KEYCODE_TV_SATELLITE_CS
	Common::KEYCODE_INVALID, // KEYCODE_TV_SATELLITE_SERVICE
	Common::KEYCODE_INVALID, // KEYCODE_TV_NETWORK
	Common::KEYCODE_INVALID, // KEYCODE_TV_ANTENNA_CABLE
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_HDMI_1
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_HDMI_2
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_HDMI_3
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_HDMI_4
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_COMPOSITE_1
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_COMPOSITE_2
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_COMPONENT_1
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_COMPONENT_2
	Common::KEYCODE_INVALID, // KEYCODE_TV_INPUT_VGA_1
	Common::KEYCODE_INVALID, // KEYCODE_TV_AUDIO_DESCRIPTION
	Common::KEYCODE_INVALID, // KEYCODE_TV_AUDIO_DESCRIPTION_MIX_UP
	Common::KEYCODE_INVALID, // KEYCODE_TV_AUDIO_DESCRIPTION_MIX_DOWN
	Common::KEYCODE_INVALID, // KEYCODE_TV_ZOOM_MODE
	Common::KEYCODE_INVALID, // KEYCODE_TV_CONTENTS_MENU
	Common::KEYCODE_INVALID, // KEYCODE_TV_MEDIA_CONTEXT_MENU
	Common::KEYCODE_INVALID, // KEYCODE_TV_TIMER_PROGRAMMING
	Common::KEYCODE_HELP, // KEYCODE_HELP
	Common::KEYCODE_INVALID, // KEYCODE_NAVIGATE_PREVIOUS
	Common::KEYCODE_INVALID, // KEYCODE_NAVIGATE_NEXT
	Common::KEYCODE_INVALID, // KEYCODE_NAVIGATE_IN
	Common::KEYCODE_INVALID, // KEYCODE_NAVIGATE_OUT
	Common::KEYCODE_INVALID, // KEYCODE_STEM_PRIMARY
	Common::KEYCODE_INVALID, // KEYCODE_STEM_1
	Common::KEYCODE_INVALID, // KEYCODE_STEM_2
	Common::KEYCODE_INVALID, // KEYCODE_STEM_3
	Common::KEYCODE_INVALID, // KEYCODE_DPAD_UP_LEFT
	Common::KEYCODE_INVALID, // KEYCODE_DPAD_DOWN_LEFT
	Common::KEYCODE_INVALID, // KEYCODE_DPAD_UP_RIGHT
	Common::KEYCODE_INVALID, // KEYCODE_DPAD_DOWN_RIGHT
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_SKIP_FORWARD
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_SKIP_BACKWARD
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_STEP_FORWARD
	Common::KEYCODE_INVALID, // KEYCODE_MEDIA_STEP_BACKWARD
	Common::KEYCODE_INVALID, // KEYCODE_SOFT_SLEEP
	Common::KEYCODE_CUT, // KEYCODE_CUT
	Common::KEYCODE_COPY, // KEYCODE_COPY
	Common::KEYCODE_PASTE // KEYCODE_PASTE
};

#endif
