#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h> 
#include <sys/stat.h>

#include "../include/fio.h"
#include "../include/disk.h"
#include "../include/string.h"

#include "obj.h"
#include "human.h"
#include "config.h"

int SARHumanLoadFromFile(sar_human_data_struct *hd, const char *filename);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))


/*
 *	Loads human presets data from file into the given
 *	sar_human_data_struct. Any data already in this struction will be
 *	deallocated first.
 */
int SARHumanLoadFromFile(sar_human_data_struct *hd, const char *filename)
{
	int i;
        FILE *fp;
        char *buf = NULL;
        struct stat stat_buf;

	sar_human_data_entry_struct *hdp_ptr = NULL;
	sar_color_struct *color_ptr, *palette_ptr = NULL;

        double value[10];
	

	if((filename == NULL) || (hd == NULL))
	    return(-1);

	/* Delete any existing preset human data entries. */
	for(i = 0; i < hd->total_presets; i++)
	    SARHumanEntryDelete(hd, hd->preset[i]);

	/* Check if file exists. */
        if(stat(filename, &stat_buf))
        {
            fprintf(stderr, "%s: No such file.\n", filename);
            return(-1);
        }
#ifdef S_ISREG
        if(!S_ISREG(stat_buf.st_mode))
        {
            fprintf(stderr,
                "%s: Not a file.\n",
                filename
            );
            return(-1);
        }
#endif	/* S_ISREG */

	/* Open human presets file. */
        fp = FOpen(filename, "rb");
        if(fp == NULL)
        {
            fprintf(stderr, "%s: Cannot open.\n", filename);
            return(-1);
        }

#define DO_SET_COLOR	\
{ \
 if(color_ptr != NULL) \
 { \
  color_ptr->r = (float)value[0]; \
  color_ptr->g = (float)value[1]; \
  color_ptr->b = (float)value[2]; \
  color_ptr->a = (float)value[3]; \
 } \
}


        do
        {
            buf = FSeekNextParm(
                fp,
                buf,
                SAR_COMMENT_CHAR,
                SAR_CFG_DELIM_CHAR
            );
            if(buf == NULL)
                break;

	    /* Begin handling parameter. */

	    /* Version? */
            if(!strcasecmp(buf, "Version"))
            {
                FGetValuesF(fp, value, 2);

		/* Ignore. */
            }
	    /* Add a new preset human data entry? */
	    else if(!strcasecmp(buf, "PresetAdd"))
            {
                char *preset_name = FGetString(fp);

		/* Reset context pointers. */
		hdp_ptr = NULL;
		palette_ptr = NULL;

		/* Allocate a new pointer and structure. */
		i = hd->total_presets;
		hd->total_presets++;
		hd->preset = (sar_human_data_entry_struct **)realloc(
		    hd->preset,
		    hd->total_presets * sizeof(sar_human_data_entry_struct *)
		);
		if(hd->preset == NULL)
		{
		    hd->total_presets = 0;
		}
		else
		{
		    hdp_ptr = (sar_human_data_entry_struct *)calloc(
			1,
			sizeof(sar_human_data_entry_struct)
		    );
		    hd->preset[i] = hdp_ptr;
		}

		/* Set human preset name. */
		if(hdp_ptr != NULL)
		{
		    hdp_ptr->name = preset_name;
		    preset_name = NULL;
		}
		else
		{
		    free(preset_name);
		    preset_name = NULL;
		}
	    }

            /* Height in meters. */
            else if(!strcasecmp(buf, "Height"))
            {
                FGetValuesF(fp, value, 1);
                if(hdp_ptr != NULL)
                {
                    hdp_ptr->height = (float)MAX(value[0], 0.0);
                }
            }
            /* Mass in kg. */
            else if(!strcasecmp(buf, "Mass"))
            {
                FGetValuesF(fp, value, 1);
                if(hdp_ptr != NULL)
                {
                    hdp_ptr->mass = (float)MAX(value[0], 0.0);  
                }
            }
	    /* Number of assisting humans. */
            else if(!strcasecmp(buf, "AssistingHumans"))
            {
                FGetValuesF(fp, value, 1);
                if(hdp_ptr != NULL)
                {
                    hdp_ptr->assisting_humans = MAX((int)value[0], 0);
                }
            }


	    /* Color palette color values. */
	    else if(!strcasecmp(buf, "ColorPaletteSelect"))
            {
		char *palette_type = FGetString(fp);
		if(palette_type != NULL)
		{
		    /* Assisting human color palette? */
		    if(!strcasecmp(palette_type, "AssistingHuman") ||
                       !strcasecmp(palette_type, "assisting_human")
		    )
		    {
			palette_ptr = hdp_ptr->assisting_human_color;
		    }
		    /* Standard human color palette? */
		    else if(!strcasecmp(palette_type, "Standard"))
                    {
                        palette_ptr = hdp_ptr->color;
                    }
		    else
		    {
			fprintf(
			    stderr,
            "%s: ColorPaletteSelect: Unsupported palette `%s'\n",
			    filename, palette_type
			);
		    }

		    free(palette_type);
		    palette_type = NULL;
		}
	    }

	    /* Face color. */
            else if(!strcasecmp(buf, "ColorFace"))
            {
                FGetValuesF(fp, value, 4);
		if((hdp_ptr != NULL) && (palette_ptr != NULL))
		{
		    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_FACE];
		    DO_SET_COLOR
		}
            }
            /* Hair color. */
            else if(!strcasecmp(buf, "ColorHair"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_HAIR];
                    DO_SET_COLOR
                }
            }
            /* Torso color. */
            else if(!strcasecmp(buf, "ColorTorso"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_TORSO];
                    DO_SET_COLOR
                }
            }
            /* Hips color. */
            else if(!strcasecmp(buf, "ColorHips"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_HIPS];
                    DO_SET_COLOR
                }
            }
            /* Legs color. */
            else if(!strcasecmp(buf, "ColorLegs"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_LEGS];
                    DO_SET_COLOR
                }
            }
            /* Feet color. */
            else if(!strcasecmp(buf, "ColorFeet"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_FEET];
                    DO_SET_COLOR
                }
            }
            /* Arms color. */
            else if(!strcasecmp(buf, "ColorArms"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_ARMS];
                    DO_SET_COLOR
                }
            }
            /* Hands color. */
            else if(!strcasecmp(buf, "ColorHands"))
            {
                FGetValuesF(fp, value, 4);
                if((hdp_ptr != NULL) && (palette_ptr != NULL))
                {
                    color_ptr = &palette_ptr[SAR_HUMAN_COLOR_HANDS];
                    DO_SET_COLOR
                }
            }

            else
            {
                fprintf(
		    stderr,
                    "%s: Unsupported parameter `%s'.\n",
                    filename, buf
                );
                FSeekNextLine(fp);
            }

        } while(1);

	/* Close file. */            
        FClose(fp);

#undef DO_SET_COLOR
	return(0);
}
