#include <stdio.h>
#include <sys/types.h>
#include <math.h>

#ifdef __MSW__
# include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#include "gw.h"

#include "sarreality.h"
#include "obj.h"
#include "objutils.h"
#include "sfm.h"
#include "sar.h"
#include "sardraw.h"
#include "sardrawpm.h"
#include "sardrawdefs.h"


void SARDrawPremodeledBuilding(SAR_DRAW_PREMODELED_PROTOTYPE);


/*
 *      Draws a premodeled building.
 */
void SARDrawPremodeledBuilding(SAR_DRAW_PREMODELED_PROTOTYPE)
{
	gw_display_struct *display = dc->display;
	sar_scene_struct *scene = dc->scene;
	GLenum shade_model_mode = display->state_gl.shade_model_mode;
	float x_min, x_max, y_min, y_max, z_max;
        int i, tex_num;


        /* Calculate bounds. */
        x_max = obj_premodeled_ptr->length / 2.0f;
        x_min = -x_max;

        y_max = obj_premodeled_ptr->width / 2.0f;
        y_min = -y_max;

        z_max = obj_premodeled_ptr->height;


	/* Set up gl states. */
	StateGLShadeModel(&display->state_gl, GL_FLAT);


        /* Select wall texture. */
        i = 0;
        if(i < SAR_OBJ_PREMODEL_MAX_TEXTURES)
            tex_num = obj_premodeled_ptr->tex_num[i];
        else
            tex_num = -1;

        if(SARIsTextureAllocated(scene, tex_num))
            V3DTextureSelect(scene->texture_ref[tex_num]);
        else
            V3DTextureSelect(NULL);
        glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

        /* Draw walls. */
        glBegin(GL_QUADS);
        {
            /* North wall. */
            glNormal3f(0.0f, 0.0f, -1.0f);
            glTexCoord2f(1.0f, 1.0f - 0.0f);
            glVertex3f(x_min, 0.0f, -y_max);
            glTexCoord2f(1.0f, 1.0f - 1.0f);
            glVertex3f(x_min, z_max, -y_max);
            glTexCoord2f(0.0f, 1.0f - 1.0f);
            glVertex3f(x_max, z_max, -y_max);
            glTexCoord2f(0.0f, 1.0f - 0.0f);
            glVertex3f(x_max, 0.0f, -y_max);

            /* West wall. */
            glNormal3f(-1.0f, 0.0f, 0.0f);
            glTexCoord2f(0.0f, 1.0f - 0.0f);
            glVertex3f(x_min, 0.0f, -y_min);
            glTexCoord2f(0.0f, 1.0f - 1.0f);
            glVertex3f(x_min, z_max, -y_min);
            glTexCoord2f(1.0f, 1.0f - 1.0f);
            glVertex3f(x_min, z_max, -y_max);
            glTexCoord2f(1.0f, 1.0f - 0.0f);
            glVertex3f(x_min, 0.0f, -y_max);

            /* South wall. */
            glNormal3f(0.0f, 0.0f, 1.0f);
            glTexCoord2f(0.0f, 1.0f - 0.0f);
            glVertex3f(x_max, 0.0f, -y_min);
            glTexCoord2f(0.0f, 1.0f - 1.0f);
            glVertex3f(x_max, z_max, -y_min);
            glTexCoord2f(1.0f, 1.0f - 1.0f);
            glVertex3f(x_min, z_max, -y_min);
            glTexCoord2f(1.0f, 1.0f - 0.0f);
            glVertex3f(x_min, 0.0f, -y_min);

            /* East wall. */
            glNormal3f(1.0f, 0.0f, 0.0f);
            glTexCoord2f(0.0f, 1.0f - 0.0f);
            glVertex3f(x_max, 0.0f, -y_max);
            glTexCoord2f(0.0f, 1.0f - 1.0f);
            glVertex3f(x_max, z_max, -y_max);
            glTexCoord2f(1.0f, 1.0f - 1.0f);
            glVertex3f(x_max, z_max, -y_min);
            glTexCoord2f(1.0f, 1.0f - 0.0f);
            glVertex3f(x_max, 0.0f, -y_min);
        }
        glEnd();

        /* Draw walls at night? */
        if(scene->tod_code != SAR_SCENE_TOD_DAY)
        {
            StateGLBoolean lighting = display->state_gl.lighting;


            /* Set up gl states. */
            if(lighting)
                StateGLDisable(&display->state_gl, GL_LIGHTING);

            /* Select night wall texture. */
            i = 1;
            if(i < SAR_OBJ_PREMODEL_MAX_TEXTURES)
                tex_num = obj_premodeled_ptr->tex_num[i];
            else
                tex_num = -1;

            if(SARIsTextureAllocated(scene, tex_num))
                V3DTextureSelect(scene->texture_ref[tex_num]);
            else
                V3DTextureSelect(NULL);

	    if(dc->ifr)
		glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
	    else
		glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

            /* Draw walls. */
            glBegin(GL_QUADS);
            {
                /* North wall. */
                glNormal3f(0.0f, 0.0f, -1.0f);
                glTexCoord2f(1.0f, 1.0f - 0.0f);
                glVertex3f(x_min, 0.0f, -y_max);
                glTexCoord2f(1.0f, 1.0f - 1.0f);
                glVertex3f(x_min, z_max, -y_max);
                glTexCoord2f(0.0f, 1.0f - 1.0f);
                glVertex3f(x_max, z_max, -y_max);
                glTexCoord2f(0.0f, 1.0f - 0.0f);
                glVertex3f(x_max, 0.0f, -y_max);

                /* West wall. */
                glNormal3f(-1.0f, 0.0f, 0.0f);
                glTexCoord2f(0.0f, 1.0f - 0.0f);
                glVertex3f(x_min, 0.0f, -y_min);
                glTexCoord2f(0.0f, 1.0f - 1.0f);
                glVertex3f(x_min, z_max, -y_min);
                glTexCoord2f(1.0f, 1.0f - 1.0f);
                glVertex3f(x_min, z_max, -y_max);
                glTexCoord2f(1.0f, 1.0f - 0.0f);
                glVertex3f(x_min, 0.0f, -y_max);

                /* South wall. */
                glNormal3f(0.0f, 0.0f, 1.0f);
                glTexCoord2f(0.0f, 1.0f - 0.0f);
                glVertex3f(x_max, 0.0f, -y_min);
                glTexCoord2f(0.0f, 1.0f - 1.0f);
                glVertex3f(x_max, z_max, -y_min);
                glTexCoord2f(1.0f, 1.0f - 1.0f);
                glVertex3f(x_min, z_max, -y_min);
                glTexCoord2f(1.0f, 1.0f - 0.0f);
                glVertex3f(x_min, 0.0f, -y_min);

                /* East wall. */
                glNormal3f(1.0f, 0.0f, 0.0f);
                glTexCoord2f(0.0f, 1.0f - 0.0f);
                glVertex3f(x_max, 0.0f, -y_max);
                glTexCoord2f(0.0f, 1.0f - 1.0f);
                glVertex3f(x_max, z_max, -y_max);
                glTexCoord2f(1.0f, 1.0f - 1.0f);
                glVertex3f(x_max, z_max, -y_min);
                glTexCoord2f(1.0f, 1.0f - 0.0f);
                glVertex3f(x_max, 0.0f, -y_min);
            }
            glEnd();

            /* Restore gl states. */
            if(lighting)
                StateGLEnable(&display->state_gl, GL_LIGHTING);
        }


        /* Select roof texture. */
        i = 2;
        if(i < SAR_OBJ_PREMODEL_MAX_TEXTURES)
            tex_num = obj_premodeled_ptr->tex_num[i];
        else
            tex_num = -1;

        if(SARIsTextureAllocated(scene, tex_num))
            V3DTextureSelect(scene->texture_ref[tex_num]);
        else
            V3DTextureSelect(NULL);
        glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

        glBegin(GL_QUADS);
        {
            /* Roof. */
            glNormal3f(0.0f, 1.0f, 0.0f);
            glTexCoord2f(0.0f, 1.0f - 0.0f);
            glVertex3f(x_max, z_max, -y_min);
            glTexCoord2f(0.0f, 1.0f - 1.0f);
            glVertex3f(x_max, z_max, -y_max);
            glTexCoord2f(1.0f, 1.0f - 1.0f);
            glVertex3f(x_min, z_max, -y_max);
            glTexCoord2f(1.0f, 1.0f - 0.0f);
            glVertex3f(x_min, z_max, -y_min);
        }
        glEnd();

        /* Restore gl states. */
        StateGLShadeModel(&display->state_gl, shade_model_mode);
}
