#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "sfm.h"


SFMRealmStruct *SFMInit(int argc, char **argv);
void SFMShutdown(SFMRealmStruct *realm);

void SFMSetTimming(SFMRealmStruct *realm, SFMTime lapsed_ms);
void SFMSetTimeCompression(SFMRealmStruct *realm, double compression);
void SFMUpdateRealm(SFMRealmStruct *realm, SFMTime lapsed_ms);


/*
 *	Initializes and returns a new SFMRealmStruct.
 */
SFMRealmStruct *SFMInit(int argc, char **argv)
{
	SFMRealmStruct *realm = SFM_REALM(calloc(
	    1, sizeof(SFMRealmStruct)
	));
	if(realm == NULL)
	    return(NULL);

	/* Reset values. */
	realm->lapsed_time = 0;
	realm->time_compensation = 1.0;
	realm->time_compression = 1.0;

	realm->gravity = SFMDefaultGravity;

	realm->airborne_cb_client_data = NULL;
	realm->airborne_cb = NULL;

	realm->touch_down_cb_client_data = NULL;
	realm->touch_down_cb = NULL;

	realm->collision_cb_client_data = NULL;
	realm->collision_cb = NULL;

	realm->model = NULL;
	realm->total_models = 0;

	return(realm);
}

/*
 *	Shuts down the given SFMRealmStruct, and deallocates all
 *	SFMModels within the SFMRealmStruct if any. All other
 *	resources on the SFMRealmStruct will be deallocated as well.
 */
void SFMShutdown(SFMRealmStruct *realm)
{
	if(realm == NULL)
	    return;

	/* Begin deallocating realm structure. */

	/* Delete all flight dynamics models. */
	while(realm->total_models > 0)
	{
	    if(realm->model[0] == NULL)
		break;

	    /* Delete this SFMModel, this will also call the
	     * destroy_model_cb on the realm structure if set.
	     *
	     * Note that each call to this function will
	     * deincrement realm->total_models by one.
	     */
	    SFMModelDelete(realm, realm->model[0]);
	}





	/* Structure itself. */
	free(realm);

	return;
}

/*
 *	Sets the timming values for the given SFMRealmStruct.
 *
 *	Future calls to SFM functions will use the timming values
 *	set here.
 */
void SFMSetTimming(SFMRealmStruct *realm, SFMTime lapsed_ms)
{
        if(realm == NULL)
	    return;

	if(lapsed_ms < 0)
	    lapsed_ms = 0;

        /* Update timmings. */
        realm->lapsed_time = lapsed_ms;
        realm->time_compensation = (double)(
            (double)lapsed_ms / (double)SFMCycleUnitsMS
        );

	return;
}

/*
 *	Changes the time compression coefficient for the given
 *	SFMRealmStruct.
 */
void SFMSetTimeCompression(SFMRealmStruct *realm, double compression)
{
        if(realm == NULL)
            return;

	if(compression < 0.0)
	    compression = 0.0;

	realm->time_compression = compression;

	return;
}

/*
 *	Procedure to update all related resources on the given
 *	SFMRealmStruct. Including its timming and SFMModels.
 */
void SFMUpdateRealm(SFMRealmStruct *realm, SFMTime lapsed_ms)
{
	int m_num;
	SFMModelStruct *m;


	if(realm == NULL)
	    return;

	SFMSetTimming(realm, lapsed_ms);

	/* Update each model in the realm. */
	for(m_num = 0; m_num < realm->total_models; m_num++)
	{
	    m = realm->model[m_num];
	    if(m == NULL)
		continue;


/* Need to work on this. */

	}


	return;
}
