/*
 * Copyright (C) 2009-2016 Alistair Neil <info@dazzleships.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package lib;

/**
 *
 * @author Alistair Neil <info@dazzleships.net>
 */
public class LicenseDialog extends javax.swing.JDialog {

    private String strTransUrl;

    /**
     * Creates new License Dialog
     *
     * @param parent
     * @param modal
     */
    public LicenseDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        jTextAreaLicense.setCaretPosition(0);
        jButtonTranslations.setVisible(false);
    }

    /**
     * Set the browser url for unnoficial translation
     *
     * @param url
     */
    public void setTranslationURL(String url) {
        strTransUrl = url;
        jButtonTranslations.setVisible(url != null);
    }

    /**
     * Get the license text
     *
     * @return Text
     */
    public String getLicenseText() {
        return jTextAreaLicense.getText();
    }

    /**
     * Set the license text
     *
     * @param text
     */
    public void setLicenseText(String text) {
        jTextAreaLicense.setText(text);
        jTextAreaLicense.setCaretPosition(0);
    }

    /**
     * Set the text on the Close button
     *
     * @param text
     */
    public void setButtonCloseText(String text) {
        jButtonClose.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaLicense = new javax.swing.JTextArea();
        jButtonClose = new javax.swing.JButton();
        jButtonTranslations = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);

        jTextAreaLicense.setEditable(false);
        jTextAreaLicense.setColumns(40);
        jTextAreaLicense.setLineWrap(true);
        jTextAreaLicense.setRows(20);
        jTextAreaLicense.setText("\n");
        jTextAreaLicense.setWrapStyleWord(true);
        jScrollPane1.setViewportView(jTextAreaLicense);

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("resources/MessagesBundle"); // NOI18N
        jButtonTranslations.setText(bundle.getString("button_translations")); // NOI18N
        jButtonTranslations.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonTranslationsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonTranslations)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonClose)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonTranslations))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        dispose();
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonTranslationsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonTranslationsActionPerformed
        Utilities.openFileExternally(strTransUrl);
    }//GEN-LAST:event_jButtonTranslationsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonTranslations;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextAreaLicense;
    // End of variables declaration//GEN-END:variables
}
