/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QSpinBox>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include <QTreeWidget>
#include <QComboBox>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <QPushButton>
#include <QCoreApplication>
#include <QtDebug>
#include  <QColorDialog>

#include "Prn.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
beal::beal(QWidget *felvnl):
	QDialog(felvnl)
<%
	QGridLayout *vnl=new QGridLayout(this);

	QLabel *fldlgz;

	fldlgz=new QLabel(this);
	fldlgz->setText(ts_036);
	vnl->addWidget(fldlgz,0,0,1,1);

	fldlgz=new QLabel(this);
	fldlgz->setText(ts_037);
	vnl->addWidget(fldlgz,1,0,1,1);

	fldlgz=new QLabel(this);
	fldlgz->setText(ts_038);
	vnl->addWidget(fldlgz,2,0,1,1);

	fldlgz=new QLabel(this);
	fldlgz->setText(ts_039);
	vnl->addWidget(fldlgz,3,0,1,1);

	bprl=new QComboBox(this);
	bprl->addItems(QStringList()<<ts_040<<ts_041<<ts_042);
	vnl->addWidget(bprl,0,1,1,1);

	prmz=new QComboBox(this);
	prmz->addItems(QStringList()<<ts_043<<ts_044);
	vnl->addWidget(prmz,1,1,1,1);

	mrtdt=new QSpinBox(this);
	mrtdt->setSuffix(ts_045);
	mrtdt->setRange(0,69 /* 69 hmmm */);
	vnl->addWidget(mrtdt,2,1,1,1);
	mrtdt->setToolTip(ts_046);

	kitzjl=new QPushButton();
	vnl->addWidget(kitzjl,3,1,1,1);
	connect(kitzjl,SIGNAL(clicked()),this,SLOT(irnyjl()));

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	vnl->addItem(spacerItem,4,1,1,1);

	QDialogButtonBox *mgmnkl=new QDialogButtonBox(this);
	mgmnkl->setOrientation(Qt::Horizontal);
	mgmnkl->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);

	vnl->addWidget(mgmnkl,5,0,1,2);

	connect(mgmnkl,SIGNAL(accepted()),this,SLOT(accept()));
	connect(mgmnkl,SIGNAL(rejected()),this,SLOT(reject()));

	QSize size(321,120);
	size=size.expandedTo(minimumSizeHint());
	resize(size);
%>

void beal::irnyjl()
<%
	kidlgz=QColorDialog::getColor(kidlgz,this);
	if(!kidlgz.isValid()) return;
	kitzjl->setText(kidlgz.name());

	QPalette adelk=kitzjl->palette();
	adelk.setBrush(QPalette::Active,QPalette::Button,kidlgz);
	kitzjl->setPalette(adelk);
%>

#include "Prn.moc"

