/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "ProcessDies.h"

ProcessDies::ProcessDies(const int secondsLimit, const short resolution, const pid_t pid) :
	AbstractLoopCondition(secondsLimit, resolution), pid(pid) {

}

void ProcessDies::open() {
#ifdef SA_OPEN_PROCESS
	error = sa_open_process();
#endif
}

bool ProcessDies::evaluate() {
	return sa_get_process(pid, &dst) == ESRCH;
}

void ProcessDies::close() {
#ifdef SA_CLOSE_PROCESS
	sa_close_process();
#endif
}
