//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#include "perfedit.h" 
#include "sequence.h"

#include "snap.xpm"
#include "play2.xpm"
#include "stop.xpm"
#include "expand.xpm"
#include "collapse.xpm"
#include "loop.xpm"
#include "copy.xpm"

using namespace SigC;

perfedit::perfedit( perform *a_perf ) 
: Gtk::Window( GTK_WINDOW_TOPLEVEL )
{

    using namespace Menu_Helpers;

    /* set the performance */
    m_snap = c_ppqn / 4;

    m_mainperf = a_perf;

    /* main window */
    set_title ( "performance edit" );
    set_default_size(700, 400);

    /* tooltips */
    m_tooltips = manage( new Tooltips( ) );

    m_vadjust = manage( new Adjustment(0,0,1,1,1,1 ));
    m_hadjust = manage( new Adjustment(0,0,1,1,1,1 ));

    m_vscroll   =  manage(new VScrollbar( *m_vadjust ));
    m_hscroll   =  manage(new HScrollbar( *m_hadjust ));

    m_perfnames = manage( new perfnames( m_mainperf, m_vadjust ));

    m_perfroll = manage( new perfroll( m_mainperf,
				       m_hadjust,
				       m_vadjust ));

    m_perftime = manage( new perftime( m_mainperf, m_hadjust ));

    /* init table, viewports and scroll bars */
    m_table     = manage( new Table( 6, 3, false));
    m_table->set_border_width( 2 );

    m_hbox      = manage( new HBox( false, 2 ));
    m_hlbox     = manage( new HBox( false, 2 ));
    
    m_hlbox->set_border_width( 2 );

    m_button_grow = manage( new Button());
    m_button_grow->add( *manage( new Arrow( GTK_ARROW_RIGHT, GTK_SHADOW_OUT )));
    m_button_grow->clicked.connect( slot( this, &perfedit::grow)); 
    m_tooltips->set_tip( *m_button_grow, "Increase size of Grid." );


    /* fill table */
  
    m_table->attach( *m_hlbox,  0, 3, 0, 1,  GTK_FILL, 0, 2, 0 );


    m_table->attach( *m_perfnames,    0, 1, 2, 3, 0, GTK_FILL );

    m_table->attach( *m_perftime, 1, 2, 1, 2, GTK_FILL, 0 );
    m_table->attach( *m_perfroll, 1, 2, 2, 3,
 		     GTK_FILL | GTK_SHRINK,  
 		     GTK_FILL | GTK_SHRINK );

    m_table->attach( *m_vscroll, 2, 3, 2, 3, 0, GTK_FILL | GTK_EXPAND  );

    m_table->attach( *m_hbox,  0, 1, 3, 4,  GTK_FILL, 0, 0, 2 );
    m_table->attach( *m_hscroll, 1, 2, 3, 4, GTK_FILL | GTK_EXPAND, 0  );
    m_table->attach( *m_button_grow, 2, 3, 3, 4, 0, 0  );

    m_menu_snap =   manage( new Menu());
    m_menu_snap->items().push_back(MenuElem("1",     bind(slot(this,&perfedit::set_snap), c_ppqn * 4  )));
    m_menu_snap->items().push_back(MenuElem("1/2",   bind(slot(this,&perfedit::set_snap), c_ppqn * 2  )));
    m_menu_snap->items().push_back(MenuElem("1/4",   bind(slot(this,&perfedit::set_snap), c_ppqn * 1  )));
    m_menu_snap->items().push_back(MenuElem("1/8",   bind(slot(this,&perfedit::set_snap), c_ppqn / 2  )));
 
    /* snap */
    m_button_snap = manage( new Button());
    m_button_snap->add( *manage( new Pixmap( snap_xpm  )));
    m_button_snap->clicked.connect(  bind<Menu *>( slot( this, &perfedit::popup_menu), m_menu_snap  ));
    m_tooltips->set_tip( *m_button_snap, "Grid snap." );
    m_entry_snap = manage( new Entry());
    m_entry_snap->set_usize( 40, -1 );
    m_entry_snap->set_editable( false );

    /* expand */
    m_button_expand = manage( new Button());
    m_button_expand->add( *manage( new Pixmap( expand_xpm  )));
    m_button_expand->clicked.connect(  slot( this, &perfedit::expand));
    m_tooltips->set_tip( *m_button_expand, "Expand between L and R markers." );

    /* collapse */
    m_button_collapse = manage( new Button());
    m_button_collapse->add( *manage( new Pixmap( collapse_xpm  )));
    m_button_collapse->clicked.connect(  slot( this, &perfedit::collapse));
    m_tooltips->set_tip( *m_button_collapse, "Collapse between L and R markers." );

    /* copy */
    m_button_copy = manage( new Button());
    m_button_copy->add( *manage( new Pixmap( copy_xpm  )));
    m_button_copy->clicked.connect(  slot( this, &perfedit::copy ));
    m_tooltips->set_tip( *m_button_copy, "Expand and copy between L and R markers." );


    m_button_loop = manage( new ToggleButton() );
    m_button_loop->add( *manage( new Pixmap( loop_xpm  )));
    m_button_loop->toggled.connect(  slot( this, &perfedit::set_looped ));
    m_tooltips->set_tip( *m_button_loop, "Play looped between L and R." );


    m_button_stop = manage( new Button() );
    m_button_stop->add( *manage( new Pixmap( stop_xpm  )));
    m_button_stop->clicked.connect( slot( this, &perfedit::stop_playing));
    m_tooltips->set_tip( *m_button_stop, "Stop playing." );

    m_button_play = manage( new Button() );
    m_button_play->add( *manage( new Pixmap( play2_xpm  )));
    m_button_play->clicked.connect(  slot( this, &perfedit::start_playing));
    m_tooltips->set_tip( *m_button_play, "Being playing at L marker." );



  
    m_hbox->pack_start( *m_button_snap , false, false );
    m_hbox->pack_start( *m_entry_snap , false, false );

    m_hlbox->pack_end( *m_button_copy , false, false ); 
    m_hlbox->pack_end( *m_button_expand , false, false );
    m_hlbox->pack_end( *m_button_collapse , false, false );
      

    m_hlbox->pack_start( *m_button_stop , false, false );
    m_hlbox->pack_start( *m_button_play , false, false );
    m_hlbox->pack_start( *m_button_loop , false, false );


    /* add table */
    this->add( *m_table );
    /* show everything */
    show_all();

    set_snap(  c_ppqn * 4 );
}
 
 

void 
perfedit::start_playing( void )
{
    m_mainperf->start( true );
}

void 
perfedit::stop_playing( void )
{
    m_mainperf->stop();
}

void
perfedit::collapse( void )
{
    m_mainperf->move_triggers( false );
    m_perfroll->queue_draw();
}

void
perfedit::copy( void )
{
    m_mainperf->copy_triggers(  );
    m_perfroll->queue_draw();
}

void 
perfedit::expand( void )
{
    m_mainperf->move_triggers( true );
    m_perfroll->queue_draw();
}

void 
perfedit::set_looped( void )
{
    m_mainperf->set_looping( m_button_loop->get_active());
}

 
void
perfedit::popup_menu(Menu *a_menu)
{
    a_menu->popup(0,0);
}


void 
perfedit::set_snap( int a_snap  )
{
    char b[10];
    sprintf( b, "1/%d",   c_ppqn * 4 / a_snap );
    m_entry_snap->set_text(b);
    
    m_snap = a_snap;
    m_perfroll->set_snap( m_snap );
}


void 
perfedit::realize_impl()
{
    // we need to do the default realize
    Gtk::Window::realize_impl();

    Gtk::Main::timeout.connect(slot(this,&perfedit::timeout ), c_redraw_ms);
 
}


void
perfedit::grow()
{
    m_perfroll->increment_size();
    m_perftime->increment_size();
}

int
perfedit::timeout( void )
{
    m_perfroll->draw_progress();
   
    return true;
}

perfedit::~perfedit()
{

}





int 
perfedit::delete_event_impl(GdkEventAny *a_event)
{
    return false;
}

