//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------


#ifndef SEQ24_PERFEDIT
#define SEQ24_PERFEDIT

#include "sequence.h"
#include "perform.h"

#include <gtk--/adjustment.h>
#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/widget.h>
#include <gtk--/scrollbar.h>
#include <gtk--/viewport.h>
#include <gtk--/combo.h>
#include <gtk--/label.h>
#include <gtk--/toolbar.h>
#include <gtk--/optionmenu.h> 
#include <gtk--/togglebutton.h>
#include <gtk--/invisible.h>
#include <gtk--/separator.h> 
#include <gtk--/pixmap.h> 
#include <gtk--/tooltips.h>
#include <gtk--/invisible.h>
#include <gtk--/arrow.h>

#include <list>
#include <string>

#include "globals.h"
#include "mainwid.h"
#include "perfnames.h"
#include "perfroll.h"
#include "perftime.h"

using namespace Gtk;
using namespace SigC;

/* has a seqroll and paino roll */
class perfedit : public Gtk::Window
{
   
 private:
 
    perform    *m_mainperf;

    Table      *m_table;

    VScrollbar *m_vscroll;
    HScrollbar *m_hscroll;

    Adjustment *m_vadjust;
    Adjustment *m_hadjust;


    perfnames  *m_perfnames;
    perfroll   *m_perfroll;
    perftime   *m_perftime;

    Menu       *m_menu_snap;
    Button     *m_button_snap;
    Entry      *m_entry_snap;

    Button     *m_button_stop;
    Button     *m_button_play;
    ToggleButton *m_button_loop;

    Button     *m_button_expand;
    Button     *m_button_collapse;
    Button     *m_button_copy;

    Button     *m_button_grow;

    HBox       *m_hbox;
    HBox       *m_hlbox;

    Tooltips    *m_tooltips;

     /* set snap to in pulses */
    int         m_snap;

    void set_snap( int a_snap );
    void grow( void );

    void realize_impl();

    void  start_playing( void );
    void  stop_playing( void );

    void set_looped( void );

    void expand( void );
    void collapse( void );
    void copy( void );

    void popup_menu(Menu *a_menu);

    int timeout( void );

    int delete_event_impl(GdkEventAny *a_event);

 public:

    perfedit( perform *a_perf  );

    ~perfedit(  );



 
};











#endif
