// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CompareTypeModExpandImpl_

template <typename TModExpand, typename THost, typename TRight, typename TCompareHostRight> struct CompareTypeModExpandImpl_;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(467)

//____________________________________________________________________________
// ConvertImplModExpand_

template <int SIZE_OF_SOURCE> struct ConvertImplModExpand_;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(251)

//____________________________________________________________________________
// FunctorComplement

template <typename TValue> struct FunctorComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(127)

//____________________________________________________________________________
// FunctorConvert

template <typename InType, typename OutType> struct FunctorConvert;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(101)

//____________________________________________________________________________
// FunctorLowcase

template <typename InType, typename Result > struct FunctorLowcase;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(76)

//____________________________________________________________________________
// FunctorUpcase

template <typename InType, typename Result > struct FunctorUpcase;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(56)

//____________________________________________________________________________
// ModExpand

template <char CHAR, typename TSpec > struct ModExpand;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(62)

//____________________________________________________________________________
// ModReverse

struct ModReverse;       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(61)

//____________________________________________________________________________
// ModifiedIterator

template <typename THost, typename TSpec > class ModifiedIterator;       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(59)

//____________________________________________________________________________
// ModifiedString

template <typename THost, typename TSpec > class ModifiedString;       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(56)
template <typename THost, typename TSpec> class ModifiedString;       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(186)

//____________________________________________________________________________
// TranslateTableDna5ToDna5Complement_

template <typename T > struct TranslateTableDna5ToDna5Complement_;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(132)

//____________________________________________________________________________
// TranslateTableRna5ToRna5Complement_

template <typename T > struct TranslateTableRna5ToRna5Complement_;       	// "seqan-1.3.1/seqan/modifier/modifier_functors.h"(143)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// AlphabetConversionTable_

template <typename TTarget, typename TSource> struct AlphabetConversionTable_;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(703)

//____________________________________________________________________________
// AlphabetOrdTable_

template <typename TSource> struct AlphabetOrdTable_;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(745)

//____________________________________________________________________________
// ModView

template <typename TFunctor> struct ModView;       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(57)

//____________________________________________________________________________
// ModViewCargo

template <typename TFunctor> struct ModViewCargo;       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(60)

//____________________________________________________________________________
// ModifiedAlphabet

template <typename THost, typename TSpec> class ModifiedAlphabet;       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(56)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Dna5StringComplement

typedef ModifiedString<Dna5String, ModView< FunctorComplement<Dna5> > > Dna5StringComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(51)

//____________________________________________________________________________
// Dna5StringReverse

typedef ModifiedString<Dna5String, ModReverse> Dna5StringReverse;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(58)

//____________________________________________________________________________
// Dna5StringReverseComplement

typedef ModifiedString< ModifiedString< Dna5String, ModView< FunctorComplement<Dna5> > >, ModReverse > Dna5StringReverseComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(76)

//____________________________________________________________________________
// DnaStringComplement

typedef ModifiedString<DnaString, ModView< FunctorComplement<Dna> > > DnaStringComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(50)

//____________________________________________________________________________
// DnaStringReverse

typedef ModifiedString<DnaString, ModReverse> DnaStringReverse;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(57)

//____________________________________________________________________________
// DnaStringReverseComplement

typedef ModifiedString< ModifiedString<DnaString, ModView< FunctorComplement<Dna> > >, ModReverse > DnaStringReverseComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(71)

//____________________________________________________________________________
// ModComplementDna

typedef ModView< FunctorComplement<Dna> > ModComplementDna;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(43)

//____________________________________________________________________________
// ModComplementDna5

typedef ModView< FunctorComplement<Dna5> > ModComplementDna5;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(44)

//____________________________________________________________________________
// ModComplementRna

typedef ModView< FunctorComplement<Rna> > ModComplementRna;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(45)

//____________________________________________________________________________
// ModComplementRna5

typedef ModView< FunctorComplement<Rna5> > ModComplementRna5;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(46)

//____________________________________________________________________________
// Rna5StringComplement

typedef ModifiedString<Rna5String, ModView< FunctorComplement<Rna5> > > Rna5StringComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(53)

//____________________________________________________________________________
// Rna5StringReverse

typedef ModifiedString<Rna5String, ModReverse> Rna5StringReverse;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(60)

//____________________________________________________________________________
// Rna5StringReverseComplement

typedef ModifiedString< ModifiedString< Rna5String, ModView< FunctorComplement<Rna5> > >, ModReverse > Rna5StringReverseComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(86)

//____________________________________________________________________________
// RnaStringComplement

typedef ModifiedString<RnaString, ModView< FunctorComplement<Rna> > > RnaStringComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(52)

//____________________________________________________________________________
// RnaStringReverse

typedef ModifiedString<RnaString, ModReverse> RnaStringReverse;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(59)

//____________________________________________________________________________
// RnaStringReverseComplement

typedef ModifiedString< ModifiedString<RnaString, ModView< FunctorComplement<Rna> > >, ModReverse > RnaStringReverseComplement;       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(81)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _assignModifiedIterator

template <typename TTarget, typename TSource> inline void _assignModifiedIterator(TTarget &me, TSource &_origin, True);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(309)
template <typename TTarget, typename TSource> inline void _assignModifiedIterator(TTarget &me, TSource &_origin, False);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(316)

//____________________________________________________________________________
// _copyCargo

template <typename TDest, typename TSource> inline void _copyCargo(TDest & me, TSource & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(254)

//____________________________________________________________________________
// _copyCargoImpl

template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest &, TSource &, False const);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(245)
template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest & me, TSource & _origin, True const);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(248)

//____________________________________________________________________________
// _dataHost

template <typename THost, typename TSpec> inline Holder<THost> & _dataHost(ModifiedString<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(211)
template <typename THost, typename TSpec> inline Holder<THost> const & _dataHost(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(219)
template <typename THost, typename TSpec> inline Holder<THost, Simple> & _dataHost(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(208)
template <typename THost, typename TSpec> inline Holder<THost, Simple> const & _dataHost(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(216)

//____________________________________________________________________________
// _initializeAlphabetConversionTable

template <typename THost, char CHAR, typename TSpec, typename TSource> inline void _initializeAlphabetConversionTable(ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > * buf, TSource const &);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(231)
template <typename TTarget, typename THost, char CHAR, typename TSpec> inline void _initializeAlphabetConversionTable(TTarget * buf, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const &);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(342)

//____________________________________________________________________________
// _initializeAlphabetOrdTable

template <typename TTarget, typename THost, char CHAR, typename TSpec> inline void _initializeAlphabetOrdTable(TTarget * buf, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const &);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(363)

//____________________________________________________________________________
// _internalCreateChar

template <typename TValue, typename TNum> inline TValue _internalCreateChar(TValue const &, TNum i);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(208)
template <typename TValue, typename TSpec, typename TNum> inline SimpleType<TValue, TSpec> _internalCreateChar(SimpleType<TValue, TSpec> const &, TNum i);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(215)

//____________________________________________________________________________
// _internalOrdValue

template <typename THost, char CHAR, typename TSpec> inline unsigned _internalOrdValue(ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & c);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(448)

//____________________________________________________________________________
// assign

template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(264)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(273)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(282)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(290)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(323)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(331)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(339)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(347)

//____________________________________________________________________________
// atBegin

template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(616)
template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(626)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(634)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(643)
template <typename THost, typename TContainer> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(316)
template <typename THost> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(324)

//____________________________________________________________________________
// atEnd

template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(656)
template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(666)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(674)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(683)
template <typename THost, typename TContainer> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me, TContainer const & );       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(337)
template <typename THost> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(345)

//____________________________________________________________________________
// begin

template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(412)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type begin(ModifiedString<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(421)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(430)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(442)
template <typename THost, typename TTag > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type begin(ModifiedString<THost, ModReverse> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(463)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type begin(ModifiedString<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(472)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(481)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(490)

//____________________________________________________________________________
// cargo

template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> >::Type >::Type cargo(ModifiedString<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(227)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> const>::Type >::Type cargo(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(235)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> >::Type >::Type cargo(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(224)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> const>::Type >::Type cargo(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(232)

//____________________________________________________________________________
// complement

template <typename TSequence > inline void complement(TSequence & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(106)
template <typename TSequence > inline void complement(TSequence const & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(113)
template <typename TSequence, typename TSpec > inline void complement(StringSet<TSequence, TSpec> & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(127)
template <typename TSequence, typename TSpec > inline void complement(StringSet<TSequence, TSpec> const & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(136)

//____________________________________________________________________________
// container

template <typename THost, typename TSpec> inline typename Container<ModifiedIterator<THost, TSpec> >::Type container(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(244)
template <typename THost, typename TSpec> inline typename Container<ModifiedIterator<THost, TSpec> const>::Type container(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(255)

//____________________________________________________________________________
// convertImpl

template <typename THost, char CHAR, typename TSpec, typename T, typename TSource> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, TSource>::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const convert_, TSource const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(291)
template <typename THost, char CHAR, typename TSpec, typename T, typename TSourceValue, typename TSourceSpec> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, SimpleType<TSourceValue, TSourceSpec> >::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, SimpleType<TSourceValue, TSourceSpec> const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(300)
template <char CHAR, typename TSpec, typename T, typename TSourceValue, typename TSourceSpec> inline typename Convert<ModifiedAlphabet<SimpleType<TSourceValue, TSourceSpec>, ModExpand<CHAR, TSpec> >, SimpleType<TSourceValue, TSourceSpec> >::Type convertImpl(Convert<ModifiedAlphabet<SimpleType<TSourceValue, TSourceSpec>, ModExpand<CHAR, TSpec> >, T> const, SimpleType<TSourceValue, TSourceSpec> const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(313)
template <typename THost, char CHAR, typename TSpec, typename T, typename TSpec2> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, Proxy<TSpec2> >::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, Proxy<TSpec2> const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(329)
template <typename TTarget, typename T, typename THost, char CHAR, typename TSpec> inline typename Convert<TTarget, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > >::Type convertImpl(Convert<TTarget, T> const, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(390)
template <typename TTargetValue, typename TTargetSpec, char CHAR, typename TSpec> inline typename Convert<SimpleType<TTargetValue, TTargetSpec>, ModifiedAlphabet<SimpleType<TTargetValue, TTargetSpec>, ModExpand<CHAR, TSpec> > >::Type convertImpl(Convert<SimpleType<TTargetValue, TTargetSpec>, ModifiedAlphabet<SimpleType<TTargetValue, TTargetSpec>, ModExpand<CHAR, TSpec> > > const, ModifiedAlphabet<SimpleType<TTargetValue, TTargetSpec>, ModExpand<CHAR, TSpec> > const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(402)
template <typename THost, char CHAR, typename TSpec, typename T> inline ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(438)

//____________________________________________________________________________
// end

template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type end(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(458)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type end(ModifiedString<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(467)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(476)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(485)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type end(ModifiedString<THost, ModReverse> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(503)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type end(ModifiedString<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(512)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(521)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(530)

//____________________________________________________________________________
// goBegin

template <typename THost, typename TSpec, typename TContainer> inline void goBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(516)
template <typename THost, typename TSpec> inline void goBegin(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(524)
template <typename THost> inline void goBegin(ModifiedIterator<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(169)

//____________________________________________________________________________
// goEnd

template <typename THost, typename TSpec, typename TContainer> inline void goEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(537)
template <typename THost, typename TSpec> inline void goEnd(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(545)
template <typename THost> inline void goEnd(ModifiedIterator<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(156)

//____________________________________________________________________________
// goNext

template <typename THost, typename TSpec> inline void goNext(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(400)
template <typename THost> inline void goNext(ModifiedIterator<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(126)

//____________________________________________________________________________
// goPrevious

template <typename THost, typename TSpec> inline void goPrevious(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(432)
template <typename THost> inline void goPrevious(ModifiedIterator<THost, ModReverse> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(141)

//____________________________________________________________________________
// id

template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(639)
template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(646)

//____________________________________________________________________________
// length

template <typename THost, typename TSpec > inline typename Size< ModifiedString<THost, TSpec> >::Type length(ModifiedString<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(401)

//____________________________________________________________________________
// operator!=

template <typename THost, typename TSpec, typename TRight > inline bool operator!=(ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(519)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator!= (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(528)
template <typename THost, typename TSpec> inline bool operator!= (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(585)

//____________________________________________________________________________
// operator*

template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type operator* (ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(378)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type operator* (ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(386)

//____________________________________________________________________________
// operator+

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator+ (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(471)

//____________________________________________________________________________
// operator++

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator++ (ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(408)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> operator++ (ModifiedIterator<THost, TSpec> & me, int);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(417)

//____________________________________________________________________________
// operator+=

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator+= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(463)
template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator+= (ModifiedIterator<THost, ModReverse> & me, TDelta delta_);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(188)

//____________________________________________________________________________
// operator-

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator- (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(493)
template <typename THost, typename TSpec> inline typename Difference< ModifiedIterator<THost, TSpec> >::Type operator- (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(503)
template <typename THost> inline typename Difference< ModifiedIterator<THost, ModReverse> >::Type operator- (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(241)

//____________________________________________________________________________
// operator--

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator-- (ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(440)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> operator-- (ModifiedIterator<THost, TSpec> & me, int);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(449)

//____________________________________________________________________________
// operator-=

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator-= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(485)
template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator-= (ModifiedIterator<THost, ModReverse> & me, TDelta delta);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(222)

//____________________________________________________________________________
// operator<

template <typename THost, typename TSpec, typename TRight> inline bool operator< (ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(540)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator< (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(548)
template <typename THost, typename TSpec> inline bool operator< (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(596)
template <typename THost> inline bool operator< (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(303)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec > inline TStream & operator<< (TStream & target, ModifiedString<THost, TSpec> const & source);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(617)

//____________________________________________________________________________
// operator<=

template <typename THost, typename TSpec, typename TRight> inline bool operator<= (ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(559)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator<= (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(567)

//____________________________________________________________________________
// operator==

template <typename THost, typename TSpec, typename TRight > inline bool operator== (ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(498)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator== (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(507)
template <typename THost, typename TSpec> inline bool operator== (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(579)
template <typename THost> inline bool operator== (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(292)

//____________________________________________________________________________
// operator>

template <typename THost, typename TSpec, typename TRight> inline bool operator> (ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(578)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator> (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(586)
template <typename THost, typename TSpec> inline bool operator> (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(603)

//____________________________________________________________________________
// operator>=

template <typename THost, typename TSpec, typename TRight> inline bool operator>= (ModifiedString<THost, TSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(597)
template <typename TLeftValue, typename THost, typename TSpec > inline bool operator>= (TLeftValue * left, ModifiedString<THost, TSpec> const & right);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(605)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec > inline TStream & operator>> (TStream & source, ModifiedString<THost, TSpec> & target);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(628)

//____________________________________________________________________________
// ordValue

template <typename THost, char CHAR, typename TSpec> inline unsigned ordValue(ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & c);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet_expansion.h"(455)

//____________________________________________________________________________
// position

template <typename THost, typename TSpec> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(558)
template <typename THost, typename TSpec, typename TContainer> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me, TContainer const &cont);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(567)
template <typename THost> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(255)
template <typename THost, typename TContainer> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me, TContainer const &cont);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(266)

//____________________________________________________________________________
// reverse

template <typename TSequence > inline void reverse(TSequence & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(558)
template <typename TSequence, typename TSpec > inline void reverse(StringSet<TSequence, TSpec> & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(592)
template <typename TSequence, typename TSpec > inline void reverse(StringSet<TSequence, TSpec> const & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(601)
template <typename TValue> inline void reverse(std::list<TValue> & list);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(610)

//____________________________________________________________________________
// reverseComplement

template <typename TSequence > inline void reverseComplement(TSequence & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(158)
template <typename TSequence > inline void reverseComplement(TSequence const & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(167)
template <typename TSequence, typename TSpec > inline void reverseComplement(StringSet<TSequence, TSpec> & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(182)
template <typename TSequence, typename TSpec > inline void reverseComplement(StringSet<TSequence, TSpec> const & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(192)

//____________________________________________________________________________
// reverseString

template <typename THost> inline ModifiedString<THost, ModReverse> reverseString(THost const & host);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(621)

//____________________________________________________________________________
// setContainer

template <typename TIteratorHost, typename TSpec, typename TStringHost> inline void setContainer( ModifiedIterator<TIteratorHost, TSpec> & me, ModifiedString<TStringHost, TSpec> & cont);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(270)
template <typename TIteratorHost, typename TSpec, typename TStringHost> inline void setContainer( ModifiedIterator<TIteratorHost, TSpec> & me, ModifiedString<TStringHost, TSpec> const & cont);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(280)
template <typename THost, typename TSpec, typename TContainer> inline void setContainer(ModifiedIterator<THost, TSpec> & me, TContainer & cont);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(288)

//____________________________________________________________________________
// setPosition

template <typename THost, typename TPosition> inline void setPosition(ModifiedIterator<THost, ModReverse> const & me, TPosition pos);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(281)

//____________________________________________________________________________
// setValue

template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(322)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(331)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(344)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(355)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(364)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(372)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(381)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 const & _origin);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(389)

//____________________________________________________________________________
// toLower

template <typename TSequence > inline void toLower(TSequence & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(216)
template <typename TSequence > inline void toLower(TSequence const & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(224)
template <typename TSequence, typename TSpec > inline void toLower(StringSet<TSequence, TSpec> & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(238)
template <typename TSequence, typename TSpec > inline void toLower(StringSet<TSequence, TSpec> const & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(248)

//____________________________________________________________________________
// toUpper

template <typename TSequence > inline void toUpper(TSequence & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(270)
template <typename TSequence > inline void toUpper(TSequence const & sequence);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(278)
template <typename TSequence, typename TSpec > inline void toUpper(StringSet<TSequence, TSpec> & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(292)
template <typename TSequence, typename TSpec > inline void toUpper(StringSet<TSequence, TSpec> const & stringSet);       	// "seqan-1.3.1/seqan/modifier/modifier_shortcuts.h"(302)

//____________________________________________________________________________
// value

template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> >::Type value(ModifiedString<THost, TSpec> & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(303)
template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> const >::Type value(ModifiedString<THost, TSpec> const & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_string.h"(311)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type value(ModifiedIterator<THost, TSpec> & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(361)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type value(ModifiedIterator<THost, TSpec> const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_iterator.h"(370)
template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> >::Type value(ModifiedString<THost, ModReverse> & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(444)
template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> const>::Type value(ModifiedString<THost, ModReverse> const & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_reverse.h"(452)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _initializeAlphabetConversionTable

template <typename TTarget, typename TSource> inline void _initializeAlphabetConversionTable(TTarget *, TSource const &);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(694)

//____________________________________________________________________________
// _initializeAlphabetOrdTable

template <typename TTarget, typename TSource> inline void _initializeAlphabetOrdTable(TTarget *, TSource const &);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(736)

//____________________________________________________________________________
// assignModViewFunctor

template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedIterator<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(205)
template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedString<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(357)

//____________________________________________________________________________
// convert

template <typename TSequence, typename TFunctor > inline void convert(TSequence & sequence, TFunctor const &F);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(373)
template <typename TSequence, typename TFunctor > inline void convert(TSequence const & sequence, TFunctor const &F);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(397)

//____________________________________________________________________________
// convertImpl

template <typename TTarget, typename T, typename THost, typename TSpec> inline typename Convert<TTarget, THost>::Type convertImpl(Convert<TTarget, T> const convert_, ModifiedAlphabet<THost, TSpec> const & source_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(83)

//____________________________________________________________________________
// getValue

template <typename THost, typename TFunctor> inline typename GetValue<ModifiedIterator<THost, ModView<TFunctor> > >::Type getValue(ModifiedIterator<THost, ModView<TFunctor> > & me);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(184)
template <typename THost, typename TFunctor> inline typename GetValue<ModifiedIterator<THost, ModView<TFunctor> > const>::Type getValue(ModifiedIterator<THost, ModView<TFunctor> > const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(192)
template <typename THost, typename TFunctor, typename TPos> inline typename GetValue<ModifiedString<THost, ModView<TFunctor> > >::Type getValue(ModifiedString<THost, ModView<TFunctor> > & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(336)
template <typename THost, typename TFunctor, typename TPos> inline typename GetValue<ModifiedString<THost, ModView<TFunctor> > const>::Type getValue(ModifiedString<THost, ModView<TFunctor> > const & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(344)

//____________________________________________________________________________
// operator!=

template <typename THost, typename TSpec, typename TRight> inline bool operator!=(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(214)
template <typename TLeft, typename THost, typename TSpec> inline bool operator!=(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(225)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator!=(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(236)
template <typename THost, typename TSpec> inline bool operator!=(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(248)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator!=(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(259)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator!=(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(270)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator!=(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(284)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator!=(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(295)

//____________________________________________________________________________
// operator<

template <typename THost, typename TSpec, typename TRight> inline bool operator<(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(406)
template <typename TLeft, typename THost, typename TSpec> inline bool operator<(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(417)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator<(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(428)
template <typename THost, typename TSpec> inline bool operator<(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(440)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(451)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(462)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(476)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(487)

//____________________________________________________________________________
// operator<=

template <typename THost, typename TSpec, typename TRight> inline bool operator<=(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(310)
template <typename TLeft, typename THost, typename TSpec> inline bool operator<=(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(321)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator<=(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(332)
template <typename THost, typename TSpec> inline bool operator<=(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(344)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<=(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(355)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<=(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(366)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<=(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(380)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<=(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(391)

//____________________________________________________________________________
// operator==

template <typename THost, typename TSpec, typename TRight> inline bool operator==(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(118)
template <typename TLeft, typename THost, typename TSpec> inline bool operator==(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(129)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator==(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(140)
template <typename THost, typename TSpec> inline bool operator==(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(152)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator==(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(163)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator==(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(174)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator==(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(188)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator==(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(199)

//____________________________________________________________________________
// operator>

template <typename THost, typename TSpec, typename TRight> inline bool operator>(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(598)
template <typename TLeft, typename THost, typename TSpec> inline bool operator>(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(609)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator>(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(620)
template <typename THost, typename TSpec> inline bool operator>(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(632)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(643)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(654)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(668)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(679)

//____________________________________________________________________________
// operator>=

template <typename THost, typename TSpec, typename TRight> inline bool operator>=(ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(502)
template <typename TLeft, typename THost, typename TSpec> inline bool operator>=(TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(513)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator>=(ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(524)
template <typename THost, typename TSpec> inline bool operator>=(ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(536)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>=(SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(547)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>=(ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(558)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>=(Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(572)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>=(ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(583)

//____________________________________________________________________________
// ordValue

template <typename THost, typename TSpec> inline unsigned ordValue(ModifiedAlphabet<THost,TSpec> const &c);       	// "seqan-1.3.1/seqan/modifier/modifier_alphabet.h"(92)

//____________________________________________________________________________
// value

template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > >::Type value(ModifiedIterator<THost, ModView<TFunctor> > & me);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(161)
template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > const>::Type value(ModifiedIterator<THost, ModView<TFunctor> > const & me);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(170)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > >::Type value(ModifiedString<THost, ModView<TFunctor> > & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(313)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > const>::Type value(ModifiedString<THost, ModView<TFunctor> > const & me, TPos pos);       	// "seqan-1.3.1/seqan/modifier/modifier_view.h"(322)

} //namespace seqan

#endif

