// 
// Copyright(c) 2009 Syntext, Inc. All Rights Reserved.
// Contact: info@syntext.com, http://www.syntext.com
// 
// This file is part of Syntext Serna XML Editor.
// 
// COMMERCIAL USAGE
// Licensees holding valid Syntext Serna commercial licenses may use this file
// in accordance with the Syntext Serna Commercial License Agreement provided
// with the software, or, alternatively, in accorance with the terms contained
// in a written agreement between you and Syntext, Inc.
// 
// GNU GENERAL PUBLIC LICENSE USAGE
// Alternatively, this file may be used under the terms of the GNU General 
// Public License versions 2.0 or 3.0 as published by the Free Software 
// Foundation and appearing in the file LICENSE.GPL included in the packaging 
// of this file. In addition, as a special exception, Syntext, Inc. gives you
// certain additional rights, which are described in the Syntext, Inc. GPL 
// Exception for Syntext Serna Free Edition, included in the file 
// GPL_EXCEPTION.txt in this package.
// 
// You should have received a copy of appropriate licenses along with this 
// package. If not, see <http://www.syntext.com/legal/>. If you are unsure
// which license is appropriate for your use, please contact the sales 
// department at sales@syntext.com.
// 
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// 
#ifndef UI_PROP_SYNCHER_H_
#define UI_PROP_SYNCHER_H_

#include "ui/ui_defs.h"
#include "ui/UiItemWatcher.h"
#include "ui/UiPropTreeHolder.h"

namespace Sui {

class Item;

class UI_EXPIMP PropSyncher : public Common::RefCounted<>,
                              protected ItemWatcher,
                              protected Common::PropertyNodeWatcher {
public:
    PropSyncher(Common::PropertyNode* spec, PropertyTreeHolder* holder);

    void                    subscribe(Item* item);

protected:
    Common::String          masterValue(const Common::String& toValue = 
                                        Common::String()) const;
    virtual void            propertyChanged(Common::PropertyNode* prop);

    virtual void            childInserted(Item* item);
    virtual void            childRemoved(Item* parent, Item* item);

    virtual void            inserted(Item* item);
    virtual void            removed(Item* item);
    void                    subscribe();
    
protected:
    Common::PropertyNodePtr spec_;
    bool                    doNotify_;
    PropertyTreeHolder*     holder_;
    Common::PropertyNodePtr toProp_;
    PropertyTreeHolder*     from_;
    Common::PropertyNodePtr fromProp_;
};

} // namespace Sui

#endif // UI_PROP_SYNCHER_H_
