/****************************************************************************
 * Driver for Solarflare network controllers
 *           (including support for SFE4001 10GBT NIC)
 *
 * Copyright 2007:	Solarflare Communications Inc,
 *                      9501 Jeronimo Road, Suite 250,
 *                      Irvine, CA 92618, USA
 *
 * Developed by Solarflare Communications <linux-net-drivers@solarflare.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 ****************************************************************************
 */

#ifdef EFX_NOT_UPSTREAM

#include "net_driver.h"

#ifndef PCI_CAP_ID_EXP
#define PCI_CAP_ID_EXP		0x10    /* PCI Express */
#endif

#ifndef PCI_CAP_ID_MSIX
#define  PCI_CAP_ID_MSIX	0x11
#endif

/* Cope with small changes in PCI constants between minor kernel revisions */
#include <linux/pci.h>
#if PCI_X_STATUS != 4
#undef PCI_X_STATUS
#define PCI_X_STATUS 4
#undef PCI_X_STATUS_MAX_SPLIT
#define PCI_X_STATUS_MAX_SPLIT 0x03800000
#endif

/* Correct PCI-X maximum split count
 *
 * SFC BUG 4587: some BIOSes will try to assign a maximum split value
 * higher than the card actually supports. Out of range writes will be ignored
 * for Falcon >=B0 silicon
 */
int falcon_set_pci_max_split(struct efx_nic *efx)
{
	int pcixcap_offset;
	u16 pcix_cmd;
	u32 pcix_status;
	unsigned int conf_max_split, des_max_split;
	int rc;

	/* Find PCI-X capability */
	pcixcap_offset = pci_find_capability(efx->pci_dev, PCI_CAP_ID_PCIX);
	if (!pcixcap_offset) {
		/* Not an error if there is no PCI-X capability (e.g. PCIe) */
		return 0;
	}

	/* Get configured and designed max_split values */
	if ((rc = pci_read_config_word(efx->pci_dev,
				       (pcixcap_offset + PCI_X_CMD),
				       &pcix_cmd)) != 0)
		return rc;
	conf_max_split = ((pcix_cmd & PCI_X_CMD_MAX_SPLIT) >> 4);
	if ((rc = pci_read_config_dword(efx->pci_dev,
					(pcixcap_offset + PCI_X_STATUS),
					&pcix_status)) != 0)
		return rc;
	des_max_split = ((pcix_status & PCI_X_STATUS_MAX_SPLIT) >> 23);

	/* Correct if necessary */
	if (conf_max_split > des_max_split) {
		EFX_LOG(efx, "reducing PCI_X_CMD_MAX_SPLIT from %d to "
			"%d\n", conf_max_split, des_max_split);
		pcix_cmd &= ~PCI_X_CMD_MAX_SPLIT;
		pcix_cmd |= (des_max_split << 4);
	}

	/* Write updated PCI_X_CMD register */
	if ((rc = pci_write_config_word(efx->pci_dev,
					(pcixcap_offset + PCI_X_CMD),
					pcix_cmd)) != 0)
		return rc;

	return 0;
}

#endif /* EFX_NOT_UPSTREAM */
