/* @(#)mem.c	1.4 04/10/10 Copyright 1998-2004 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)mem.c	1.4 04/10/10 Copyright 1998-2004 J. Schilling";
#endif
/*
 *	Memory handling with error checking
 *
 *	Copyright (c) 1998-2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <strdefs.h>
#include <standard.h>
#include <schily.h>
#include <nlsdefs.h>
#include "mem.h"

EXPORT	void	*__malloc	__PR((size_t size, char *msg));
EXPORT	void	*__realloc	__PR((void *ptr, size_t size, char *msg));
EXPORT	char	*__savestr	__PR((const char *s));

EXPORT void *
__malloc(size, msg)
	size_t	size;
	char	*msg;
{
	void	*ret;

	ret = malloc(size);
	if (ret == NULL) {
		comerr(gettext("Cannot allocate memory for %s.\n"), msg);
		/* NOTREACHED */
	}
	return (ret);
}

EXPORT void *
__realloc(ptr, size, msg)
	void	*ptr;
	size_t	size;
	char	*msg;
{
	void	*ret;

	if (ptr == NULL)
		ret = malloc(size);
	else
		ret = realloc(ptr, size);
	if (ret == NULL) {
		comerr(gettext("Cannot realloc memory for %s.\n"), msg);
		/* NOTREACHED */
	}
	return (ret);
}

EXPORT char *
__savestr(s)
	const char	*s;
{
	char	*ret = __malloc(strlen(s)+1, "saved string");

	strcpy(ret, s);
	return (ret);
}
