/*
 *  Copyright (C) 2004-2013 Savoir-Faire Linux Inc.
 *
 *  Author: Emmanuel Milou <emmanuel.milou@savoirfairelinux.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 *  Additional permission under GNU GPL version 3 section 7:
 *
 *  If you modify this program, or any covered work, by linking or
 *  combining it with the OpenSSL project's OpenSSL library (or a
 *  modified version of that library), containing parts covered by the
 *  terms of the OpenSSL or SSLeay licenses, Savoir-Faire Linux Inc.
 *  grants you additional permission to convey the resulting work.
 *  Corresponding Source for a non-source form of such a combination
 *  shall include the source code for the parts of OpenSSL used as well
 *  as that of the covered work.
 */

#include "numbercleaner.h"
#include <algorithm>

#define INVALID_CHAR " -()"

static void
strip_chars(const std::string &to_strip, std::string &num)
{
    for (const auto &item : to_strip)
        num.erase(std::remove(num.begin(), num.end(), item), num.end());
}

std::string NumberCleaner::clean(std::string to_clean, const std::string &prefix)
{
   size_t pos;
   //Hostname and DNS can have '-'
   if ((pos = to_clean.find("@")) == std::string::npos) {
      strip_chars(INVALID_CHAR, to_clean);
      return to_clean.insert(0, prefix);
   }
   else {
      std::string high = to_clean.substr(0,pos+1);
      strip_chars(INVALID_CHAR, high);
      return high+to_clean.substr(pos+1);
   }
}
