#define USE_PCTR 0
#include "crypt.h"
#include "bench.h"
#include "keyregression.h"

#define MYTIME(code)					\
  __v = get_time ();					\
  code; 						\
  __v = get_time () - __v;				\
  warn ("%s: %" U64F "d " TIME_LABEL "\n", #code, __v);


int
main (int argc, char **argv)
{
  random_update ();

  u_int64_t __v;					\

  // Sample owner
  // Create a chain of length 100K
  MYTIME (keyregression_owner kro (100000));
  BENCH (99998, kro.wind ());
  warn << "kro done\n";

  // Sample member
  // Transfer initial member state (version, stm)
  MYTIME (keyregression kr); 
  chefs_stm stm (kro.stm ());
  MYTIME (kr.update (stm));
  //  BENCH (99999, kr.unwind ());
  BENCH (1000, kr.keyder (1));
  warn << "kr done\n";

  warn << hexdump (kr.keyder (0)->base (), kr.keyder (0)->size ());
  
  rsa_priv x (rsa_keygen (1024));

  /*
e 3
n d38b49aacdb4ad5b6dc3cc23275275d407976f4d776ec7c54f5562361a4adbbdce364780ac9f48b2619d33caac3ffc62d2868bece33c2cd12720f58e384a4e12cf0c972707fd6b19c100b60428bc43385ff8744aacfe03c4bcaf8a3f6a15a9fbb321492ae718ef3ff97da288aaf353651b769664a19484af8a6158b7b56155e9
p e022d1596699413f12dee4551d69fa8c0ef2779b1a7c00f4e4fa96caa38d6dede8901adfcfb29fb4bbaf5ba707036b5581e85cb6212e56f6aeb4640e1fad1a2b
q f19e3381a1d57279cb98c57beeed05bf1ec50d47769b4316722e5aa23ef0fba4921ff96836560c718cdef989c273714665e0c83e77e95765dc2aa76de833ea3b
  */

  /*
  bigint pt (random_bigint (1023));
  bigint ct, pt2;

  BENCH (100, ct = x.encrypt (pt));
  BENCH (100, pt = x.decrypt (ct));

  warn << pt.getstr (10) << "\n";
  ct = x.encrypt (pt);
  warn << ct.getstr (10) << "\n";;
  pt2 = x.decrypt (ct);
  warn << pt2.getstr (10) << "\n";
  */

  return 0;
}
