/*
 * Copyright (C) 2005 Kevin Fu (fubob@mit.edu)
 * Copyright (C) 2000 Kevin Fu (fubob@mit.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "arpc.h"
#include "crypt.h"
#include "sfsro_prot.h"
#include "sfsmisc.h"


class srvcon {
  sfs_connectres conres;
  sfs_fsinfo fsires;
  sfsro_datares sfsrores;

  ptr<axprt_stream> s;
  ptr<aclnt> sfsc;
  ptr<aclnt> sfsroc;

  void fail (int err);
  void init ();
  void getsockres (int fd);
  void sfsconres (clnt_stat);
  void getfsinfores (clnt_stat);
  void getdata (ref<sfsro_getdataargs> gdargs, uint32 num, clnt_stat err);

public:
  srvcon ()
  { init (); }
};


// Trace of 36,273 GETDATA RPCs of SFSRO reading 12,407 8KB files
char trace[][20] = {
#include "chefs-rodb-trace.txt"
};
size_t trace_size = sizeof (trace) / sizeof (trace[0]);
