# format:
#	name:
#		data_class + _type, feature_class + _type(s),
#		available kernel parameters, accuracy
KLIST={
	'AUC':[['rand', 'ushort'], ['simple', 'word'], ['subkernel'], 1e-8],
	'Byte':[['rand', 'ubyte'], ['simple', 'byte'], [], 1e-8],
	'CanberraWord':[['rand', 'ushort'], ['simple', 'word'], ['width'], 1e-12],
	'Char':[['rand', 'character'], ['simple', 'char'], [], 1e-8],
	'Chi2':[['rand', 'double'], ['simple', 'real'], ['width', 'size'], 1e-8],
	'Combined':[['', ''], ['wordstring', ''], ['append_subkernel_weights'], 1e-8],
	'CommUlongString':[['dna', ''], ['string', 'char'],
		['use_sign', 'normalization'], 1e-9],
	'CommWordString':[['dna', ''], ['wordstring', 'char', 'word'],
		['use_sign', 'normalization'], 1e-9],
	'Const':[['rand', 'double'], ['simple', 'real'], ['c'], 0],
	'Custom':[['rand', 'double'], ['simple', 'real'], [], 1e-8],
	'Diag':[['rand', 'double'], ['simple', 'real'], ['diag'], 0],
	'Distance':[['rand', 'double'], ['simple', 'real'], ['distance'], 1e-8],
	'FixedDegreeString':[['dna', ''], ['string', 'char'], ['degree'], 1e-9],
	'Gaussian':[['rand', 'double'], ['simple', 'real'], ['width'], 1e-8],
	'GaussianShift':[['rand', 'double'], ['simple', 'real'],
		['width', 'max_shift', 'shift_step'], 1e-8],
	'HammingWord':[['rand', 'ushort'], ['simple', 'word'],
		['width', 'use_sign'], 1e-14],
	'HistogramWord':[['rand', 'ushort'], ['simple', 'word'],
		['plugin_estimate'], 1e-6],
	'Int':[['rand', 'int'], ['simple', 'int'], [], 1e-8],
	'Linear':[['rand', 'double'], ['simple', 'real'], ['scale'], 1e-8],
	'LinearByte':[['rand', 'ubyte'], ['simple', 'byte'],
		['do_rescale', 'scale'], 1e-8],
	'LinearString':[['dna', ''], ['string', 'char'], ['scale'], 1e-8],
	'LinearWord':[['rand', 'ushort'], ['simple', 'word'],
		['do_rescale', 'scale'], 1e-8],
	'LocalAlignmentString':[['dna', ''], ['string', 'char'], [], 1e-8],
	'LocalityImprovedString':[['dna', ''], ['string', 'char'],
		['length', 'inner_degree', 'outer_degree'], 1e-8],
	'ManhattanWord':[['rand', 'ushort'], ['simple', 'word'], ['width'], 1e-13],
	'MindyGram':[['', ''], ['mindy', ''], ['measure', 'width'], 1e-8],
	'Poly':[['rand', 'double'], ['simple', 'real'],
		['degree', 'inhomogene', 'use_normalization'], 1e-6],
	'PolyMatchString':[['dna', ''], ['string', 'char'],
		['degree', 'inhomogene'], 1e-10],
	'PolyMatchWord':[['rand', 'ushort'], ['simple', 'word'],
		['degree', 'inhomogene'], 1e-10],
	'Real':[['rand', 'double'], ['simple', 'real'], [], 1e-8],
	'SalzbergWord':[['rand', 'ushort'], ['simple', 'word'],
		['plugin_estimate'], 1e-6],
	'Short':[['rand', 'ushort'], ['simple', 'short'], [], 1e-8],
	'Sigmoid':[['rand', 'double'], ['simple', 'real'],
		['size', 'gamma_', 'coef0'], 1e-9],
	'SimpleLocalityImprovedString':[['dna', ''], ['string', 'char'],
		['length', 'inner_degree', 'outer_degree'], 1e-15],
	'SparseReal':[['rand', 'double'], ['simple', 'real'], [], 1e-8],
	'SparseGaussian':[['rand', 'double'], ['simple', 'real'],
		['width'], 1e-8],
	'SparseLinear':[['rand', 'double'], ['simple', 'real'],
		['scale'], 1e-8],
	'SparsePoly':[['rand', 'double'], ['simple', 'real'],
		['size', 'degree', 'inhomogene', 'use_normalization'], 1e-8],
	'SparseWord':[['rand', 'double'], ['simple', 'word'], [], 1e-8],
	'StringCharKernel':[['dna', ''], ['string', 'char'], [], 1e-8],
	'StringIntKernel':[['dna', ''], ['string', 'int'], [], 1e-8],
	'StringRealKernel':[['dna', ''], ['string', 'real'], [], 1e-8],
	'StringUlongKernel':[['dna', ''], ['string', 'ulong'], [], 1e-8],
	'StringWordKernel':[['dna', ''], ['string', 'word'], [], 1e-8],
	'Ulong':[['rand', 'double'], ['simple', 'ulong'], [], 1e-8],
	'WeightedDegreePositionString':[['dna', ''], ['string', 'char'],
		['degree', 'weights', 'shift', 'shift_len', 'max_mismatch',
		'use_normalization', 'mkl_stepsize'], 1e-8],
	'WeightedDegreeString':[['dna', ''], ['string', 'char'],
		['degree', 'max_mismatch', 'use_normalization',
		'block_computation', 'mkl_stepsize', 'which_degree', 'weights'],
		1e-10],
	'WeightedCommWordString':[['dna', ''], ['wordstring', 'char', 'word'],
		['use_sign', 'normalization'], 1e-9],
	'Word':[['rand', 'ushort'], ['simple', 'word'], [], 1e-8],
	'WordMatch':[['rand', 'ushort'], ['simple', 'word'],
		['degree', 'do_rescale', 'scale'], 1e-8],
}
