/***************************************************************************
                          album.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "album.h"

#include "directory.h"
#include "directoryview.h"
#include "imageviewer.h"
#include "imagelistview.h"
#include "mainwindow.h"
#include "albumimagefileiconitem.h"

#include <qtextstream.h>
#include <qfile.h>

#include <klocale.h>
#include <kapplication.h>
#include <konq_operations.h>
#include <kurl.h>

Album::Album(Directory * parent, QString filename,
		DirectoryView* dirView, ImageViewer * iv,
		ImageListView * imageList, MainWindow * mw)
	:ListItem(parent, filename, dirView, iv, imageList, mw)
{
	full=this->parent()->fullName()+f.name();
	size=QString("");
	init();
}

Album::~Album()
{
}

void
Album::init()
{
	setPixmap(0, BarIcon("imagegallery", KIcon::SizeSmall ));
	extension = i18n("Album");
	setDropEnabled(true);
}

void
Album::addURL(QStringList lst)
{
	QFile f(fullName());
	if (!f.open(IO_Raw | IO_ReadWrite | IO_Append) )
		return;
	KURL::List list(lst);
	QTextStream stream(&f);
	for (uint i = 0; i < list.count (); i++)
	{
		stream << pathTo(list[i].path()) << '\n';
	}
	
	if(size!="") size=QString("%1").arg(size.toInt()+lst.count());
	repaint();
	f.close();

}
	
QString 
Album::pathTo(QString fileName)
{
	int i=0;
	while(fileName[i] == fullName()[i] && (unsigned int)i<fileName.length() && (unsigned int)i< fullName().length())
		i++;
	if(fileName[i]=='/') i--;
	int pos=fileName.findRev('/', i, false);
	QString rFileName=fileName.right(fileName.length()-pos-1);
	QString rFullName=fullName().right(fullName().length()-pos-1);
	for(i=0; i<rFullName.contains('/', false); i++)
		rFileName="../"+rFileName;
	return rFileName;

}


void
Album::load (bool )
{
	bool hasIm=imageList->hasImages();
	mw->setMessage(i18n("Loading album %1...").arg(text(0)));
	KApplication::setOverrideCursor( waitCursor ); // this might take time
	if(mw->preview())
		imageList->stopLoading();

	QString currentPath=QFileInfo(fullName()).dirPath(true);
	QFile f(fullName());
	if (!f.open(IO_ReadOnly) )
		return;
	QTextStream ts(&f);
	QString lut;
	int i=0;
	AlbumImageFileIconItem *item;
	while(!ts.eof())
	{
		lut=currentPath+'/'+ts.readLine ();
		QFileInfo fi(lut);
		if(fi.exists())
		{
			item=new AlbumImageFileIconItem(imageList, this, QDir::cleanDirPath(lut), iv);
			list.append(item);
			i++;
		}
	}
	f.close();
	
	mw->slotAddImage(i);
	size = QString("%1").arg(i);
	iv->updateStatus();
	repaint();
	kapp->processEvents();

	if(mw->preview()) imageList->slotLoadFirst();
	imageList->sort();
	imageList->arrangeItemsInGrid () ;

	if(!hasIm)
	{
		if(dirView->loadFirstImage())
			imageList->first();
		else
			iv->loadImage();
	}
  
	KApplication::restoreOverrideCursor();	// restore original cursor
	mw->setMessage(i18n("Ready"));
}


void
Album::unLoad ()
{
	if(mw->preview())
		imageList->stopLoading();
	
	mw->slotRemoveImage(list.count());
	for (ImageFileIconItem *item = list.first(); item; item = list.next() )
		imageList->takeItem(item);
	list.clear();

	iv->updateStatus();
	imageList->slotUpdate();
	if(mw->preview())
		imageList->slotLoadFirst();
}


void
Album::removeImage (AlbumImageFileIconItem *imf)
{
	list.remove(list.find(imf));
	imageList->takeItem(imf);
	mw->slotRemoveImage(1);

	size = QString("%1").arg(size.toInt()-1);
	repaint();
}

void
Album::updateChildren()
{
	kdDebug() << __FILE__ << __LINE__ << " begin  updateChildren() de "<< fullName() << endl;
	full = parent()->fullName()+f.name();
	kdDebug() << __FILE__ << __LINE__ << " end  updateChildren() de "<< fullName() << endl;
}

ListItem*
Album::find (const char *)
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::find (const char *)" << endl;
	return NULL;
}

void
Album::goTo (const char *)
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::goTo (const char *)" << endl;
}


void
Album::removeImage ( ListItem* )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::removeImage ( ListItem* )" << endl;
}


void
Album::create(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::create(QString )" << endl;
}

void
Album::rename(QString newDirName)
{
	kdDebug() << __FILE__ << __LINE__ << " begin Album::rename(QString newDirName=)" << newDirName << endl;
	KonqOperations::rename(mw, getURL(), newDirName);
	f.setName(newDirName);
	updateChildren();
	
	repaint();
	kdDebug() << __FILE__ << __LINE__ << " end Album::rename(QString newDirName) fullName()=" << fullName() << endl;
}

void
Album::rename()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::rename()" << endl;
}

void
Album::properties()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::properties()" << endl;
}

bool
Album::add(QStringList )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO Album::add(QStringList )" << endl;
	return false;
}

