/***************************************************************************
                          albumimagefileiconitem.cpp  -  description
                             -------------------
    begin                : Sun Jan 6 2002
    copyright            : (C) 2002 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "albumimagefileiconitem.h"

#include "imagelistview.h"
#include "album.h"
#include "imageviewer.h"
#include "directory.h"
#include "imagefileinfo.h"
#include "exif.h"

#include <klocale.h>

AlbumImageFileIconItem::AlbumImageFileIconItem(ImageListView *imageList, Album *album,
	 						 QString fullname, ImageViewer *iv)
	:ImageFileIconItem(imageList, NULL,
		QFileInfo(fullname).fileName(), QFileInfo(fullname).dirPath(true)+'/', iv)
{
	setType("filealbum");
	this->album=album;
	__isimage__=true;
	__ismovable__=false;

}

AlbumImageFileIconItem::~AlbumImageFileIconItem()
{
}

QString
AlbumImageFileIconItem::toolTipStr() const
{
	QString tip;
	ImageFileInfo iminfo(full, IMAGE, true);
	tip = "<table><tr><td>"
		+i18n("<b>name</b>: %1<br><b>album</b>: %2<br><b>location</b>: %3<br>%4%5")
			.arg(f.name())
			.arg(album->name())
			.arg(shrink(QFileInfo(full).dirPath(true)))
			.arg(QFileInfo(full).extension().lower()=="jpg"?i18n("<b>dimension</b>: ")+ProcessFile(full.ascii(),true):QString())
			.arg(iminfo.hasInfo()?i18n("<br><b>description</b>: %1").arg(iminfo.getTitle()):QString())
		+"</td></tr></table>";
	tip+=fileInfo()->getToolTipText();

	return tip;
}

void
AlbumImageFileIconItem::removeEntry()
{
	QFile f(album->fullName());
	QString out;
	if ( f.open(IO_ReadOnly) )
	{    // file opened successfully
		QTextStream t( &f );        // use a text stream
		QString s;
		QString rPath=album->pathTo(fullName());
		while ( !t.eof() )
		{        // until end of file...
			s = t.readLine();       // line of text excluding '\n'
			if(s!=rPath)
				out+=s+"\n";
		}
		f.close();
		f.open(IO_WriteOnly);
		QTextStream tw( &f );
		tw << out;
		f.close();
	}
	album->removeImage(this);
}


bool
AlbumImageFileIconItem::suppression()
{
	removeEntry();
	return true;
}

bool
AlbumImageFileIconItem::suppression(bool )
{
	removeEntry();
	return false;
}

bool
AlbumImageFileIconItem::moveToTrash()
{
	removeEntry();
	return true;
}


bool
AlbumImageFileIconItem::shred()
{
	removeEntry();
	return true;
}
