/***************************************************************************
                           kstartuplogo.cpp  -  description
                             -------------------
    artwork              : KDevelop Project / Ralf Nolden <nolden@kde.org>
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstartuplogo.h"

#include <kapplication.h>
#include <kstandarddirs.h>

KStartupLogo::KStartupLogo(QWidget * parent, const char *name) : QWidget(parent,name, WStyle_NoBorder | WStyle_Customize | WDestructiveClose ), m_bReadyToHide( false ){
	QPixmap pm;
	pm.load(locate("appdata", "pics/logo.png"));
	setBackgroundPixmap(pm);
	setGeometry(KApplication::desktop()->width()/2-pm.width()/2, KApplication::desktop()->height()/2-pm.height()/2, pm.width(),pm.height());
}

KStartupLogo::~KStartupLogo()
{
}

void KStartupLogo::mousePressEvent( QMouseEvent*)
{
	if (m_bReadyToHide) hide();
}

#include "kstartuplogo.moc"
