/***************************************************************************
                          listitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "listitem.h"

#include "directoryview.h"
#include "imageviewer.h"
#include "imagelistview.h"
#include "mainwindow.h"

#include <klistview.h>
#include <kapplication.h>

#include <qstring.h>
#include <qfile.h>
#include <qptrlist.h>

ListItem::ListItem(DirectoryView *parent, ImageViewer *iv, ImageListView *imageList, MainWindow *mw)
	:KListViewItem(parent),
	f("/")
{
	this->dirView = parent;
	this->iv = iv;
	this->imageList = imageList;
	this->mw  = mw;
	setDropEnabled(false);
}

ListItem::ListItem(ListItem *parent, QString filename, DirectoryView *dirView, ImageViewer *iv,  ImageListView *imageList, MainWindow *mw)
	:KListViewItem(parent),
	f(filename)
{
	this->dirView = dirView;
	this->iv = iv;
	this->imageList = imageList;
	this->mw  = mw;
	setDropEnabled(false);
}

ListItem::~ListItem()
{
}

QString
ListItem::key (int column, bool ascending) const
{
	if(column!=1)
		return KListViewItem::key(column, ascending).lower();
	else
		return  QString("YY")+text(1);
}

int 
ListItem::compare (QListViewItem * i, int col, bool ascending ) const
{
	if(col==2)
		return text(2).toInt() - i->text(2).toInt();		
	else
		return KListViewItem::compare(i,col,ascending);
}

QString
ListItem::fullName()
{
	return full;
}

void
ListItem::setSelected (bool select)
{
	QListViewItem::setSelected(select);
	if(!dirView->isDropping())
	{
		//repaint();
		kapp->processEvents();
		if(select)
		{
			mw->changeDirectory(fullName());
			load(true);
			dirView->startWatchDir(fullName());
		}
		else
		{
			dirView->stopWatchDir(fullName());
			unLoad();
		}
	}		
}

void 
ListItem::updateChildren()
{
	kdDebug() << __FILE__ << __LINE__ << " begin  updateChildren() de "<< fullName() << endl;

	full = parent()->fullName()+f.name()+"/";	
        ListItem *myChild = firstChild();
        while( myChild ) 
	{
            myChild->updateChildren();
            myChild = myChild->nextSibling();
        }

	kdDebug() << __FILE__ << __LINE__ << " end  updateChildren() de "<< fullName() << endl;
}

QString
ListItem::text (int column) const
{
	if (column == 0)
	{
		return f.name();
	}
	else
	if (column == 1)
		return (extension);
	else
		return (size);
}

QString 
ListItem::name ()
{
	return f.name();
}

QString 
ListItem::path ()
{
	return QFileInfo(fullName()).dir().absPath();
}

ListItem* 
ListItem::firstChild()
{
	return (ListItem*)KListViewItem::firstChild();
}

ListItem* 
ListItem::nextSibling()
{
	return (ListItem*)KListViewItem::nextSibling();
}

ListItem* 
ListItem::parent()
{
	return (ListItem*)KListViewItem::parent();
}

bool 
ListItem::refresh(bool )
{
	unLoad();
	load();
	
	return true;
}
 
 
KURL 
ListItem::getURL()
{
	return KURL("file:/"+fullName());
}


void 
ListItem::load (bool )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::load (bool )" << endl;
}

void 
ListItem::unLoad()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::unLoad()" << endl;
}

void 
ListItem::create(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::create(QString )" << endl;
}

void 
ListItem::rename(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::rename(QString )" << endl;
}

void 
ListItem::rename()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::rename()" << endl;
}

void 
ListItem::properties()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::properties()" << endl;
}

void 
ListItem::goTo (QString)
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::goTo (QString)" << endl;
}

ListItem* 
ListItem::find (QString)
{
	kdWarning() << __FILE__ << __LINE__ << " TODO ListItem* ListItem::find (QString)" << endl;
	return NULL;
}

void 
ListItem::removeImage ( ListItem* )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO void ListItem::removeImage ( ListItem* )" << endl;
}

bool 
ListItem::add(QStringList )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO bool ListItem::add(QStringList )" << endl;
	return false;
}

bool 
ListItem::acceptDrop()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO bool ListItem::acceptDrop()" << endl;
	return false;
}

