/***************************************************************************
                          mainwindow.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "history_action.h"

#include <kdockwindow.h>
#include <kbookmarkmanager.h>
#include <kdockwidget.h>

class Directory;
class DirectoryView;
class ImageListView;
class DirectoryView;
class ImageViewer;
class HistoryAction;
class ListItem;
class ImageSimilarityData;
class RenameSeries;

#ifdef HAVE_LIBDIGIKAM
class DigikamPluginManager;
namespace Digikam
{
class AlbumManager;
}
#endif

class QKeyEvent;
class QFile;
class QSize;
class QDate;
class QDateTime;
class QStringList;
class QString;
class QCloseEvent;
class QImage;
class QListViewItem;
class QProgressDialog;
class QProgressBar;

class KDockMainWindow;
class KBookmarkOwner;
class KProcess;
class KDockWidget;
class KAction;
class KToggleAction;
class KRadioAction;
class KAccel;
class KActionMenu;
class KBookmarkMenu;
class KScanDialog;
class KProgress;
class KActionCollection;
class KURLCompletion;
class KHistoryCombo;



class MainWindow:public KDockMainWindow, public KBookmarkOwner
{
	Q_OBJECT
public:
	MainWindow (QString name="MainWindow");
	MainWindow (QString pic, QString);

	~MainWindow();

	/**
		@return true if the 2 files are the sames
	*/
	bool equals(QFile*, QFile*);

	/**
		launch the exact comparison
	*/	
	void compareFast();
	
	/**
		launch the approximative comparison
	*/
	void compareAlmost();

	DirectoryView* getDirectoryView();
	ListItem* findDir(QString);
	void nextDir (Directory * r);

	/**
		open a directory given its fullname
	*/
	bool openDir (QString);

	/**
		diplay the txt in the status bar
	*/
	void setMessage (QString txt);
	
	/**
		set the number of item in the file view in the statusbar
	*/
	void setNbrItems (int nbr);
	
	/**
		set the zoom of displayed image in the statusbar
	*/	
	void setZoom (int zoom);
	
	/**
		set the Imagename of displayed image in the statusbar
	*/	
	void setImagename (QString name);
	
	/**
		set the Imagetype of displayed image in the statusbar
	*/
	void setImagetype (QString type);

	/**
		set the Imagetype of displayed image in the statusbar
	*/
	void setImageIndex (int index);
	
	/**
		set the Dimension of displayed image in the statusbar
	*/	
	void setDim (QSize *size);
	
	/**
		set the Size  of displayed image in the statusbar
	*/	
	void setSize (int size);
	
	/**
		set the Date  of displayed image in the statusbar
	*/	
	void setDate (QDateTime *date);
	
	/**
	*/
	void setActionsEnabled(bool enable);  
	
	/**
		set the imageViewer to an empty image
	*/
	void setEmptyImage();

	/**
		@return true if icons preview is enabled
	*/
	bool preview();	
	void setOnTop(bool onTop);

	//
	/**
	 * This function is called if the user selects a bookmark.  It will
	 * open up the bookmark in a default fashion unless you override it.
	 */
	virtual void openBookmarkURL(const QString& _url);

	/**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The title will become the
	 * "name" of the bookmark.  You must overload this function if you
	 * wish to give your users the ability to add bookmarks.
	 *
	 * @return the title of the current page.
	 */
	virtual QString currentTitle() const;

	 /**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The URL will become the URL
	 * of the bookmark.  You must overload this function if you wish to
	 * give your users the ability to add bookmarks.
	 *
	 * @return the URL of the current page.
	 */
	virtual QString currentURL() const;

	/**
	* add the url in the groupText group of the bookmark
	*/
	void addToBookmark(QString groupText, QString url);

	//
	/**
		@return true if in fullscreen mode
	*/
	bool fullScreen();
	
	/**
		copy uris to the specified directory
	*/
	void copyFilesTo(QStringList uris, QString dest);
	
	/**
		move uris to the specified directory
	*/
	void moveFilesTo(QStringList uris, QString dest);

	void startWatchDir();
	void stopWatchDir();
	
	KProgress *progress;
	int total;
	int done;
	
	ImageViewer *iv;
	ImageListView *imageList;
	DirectoryView *dirView;


public slots:
	void clearCache();
	void updateCache();

	void setHasImageSelected(bool selected);

	void slotFullScreen (); //switch to full screen and windows mode
	void slotSlideShow ();  //launch the slide show
	void slotPreview ();	  //show/hide thes thumbertails
	void slotRefresh ();	 //refresh the image list
	void slotRefresh (QString dir);	//refresh a specifique dir
	void slotKeepFit();	   // fit/unfit to screen
	void slotfitWidth();	   
	void slotfitHeight();	   
	void slotEnlarge ();
	void slotShrink ();
	void slotSmooth ();    //smooth/unsmooth
	void slotCompareFast (){compareFast();}; //compare the pictures loaded
	void slotCompareAlmost (){compareAlmost();}; //compare the pictures loaded

	void myDialogSlot();  
	void convert();  

	void slotNewWindow();
	void slotPrint();
	void slotQuickPrint();
	void slotUndo();
	void slotRedo();
	void slotMovetotrash();
	void slotShred();    

	void slotOpenLocation();
	void slotSaveImage();


	void slotTODO ();
	void slotcopy ();
	void slotcopyPixmap ();
	void slotcut ();
	void slotpaste ();
	void slotRotateLeft();
	void slotRotateRight();
	void slotStop();
	void slotZoomIn();
	void slotZoomOut() ;
	void slotZoom();
	void slotZoomNo();
	void slotZoomLock();
	void configureKey();
	void configureToolbars();
	void configureShowImg();
	void slotBookmark();

	void slotForward();
	void slotBack();
	void goHome();
	void goUp();

	void slotAddImage (int number=1);
	void slotRemoveImage();
	void slotPreviewDone ();
	void slotReset (bool init=true);
	void slotDone ();
	void slotRemoveImage (int val);
	void slotMirrorH ();
	void slotMirrorV ();
	void slotDirChange (const QString & dir);
	void slotFileChange (const QString &);
	void slotPreferences();
	void slotEditFileType();
	void renameSeries();

	void slotArrangement();
	void slotTxtPos();
	
	void slotIconSize(bool refresh=false);

	void changeDirectory(QString);
	void changeDirectory();

	void backMenuActivated(int);
	void forwardMenuActivated(int);
	void slotForwardAboutToShow();
	void slotBackAboutToShow();

	void quit();
	bool closeAppl();

	void slotDirCut();
	void slotDirCopy();
	void slotDirMove();
	void slotDirPaste();

	void toolsRotateLeft();
	void toolsRotateRight();

	void slotSetFilter();
	
	void slotScanImage();
	void slotScanned( const QImage&, int );

	void slotDisplayNBImg();

private slots:
	void slotEndConvert(KProcess *);
	void escapePressed();
	void spacePressed();
	
	
protected:
	KActionCollection *m_actions;
	void setupActions();
	void setupStatusBar();

	bool inFullScreen;
	QProgressDialog *pdCache;

	void init ();

	void closeEvent( QCloseEvent* );

	void clearCache(QString fromDir);
	void updateCache(QString fromDir);

	QString getFileName(QString *fullName);
	QString getFileExt(QString *fullName);
	QString getFullName(QString *fullName);
	QString getFullPath(QString *fullName);  

	inline char getRed(QImage *im, int x, int y);
	inline char getGreen(QImage *im, int x, int y);
	inline char getBlue(QImage *im, int x, int y);

	ImageSimilarityData* image_sim_fill_data(QString filename);
	float image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b);
	float image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, float min);

	void updateHistory();
	void go( int steps );
	
	QString currentDir() const;
	void setCurrentDir(QString dir);

	QLabel *label;

	QPopupMenu *file;
	QPopupMenu *options;

	KDockWidget *dockIV;
	KDockWidget *dockDir;
	KDockWidget *dockIL;

	Directory *root;


	QSize oldSize;
	QPoint oldPos;

	QTimer *timer;

	KToolBar *mainToolbar, *pathToolbar;
	KScanDialog *m_scanDialog;
	RenameSeries *m_renameS;


private:
	KConfig *config;
	
	QColor bgColor;
	bool checkDelete, checkShred, checkTrash;
	int grayscale, slideshowTime, slideshowType, openDirType;
	bool storeth, showFrame;
	bool smooth;
	QString openDirname;
	bool showSP, useEXIF;
	bool showToolbar, showStatusbar;

	bool hasimageselected;
	QString currentDir_;
	QString lastDestDir;
	QLabel *lnbrItems, *lZoom, *lImagename, *lImagetype, *lDim, *lSize, *lDate;

	int fit; //index of 'fit' to screen menu
	int ss;  //index of 'smooth' menu
	bool inInterface;

	int nbrItems; //number of item
	int imageIndex; //current item index

	void createActions();  
	void createAccels();
	void createMenus();
	void createToolbar();
	void createStatusbar();
	void createMainView();
	void initSize();
	void setLayout(int layout);

	
	KActionCollection *actionCollect;

	KAction *aCut, *aCopy, *aPaste, *aDelete, *aCopyPixmap,
	      *aNewWindow,
	      *aPrint, *aQuickPrint,
	      *aOpenLocation, *aSaveImage,
	      *aQuit,*aClose,
	      *aUndo,*aRedo,
	      *aRename,*aTrash,*aShred,
	      *aEditType,*aFileProperties,*aImageProperties,
	      *aImageInfo, *aDirInfo,
	      *aSelect,*aUnselect,*aUnselectAll,*aInvertSelection,
	      *aPrevious,*aNext,*aFirst,*aLast,
	      *aConfigureKey,*aConfigureToolbars,*aConfigureShowImg,
	      *aRenameSeries,
	      *aCompareFast,*aCompareAlmost,*aCovert,
	      *aRotLeft,*aRotRight,*aHMirror,*aVMirror,
	      *aReloadDir,*aStop,
	      *aZoomIn,*aZoomOut,*aZoomNo,*aZoomFit,
	      *aOpenWithGimp, *aOpenWithKhexedit, *aOpenWith,
	      *aWallpaper_CENTER,*aWallpaper_MOSAIC,*aWallpaper_CENTER_MOSAIC,*aWallpaper_CENTER_MAX,*aWallpaper_ADAPT,*aWallpaper_LOGO,

	      *aDirNewFolder, *aDirProperties,
	      *aDirNewAlbum,
	      *aDirCut, *aDirCopy, *aDirPaste, *aDirMove, *aDirPasteFiles, *aDirRecOpen,
	      *aDirRename, *aDirTrash, *aDirDelete,
	      *aDirBookmark,
	      *aFilesMoveTo, *aFilesCopyTo,
	
	      *aScrollXR, *aScrollXL, *aScrollYB, *aScrollYT,
	      
	      *aToolsRotateLeft, *aToolsRotateRight,

	      *aGoHome, *aGoUp, *aGo,

	      *aClearCache, *aUpdateCache,
	      
	      *aScan,

	      *aTime;

	HistoryAction *aBack, *aForward;
	HistoryEntryList m_lstHistory;
	KHistoryCombo *m_URLHistory;
	KURLCompletion *m_URLHistoryCompletion;

	KToggleAction *aSlideshow,
	      *aSmooth,
	      *aPreview,
	      *aEnlarge, *aShrink,
	      *aZoomLock, *aZoomFitWidth, *aZoomFitHeight,
	      *aFullScreen,

	      *aEffect_NORMALIZE,*aEffect_EQUALIZE,*aEffect_INTENSITY, *aEffect_INVERT, *aEffect_GRAYSCALE,
	      *aEffect_EMBOSS,*aEffect_SWIRL,*aEffect_SPREAD,*aEffect_IMPLODE,*aEffect_CHARCOAL,
	      *aEffect_NONE;


	KRadioAction
	      *aIconSmall, *aIconMed, *aIconBig,
	      *aArrangementLR, *aArrangementTB,
	      *aArrangementB, *aArrangementR,
	      *aSortBySize,*aSortByType,*aSortByName, *aSortByDate;

	KAccel* mAccel;
	KActionMenu* abookmarkmenu;

	KBookmarkMenu *mBookMenu;
#ifdef HAVE_LIBDIGIKAM
	DigikamPluginManager *pluginManager_;
	Digikam::AlbumManager *mAlbumManager;
#endif

};

#endif
