/***************************************************************************
                         replace.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "replace.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qfileinfo.h>

#include <kapplication.h>
#include <klocale.h>

/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 *  Constructs a ConfirmReplace which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConfirmReplace::ConfirmReplace( QWidget* parent,  QString name, QString org, QString dest )
    : KDialog( parent, name.ascii(), true )
{
	this->org = new QString(org);
	this->dest = new QString(dest);

	if ( !name )
	    setName( "ConfirmReplace" );
	resize( 630, 440 );
	setMaximumSize( QSize( 630, 440 ) );
	setMinimumSize( QSize( 630, 440 ) );
	setCaption(i18n( "Confirm replace" ) );

	GroupBox1_2 = new QGroupBox( this, "GroupBox1_2" );
	GroupBox1_2->setGeometry( QRect( 340, 10, 280, 330 ) );
	GroupBox1_2->setTitle(i18n( "With file:" ) );
	GroupBox1_2->setMinimumSize( QSize( 280, 320 ) );

	fileDest = new QLabel( GroupBox1_2, "fileDest" );
	fileDest->setGeometry( QRect( 10, 20, 260, 21 ) );
	fileDest->setText(i18n( "Image location" ) );
	fileDest->setAlignment( int( QLabel::AlignCenter ) );

	tailleDest = new QLabel( GroupBox1_2, "tailleDest" );
	tailleDest->setGeometry( QRect( 11, 40, 260, 21 ) );
	tailleDest->setText(i18n( "Set size and date of image" ) );
	tailleDest->setAlignment( int( QLabel::AlignCenter ) );
	tailleDest->setFrameShadow( QLabel::Sunken );
	tailleDest->setFrameShape( QLabel::StyledPanel );

	previewDest = new QLabel( GroupBox1_2, "previewDest" );
	previewDest->setGeometry( QRect( 10, 70, 261, 220 ) );
	previewDest->setScaledContents( TRUE );
	previewDest->setText(i18n( "Preview" ) );
	previewDest->setFrameShape( QLabel::StyledPanel );
	previewDest->setFrameShadow( QLabel::Sunken );
	previewDest->setAlignment( int( QLabel::AlignCenter ) );

	dimDest = new QLabel( GroupBox1_2, "dimDest" );
	dimDest->setGeometry( QRect( 10, 300, 251, 21 ) );
	dimDest->setAlignment( int( QLabel::AlignCenter ) );

	ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
	ButtonGroup1->setGeometry( QRect( 10, 350, 120, 80 ) );
	ButtonGroup1->setTitle("");
	ButtonGroup1->setFrameShape( QButtonGroup::NoFrame );

	NoImageRadioButton = new QRadioButton( ButtonGroup1, "NoImageRadioButton" );
	NoImageRadioButton->setGeometry( QRect( 0, 10, 101, 20 ) );
	NoImageRadioButton->setText(i18n( "N&o images" ) );

	showThumbnailsRadioButton2 = new QRadioButton( ButtonGroup1, "showThumbnailsRadioButton2" );
	showThumbnailsRadioButton2->setGeometry( QRect( 0, 30, 120, 21 ) );
	showThumbnailsRadioButton2->setText(i18n( "Show &thumbnails" ) );
	showThumbnailsRadioButton2->setChecked( TRUE );

	showFullImagesRadioButton3 = new QRadioButton( ButtonGroup1, "showFullImagesRadioButton3" );
	showFullImagesRadioButton3->setGeometry( QRect( 0, 50, 120, 21 ) );
	showFullImagesRadioButton3->setText(i18n( "Show full &images" ) );

	ButtonGroup1->setEnabled(false);

	GroupBox1 = new QGroupBox( this, "GroupBox1" );
	GroupBox1->setGeometry( QRect( 10, 10, 280, 330 ) );
	GroupBox1->setTitle(i18n( "Replace Files:" ) );
	GroupBox1->setMinimumSize( QSize( 280, 320 ) );

	previewOrig = new QLabel( GroupBox1, "previewOrig" );
	previewOrig->setGeometry( QRect( 10, 70, 261, 220 ) );
	previewOrig->setScaledContents( TRUE );
	previewOrig->setText(i18n( "Preview" ) );
	previewOrig->setFrameShape( QLabel::StyledPanel );
	previewOrig->setFrameShadow( QLabel::Sunken );
	previewOrig->setAlignment( int( QLabel::AlignCenter ) );

	dimOrig = new QLabel( GroupBox1, "dimOrig" );
	dimOrig->setGeometry( QRect( 10, 300, 251, 21 ) );
	dimOrig->setAlignment( int( QLabel::AlignCenter ) );

	fileOrig = new QLabel( GroupBox1, "fileOrig" );
	fileOrig->setGeometry( QRect( 10, 20, 260, 21 ) );
	fileOrig->setText(i18n( "Image location" ) );
	fileOrig->setAlignment( int( QLabel::AlignCenter ) );

	tailleOrig = new QLabel( GroupBox1, "tailleOrig" );
	tailleOrig->setGeometry( QRect( 10, 40, 260, 21 ) );
	tailleOrig->setText(i18n( "Set size and date of image" ) );
	tailleOrig->setAlignment( int( QLabel::AlignCenter ) );
	tailleOrig->setFrameShadow( QLabel::Sunken );
	tailleOrig->setFrameShape( QLabel::StyledPanel );

	skipButton = new QPushButton( this, "skipButton" );
	skipButton->setGeometry( QRect( 320, 350, 71, 31 ) );
	skipButton->setText(i18n( "&Skip" ) );
	connect(skipButton, SIGNAL(clicked()), this, SLOT(slotSkip()));

	cancelButton = new QPushButton( this, "cancelButton" );
	cancelButton->setGeometry( QRect( 320, 390, 71, 31 ) );
	cancelButton->setText(i18n( "&Cancel" ) );
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(slotCancel()));

	GroupBox4 = new QGroupBox( this, "GroupBox4" );
	GroupBox4->setGeometry( QRect( 400, 350, 221, 71 ) );
	GroupBox4->setTitle(i18n( "Rename file" ) );

	TextLabel4 = new QLabel( GroupBox4, "TextLabel4" );
	TextLabel4->setGeometry( QRect( 10, 50, 111, 16 ) );
	TextLabel4->setText(i18n( "New file name" ) );
	TextLabel4->setAlignment( int( QLabel::AlignCenter ) );

	renamePushButton = new QPushButton( GroupBox4, "renamePushButton" );
	renamePushButton->setGeometry( QRect( 130, 30, 80, 31 ) );
	renamePushButton->setText(i18n( "Re&name" ) );
	connect(renamePushButton, SIGNAL(clicked()), this, SLOT(slotRename()));

	renameLineEdit = new QLineEdit( GroupBox4, "renameLineEdit" );
	renameLineEdit->setGeometry( QRect( 10, 20, 111, 22 ) );
	renameLineEdit->setText(  "Nouveau Nom"  );
	renameLineEdit->setCursor( QCursor( IbeamCursor ));
	connect(renameLineEdit, SIGNAL( returnPressed ()), this, SLOT(slotRename()));

	replaceAllButton = new QPushButton( this, "replaceAllButton" );
	replaceAllButton->setGeometry( QRect( 240, 390, 71, 31 ) );
	replaceAllButton->setText(i18n( "Replace &All" ) );
	connect(replaceAllButton, SIGNAL(clicked()), this, SLOT(slotReplaceAll()));

	replaceButton = new QPushButton( this, "replaceButton" );
	replaceButton->setGeometry( QRect( 240, 350, 71, 31 ) );
	replaceButton->setText(i18n( "&Replace" ) );
	connect(replaceButton, SIGNAL(clicked()), this, SLOT(slotReplace()));

	init();
}

/*
 *  Destroys the object and frees any allocated resources
 */
ConfirmReplace::~ConfirmReplace()
{
	// no need to delete child widgets, Qt does it all for us
}




void ConfirmReplace::init()
{
	KApplication::setOverrideCursor( waitCursor ); // this might take time

	fileOrig->setText(*org);
	fileDest->setText(*dest);

	tailleOrig->setText(QString().setNum((float)QFileInfo(*org).size()/1024)  + " Ko,  " + QFileInfo(*org).lastModified().toString() );
	tailleDest->setText(QString().setNum((float)QFileInfo(*dest).size()/1024) + " Ko,  " +  QFileInfo(*dest).lastModified().toString() );

	renameLineEdit->setText(*dest);

	QImage im = QImage(*org);
	im = im.smoothScale(previewOrig->width(), previewOrig->height());
	QPixmap pix;
	pix.convertFromImage(im);
	previewOrig->setPixmap(pix);

	im = QImage(*dest);
	im = im.smoothScale(previewDest->width(), previewDest->height());
	pix.convertFromImage(im);
	previewDest->setPixmap(pix);

	KApplication::restoreOverrideCursor();        // restore original cursor
}

QString
ConfirmReplace::getRename()
{
        return renameLineEdit->text();
}

void
ConfirmReplace::slotSkip()
{
        done(2);
}
void ConfirmReplace::slotCancel()
{
        done(4);
}
void ConfirmReplace::slotRename()
{
        done(5);
}
void ConfirmReplace::slotReplaceAll()
{
        done(3);
}

void ConfirmReplace::slotReplace()
{
        done(1);
}

#include "replace.moc"
