/***************************************************************************
                          zipfile.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "zipfile.h"

#include <stdlib.h>

#include <kdebug.h>

ZipFile::ZipFile (QString archive, QString file)
{
	this->archive =archive;
	this->file = file;

	mystdout = new QCString ();
}
  
ZipFile::~ZipFile()
{
	delete(mystdout);
}

int
ZipFile::size ()
{

	QString com= QString(" unzip -Z  \"%1\" \"%2\" | tr -s \" \" \" \" | cut -d\" \" -f 4")
	   		.arg(archive)
			.arg(file);

	KShellProcess * proc = new KShellProcess ();
	connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	         SLOT (slotMsgRcv (KProcess *, char *, int)));

	*proc << com;
	proc->start (KShellProcess::Block, KShellProcess::Stdout);

	return mystdout->toInt ();
}


bool
ZipFile::deleteFile ()
{
	kdDebug() << __FILE__ << __LINE__ << " ZipFile::deleteFile ()" << endl;
	QString com=QString(" zip -d  \"%1\" \"%2\"")
			.arg(archive)
			.arg(file);
	KShellProcess * proc = new KShellProcess ();
	connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	         SLOT (slotMsgRcv (KProcess *, char *, int)));

	kdDebug() << __FILE__ << __LINE__ << " \tZipFile::deleteFile ()\n\tcom=" << com <<endl;
	*proc << com;
	proc->start (KShellProcess::Block);   

	kdDebug() << __FILE__ << __LINE__ << " ZipFile::deleteFile ()" << endl;
	return true;
}

void
ZipFile::slotMsgRcv (KProcess * , char *buffer, int buflen)
{
	mystdout = new QCString (buffer, buflen);
	kdDebug() << __FILE__ << __LINE__ << " ZipFile::slotMsgRcv (KProcess * , char *buffer, int buflen)\n\t mystdout = " << mystdout << endl;
}

#include "zipfile.moc"
