/* $Id: elf.h,v 1.4 2003/05/30 00:42:38 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ELF_H
#define ELF_H

#include "port.h"

/* Elf types */
typedef uint8_t  Elf_Byte;

typedef uint16_t Elf32_Half;
typedef uint32_t Elf32_Word;
typedef  int32_t Elf32_Sword;
typedef uint32_t Elf32_Off;
typedef uint32_t Elf32_Addr;

typedef uint16_t Elf64_Quarter;
typedef uint32_t Elf64_Half;
typedef  int32_t Elf64_Shalf;
typedef uint64_t Elf64_Word;
typedef  int64_t Elf64_Sword;
typedef uint64_t Elf64_Addr;
typedef uint64_t Elf64_Off;


/* ELF Header */
#define EI_NIDENT    16

/* Quick rant: Why, oh why, do these all have to start with e_?  Isn't
   it enough to see they're elements of an Ehdr struct?  Maybe there's
   a worldwide conspiracy to increase the number of 'e's in existance. 
   The truth is out there, and I'm REALLY tired right now  - JDC */

typedef struct {
	Elf_Byte       e_ident[EI_NIDENT] ;   /* ID.  Elf0x7f+              */
	Elf32_Half     e_type             ;   /* File type                  */
	Elf32_Half     e_machine          ;   /* Machine type               */
	Elf32_Word     e_version          ;   /* Version (Duh!)             */
	Elf32_Addr     e_entry            ;   /* Execution entry point      */
	Elf32_Off      e_phoff            ;   /* Program header offset      */
	Elf32_Off      e_shoff            ;   /* Section header offset      */
	Elf32_Word     e_flags            ;   /* Processor flags            */
	Elf32_Half     e_ehsize           ;   /* Ehder size                 */
	Elf32_Half     e_phentsize        ;   /* Prog header entry size     */
	Elf32_Half     e_phnum            ;   /* Prog header count          */
	Elf32_Half     e_shentsize        ;   /* Section header entry size  */
	Elf32_Half     e_shnum            ;   /* Number of section headers  */
	Elf32_Half     e_shstrndx         ;   /* String table index         */
} Elf32_Ehdr;


typedef struct {
	Elf_Byte       e_ident[EI_NIDENT] ;   /* ID.  Elf0x7f+              */
	Elf64_Quarter  e_type             ;   /* File type                  */
	Elf64_Quarter  e_machine          ;   /* Machine type               */
	Elf64_Half     e_version          ;   /* Version (Duh!)             */
	Elf64_Addr     e_entry            ;   /* Execution entry point      */
	Elf64_Off      e_phoff            ;   /* Program header offset      */
	Elf64_Off      e_shoff            ;   /* Section header offset      */
	Elf64_Half     e_flags            ;   /* Processor flags            */
	Elf64_Quarter  e_ehsize           ;   /* Ehder size                 */
	Elf64_Quarter  e_phentsize        ;   /* Prog header entry size     */
	Elf64_Quarter  e_phnum            ;   /* Prog header count          */
	Elf64_Quarter  e_shentsize        ;   /* Section header entry size  */
	Elf64_Quarter  e_shnum            ;   /* Number of section headers  */
	Elf64_Quarter  e_shstrndx         ;   /* String table index         */
} Elf64_Ehdr;


/* e_ident offsets */
#define EI_MAG0            0                  /* File identification        */
#define EI_MAG1            1                  /* File identification        */
#define EI_MAG2            2                  /* File identification        */
#define EI_MAG3            3                  /* File identification        */
#define EI_CLASS           4                  /* Class (Duh!)               */
#define EI_DATA            5                  /* Encoding                   */
#define EI_VERSION         6                  /* Version                    */
#define EI_PAD             7                  /* Start of padding           */

/* e_ident magic cookie */
#define ELFMAG0         0x7f
#define ELFMAG1          'E'
#define ELFMAG2          'L'
#define ELFMAG3          'F'
#define ELFMAG     "\177ELF"

/* e_ident[EI_CLASS] values */
#define ELFCLASSNONE       0
#define ELFCLASS32         1
#define ELFCLASS64         2                  

/* e_ident[EI_DATA] values */
#define ELFDATANONE        0                  /* straight out!              */
#define ELFDATA2LSB        1                  /* little-endian              */
#define ELFDATA2MSB        2                  /* big-endian                 */

/* e_type values */
#define ET_NONE            0                  /* Go away!                   */
#define ET_REL             1                  /* Relocatable                */
#define ET_EXEC            2                  /* Executable                 */
#define ET_DYN             3                  /* Shared object              */
#define ET_CORE            4                  /* Core (Not Arm)             */
#define ET_LOPROC     0xff00                  /* Processor specific         */
#define ET_HIPROC     0xffff                  /* Processor specific         */


typedef struct {
	Elf32_Word     p_type             ;   /* Segment type               */
	Elf32_Off      p_offset           ;   /* Offset to segment data     */
	Elf32_Addr     p_vaddr            ;   /* Virt addr of segment       */
	Elf32_Addr     p_paddr            ;   /* Ignored segment phys addr  */
	Elf32_Word     p_filesz           ;   /* Segment file image size    */
	Elf32_Word     p_memsz            ;   /* Segment memory image size  */
	Elf32_Word     p_flags            ;   /* Flags for segment          */
	Elf32_Word     p_align            ;   /* Segment alignment enforced */
} Elf32_Phdr;

typedef struct {
	Elf64_Half     p_type             ;   /* Segment type               */
	Elf64_Half     p_flags            ;   /* Flags for segment          */
	Elf64_Off      p_offset           ;   /* Offset to segment data     */
	Elf64_Addr     p_vaddr            ;   /* Virt addr of segment       */
	Elf64_Addr     p_paddr            ;   /* Ignored segment phys addr  */
	Elf64_Word     p_filesz           ;   /* Segment file image size    */
	Elf64_Word     p_memsz            ;   /* Segment memory image size  */
	Elf64_Word     p_align            ;   /* Segment alignment enforced */
} Elf64_Phdr;

/* p_type values */
#define PT_NULL            0                  /* Ignore                     */
#define PT_LOAD            1                  /* Loadable segment           */
#define PT_DYNAMIC         2                  /* Dynamic linking info       */
#define PT_INTERP          3                  /* Program interpreter        */
#define PT_NOTE            4                  /* Auxilliary info location   */
#define PT_SHLIB           5                  /* Reserved                   */
#define PT_PHDR            6                  /* Location of phdr table (?) */
#define PT_LOPROC 0x70000000                  /* Proc specific range low    */
#define PT_HIPROV 0x7fffffff                  /* Proc specific range high   */

/* p_flags vaules  (Not related to PFLAG...:) */
#define PHP_X            0x1                  /* Execute                    */
#define PHP_W            0x2                  /* Write                      */
#define PHP_R            0x4                  /* Read                       */

#endif
