#!/bin/bash
# refreshes the public openbsd keys using their CVS server

set -eu

here=$(readlink -f $(dirname $0))
tmp=$(mktemp -d)

cd $tmp
echo "VERIFY THE SERVER FINGERPRINT WITH THE LIST BELOW !!!"
cat <<EOF
(RSA) SHA256:10SgQKcgCw02RSqBZGa8eGUR0ab+YkuhqFENhOoK1L4, MD5:cf:97:03:7b:0a:32:3b:d7:e2:31:05:39:9f:9d:03:dc
(ECDSA) SHA256:hVx+UscX/3uhv2nxPgp2zC/omvDIBSkv6iISCn19yqQ, MD5:28:58:44:09:8e:01:c2:79:33:03:39:7a:e7:6a:bd:a4
(ED25519) SHA256:WDEcVZFXagh0OXHlHVhcct6VjFjFqaNZwAhM3GnVA/c, MD5:3c:a9:4d:1e:4c:55:9d:6d:03:06:26:8f:21:ce:65:a6

EOF
echo "THEN DOUBLE-CHECK WITH https://www.openbsd.org/anoncvs.html !!!"

cvs -qd anoncvs@anoncvs.ca.openbsd.org:/cvs get -P src/etc/signify
cd src/etc/signify/
mv *.pub $here

cd $here

echo "VERIFY THAT ONLY NEW FILES WERE ADDED"
git status
read

sha256sum *.pub > keys.sha256
gpg --detach-sign --armor keys.sha256
